// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: base/v1/base.proto

package basev1

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Context with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Context) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Context with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ContextMultiError, or nil if none found.
func (m *Context) ValidateAll() error {
	return m.validate(true)
}

func (m *Context) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetTuples() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ContextValidationError{
						field:  fmt.Sprintf("Tuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ContextValidationError{
						field:  fmt.Sprintf("Tuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ContextValidationError{
					field:  fmt.Sprintf("Tuples[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetAttributes() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ContextValidationError{
						field:  fmt.Sprintf("Attributes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ContextValidationError{
						field:  fmt.Sprintf("Attributes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ContextValidationError{
					field:  fmt.Sprintf("Attributes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetData()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ContextValidationError{
					field:  "Data",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ContextValidationError{
					field:  "Data",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetData()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ContextValidationError{
				field:  "Data",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ContextMultiError(errors)
	}

	return nil
}

// ContextMultiError is an error wrapping multiple validation errors returned
// by Context.ValidateAll() if the designated constraints aren't met.
type ContextMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ContextMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ContextMultiError) AllErrors() []error { return m }

// ContextValidationError is the validation error returned by Context.Validate
// if the designated constraints aren't met.
type ContextValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ContextValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ContextValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ContextValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ContextValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ContextValidationError) ErrorName() string { return "ContextValidationError" }

// Error satisfies the builtin error interface
func (e ContextValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sContext.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ContextValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ContextValidationError{}

// Validate checks the field values on Child with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Child) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Child with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ChildMultiError, or nil if none found.
func (m *Child) ValidateAll() error {
	return m.validate(true)
}

func (m *Child) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofTypePresent := false
	switch v := m.Type.(type) {
	case *Child_Leaf:
		if v == nil {
			err := ChildValidationError{
				field:  "Type",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTypePresent = true

		if m.GetLeaf() == nil {
			err := ChildValidationError{
				field:  "Leaf",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetLeaf()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ChildValidationError{
						field:  "Leaf",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ChildValidationError{
						field:  "Leaf",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetLeaf()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ChildValidationError{
					field:  "Leaf",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Child_Rewrite:
		if v == nil {
			err := ChildValidationError{
				field:  "Type",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTypePresent = true

		if m.GetRewrite() == nil {
			err := ChildValidationError{
				field:  "Rewrite",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetRewrite()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ChildValidationError{
						field:  "Rewrite",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ChildValidationError{
						field:  "Rewrite",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRewrite()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ChildValidationError{
					field:  "Rewrite",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofTypePresent {
		err := ChildValidationError{
			field:  "Type",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ChildMultiError(errors)
	}

	return nil
}

// ChildMultiError is an error wrapping multiple validation errors returned by
// Child.ValidateAll() if the designated constraints aren't met.
type ChildMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ChildMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ChildMultiError) AllErrors() []error { return m }

// ChildValidationError is the validation error returned by Child.Validate if
// the designated constraints aren't met.
type ChildValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ChildValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ChildValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ChildValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ChildValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ChildValidationError) ErrorName() string { return "ChildValidationError" }

// Error satisfies the builtin error interface
func (e ChildValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sChild.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ChildValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ChildValidationError{}

// Validate checks the field values on Leaf with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *Leaf) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Leaf with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in LeafMultiError, or nil if none found.
func (m *Leaf) ValidateAll() error {
	return m.validate(true)
}

func (m *Leaf) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofTypePresent := false
	switch v := m.Type.(type) {
	case *Leaf_ComputedUserSet:
		if v == nil {
			err := LeafValidationError{
				field:  "Type",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTypePresent = true

		if m.GetComputedUserSet() == nil {
			err := LeafValidationError{
				field:  "ComputedUserSet",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetComputedUserSet()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, LeafValidationError{
						field:  "ComputedUserSet",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, LeafValidationError{
						field:  "ComputedUserSet",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetComputedUserSet()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return LeafValidationError{
					field:  "ComputedUserSet",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Leaf_TupleToUserSet:
		if v == nil {
			err := LeafValidationError{
				field:  "Type",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTypePresent = true

		if m.GetTupleToUserSet() == nil {
			err := LeafValidationError{
				field:  "TupleToUserSet",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTupleToUserSet()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, LeafValidationError{
						field:  "TupleToUserSet",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, LeafValidationError{
						field:  "TupleToUserSet",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTupleToUserSet()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return LeafValidationError{
					field:  "TupleToUserSet",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Leaf_ComputedAttribute:
		if v == nil {
			err := LeafValidationError{
				field:  "Type",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTypePresent = true

		if m.GetComputedAttribute() == nil {
			err := LeafValidationError{
				field:  "ComputedAttribute",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetComputedAttribute()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, LeafValidationError{
						field:  "ComputedAttribute",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, LeafValidationError{
						field:  "ComputedAttribute",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetComputedAttribute()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return LeafValidationError{
					field:  "ComputedAttribute",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Leaf_Call:
		if v == nil {
			err := LeafValidationError{
				field:  "Type",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTypePresent = true

		if m.GetCall() == nil {
			err := LeafValidationError{
				field:  "Call",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetCall()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, LeafValidationError{
						field:  "Call",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, LeafValidationError{
						field:  "Call",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetCall()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return LeafValidationError{
					field:  "Call",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofTypePresent {
		err := LeafValidationError{
			field:  "Type",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return LeafMultiError(errors)
	}

	return nil
}

// LeafMultiError is an error wrapping multiple validation errors returned by
// Leaf.ValidateAll() if the designated constraints aren't met.
type LeafMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LeafMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LeafMultiError) AllErrors() []error { return m }

// LeafValidationError is the validation error returned by Leaf.Validate if the
// designated constraints aren't met.
type LeafValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LeafValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LeafValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LeafValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LeafValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LeafValidationError) ErrorName() string { return "LeafValidationError" }

// Error satisfies the builtin error interface
func (e LeafValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLeaf.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LeafValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LeafValidationError{}

// Validate checks the field values on Rewrite with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Rewrite) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Rewrite with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in RewriteMultiError, or nil if none found.
func (m *Rewrite) ValidateAll() error {
	return m.validate(true)
}

func (m *Rewrite) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for RewriteOperation

	for idx, item := range m.GetChildren() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RewriteValidationError{
						field:  fmt.Sprintf("Children[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RewriteValidationError{
						field:  fmt.Sprintf("Children[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RewriteValidationError{
					field:  fmt.Sprintf("Children[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return RewriteMultiError(errors)
	}

	return nil
}

// RewriteMultiError is an error wrapping multiple validation errors returned
// by Rewrite.ValidateAll() if the designated constraints aren't met.
type RewriteMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RewriteMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RewriteMultiError) AllErrors() []error { return m }

// RewriteValidationError is the validation error returned by Rewrite.Validate
// if the designated constraints aren't met.
type RewriteValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RewriteValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RewriteValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RewriteValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RewriteValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RewriteValidationError) ErrorName() string { return "RewriteValidationError" }

// Error satisfies the builtin error interface
func (e RewriteValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRewrite.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RewriteValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RewriteValidationError{}

// Validate checks the field values on SchemaDefinition with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *SchemaDefinition) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SchemaDefinition with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// SchemaDefinitionMultiError, or nil if none found.
func (m *SchemaDefinition) ValidateAll() error {
	return m.validate(true)
}

func (m *SchemaDefinition) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	{
		sorted_keys := make([]string, len(m.GetEntityDefinitions()))
		i := 0
		for key := range m.GetEntityDefinitions() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetEntityDefinitions()[key]
			_ = val

			// no validation rules for EntityDefinitions[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, SchemaDefinitionValidationError{
							field:  fmt.Sprintf("EntityDefinitions[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, SchemaDefinitionValidationError{
							field:  fmt.Sprintf("EntityDefinitions[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return SchemaDefinitionValidationError{
						field:  fmt.Sprintf("EntityDefinitions[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	{
		sorted_keys := make([]string, len(m.GetRuleDefinitions()))
		i := 0
		for key := range m.GetRuleDefinitions() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetRuleDefinitions()[key]
			_ = val

			// no validation rules for RuleDefinitions[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, SchemaDefinitionValidationError{
							field:  fmt.Sprintf("RuleDefinitions[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, SchemaDefinitionValidationError{
							field:  fmt.Sprintf("RuleDefinitions[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return SchemaDefinitionValidationError{
						field:  fmt.Sprintf("RuleDefinitions[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	// no validation rules for References

	if len(errors) > 0 {
		return SchemaDefinitionMultiError(errors)
	}

	return nil
}

// SchemaDefinitionMultiError is an error wrapping multiple validation errors
// returned by SchemaDefinition.ValidateAll() if the designated constraints
// aren't met.
type SchemaDefinitionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SchemaDefinitionMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SchemaDefinitionMultiError) AllErrors() []error { return m }

// SchemaDefinitionValidationError is the validation error returned by
// SchemaDefinition.Validate if the designated constraints aren't met.
type SchemaDefinitionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SchemaDefinitionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SchemaDefinitionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SchemaDefinitionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SchemaDefinitionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SchemaDefinitionValidationError) ErrorName() string { return "SchemaDefinitionValidationError" }

// Error satisfies the builtin error interface
func (e SchemaDefinitionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSchemaDefinition.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SchemaDefinitionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SchemaDefinitionValidationError{}

// Validate checks the field values on EntityDefinition with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *EntityDefinition) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on EntityDefinition with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// EntityDefinitionMultiError, or nil if none found.
func (m *EntityDefinition) ValidateAll() error {
	return m.validate(true)
}

func (m *EntityDefinition) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetName()) > 64 {
		err := EntityDefinitionValidationError{
			field:  "Name",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_EntityDefinition_Name_Pattern.MatchString(m.GetName()) {
		err := EntityDefinitionValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	{
		sorted_keys := make([]string, len(m.GetRelations()))
		i := 0
		for key := range m.GetRelations() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetRelations()[key]
			_ = val

			// no validation rules for Relations[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, EntityDefinitionValidationError{
							field:  fmt.Sprintf("Relations[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, EntityDefinitionValidationError{
							field:  fmt.Sprintf("Relations[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return EntityDefinitionValidationError{
						field:  fmt.Sprintf("Relations[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	{
		sorted_keys := make([]string, len(m.GetPermissions()))
		i := 0
		for key := range m.GetPermissions() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetPermissions()[key]
			_ = val

			// no validation rules for Permissions[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, EntityDefinitionValidationError{
							field:  fmt.Sprintf("Permissions[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, EntityDefinitionValidationError{
							field:  fmt.Sprintf("Permissions[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return EntityDefinitionValidationError{
						field:  fmt.Sprintf("Permissions[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	{
		sorted_keys := make([]string, len(m.GetAttributes()))
		i := 0
		for key := range m.GetAttributes() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetAttributes()[key]
			_ = val

			// no validation rules for Attributes[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, EntityDefinitionValidationError{
							field:  fmt.Sprintf("Attributes[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, EntityDefinitionValidationError{
							field:  fmt.Sprintf("Attributes[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return EntityDefinitionValidationError{
						field:  fmt.Sprintf("Attributes[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	// no validation rules for References

	if len(errors) > 0 {
		return EntityDefinitionMultiError(errors)
	}

	return nil
}

// EntityDefinitionMultiError is an error wrapping multiple validation errors
// returned by EntityDefinition.ValidateAll() if the designated constraints
// aren't met.
type EntityDefinitionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m EntityDefinitionMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m EntityDefinitionMultiError) AllErrors() []error { return m }

// EntityDefinitionValidationError is the validation error returned by
// EntityDefinition.Validate if the designated constraints aren't met.
type EntityDefinitionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EntityDefinitionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EntityDefinitionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EntityDefinitionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EntityDefinitionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EntityDefinitionValidationError) ErrorName() string { return "EntityDefinitionValidationError" }

// Error satisfies the builtin error interface
func (e EntityDefinitionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEntityDefinition.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EntityDefinitionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EntityDefinitionValidationError{}

var _EntityDefinition_Name_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on RuleDefinition with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RuleDefinition) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RuleDefinition with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RuleDefinitionMultiError,
// or nil if none found.
func (m *RuleDefinition) ValidateAll() error {
	return m.validate(true)
}

func (m *RuleDefinition) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetName()) > 64 {
		err := RuleDefinitionValidationError{
			field:  "Name",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_RuleDefinition_Name_Pattern.MatchString(m.GetName()) {
		err := RuleDefinitionValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Arguments

	if all {
		switch v := interface{}(m.GetExpression()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RuleDefinitionValidationError{
					field:  "Expression",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RuleDefinitionValidationError{
					field:  "Expression",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetExpression()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RuleDefinitionValidationError{
				field:  "Expression",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RuleDefinitionMultiError(errors)
	}

	return nil
}

// RuleDefinitionMultiError is an error wrapping multiple validation errors
// returned by RuleDefinition.ValidateAll() if the designated constraints
// aren't met.
type RuleDefinitionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RuleDefinitionMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RuleDefinitionMultiError) AllErrors() []error { return m }

// RuleDefinitionValidationError is the validation error returned by
// RuleDefinition.Validate if the designated constraints aren't met.
type RuleDefinitionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RuleDefinitionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RuleDefinitionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RuleDefinitionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RuleDefinitionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RuleDefinitionValidationError) ErrorName() string { return "RuleDefinitionValidationError" }

// Error satisfies the builtin error interface
func (e RuleDefinitionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRuleDefinition.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RuleDefinitionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RuleDefinitionValidationError{}

var _RuleDefinition_Name_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on AttributeDefinition with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AttributeDefinition) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AttributeDefinition with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AttributeDefinitionMultiError, or nil if none found.
func (m *AttributeDefinition) ValidateAll() error {
	return m.validate(true)
}

func (m *AttributeDefinition) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetName()) > 64 {
		err := AttributeDefinitionValidationError{
			field:  "Name",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_AttributeDefinition_Name_Pattern.MatchString(m.GetName()) {
		err := AttributeDefinitionValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Type

	if len(errors) > 0 {
		return AttributeDefinitionMultiError(errors)
	}

	return nil
}

// AttributeDefinitionMultiError is an error wrapping multiple validation
// errors returned by AttributeDefinition.ValidateAll() if the designated
// constraints aren't met.
type AttributeDefinitionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AttributeDefinitionMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AttributeDefinitionMultiError) AllErrors() []error { return m }

// AttributeDefinitionValidationError is the validation error returned by
// AttributeDefinition.Validate if the designated constraints aren't met.
type AttributeDefinitionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AttributeDefinitionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AttributeDefinitionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AttributeDefinitionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AttributeDefinitionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AttributeDefinitionValidationError) ErrorName() string {
	return "AttributeDefinitionValidationError"
}

// Error satisfies the builtin error interface
func (e AttributeDefinitionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAttributeDefinition.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AttributeDefinitionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AttributeDefinitionValidationError{}

var _AttributeDefinition_Name_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on RelationDefinition with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RelationDefinition) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationDefinition with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RelationDefinitionMultiError, or nil if none found.
func (m *RelationDefinition) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationDefinition) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetName()) > 64 {
		err := RelationDefinitionValidationError{
			field:  "Name",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_RelationDefinition_Name_Pattern.MatchString(m.GetName()) {
		err := RelationDefinitionValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetRelationReferences() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RelationDefinitionValidationError{
						field:  fmt.Sprintf("RelationReferences[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RelationDefinitionValidationError{
						field:  fmt.Sprintf("RelationReferences[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RelationDefinitionValidationError{
					field:  fmt.Sprintf("RelationReferences[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return RelationDefinitionMultiError(errors)
	}

	return nil
}

// RelationDefinitionMultiError is an error wrapping multiple validation errors
// returned by RelationDefinition.ValidateAll() if the designated constraints
// aren't met.
type RelationDefinitionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationDefinitionMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationDefinitionMultiError) AllErrors() []error { return m }

// RelationDefinitionValidationError is the validation error returned by
// RelationDefinition.Validate if the designated constraints aren't met.
type RelationDefinitionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationDefinitionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationDefinitionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationDefinitionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationDefinitionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationDefinitionValidationError) ErrorName() string {
	return "RelationDefinitionValidationError"
}

// Error satisfies the builtin error interface
func (e RelationDefinitionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationDefinition.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationDefinitionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationDefinitionValidationError{}

var _RelationDefinition_Name_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on PermissionDefinition with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PermissionDefinition) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PermissionDefinition with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// PermissionDefinitionMultiError, or nil if none found.
func (m *PermissionDefinition) ValidateAll() error {
	return m.validate(true)
}

func (m *PermissionDefinition) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetName()) > 64 {
		err := PermissionDefinitionValidationError{
			field:  "Name",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_PermissionDefinition_Name_Pattern.MatchString(m.GetName()) {
		err := PermissionDefinitionValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetChild()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PermissionDefinitionValidationError{
					field:  "Child",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PermissionDefinitionValidationError{
					field:  "Child",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetChild()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PermissionDefinitionValidationError{
				field:  "Child",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return PermissionDefinitionMultiError(errors)
	}

	return nil
}

// PermissionDefinitionMultiError is an error wrapping multiple validation
// errors returned by PermissionDefinition.ValidateAll() if the designated
// constraints aren't met.
type PermissionDefinitionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PermissionDefinitionMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PermissionDefinitionMultiError) AllErrors() []error { return m }

// PermissionDefinitionValidationError is the validation error returned by
// PermissionDefinition.Validate if the designated constraints aren't met.
type PermissionDefinitionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PermissionDefinitionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PermissionDefinitionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PermissionDefinitionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PermissionDefinitionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PermissionDefinitionValidationError) ErrorName() string {
	return "PermissionDefinitionValidationError"
}

// Error satisfies the builtin error interface
func (e PermissionDefinitionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPermissionDefinition.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PermissionDefinitionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PermissionDefinitionValidationError{}

var _PermissionDefinition_Name_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on RelationReference with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *RelationReference) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationReference with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RelationReferenceMultiError, or nil if none found.
func (m *RelationReference) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationReference) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetType()) > 64 {
		err := RelationReferenceValidationError{
			field:  "Type",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_RelationReference_Type_Pattern.MatchString(m.GetType()) {
		err := RelationReferenceValidationError{
			field:  "Type",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetRelation() != "" {

		if len(m.GetRelation()) > 64 {
			err := RelationReferenceValidationError{
				field:  "Relation",
				reason: "value length must be at most 64 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_RelationReference_Relation_Pattern.MatchString(m.GetRelation()) {
			err := RelationReferenceValidationError{
				field:  "Relation",
				reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return RelationReferenceMultiError(errors)
	}

	return nil
}

// RelationReferenceMultiError is an error wrapping multiple validation errors
// returned by RelationReference.ValidateAll() if the designated constraints
// aren't met.
type RelationReferenceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationReferenceMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationReferenceMultiError) AllErrors() []error { return m }

// RelationReferenceValidationError is the validation error returned by
// RelationReference.Validate if the designated constraints aren't met.
type RelationReferenceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationReferenceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationReferenceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationReferenceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationReferenceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationReferenceValidationError) ErrorName() string {
	return "RelationReferenceValidationError"
}

// Error satisfies the builtin error interface
func (e RelationReferenceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationReference.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationReferenceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationReferenceValidationError{}

var _RelationReference_Type_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

var _RelationReference_Relation_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on Entrance with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Entrance) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Entrance with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in EntranceMultiError, or nil
// if none found.
func (m *Entrance) ValidateAll() error {
	return m.validate(true)
}

func (m *Entrance) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetType()) > 64 {
		err := EntranceValidationError{
			field:  "Type",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_Entrance_Type_Pattern.MatchString(m.GetType()) {
		err := EntranceValidationError{
			field:  "Type",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetValue()) > 64 {
		err := EntranceValidationError{
			field:  "Value",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_Entrance_Value_Pattern.MatchString(m.GetValue()) {
		err := EntranceValidationError{
			field:  "Value",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return EntranceMultiError(errors)
	}

	return nil
}

// EntranceMultiError is an error wrapping multiple validation errors returned
// by Entrance.ValidateAll() if the designated constraints aren't met.
type EntranceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m EntranceMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m EntranceMultiError) AllErrors() []error { return m }

// EntranceValidationError is the validation error returned by
// Entrance.Validate if the designated constraints aren't met.
type EntranceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EntranceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EntranceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EntranceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EntranceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EntranceValidationError) ErrorName() string { return "EntranceValidationError" }

// Error satisfies the builtin error interface
func (e EntranceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEntrance.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EntranceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EntranceValidationError{}

var _Entrance_Type_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

var _Entrance_Value_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on Argument with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Argument) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Argument with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ArgumentMultiError, or nil
// if none found.
func (m *Argument) ValidateAll() error {
	return m.validate(true)
}

func (m *Argument) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Type.(type) {
	case *Argument_ComputedAttribute:
		if v == nil {
			err := ArgumentValidationError{
				field:  "Type",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetComputedAttribute()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ArgumentValidationError{
						field:  "ComputedAttribute",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ArgumentValidationError{
						field:  "ComputedAttribute",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetComputedAttribute()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ArgumentValidationError{
					field:  "ComputedAttribute",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return ArgumentMultiError(errors)
	}

	return nil
}

// ArgumentMultiError is an error wrapping multiple validation errors returned
// by Argument.ValidateAll() if the designated constraints aren't met.
type ArgumentMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ArgumentMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ArgumentMultiError) AllErrors() []error { return m }

// ArgumentValidationError is the validation error returned by
// Argument.Validate if the designated constraints aren't met.
type ArgumentValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ArgumentValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ArgumentValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ArgumentValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ArgumentValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ArgumentValidationError) ErrorName() string { return "ArgumentValidationError" }

// Error satisfies the builtin error interface
func (e ArgumentValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sArgument.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ArgumentValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ArgumentValidationError{}

// Validate checks the field values on Call with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *Call) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Call with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in CallMultiError, or nil if none found.
func (m *Call) ValidateAll() error {
	return m.validate(true)
}

func (m *Call) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for RuleName

	for idx, item := range m.GetArguments() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, CallValidationError{
						field:  fmt.Sprintf("Arguments[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, CallValidationError{
						field:  fmt.Sprintf("Arguments[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CallValidationError{
					field:  fmt.Sprintf("Arguments[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return CallMultiError(errors)
	}

	return nil
}

// CallMultiError is an error wrapping multiple validation errors returned by
// Call.ValidateAll() if the designated constraints aren't met.
type CallMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CallMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CallMultiError) AllErrors() []error { return m }

// CallValidationError is the validation error returned by Call.Validate if the
// designated constraints aren't met.
type CallValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CallValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CallValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CallValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CallValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CallValidationError) ErrorName() string { return "CallValidationError" }

// Error satisfies the builtin error interface
func (e CallValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCall.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CallValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CallValidationError{}

// Validate checks the field values on ComputedAttribute with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ComputedAttribute) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ComputedAttribute with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ComputedAttributeMultiError, or nil if none found.
func (m *ComputedAttribute) ValidateAll() error {
	return m.validate(true)
}

func (m *ComputedAttribute) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetName()) > 64 {
		err := ComputedAttributeValidationError{
			field:  "Name",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_ComputedAttribute_Name_Pattern.MatchString(m.GetName()) {
		err := ComputedAttributeValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ComputedAttributeMultiError(errors)
	}

	return nil
}

// ComputedAttributeMultiError is an error wrapping multiple validation errors
// returned by ComputedAttribute.ValidateAll() if the designated constraints
// aren't met.
type ComputedAttributeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ComputedAttributeMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ComputedAttributeMultiError) AllErrors() []error { return m }

// ComputedAttributeValidationError is the validation error returned by
// ComputedAttribute.Validate if the designated constraints aren't met.
type ComputedAttributeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ComputedAttributeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ComputedAttributeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ComputedAttributeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ComputedAttributeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ComputedAttributeValidationError) ErrorName() string {
	return "ComputedAttributeValidationError"
}

// Error satisfies the builtin error interface
func (e ComputedAttributeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sComputedAttribute.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ComputedAttributeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ComputedAttributeValidationError{}

var _ComputedAttribute_Name_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on ComputedUserSet with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ComputedUserSet) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ComputedUserSet with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ComputedUserSetMultiError, or nil if none found.
func (m *ComputedUserSet) ValidateAll() error {
	return m.validate(true)
}

func (m *ComputedUserSet) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetRelation()) > 64 {
		err := ComputedUserSetValidationError{
			field:  "Relation",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_ComputedUserSet_Relation_Pattern.MatchString(m.GetRelation()) {
		err := ComputedUserSetValidationError{
			field:  "Relation",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ComputedUserSetMultiError(errors)
	}

	return nil
}

// ComputedUserSetMultiError is an error wrapping multiple validation errors
// returned by ComputedUserSet.ValidateAll() if the designated constraints
// aren't met.
type ComputedUserSetMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ComputedUserSetMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ComputedUserSetMultiError) AllErrors() []error { return m }

// ComputedUserSetValidationError is the validation error returned by
// ComputedUserSet.Validate if the designated constraints aren't met.
type ComputedUserSetValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ComputedUserSetValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ComputedUserSetValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ComputedUserSetValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ComputedUserSetValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ComputedUserSetValidationError) ErrorName() string { return "ComputedUserSetValidationError" }

// Error satisfies the builtin error interface
func (e ComputedUserSetValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sComputedUserSet.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ComputedUserSetValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ComputedUserSetValidationError{}

var _ComputedUserSet_Relation_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on TupleToUserSet with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TupleToUserSet) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TupleToUserSet with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TupleToUserSetMultiError,
// or nil if none found.
func (m *TupleToUserSet) ValidateAll() error {
	return m.validate(true)
}

func (m *TupleToUserSet) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetTupleSet()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TupleToUserSetValidationError{
					field:  "TupleSet",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TupleToUserSetValidationError{
					field:  "TupleSet",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTupleSet()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TupleToUserSetValidationError{
				field:  "TupleSet",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetComputed()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TupleToUserSetValidationError{
					field:  "Computed",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TupleToUserSetValidationError{
					field:  "Computed",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetComputed()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TupleToUserSetValidationError{
				field:  "Computed",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return TupleToUserSetMultiError(errors)
	}

	return nil
}

// TupleToUserSetMultiError is an error wrapping multiple validation errors
// returned by TupleToUserSet.ValidateAll() if the designated constraints
// aren't met.
type TupleToUserSetMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TupleToUserSetMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TupleToUserSetMultiError) AllErrors() []error { return m }

// TupleToUserSetValidationError is the validation error returned by
// TupleToUserSet.Validate if the designated constraints aren't met.
type TupleToUserSetValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TupleToUserSetValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TupleToUserSetValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TupleToUserSetValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TupleToUserSetValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TupleToUserSetValidationError) ErrorName() string { return "TupleToUserSetValidationError" }

// Error satisfies the builtin error interface
func (e TupleToUserSetValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTupleToUserSet.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TupleToUserSetValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TupleToUserSetValidationError{}

// Validate checks the field values on TupleSet with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TupleSet) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TupleSet with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TupleSetMultiError, or nil
// if none found.
func (m *TupleSet) ValidateAll() error {
	return m.validate(true)
}

func (m *TupleSet) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetRelation()) > 64 {
		err := TupleSetValidationError{
			field:  "Relation",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_TupleSet_Relation_Pattern.MatchString(m.GetRelation()) {
		err := TupleSetValidationError{
			field:  "Relation",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return TupleSetMultiError(errors)
	}

	return nil
}

// TupleSetMultiError is an error wrapping multiple validation errors returned
// by TupleSet.ValidateAll() if the designated constraints aren't met.
type TupleSetMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TupleSetMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TupleSetMultiError) AllErrors() []error { return m }

// TupleSetValidationError is the validation error returned by
// TupleSet.Validate if the designated constraints aren't met.
type TupleSetValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TupleSetValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TupleSetValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TupleSetValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TupleSetValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TupleSetValidationError) ErrorName() string { return "TupleSetValidationError" }

// Error satisfies the builtin error interface
func (e TupleSetValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTupleSet.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TupleSetValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TupleSetValidationError{}

var _TupleSet_Relation_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on Tuple with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Tuple) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Tuple with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in TupleMultiError, or nil if none found.
func (m *Tuple) ValidateAll() error {
	return m.validate(true)
}

func (m *Tuple) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetEntity() == nil {
		err := TupleValidationError{
			field:  "Entity",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetEntity()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TupleValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TupleValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEntity()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TupleValidationError{
				field:  "Entity",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetRelation()) > 64 {
		err := TupleValidationError{
			field:  "Relation",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_Tuple_Relation_Pattern.MatchString(m.GetRelation()) {
		err := TupleValidationError{
			field:  "Relation",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetSubject() == nil {
		err := TupleValidationError{
			field:  "Subject",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetSubject()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TupleValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TupleValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSubject()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TupleValidationError{
				field:  "Subject",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return TupleMultiError(errors)
	}

	return nil
}

// TupleMultiError is an error wrapping multiple validation errors returned by
// Tuple.ValidateAll() if the designated constraints aren't met.
type TupleMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TupleMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TupleMultiError) AllErrors() []error { return m }

// TupleValidationError is the validation error returned by Tuple.Validate if
// the designated constraints aren't met.
type TupleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TupleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TupleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TupleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TupleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TupleValidationError) ErrorName() string { return "TupleValidationError" }

// Error satisfies the builtin error interface
func (e TupleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTuple.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TupleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TupleValidationError{}

var _Tuple_Relation_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on Attribute with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Attribute) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Attribute with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in AttributeMultiError, or nil
// if none found.
func (m *Attribute) ValidateAll() error {
	return m.validate(true)
}

func (m *Attribute) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetEntity() == nil {
		err := AttributeValidationError{
			field:  "Entity",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetEntity()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AttributeValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AttributeValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEntity()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AttributeValidationError{
				field:  "Entity",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Attribute

	if all {
		switch v := interface{}(m.GetValue()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AttributeValidationError{
					field:  "Value",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AttributeValidationError{
					field:  "Value",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetValue()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AttributeValidationError{
				field:  "Value",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return AttributeMultiError(errors)
	}

	return nil
}

// AttributeMultiError is an error wrapping multiple validation errors returned
// by Attribute.ValidateAll() if the designated constraints aren't met.
type AttributeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AttributeMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AttributeMultiError) AllErrors() []error { return m }

// AttributeValidationError is the validation error returned by
// Attribute.Validate if the designated constraints aren't met.
type AttributeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AttributeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AttributeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AttributeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AttributeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AttributeValidationError) ErrorName() string { return "AttributeValidationError" }

// Error satisfies the builtin error interface
func (e AttributeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAttribute.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AttributeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AttributeValidationError{}

// Validate checks the field values on Tuples with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Tuples) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Tuples with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in TuplesMultiError, or nil if none found.
func (m *Tuples) ValidateAll() error {
	return m.validate(true)
}

func (m *Tuples) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetTuples() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, TuplesValidationError{
						field:  fmt.Sprintf("Tuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, TuplesValidationError{
						field:  fmt.Sprintf("Tuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return TuplesValidationError{
					field:  fmt.Sprintf("Tuples[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return TuplesMultiError(errors)
	}

	return nil
}

// TuplesMultiError is an error wrapping multiple validation errors returned by
// Tuples.ValidateAll() if the designated constraints aren't met.
type TuplesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TuplesMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TuplesMultiError) AllErrors() []error { return m }

// TuplesValidationError is the validation error returned by Tuples.Validate if
// the designated constraints aren't met.
type TuplesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TuplesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TuplesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TuplesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TuplesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TuplesValidationError) ErrorName() string { return "TuplesValidationError" }

// Error satisfies the builtin error interface
func (e TuplesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTuples.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TuplesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TuplesValidationError{}

// Validate checks the field values on Attributes with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Attributes) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Attributes with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in AttributesMultiError, or
// nil if none found.
func (m *Attributes) ValidateAll() error {
	return m.validate(true)
}

func (m *Attributes) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetAttributes() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AttributesValidationError{
						field:  fmt.Sprintf("Attributes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AttributesValidationError{
						field:  fmt.Sprintf("Attributes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AttributesValidationError{
					field:  fmt.Sprintf("Attributes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return AttributesMultiError(errors)
	}

	return nil
}

// AttributesMultiError is an error wrapping multiple validation errors
// returned by Attributes.ValidateAll() if the designated constraints aren't met.
type AttributesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AttributesMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AttributesMultiError) AllErrors() []error { return m }

// AttributesValidationError is the validation error returned by
// Attributes.Validate if the designated constraints aren't met.
type AttributesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AttributesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AttributesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AttributesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AttributesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AttributesValidationError) ErrorName() string { return "AttributesValidationError" }

// Error satisfies the builtin error interface
func (e AttributesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAttributes.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AttributesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AttributesValidationError{}

// Validate checks the field values on Entity with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Entity) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Entity with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in EntityMultiError, or nil if none found.
func (m *Entity) ValidateAll() error {
	return m.validate(true)
}

func (m *Entity) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetType()) > 64 {
		err := EntityValidationError{
			field:  "Type",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_Entity_Type_Pattern.MatchString(m.GetType()) {
		err := EntityValidationError{
			field:  "Type",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetId()) > 128 {
		err := EntityValidationError{
			field:  "Id",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_Entity_Id_Pattern.MatchString(m.GetId()) {
		err := EntityValidationError{
			field:  "Id",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return EntityMultiError(errors)
	}

	return nil
}

// EntityMultiError is an error wrapping multiple validation errors returned by
// Entity.ValidateAll() if the designated constraints aren't met.
type EntityMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m EntityMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m EntityMultiError) AllErrors() []error { return m }

// EntityValidationError is the validation error returned by Entity.Validate if
// the designated constraints aren't met.
type EntityValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EntityValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EntityValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EntityValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EntityValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EntityValidationError) ErrorName() string { return "EntityValidationError" }

// Error satisfies the builtin error interface
func (e EntityValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEntity.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EntityValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EntityValidationError{}

var _Entity_Type_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

var _Entity_Id_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

// Validate checks the field values on EntityAndRelation with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *EntityAndRelation) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on EntityAndRelation with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// EntityAndRelationMultiError, or nil if none found.
func (m *EntityAndRelation) ValidateAll() error {
	return m.validate(true)
}

func (m *EntityAndRelation) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetEntity() == nil {
		err := EntityAndRelationValidationError{
			field:  "Entity",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetEntity()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, EntityAndRelationValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, EntityAndRelationValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEntity()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return EntityAndRelationValidationError{
				field:  "Entity",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetRelation()) > 64 {
		err := EntityAndRelationValidationError{
			field:  "Relation",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_EntityAndRelation_Relation_Pattern.MatchString(m.GetRelation()) {
		err := EntityAndRelationValidationError{
			field:  "Relation",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return EntityAndRelationMultiError(errors)
	}

	return nil
}

// EntityAndRelationMultiError is an error wrapping multiple validation errors
// returned by EntityAndRelation.ValidateAll() if the designated constraints
// aren't met.
type EntityAndRelationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m EntityAndRelationMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m EntityAndRelationMultiError) AllErrors() []error { return m }

// EntityAndRelationValidationError is the validation error returned by
// EntityAndRelation.Validate if the designated constraints aren't met.
type EntityAndRelationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EntityAndRelationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EntityAndRelationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EntityAndRelationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EntityAndRelationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EntityAndRelationValidationError) ErrorName() string {
	return "EntityAndRelationValidationError"
}

// Error satisfies the builtin error interface
func (e EntityAndRelationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEntityAndRelation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EntityAndRelationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EntityAndRelationValidationError{}

var _EntityAndRelation_Relation_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on Subject with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Subject) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Subject with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in SubjectMultiError, or nil if none found.
func (m *Subject) ValidateAll() error {
	return m.validate(true)
}

func (m *Subject) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetType()) > 64 {
		err := SubjectValidationError{
			field:  "Type",
			reason: "value length must be at most 64 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_Subject_Type_Pattern.MatchString(m.GetType()) {
		err := SubjectValidationError{
			field:  "Type",
			reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetId()) > 128 {
		err := SubjectValidationError{
			field:  "Id",
			reason: "value length must be at most 128 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_Subject_Id_Pattern.MatchString(m.GetId()) {
		err := SubjectValidationError{
			field:  "Id",
			reason: "value does not match regex pattern \"^([a-zA-Z0-9_\\\\-@\\\\.:+]{1,128}|\\\\*)$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetRelation() != "" {

		if len(m.GetRelation()) > 64 {
			err := SubjectValidationError{
				field:  "Relation",
				reason: "value length must be at most 64 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_Subject_Relation_Pattern.MatchString(m.GetRelation()) {
			err := SubjectValidationError{
				field:  "Relation",
				reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return SubjectMultiError(errors)
	}

	return nil
}

// SubjectMultiError is an error wrapping multiple validation errors returned
// by Subject.ValidateAll() if the designated constraints aren't met.
type SubjectMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SubjectMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SubjectMultiError) AllErrors() []error { return m }

// SubjectValidationError is the validation error returned by Subject.Validate
// if the designated constraints aren't met.
type SubjectValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SubjectValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SubjectValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SubjectValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SubjectValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SubjectValidationError) ErrorName() string { return "SubjectValidationError" }

// Error satisfies the builtin error interface
func (e SubjectValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSubject.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SubjectValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SubjectValidationError{}

var _Subject_Type_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

var _Subject_Id_Pattern = regexp.MustCompile("^([a-zA-Z0-9_\\-@\\.:+]{1,128}|\\*)$")

var _Subject_Relation_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on AttributeFilter with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *AttributeFilter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AttributeFilter with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AttributeFilterMultiError, or nil if none found.
func (m *AttributeFilter) ValidateAll() error {
	return m.validate(true)
}

func (m *AttributeFilter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetEntity()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AttributeFilterValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AttributeFilterValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEntity()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AttributeFilterValidationError{
				field:  "Entity",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return AttributeFilterMultiError(errors)
	}

	return nil
}

// AttributeFilterMultiError is an error wrapping multiple validation errors
// returned by AttributeFilter.ValidateAll() if the designated constraints
// aren't met.
type AttributeFilterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AttributeFilterMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AttributeFilterMultiError) AllErrors() []error { return m }

// AttributeFilterValidationError is the validation error returned by
// AttributeFilter.Validate if the designated constraints aren't met.
type AttributeFilterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AttributeFilterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AttributeFilterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AttributeFilterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AttributeFilterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AttributeFilterValidationError) ErrorName() string { return "AttributeFilterValidationError" }

// Error satisfies the builtin error interface
func (e AttributeFilterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAttributeFilter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AttributeFilterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AttributeFilterValidationError{}

// Validate checks the field values on TupleFilter with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TupleFilter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TupleFilter with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TupleFilterMultiError, or
// nil if none found.
func (m *TupleFilter) ValidateAll() error {
	return m.validate(true)
}

func (m *TupleFilter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetEntity()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TupleFilterValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TupleFilterValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEntity()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TupleFilterValidationError{
				field:  "Entity",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetRelation() != "" {

		if len(m.GetRelation()) > 64 {
			err := TupleFilterValidationError{
				field:  "Relation",
				reason: "value length must be at most 64 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_TupleFilter_Relation_Pattern.MatchString(m.GetRelation()) {
			err := TupleFilterValidationError{
				field:  "Relation",
				reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetSubject()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TupleFilterValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TupleFilterValidationError{
					field:  "Subject",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSubject()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TupleFilterValidationError{
				field:  "Subject",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return TupleFilterMultiError(errors)
	}

	return nil
}

// TupleFilterMultiError is an error wrapping multiple validation errors
// returned by TupleFilter.ValidateAll() if the designated constraints aren't met.
type TupleFilterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TupleFilterMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TupleFilterMultiError) AllErrors() []error { return m }

// TupleFilterValidationError is the validation error returned by
// TupleFilter.Validate if the designated constraints aren't met.
type TupleFilterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TupleFilterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TupleFilterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TupleFilterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TupleFilterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TupleFilterValidationError) ErrorName() string { return "TupleFilterValidationError" }

// Error satisfies the builtin error interface
func (e TupleFilterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTupleFilter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TupleFilterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TupleFilterValidationError{}

var _TupleFilter_Relation_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on EntityFilter with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *EntityFilter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on EntityFilter with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in EntityFilterMultiError, or
// nil if none found.
func (m *EntityFilter) ValidateAll() error {
	return m.validate(true)
}

func (m *EntityFilter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Type

	if len(errors) > 0 {
		return EntityFilterMultiError(errors)
	}

	return nil
}

// EntityFilterMultiError is an error wrapping multiple validation errors
// returned by EntityFilter.ValidateAll() if the designated constraints aren't met.
type EntityFilterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m EntityFilterMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m EntityFilterMultiError) AllErrors() []error { return m }

// EntityFilterValidationError is the validation error returned by
// EntityFilter.Validate if the designated constraints aren't met.
type EntityFilterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EntityFilterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EntityFilterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EntityFilterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EntityFilterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EntityFilterValidationError) ErrorName() string { return "EntityFilterValidationError" }

// Error satisfies the builtin error interface
func (e EntityFilterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEntityFilter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EntityFilterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EntityFilterValidationError{}

// Validate checks the field values on SubjectFilter with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *SubjectFilter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SubjectFilter with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in SubjectFilterMultiError, or
// nil if none found.
func (m *SubjectFilter) ValidateAll() error {
	return m.validate(true)
}

func (m *SubjectFilter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Type

	if m.GetRelation() != "" {

		if len(m.GetRelation()) > 64 {
			err := SubjectFilterValidationError{
				field:  "Relation",
				reason: "value length must be at most 64 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_SubjectFilter_Relation_Pattern.MatchString(m.GetRelation()) {
			err := SubjectFilterValidationError{
				field:  "Relation",
				reason: "value does not match regex pattern \"^[a-zA-Z_]{1,64}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return SubjectFilterMultiError(errors)
	}

	return nil
}

// SubjectFilterMultiError is an error wrapping multiple validation errors
// returned by SubjectFilter.ValidateAll() if the designated constraints
// aren't met.
type SubjectFilterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SubjectFilterMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SubjectFilterMultiError) AllErrors() []error { return m }

// SubjectFilterValidationError is the validation error returned by
// SubjectFilter.Validate if the designated constraints aren't met.
type SubjectFilterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SubjectFilterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SubjectFilterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SubjectFilterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SubjectFilterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SubjectFilterValidationError) ErrorName() string { return "SubjectFilterValidationError" }

// Error satisfies the builtin error interface
func (e SubjectFilterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSubjectFilter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SubjectFilterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SubjectFilterValidationError{}

var _SubjectFilter_Relation_Pattern = regexp.MustCompile("^[a-zA-Z_]{1,64}$")

// Validate checks the field values on ExpandTreeNode with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ExpandTreeNode) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ExpandTreeNode with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ExpandTreeNodeMultiError,
// or nil if none found.
func (m *ExpandTreeNode) ValidateAll() error {
	return m.validate(true)
}

func (m *ExpandTreeNode) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Operation

	for idx, item := range m.GetChildren() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ExpandTreeNodeValidationError{
						field:  fmt.Sprintf("Children[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ExpandTreeNodeValidationError{
						field:  fmt.Sprintf("Children[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ExpandTreeNodeValidationError{
					field:  fmt.Sprintf("Children[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ExpandTreeNodeMultiError(errors)
	}

	return nil
}

// ExpandTreeNodeMultiError is an error wrapping multiple validation errors
// returned by ExpandTreeNode.ValidateAll() if the designated constraints
// aren't met.
type ExpandTreeNodeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ExpandTreeNodeMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ExpandTreeNodeMultiError) AllErrors() []error { return m }

// ExpandTreeNodeValidationError is the validation error returned by
// ExpandTreeNode.Validate if the designated constraints aren't met.
type ExpandTreeNodeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ExpandTreeNodeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ExpandTreeNodeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ExpandTreeNodeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ExpandTreeNodeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ExpandTreeNodeValidationError) ErrorName() string { return "ExpandTreeNodeValidationError" }

// Error satisfies the builtin error interface
func (e ExpandTreeNodeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sExpandTreeNode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ExpandTreeNodeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ExpandTreeNodeValidationError{}

// Validate checks the field values on Expand with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Expand) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Expand with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ExpandMultiError, or nil if none found.
func (m *Expand) ValidateAll() error {
	return m.validate(true)
}

func (m *Expand) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetEntity()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ExpandValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ExpandValidationError{
					field:  "Entity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEntity()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ExpandValidationError{
				field:  "Entity",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Permission

	for idx, item := range m.GetArguments() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ExpandValidationError{
						field:  fmt.Sprintf("Arguments[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ExpandValidationError{
						field:  fmt.Sprintf("Arguments[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ExpandValidationError{
					field:  fmt.Sprintf("Arguments[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	switch v := m.Node.(type) {
	case *Expand_Expand:
		if v == nil {
			err := ExpandValidationError{
				field:  "Node",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetExpand()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ExpandValidationError{
						field:  "Expand",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ExpandValidationError{
						field:  "Expand",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetExpand()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ExpandValidationError{
					field:  "Expand",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Expand_Leaf:
		if v == nil {
			err := ExpandValidationError{
				field:  "Node",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetLeaf()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ExpandValidationError{
						field:  "Leaf",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ExpandValidationError{
						field:  "Leaf",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetLeaf()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ExpandValidationError{
					field:  "Leaf",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return ExpandMultiError(errors)
	}

	return nil
}

// ExpandMultiError is an error wrapping multiple validation errors returned by
// Expand.ValidateAll() if the designated constraints aren't met.
type ExpandMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ExpandMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ExpandMultiError) AllErrors() []error { return m }

// ExpandValidationError is the validation error returned by Expand.Validate if
// the designated constraints aren't met.
type ExpandValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ExpandValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ExpandValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ExpandValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ExpandValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ExpandValidationError) ErrorName() string { return "ExpandValidationError" }

// Error satisfies the builtin error interface
func (e ExpandValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sExpand.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ExpandValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ExpandValidationError{}

// Validate checks the field values on ExpandLeaf with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ExpandLeaf) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ExpandLeaf with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ExpandLeafMultiError, or
// nil if none found.
func (m *ExpandLeaf) ValidateAll() error {
	return m.validate(true)
}

func (m *ExpandLeaf) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofTypePresent := false
	switch v := m.Type.(type) {
	case *ExpandLeaf_Subjects:
		if v == nil {
			err := ExpandLeafValidationError{
				field:  "Type",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTypePresent = true

		if all {
			switch v := interface{}(m.GetSubjects()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ExpandLeafValidationError{
						field:  "Subjects",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ExpandLeafValidationError{
						field:  "Subjects",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetSubjects()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ExpandLeafValidationError{
					field:  "Subjects",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ExpandLeaf_Values:
		if v == nil {
			err := ExpandLeafValidationError{
				field:  "Type",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTypePresent = true

		if all {
			switch v := interface{}(m.GetValues()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ExpandLeafValidationError{
						field:  "Values",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ExpandLeafValidationError{
						field:  "Values",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetValues()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ExpandLeafValidationError{
					field:  "Values",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ExpandLeaf_Value:
		if v == nil {
			err := ExpandLeafValidationError{
				field:  "Type",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTypePresent = true

		if all {
			switch v := interface{}(m.GetValue()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ExpandLeafValidationError{
						field:  "Value",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ExpandLeafValidationError{
						field:  "Value",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetValue()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ExpandLeafValidationError{
					field:  "Value",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofTypePresent {
		err := ExpandLeafValidationError{
			field:  "Type",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ExpandLeafMultiError(errors)
	}

	return nil
}

// ExpandLeafMultiError is an error wrapping multiple validation errors
// returned by ExpandLeaf.ValidateAll() if the designated constraints aren't met.
type ExpandLeafMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ExpandLeafMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ExpandLeafMultiError) AllErrors() []error { return m }

// ExpandLeafValidationError is the validation error returned by
// ExpandLeaf.Validate if the designated constraints aren't met.
type ExpandLeafValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ExpandLeafValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ExpandLeafValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ExpandLeafValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ExpandLeafValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ExpandLeafValidationError) ErrorName() string { return "ExpandLeafValidationError" }

// Error satisfies the builtin error interface
func (e ExpandLeafValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sExpandLeaf.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ExpandLeafValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ExpandLeafValidationError{}

// Validate checks the field values on Values with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Values) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Values with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ValuesMultiError, or nil if none found.
func (m *Values) ValidateAll() error {
	return m.validate(true)
}

func (m *Values) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	{
		sorted_keys := make([]string, len(m.GetValues()))
		i := 0
		for key := range m.GetValues() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetValues()[key]
			_ = val

			// no validation rules for Values[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, ValuesValidationError{
							field:  fmt.Sprintf("Values[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, ValuesValidationError{
							field:  fmt.Sprintf("Values[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return ValuesValidationError{
						field:  fmt.Sprintf("Values[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if len(errors) > 0 {
		return ValuesMultiError(errors)
	}

	return nil
}

// ValuesMultiError is an error wrapping multiple validation errors returned by
// Values.ValidateAll() if the designated constraints aren't met.
type ValuesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ValuesMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ValuesMultiError) AllErrors() []error { return m }

// ValuesValidationError is the validation error returned by Values.Validate if
// the designated constraints aren't met.
type ValuesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ValuesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ValuesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ValuesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ValuesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ValuesValidationError) ErrorName() string { return "ValuesValidationError" }

// Error satisfies the builtin error interface
func (e ValuesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sValues.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ValuesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ValuesValidationError{}

// Validate checks the field values on Subjects with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Subjects) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Subjects with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in SubjectsMultiError, or nil
// if none found.
func (m *Subjects) ValidateAll() error {
	return m.validate(true)
}

func (m *Subjects) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetSubjects() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, SubjectsValidationError{
						field:  fmt.Sprintf("Subjects[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, SubjectsValidationError{
						field:  fmt.Sprintf("Subjects[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return SubjectsValidationError{
					field:  fmt.Sprintf("Subjects[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return SubjectsMultiError(errors)
	}

	return nil
}

// SubjectsMultiError is an error wrapping multiple validation errors returned
// by Subjects.ValidateAll() if the designated constraints aren't met.
type SubjectsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SubjectsMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SubjectsMultiError) AllErrors() []error { return m }

// SubjectsValidationError is the validation error returned by
// Subjects.Validate if the designated constraints aren't met.
type SubjectsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SubjectsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SubjectsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SubjectsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SubjectsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SubjectsValidationError) ErrorName() string { return "SubjectsValidationError" }

// Error satisfies the builtin error interface
func (e SubjectsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSubjects.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SubjectsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SubjectsValidationError{}

// Validate checks the field values on Tenant with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Tenant) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Tenant with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in TenantMultiError, or nil if none found.
func (m *Tenant) ValidateAll() error {
	return m.validate(true)
}

func (m *Tenant) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	// no validation rules for Name

	if all {
		switch v := interface{}(m.GetCreatedAt()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TenantValidationError{
					field:  "CreatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TenantValidationError{
					field:  "CreatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCreatedAt()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TenantValidationError{
				field:  "CreatedAt",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return TenantMultiError(errors)
	}

	return nil
}

// TenantMultiError is an error wrapping multiple validation errors returned by
// Tenant.ValidateAll() if the designated constraints aren't met.
type TenantMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TenantMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TenantMultiError) AllErrors() []error { return m }

// TenantValidationError is the validation error returned by Tenant.Validate if
// the designated constraints aren't met.
type TenantValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TenantValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TenantValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TenantValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TenantValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TenantValidationError) ErrorName() string { return "TenantValidationError" }

// Error satisfies the builtin error interface
func (e TenantValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTenant.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TenantValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TenantValidationError{}

// Validate checks the field values on DataChanges with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *DataChanges) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DataChanges with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in DataChangesMultiError, or
// nil if none found.
func (m *DataChanges) ValidateAll() error {
	return m.validate(true)
}

func (m *DataChanges) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SnapToken

	for idx, item := range m.GetDataChanges() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DataChangesValidationError{
						field:  fmt.Sprintf("DataChanges[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DataChangesValidationError{
						field:  fmt.Sprintf("DataChanges[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DataChangesValidationError{
					field:  fmt.Sprintf("DataChanges[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return DataChangesMultiError(errors)
	}

	return nil
}

// DataChangesMultiError is an error wrapping multiple validation errors
// returned by DataChanges.ValidateAll() if the designated constraints aren't met.
type DataChangesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DataChangesMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DataChangesMultiError) AllErrors() []error { return m }

// DataChangesValidationError is the validation error returned by
// DataChanges.Validate if the designated constraints aren't met.
type DataChangesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DataChangesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DataChangesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DataChangesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DataChangesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DataChangesValidationError) ErrorName() string { return "DataChangesValidationError" }

// Error satisfies the builtin error interface
func (e DataChangesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDataChanges.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DataChangesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DataChangesValidationError{}

// Validate checks the field values on DataChange with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *DataChange) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DataChange with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in DataChangeMultiError, or
// nil if none found.
func (m *DataChange) ValidateAll() error {
	return m.validate(true)
}

func (m *DataChange) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Operation

	oneofTypePresent := false
	switch v := m.Type.(type) {
	case *DataChange_Tuple:
		if v == nil {
			err := DataChangeValidationError{
				field:  "Type",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTypePresent = true

		if all {
			switch v := interface{}(m.GetTuple()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DataChangeValidationError{
						field:  "Tuple",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DataChangeValidationError{
						field:  "Tuple",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTuple()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DataChangeValidationError{
					field:  "Tuple",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *DataChange_Attribute:
		if v == nil {
			err := DataChangeValidationError{
				field:  "Type",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTypePresent = true

		if all {
			switch v := interface{}(m.GetAttribute()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DataChangeValidationError{
						field:  "Attribute",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DataChangeValidationError{
						field:  "Attribute",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAttribute()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DataChangeValidationError{
					field:  "Attribute",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofTypePresent {
		err := DataChangeValidationError{
			field:  "Type",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return DataChangeMultiError(errors)
	}

	return nil
}

// DataChangeMultiError is an error wrapping multiple validation errors
// returned by DataChange.ValidateAll() if the designated constraints aren't met.
type DataChangeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DataChangeMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DataChangeMultiError) AllErrors() []error { return m }

// DataChangeValidationError is the validation error returned by
// DataChange.Validate if the designated constraints aren't met.
type DataChangeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DataChangeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DataChangeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DataChangeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DataChangeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DataChangeValidationError) ErrorName() string { return "DataChangeValidationError" }

// Error satisfies the builtin error interface
func (e DataChangeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDataChange.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DataChangeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DataChangeValidationError{}

// Validate checks the field values on StringValue with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *StringValue) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on StringValue with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in StringValueMultiError, or
// nil if none found.
func (m *StringValue) ValidateAll() error {
	return m.validate(true)
}

func (m *StringValue) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Data

	if len(errors) > 0 {
		return StringValueMultiError(errors)
	}

	return nil
}

// StringValueMultiError is an error wrapping multiple validation errors
// returned by StringValue.ValidateAll() if the designated constraints aren't met.
type StringValueMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m StringValueMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m StringValueMultiError) AllErrors() []error { return m }

// StringValueValidationError is the validation error returned by
// StringValue.Validate if the designated constraints aren't met.
type StringValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e StringValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e StringValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e StringValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e StringValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e StringValueValidationError) ErrorName() string { return "StringValueValidationError" }

// Error satisfies the builtin error interface
func (e StringValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sStringValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = StringValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = StringValueValidationError{}

// Validate checks the field values on IntegerValue with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *IntegerValue) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on IntegerValue with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in IntegerValueMultiError, or
// nil if none found.
func (m *IntegerValue) ValidateAll() error {
	return m.validate(true)
}

func (m *IntegerValue) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Data

	if len(errors) > 0 {
		return IntegerValueMultiError(errors)
	}

	return nil
}

// IntegerValueMultiError is an error wrapping multiple validation errors
// returned by IntegerValue.ValidateAll() if the designated constraints aren't met.
type IntegerValueMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m IntegerValueMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m IntegerValueMultiError) AllErrors() []error { return m }

// IntegerValueValidationError is the validation error returned by
// IntegerValue.Validate if the designated constraints aren't met.
type IntegerValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e IntegerValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e IntegerValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e IntegerValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e IntegerValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e IntegerValueValidationError) ErrorName() string { return "IntegerValueValidationError" }

// Error satisfies the builtin error interface
func (e IntegerValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sIntegerValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = IntegerValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = IntegerValueValidationError{}

// Validate checks the field values on DoubleValue with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *DoubleValue) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DoubleValue with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in DoubleValueMultiError, or
// nil if none found.
func (m *DoubleValue) ValidateAll() error {
	return m.validate(true)
}

func (m *DoubleValue) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Data

	if len(errors) > 0 {
		return DoubleValueMultiError(errors)
	}

	return nil
}

// DoubleValueMultiError is an error wrapping multiple validation errors
// returned by DoubleValue.ValidateAll() if the designated constraints aren't met.
type DoubleValueMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DoubleValueMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DoubleValueMultiError) AllErrors() []error { return m }

// DoubleValueValidationError is the validation error returned by
// DoubleValue.Validate if the designated constraints aren't met.
type DoubleValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DoubleValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DoubleValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DoubleValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DoubleValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DoubleValueValidationError) ErrorName() string { return "DoubleValueValidationError" }

// Error satisfies the builtin error interface
func (e DoubleValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDoubleValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DoubleValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DoubleValueValidationError{}

// Validate checks the field values on BooleanValue with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *BooleanValue) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BooleanValue with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in BooleanValueMultiError, or
// nil if none found.
func (m *BooleanValue) ValidateAll() error {
	return m.validate(true)
}

func (m *BooleanValue) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Data

	if len(errors) > 0 {
		return BooleanValueMultiError(errors)
	}

	return nil
}

// BooleanValueMultiError is an error wrapping multiple validation errors
// returned by BooleanValue.ValidateAll() if the designated constraints aren't met.
type BooleanValueMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BooleanValueMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BooleanValueMultiError) AllErrors() []error { return m }

// BooleanValueValidationError is the validation error returned by
// BooleanValue.Validate if the designated constraints aren't met.
type BooleanValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BooleanValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BooleanValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BooleanValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BooleanValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BooleanValueValidationError) ErrorName() string { return "BooleanValueValidationError" }

// Error satisfies the builtin error interface
func (e BooleanValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBooleanValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BooleanValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BooleanValueValidationError{}

// Validate checks the field values on StringArrayValue with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *StringArrayValue) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on StringArrayValue with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// StringArrayValueMultiError, or nil if none found.
func (m *StringArrayValue) ValidateAll() error {
	return m.validate(true)
}

func (m *StringArrayValue) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return StringArrayValueMultiError(errors)
	}

	return nil
}

// StringArrayValueMultiError is an error wrapping multiple validation errors
// returned by StringArrayValue.ValidateAll() if the designated constraints
// aren't met.
type StringArrayValueMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m StringArrayValueMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m StringArrayValueMultiError) AllErrors() []error { return m }

// StringArrayValueValidationError is the validation error returned by
// StringArrayValue.Validate if the designated constraints aren't met.
type StringArrayValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e StringArrayValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e StringArrayValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e StringArrayValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e StringArrayValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e StringArrayValueValidationError) ErrorName() string { return "StringArrayValueValidationError" }

// Error satisfies the builtin error interface
func (e StringArrayValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sStringArrayValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = StringArrayValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = StringArrayValueValidationError{}

// Validate checks the field values on IntegerArrayValue with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *IntegerArrayValue) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on IntegerArrayValue with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// IntegerArrayValueMultiError, or nil if none found.
func (m *IntegerArrayValue) ValidateAll() error {
	return m.validate(true)
}

func (m *IntegerArrayValue) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return IntegerArrayValueMultiError(errors)
	}

	return nil
}

// IntegerArrayValueMultiError is an error wrapping multiple validation errors
// returned by IntegerArrayValue.ValidateAll() if the designated constraints
// aren't met.
type IntegerArrayValueMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m IntegerArrayValueMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m IntegerArrayValueMultiError) AllErrors() []error { return m }

// IntegerArrayValueValidationError is the validation error returned by
// IntegerArrayValue.Validate if the designated constraints aren't met.
type IntegerArrayValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e IntegerArrayValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e IntegerArrayValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e IntegerArrayValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e IntegerArrayValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e IntegerArrayValueValidationError) ErrorName() string {
	return "IntegerArrayValueValidationError"
}

// Error satisfies the builtin error interface
func (e IntegerArrayValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sIntegerArrayValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = IntegerArrayValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = IntegerArrayValueValidationError{}

// Validate checks the field values on DoubleArrayValue with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *DoubleArrayValue) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DoubleArrayValue with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DoubleArrayValueMultiError, or nil if none found.
func (m *DoubleArrayValue) ValidateAll() error {
	return m.validate(true)
}

func (m *DoubleArrayValue) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return DoubleArrayValueMultiError(errors)
	}

	return nil
}

// DoubleArrayValueMultiError is an error wrapping multiple validation errors
// returned by DoubleArrayValue.ValidateAll() if the designated constraints
// aren't met.
type DoubleArrayValueMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DoubleArrayValueMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DoubleArrayValueMultiError) AllErrors() []error { return m }

// DoubleArrayValueValidationError is the validation error returned by
// DoubleArrayValue.Validate if the designated constraints aren't met.
type DoubleArrayValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DoubleArrayValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DoubleArrayValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DoubleArrayValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DoubleArrayValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DoubleArrayValueValidationError) ErrorName() string { return "DoubleArrayValueValidationError" }

// Error satisfies the builtin error interface
func (e DoubleArrayValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDoubleArrayValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DoubleArrayValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DoubleArrayValueValidationError{}

// Validate checks the field values on BooleanArrayValue with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *BooleanArrayValue) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BooleanArrayValue with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BooleanArrayValueMultiError, or nil if none found.
func (m *BooleanArrayValue) ValidateAll() error {
	return m.validate(true)
}

func (m *BooleanArrayValue) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return BooleanArrayValueMultiError(errors)
	}

	return nil
}

// BooleanArrayValueMultiError is an error wrapping multiple validation errors
// returned by BooleanArrayValue.ValidateAll() if the designated constraints
// aren't met.
type BooleanArrayValueMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BooleanArrayValueMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BooleanArrayValueMultiError) AllErrors() []error { return m }

// BooleanArrayValueValidationError is the validation error returned by
// BooleanArrayValue.Validate if the designated constraints aren't met.
type BooleanArrayValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BooleanArrayValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BooleanArrayValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BooleanArrayValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BooleanArrayValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BooleanArrayValueValidationError) ErrorName() string {
	return "BooleanArrayValueValidationError"
}

// Error satisfies the builtin error interface
func (e BooleanArrayValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBooleanArrayValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BooleanArrayValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BooleanArrayValueValidationError{}

// Validate checks the field values on DataBundle with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *DataBundle) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DataBundle with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in DataBundleMultiError, or
// nil if none found.
func (m *DataBundle) ValidateAll() error {
	return m.validate(true)
}

func (m *DataBundle) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Name

	for idx, item := range m.GetOperations() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DataBundleValidationError{
						field:  fmt.Sprintf("Operations[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DataBundleValidationError{
						field:  fmt.Sprintf("Operations[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DataBundleValidationError{
					field:  fmt.Sprintf("Operations[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return DataBundleMultiError(errors)
	}

	return nil
}

// DataBundleMultiError is an error wrapping multiple validation errors
// returned by DataBundle.ValidateAll() if the designated constraints aren't met.
type DataBundleMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DataBundleMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DataBundleMultiError) AllErrors() []error { return m }

// DataBundleValidationError is the validation error returned by
// DataBundle.Validate if the designated constraints aren't met.
type DataBundleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DataBundleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DataBundleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DataBundleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DataBundleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DataBundleValidationError) ErrorName() string { return "DataBundleValidationError" }

// Error satisfies the builtin error interface
func (e DataBundleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDataBundle.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DataBundleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DataBundleValidationError{}

// Validate checks the field values on Operation with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Operation) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Operation with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in OperationMultiError, or nil
// if none found.
func (m *Operation) ValidateAll() error {
	return m.validate(true)
}

func (m *Operation) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return OperationMultiError(errors)
	}

	return nil
}

// OperationMultiError is an error wrapping multiple validation errors returned
// by Operation.ValidateAll() if the designated constraints aren't met.
type OperationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m OperationMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m OperationMultiError) AllErrors() []error { return m }

// OperationValidationError is the validation error returned by
// Operation.Validate if the designated constraints aren't met.
type OperationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OperationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OperationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OperationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OperationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OperationValidationError) ErrorName() string { return "OperationValidationError" }

// Error satisfies the builtin error interface
func (e OperationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOperation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OperationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OperationValidationError{}

// Validate checks the field values on Partials with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Partials) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Partials with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in PartialsMultiError, or nil
// if none found.
func (m *Partials) ValidateAll() error {
	return m.validate(true)
}

func (m *Partials) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return PartialsMultiError(errors)
	}

	return nil
}

// PartialsMultiError is an error wrapping multiple validation errors returned
// by Partials.ValidateAll() if the designated constraints aren't met.
type PartialsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PartialsMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PartialsMultiError) AllErrors() []error { return m }

// PartialsValidationError is the validation error returned by
// Partials.Validate if the designated constraints aren't met.
type PartialsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PartialsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PartialsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PartialsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PartialsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PartialsValidationError) ErrorName() string { return "PartialsValidationError" }

// Error satisfies the builtin error interface
func (e PartialsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPartials.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PartialsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PartialsValidationError{}
