//////////////////////////////////////////////////////////////////////////////
/**
 * @module vgl
 */

/* global mat4 */
/* exported modelViewMatrixStack */
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
/**
 * Helper function to create stack for matrices
 */
//////////////////////////////////////////////////////////////////////////////
vgl.modelViewMatrixStack = function () {
  'use strict';

  var mvMatrixStack = [];

  if (!(this instanceof vgl.modelViewMatrixStack)) {
    /* jshint newcap: false */
    //jscs:disable requireCapitalizedConstructors
    return new vgl.modelViewMatrixStack();
    //jscs:enable requireCapitalizedConstructors
    /* jshint newcap: true */
  }

  ////////////////////////////////////////////////////////////////////////////
  /**
   * Push new matrix to the stack
   *
   * @param mat
   */
  ////////////////////////////////////////////////////////////////////////////
  this.pushMatrix = function (mat) {
    var copy = mat4.create();
    mat4.set(mat, copy);
    mvMatrixStack.push(copy);
  };

  ////////////////////////////////////////////////////////////////////////////
  /**
   * Pop matrix from the stack
   *
   * @returns {*}
   */
  ////////////////////////////////////////////////////////////////////////////
  this.popMatrix = function () {
    if (mvMatrixStack.length === 0) {
      throw 'Invalid popMatrix!';
    }
    var mat = mvMatrixStack.pop();
    return mat;
  };
};
