# coding: utf8
"""Based on unique combinations form this dataset:

https://github.com/UniversalDependencies/UD_Norwegian-Bokmaal

Models can be trained using this. dataset as well."""
from __future__ import unicode_literals

from ...symbols import POS, PUNCT, ADJ, CONJ, CCONJ, SCONJ, SYM, NUM, DET, ADV, ADP, X, VERB
from ...symbols import NOUN, PROPN, PART, INTJ, SPACE, PRON, AUX

TAG_MAP = {
    'NOUN__Definite=Ind|Gender=Neut|Number=Sing': {'morph': 'Definite=Ind|Gender=Neut|Number=Sing', POS: NOUN},
    'CCONJ___': {'morph': '_', POS: CCONJ},
    'NOUN__Definite=Ind|Gender=Masc|Number=Sing': {'morph': 'Definite=Ind|Gender=Masc|Number=Sing', POS: NOUN},
    'ADP___': {'morph': '_', POS: ADP},
    'NOUN__Definite=Def|Gender=Masc|Number=Sing': {'morph': 'Definite=Def|Gender=Masc|Number=Sing', POS: NOUN},
    'NOUN__Definite=Ind|Gender=Neut|Number=Plur': {'morph': 'Definite=Ind|Gender=Neut|Number=Plur', POS: NOUN},
    'PUNCT___': {'morph': '_', POS: PUNCT},
    'VERB__Mood=Ind|Tense=Past|VerbForm=Fin': {'morph': 'Mood=Ind|Tense=Past|VerbForm=Fin', POS: VERB},
    'DET__Gender=Masc|Number=Sing|PronType=Dem': {'morph': 'Gender=Masc|Number=Sing|PronType=Dem', POS: DET},
    'ADJ__Definite=Def|Degree=Pos|Number=Sing': {'morph': 'Definite=Def|Degree=Pos|Number=Sing', POS: ADJ},
    'PROPN___': {'morph': '_', POS: PROPN},
    'X___': {'morph': '_', POS: X},
    'VERB__Mood=Ind|Tense=Pres|VerbForm=Fin': {'morph': 'Mood=Ind|Tense=Pres|VerbForm=Fin', POS: VERB},
    'NOUN__Definite=Def|Gender=Neut|Number=Sing': {'morph': 'Definite=Def|Gender=Neut|Number=Sing', POS: NOUN},
    'PRON__PronType=Rel': {'morph': 'PronType=Rel', POS: PRON},
    'AUX__Mood=Ind|Tense=Pres|VerbForm=Fin': {'morph': 'Mood=Ind|Tense=Pres|VerbForm=Fin', POS: AUX},
    'ADJ__Definite=Ind|Gender=Neut|Number=Sing|VerbForm=Part': {'morph': 'Definite=Ind|Gender=Neut|Number=Sing|VerbForm=Part', POS: ADJ},
    'ADJ__Definite=Ind|Degree=Pos|Number=Sing': {'morph': 'Definite=Ind|Degree=Pos|Number=Sing', POS: ADJ},
    'NOUN__Definite=Ind|Gender=Fem|Number=Sing': {'morph': 'Definite=Ind|Gender=Fem|Number=Sing', POS: NOUN},
    'ADJ__Number=Plur|VerbForm=Part': {'morph': 'Number=Plur|VerbForm=Part', POS: ADJ},
    'NOUN__Definite=Ind|Gender=Fem|Number=Plur': {'morph': 'Definite=Ind|Gender=Fem|Number=Plur', POS: NOUN},
    'ADV___': {'morph': '_', POS: ADV},
    'PRON__Gender=Neut|Number=Sing|Person=3|PronType=Prs': {'morph': 'Gender=Neut|Number=Sing|Person=3|PronType=Prs', POS: PRON},
    'ADJ__Definite=Ind|Number=Sing|VerbForm=Part': {'morph': 'Definite=Ind|Number=Sing|VerbForm=Part', POS: ADJ},
    'VERB__VerbForm=Part': {'morph': 'VerbForm=Part', POS: VERB},
    'NOUN__Definite=Ind|Gender=Masc|Number=Plur': {'morph': 'Definite=Ind|Gender=Masc|Number=Plur', POS: NOUN},
    'ADJ__Definite=Ind|Degree=Pos|Gender=Neut|Number=Sing': {'morph': 'Definite=Ind|Degree=Pos|Gender=Neut|Number=Sing', POS: ADJ},
    'ADJ__Degree=Pos|Number=Plur': {'morph': 'Degree=Pos|Number=Plur', POS: ADJ},
    'NUM__Number=Plur|NumType=Card': {'morph': 'Number=Plur|NumType=Card', POS: NUM},
    'NOUN__Definite=Def|Gender=Masc|Number=Plur': {'morph': 'Definite=Def|Gender=Masc|Number=Plur', POS: NOUN},
    'PRON__Case=Acc|PronType=Prs|Reflex=Yes': {'morph': 'Case=Acc|PronType=Prs|Reflex=Yes', POS: PRON},
    'NOUN__Case=Gen|Definite=Ind|Gender=Neut|Number=Sing': {'morph': 'Case=Gen|Definite=Ind|Gender=Neut|Number=Sing', POS: NOUN},
    'PART___': {'morph': '_', POS: PART},
    'VERB__VerbForm=Inf': {'morph': 'VerbForm=Inf', POS: VERB},
    'PRON__Case=Nom|Number=Plur|Person=3|PronType=Prs': {'morph': 'Case=Nom|Number=Plur|Person=3|PronType=Prs', POS: PRON},
    'AUX__Mood=Ind|Tense=Past|VerbForm=Fin': {'morph': 'Mood=Ind|Tense=Past|VerbForm=Fin', POS: AUX},
    'PROPN__Gender=Fem': {'morph': 'Gender=Fem', POS: PROPN},
    'NOUN___': {'morph': '_', POS: NOUN},
    'PROPN__Gender=Masc': {'morph': 'Gender=Masc', POS: PROPN},
    'DET__Gender=Neut|Number=Sing|PronType=Dem': {'morph': 'Gender=Neut|Number=Sing|PronType=Dem', POS: DET},
    'DET__Gender=Masc|Number=Sing|PronType=Art': {'morph': 'Gender=Masc|Number=Sing|PronType=Art', POS: DET},
    'NOUN__Case=Gen|Definite=Def|Gender=Masc|Number=Sing': {'morph': 'Case=Gen|Definite=Def|Gender=Masc|Number=Sing', POS: NOUN},
    'PROPN__Abbr=Yes': {'morph': 'Abbr=Yes', POS: PROPN},
    'ADV__Polarity=Neg': {'morph': 'Polarity=Neg', POS: ADV},
    'SCONJ___': {'morph': '_', POS: SCONJ},
    'DET__Number=Plur|Poss=Yes|PronType=Prs': {'morph': 'Number=Plur|Poss=Yes|PronType=Prs', POS: DET},
    'NOUN__Case=Gen|Definite=Ind|Gender=Neut|Number=Plur': {'morph': 'Case=Gen|Definite=Ind|Gender=Neut|Number=Plur', POS: NOUN},
    'PROPN__Case=Gen': {'morph': 'Case=Gen', POS: PROPN},
    'DET__Gender=Fem|Number=Sing|PronType=Dem': {'morph': 'Gender=Fem|Number=Sing|PronType=Dem', POS: DET},
    'DET__Gender=Masc|Number=Sing|Poss=Yes|PronType=Prs': {'morph': 'Gender=Masc|Number=Sing|Poss=Yes|PronType=Prs', POS: DET},
    'ADJ__Definite=Def|Degree=Sup': {'morph': 'Definite=Def|Degree=Sup', POS: ADJ},
    'PROPN__Case=Gen|Gender=Fem': {'morph': 'Case=Gen|Gender=Fem', POS: PROPN},
    'DET__Number=Plur|PronType=Dem': {'morph': 'Number=Plur|PronType=Dem', POS: DET},
    'NOUN__Case=Gen|Definite=Def|Gender=Neut|Number=Sing': {'morph': 'Case=Gen|Definite=Def|Gender=Neut|Number=Sing', POS: NOUN},
    'ADJ__Definite=Ind|Degree=Sup': {'morph': 'Definite=Ind|Degree=Sup', POS: ADJ},
    'NOUN__Definite=Def|Gender=Fem|Number=Plur': {'morph': 'Definite=Def|Gender=Fem|Number=Plur', POS: NOUN},
    'PROPN__Gender=Neut': {'morph': 'Gender=Neut', POS: PROPN},
    'DET__Number=Plur|PronType=Int': {'morph': 'Number=Plur|PronType=Int', POS: DET},
    'NOUN__Definite=Def|Gender=Neut|Number=Plur': {'morph': 'Definite=Def|Gender=Neut|Number=Plur', POS: NOUN},
    'DET__Definite=Def|PronType=Dem': {'morph': 'Definite=Def|PronType=Dem', POS: DET},
    'DET__Gender=Neut|Number=Sing|PronType=Art': {'morph': 'Gender=Neut|Number=Sing|PronType=Art', POS: DET},
    'VERB__Mood=Ind|Tense=Pres|VerbForm=Fin|Voice=Pass': {'morph': 'Mood=Ind|Tense=Pres|VerbForm=Fin|Voice=Pass', POS: VERB},
    'PROPN__Abbr=Yes|Case=Gen': {'morph': 'Abbr=Yes|Case=Gen', POS: PROPN},
    'PRON__Animacy=Hum|Case=Nom|Gender=Masc|Number=Sing|Person=3|PronType=Prs': {'morph': 'Animacy=Hum|Case=Nom|Gender=Masc|Number=Sing|Person=3|PronType=Prs', POS: PRON},
    'ADJ__Degree=Cmp': {'morph': 'Degree=Cmp', POS: ADJ},
    'ADJ__VerbForm=Part': {'morph': 'VerbForm=Part', POS: ADJ},
    'DET__Gender=Neut|Number=Sing|Poss=Yes|PronType=Prs': {'morph': 'Gender=Neut|Number=Sing|Poss=Yes|PronType=Prs', POS: DET},
    'ADP__Abbr=Yes': {'morph': 'Abbr=Yes', POS: ADP},
    'DET__Definite=Ind|Gender=Neut|Number=Sing|PronType=Prs': {'morph': 'Definite=Ind|Gender=Neut|Number=Sing|PronType=Prs', POS: DET},
    'NOUN__Case=Gen|Definite=Def|Gender=Neut|Number=Plur': {'morph': 'Case=Gen|Definite=Def|Gender=Neut|Number=Plur', POS: NOUN},
    'AUX__VerbForm=Part': {'morph': 'VerbForm=Part', POS: AUX},
    'PRON__PronType=Int': {'morph': 'PronType=Int', POS: PRON},
    'DET__Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs': {'morph': 'Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs', POS: DET},
    'PRON__Number=Plur|Person=3|PronType=Ind,Prs': {'morph': 'Number=Plur|Person=3|PronType=Ind,Prs', POS: PRON},
    'DET__Number=Plur|PronType=Ind': {'morph': 'Number=Plur|PronType=Ind', POS: DET},
    'ADJ__Degree=Pos': {'morph': 'Degree=Pos', POS: ADJ},
    'PRON__Animacy=Hum|Case=Nom|Number=Plur|Person=1|PronType=Prs': {'morph': 'Animacy=Hum|Case=Nom|Number=Plur|Person=1|PronType=Prs', POS: PRON},
    'VERB__VerbForm=Inf|Voice=Pass': {'morph': 'VerbForm=Inf|Voice=Pass', POS: VERB},
    'DET__Definite=Ind|Gender=Fem|Number=Sing|PronType=Dem': {'morph': 'Definite=Ind|Gender=Fem|Number=Sing|PronType=Dem', POS: DET},
    'DET__Gender=Neut|Number=Sing|PronType=Ind': {'morph': 'Gender=Neut|Number=Sing|PronType=Ind', POS: DET},
    'PRON__Animacy=Hum|Case=Acc|Gender=Masc|Number=Sing|Person=3|PronType=Prs': {'morph': 'Animacy=Hum|Case=Acc|Gender=Masc|Number=Sing|Person=3|PronType=Prs', POS: PRON},
    'PRON__Animacy=Hum|Case=Nom|Number=Sing|Person=1|PronType=Prs': {'morph': 'Animacy=Hum|Case=Nom|Number=Sing|Person=1|PronType=Prs', POS: PRON},
    'DET__Number=Plur|Polarity=Neg|PronType=Neg': {'morph': 'Number=Plur|Polarity=Neg|PronType=Neg', POS: DET},
    'NUM__NumType=Card': {'morph': 'NumType=Card', POS: NUM},
    'DET__Gender=Masc|Number=Sing|PronType=Ind': {'morph': 'Gender=Masc|Number=Sing|PronType=Ind', POS: DET},
    'DET__PronType=Prs': {'morph': 'PronType=Prs', POS: DET},
    'DET__Gender=Fem|Number=Sing|PronType=Ind': {'morph': 'Gender=Fem|Number=Sing|PronType=Ind', POS: DET},
    'PROPN__Case=Gen|Gender=Neut': {'morph': 'Case=Gen|Gender=Neut', POS: PROPN},
    'DET__Gender=Masc|Number=Sing|Polarity=Neg|PronType=Neg': {'morph': 'Gender=Masc|Number=Sing|Polarity=Neg|PronType=Neg', POS: DET},
    'ADJ__Definite=Def|Number=Sing|VerbForm=Part': {'morph': 'Definite=Def|Number=Sing|VerbForm=Part', POS: ADJ},
    'PRON__Gender=Fem,Masc|Number=Sing|Person=3|PronType=Prs': {'morph': 'Gender=Fem,Masc|Number=Sing|Person=3|PronType=Prs', POS: PRON},
    'AUX__VerbForm=Inf': {'morph': 'VerbForm=Inf', POS: AUX},
    'PRON__Case=Acc|Number=Plur|Person=3|PronType=Prs': {'morph': 'Case=Acc|Number=Plur|Person=3|PronType=Prs', POS: PRON},
    'ADJ__Case=Gen|Degree=Pos|Number=Plur': {'morph': 'Case=Gen|Degree=Pos|Number=Plur', POS: ADJ},
    'DET__Number=Plur|PronType=Tot': {'morph': 'Number=Plur|PronType=Tot', POS: DET},
    'DET__Case=Gen|Gender=Masc|Number=Sing|PronType=Dem': {'morph': 'Case=Gen|Gender=Masc|Number=Sing|PronType=Dem', POS: DET},
    'DET__Number=Plur|PronType=Prs': {'morph': 'Number=Plur|PronType=Prs', POS: DET},
    'SYM___': {'morph': '_', POS: SYM},
    'NUM__Gender=Neut|Number=Sing|NumType=Card': {'morph': 'Gender=Neut|Number=Sing|NumType=Card', POS: NUM},
    'PRON__Animacy=Hum|Case=Nom|Number=Sing|PronType=Prs': {'morph': 'Animacy=Hum|Case=Nom|Number=Sing|PronType=Prs', POS: PRON},
    'DET__Definite=Ind|Gender=Masc|Number=Sing|PronType=Prs': {'morph': 'Definite=Ind|Gender=Masc|Number=Sing|PronType=Prs', POS: DET},
    'NOUN__Case=Gen|Definite=Ind|Gender=Masc|Number=Sing': {'morph': 'Case=Gen|Definite=Ind|Gender=Masc|Number=Sing', POS: NOUN},
    'ADV__Abbr=Yes': {'morph': 'Abbr=Yes', POS: ADV},
    'DET__Definite=Ind|Gender=Neut|Number=Sing|PronType=Dem': {'morph': 'Definite=Ind|Gender=Neut|Number=Sing|PronType=Dem', POS: DET},
    'DET__Gender=Masc|Number=Sing|PronType=Tot': {'morph': 'Gender=Masc|Number=Sing|PronType=Tot', POS: DET},
    'DET__Definite=Def|PronType=Prs': {'morph': 'Definite=Def|PronType=Prs', POS: DET},
    'PRON__Animacy=Hum|Case=Nom|Gender=Fem|Number=Sing|Person=3|PronType=Prs': {'morph': 'Animacy=Hum|Case=Nom|Gender=Fem|Number=Sing|Person=3|PronType=Prs', POS: PRON},
    'NOUN__Gender=Neut': {'morph': 'Gender=Neut', POS: NOUN},
    'DET__Gender=Neut|Number=Sing|PronType=Int': {'morph': 'Gender=Neut|Number=Sing|PronType=Int', POS: DET},
    'NUM__Definite=Def|NumType=Card': {'morph': 'Definite=Def|NumType=Card', POS: NUM},
    'VERB__Mood=Imp|VerbForm=Fin': {'morph': 'Mood=Imp|VerbForm=Fin', POS: VERB},
    'NOUN__Definite=Ind|Number=Plur': {'morph': 'Definite=Ind|Number=Plur', POS: NOUN},
    'DET__Gender=Neut|Number=Sing|PronType=Tot': {'morph': 'Gender=Neut|Number=Sing|PronType=Tot', POS: DET},
    'DET__Gender=Fem|Number=Sing|PronType=Tot': {'morph': 'Gender=Fem|Number=Sing|PronType=Tot', POS: DET},
    'PRON__Animacy=Hum|Case=Acc|Number=Plur|Person=1|PronType=Prs': {'morph': 'Animacy=Hum|Case=Acc|Number=Plur|Person=1|PronType=Prs', POS: PRON},
    'PRON__Gender=Fem,Masc|Number=Sing|Person=3|Polarity=Neg|PronType=Neg,Prs': {'morph': 'Gender=Fem,Masc|Number=Sing|Person=3|Polarity=Neg|PronType=Neg,Prs', POS: PRON},
    'PRON__Number=Plur|Person=3|Polarity=Neg|PronType=Neg,Prs': {'morph': 'Number=Plur|Person=3|Polarity=Neg|PronType=Neg,Prs', POS: PRON},
    'NUM__Definite=Def|Number=Sing|NumType=Card': {'morph': 'Definite=Def|Number=Sing|NumType=Card', POS: NUM},
    'NUM__Gender=Masc|Number=Sing|NumType=Card': {'morph': 'Gender=Masc|Number=Sing|NumType=Card', POS: NUM},
    'DET__Definite=Ind|Gender=Masc|Number=Sing|PronType=Dem': {'morph': 'Definite=Ind|Gender=Masc|Number=Sing|PronType=Dem', POS: DET},
    'NOUN__Case=Gen|Definite=Def|Gender=Fem|Number=Plur': {'morph': 'Case=Gen|Definite=Def|Gender=Fem|Number=Plur', POS: NOUN},
    'DET__Case=Gen|Gender=Neut|Number=Sing|PronType=Dem': {'morph': 'Case=Gen|Gender=Neut|Number=Sing|PronType=Dem', POS: DET},
    'PRON__Animacy=Hum|Number=Sing|PronType=Art,Prs': {'morph': 'Animacy=Hum|Number=Sing|PronType=Art,Prs', POS: PRON},
    'AUX__Mood=Imp|VerbForm=Fin': {'morph': 'Mood=Imp|VerbForm=Fin', POS: AUX},
    'PRON__Number=Plur|Person=3|PronType=Prs,Tot': {'morph': 'Number=Plur|Person=3|PronType=Prs,Tot', POS: PRON},
    'ADJ__Number=Plur': {'morph': 'Number=Plur', POS: ADJ},
    'NOUN__Gender=Masc': {'morph': 'Gender=Masc', POS: NOUN},
    'NOUN__Abbr=Yes': {'morph': 'Abbr=Yes', POS: NOUN},
    'NOUN__Case=Gen|Definite=Ind|Gender=Masc|Number=Plur': {'morph': 'Case=Gen|Definite=Ind|Gender=Masc|Number=Plur', POS: NOUN},
    'PRON__Gender=Neut|Number=Sing|Person=3|PronType=Ind,Prs': {'morph': 'Gender=Neut|Number=Sing|Person=3|PronType=Ind,Prs', POS: PRON},
    'INTJ___': {'morph': '_', POS: INTJ},
    'PRON__Animacy=Hum|Case=Nom|Number=Sing|Person=2|PronType=Prs': {'morph': 'Animacy=Hum|Case=Nom|Number=Sing|Person=2|PronType=Prs', POS: PRON},
    'PRON__Animacy=Hum|Case=Acc|Number=Sing|Person=1|PronType=Prs': {'morph': 'Animacy=Hum|Case=Acc|Number=Sing|Person=1|PronType=Prs', POS: PRON},
    'NOUN__Case=Gen|Definite=Def|Gender=Masc|Number=Plur': {'morph': 'Case=Gen|Definite=Def|Gender=Masc|Number=Plur', POS: NOUN},
    'ADJ___': {'morph': '_', POS: ADJ},
    'PRON__Animacy=Hum|Case=Acc|Gender=Fem|Number=Sing|Person=3|PronType=Prs': {'morph': 'Animacy=Hum|Case=Acc|Gender=Fem|Number=Sing|Person=3|PronType=Prs', POS: PRON},
    'PRON__Animacy=Hum|Case=Acc|Number=Sing|Person=2|PronType=Prs': {'morph': 'Animacy=Hum|Case=Acc|Number=Sing|Person=2|PronType=Prs', POS: PRON},
    'NOUN__Definite=Def|Gender=Fem|Number=Sing': {'morph': 'Definite=Def|Gender=Fem|Number=Sing', POS: NOUN},
    'PRON__Number=Sing|Polarity=Neg|PronType=Neg': {'morph': 'Number=Sing|Polarity=Neg|PronType=Neg', POS: PRON},
    'NOUN__Case=Gen': {'morph': 'Case=Gen', POS: NOUN},
    'ADJ__Definite=Ind|Number=Sing': {'morph': 'Definite=Ind|Number=Sing', POS: ADJ},
    'PROPN__Case=Gen|Gender=Masc': {'morph': 'Case=Gen|Gender=Masc', POS: PROPN},
    'PRON__Animacy=Hum|Number=Plur|PronType=Rcp': {'morph': 'Animacy=Hum|Number=Plur|PronType=Rcp', POS: PRON},
    'NOUN__Case=Gen|Definite=Ind|Gender=Fem|Number=Sing': {'morph': 'Case=Gen|Definite=Ind|Gender=Fem|Number=Sing', POS: NOUN},
    'PRON__Number=Plur|Person=3|PronType=Prs': {'morph': 'Number=Plur|Person=3|PronType=Prs', POS: PRON},
    'PRON__Gender=Fem,Masc|Number=Sing|Person=3|PronType=Ind,Prs': {'morph': 'Gender=Fem,Masc|Number=Sing|Person=3|PronType=Ind,Prs', POS: PRON},
    'DET__Definite=Ind|Gender=Fem|Number=Sing|PronType=Prs': {'morph': 'Definite=Ind|Gender=Fem|Number=Sing|PronType=Prs', POS: DET},
    'NOUN__Case=Gen|Definite=Def|Gender=Fem|Number=Sing': {'morph': 'Case=Gen|Definite=Def|Gender=Fem|Number=Sing', POS: NOUN},
    'DET__Gender=Fem|Number=Sing|PronType=Art': {'morph': 'Gender=Fem|Number=Sing|PronType=Art', POS: DET},
    'ADJ__Case=Gen|Definite=Def|Degree=Pos|Number=Sing': {'morph': 'Case=Gen|Definite=Def|Degree=Pos|Number=Sing', POS: ADJ},
    'DET__Gender=Masc|Number=Sing|PronType=Int': {'morph': 'Gender=Masc|Number=Sing|PronType=Int', POS: DET},
    'NUM__Number=Sing|NumType=Card': {'morph': 'Number=Sing|NumType=Card', POS: NUM},
    'PRON__Animacy=Hum|Case=Acc|Number=Plur|Person=2|PronType=Prs': {'morph': 'Animacy=Hum|Case=Acc|Number=Plur|Person=2|PronType=Prs', POS: PRON},
    'PRON__Animacy=Hum|Case=Nom|Number=Plur|Person=2|PronType=Prs': {'morph': 'Animacy=Hum|Case=Nom|Number=Plur|Person=2|PronType=Prs', POS: PRON},
    'ADJ__Case=Gen|Definite=Ind|Degree=Pos|Gender=Neut|Number=Sing': {'morph': 'Case=Gen|Definite=Ind|Degree=Pos|Gender=Neut|Number=Sing', POS: ADJ},
    'ADJ__Degree=Sup': {'morph': 'Degree=Sup', POS: ADJ},
    'PRON__Animacy=Hum|PronType=Int': {'morph': 'Animacy=Hum|PronType=Int', POS: PRON},
    'DET__PronType=Ind': {'morph': 'PronType=Ind', POS: DET},
    'DET__Definite=Def|Number=Sing|PronType=Dem': {'morph': 'Definite=Def|Number=Sing|PronType=Dem', POS: DET},
    'NOUN__Gender=Fem': {'morph': 'Gender=Fem', POS: NOUN},
    'DET__Case=Gen|Number=Plur|PronType=Dem': {'morph': 'Case=Gen|Number=Plur|PronType=Dem', POS: DET},
    'PRON__Gender=Fem,Masc|Number=Sing|Person=3|PronType=Prs,Tot': {'morph': 'Gender=Fem,Masc|Number=Sing|Person=3|PronType=Prs,Tot', POS: PRON},
    'NOUN__Case=Gen|Definite=Ind|Gender=Fem|Number=Plur': {'morph': 'Case=Gen|Definite=Ind|Gender=Fem|Number=Plur', POS: NOUN},
    'DET__Gender=Neut|Number=Sing|Polarity=Neg|PronType=Neg': {'morph': 'Gender=Neut|Number=Sing|Polarity=Neg|PronType=Neg', POS: DET},
    'NOUN__Number=Plur': {'morph': 'Number=Plur', POS: NOUN},
    'ADJ__Case=Gen|Definite=Ind|Degree=Pos|Number=Sing': {'morph': 'Case=Gen|Definite=Ind|Degree=Pos|Number=Sing', POS: ADJ},
    'VERB__Definite=Ind|Number=Sing|VerbForm=Part': {'morph': 'Definite=Ind|Number=Sing|VerbForm=Part', POS: VERB},
    'ADJ__Case=Gen|Definite=Def|Number=Sing|VerbForm=Part': {'morph': 'Case=Gen|Definite=Def|Number=Sing|VerbForm=Part', POS: ADJ},
    'VERB__Mood=Ind|Tense=Past|VerbForm=Fin|Voice=Pass': {'morph': 'Mood=Ind|Tense=Past|VerbForm=Fin|Voice=Pass', POS: VERB},
    'DET__Gender=Neut|Number=Sing|PronType=Dem,Ind': {'morph': 'Gender=Neut|Number=Sing|PronType=Dem,Ind', POS: DET},
    'PRON__Animacy=Hum|Poss=Yes|PronType=Int': {'morph': 'Animacy=Hum|Poss=Yes|PronType=Int', POS: PRON},
    'ADJ__Abbr=Yes': {'morph': 'Abbr=Yes', POS: ADJ},
    'DET__Case=Gen|Gender=Masc|Number=Sing|PronType=Art': {'morph': 'Case=Gen|Gender=Masc|Number=Sing|PronType=Art', POS: DET},
    'NOUN__Abbr=Yes|Definite=Def,Ind|Gender=Masc|Number=Sing': {'morph': 'Abbr=Yes|Definite=Def,Ind|Gender=Masc|Number=Sing', POS: NOUN},
    'PRON__PronType=Prs': {'morph': 'PronType=Prs', POS: PRON},
    'DET__Case=Gen|Gender=Fem|Number=Sing|PronType=Dem': {'morph': 'Case=Gen|Gender=Fem|Number=Sing|PronType=Dem', POS: DET},
    'DET__Number=Plur|Poss=Yes|PronType=Rcp': {'morph': 'Number=Plur|Poss=Yes|PronType=Rcp', POS: DET},
    'ADJ__Definite=Ind|Degree=Pos': {'morph': 'Definite=Ind|Degree=Pos', POS: ADJ},
    'DET__Number=Plur|PronType=Art': {'morph': 'Number=Plur|PronType=Art', POS: DET},
    'NUM__Case=Gen|Number=Plur|NumType=Card': {'morph': 'Case=Gen|Number=Plur|NumType=Card', POS: NUM},
    'NOUN__Abbr=Yes|Definite=Def,Ind|Gender=Neut|Number=Plur,Sing': {'morph': 'Abbr=Yes|Definite=Def,Ind|Gender=Neut|Number=Plur,Sing', POS: NOUN},
    'DET__Case=Gen|Number=Plur|PronType=Tot': {'morph': 'Case=Gen|Number=Plur|PronType=Tot', POS: DET},
    'NOUN__Abbr=Yes|Definite=Def,Ind|Gender=Masc|Number=Plur,Sing': {'morph': 'Abbr=Yes|Definite=Def,Ind|Gender=Masc|Number=Plur,Sing', POS: NOUN},
    'DET__Gender=Fem|Number=Sing|PronType=Int': {'morph': 'Gender=Fem|Number=Sing|PronType=Int', POS: DET},
    'ADJ__Definite=Ind|Gender=Neut|Number=Sing': {'morph': 'Definite=Ind|Gender=Neut|Number=Sing', POS: ADJ},
    'DET__Case=Gen|Definite=Ind|Gender=Masc|Number=Sing|PronType=Dem': {'morph': 'Case=Gen|Definite=Ind|Gender=Masc|Number=Sing|PronType=Dem', POS: DET},
    'DET__Gender=Fem|Number=Sing|PronType=Prs': {'morph': 'Gender=Fem|Number=Sing|PronType=Prs', POS: DET},
    'PRON__Animacy=Hum|Case=Gen,Nom|Number=Sing|PronType=Art,Prs': {'morph': 'Animacy=Hum|Case=Gen,Nom|Number=Sing|PronType=Art,Prs', POS: PRON},
    'ADJ__Definite=Def|Degree=Pos|Gender=Masc|Number=Sing': {'morph': 'Definite=Def|Degree=Pos|Gender=Masc|Number=Sing', POS: ADJ},
    'PRON__Animacy=Hum|Case=Gen|Number=Sing|PronType=Art,Prs': {'morph': 'Animacy=Hum|Case=Gen|Number=Sing|PronType=Art,Prs', POS: PRON},
    'NUM__Gender=Fem|Number=Sing|NumType=Card': {'morph': 'Gender=Fem|Number=Sing|NumType=Card', POS: NUM},
    'NOUN__Definite=Ind|Gender=Masc': {'morph': 'Definite=Ind|Gender=Masc', POS: NOUN},
    'NOUN__Definite=Def|Number=Plur': {'morph': 'Definite=Def|Number=Plur', POS: NOUN},
    'ADJ__Number=Sing|VerbForm=Part': {'morph': 'Number=Sing|VerbForm=Part', POS: ADJ},
    'ADJ__Definite=Ind|Gender=Masc|Number=Sing|VerbForm=Part': {'morph': 'Definite=Ind|Gender=Masc|Number=Sing|VerbForm=Part', POS: ADJ},
    'NOUN__Abbr=Yes|Gender=Masc': {'morph': 'Abbr=Yes|Gender=Masc', POS: NOUN},
    'NOUN__Abbr=Yes|Case=Gen': {'morph': 'Abbr=Yes|Case=Gen', POS: NOUN},
    'VERB__Abbr=Yes|Mood=Ind|Tense=Pres|VerbForm=Fin': {'morph': 'Abbr=Yes|Mood=Ind|Tense=Pres|VerbForm=Fin', POS: VERB},
    'ADJ__Abbr=Yes|Degree=Pos': {'morph': 'Abbr=Yes|Degree=Pos', POS: ADJ},
    'NOUN__Case=Gen|Gender=Fem': {'morph': 'Case=Gen|Gender=Fem', POS: NOUN},
    'ADJ__Case=Gen|Degree=Cmp': {'morph': 'Case=Gen|Degree=Cmp', POS: ADJ},
    'ADJ__Definite=Ind|Degree=Pos|Gender=Masc|Number=Sing': {'morph': 'Definite=Ind|Degree=Pos|Gender=Masc|Number=Sing', POS: ADJ},
    'NOUN__Gender=Masc|Number=Sing': {'morph': 'Gender=Masc|Number=Sing', POS: NOUN},
}
