package com.vanced.manager.ui.dialogs

import android.os.Bundle
import android.view.LayoutInflater
import android.view.ViewGroup
import com.vanced.manager.R
import com.vanced.manager.databinding.DialogMusicPreferencesBinding
import com.vanced.manager.ui.core.BindingBottomSheetDialogFragment
import com.vanced.manager.utils.Extensions.convertToAppVersions
import com.vanced.manager.utils.Extensions.getDefaultPrefs
import com.vanced.manager.utils.Extensions.show
import com.vanced.manager.utils.InternetTools.musicVersions

class MusicPreferencesDialog : BindingBottomSheetDialogFragment<DialogMusicPreferencesBinding>() {

    companion object {

        fun newInstance(): MusicPreferencesDialog = MusicPreferencesDialog().apply {
            arguments = Bundle()
        }
    }

    private val prefs by lazy { requireActivity().getDefaultPrefs() }

    override fun binding(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ) = DialogMusicPreferencesBinding.inflate(inflater, container, false)

    override fun otherSetups() {
        bindData()
    }

    private fun bindData() {
        with(binding) {
            val musicVersionsConv = musicVersions.get()?.value?.reversed()?.convertToAppVersions()
            musicInstallTitle.text = getString(R.string.app_installation_preferences, getString(R.string.music))
            musicVersion.text = getString(R.string.chosen_version, prefs.getString("music_version", "latest"))
            openVersionSelector.setOnClickListener {
                dismiss()
                AppVersionSelectorDialog.newInstance(
                    versions = musicVersionsConv,
                    app = "music"
                ).show(requireActivity())
            }
            musicInstall.setOnClickListener {
                dismiss()
                AppDownloadDialog.newInstance(
                    app = getString(R.string.music)
                ).show(requireActivity())
            }
        }
    }
}