package com.vanced.manager.ui.dialogs

import android.os.Bundle
import android.view.LayoutInflater
import android.view.ViewGroup
import android.view.ViewGroup.LayoutParams.*
import androidx.core.content.edit
import androidx.preference.PreferenceManager.*
import com.google.android.material.radiobutton.MaterialRadioButton
import com.vanced.manager.BuildConfig.*
import com.vanced.manager.databinding.DialogManagerLanguageBinding
import com.vanced.manager.ui.core.BindingBottomSheetDialogFragment
import com.vanced.manager.utils.Extensions.getCheckedButtonTag
import com.vanced.manager.utils.LanguageHelper.getLanguageFormat

class ManagerLanguageDialog : BindingBottomSheetDialogFragment<DialogManagerLanguageBinding>() {

    companion object {

        fun newInstance(): ManagerLanguageDialog = ManagerLanguageDialog().apply {
            arguments = Bundle()
        }
    }

    private val prefs by lazy { getDefaultSharedPreferences(requireActivity()) }

    override fun binding(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ) = DialogManagerLanguageBinding.inflate(inflater, container, false)

    override fun otherSetups() {
        bindData()
    }

    private fun bindData() {
        with(binding) {
            addRadioButtons().forEach { mrb ->
                languageRadiogroup.addView(mrb, MATCH_PARENT, WRAP_CONTENT)
            }
            val language = prefs.getString("manager_lang", "System Default")
            root.findViewWithTag<MaterialRadioButton>(language).isChecked = true
            languageSave.setOnClickListener {
                val newPref = binding.languageRadiogroup.getCheckedButtonTag()
                if (language != newPref) {
                    prefs.edit { putString("manager_lang", newPref) }
                    dismiss()
                    requireActivity().recreate()
                } else {
                    dismiss()
                }
            }
        }
    }

    private fun addRadioButtons() =
        (arrayOf("System Default") + MANAGER_LANGUAGES).map { lang ->
            MaterialRadioButton(requireActivity()).apply {
                text = getLanguageFormat(requireActivity(), lang)
                textSize = 18f
                tag = lang
            }
        }
}