﻿/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

namespace QuantConnect.Data.Custom.TradingEconomics
{
    public static partial class TradingEconomics
    {
        /// <summary>
        /// Indicator group
        /// </summary>
        public static class Indicator
        {
            public static class Afghanistan
            {
                /// <summary>
                /// Afghanistan Currency
                /// </summary>
                public const string Currency = "USDAFN";
            }
            public static class Albania
            {
                /// <summary>
                /// Albania Currency
                /// </summary>
                public const string Currency = "USDALL";
            }
            public static class Algeria
            {
                /// <summary>
                /// Algeria Currency
                /// </summary>
                public const string Currency = "USDDZD";
            }
            public static class Angola
            {
                /// <summary>
                /// Angola Currency
                /// </summary>
                public const string Currency = "USDAOA";
            }
            public static class Argentina
            {
                /// <summary>
                /// Argentina Interest Rate
                /// </summary>
                public const string InterestRate = "APDR1T";
                /// <summary>
                /// Argentina Deposit Interest Rate
                /// </summary>
                public const string DepositInterestRate = "ARGFRINRDPST";
                /// <summary>
                /// Argentina Stock Market
                /// </summary>
                public const string StockMarket = "MERVAL";
                /// <summary>
                /// Argentina Currency
                /// </summary>
                public const string Currency = "USDARS";
            }
            public static class Armenia
            {
                /// <summary>
                /// Armenia Currency
                /// </summary>
                public const string Currency = "USDAMD";
            }
            public static class Australia
            {
                /// <summary>
                /// Australia Stock Market
                /// </summary>
                public const string StockMarket = "AS51";
                /// <summary>
                /// Australia Currency
                /// </summary>
                public const string Currency = "AUDUSD";
                /// <summary>
                /// Australia 2 Year Note Yield
                /// </summary>
                public const string TwoYearNoteYield = "AUSTRALIA2YNY";
                /// <summary>
                /// Australia Central Bank Balance Sheet
                /// </summary>
                public const string CentralBankBalanceSheet = "AUSTRALIACENBANBALSH";
                /// <summary>
                /// Australia Inflation Expectations
                /// </summary>
                public const string InflationExpectations = "AUSTRALIAINFEXP";
                /// <summary>
                /// Australia Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GACGB10";
                /// <summary>
                /// Australia Consumer Confidence
                /// </summary>
                public const string ConsumerConfidence = "WMCCCONPCT";
            }
            public static class Austria
            {
                /// <summary>
                /// Austria Stock Market
                /// </summary>
                public const string StockMarket = "ATX";
                /// <summary>
                /// Austria Currency
                /// </summary>
                public const string Currency = "EURUSD";
                /// <summary>
                /// Austria Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GAGB10YR";
            }
            public static class Bahamas
            {
                /// <summary>
                /// Bahamas Currency
                /// </summary>
                public const string Currency = "USDBSD";
            }
            public static class Bahrain
            {
                /// <summary>
                /// Bahrain Interbank Rate
                /// </summary>
                public const string InterbankRate = "BAHRAININTRAT";
                /// <summary>
                /// Bahrain Stock Market
                /// </summary>
                public const string StockMarket = "BHSEEI";
                /// <summary>
                /// Bahrain Currency
                /// </summary>
                public const string Currency = "USDBHD";
            }
            public static class Bangladesh
            {
                /// <summary>
                /// Bangladesh Interest Rate
                /// </summary>
                public const string InterestRate = "BANGLADESHINTRATE";
                /// <summary>
                /// Bangladesh Stock Market
                /// </summary>
                public const string StockMarket = "DHAKA";
                /// <summary>
                /// Bangladesh Currency
                /// </summary>
                public const string Currency = "USDBDT";
            }
            public static class Belarus
            {
                /// <summary>
                /// Belarus Currency
                /// </summary>
                public const string Currency = "USDBYR";
            }
            public static class Belgium
            {
                /// <summary>
                /// Belgium Stock Market
                /// </summary>
                public const string StockMarket = "BEL20";
                /// <summary>
                /// Belgium Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GBGB10YR";
            }
            public static class Bermuda
            {
                /// <summary>
                /// Bermuda Stock Market
                /// </summary>
                public const string StockMarket = "BSX";
            }
            public static class Bolivia
            {
                /// <summary>
                /// Bolivia Currency
                /// </summary>
                public const string Currency = "USDBOB";
            }
            public static class BosniaAndHerzegovina
            {
                /// <summary>
                /// BosniaAndHerzegovina Stock Market
                /// </summary>
                public const string StockMarket = "SASX10";
                /// <summary>
                /// BosniaAndHerzegovina Currency
                /// </summary>
                public const string Currency = "USDBIH";
            }
            public static class Botswana
            {
                /// <summary>
                /// Botswana Stock Market
                /// </summary>
                public const string StockMarket = "BGSMDC";
                /// <summary>
                /// Botswana Currency
                /// </summary>
                public const string Currency = "USDBWP";
            }
            public static class Brazil
            {
                /// <summary>
                /// Brazil Cash Reserve Ratio
                /// </summary>
                public const string CashReserveRatio = "BRAZILCASRESRAT";
                /// <summary>
                /// Brazil Interbank Rate
                /// </summary>
                public const string InterbankRate = "BRAZILINTRAT";
                /// <summary>
                /// Brazil Minimum Wages
                /// </summary>
                public const string MinimumWages = "BRAZILMINWAG";
                /// <summary>
                /// Brazil Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GEBU10Y";
                /// <summary>
                /// Brazil Stock Market
                /// </summary>
                public const string StockMarket = "IBOV";
                /// <summary>
                /// Brazil Currency
                /// </summary>
                public const string Currency = "USDBRL";
            }
            public static class Brunei
            {
                /// <summary>
                /// Brunei Currency
                /// </summary>
                public const string Currency = "USDBND";
            }
            public static class Bulgaria
            {
                /// <summary>
                /// Bulgaria Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "BULGARIAGOVBON10Y";
                /// <summary>
                /// Bulgaria Interbank Rate
                /// </summary>
                public const string InterbankRate = "BULGARIAINTRAT";
                /// <summary>
                /// Bulgaria Stock Market
                /// </summary>
                public const string StockMarket = "SOFIX";
                /// <summary>
                /// Bulgaria Currency
                /// </summary>
                public const string Currency = "USDBGN";
            }
            public static class Burundi
            {
                /// <summary>
                /// Burundi Currency
                /// </summary>
                public const string Currency = "USDBIF";
            }
            public static class Cambodia
            {
                /// <summary>
                /// Cambodia Currency
                /// </summary>
                public const string Currency = "USDKHR";
            }
            public static class Canada
            {
                /// <summary>
                /// Canada Bank Lending Rate
                /// </summary>
                public const string BankLendingRate = "CANADABANLENRAT";
                /// <summary>
                /// Canada Interbank Rate
                /// </summary>
                public const string InterbankRate = "CANADAINTRAT";
                /// <summary>
                /// Canada Deposit Interest Rate
                /// </summary>
                public const string DepositInterestRate = "CANFRINRDPST";
                /// <summary>
                /// Canada Interest Rate
                /// </summary>
                public const string InterestRate = "CCLR";
                /// <summary>
                /// Canada Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GCAN10YR";
                /// <summary>
                /// Canada Consumer Confidence
                /// </summary>
                public const string ConsumerConfidence = "OECAI001";
                /// <summary>
                /// Canada Stock Market
                /// </summary>
                public const string StockMarket = "SPTSX";
                /// <summary>
                /// Canada Currency
                /// </summary>
                public const string Currency = "USDCAD";
            }
            public static class CapeVerde
            {
                /// <summary>
                /// CapeVerde Currency
                /// </summary>
                public const string Currency = "USDCVE";
            }
            public static class CaymanIslands
            {
                /// <summary>
                /// CaymanIslands Currency
                /// </summary>
                public const string Currency = "USDKYD";
            }
            public static class Chile
            {
                /// <summary>
                /// Chile Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "CHILEGOVBON10Y";
                /// <summary>
                /// Chile Interbank Rate
                /// </summary>
                public const string InterbankRate = "CHILEINTRAT";
                /// <summary>
                /// Chile Stock Market
                /// </summary>
                public const string StockMarket = "IGPA";
                /// <summary>
                /// Chile Currency
                /// </summary>
                public const string Currency = "USDCLP";
            }
            public static class China
            {
                /// <summary>
                /// China Cash Reserve Ratio
                /// </summary>
                public const string CashReserveRatio = "CHINACASRESRAT";
                /// <summary>
                /// China Interbank Rate
                /// </summary>
                public const string InterbankRate = "CHINAINTRAT";
                /// <summary>
                /// China Reverse Repo Rate
                /// </summary>
                public const string ReverseRepoRate = "CHINAREVREPRAT";
                /// <summary>
                /// China Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GCNY10YR";
                /// <summary>
                /// China Stock Market
                /// </summary>
                public const string StockMarket = "SHCOMP";
                /// <summary>
                /// China Currency
                /// </summary>
                public const string Currency = "USDCNY";
            }
            public static class Colombia
            {
                /// <summary>
                /// Colombia Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "COGR10Y";
                /// <summary>
                /// Colombia Stock Market
                /// </summary>
                public const string StockMarket = "COLCAP";
                /// <summary>
                /// Colombia Interbank Rate
                /// </summary>
                public const string InterbankRate = "COLOMBIAINTRAT";
                /// <summary>
                /// Colombia Currency
                /// </summary>
                public const string Currency = "USDCOP";
            }
            public static class Commodity
            {
                /// <summary>
                /// Commodity Baltic Exchange Dry Index
                /// </summary>
                public const string BalticExchangeDryIndex = "BALTIC";
                /// <summary>
                /// Commodity Beef
                /// </summary>
                public const string Beef = "BEEF";
                /// <summary>
                /// Commodity Bitumen
                /// </summary>
                public const string Bitumen = "BIT";
                /// <summary>
                /// Commodity Corn
                /// </summary>
                public const string Corn = "C-1";
                /// <summary>
                /// Commodity Cocoa
                /// </summary>
                public const string Cocoa = "CC1";
                /// <summary>
                /// Commodity Cheese
                /// </summary>
                public const string Cheese = "CHEESE1";
                /// <summary>
                /// Commodity Crude oil
                /// </summary>
                public const string CrudeOil = "CL1";
                /// <summary>
                /// Commodity Brent crude oil
                /// </summary>
                public const string BrentCrudeOil = "CO1";
                /// <summary>
                /// Commodity Coal
                /// </summary>
                public const string Coal = "COAL";
                /// <summary>
                /// Commodity Cobalt
                /// </summary>
                public const string Cobalt = "COBALT";
                /// <summary>
                /// Commodity CRB Commodity Index
                /// </summary>
                public const string CrbCommodityIndex = "CRB";
                /// <summary>
                /// Commodity Cotton
                /// </summary>
                public const string Cotton = "CT1";
                /// <summary>
                /// Commodity Ethanol
                /// </summary>
                public const string Ethanol = "DL1";
                /// <summary>
                /// Commodity Feeder Cattle
                /// </summary>
                public const string FeederCattle = "FC1";
                /// <summary>
                /// Commodity GSCI Commodity Index
                /// </summary>
                public const string GsciCommodityIndex = "GSCI";
                /// <summary>
                /// Commodity Copper
                /// </summary>
                public const string Copper = "HG1";
                /// <summary>
                /// Commodity Heating oil
                /// </summary>
                public const string HeatingOil = "HO1";
                /// <summary>
                /// Commodity Manganese Ore
                /// </summary>
                public const string ManganeseOre = "IMR";
                /// <summary>
                /// Commodity Iron Ore
                /// </summary>
                public const string IronOre = "IRONORE";
                /// <summary>
                /// Commodity Rubber
                /// </summary>
                public const string Rubber = "JN1";
                /// <summary>
                /// Commodity Orange Juice
                /// </summary>
                public const string OrangeJuice = "JO1";
                /// <summary>
                /// Commodity Coffee
                /// </summary>
                public const string Coffee = "KC1";
                /// <summary>
                /// Commodity Lumber
                /// </summary>
                public const string Lumber = "LB1";
                /// <summary>
                /// Commodity Live Cattle
                /// </summary>
                public const string LiveCattle = "LC1";
                /// <summary>
                /// Commodity Lean Hogs
                /// </summary>
                public const string LeanHogs = "LH1";
                /// <summary>
                /// Commodity Lithium
                /// </summary>
                public const string Lithium = "LITHIUM";
                /// <summary>
                /// Commodity Aluminum
                /// </summary>
                public const string Aluminum = "LMAHDS03";
                /// <summary>
                /// Commodity LME Index
                /// </summary>
                public const string LmeIndex = "LME";
                /// <summary>
                /// Commodity Molybdenum
                /// </summary>
                public const string Molybdenum = "LMMLDS03";
                /// <summary>
                /// Commodity Nickel
                /// </summary>
                public const string Nickel = "LMNIDS03";
                /// <summary>
                /// Commodity Lead
                /// </summary>
                public const string Lead = "LMPBDS03";
                /// <summary>
                /// Commodity Tin
                /// </summary>
                public const string Tin = "LMSNDS03";
                /// <summary>
                /// Commodity Zinc
                /// </summary>
                public const string Zinc = "LMZSDS03";
                /// <summary>
                /// Commodity Milk
                /// </summary>
                public const string Milk = "MILK";
                /// <summary>
                /// Commodity Naphtha
                /// </summary>
                public const string Naphtha = "NAPHTHA";
                /// <summary>
                /// Commodity Natural gas
                /// </summary>
                public const string NaturalGas = "NG1";
                /// <summary>
                /// Commodity Oat
                /// </summary>
                public const string Oat = "O-1";
                /// <summary>
                /// Commodity Wool
                /// </summary>
                public const string Wool = "OL1";
                /// <summary>
                /// Commodity Palm Oil
                /// </summary>
                public const string PalmOil = "PALMOIL";
                /// <summary>
                /// Commodity Propane
                /// </summary>
                public const string Propane = "PROPANE";
                /// <summary>
                /// Commodity RHODIUM
                /// </summary>
                public const string Rhodium = "RHODIUM";
                /// <summary>
                /// Commodity Rice
                /// </summary>
                public const string Rice = "RR1";
                /// <summary>
                /// Commodity Canola
                /// </summary>
                public const string Canola = "RS1";
                /// <summary>
                /// Commodity Soybeans
                /// </summary>
                public const string Soybeans = "S-1";
                /// <summary>
                /// Commodity Sugar
                /// </summary>
                public const string Sugar = "SB1";
                /// <summary>
                /// Commodity Soda Ash
                /// </summary>
                public const string SodaAsh = "SODASH";
                /// <summary>
                /// Commodity Neodymium
                /// </summary>
                public const string Neodymium = "SREMNDM";
                /// <summary>
                /// Commodity Steel
                /// </summary>
                public const string Steel = "STEEL";
                /// <summary>
                /// Commodity Iron Ore 62% FE
                /// </summary>
                public const string IronOre62PercentFe = "TIOC";
                /// <summary>
                /// Commodity Uranium
                /// </summary>
                public const string Uranium = "URANIUM";
                /// <summary>
                /// Commodity Wheat
                /// </summary>
                public const string Wheat = "W-1";
                /// <summary>
                /// Commodity Silver
                /// </summary>
                public const string Silver = "XAGUSD";
                /// <summary>
                /// Commodity Gold
                /// </summary>
                public const string Gold = "XAUUSD";
                /// <summary>
                /// Commodity Gasoline
                /// </summary>
                public const string Gasoline = "XB1";
                /// <summary>
                /// Commodity Palladium
                /// </summary>
                public const string Palladium = "XPDUSD";
                /// <summary>
                /// Commodity Platinum
                /// </summary>
                public const string Platinum = "XPTUSD";
            }
            public static class Comoros
            {
                /// <summary>
                /// Comoros Currency
                /// </summary>
                public const string Currency = "USDKMF";
            }
            public static class Congo
            {
                /// <summary>
                /// Congo Currency
                /// </summary>
                public const string Currency = "USDCDF";
            }
            public static class CostaRica
            {
                /// <summary>
                /// CostaRica Stock Market
                /// </summary>
                public const string StockMarket = "CRSMBCT";
                /// <summary>
                /// CostaRica Currency
                /// </summary>
                public const string Currency = "USDCRC";
            }
            public static class Croatia
            {
                /// <summary>
                /// Croatia Stock Market
                /// </summary>
                public const string StockMarket = "CRO";
                /// <summary>
                /// Croatia Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "CROATIAGOVD10Y";
                /// <summary>
                /// Croatia Interbank Rate
                /// </summary>
                public const string InterbankRate = "CROATIAINTRAT";
                /// <summary>
                /// Croatia Currency
                /// </summary>
                public const string Currency = "USDHRV";
            }
            public static class Cuba
            {
                /// <summary>
                /// Cuba Currency
                /// </summary>
                public const string Currency = "USDCUC";
            }
            public static class Cyprus
            {
                /// <summary>
                /// Cyprus Stock Market
                /// </summary>
                public const string StockMarket = "CYSMMAPA";
            }
            public static class CzechRepublic
            {
                /// <summary>
                /// CzechRepublic Interbank Rate
                /// </summary>
                public const string InterbankRate = "CZECHREPUINTRAT";
                /// <summary>
                /// CzechRepublic Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "CZGB10YR";
                /// <summary>
                /// CzechRepublic Stock Market
                /// </summary>
                public const string StockMarket = "PX";
                /// <summary>
                /// CzechRepublic Currency
                /// </summary>
                public const string Currency = "USDCZK";
            }
            public static class Denmark
            {
                /// <summary>
                /// Denmark Interbank Rate
                /// </summary>
                public const string InterbankRate = "DENMARKINTRAT";
                /// <summary>
                /// Denmark Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GDGB10YR";
                /// <summary>
                /// Denmark Stock Market
                /// </summary>
                public const string StockMarket = "KFX";
                /// <summary>
                /// Denmark Currency
                /// </summary>
                public const string Currency = "USDDKK";
            }
            public static class Djibouti
            {
                /// <summary>
                /// Djibouti Currency
                /// </summary>
                public const string Currency = "USDDJF";
            }
            public static class DominicanRepublic
            {
                /// <summary>
                /// DominicanRepublic Currency
                /// </summary>
                public const string Currency = "USDDOP";
            }
            public static class Ecuador
            {
                /// <summary>
                /// Ecuador Stock Market
                /// </summary>
                public const string StockMarket = "ECU";
                /// <summary>
                /// Ecuador Interbank Rate
                /// </summary>
                public const string InterbankRate = "ECUADORINTRATI";
            }
            public static class Egypt
            {
                /// <summary>
                /// Egypt Stock Market
                /// </summary>
                public const string StockMarket = "CASE";
                /// <summary>
                /// Egypt Interbank Rate
                /// </summary>
                public const string InterbankRate = "EGYPTINTRAT";
                /// <summary>
                /// Egypt Interest Rate
                /// </summary>
                public const string InterestRate = "EGYPTINTRATE";
                /// <summary>
                /// Egypt Lending Rate
                /// </summary>
                public const string LendingRate = "EGYPTLENRAT";
                /// <summary>
                /// Egypt Currency
                /// </summary>
                public const string Currency = "USDEGP";
            }
            public static class Eritrea
            {
                /// <summary>
                /// Eritrea Currency
                /// </summary>
                public const string Currency = "USDERN";
            }
            public static class Estonia
            {
                /// <summary>
                /// Estonia Stock Market
                /// </summary>
                public const string StockMarket = "TALSE";
            }
            public static class Ethiopia
            {
                /// <summary>
                /// Ethiopia Currency
                /// </summary>
                public const string Currency = "USDETB";
            }
            public static class EuroArea
            {
                /// <summary>
                /// EuroArea Interbank Rate
                /// </summary>
                public const string InterbankRate = "EMUEVOLVINTRAT";
                /// <summary>
                /// EuroArea Lending Rate
                /// </summary>
                public const string LendingRate = "EUROAREALENRAT";
                /// <summary>
                /// EuroArea Zew Economic Sentiment Index
                /// </summary>
                public const string ZewEconomicSentimentIndex = "EUROAREAZEWECOSENIND";
                /// <summary>
                /// EuroArea Stock Market
                /// </summary>
                public const string StockMarket = "SX5E";
            }
            public static class Fiji
            {
                /// <summary>
                /// Fiji Currency
                /// </summary>
                public const string Currency = "USDFJD";
            }
            public static class Finland
            {
                /// <summary>
                /// Finland Interbank Rate
                /// </summary>
                public const string InterbankRate = "FINLANDINTRAT";
                /// <summary>
                /// Finland Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GFIN10YR";
                /// <summary>
                /// Finland Stock Market
                /// </summary>
                public const string StockMarket = "HEX25";
            }
            public static class France
            {
                /// <summary>
                /// France Stock Market
                /// </summary>
                public const string StockMarket = "CAC";
                /// <summary>
                /// France Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GFRN10";
            }
            public static class Gambia
            {
                /// <summary>
                /// Gambia Currency
                /// </summary>
                public const string Currency = "USDGMD";
            }
            public static class Georgia
            {
                /// <summary>
                /// Georgia Currency
                /// </summary>
                public const string Currency = "USDGEL";
            }
            public static class Germany
            {
                /// <summary>
                /// Germany Stock Market
                /// </summary>
                public const string StockMarket = "DAX";
                /// <summary>
                /// Germany Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GDBR10";
                /// <summary>
                /// Germany 2 Year Note Yield
                /// </summary>
                public const string TwoYearNoteYield = "GERMANY2YNY";
                /// <summary>
                /// Germany Zew Economic Sentiment Index
                /// </summary>
                public const string ZewEconomicSentimentIndex = "GERMANYZEWECOSENIND";
                /// <summary>
                /// Germany Consumer Confidence
                /// </summary>
                public const string ConsumerConfidence = "GRCCI";
            }
            public static class Ghana
            {
                /// <summary>
                /// Ghana Stock Market
                /// </summary>
                public const string StockMarket = "GGSECI";
                /// <summary>
                /// Ghana Currency
                /// </summary>
                public const string Currency = "USDGHS";
            }
            public static class Greece
            {
                /// <summary>
                /// Greece Stock Market
                /// </summary>
                public const string StockMarket = "ASE";
                /// <summary>
                /// Greece Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GGGB10YR";
                /// <summary>
                /// Greece 2 Year Note Yield
                /// </summary>
                public const string TwoYearNoteYield = "GREECE2YNY";
            }
            public static class Guatemala
            {
                /// <summary>
                /// Guatemala Currency
                /// </summary>
                public const string Currency = "USDGTQ";
            }
            public static class Guinea
            {
                /// <summary>
                /// Guinea Currency
                /// </summary>
                public const string Currency = "USDGNF";
            }
            public static class Guyana
            {
                /// <summary>
                /// Guyana Currency
                /// </summary>
                public const string Currency = "USDGYD";
            }
            public static class Haiti
            {
                /// <summary>
                /// Haiti Currency
                /// </summary>
                public const string Currency = "USDHTG";
            }
            public static class Honduras
            {
                /// <summary>
                /// Honduras Interest Rate
                /// </summary>
                public const string InterestRate = "HONURASINTTRATE";
                /// <summary>
                /// Honduras Currency
                /// </summary>
                public const string Currency = "USDHNL";
            }
            public static class HongKong
            {
                /// <summary>
                /// HongKong Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GHKGB10Y";
                /// <summary>
                /// HongKong Interbank Rate
                /// </summary>
                public const string InterbankRate = "HONGKONGINTRAT";
                /// <summary>
                /// HongKong Stock Market
                /// </summary>
                public const string StockMarket = "HSI";
                /// <summary>
                /// HongKong Currency
                /// </summary>
                public const string Currency = "USDHKD";
            }
            public static class Hungary
            {
                /// <summary>
                /// Hungary Stock Market
                /// </summary>
                public const string StockMarket = "BUX";
                /// <summary>
                /// Hungary Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GHGB10YR";
                /// <summary>
                /// Hungary Interbank Rate
                /// </summary>
                public const string InterbankRate = "HUNGARYINTRAT";
                /// <summary>
                /// Hungary Currency
                /// </summary>
                public const string Currency = "USDHUF";
            }
            public static class Iceland
            {
                /// <summary>
                /// Iceland Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "ICELANDGOVBON10Y";
                /// <summary>
                /// Iceland Interbank Rate
                /// </summary>
                public const string InterbankRate = "ICELANDINTRAT";
                /// <summary>
                /// Iceland Stock Market
                /// </summary>
                public const string StockMarket = "ICEXI";
                /// <summary>
                /// Iceland Currency
                /// </summary>
                public const string Currency = "USDISK";
            }
            public static class India
            {
                /// <summary>
                /// India Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GIND10YR";
                /// <summary>
                /// India Cash Reserve Ratio
                /// </summary>
                public const string CashReserveRatio = "INDIACASRESRAT";
                /// <summary>
                /// India Interest Rate
                /// </summary>
                public const string InterestRate = "RSPOYLD";
                /// <summary>
                /// India Stock Market
                /// </summary>
                public const string StockMarket = "SENSEX";
                /// <summary>
                /// India Currency
                /// </summary>
                public const string Currency = "USDINR";
            }
            public static class Indonesia
            {
                /// <summary>
                /// Indonesia Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GIDN10YR";
                /// <summary>
                /// Indonesia Interbank Rate
                /// </summary>
                public const string InterbankRate = "INDONESIAINTRAT";
                /// <summary>
                /// Indonesia Stock Market
                /// </summary>
                public const string StockMarket = "JCI";
                /// <summary>
                /// Indonesia Currency
                /// </summary>
                public const string Currency = "USDIDR";
            }
            public static class Iraq
            {
                /// <summary>
                /// Iraq Currency
                /// </summary>
                public const string Currency = "USDIQD";
            }
            public static class Ireland
            {
                /// <summary>
                /// Ireland Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GIGB10YR";
                /// <summary>
                /// Ireland Stock Market
                /// </summary>
                public const string StockMarket = "ISEQ";
            }
            public static class Israel
            {
                /// <summary>
                /// Israel Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GISR10YR";
                /// <summary>
                /// Israel Interest Rate
                /// </summary>
                public const string InterestRate = "ISBRATE";
                /// <summary>
                /// Israel Interbank Rate
                /// </summary>
                public const string InterbankRate = "ISRAELINTRAT";
                /// <summary>
                /// Israel Stock Market
                /// </summary>
                public const string StockMarket = "TA-100";
                /// <summary>
                /// Israel Currency
                /// </summary>
                public const string Currency = "USDILS";
            }
            public static class Italy
            {
                /// <summary>
                /// Italy Stock Market
                /// </summary>
                public const string StockMarket = "FTSEMIB";
                /// <summary>
                /// Italy Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GBTPGR10";
                /// <summary>
                /// Italy 2 Year Note Yield
                /// </summary>
                public const string TwoYearNoteYield = "ITALY2YNY";
            }
            public static class IvoryCoast
            {
                /// <summary>
                /// IvoryCoast Currency
                /// </summary>
                public const string Currency = "USDXOF";
            }
            public static class Jamaica
            {
                /// <summary>
                /// Jamaica Interest Rate
                /// </summary>
                public const string InterestRate = "JAMAICAINTTRATE";
                /// <summary>
                /// Jamaica Stock Market
                /// </summary>
                public const string StockMarket = "JMSMX";
                /// <summary>
                /// Jamaica Currency
                /// </summary>
                public const string Currency = "USDJMD";
            }
            public static class Japan
            {
                /// <summary>
                /// Japan Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GJGB10";
                /// <summary>
                /// Japan 2 Year Note Yield
                /// </summary>
                public const string TwoYearNoteYield = "JAPAN2YNY";
                /// <summary>
                /// Japan Interbank Rate
                /// </summary>
                public const string InterbankRate = "JAPANINTRAT";
                /// <summary>
                /// Japan Deposit Interest Rate
                /// </summary>
                public const string DepositInterestRate = "JPNFRINRDPST";
                /// <summary>
                /// Japan Stock Market
                /// </summary>
                public const string StockMarket = "NKY";
                /// <summary>
                /// Japan Currency
                /// </summary>
                public const string Currency = "USDJPY";
            }
            public static class Jordan
            {
                /// <summary>
                /// Jordan Stock Market
                /// </summary>
                public const string StockMarket = "JOSMGNFF";
                /// <summary>
                /// Jordan Currency
                /// </summary>
                public const string Currency = "USDJOR";
            }
            public static class Kazakhstan
            {
                /// <summary>
                /// Kazakhstan Interbank Rate
                /// </summary>
                public const string InterbankRate = "KAZAKHSTANINTRAT";
                /// <summary>
                /// Kazakhstan Interest Rate
                /// </summary>
                public const string InterestRate = "KAZAKHSTANINTRATE";
                /// <summary>
                /// Kazakhstan Stock Market
                /// </summary>
                public const string StockMarket = "KZKAK";
                /// <summary>
                /// Kazakhstan Currency
                /// </summary>
                public const string Currency = "USDKZT";
            }
            public static class Kenya
            {
                /// <summary>
                /// Kenya Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "KENYAGOVBON10Y";
                /// <summary>
                /// Kenya Stock Market
                /// </summary>
                public const string StockMarket = "KNSMIDX";
                /// <summary>
                /// Kenya Currency
                /// </summary>
                public const string Currency = "USDKES";
            }
            public static class Kuwait
            {
                /// <summary>
                /// Kuwait Interbank Rate
                /// </summary>
                public const string InterbankRate = "KUWAITINTRAT";
                /// <summary>
                /// Kuwait Currency
                /// </summary>
                public const string Currency = "USDKWD";
            }
            public static class Kyrgyzstan
            {
                /// <summary>
                /// Kyrgyzstan Interest Rate
                /// </summary>
                public const string InterestRate = "KYRSTANINTTRATE";
                /// <summary>
                /// Kyrgyzstan Currency
                /// </summary>
                public const string Currency = "USDKGS";
            }
            public static class Laos
            {
                /// <summary>
                /// Laos Stock Market
                /// </summary>
                public const string StockMarket = "LSXC";
                /// <summary>
                /// Laos Currency
                /// </summary>
                public const string Currency = "USDLAK";
            }
            public static class Latvia
            {
                /// <summary>
                /// Latvia Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "LATVIAGOVBON10Y";
                /// <summary>
                /// Latvia Interbank Rate
                /// </summary>
                public const string InterbankRate = "LATVIAINTRAT";
                /// <summary>
                /// Latvia Stock Market
                /// </summary>
                public const string StockMarket = "RIGSE";
            }
            public static class Lebanon
            {
                /// <summary>
                /// Lebanon Stock Market
                /// </summary>
                public const string StockMarket = "BLOM";
                /// <summary>
                /// Lebanon Currency
                /// </summary>
                public const string Currency = "USDLBP";
            }
            public static class Lesotho
            {
                /// <summary>
                /// Lesotho Currency
                /// </summary>
                public const string Currency = "USDLSL";
            }
            public static class Liberia
            {
                /// <summary>
                /// Liberia Currency
                /// </summary>
                public const string Currency = "USDLRD";
            }
            public static class Libya
            {
                /// <summary>
                /// Libya Currency
                /// </summary>
                public const string Currency = "USDLYD";
            }
            public static class Lithuania
            {
                /// <summary>
                /// Lithuania Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "LITHUANIAGOVBON10Y";
                /// <summary>
                /// Lithuania Stock Market
                /// </summary>
                public const string StockMarket = "VILSE";
            }
            public static class Luxembourg
            {
                /// <summary>
                /// Luxembourg Stock Market
                /// </summary>
                public const string StockMarket = "LUXXX";
            }
            public static class Macau
            {
                /// <summary>
                /// Macau Interbank Rate
                /// </summary>
                public const string InterbankRate = "MACAOINTRAT";
                /// <summary>
                /// Macau Currency
                /// </summary>
                public const string Currency = "USDMOP";
            }
            public static class Macedonia
            {
                /// <summary>
                /// Macedonia Stock Market
                /// </summary>
                public const string StockMarket = "MBI";
                /// <summary>
                /// Macedonia Currency
                /// </summary>
                public const string Currency = "USDMKD";
            }
            public static class Madagascar
            {
                /// <summary>
                /// Madagascar Currency
                /// </summary>
                public const string Currency = "USDMGA";
            }
            public static class Malawi
            {
                /// <summary>
                /// Malawi Currency
                /// </summary>
                public const string Currency = "USDMWK";
            }
            public static class Malaysia
            {
                /// <summary>
                /// Malaysia Stock Market
                /// </summary>
                public const string StockMarket = "FBMKLCI";
                /// <summary>
                /// Malaysia Interbank Rate
                /// </summary>
                public const string InterbankRate = "MALAYSIAINTRAT";
                /// <summary>
                /// Malaysia Interest Rate
                /// </summary>
                public const string InterestRate = "MAOPRATE";
                /// <summary>
                /// Malaysia Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "MGIY10Y";
                /// <summary>
                /// Malaysia Currency
                /// </summary>
                public const string Currency = "USDMYR";
            }
            public static class Maldives
            {
                /// <summary>
                /// Maldives Currency
                /// </summary>
                public const string Currency = "USDMVR";
            }
            public static class Malta
            {
                /// <summary>
                /// Malta Stock Market
                /// </summary>
                public const string StockMarket = "MALTEX";
            }
            public static class Mauritius
            {
                /// <summary>
                /// Mauritius Stock Market
                /// </summary>
                public const string StockMarket = "SEMDEX";
                /// <summary>
                /// Mauritius Currency
                /// </summary>
                public const string Currency = "USDMUR";
            }
            public static class Mexico
            {
                /// <summary>
                /// Mexico Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GMXN10YR";
                /// <summary>
                /// Mexico Stock Market
                /// </summary>
                public const string StockMarket = "MEXBOL";
                /// <summary>
                /// Mexico Interest Rate
                /// </summary>
                public const string InterestRate = "MXONBR";
                /// <summary>
                /// Mexico Currency
                /// </summary>
                public const string Currency = "USDMXN";
            }
            public static class Moldova
            {
                /// <summary>
                /// Moldova Currency
                /// </summary>
                public const string Currency = "USDMDL";
            }
            public static class Mongolia
            {
                /// <summary>
                /// Mongolia Stock Market
                /// </summary>
                public const string StockMarket = "MSETOP";
                /// <summary>
                /// Mongolia Currency
                /// </summary>
                public const string Currency = "USDMNT";
            }
            public static class Morocco
            {
                /// <summary>
                /// Morocco Stock Market
                /// </summary>
                public const string StockMarket = "MOSENEW";
                /// <summary>
                /// Morocco Currency
                /// </summary>
                public const string Currency = "USDMAD";
            }
            public static class Mozambique
            {
                /// <summary>
                /// Mozambique Currency
                /// </summary>
                public const string Currency = "USDMZN";
            }
            public static class Myanmar
            {
                /// <summary>
                /// Myanmar Currency
                /// </summary>
                public const string Currency = "USDMMK";
            }
            public static class Namibia
            {
                /// <summary>
                /// Namibia Stock Market
                /// </summary>
                public const string StockMarket = "FTN098";
                /// <summary>
                /// Namibia Currency
                /// </summary>
                public const string Currency = "USDNAD";
            }
            public static class Nepal
            {
                /// <summary>
                /// Nepal Currency
                /// </summary>
                public const string Currency = "USDNPR";
            }
            public static class Netherlands
            {
                /// <summary>
                /// Netherlands Stock Market
                /// </summary>
                public const string StockMarket = "AEX";
                /// <summary>
                /// Netherlands Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GNTH10YR";
            }
            public static class NewCaledonia
            {
                /// <summary>
                /// NewCaledonia Currency
                /// </summary>
                public const string Currency = "USDXPF";
            }
            public static class NewZealand
            {
                /// <summary>
                /// NewZealand Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GNZGB10";
                /// <summary>
                /// NewZealand Global Dairy Trade Price Index
                /// </summary>
                public const string GlobalDairyTradePriceIndex = "NEWZEALANGDTPI";
                /// <summary>
                /// NewZealand Currency
                /// </summary>
                public const string Currency = "NZDUSD";
                /// <summary>
                /// NewZealand Deposit Interest Rate
                /// </summary>
                public const string DepositInterestRate = "NZLFRINRDPST";
                /// <summary>
                /// NewZealand Interest Rate
                /// </summary>
                public const string InterestRate = "NZOCRS";
                /// <summary>
                /// NewZealand Stock Market
                /// </summary>
                public const string StockMarket = "NZSE50FG";
            }
            public static class Nicaragua
            {
                /// <summary>
                /// Nicaragua Currency
                /// </summary>
                public const string Currency = "USDNIO";
            }
            public static class Nigeria
            {
                /// <summary>
                /// Nigeria Stock Market
                /// </summary>
                public const string StockMarket = "NGSEINDX";
                /// <summary>
                /// Nigeria Cash Reserve Ratio
                /// </summary>
                public const string CashReserveRatio = "NIGERIACASRESRAT";
                /// <summary>
                /// Nigeria Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "NIGERIAGOVBON10Y";
                /// <summary>
                /// Nigeria Interbank Rate
                /// </summary>
                public const string InterbankRate = "NIGERIAINTRAT";
                /// <summary>
                /// Nigeria Currency
                /// </summary>
                public const string Currency = "USDNGN";
            }
            public static class NorthKorea
            {
                /// <summary>
                /// NorthKorea Currency
                /// </summary>
                public const string Currency = "NORTHKORECUR";
            }
            public static class Norway
            {
                /// <summary>
                /// Norway Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GNOR10YR";
                /// <summary>
                /// Norway Interbank Rate
                /// </summary>
                public const string InterbankRate = "NORWAYINTRAT";
                /// <summary>
                /// Norway Stock Market
                /// </summary>
                public const string StockMarket = "OSEAX";
                /// <summary>
                /// Norway Currency
                /// </summary>
                public const string Currency = "USDNOK";
            }
            public static class Oman
            {
                /// <summary>
                /// Oman Stock Market
                /// </summary>
                public const string StockMarket = "MSM30";
                /// <summary>
                /// Oman Currency
                /// </summary>
                public const string Currency = "USDOMR";
            }
            public static class Pakistan
            {
                /// <summary>
                /// Pakistan Stock Market
                /// </summary>
                public const string StockMarket = "KSE100";
                /// <summary>
                /// Pakistan Interest Rate
                /// </summary>
                public const string InterestRate = "PAPRSBP";
                /// <summary>
                /// Pakistan Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "PKIB10YR";
                /// <summary>
                /// Pakistan Currency
                /// </summary>
                public const string Currency = "USDPKR";
            }
            public static class Panama
            {
                /// <summary>
                /// Panama Stock Market
                /// </summary>
                public const string StockMarket = "BVPSBVPS";
                /// <summary>
                /// Panama Currency
                /// </summary>
                public const string Currency = "USDPAB";
            }
            public static class PapuaNewGuinea
            {
                /// <summary>
                /// PapuaNewGuinea Currency
                /// </summary>
                public const string Currency = "USDPGK";
            }
            public static class Paraguay
            {
                /// <summary>
                /// Paraguay Currency
                /// </summary>
                public const string Currency = "USDPYG";
            }
            public static class Peru
            {
                /// <summary>
                /// Peru Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GRPE10Y";
                /// <summary>
                /// Peru Stock Market
                /// </summary>
                public const string StockMarket = "IGBVL";
                /// <summary>
                /// Peru Interbank Rate
                /// </summary>
                public const string InterbankRate = "PERUINTRAT";
                /// <summary>
                /// Peru Interest Rate
                /// </summary>
                public const string InterestRate = "PRRRONUS";
                /// <summary>
                /// Peru Currency
                /// </summary>
                public const string Currency = "USDPEN";
            }
            public static class Philippines
            {
                /// <summary>
                /// Philippines Stock Market
                /// </summary>
                public const string StockMarket = "PCOMP";
                /// <summary>
                /// Philippines Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "PHILIPPINEGOVBON10Y";
                /// <summary>
                /// Philippines Interbank Rate
                /// </summary>
                public const string InterbankRate = "PHILIPPINEINTRAT";
                /// <summary>
                /// Philippines Interest Rate
                /// </summary>
                public const string InterestRate = "PHILIPPINESINTRATE";
                /// <summary>
                /// Philippines Currency
                /// </summary>
                public const string Currency = "USDPHP";
            }
            public static class Poland
            {
                /// <summary>
                /// Poland Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "POGB10YR";
                /// <summary>
                /// Poland Interbank Rate
                /// </summary>
                public const string InterbankRate = "POLANDINTRAT";
                /// <summary>
                /// Poland Deposit Interest Rate
                /// </summary>
                public const string DepositInterestRate = "POLFRINRDPST";
                /// <summary>
                /// Poland Currency
                /// </summary>
                public const string Currency = "USDPLN";
                /// <summary>
                /// Poland Stock Market
                /// </summary>
                public const string StockMarket = "WIG";
            }
            public static class Portugal
            {
                /// <summary>
                /// Portugal Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GSPT10YR";
                /// <summary>
                /// Portugal 2 Year Note Yield
                /// </summary>
                public const string TwoYearNoteYield = "PORTUGAL2YNY";
                /// <summary>
                /// Portugal Stock Market
                /// </summary>
                public const string StockMarket = "PSI20";
            }
            public static class Qatar
            {
                /// <summary>
                /// Qatar Stock Market
                /// </summary>
                public const string StockMarket = "DSM";
                /// <summary>
                /// Qatar Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "QATARGOVBON10Y";
                /// <summary>
                /// Qatar Reverse Repo Rate
                /// </summary>
                public const string ReverseRepoRate = "QATARREVREPRAT";
                /// <summary>
                /// Qatar Currency
                /// </summary>
                public const string Currency = "USDQAR";
            }
            public static class Romania
            {
                /// <summary>
                /// Romania Stock Market
                /// </summary>
                public const string StockMarket = "BET";
                /// <summary>
                /// Romania Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "ROMANIAGOVBON10Y";
                /// <summary>
                /// Romania Interbank Rate
                /// </summary>
                public const string InterbankRate = "ROMANIAINTRAT";
                /// <summary>
                /// Romania Currency
                /// </summary>
                public const string Currency = "USDRON";
            }
            public static class Russia
            {
                /// <summary>
                /// Russia Stock Market
                /// </summary>
                public const string StockMarket = "INDEXCF";
                /// <summary>
                /// Russia Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "RUGE10Y";
                /// <summary>
                /// Russia Central Bank Balance Sheet
                /// </summary>
                public const string CentralBankBalanceSheet = "RUSSIACENBANBALSHE";
                /// <summary>
                /// Russia Currency
                /// </summary>
                public const string Currency = "USDRUB";
            }
            public static class Rwanda
            {
                /// <summary>
                /// Rwanda Currency
                /// </summary>
                public const string Currency = "USDRWF";
            }
            public static class SaoTomeAndPrincipe
            {
                /// <summary>
                /// SaoTomeAndPrincipe Currency
                /// </summary>
                public const string Currency = "USDSTD";
            }
            public static class SaudiArabia
            {
                /// <summary>
                /// SaudiArabia Stock Market
                /// </summary>
                public const string StockMarket = "SASEIDX";
                /// <summary>
                /// SaudiArabia Reverse Repo Rate
                /// </summary>
                public const string ReverseRepoRate = "SAUDIARABREVREPRAT";
                /// <summary>
                /// SaudiArabia Deposit Interest Rate
                /// </summary>
                public const string DepositInterestRate = "SAUFRINRDPST";
                /// <summary>
                /// SaudiArabia Currency
                /// </summary>
                public const string Currency = "USDSAR";
            }
            public static class Serbia
            {
                /// <summary>
                /// Serbia Stock Market
                /// </summary>
                public const string StockMarket = "BELEX15";
                /// <summary>
                /// Serbia Interbank Rate
                /// </summary>
                public const string InterbankRate = "SERBIAINTRAT";
                /// <summary>
                /// Serbia Interest Rate
                /// </summary>
                public const string InterestRate = "SERRBIAINTTRATE";
                /// <summary>
                /// Serbia Deposit Interest Rate
                /// </summary>
                public const string DepositInterestRate = "SRBFRINRDPST";
                /// <summary>
                /// Serbia Currency
                /// </summary>
                public const string Currency = "USDSRB";
            }
            public static class Seychelles
            {
                /// <summary>
                /// Seychelles Currency
                /// </summary>
                public const string Currency = "USDSCR";
            }
            public static class SierraLeone
            {
                /// <summary>
                /// SierraLeone Currency
                /// </summary>
                public const string Currency = "USDSLL";
            }
            public static class Singapore
            {
                /// <summary>
                /// Singapore Stock Market
                /// </summary>
                public const string StockMarket = "FSSTI";
                /// <summary>
                /// Singapore Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "MASB10Y";
                /// <summary>
                /// Singapore Interbank Rate
                /// </summary>
                public const string InterbankRate = "SINGAPOREINTRAT";
                /// <summary>
                /// Singapore Currency
                /// </summary>
                public const string Currency = "USDSGD";
            }
            public static class Slovakia
            {
                /// <summary>
                /// Slovakia Stock Market
                /// </summary>
                public const string StockMarket = "SKSM";
                /// <summary>
                /// Slovakia Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "SLOVAKIAGOVBON10Y";
            }
            public static class Slovenia
            {
                /// <summary>
                /// Slovenia Stock Market
                /// </summary>
                public const string StockMarket = "SBITOP";
                /// <summary>
                /// Slovenia Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "SLOVENIAGOVBON10Y";
            }
            public static class Somalia
            {
                /// <summary>
                /// Somalia Currency
                /// </summary>
                public const string Currency = "USDSOS";
            }
            public static class SouthAfrica
            {
                /// <summary>
                /// SouthAfrica Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GSAB10YR";
                /// <summary>
                /// SouthAfrica Stock Market
                /// </summary>
                public const string StockMarket = "JALSH";
                /// <summary>
                /// SouthAfrica Interbank Rate
                /// </summary>
                public const string InterbankRate = "SOUTHAFRIINTRAT";
                /// <summary>
                /// SouthAfrica Currency
                /// </summary>
                public const string Currency = "USDZAR";
            }
            public static class SouthKorea
            {
                /// <summary>
                /// SouthKorea Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GVSK10YR";
                /// <summary>
                /// SouthKorea Stock Market
                /// </summary>
                public const string StockMarket = "KOSPI";
                /// <summary>
                /// SouthKorea Interbank Rate
                /// </summary>
                public const string InterbankRate = "SOUTHKOREINTRAT";
                /// <summary>
                /// SouthKorea Currency
                /// </summary>
                public const string Currency = "USDKRW";
            }
            public static class Spain
            {
                /// <summary>
                /// Spain Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GSPG10YR";
                /// <summary>
                /// Spain Stock Market
                /// </summary>
                public const string StockMarket = "IBEX";
                /// <summary>
                /// Spain Interbank Rate
                /// </summary>
                public const string InterbankRate = "SPAININTRAT";
            }
            public static class SriLanka
            {
                /// <summary>
                /// SriLanka Stock Market
                /// </summary>
                public const string StockMarket = "CSEALL";
                /// <summary>
                /// SriLanka Interest Rate
                /// </summary>
                public const string InterestRate = "SRI-LANKAINTRATE";
                /// <summary>
                /// SriLanka Cash Reserve Ratio
                /// </summary>
                public const string CashReserveRatio = "SRILANKACASRESRAT";
                /// <summary>
                /// SriLanka Interbank Rate
                /// </summary>
                public const string InterbankRate = "SRILANKAINTRAT";
                /// <summary>
                /// SriLanka Lending Rate
                /// </summary>
                public const string LendingRate = "SRILANKALENRAT";
                /// <summary>
                /// SriLanka Currency
                /// </summary>
                public const string Currency = "USDLKR";
            }
            public static class Sudan
            {
                /// <summary>
                /// Sudan Currency
                /// </summary>
                public const string Currency = "USDSDG";
            }
            public static class Suriname
            {
                /// <summary>
                /// Suriname Currency
                /// </summary>
                public const string Currency = "USDSRD";
            }
            public static class Swaziland
            {
                /// <summary>
                /// Swaziland Currency
                /// </summary>
                public const string Currency = "USDSZL";
            }
            public static class Sweden
            {
                /// <summary>
                /// Sweden Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GSGB10YR";
                /// <summary>
                /// Sweden Stock Market
                /// </summary>
                public const string StockMarket = "OMX";
                /// <summary>
                /// Sweden Interbank Rate
                /// </summary>
                public const string InterbankRate = "SWEDENINTRAT";
                /// <summary>
                /// Sweden Currency
                /// </summary>
                public const string Currency = "USDSEK";
            }
            public static class Switzerland
            {
                /// <summary>
                /// Switzerland Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GSWISS10";
                /// <summary>
                /// Switzerland Stock Market
                /// </summary>
                public const string StockMarket = "SMI";
                /// <summary>
                /// Switzerland Interbank Rate
                /// </summary>
                public const string InterbankRate = "SWITZERLANINTRAT";
                /// <summary>
                /// Switzerland Currency
                /// </summary>
                public const string Currency = "USDCHF";
            }
            public static class Syria
            {
                /// <summary>
                /// Syria Currency
                /// </summary>
                public const string Currency = "USDSYP";
            }
            public static class Taiwan
            {
                /// <summary>
                /// Taiwan Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "TAIWANGOVBON10Y";
                /// <summary>
                /// Taiwan Interbank Rate
                /// </summary>
                public const string InterbankRate = "TAIWANINTRAT";
                /// <summary>
                /// Taiwan Interest Rate
                /// </summary>
                public const string InterestRate = "TAIWANIR";
                /// <summary>
                /// Taiwan Stock Market
                /// </summary>
                public const string StockMarket = "TWSE";
                /// <summary>
                /// Taiwan Currency
                /// </summary>
                public const string Currency = "USDTWD";
            }
            public static class Tajikistan
            {
                /// <summary>
                /// Tajikistan Currency
                /// </summary>
                public const string Currency = "USDTJS";
            }
            public static class Tanzania
            {
                /// <summary>
                /// Tanzania Stock Market
                /// </summary>
                public const string StockMarket = "DARSDSEI";
                /// <summary>
                /// Tanzania Currency
                /// </summary>
                public const string Currency = "USDTZS";
            }
            public static class Thailand
            {
                /// <summary>
                /// Thailand Interest Rate
                /// </summary>
                public const string InterestRate = "BTRR1DAY";
                /// <summary>
                /// Thailand Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GVTL10YR";
                /// <summary>
                /// Thailand Stock Market
                /// </summary>
                public const string StockMarket = "SET50";
                /// <summary>
                /// Thailand Interbank Rate
                /// </summary>
                public const string InterbankRate = "THAILANDINTRAT";
                /// <summary>
                /// Thailand Currency
                /// </summary>
                public const string Currency = "USDTHB";
            }
            public static class TrinidadAndTobago
            {
                /// <summary>
                /// TrinidadAndTobago Currency
                /// </summary>
                public const string Currency = "USDTTD";
            }
            public static class Tunisia
            {
                /// <summary>
                /// Tunisia Stock Market
                /// </summary>
                public const string StockMarket = "TUSISE";
                /// <summary>
                /// Tunisia Currency
                /// </summary>
                public const string Currency = "USDTND";
            }
            public static class Turkey
            {
                /// <summary>
                /// Turkey Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "TURKEYGOVBON10Y";
                /// <summary>
                /// Turkey Interbank Rate
                /// </summary>
                public const string InterbankRate = "TURKEYINTRAT";
                /// <summary>
                /// Turkey Currency
                /// </summary>
                public const string Currency = "USDTRY";
                /// <summary>
                /// Turkey Stock Market
                /// </summary>
                public const string StockMarket = "XU100";
            }
            public static class Turkmenistan
            {
                /// <summary>
                /// Turkmenistan Currency
                /// </summary>
                public const string Currency = "USDTMT";
            }
            public static class Uganda
            {
                /// <summary>
                /// Uganda Currency
                /// </summary>
                public const string Currency = "USDUGX";
            }
            public static class Ukraine
            {
                /// <summary>
                /// Ukraine Stock Market
                /// </summary>
                public const string StockMarket = "PFTS";
                /// <summary>
                /// Ukraine Interbank Rate
                /// </summary>
                public const string InterbankRate = "UKRAINEINTRAT";
                /// <summary>
                /// Ukraine Currency
                /// </summary>
                public const string Currency = "USDUAH";
            }
            public static class UnitedArabEmirates
            {
                /// <summary>
                /// UnitedArabEmirates Stock Market
                /// </summary>
                public const string StockMarket = "ADSMI";
                /// <summary>
                /// UnitedArabEmirates Interbank Rate
                /// </summary>
                public const string InterbankRate = "UNITEDARAINTRAT";
                /// <summary>
                /// UnitedArabEmirates Currency
                /// </summary>
                public const string Currency = "USDAED";
            }
            public static class UnitedKingdom
            {
                /// <summary>
                /// UnitedKingdom Currency
                /// </summary>
                public const string Currency = "GBPUSD";
                /// <summary>
                /// UnitedKingdom Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "GUKG10";
                /// <summary>
                /// UnitedKingdom Stock Market
                /// </summary>
                public const string StockMarket = "UKX";
                /// <summary>
                /// UnitedKingdom 2 Year Note Yield
                /// </summary>
                public const string TwoYearNoteYield = "UNITEDKIN2YNY";
                /// <summary>
                /// UnitedKingdom Interbank Rate
                /// </summary>
                public const string InterbankRate = "UNITEDKININTRAT";
            }
            public static class UnitedStates
            {
                /// <summary>
                /// UnitedStates Currency
                /// </summary>
                public const string Currency = "DXY";
                /// <summary>
                /// UnitedStates Interest Rate
                /// </summary>
                public const string InterestRate = "FDTR";
                /// <summary>
                /// UnitedStates Stock Market
                /// </summary>
                public const string StockMarket = "INDU";
                /// <summary>
                /// UnitedStates 2 Year Note Yield
                /// </summary>
                public const string TwoYearNoteYield = "UNITEDSTA2YEANOTYIE";
                /// <summary>
                /// UnitedStates Economic Optimism Index
                /// </summary>
                public const string EconomicOptimismIndex = "UNITEDSTAECOOPTIND";
                /// <summary>
                /// UnitedStates Foreign Direct Investment
                /// </summary>
                public const string ForeignDirectInvestment = "UNITEDSTAFORDIRINV";
                /// <summary>
                /// UnitedStates Interbank Rate
                /// </summary>
                public const string InterbankRate = "UNITEDSTAINTRAT";
                /// <summary>
                /// UnitedStates Nahb Housing Market Index
                /// </summary>
                public const string NahbHousingMarketIndex = "UNITEDSTANAHHOUMARIN";
                /// <summary>
                /// UnitedStates NY Empire State Manufacturing Index
                /// </summary>
                public const string NyEmpireStateManufacturingIndex = "UNITEDSTANYEMPSTAMAN";
                /// <summary>
                /// UnitedStates Redbook Index
                /// </summary>
                public const string RedbookIndex = "UNITEDSTAREDIND";
                /// <summary>
                /// UnitedStates Government Bond 10Y
                /// </summary>
                public const string GovernmentBond10y = "USGG10YR";
                /// <summary>
                /// UnitedStates Crude Oil Rigs
                /// </summary>
                public const string CrudeOilRigs = "USOILRIGS";
            }
            public static class Uruguay
            {
                /// <summary>
                /// Uruguay Currency
                /// </summary>
                public const string Currency = "USDURY";
            }
            public static class Uzbekistan
            {
                /// <summary>
                /// Uzbekistan Currency
                /// </summary>
                public const string Currency = "USDUZS";
            }
            public static class Venezuela
            {
                /// <summary>
                /// Venezuela Stock Market
                /// </summary>
                public const string StockMarket = "IBVC";
                /// <summary>
                /// Venezuela Currency
                /// </summary>
                public const string Currency = "USDVES";
                /// <summary>
                /// Venezuela Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "VENEZUELAGOVBON10Y";
                /// <summary>
                /// Venezuela Deposit Interest Rate
                /// </summary>
                public const string DepositInterestRate = "VENFRINRDPST";
            }
            public static class Vietnam
            {
                /// <summary>
                /// Vietnam Currency
                /// </summary>
                public const string Currency = "USDVND";
                /// <summary>
                /// Vietnam Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "VIETNAMGOVBON10Y";
                /// <summary>
                /// Vietnam Interbank Rate
                /// </summary>
                public const string InterbankRate = "VIETNAMINTRAT";
                /// <summary>
                /// Vietnam Stock Market
                /// </summary>
                public const string StockMarket = "VNINDEX";
            }
            public static class Yemen
            {
                /// <summary>
                /// Yemen Currency
                /// </summary>
                public const string Currency = "USDYER";
            }
            public static class Zambia
            {
                /// <summary>
                /// Zambia Currency
                /// </summary>
                public const string Currency = "USDZMK";
                /// <summary>
                /// Zambia Government Bond 10y
                /// </summary>
                public const string GovernmentBond10y = "ZAMBIAGOVBON10Y";
                /// <summary>
                /// Zambia Interest Rate
                /// </summary>
                public const string InterestRate = "ZAMMBIAINTTRATE";
            }
            public static class Zimbabwe
            {
                /// <summary>
                /// Zimbabwe Stock Market
                /// </summary>
                public const string StockMarket = "INDZI";
            }
        }
    }
}
