/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// OpenTradeFinancing is used to pay/collect daily financing charge for an open Trade within an Account
    /// </summary>
    [DataContract]
    public partial class OpenTradeFinancing :  IEquatable<OpenTradeFinancing>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="OpenTradeFinancing" /> class.
        /// </summary>
        /// <param name="TradeID">The ID of the Trade that financing is being paid/collected for..</param>
        /// <param name="Financing">The amount of financing paid/collected for the Trade..</param>
        public OpenTradeFinancing(string TradeID = default(string), string Financing = default(string))
        {
            this.TradeID = TradeID;
            this.Financing = Financing;
        }
        
        /// <summary>
        /// The ID of the Trade that financing is being paid/collected for.
        /// </summary>
        /// <value>The ID of the Trade that financing is being paid/collected for.</value>
        [DataMember(Name="tradeID", EmitDefaultValue=false)]
        public string TradeID { get; set; }
        /// <summary>
        /// The amount of financing paid/collected for the Trade.
        /// </summary>
        /// <value>The amount of financing paid/collected for the Trade.</value>
        [DataMember(Name="financing", EmitDefaultValue=false)]
        public string Financing { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class OpenTradeFinancing {\n");
            sb.Append("  TradeID: ").Append(TradeID).Append("\n");
            sb.Append("  Financing: ").Append(Financing).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as OpenTradeFinancing);
        }

        /// <summary>
        /// Returns true if OpenTradeFinancing instances are equal
        /// </summary>
        /// <param name="other">Instance of OpenTradeFinancing to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(OpenTradeFinancing other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.TradeID == other.TradeID ||
                    this.TradeID != null &&
                    this.TradeID.Equals(other.TradeID)
                ) && 
                (
                    this.Financing == other.Financing ||
                    this.Financing != null &&
                    this.Financing.Equals(other.Financing)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.TradeID != null)
                    hash = hash * 59 + this.TradeID.GetHashCode();
                if (this.Financing != null)
                    hash = hash * 59 + this.Financing.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
