/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// The dynamic state of an Order. This is only relevant to TrailingStopLoss Orders, as no other Order type has dynamic state.
    /// </summary>
    [DataContract]
    public partial class DynamicOrderState :  IEquatable<DynamicOrderState>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="DynamicOrderState" /> class.
        /// </summary>
        /// <param name="Id">The Order&#39;s ID..</param>
        /// <param name="TrailingStopValue">The Order&#39;s calculated trailing stop value..</param>
        /// <param name="TriggerDistance">The distance between the Trailing Stop Loss Order&#39;s trailingStopValue and the current Market Price. This represents the distance (in price units) of the Order from a triggering price. If the distance could not be determined, this value will not be set..</param>
        /// <param name="IsTriggerDistanceExact">True if an exact trigger distance could be calculated. If false, it means the provided trigger distance is a best estimate. If the distance could not be determined, this value will not be set..</param>
        public DynamicOrderState(string Id = default(string), string TrailingStopValue = default(string), string TriggerDistance = default(string), bool? IsTriggerDistanceExact = default(bool?))
        {
            this.Id = Id;
            this.TrailingStopValue = TrailingStopValue;
            this.TriggerDistance = TriggerDistance;
            this.IsTriggerDistanceExact = IsTriggerDistanceExact;
        }
        
        /// <summary>
        /// The Order&#39;s ID.
        /// </summary>
        /// <value>The Order&#39;s ID.</value>
        [DataMember(Name="id", EmitDefaultValue=false)]
        public string Id { get; set; }
        /// <summary>
        /// The Order&#39;s calculated trailing stop value.
        /// </summary>
        /// <value>The Order&#39;s calculated trailing stop value.</value>
        [DataMember(Name="trailingStopValue", EmitDefaultValue=false)]
        public string TrailingStopValue { get; set; }
        /// <summary>
        /// The distance between the Trailing Stop Loss Order&#39;s trailingStopValue and the current Market Price. This represents the distance (in price units) of the Order from a triggering price. If the distance could not be determined, this value will not be set.
        /// </summary>
        /// <value>The distance between the Trailing Stop Loss Order&#39;s trailingStopValue and the current Market Price. This represents the distance (in price units) of the Order from a triggering price. If the distance could not be determined, this value will not be set.</value>
        [DataMember(Name="triggerDistance", EmitDefaultValue=false)]
        public string TriggerDistance { get; set; }
        /// <summary>
        /// True if an exact trigger distance could be calculated. If false, it means the provided trigger distance is a best estimate. If the distance could not be determined, this value will not be set.
        /// </summary>
        /// <value>True if an exact trigger distance could be calculated. If false, it means the provided trigger distance is a best estimate. If the distance could not be determined, this value will not be set.</value>
        [DataMember(Name="isTriggerDistanceExact", EmitDefaultValue=false)]
        public bool? IsTriggerDistanceExact { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class DynamicOrderState {\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  TrailingStopValue: ").Append(TrailingStopValue).Append("\n");
            sb.Append("  TriggerDistance: ").Append(TriggerDistance).Append("\n");
            sb.Append("  IsTriggerDistanceExact: ").Append(IsTriggerDistanceExact).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as DynamicOrderState);
        }

        /// <summary>
        /// Returns true if DynamicOrderState instances are equal
        /// </summary>
        /// <param name="other">Instance of DynamicOrderState to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(DynamicOrderState other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Id == other.Id ||
                    this.Id != null &&
                    this.Id.Equals(other.Id)
                ) && 
                (
                    this.TrailingStopValue == other.TrailingStopValue ||
                    this.TrailingStopValue != null &&
                    this.TrailingStopValue.Equals(other.TrailingStopValue)
                ) && 
                (
                    this.TriggerDistance == other.TriggerDistance ||
                    this.TriggerDistance != null &&
                    this.TriggerDistance.Equals(other.TriggerDistance)
                ) && 
                (
                    this.IsTriggerDistanceExact == other.IsTriggerDistanceExact ||
                    this.IsTriggerDistanceExact != null &&
                    this.IsTriggerDistanceExact.Equals(other.IsTriggerDistanceExact)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.Id != null)
                    hash = hash * 59 + this.Id.GetHashCode();
                if (this.TrailingStopValue != null)
                    hash = hash * 59 + this.TrailingStopValue.GetHashCode();
                if (this.TriggerDistance != null)
                    hash = hash * 59 + this.TriggerDistance.GetHashCode();
                if (this.IsTriggerDistanceExact != null)
                    hash = hash * 59 + this.IsTriggerDistanceExact.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
