/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

//------------------------------------------------------------------------------
// This code was generated by a tool.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
//------------------------------------------------------------------------------

// To get up to date fundamental definition files for your hedgefund contact sales@quantconnect.com

using System;
using System.IO;
using Newtonsoft.Json;

namespace QuantConnect.Data.Fundamental
{
	/// <summary>
	/// Definition of the CompanyProfile class
	/// </summary>
	public class CompanyProfile
	{
		/// <summary>
		/// The headquarter address as given in the latest report
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2100
		/// </remarks>
		[JsonProperty("2100")]
		public string HeadquarterAddressLine1 { get; set; }

		/// <summary>
		/// The headquarter address as given in the latest report
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2101
		/// </remarks>
		[JsonProperty("2101")]
		public string HeadquarterAddressLine2 { get; set; }

		/// <summary>
		/// The headquarter address as given in the latest report
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2102
		/// </remarks>
		[JsonProperty("2102")]
		public string HeadquarterAddressLine3 { get; set; }

		/// <summary>
		/// The headquarter address as given in the latest report
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2103
		/// </remarks>
		[JsonProperty("2103")]
		public string HeadquarterAddressLine4 { get; set; }

		/// <summary>
		/// The headquarter address as given in the latest report
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2104
		/// </remarks>
		[JsonProperty("2104")]
		public string HeadquarterAddressLine5 { get; set; }

		/// <summary>
		/// The headquarter city as given in the latest report
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2105
		/// </remarks>
		[JsonProperty("2105")]
		public string HeadquarterCity { get; set; }

		/// <summary>
		/// The headquarter state or province as given in the latest report
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2106
		/// </remarks>
		[JsonProperty("2106")]
		public string HeadquarterProvince { get; set; }

		/// <summary>
		/// The headquarter country as given in the latest report
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2107
		/// </remarks>
		[JsonProperty("2107")]
		public string HeadquarterCountry { get; set; }

		/// <summary>
		/// The headquarter postal code as given in the latest report
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2108
		/// </remarks>
		[JsonProperty("2108")]
		public string HeadquarterPostalCode { get; set; }

		/// <summary>
		/// The headquarter phone number as given in the latest report
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2109
		/// </remarks>
		[JsonProperty("2109")]
		public string HeadquarterPhone { get; set; }

		/// <summary>
		/// The headquarter fax number as given in the latest report
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2110
		/// </remarks>
		[JsonProperty("2110")]
		public string HeadquarterFax { get; set; }

		/// <summary>
		/// The headquarters' website address as given in the latest report
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2111
		/// </remarks>
		[JsonProperty("2111")]
		public string HeadquarterHomepage { get; set; }

		/// <summary>
		/// The number of employees as indicated on the latest Annual Report, 10-K filing, Form 20-F or equivalent report indicating the
		/// employee count at the end of latest fiscal year.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2113
		/// </remarks>
		[JsonProperty("2113")]
		public int TotalEmployeeNumber { get; set; }

		/// <summary>
		/// Company's contact email address
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2114
		/// </remarks>
		[JsonProperty("2114")]
		public string ContactEmail { get; set; }

		/// <summary>
		/// Average number of employees from Annual Report
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2115
		/// </remarks>
		[JsonProperty("2115")]
		public int AverageEmployeeNumber { get; set; }

		/// <summary>
		/// Details for registered office contact information including address full details, phone and
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2116
		/// </remarks>
		[JsonProperty("2116")]
		public string RegisteredAddressLine1 { get; set; }

		/// <summary>
		/// Address for registered office
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2117
		/// </remarks>
		[JsonProperty("2117")]
		public string RegisteredAddressLine2 { get; set; }

		/// <summary>
		/// Address for registered office
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2118
		/// </remarks>
		[JsonProperty("2118")]
		public string RegisteredAddressLine3 { get; set; }

		/// <summary>
		/// Address for registered office
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2119
		/// </remarks>
		[JsonProperty("2119")]
		public string RegisteredAddressLine4 { get; set; }

		/// <summary>
		/// City for registered office
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2120
		/// </remarks>
		[JsonProperty("2120")]
		public string RegisteredCity { get; set; }

		/// <summary>
		/// Province for registered office
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2121
		/// </remarks>
		[JsonProperty("2121")]
		public string RegisteredProvince { get; set; }

		/// <summary>
		/// Country for registered office
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2122
		/// </remarks>
		[JsonProperty("2122")]
		public string RegisteredCountry { get; set; }

		/// <summary>
		/// Postal Code for registered office
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2123
		/// </remarks>
		[JsonProperty("2123")]
		public string RegisteredPostalCode { get; set; }

		/// <summary>
		/// Phone number for registered office
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2124
		/// </remarks>
		[JsonProperty("2124")]
		public string RegisteredPhone { get; set; }

		/// <summary>
		/// Fax number for registered office
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2125
		/// </remarks>
		[JsonProperty("2125")]
		public string RegisteredFax { get; set; }

		/// <summary>
		/// Flag to denote whether head and registered offices are the same
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 2126
		/// </remarks>
		[JsonProperty("2126")]
		public bool IsHeadOfficeSameWithRegisteredOfficeFlag { get; set; }

		/// <summary>
		/// The latest total shares outstanding reported by the company; most common source of this information is from the cover of the 10K,
		/// 10Q, or 20F filing. This figure is an aggregated shares outstanding number for a company. It can be used to calculate the most
		/// accurate market cap, based on each individual share's trading price and the total aggregated shares outstanding figure.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 40000
		/// </remarks>
		[JsonProperty("40000")]
		public long SharesOutstanding { get; set; }

		/// <summary>
		/// Price * Total SharesOutstanding.
		/// The most current market cap for example, would be the most recent closing price x the most recent reported shares outstanding.
		/// For ADR share classes, market cap is price * (ordinary shares outstanding / adr ratio).
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 40001
		/// </remarks>
		[JsonProperty("40001")]
		public long MarketCap { get; set; }

		/// <summary>
		/// This number tells you what cash return you would get if you bought the entire company, including its debt.        Enterprise Value =
		/// Market Cap + Preferred stock + Long-Term Debt And Capital Lease + Short Term Debt And Capital Lease + Securities Sold But
		/// Not Yet Repurchased  - Cash, Cash Equivalent And Market Securities - Securities Purchased with Agreement to Resell - Securities
		/// Borrowed.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 40002
		/// </remarks>
		[JsonProperty("40002")]
		public long EnterpriseValue { get; set; }

		/// <summary>
		/// The latest shares outstanding reported by the company of a particular share class; most common source of this information is from
		/// the cover of the 10K, 10Q, or 20F filing. This figure is an aggregated shares outstanding number for a particular share class of the
		/// company.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 40003
		/// </remarks>
		[JsonProperty("40003")]
		public long ShareClassLevelSharesOutstanding { get; set; }

		/// <summary>
		/// Total shares outstanding reported by the company as of the balance sheet period ended date. The most common source of this
		/// information is from the 10K, 10Q, or 20F filing. This figure is an aggregated shares outstanding number for a company.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 40007
		/// </remarks>
		[JsonProperty("40007")]
		public long SharesOutstandingWithBalanceSheetEndingDate { get; set; }

		/// <summary>
		/// The reason for the change in a company's total shares outstanding from the previous record. Examples could be share issuances or
		/// share buy-back. This field will only be populated when total shares outstanding is collected from a press release.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 40010
		/// </remarks>
		[JsonProperty("40010")]
		public string ReasonofSharesChange { get; set; }

		/// <summary>
		/// Creates an instance of the CompanyProfile class
		/// </summary>
		public CompanyProfile()
		{
		}

		/// <summary>
		/// Applies updated values from <paramref name="update"/> to this instance
		/// </summary>
		/// <remarks>Used to apply data updates to the current instance. This WILL overwrite existing values. Default update values are ignored.</remarks>
		/// <param name="update">The next data update for this instance</param>
		public void UpdateValues(CompanyProfile update)
		{
			if (update == null) return;

			if (!string.IsNullOrWhiteSpace(update.HeadquarterAddressLine1)) HeadquarterAddressLine1 = update.HeadquarterAddressLine1;
			if (!string.IsNullOrWhiteSpace(update.HeadquarterAddressLine2)) HeadquarterAddressLine2 = update.HeadquarterAddressLine2;
			if (!string.IsNullOrWhiteSpace(update.HeadquarterAddressLine3)) HeadquarterAddressLine3 = update.HeadquarterAddressLine3;
			if (!string.IsNullOrWhiteSpace(update.HeadquarterAddressLine4)) HeadquarterAddressLine4 = update.HeadquarterAddressLine4;
			if (!string.IsNullOrWhiteSpace(update.HeadquarterAddressLine5)) HeadquarterAddressLine5 = update.HeadquarterAddressLine5;
			if (!string.IsNullOrWhiteSpace(update.HeadquarterCity)) HeadquarterCity = update.HeadquarterCity;
			if (!string.IsNullOrWhiteSpace(update.HeadquarterProvince)) HeadquarterProvince = update.HeadquarterProvince;
			if (!string.IsNullOrWhiteSpace(update.HeadquarterCountry)) HeadquarterCountry = update.HeadquarterCountry;
			if (!string.IsNullOrWhiteSpace(update.HeadquarterPostalCode)) HeadquarterPostalCode = update.HeadquarterPostalCode;
			if (!string.IsNullOrWhiteSpace(update.HeadquarterPhone)) HeadquarterPhone = update.HeadquarterPhone;
			if (!string.IsNullOrWhiteSpace(update.HeadquarterFax)) HeadquarterFax = update.HeadquarterFax;
			if (!string.IsNullOrWhiteSpace(update.HeadquarterHomepage)) HeadquarterHomepage = update.HeadquarterHomepage;
			if (update.TotalEmployeeNumber != default(int)) TotalEmployeeNumber = update.TotalEmployeeNumber;
			if (!string.IsNullOrWhiteSpace(update.ContactEmail)) ContactEmail = update.ContactEmail;
			if (update.AverageEmployeeNumber != default(int)) AverageEmployeeNumber = update.AverageEmployeeNumber;
			if (!string.IsNullOrWhiteSpace(update.RegisteredAddressLine1)) RegisteredAddressLine1 = update.RegisteredAddressLine1;
			if (!string.IsNullOrWhiteSpace(update.RegisteredAddressLine2)) RegisteredAddressLine2 = update.RegisteredAddressLine2;
			if (!string.IsNullOrWhiteSpace(update.RegisteredAddressLine3)) RegisteredAddressLine3 = update.RegisteredAddressLine3;
			if (!string.IsNullOrWhiteSpace(update.RegisteredAddressLine4)) RegisteredAddressLine4 = update.RegisteredAddressLine4;
			if (!string.IsNullOrWhiteSpace(update.RegisteredCity)) RegisteredCity = update.RegisteredCity;
			if (!string.IsNullOrWhiteSpace(update.RegisteredProvince)) RegisteredProvince = update.RegisteredProvince;
			if (!string.IsNullOrWhiteSpace(update.RegisteredCountry)) RegisteredCountry = update.RegisteredCountry;
			if (!string.IsNullOrWhiteSpace(update.RegisteredPostalCode)) RegisteredPostalCode = update.RegisteredPostalCode;
			if (!string.IsNullOrWhiteSpace(update.RegisteredPhone)) RegisteredPhone = update.RegisteredPhone;
			if (!string.IsNullOrWhiteSpace(update.RegisteredFax)) RegisteredFax = update.RegisteredFax;
			if (update.IsHeadOfficeSameWithRegisteredOfficeFlag != default(bool)) IsHeadOfficeSameWithRegisteredOfficeFlag = update.IsHeadOfficeSameWithRegisteredOfficeFlag;
			if (update.SharesOutstanding != default(long)) SharesOutstanding = update.SharesOutstanding;
			if (update.MarketCap != default(long)) MarketCap = update.MarketCap;
			if (update.EnterpriseValue != default(long)) EnterpriseValue = update.EnterpriseValue;
			if (update.ShareClassLevelSharesOutstanding != default(long)) ShareClassLevelSharesOutstanding = update.ShareClassLevelSharesOutstanding;
			if (update.SharesOutstandingWithBalanceSheetEndingDate != default(long)) SharesOutstandingWithBalanceSheetEndingDate = update.SharesOutstandingWithBalanceSheetEndingDate;
			if (!string.IsNullOrWhiteSpace(update.ReasonofSharesChange)) ReasonofSharesChange = update.ReasonofSharesChange;
		}
	}
}
