/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

//------------------------------------------------------------------------------
// This code was generated by a tool.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
//------------------------------------------------------------------------------

// To get up to date fundamental definition files for your hedgefund contact sales@quantconnect.com

using System;
using Newtonsoft.Json;

namespace QuantConnect.Data.Fundamental
{
	/// <summary>
	/// Definition of the CashFlowStatement class
	/// </summary>
	public class CashFlowStatement
	{
		/// <summary>
		/// The systematic and rational apportionment of the acquisition cost of intangible operational assets to future periods in which the benefits
		/// contribute to revenue. This field is to include Amortization and any variation where Amortization is the first account listed in the line item,
		/// excluding Amortization of Intangibles.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26000
		/// </remarks>
		[JsonProperty("26000")]
		public AmortizationCashFlowStatement Amortization { get; set; }

		/// <summary>
		/// Funds used by a company to acquire or upgrade physical assets such as property, industrial buildings or equipment. This
		/// type of outlay is made by companies to maintain or increase the scope of their operations. Capital expenditures are generally
		/// depreciated or depleted over their useful life, as distinguished from repairs, which are subtracted from the income of the current
		/// year.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26005
		/// </remarks>
		[JsonProperty("26005")]
		public CapitalExpenditureCashFlowStatement CapitalExpenditure { get; set; }

		/// <summary>
		/// Payments for the cash dividends declared by an entity to shareholders during the period. This element includes paid and unpaid
		/// dividends declared during the period for both common and preferred stock.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26007
		/// </remarks>
		[JsonProperty("26007")]
		public CashDividendsPaidCashFlowStatement CashDividendsPaid { get; set; }

		/// <summary>
		/// Cash generated by or used in financing activities of continuing operations; excludes cash flows from discontinued operations.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26008
		/// </remarks>
		[JsonProperty("26008")]
		public CashFlowFromContinuingFinancingActivitiesCashFlowStatement CashFlowFromContinuingFinancingActivities { get; set; }

		/// <summary>
		/// Cash generated by or used in investing activities of continuing operations; excludes cash flows from discontinued operations.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26009
		/// </remarks>
		[JsonProperty("26009")]
		public CashFlowFromContinuingInvestingActivitiesCashFlowStatement CashFlowFromContinuingInvestingActivities { get; set; }

		/// <summary>
		/// Cash generated by or used in operating activities of continuing operations; excludes cash flows from discontinued operations.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26010
		/// </remarks>
		[JsonProperty("26010")]
		public CashFlowFromContinuingOperatingActivitiesCashFlowStatement CashFlowFromContinuingOperatingActivities { get; set; }

		/// <summary>
		/// The aggregate amount of cash flow from discontinued operation, including operating activities, investing activities, and financing
		/// activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26011
		/// </remarks>
		[JsonProperty("26011")]
		public CashFlowFromDiscontinuedOperationCashFlowStatement CashFlowFromDiscontinuedOperation { get; set; }

		/// <summary>
		/// The net cash inflow (outflow) from financing activity for the period, which involve changes to the long-term liabilities and
		/// stockholders' equity.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26012
		/// </remarks>
		[JsonProperty("26012")]
		public FinancingCashFlowCashFlowStatement FinancingCashFlow { get; set; }

		/// <summary>
		/// An item on the cash flow statement that reports the aggregate change in a company's cash position resulting from any gains (or
		/// losses) from investments in the financial markets and operating subsidiaries, and changes resulting from amounts spent on
		/// investments in capital assets such as plant and equipment.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26013
		/// </remarks>
		[JsonProperty("26013")]
		public InvestingCashFlowCashFlowStatement InvestingCashFlow { get; set; }

		/// <summary>
		/// The net cash from (used in) all of the entity's operating activities, including those of discontinued operations, of the reporting entity.
		/// Operating activities include all transactions and events that are not defined as investing or financing activities. Operating activities
		/// generally involve producing and delivering goods and providing services. Cash flows from operating activities are generally the cash
		/// effects of transactions and other events that enter into the determination of net income.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26014
		/// </remarks>
		[JsonProperty("26014")]
		public OperatingCashFlowCashFlowStatement OperatingCashFlow { get; set; }

		/// <summary>
		/// The cash and equivalents balance at the beginning of the accounting period, as indicated on the Cash Flow statement.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26015
		/// </remarks>
		[JsonProperty("26015")]
		public BeginningCashPositionCashFlowStatement BeginningCashPosition { get; set; }

		/// <summary>
		/// The cash and cash equivalents balance at the end of the accounting period, as indicated on the Cash Flow statement. It is equal to
		/// the Beginning Cash and Equivalents, plus the Net Change in Cash and Equivalents.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26016
		/// </remarks>
		[JsonProperty("26016")]
		public EndCashPositionCashFlowStatement EndCashPosition { get; set; }

		/// <summary>
		/// Cash generated by or used in financing activities of discontinued operations; excludes cash flows from continued operations.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26017
		/// </remarks>
		[JsonProperty("26017")]
		public CashFromDiscontinuedFinancingCashFlowStatement CashFromDiscontinuedFinancing { get; set; }

		/// <summary>
		/// Cash generated by or used in financing activities of discontinued operations; excludes cash flows from continued operations.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26018
		/// </remarks>
		[JsonProperty("26018")]
		public CashFromDiscontinuedFinancingActivitiesCashFlowStatement CashFromDiscontinuedFinancingActivities { get; set; }

		/// <summary>
		/// The net cash inflow (outflow) from discontinued investing activities over the designated time period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26019
		/// </remarks>
		[JsonProperty("26019")]
		public CashFromDiscontinuedInvestingCashFlowStatement CashFromDiscontinuedInvesting { get; set; }

		/// <summary>
		/// The net cash inflow (outflow) from discontinued investing activities over the designated time period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26020
		/// </remarks>
		[JsonProperty("26020")]
		public CashFromDiscontinuedInvestingActivitiesCashFlowStatement CashFromDiscontinuedInvestingActivities { get; set; }

		/// <summary>
		/// The net cash from (used in) all of the entity's discontinued operating activities, excluding those of continued operations, of the
		/// reporting entity.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26021
		/// </remarks>
		[JsonProperty("26021")]
		public CashFromDiscontinuedOperatingCashFlowStatement CashFromDiscontinuedOperating { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the account payables.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26022
		/// </remarks>
		[JsonProperty("26022")]
		public ChangeInAccountPayableCashFlowStatement ChangeInAccountPayable { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the tax payables.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26024
		/// </remarks>
		[JsonProperty("26024")]
		public ChangeInTaxPayableCashFlowStatement ChangeInTaxPayable { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the accrued expenses.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26025
		/// </remarks>
		[JsonProperty("26025")]
		public ChangeInAccruedExpenseCashFlowStatement ChangeInAccruedExpense { get; set; }

		/// <summary>
		/// The net change during the reporting period in investment income that has been earned but not yet received in cash.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26026
		/// </remarks>
		[JsonProperty("26026")]
		public ChangeInAccruedInvestmentIncomeCashFlowStatement ChangeInAccruedInvestmentIncome { get; set; }

		/// <summary>
		/// The net change between the beginning and ending balance of cash and cash equivalents.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26027
		/// </remarks>
		[JsonProperty("26027")]
		public ChangesInCashCashFlowStatement ChangesInCash { get; set; }

		/// <summary>
		/// The change of the unamortized portion as of the balance sheet date of capitalized costs that vary with and are primarily related to
		/// the acquisition of new and renewal insurance contracts.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26028
		/// </remarks>
		[JsonProperty("26028")]
		public ChangeInDeferredAcquisitionCostsCashFlowStatement ChangeInDeferredAcquisitionCosts { get; set; }

		/// <summary>
		/// The amount shown on the books that a bank with insufficient reserves borrows, at the federal funds rate, from another bank to
		/// meet its reserve requirements and the amount of securities that an institution sells and agrees to repurchase at a specified date for
		/// a specified price, net of any reductions or offsets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26030
		/// </remarks>
		[JsonProperty("26030")]
		public ChangeInFederalFundsAndSecuritiesSoldForRepurchaseCashFlowStatement ChangeInFederalFundsAndSecuritiesSoldForRepurchase { get; set; }

		/// <summary>
		/// The net change during the reporting period associated with funds withheld.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26031
		/// </remarks>
		[JsonProperty("26031")]
		public ChangeInFundsWithheldCashFlowStatement ChangeInFundsWithheld { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the income tax payables.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26032
		/// </remarks>
		[JsonProperty("26032")]
		public ChangeInIncomeTaxPayableCashFlowStatement ChangeInIncomeTaxPayable { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the interest payable. Interest payable means carrying value as of the balance sheet
		/// date of interest payable on all forms of debt.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26033
		/// </remarks>
		[JsonProperty("26033")]
		public ChangeInInterestPayableCashFlowStatement ChangeInInterestPayable { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the Inventories. Inventories represent merchandise bought for resale and supplies and
		/// raw materials purchased for use in revenue producing operations.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26034
		/// </remarks>
		[JsonProperty("26034")]
		public ChangeInInventoryCashFlowStatement ChangeInInventory { get; set; }

		/// <summary>
		/// The net change that a lender gives money or property to a borrower and the borrower agrees to return the property or repay the
		/// borrowed money, along with interest, at a predetermined date in the future.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26035
		/// </remarks>
		[JsonProperty("26035")]
		public ChangeInLoansCashFlowStatement ChangeInLoans { get; set; }

		/// <summary>
		/// The net change during the reporting period in the reserve account established to account for expected but unspecified losses.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26036
		/// </remarks>
		[JsonProperty("26036")]
		public ChangeInLossAndLossAdjustmentExpenseReservesCashFlowStatement ChangeInLossAndLossAdjustmentExpenseReserves { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the payables.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26040
		/// </remarks>
		[JsonProperty("26040")]
		public ChangeInPayableCashFlowStatement ChangeInPayable { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the payables and accrued expenses. Accrued expenses represent expenses incurred
		/// at the end of the reporting period but not yet paid; also called accrued liabilities. The accrued liability is shown under current
		/// liabilities in the balance sheet.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26041
		/// </remarks>
		[JsonProperty("26041")]
		public ChangeInPayablesAndAccruedExpenseCashFlowStatement ChangeInPayablesAndAccruedExpense { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the prepaid assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26043
		/// </remarks>
		[JsonProperty("26043")]
		public ChangeInPrepaidAssetsCashFlowStatement ChangeInPrepaidAssets { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the receivables. Receivables are amounts due to be paid to the company from clients
		/// and other.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26045
		/// </remarks>
		[JsonProperty("26045")]
		public ChangeInReceivablesCashFlowStatement ChangeInReceivables { get; set; }

		/// <summary>
		/// The net change during the reporting period in the amount of benefits the ceding insurer expects to recover on insurance policies
		/// ceded to other insurance entities as of the balance sheet date for all guaranteed benefit types.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26047
		/// </remarks>
		[JsonProperty("26047")]
		public ChangeInReinsuranceRecoverableOnPaidAndUnpaidLossesCashFlowStatement ChangeInReinsuranceRecoverableOnPaidAndUnpaidLosses { get; set; }

		/// <summary>
		/// The net cash inflow (outflow) for the net change associated with funds that are not available for withdrawal or use (such as funds
		/// held in escrow).
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26049
		/// </remarks>
		[JsonProperty("26049")]
		public ChangeInRestrictedCashCashFlowStatement ChangeInRestrictedCash { get; set; }

		/// <summary>
		/// The net change during the reporting period associated with trading account assets. Trading account assets are bought and held
		/// principally for the purpose of selling them in the near term (thus held for only a short period of time). Unrealized holding gains and
		/// losses for trading securities are included in earnings.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26050
		/// </remarks>
		[JsonProperty("26050")]
		public ChangeInTradingAccountSecuritiesCashFlowStatement ChangeInTradingAccountSecurities { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the working capital.  Working Capital is the amount left to the company to finance
		/// operations and expansion after current liabilities have been covered.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26053
		/// </remarks>
		[JsonProperty("26053")]
		public ChangeInWorkingCapitalCashFlowStatement ChangeInWorkingCapital { get; set; }

		/// <summary>
		/// The component of income tax expense for the period representing the net change in the entities deferred tax assets and liabilities
		/// pertaining to continuing operations.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26056
		/// </remarks>
		[JsonProperty("26056")]
		public DeferredIncomeTaxCashFlowStatement DeferredIncomeTax { get; set; }

		/// <summary>
		/// Future tax liability or asset, resulting from temporary differences between book (accounting) value of assets and liabilities, and their
		/// tax value. This arises due to differences between financial accounting for shareholders and tax accounting.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26057
		/// </remarks>
		[JsonProperty("26057")]
		public DeferredTaxCashFlowStatement DeferredTax { get; set; }

		/// <summary>
		/// Unlike depreciation and amortization, which mainly describe the deduction of expenses due to the aging of equipment and property,
		/// depletion is the actual physical reduction of natural resources by companies.   For example, coalmines, oil fields and other natural
		/// resources are depleted on company accounting statements. This reduction in the quantity of resources is meant to assist in
		/// accurately identifying the value of the asset on the balance sheet.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26058
		/// </remarks>
		[JsonProperty("26058")]
		public DepletionCashFlowStatement Depletion { get; set; }

		/// <summary>
		/// An expense recorded to allocate a tangible asset's cost over its useful life. Since it is a non-cash expense, it increases free cash
		/// flow while decreasing reported earnings.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26059
		/// </remarks>
		[JsonProperty("26059")]
		public DepreciationCashFlowStatement Depreciation { get; set; }

		/// <summary>
		/// The current period expense charged against earnings on long-lived, physical assets used in the normal conduct of business and not
		/// intended for resale to allocate or recognize the cost of assets over their useful lives; or to record the reduction in book value of an
		/// intangible asset over the benefit period of such asset.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26060
		/// </remarks>
		[JsonProperty("26060")]
		public DepreciationAndAmortizationCashFlowStatement DepreciationAndAmortization { get; set; }

		/// <summary>
		/// It is a non cash charge that represents a reduction in the value of fixed assets due to wear, age or obsolescence. This figure also
		/// includes amortization of leased property, intangibles, and goodwill, and depletion. This non-cash item is an add-back to the cash
		/// flow statement.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26061
		/// </remarks>
		[JsonProperty("26061")]
		public DepreciationAmortizationDepletionCashFlowStatement DepreciationAmortizationDepletion { get; set; }

		/// <summary>
		/// The effect of exchange rate changes on cash balances held in foreign currencies.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26063
		/// </remarks>
		[JsonProperty("26063")]
		public EffectOfExchangeRateChangesCashFlowStatement EffectOfExchangeRateChanges { get; set; }

		/// <summary>
		/// The aggregate net change during the reporting period in moneys given as security, collateral, or margin deposits.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26069
		/// </remarks>
		[JsonProperty("26069")]
		public IncreaseDecreaseInDepositCashFlowStatement IncreaseDecreaseInDeposit { get; set; }

		/// <summary>
		/// The increase or decrease between periods of common stock.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26071
		/// </remarks>
		[JsonProperty("26071")]
		public NetCommonStockIssuanceCashFlowStatement NetCommonStockIssuance { get; set; }

		/// <summary>
		/// The increase or decrease between periods of debt.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26072
		/// </remarks>
		[JsonProperty("26072")]
		public NetIssuancePaymentsOfDebtCashFlowStatement NetIssuancePaymentsOfDebt { get; set; }

		/// <summary>
		/// The increase or decrease between periods of long term debt. Long term debt includes notes payable, bonds payable, mortgage
		/// loans, convertible debt, subordinated debt and other types of long term debt.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26073
		/// </remarks>
		[JsonProperty("26073")]
		public NetLongTermDebtIssuanceCashFlowStatement NetLongTermDebtIssuance { get; set; }

		/// <summary>
		/// The increase or decrease between periods of preferred stock.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26074
		/// </remarks>
		[JsonProperty("26074")]
		public NetPreferredStockIssuanceCashFlowStatement NetPreferredStockIssuance { get; set; }

		/// <summary>
		/// The increase or decrease between periods of short term debt.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26075
		/// </remarks>
		[JsonProperty("26075")]
		public NetShortTermDebtIssuanceCashFlowStatement NetShortTermDebtIssuance { get; set; }

		/// <summary>
		/// The net cash from (used in) all of the entity's discontinued operating activities, excluding those of continued operations, of the
		/// reporting entity.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26077
		/// </remarks>
		[JsonProperty("26077")]
		public NetCashFromDiscontinuedOperationsCashFlowStatement NetCashFromDiscontinuedOperations { get; set; }

		/// <summary>
		/// The aggregate amount of realized and unrealized gain or loss resulting from changes in exchange rates between currencies.
		/// (Excludes foreign currency transactions designated as hedges of net investment in a foreign entity and inter-company foreign
		/// currency transactions that are of a long-term nature, when the entities to the transaction are consolidated, combined, or accounted
		/// for by the equity method in the reporting entity's financial statements. For certain entities, primarily banks, which are dealers in
		/// foreign exchange, foreign currency transaction gains or losses, may be disclosed as dealer gains or losses.)
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26078
		/// </remarks>
		[JsonProperty("26078")]
		public NetForeignCurrencyExchangeGainLossCashFlowStatement NetForeignCurrencyExchangeGainLoss { get; set; }

		/// <summary>
		/// Revenue less expenses and taxes from the entity's ongoing operations and before income (loss) from discontinued operations,
		/// extraordinary items, impact of changes in accounting principles, minority interest, and various other reconciling adjustments;
		/// represents the starting line for Operating Cash Flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26080
		/// </remarks>
		[JsonProperty("26080")]
		public NetIncomeFromContinuingOperationsCashFlowStatement NetIncomeFromContinuingOperations { get; set; }

		/// <summary>
		/// Payment from a bank or insurance company to the lender who lends money or property based on the agreement, along with
		/// interest, at a predetermined date in the future.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26087
		/// </remarks>
		[JsonProperty("26087")]
		public PaymentForLoansCashFlowStatement PaymentForLoans { get; set; }

		/// <summary>
		/// The cash outflow to reacquire common stock during the period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26088
		/// </remarks>
		[JsonProperty("26088")]
		public CommonStockPaymentsCashFlowStatement CommonStockPayments { get; set; }

		/// <summary>
		/// The cash outflow to reacquire preferred stock during the period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26089
		/// </remarks>
		[JsonProperty("26089")]
		public PreferredStockPaymentsCashFlowStatement PreferredStockPayments { get; set; }

		/// <summary>
		/// The cash outflow for debt initially having maturity due after one year or beyond the normal operating cycle, if longer.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26090
		/// </remarks>
		[JsonProperty("26090")]
		public LongTermDebtPaymentsCashFlowStatement LongTermDebtPayments { get; set; }

		/// <summary>
		/// The cash outflow for a borrowing having initial term of repayment within one year or the normal operating cycle, if longer.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26091
		/// </remarks>
		[JsonProperty("26091")]
		public ShortTermDebtPaymentsCashFlowStatement ShortTermDebtPayments { get; set; }

		/// <summary>
		/// The cash inflow from borrowing money or property for a bank or insurance company.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26095
		/// </remarks>
		[JsonProperty("26095")]
		public ProceedsFromLoansCashFlowStatement ProceedsFromLoans { get; set; }

		/// <summary>
		/// The cash inflow associated with the amount received from holders exercising their stock options.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26097
		/// </remarks>
		[JsonProperty("26097")]
		public ProceedsFromStockOptionExercisedCashFlowStatement ProceedsFromStockOptionExercised { get; set; }

		/// <summary>
		/// The cash inflow from offering common stock, which is the additional capital contribution to the entity during the period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26098
		/// </remarks>
		[JsonProperty("26098")]
		public CommonStockIssuanceCashFlowStatement CommonStockIssuance { get; set; }

		/// <summary>
		/// The cash inflow from a debt initially having maturity due after one year or beyond the operating cycle, if longer.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26099
		/// </remarks>
		[JsonProperty("26099")]
		public LongTermDebtIssuanceCashFlowStatement LongTermDebtIssuance { get; set; }

		/// <summary>
		/// The cash inflow from offering preferred stock.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26100
		/// </remarks>
		[JsonProperty("26100")]
		public PreferredStockIssuanceCashFlowStatement PreferredStockIssuance { get; set; }

		/// <summary>
		/// The cash inflow from a debt initially having maturity due within one year or the normal operating cycle, if longer.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26101
		/// </remarks>
		[JsonProperty("26101")]
		public ShortTermDebtIssuanceCashFlowStatement ShortTermDebtIssuance { get; set; }

		/// <summary>
		/// The net value of proceeds or payments of loans.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26103
		/// </remarks>
		[JsonProperty("26103")]
		public NetProceedsPaymentForLoanCashFlowStatement NetProceedsPaymentForLoan { get; set; }

		/// <summary>
		/// The net change on interest-bearing deposits in other financial institutions for relatively short periods of time including, for example,
		/// certificates of deposits.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26104
		/// </remarks>
		[JsonProperty("26104")]
		public ProceedsPaymentInInterestBearingDepositsInBankCashFlowStatement ProceedsPaymentInInterestBearingDepositsInBank { get; set; }

		/// <summary>
		/// The amount of capital outlays undertaken to increase, construct or improve intangible assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26108
		/// </remarks>
		[JsonProperty("26108")]
		public PurchaseOfIntangiblesCashFlowStatement PurchaseOfIntangibles { get; set; }

		/// <summary>
		/// All purchases of investments, including both long term and short term.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26110
		/// </remarks>
		[JsonProperty("26110")]
		public PurchaseOfInvestmentCashFlowStatement PurchaseOfInvestment { get; set; }

		/// <summary>
		/// The amount of capital outlays undertaken to increase, construct or improve capital assets. This category includes property, plant
		/// equipment, furniture, fixed assets, buildings, and improvement.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26112
		/// </remarks>
		[JsonProperty("26112")]
		public PurchaseOfPPECashFlowStatement PurchaseOfPPE { get; set; }

		/// <summary>
		/// All the purchases of business including business acquisitions, investment in subsidiary; investing in affiliated companies, and join
		/// venture.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26115
		/// </remarks>
		[JsonProperty("26115")]
		public PurchaseOfBusinessCashFlowStatement PurchaseOfBusiness { get; set; }

		/// <summary>
		/// The net change between Purchases/Sales of Business.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26116
		/// </remarks>
		[JsonProperty("26116")]
		public NetBusinessPurchaseAndSaleCashFlowStatement NetBusinessPurchaseAndSale { get; set; }

		/// <summary>
		/// The net change between Purchases/Sales of Intangibles.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26117
		/// </remarks>
		[JsonProperty("26117")]
		public NetIntangiblesPurchaseAndSaleCashFlowStatement NetIntangiblesPurchaseAndSale { get; set; }

		/// <summary>
		/// The net change between Purchases/Sales of Investments.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26118
		/// </remarks>
		[JsonProperty("26118")]
		public NetInvestmentPurchaseAndSaleCashFlowStatement NetInvestmentPurchaseAndSale { get; set; }

		/// <summary>
		/// The net change between Purchases/Sales of PPE.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26119
		/// </remarks>
		[JsonProperty("26119")]
		public NetPPEPurchaseAndSaleCashFlowStatement NetPPEPurchaseAndSale { get; set; }

		/// <summary>
		/// Proceeds received from selling a business including proceeds from a subsidiary, and proceeds from an affiliated company.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26123
		/// </remarks>
		[JsonProperty("26123")]
		public SaleOfBusinessCashFlowStatement SaleOfBusiness { get; set; }

		/// <summary>
		/// The amount of capital inflow from the sale of all kinds of intangible assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26124
		/// </remarks>
		[JsonProperty("26124")]
		public SaleOfIntangiblesCashFlowStatement SaleOfIntangibles { get; set; }

		/// <summary>
		/// Proceeds received from selling all kind of investments, including both long term and short term.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26125
		/// </remarks>
		[JsonProperty("26125")]
		public SaleOfInvestmentCashFlowStatement SaleOfInvestment { get; set; }

		/// <summary>
		/// Proceeds from selling any fixed assets such as property, plant and equipment, which also includes retirement of equipment.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26127
		/// </remarks>
		[JsonProperty("26127")]
		public SaleOfPPECashFlowStatement SaleOfPPE { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the accounts receivables.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26137
		/// </remarks>
		[JsonProperty("26137")]
		public ChangesInAccountReceivablesCashFlowStatement ChangesInAccountReceivables { get; set; }

		/// <summary>
		/// The component of interest expense representing the non-cash expenses charged against earnings in the period to allocate debt
		/// discount and premium, and the costs to issue debt and obtain financing over the related debt instruments. This item is usually only
		/// available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26141
		/// </remarks>
		[JsonProperty("26141")]
		public AmortizationOfFinancingCostsAndDiscountsCashFlowStatement AmortizationOfFinancingCostsAndDiscounts { get; set; }

		/// <summary>
		/// Represents amortization of the allocation of a lump sum amount to different time periods, particularly for securities, debt, loans,
		/// and other forms of financing. Does not include amortization, amortization of capital expenditure and intangible assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26142
		/// </remarks>
		[JsonProperty("26142")]
		public AmortizationOfSecuritiesCashFlowStatement AmortizationOfSecurities { get; set; }

		/// <summary>
		/// The charge against earnings resulting from the aggregate write down of all assets from their carrying value to their fair value.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26143
		/// </remarks>
		[JsonProperty("26143")]
		public AssetImpairmentChargeCashFlowStatement AssetImpairmentCharge { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the dividend payables.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26144
		/// </remarks>
		[JsonProperty("26144")]
		public ChangeInDividendPayableCashFlowStatement ChangeInDividendPayable { get; set; }

		/// <summary>
		/// The net change during the reporting period in the value of expenditures made during the current reporting period for benefits that
		/// will be received over a period of years. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26145
		/// </remarks>
		[JsonProperty("26145")]
		public ChangeInDeferredChargesCashFlowStatement ChangeInDeferredCharges { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the Other Current Assets. This category typically includes prepayments, deferred
		/// charges, and amounts (other than trade accounts) due from parents and subsidiaries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26146
		/// </remarks>
		[JsonProperty("26146")]
		public ChangeInOtherCurrentAssetsCashFlowStatement ChangeInOtherCurrentAssets { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the Other Current liabilities. Other Current liabilities is a balance sheet entry used by
		/// companies to group together current liabilities that are not assigned to common liabilities such as debt obligations or accounts
		/// payable.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26147
		/// </remarks>
		[JsonProperty("26147")]
		public ChangeInOtherCurrentLiabilitiesCashFlowStatement ChangeInOtherCurrentLiabilities { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the other working capital.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26148
		/// </remarks>
		[JsonProperty("26148")]
		public ChangeInOtherWorkingCapitalCashFlowStatement ChangeInOtherWorkingCapital { get; set; }

		/// <summary>
		/// The change during the period in the unearned portion of premiums written, excluding the portion amortized into income. This item is
		/// usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26152
		/// </remarks>
		[JsonProperty("26152")]
		public ChangeInUnearnedPremiumsCashFlowStatement ChangeInUnearnedPremiums { get; set; }

		/// <summary>
		/// The cash outflow from the distribution of an entity's earnings in the form of dividends to common shareholders.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26154
		/// </remarks>
		[JsonProperty("26154")]
		public CommonStockDividendPaidCashFlowStatement CommonStockDividendPaid { get; set; }

		/// <summary>
		/// This item represents the entity's proportionate share for the period of the net income (loss) of its investee (such as unconsolidated
		/// subsidiaries and joint ventures) to which the equity method of accounting is applied. The amount typically reflects adjustments.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26155
		/// </remarks>
		[JsonProperty("26155")]
		public EarningsLossesFromEquityInvestmentsCashFlowStatement EarningsLossesFromEquityInvestments { get; set; }

		/// <summary>
		/// Reductions in the entity's income taxes that arise when compensation cost (from non-qualified share-based compensation)
		/// recognized on the entities tax return exceeds compensation cost from share-based compensation recognized in financial
		/// statements. This element reduces net cash provided by operating activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26156
		/// </remarks>
		[JsonProperty("26156")]
		public ExcessTaxBenefitFromStockBasedCompensationCashFlowStatement ExcessTaxBenefitFromStockBasedCompensation { get; set; }

		/// <summary>
		/// This item represents the net total realized gain (loss) included in earnings for the period as a result of selling or holding marketable
		/// securities categorized as trading, available-for-sale, or held-to-maturity, including the unrealized holding gain or loss of held-to-
		/// maturity securities transferred to the trading security category and the cumulative unrealized gain or loss which was included in
		/// other comprehensive income (a separate component of shareholders' equity) for available-for-sale securities transferred to trading
		/// securities during the period. Additionally, this item would include any losses recognized for other than temporary impairments of the
		/// subject investments in debt and equity securities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26158
		/// </remarks>
		[JsonProperty("26158")]
		public GainLossOnInvestmentSecuritiesCashFlowStatement GainLossOnInvestmentSecurities { get; set; }

		/// <summary>
		/// The difference between the sale price or salvage price and the book value of an asset that was sold or retired during the reporting
		/// period. This element refers to the gain (loss) and not to the cash proceeds of the business. This element is a non-cash adjustment
		/// to net income when calculating net cash generated by operating activities using the indirect method.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26159
		/// </remarks>
		[JsonProperty("26159")]
		public GainLossOnSaleOfBusinessCashFlowStatement GainLossOnSaleOfBusiness { get; set; }

		/// <summary>
		/// The difference between the sale price or salvage price and the book value of the property, plant and equipment that was sold or
		/// retired during the reporting period. Includes the amount received from selling any fixed assets such as property, plant and
		/// equipment. Usually this section also includes any retirement of equipment. Such as Sale of business segments; Sale of credit and
		/// receivables; Property disposition; Proceeds from sale or disposition of business or investment; Decrease in excess of purchase price
		/// over acquired net assets; Abandoned project (expenditures) credit; Allowances for other funds during construction.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26160
		/// </remarks>
		[JsonProperty("26160")]
		public GainLossOnSaleOfPPECashFlowStatement GainLossOnSaleOfPPE { get; set; }

		/// <summary>
		/// An expense reported in the income statement and needs to be removed from net income to arrive at cash provided by (used in)
		/// operations to the extent that such interest has not been paid. This item is usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26161
		/// </remarks>
		[JsonProperty("26161")]
		public InterestCreditedOnPolicyholderDepositsCashFlowStatement InterestCreditedOnPolicyholderDeposits { get; set; }

		/// <summary>
		/// The net cash from (used in) all of the entity's discontinued operating activities, excluding those of continued operations, of the
		/// reporting entity.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26162
		/// </remarks>
		[JsonProperty("26162")]
		public CashFromDiscontinuedOperatingActivitiesCashFlowStatement CashFromDiscontinuedOperatingActivities { get; set; }

		/// <summary>
		/// The gain or loss from the entity's ongoing operations.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26163
		/// </remarks>
		[JsonProperty("26163")]
		public OperatingGainsLossesCashFlowStatement OperatingGainsLosses { get; set; }

		/// <summary>
		/// Miscellaneous charges incurred due to Financing activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26164
		/// </remarks>
		[JsonProperty("26164")]
		public NetOtherFinancingChargesCashFlowStatement NetOtherFinancingCharges { get; set; }

		/// <summary>
		/// Miscellaneous charges incurred due to Investing activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26165
		/// </remarks>
		[JsonProperty("26165")]
		public NetOtherInvestingChangesCashFlowStatement NetOtherInvestingChanges { get; set; }

		/// <summary>
		/// Items which adjusted back from net income but without real cash outflow or inflow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26166
		/// </remarks>
		[JsonProperty("26166")]
		public OtherNonCashItemsCashFlowStatement OtherNonCashItems { get; set; }

		/// <summary>
		/// The amount of pension and other (such as medical, dental and life insurance) postretirement benefit costs recognized during the
		/// period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26167
		/// </remarks>
		[JsonProperty("26167")]
		public PensionAndEmployeeBenefitExpenseCashFlowStatement PensionAndEmployeeBenefitExpense { get; set; }

		/// <summary>
		/// Pay for the amount of dividends declared or paid in the period to preferred shareholders or the amount for which the obligation to
		/// pay them dividends rose in the period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26168
		/// </remarks>
		[JsonProperty("26168")]
		public PreferredStockDividendPaidCashFlowStatement PreferredStockDividendPaid { get; set; }

		/// <summary>
		/// The aggregate amount change of (1) the lending of excess federal funds to another commercial bank requiring such for its legal
		/// reserve requirements and (2) securities purchased under agreements to resell. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26169
		/// </remarks>
		[JsonProperty("26169")]
		public ProceedsPaymentFederalFundsSoldAndSecuritiesPurchasedUnderAgreementToResellCashFlowStatement ProceedsPaymentFederalFundsSoldAndSecuritiesPurchasedUnderAgreementToResell { get; set; }

		/// <summary>
		/// The sum of the periodic provision charged to earnings, based on an assessment of uncollectible from the counterparty on account
		/// of loan, lease or other credit losses, to reduce these accounts to the amount that approximates their net realizable value. This item
		/// is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26170
		/// </remarks>
		[JsonProperty("26170")]
		public ProvisionForLoanLeaseAndOtherLossesCashFlowStatement ProvisionForLoanLeaseAndOtherLosses { get; set; }

		/// <summary>
		/// The gains and losses included in earnings that represent the difference between the sale price and the carrying value of loans and
		/// leases that were sold during the reporting period. This element refers to the gain (loss) and not to the cash proceeds of the sales.
		/// This element is a non-cash adjustment to net income when calculating net cash generated by operating activities using the indirect
		/// method. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26171
		/// </remarks>
		[JsonProperty("26171")]
		public RealizedGainLossOnSaleOfLoansAndLeaseCashFlowStatement RealizedGainLossOnSaleOfLoansAndLease { get; set; }

		/// <summary>
		/// Value of stock issued during the period as a result of any share-based compensation plan other than an employee stock ownership
		/// plan (ESOP).
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26172
		/// </remarks>
		[JsonProperty("26172")]
		public StockBasedCompensationCashFlowStatement StockBasedCompensation { get; set; }

		/// <summary>
		/// The increases (decreases) in the market value of unsold securities whose gains (losses) were included in earnings.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26173
		/// </remarks>
		[JsonProperty("26173")]
		public UnrealizedGainLossOnInvestmentSecuritiesCashFlowStatement UnrealizedGainLossOnInvestmentSecurities { get; set; }

		/// <summary>
		/// The gross gains and losses on derivatives. This item is usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26174
		/// </remarks>
		[JsonProperty("26174")]
		public UnrealizedGainsLossesOnDerivativesCashFlowStatement UnrealizedGainsLossesOnDerivatives { get; set; }

		/// <summary>
		/// The aggregate expense charged against earnings to allocate the cost of intangible assets (nonphysical assets not used in
		/// production) in a systematic and rational manner to the periods expected to benefit from such assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26175
		/// </remarks>
		[JsonProperty("26175")]
		public AmortizationOfIntangiblesCashFlowStatement AmortizationOfIntangibles { get; set; }

		/// <summary>
		/// The amount of cash paid during the current period to foreign, federal state and local authorities as taxes on income.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26179
		/// </remarks>
		[JsonProperty("26179")]
		public IncomeTaxPaidSupplementalDataCashFlowStatement IncomeTaxPaidSupplementalData { get; set; }

		/// <summary>
		/// The amount of cash paid during the current period for interest owed on money borrowed; including amount of interest capitalized.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26180
		/// </remarks>
		[JsonProperty("26180")]
		public InterestPaidSupplementalDataCashFlowStatement InterestPaidSupplementalData { get; set; }

		/// <summary>
		/// The cash inflow from offering common stock, which is the additional capital contribution to the entity during the period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26181
		/// </remarks>
		[JsonProperty("26181")]
		public IssuanceOfCapitalStockCashFlowStatement IssuanceOfCapitalStock { get; set; }

		/// <summary>
		/// The cash inflow due to an increase in long term debt.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26182
		/// </remarks>
		[JsonProperty("26182")]
		public IssuanceOfDebtCashFlowStatement IssuanceOfDebt { get; set; }

		/// <summary>
		/// Payments to Settle Long Term Debt plus Payments to Settle Short Term Debt.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26183
		/// </remarks>
		[JsonProperty("26183")]
		public RepaymentOfDebtCashFlowStatement RepaymentOfDebt { get; set; }

		/// <summary>
		/// Payments for Common Stock plus Payments for Preferred Stock.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26184
		/// </remarks>
		[JsonProperty("26184")]
		public RepurchaseOfCapitalStockCashFlowStatement RepurchaseOfCapitalStock { get; set; }

		/// <summary>
		/// Cash Flow Operations minus Capital Expenditures.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26185
		/// </remarks>
		[JsonProperty("26185")]
		public FreeCashFlowCashFlowStatement FreeCashFlow { get; set; }

		/// <summary>
		/// The net change on interest-bearing deposits in other financial institutions for relatively short periods of time including, for example,
		/// certificates of deposits.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26188
		/// </remarks>
		[JsonProperty("26188")]
		public DecreaseinInterestBearingDepositsinBankCashFlowStatement DecreaseinInterestBearingDepositsinBank { get; set; }

		/// <summary>
		/// Increase in interest-bearing deposits in bank.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26189
		/// </remarks>
		[JsonProperty("26189")]
		public IncreaseinInterestBearingDepositsinBankCashFlowStatement IncreaseinInterestBearingDepositsinBank { get; set; }

		/// <summary>
		/// Interest received by the company, in the Operating Cash Flow section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26194
		/// </remarks>
		[JsonProperty("26194")]
		public InterestReceivedCFOCashFlowStatement InterestReceivedCFO { get; set; }

		/// <summary>
		/// Interest paid on loans, debt or borrowings, in the Operating Cash Flow section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26195
		/// </remarks>
		[JsonProperty("26195")]
		public InterestPaidCFOCashFlowStatement InterestPaidCFO { get; set; }

		/// <summary>
		/// Purchase of subsidiaries or interest in subsidiaries (investments 51% and above).
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26196
		/// </remarks>
		[JsonProperty("26196")]
		public PurchaseofSubsidiariesCashFlowStatement PurchaseofSubsidiaries { get; set; }

		/// <summary>
		/// Purchase of joint venture/associates (investment below 50%).
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26197
		/// </remarks>
		[JsonProperty("26197")]
		public PurchaseofJointVentureAssociateCashFlowStatement PurchaseofJointVentureAssociate { get; set; }

		/// <summary>
		/// Cash inflow from the disposal of any subsidiaries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26198
		/// </remarks>
		[JsonProperty("26198")]
		public SaleofSubsidiariesCashFlowStatement SaleofSubsidiaries { get; set; }

		/// <summary>
		/// Cash inflow from the disposal of joint venture/associates (investment below 50%).
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26199
		/// </remarks>
		[JsonProperty("26199")]
		public SaleofJointVentureAssociateCashFlowStatement SaleofJointVentureAssociate { get; set; }

		/// <summary>
		/// Change in cash flow resulting from increase/decrease in lease financing.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26200
		/// </remarks>
		[JsonProperty("26200")]
		public IncreaseDecreaseinLeaseFinancingCashFlowStatement IncreaseDecreaseinLeaseFinancing { get; set; }

		/// <summary>
		/// The cash inflow from increase in lease financing.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26201
		/// </remarks>
		[JsonProperty("26201")]
		public IncreaseinLeaseFinancingCashFlowStatement IncreaseinLeaseFinancing { get; set; }

		/// <summary>
		/// The cash outflow to repay lease financing during the period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26202
		/// </remarks>
		[JsonProperty("26202")]
		public RepaymentinLeaseFinancingCashFlowStatement RepaymentinLeaseFinancing { get; set; }

		/// <summary>
		/// A non-cash adjustment for share of associates' income in respect of operating activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26203
		/// </remarks>
		[JsonProperty("26203")]
		public ShareofAssociatesCashFlowStatement ShareofAssociates { get; set; }

		/// <summary>
		/// The difference between the sale price or salvage price and the book value of an asset that was sold or retired during the reporting
		/// period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26204
		/// </remarks>
		[JsonProperty("26204")]
		public ProfitonDisposalsCashFlowStatement ProfitonDisposals { get; set; }

		/// <summary>
		/// A non-cash adjustment relating to restructuring costs.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26205
		/// </remarks>
		[JsonProperty("26205")]
		public ReorganizationOtherCostsCashFlowStatement ReorganizationOtherCosts { get; set; }

		/// <summary>
		/// Adjustments due to net loans to/from outsiders in the Investing Cash Flow section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26207
		/// </remarks>
		[JsonProperty("26207")]
		public NetOutwardLoansCashFlowStatement NetOutwardLoans { get; set; }

		/// <summary>
		/// Cost associated with issuance of debt/equity capital in the Financing Cash Flow section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26208
		/// </remarks>
		[JsonProperty("26208")]
		public IssueExpensesCashFlowStatement IssueExpenses { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the deposits by banks and customers.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26219
		/// </remarks>
		[JsonProperty("26219")]
		public ChangeinDepositsbyBanksandCustomersCashFlowStatement ChangeinDepositsbyBanksandCustomers { get; set; }

		/// <summary>
		/// The net cash from (used in) all of the entity's operating activities, including those of discontinued operations, of the reporting entity
		/// under the direct method.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26220
		/// </remarks>
		[JsonProperty("26220")]
		public CashFlowsfromusedinOperatingActivitiesDirectCashFlowStatement CashFlowsfromusedinOperatingActivitiesDirect { get; set; }

		/// <summary>
		/// Sum of total cash receipts in the direct cash flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26221
		/// </remarks>
		[JsonProperty("26221")]
		public ClassesofCashReceiptsfromOperatingActivitiesCashFlowStatement ClassesofCashReceiptsfromOperatingActivities { get; set; }

		/// <summary>
		/// Other cash receipts for the direct cash flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26222
		/// </remarks>
		[JsonProperty("26222")]
		public OtherCashReceiptsfromOperatingActivitiesCashFlowStatement OtherCashReceiptsfromOperatingActivities { get; set; }

		/// <summary>
		/// Sum of total cash payment in the direct cash flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26223
		/// </remarks>
		[JsonProperty("26223")]
		public ClassesofCashPaymentsCashFlowStatement ClassesofCashPayments { get; set; }

		/// <summary>
		/// Cash paid to suppliers when purchasing goods or services by the company, in the direct cash flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26224
		/// </remarks>
		[JsonProperty("26224")]
		public PaymentstoSuppliersforGoodsandServicesCashFlowStatement PaymentstoSuppliersforGoodsandServices { get; set; }

		/// <summary>
		/// Cash paid in a form of salaries or other benefits to employees of the company, in the direct cash flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26226
		/// </remarks>
		[JsonProperty("26226")]
		public PaymentsonBehalfofEmployeesCashFlowStatement PaymentsonBehalfofEmployees { get; set; }

		/// <summary>
		/// Other cash payments for the direct cash flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26228
		/// </remarks>
		[JsonProperty("26228")]
		public OtherCashPaymentsfromOperatingActivitiesCashFlowStatement OtherCashPaymentsfromOperatingActivities { get; set; }

		/// <summary>
		/// Dividend paid to the investors, for the direct cash flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26229
		/// </remarks>
		[JsonProperty("26229")]
		public DividendsPaidDirectCashFlowStatement DividendsPaidDirect { get; set; }

		/// <summary>
		/// Dividend received on the investment, for the direct cash flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26230
		/// </remarks>
		[JsonProperty("26230")]
		public DividendsReceivedDirectCashFlowStatement DividendsReceivedDirect { get; set; }

		/// <summary>
		/// Interest paid on loans, debt or borrowings, in the direct cash flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26231
		/// </remarks>
		[JsonProperty("26231")]
		public InterestPaidDirectCashFlowStatement InterestPaidDirect { get; set; }

		/// <summary>
		/// Interest received by the company, in the direct cash flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26232
		/// </remarks>
		[JsonProperty("26232")]
		public InterestReceivedDirectCashFlowStatement InterestReceivedDirect { get; set; }

		/// <summary>
		/// Tax paid/refund related to operating activities, for the direct cash flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26233
		/// </remarks>
		[JsonProperty("26233")]
		public TaxesRefundPaidDirectCashFlowStatement TaxesRefundPaidDirect { get; set; }

		/// <summary>
		/// Sum of all adjustments back from net income but without real cash outflow or inflow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26234
		/// </remarks>
		[JsonProperty("26234")]
		public TotalAdjustmentsforNonCashItemsCashFlowStatement TotalAdjustmentsforNonCashItems { get; set; }

		/// <summary>
		/// The difference between the future net cash flows expected to be received from the asset and its book value, recognized in the
		/// Income Statement.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26235
		/// </remarks>
		[JsonProperty("26235")]
		public ImpairmentLossReversalRecognizedinProfitorLossCashFlowStatement ImpairmentLossReversalRecognizedinProfitorLoss { get; set; }

		/// <summary>
		/// Dividend paid to the investors, in the Operating Cash Flow section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26238
		/// </remarks>
		[JsonProperty("26238")]
		public DividendPaidCFOCashFlowStatement DividendPaidCFO { get; set; }

		/// <summary>
		/// Dividend received on investment, in the Operating Cash Flow section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26239
		/// </remarks>
		[JsonProperty("26239")]
		public DividendReceivedCFOCashFlowStatement DividendReceivedCFO { get; set; }

		/// <summary>
		/// Total tax paid or received on operating activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26240
		/// </remarks>
		[JsonProperty("26240")]
		public TaxesRefundPaidCashFlowStatement TaxesRefundPaid { get; set; }

		/// <summary>
		/// Any other cash inflows or outflows in the Operating Cash Flow section, not accounted for in the other specified items.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26241
		/// </remarks>
		[JsonProperty("26241")]
		public OtherOperatingInflowsOutflowsofCashCashFlowStatement OtherOperatingInflowsOutflowsofCash { get; set; }

		/// <summary>
		/// Cash outlay for cash advances and loans made to other parties.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26243
		/// </remarks>
		[JsonProperty("26243")]
		public CashAdvancesandLoansMadetoOtherPartiesCashFlowStatement CashAdvancesandLoansMadetoOtherParties { get; set; }

		/// <summary>
		/// Cash received from the repayment of advances and loans made to other parties, in the Investing Cash Flow section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26244
		/// </remarks>
		[JsonProperty("26244")]
		public CashReceiptsfromRepaymentofAdvancesandLoansMadetoOtherPartiesCashFlowStatement CashReceiptsfromRepaymentofAdvancesandLoansMadetoOtherParties { get; set; }

		/// <summary>
		/// Dividend received on investment, in the Investing Cash Flow section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26246
		/// </remarks>
		[JsonProperty("26246")]
		public DividendsReceivedCFICashFlowStatement DividendsReceivedCFI { get; set; }

		/// <summary>
		/// Interest received by the company, in the Investing Cash Flow section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26247
		/// </remarks>
		[JsonProperty("26247")]
		public InterestReceivedCFICashFlowStatement InterestReceivedCFI { get; set; }

		/// <summary>
		/// Interest paid on loans, debt or borrowings, in the Financing Cash Flow section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26253
		/// </remarks>
		[JsonProperty("26253")]
		public InterestPaidCFFCashFlowStatement InterestPaidCFF { get; set; }

		/// <summary>
		/// The increase or decrease between periods in the amount of outstanding money owed by a customer for goods or services provided
		/// by the company.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26255
		/// </remarks>
		[JsonProperty("26255")]
		public ChangeinAccruedIncomeCashFlowStatement ChangeinAccruedIncome { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the financial assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26258
		/// </remarks>
		[JsonProperty("26258")]
		public ChangeinFinancialAssetsCashFlowStatement ChangeinFinancialAssets { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the advances from central banks.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26259
		/// </remarks>
		[JsonProperty("26259")]
		public ChangeinAdvancesfromCentralBanksCashFlowStatement ChangeinAdvancesfromCentralBanks { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the financial liabilities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26260
		/// </remarks>
		[JsonProperty("26260")]
		public ChangeinFinancialLiabilitiesCashFlowStatement ChangeinFinancialLiabilities { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the contract assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26261
		/// </remarks>
		[JsonProperty("26261")]
		public ChangeinInsuranceContractAssetsCashFlowStatement ChangeinInsuranceContractAssets { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the reinsurance receivable.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26262
		/// </remarks>
		[JsonProperty("26262")]
		public ChangeinReinsuranceReceivablesCashFlowStatement ChangeinReinsuranceReceivables { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the deferred acquisition costs.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26263
		/// </remarks>
		[JsonProperty("26263")]
		public ChangeinDeferredAcquisitionCostsNetCashFlowStatement ChangeinDeferredAcquisitionCostsNet { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the insurance funds.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26264
		/// </remarks>
		[JsonProperty("26264")]
		public ChangeinInsuranceFundsCashFlowStatement ChangeinInsuranceFunds { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the investment contract liabilities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26266
		/// </remarks>
		[JsonProperty("26266")]
		public ChangeinInvestmentContractLiabilitiesCashFlowStatement ChangeinInvestmentContractLiabilities { get; set; }

		/// <summary>
		/// The increase or decrease between periods of the insurance contract liabilities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26267
		/// </remarks>
		[JsonProperty("26267")]
		public ChangeinInsuranceContractLiabilitiesCashFlowStatement ChangeinInsuranceContractLiabilities { get; set; }

		/// <summary>
		/// A non-cash adjustment for total provision and write off on assets &amp; liabilities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26269
		/// </remarks>
		[JsonProperty("26269")]
		public ProvisionandWriteOffofAssetsCashFlowStatement ProvisionandWriteOffofAssets { get; set; }

		/// <summary>
		/// Payment received from customers in the Direct Cash Flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26270
		/// </remarks>
		[JsonProperty("26270")]
		public ReceiptsfromCustomersCashFlowStatement ReceiptsfromCustomers { get; set; }

		/// <summary>
		/// Cash received from governments in the form of grants in the Direct Cash Flow.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26271
		/// </remarks>
		[JsonProperty("26271")]
		public ReceiptsfromGovernmentGrantsCashFlowStatement ReceiptsfromGovernmentGrants { get; set; }

		/// <summary>
		/// Amount of net income (loss) for the period allocated to non-controlling shareholders, partners, or other equity holders in one or
		/// more of the entities included.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26272
		/// </remarks>
		[JsonProperty("26272")]
		public MinorityInterestCashFlowStatement MinorityInterest { get; set; }

		/// <summary>
		/// Capital expenditure, capitalized software development cost, maintenance capital expenditure, etc. as reported by the company.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26273
		/// </remarks>
		[JsonProperty("26273")]
		public CapExReportedCashFlowStatement CapExReported { get; set; }

		/// <summary>
		/// Cash received as refunds from tax authorities in operating cash flow, using the direct method
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26274
		/// </remarks>
		[JsonProperty("26274")]
		public CashReceiptsfromTaxRefundsCashFlowStatement CashReceiptsfromTaxRefunds { get; set; }

		/// <summary>
		/// Cash received from banks and customer deposits in operating cash flow, using the direct method. This item is usually only available
		/// for bank industry
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26276
		/// </remarks>
		[JsonProperty("26276")]
		public CashReceiptsfromDepositsbyBanksandCustomersCashFlowStatement CashReceiptsfromDepositsbyBanksandCustomers { get; set; }

		/// <summary>
		/// Cash received from loans in operating cash flow, using the direct method. This item is usually only available for bank industry
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26277
		/// </remarks>
		[JsonProperty("26277")]
		public CashReceiptsfromLoansCashFlowStatement CashReceiptsfromLoans { get; set; }

		/// <summary>
		/// Cash received from the trading of securities in operating cash flow, using the direct method. This item is usually only available for
		/// bank and insurance industries
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26278
		/// </remarks>
		[JsonProperty("26278")]
		public CashReceiptsfromSecuritiesRelatedActivitiesCashFlowStatement CashReceiptsfromSecuritiesRelatedActivities { get; set; }

		/// <summary>
		/// Cash received from agency fees and commissions in operating cash flow, using the direct method. This item is usually available for
		/// bank and insurance industries
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26280
		/// </remarks>
		[JsonProperty("26280")]
		public CashReceiptsfromFeesandCommissionsCashFlowStatement CashReceiptsfromFeesandCommissions { get; set; }

		/// <summary>
		/// Cash paid for deposits by banks and customers in operating cash flow, using the direct method. This item is usually only available
		/// for bank industry
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26282
		/// </remarks>
		[JsonProperty("26282")]
		public CashPaymentsforDepositsbyBanksandCustomersCashFlowStatement CashPaymentsforDepositsbyBanksandCustomers { get; set; }

		/// <summary>
		/// Cash paid for loans in operating cash flow, using the direct method. This item is usually only available for bank industry
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26283
		/// </remarks>
		[JsonProperty("26283")]
		public CashPaymentsforLoansCashFlowStatement CashPaymentsforLoans { get; set; }

		/// <summary>
		/// Cash paid for interest and commission in operating cash flow, using the direct method
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26284
		/// </remarks>
		[JsonProperty("26284")]
		public InterestandCommissionPaidCashFlowStatement InterestandCommissionPaid { get; set; }

		/// <summary>
		/// Cash paid to tax authorities in operating cash flow, using the direct method
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26285
		/// </remarks>
		[JsonProperty("26285")]
		public AllTaxesPaidCashFlowStatement AllTaxesPaid { get; set; }

		/// <summary>
		/// Cash received from insurance activities in operating cash flow, using the direct method. This item is usually only available for
		/// insurance industry
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26286
		/// </remarks>
		[JsonProperty("26286")]
		public CashReceivedfromInsuranceActivitiesCashFlowStatement CashReceivedfromInsuranceActivities { get; set; }

		/// <summary>
		/// Cash received from premium income in operating cash flow, using the direct method. This item is usually only available for
		/// insurance industry
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26287
		/// </remarks>
		[JsonProperty("26287")]
		public PremiumReceivedCashFlowStatement PremiumReceived { get; set; }

		/// <summary>
		/// Cash received from reinsurance income or other recoveries income in operating cash flow, using the direct method. This item is
		/// usually only available for insurance industry
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26288
		/// </remarks>
		[JsonProperty("26288")]
		public ReinsuranceandOtherRecoveriesReceivedCashFlowStatement ReinsuranceandOtherRecoveriesReceived { get; set; }

		/// <summary>
		/// Cash received from policyholder deposit investment activities in operating cash flow, using the direct method. This item is usually
		/// only available for insurance industry
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26289
		/// </remarks>
		[JsonProperty("26289")]
		public PolicyholderDepositInvestmentReceivedCashFlowStatement PolicyholderDepositInvestmentReceived { get; set; }

		/// <summary>
		/// Cash paid out for insurance activities during the period in operating cash flow, using the direct method. This item is usually only
		/// available for insurance industry
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26290
		/// </remarks>
		[JsonProperty("26290")]
		public CashPaidforInsuranceActivitiesCashFlowStatement CashPaidforInsuranceActivities { get; set; }

		/// <summary>
		/// Cash paid out for claims by a insurance company during the period in operating cash flow, using the direct method. This item is
		/// usually only available for insurance industry
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26291
		/// </remarks>
		[JsonProperty("26291")]
		public ClaimsPaidCashFlowStatement ClaimsPaid { get; set; }

		/// <summary>
		/// Cash paid for commissions in operating cash flow, using the direct method
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26292
		/// </remarks>
		[JsonProperty("26292")]
		public CommissionPaidCashFlowStatement CommissionPaid { get; set; }

		/// <summary>
		/// Cash paid out to reinsurers in operating cash flow, using the direct method. This item is usually only available for insurance industry
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26293
		/// </remarks>
		[JsonProperty("26293")]
		public CashPaidtoReinsurersCashFlowStatement CashPaidtoReinsurers { get; set; }

		/// <summary>
		/// Cash paid out for underwriting expenses, such as the acquisition of new and renewal insurance contracts, in operating cash flow,
		/// using the direct method. This item is usually only available for insurance industry
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26294
		/// </remarks>
		[JsonProperty("26294")]
		public OtherUnderwritingExpensesPaidCashFlowStatement OtherUnderwritingExpensesPaid { get; set; }

		/// <summary>
		/// Cash Distribution of earnings to Minority Stockholders.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26295
		/// </remarks>
		[JsonProperty("26295")]
		public CashDividendsForMinoritiesCashFlowStatement CashDividendsForMinorities { get; set; }

		/// <summary>
		/// Filing date of the Cash Flow Statement.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26296
		/// </remarks>
		[JsonProperty("26296")]
		public DateTime CFFileDate { get; set; }

		/// <summary>
		/// The net cash from an entity's operating activities before real cash inflow or outflow for Dividend, Interest, Tax, or other unclassified
		/// operating activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26298
		/// </remarks>
		[JsonProperty("26298")]
		public CashGeneratedfromOperatingActivitiesCashFlowStatement CashGeneratedfromOperatingActivities { get; set; }

		/// <summary>
		/// Funds from operations; populated only for real estate investment trusts (REITs), defined as the sum of net income, gain/loss
		/// (realized and unrealized) on investment securities, asset impairment charge, depreciation and amortization and gain/ loss on the
		/// sale of business and property plant and equipment.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26299
		/// </remarks>
		[JsonProperty("26299")]
		public FundFromOperationCashFlowStatement FundFromOperation { get; set; }

		/// <summary>
		/// Net increase or decrease in cash due to purchases or sales of investment properties during the accounting period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26300
		/// </remarks>
		[JsonProperty("26300")]
		public NetInvestmentPropertiesPurchaseAndSaleCashFlowStatement NetInvestmentPropertiesPurchaseAndSale { get; set; }

		/// <summary>
		/// Cash outflow for purchases of investment properties during the accounting period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26301
		/// </remarks>
		[JsonProperty("26301")]
		public PurchaseOfInvestmentPropertiesCashFlowStatement PurchaseOfInvestmentProperties { get; set; }

		/// <summary>
		/// Cash inflow from sale of investment properties during the accounting period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26302
		/// </remarks>
		[JsonProperty("26302")]
		public SaleOfInvestmentPropertiesCashFlowStatement SaleOfInvestmentProperties { get; set; }

		/// <summary>
		/// Other cash adjustments included in change in cash not categorized above.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26303
		/// </remarks>
		[JsonProperty("26303")]
		public OtherCashAdjustIncludedIntoChangeinCashCashFlowStatement OtherCashAdjustIncludedIntoChangeinCash { get; set; }

		/// <summary>
		/// Other changes to cash and cash equivalents during the accounting period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26304
		/// </remarks>
		[JsonProperty("26304")]
		public OtherCashAdjustExcludeFromChangeinCashCashFlowStatement OtherCashAdjustExcludeFromChangeinCash { get; set; }

		/// <summary>
		/// The change in cash flow from the previous period to the current, as reported by the company, may be the same or not the same as
		/// Morningstar's standardized definition. It is a supplemental value which would be reported outside consolidated statements.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 26305
		/// </remarks>
		[JsonProperty("26305")]
		public ChangeinCashSupplementalAsReportedCashFlowStatement ChangeinCashSupplementalAsReported { get; set; }

		/// <summary>
		/// Creates an instance of the CashFlowStatement class
		/// </summary>
		public CashFlowStatement()
		{
			Amortization = new AmortizationCashFlowStatement();
			CapitalExpenditure = new CapitalExpenditureCashFlowStatement();
			CashDividendsPaid = new CashDividendsPaidCashFlowStatement();
			CashFlowFromContinuingFinancingActivities = new CashFlowFromContinuingFinancingActivitiesCashFlowStatement();
			CashFlowFromContinuingInvestingActivities = new CashFlowFromContinuingInvestingActivitiesCashFlowStatement();
			CashFlowFromContinuingOperatingActivities = new CashFlowFromContinuingOperatingActivitiesCashFlowStatement();
			CashFlowFromDiscontinuedOperation = new CashFlowFromDiscontinuedOperationCashFlowStatement();
			FinancingCashFlow = new FinancingCashFlowCashFlowStatement();
			InvestingCashFlow = new InvestingCashFlowCashFlowStatement();
			OperatingCashFlow = new OperatingCashFlowCashFlowStatement();
			BeginningCashPosition = new BeginningCashPositionCashFlowStatement();
			EndCashPosition = new EndCashPositionCashFlowStatement();
			CashFromDiscontinuedFinancing = new CashFromDiscontinuedFinancingCashFlowStatement();
			CashFromDiscontinuedFinancingActivities = new CashFromDiscontinuedFinancingActivitiesCashFlowStatement();
			CashFromDiscontinuedInvesting = new CashFromDiscontinuedInvestingCashFlowStatement();
			CashFromDiscontinuedInvestingActivities = new CashFromDiscontinuedInvestingActivitiesCashFlowStatement();
			CashFromDiscontinuedOperating = new CashFromDiscontinuedOperatingCashFlowStatement();
			ChangeInAccountPayable = new ChangeInAccountPayableCashFlowStatement();
			ChangeInTaxPayable = new ChangeInTaxPayableCashFlowStatement();
			ChangeInAccruedExpense = new ChangeInAccruedExpenseCashFlowStatement();
			ChangeInAccruedInvestmentIncome = new ChangeInAccruedInvestmentIncomeCashFlowStatement();
			ChangesInCash = new ChangesInCashCashFlowStatement();
			ChangeInDeferredAcquisitionCosts = new ChangeInDeferredAcquisitionCostsCashFlowStatement();
			ChangeInFederalFundsAndSecuritiesSoldForRepurchase = new ChangeInFederalFundsAndSecuritiesSoldForRepurchaseCashFlowStatement();
			ChangeInFundsWithheld = new ChangeInFundsWithheldCashFlowStatement();
			ChangeInIncomeTaxPayable = new ChangeInIncomeTaxPayableCashFlowStatement();
			ChangeInInterestPayable = new ChangeInInterestPayableCashFlowStatement();
			ChangeInInventory = new ChangeInInventoryCashFlowStatement();
			ChangeInLoans = new ChangeInLoansCashFlowStatement();
			ChangeInLossAndLossAdjustmentExpenseReserves = new ChangeInLossAndLossAdjustmentExpenseReservesCashFlowStatement();
			ChangeInPayable = new ChangeInPayableCashFlowStatement();
			ChangeInPayablesAndAccruedExpense = new ChangeInPayablesAndAccruedExpenseCashFlowStatement();
			ChangeInPrepaidAssets = new ChangeInPrepaidAssetsCashFlowStatement();
			ChangeInReceivables = new ChangeInReceivablesCashFlowStatement();
			ChangeInReinsuranceRecoverableOnPaidAndUnpaidLosses = new ChangeInReinsuranceRecoverableOnPaidAndUnpaidLossesCashFlowStatement();
			ChangeInRestrictedCash = new ChangeInRestrictedCashCashFlowStatement();
			ChangeInTradingAccountSecurities = new ChangeInTradingAccountSecuritiesCashFlowStatement();
			ChangeInWorkingCapital = new ChangeInWorkingCapitalCashFlowStatement();
			DeferredIncomeTax = new DeferredIncomeTaxCashFlowStatement();
			DeferredTax = new DeferredTaxCashFlowStatement();
			Depletion = new DepletionCashFlowStatement();
			Depreciation = new DepreciationCashFlowStatement();
			DepreciationAndAmortization = new DepreciationAndAmortizationCashFlowStatement();
			DepreciationAmortizationDepletion = new DepreciationAmortizationDepletionCashFlowStatement();
			EffectOfExchangeRateChanges = new EffectOfExchangeRateChangesCashFlowStatement();
			IncreaseDecreaseInDeposit = new IncreaseDecreaseInDepositCashFlowStatement();
			NetCommonStockIssuance = new NetCommonStockIssuanceCashFlowStatement();
			NetIssuancePaymentsOfDebt = new NetIssuancePaymentsOfDebtCashFlowStatement();
			NetLongTermDebtIssuance = new NetLongTermDebtIssuanceCashFlowStatement();
			NetPreferredStockIssuance = new NetPreferredStockIssuanceCashFlowStatement();
			NetShortTermDebtIssuance = new NetShortTermDebtIssuanceCashFlowStatement();
			NetCashFromDiscontinuedOperations = new NetCashFromDiscontinuedOperationsCashFlowStatement();
			NetForeignCurrencyExchangeGainLoss = new NetForeignCurrencyExchangeGainLossCashFlowStatement();
			NetIncomeFromContinuingOperations = new NetIncomeFromContinuingOperationsCashFlowStatement();
			PaymentForLoans = new PaymentForLoansCashFlowStatement();
			CommonStockPayments = new CommonStockPaymentsCashFlowStatement();
			PreferredStockPayments = new PreferredStockPaymentsCashFlowStatement();
			LongTermDebtPayments = new LongTermDebtPaymentsCashFlowStatement();
			ShortTermDebtPayments = new ShortTermDebtPaymentsCashFlowStatement();
			ProceedsFromLoans = new ProceedsFromLoansCashFlowStatement();
			ProceedsFromStockOptionExercised = new ProceedsFromStockOptionExercisedCashFlowStatement();
			CommonStockIssuance = new CommonStockIssuanceCashFlowStatement();
			LongTermDebtIssuance = new LongTermDebtIssuanceCashFlowStatement();
			PreferredStockIssuance = new PreferredStockIssuanceCashFlowStatement();
			ShortTermDebtIssuance = new ShortTermDebtIssuanceCashFlowStatement();
			NetProceedsPaymentForLoan = new NetProceedsPaymentForLoanCashFlowStatement();
			ProceedsPaymentInInterestBearingDepositsInBank = new ProceedsPaymentInInterestBearingDepositsInBankCashFlowStatement();
			PurchaseOfIntangibles = new PurchaseOfIntangiblesCashFlowStatement();
			PurchaseOfInvestment = new PurchaseOfInvestmentCashFlowStatement();
			PurchaseOfPPE = new PurchaseOfPPECashFlowStatement();
			PurchaseOfBusiness = new PurchaseOfBusinessCashFlowStatement();
			NetBusinessPurchaseAndSale = new NetBusinessPurchaseAndSaleCashFlowStatement();
			NetIntangiblesPurchaseAndSale = new NetIntangiblesPurchaseAndSaleCashFlowStatement();
			NetInvestmentPurchaseAndSale = new NetInvestmentPurchaseAndSaleCashFlowStatement();
			NetPPEPurchaseAndSale = new NetPPEPurchaseAndSaleCashFlowStatement();
			SaleOfBusiness = new SaleOfBusinessCashFlowStatement();
			SaleOfIntangibles = new SaleOfIntangiblesCashFlowStatement();
			SaleOfInvestment = new SaleOfInvestmentCashFlowStatement();
			SaleOfPPE = new SaleOfPPECashFlowStatement();
			ChangesInAccountReceivables = new ChangesInAccountReceivablesCashFlowStatement();
			AmortizationOfFinancingCostsAndDiscounts = new AmortizationOfFinancingCostsAndDiscountsCashFlowStatement();
			AmortizationOfSecurities = new AmortizationOfSecuritiesCashFlowStatement();
			AssetImpairmentCharge = new AssetImpairmentChargeCashFlowStatement();
			ChangeInDividendPayable = new ChangeInDividendPayableCashFlowStatement();
			ChangeInDeferredCharges = new ChangeInDeferredChargesCashFlowStatement();
			ChangeInOtherCurrentAssets = new ChangeInOtherCurrentAssetsCashFlowStatement();
			ChangeInOtherCurrentLiabilities = new ChangeInOtherCurrentLiabilitiesCashFlowStatement();
			ChangeInOtherWorkingCapital = new ChangeInOtherWorkingCapitalCashFlowStatement();
			ChangeInUnearnedPremiums = new ChangeInUnearnedPremiumsCashFlowStatement();
			CommonStockDividendPaid = new CommonStockDividendPaidCashFlowStatement();
			EarningsLossesFromEquityInvestments = new EarningsLossesFromEquityInvestmentsCashFlowStatement();
			ExcessTaxBenefitFromStockBasedCompensation = new ExcessTaxBenefitFromStockBasedCompensationCashFlowStatement();
			GainLossOnInvestmentSecurities = new GainLossOnInvestmentSecuritiesCashFlowStatement();
			GainLossOnSaleOfBusiness = new GainLossOnSaleOfBusinessCashFlowStatement();
			GainLossOnSaleOfPPE = new GainLossOnSaleOfPPECashFlowStatement();
			InterestCreditedOnPolicyholderDeposits = new InterestCreditedOnPolicyholderDepositsCashFlowStatement();
			CashFromDiscontinuedOperatingActivities = new CashFromDiscontinuedOperatingActivitiesCashFlowStatement();
			OperatingGainsLosses = new OperatingGainsLossesCashFlowStatement();
			NetOtherFinancingCharges = new NetOtherFinancingChargesCashFlowStatement();
			NetOtherInvestingChanges = new NetOtherInvestingChangesCashFlowStatement();
			OtherNonCashItems = new OtherNonCashItemsCashFlowStatement();
			PensionAndEmployeeBenefitExpense = new PensionAndEmployeeBenefitExpenseCashFlowStatement();
			PreferredStockDividendPaid = new PreferredStockDividendPaidCashFlowStatement();
			ProceedsPaymentFederalFundsSoldAndSecuritiesPurchasedUnderAgreementToResell = new ProceedsPaymentFederalFundsSoldAndSecuritiesPurchasedUnderAgreementToResellCashFlowStatement();
			ProvisionForLoanLeaseAndOtherLosses = new ProvisionForLoanLeaseAndOtherLossesCashFlowStatement();
			RealizedGainLossOnSaleOfLoansAndLease = new RealizedGainLossOnSaleOfLoansAndLeaseCashFlowStatement();
			StockBasedCompensation = new StockBasedCompensationCashFlowStatement();
			UnrealizedGainLossOnInvestmentSecurities = new UnrealizedGainLossOnInvestmentSecuritiesCashFlowStatement();
			UnrealizedGainsLossesOnDerivatives = new UnrealizedGainsLossesOnDerivativesCashFlowStatement();
			AmortizationOfIntangibles = new AmortizationOfIntangiblesCashFlowStatement();
			IncomeTaxPaidSupplementalData = new IncomeTaxPaidSupplementalDataCashFlowStatement();
			InterestPaidSupplementalData = new InterestPaidSupplementalDataCashFlowStatement();
			IssuanceOfCapitalStock = new IssuanceOfCapitalStockCashFlowStatement();
			IssuanceOfDebt = new IssuanceOfDebtCashFlowStatement();
			RepaymentOfDebt = new RepaymentOfDebtCashFlowStatement();
			RepurchaseOfCapitalStock = new RepurchaseOfCapitalStockCashFlowStatement();
			FreeCashFlow = new FreeCashFlowCashFlowStatement();
			DecreaseinInterestBearingDepositsinBank = new DecreaseinInterestBearingDepositsinBankCashFlowStatement();
			IncreaseinInterestBearingDepositsinBank = new IncreaseinInterestBearingDepositsinBankCashFlowStatement();
			InterestReceivedCFO = new InterestReceivedCFOCashFlowStatement();
			InterestPaidCFO = new InterestPaidCFOCashFlowStatement();
			PurchaseofSubsidiaries = new PurchaseofSubsidiariesCashFlowStatement();
			PurchaseofJointVentureAssociate = new PurchaseofJointVentureAssociateCashFlowStatement();
			SaleofSubsidiaries = new SaleofSubsidiariesCashFlowStatement();
			SaleofJointVentureAssociate = new SaleofJointVentureAssociateCashFlowStatement();
			IncreaseDecreaseinLeaseFinancing = new IncreaseDecreaseinLeaseFinancingCashFlowStatement();
			IncreaseinLeaseFinancing = new IncreaseinLeaseFinancingCashFlowStatement();
			RepaymentinLeaseFinancing = new RepaymentinLeaseFinancingCashFlowStatement();
			ShareofAssociates = new ShareofAssociatesCashFlowStatement();
			ProfitonDisposals = new ProfitonDisposalsCashFlowStatement();
			ReorganizationOtherCosts = new ReorganizationOtherCostsCashFlowStatement();
			NetOutwardLoans = new NetOutwardLoansCashFlowStatement();
			IssueExpenses = new IssueExpensesCashFlowStatement();
			ChangeinDepositsbyBanksandCustomers = new ChangeinDepositsbyBanksandCustomersCashFlowStatement();
			CashFlowsfromusedinOperatingActivitiesDirect = new CashFlowsfromusedinOperatingActivitiesDirectCashFlowStatement();
			ClassesofCashReceiptsfromOperatingActivities = new ClassesofCashReceiptsfromOperatingActivitiesCashFlowStatement();
			OtherCashReceiptsfromOperatingActivities = new OtherCashReceiptsfromOperatingActivitiesCashFlowStatement();
			ClassesofCashPayments = new ClassesofCashPaymentsCashFlowStatement();
			PaymentstoSuppliersforGoodsandServices = new PaymentstoSuppliersforGoodsandServicesCashFlowStatement();
			PaymentsonBehalfofEmployees = new PaymentsonBehalfofEmployeesCashFlowStatement();
			OtherCashPaymentsfromOperatingActivities = new OtherCashPaymentsfromOperatingActivitiesCashFlowStatement();
			DividendsPaidDirect = new DividendsPaidDirectCashFlowStatement();
			DividendsReceivedDirect = new DividendsReceivedDirectCashFlowStatement();
			InterestPaidDirect = new InterestPaidDirectCashFlowStatement();
			InterestReceivedDirect = new InterestReceivedDirectCashFlowStatement();
			TaxesRefundPaidDirect = new TaxesRefundPaidDirectCashFlowStatement();
			TotalAdjustmentsforNonCashItems = new TotalAdjustmentsforNonCashItemsCashFlowStatement();
			ImpairmentLossReversalRecognizedinProfitorLoss = new ImpairmentLossReversalRecognizedinProfitorLossCashFlowStatement();
			DividendPaidCFO = new DividendPaidCFOCashFlowStatement();
			DividendReceivedCFO = new DividendReceivedCFOCashFlowStatement();
			TaxesRefundPaid = new TaxesRefundPaidCashFlowStatement();
			OtherOperatingInflowsOutflowsofCash = new OtherOperatingInflowsOutflowsofCashCashFlowStatement();
			CashAdvancesandLoansMadetoOtherParties = new CashAdvancesandLoansMadetoOtherPartiesCashFlowStatement();
			CashReceiptsfromRepaymentofAdvancesandLoansMadetoOtherParties = new CashReceiptsfromRepaymentofAdvancesandLoansMadetoOtherPartiesCashFlowStatement();
			DividendsReceivedCFI = new DividendsReceivedCFICashFlowStatement();
			InterestReceivedCFI = new InterestReceivedCFICashFlowStatement();
			InterestPaidCFF = new InterestPaidCFFCashFlowStatement();
			ChangeinAccruedIncome = new ChangeinAccruedIncomeCashFlowStatement();
			ChangeinFinancialAssets = new ChangeinFinancialAssetsCashFlowStatement();
			ChangeinAdvancesfromCentralBanks = new ChangeinAdvancesfromCentralBanksCashFlowStatement();
			ChangeinFinancialLiabilities = new ChangeinFinancialLiabilitiesCashFlowStatement();
			ChangeinInsuranceContractAssets = new ChangeinInsuranceContractAssetsCashFlowStatement();
			ChangeinReinsuranceReceivables = new ChangeinReinsuranceReceivablesCashFlowStatement();
			ChangeinDeferredAcquisitionCostsNet = new ChangeinDeferredAcquisitionCostsNetCashFlowStatement();
			ChangeinInsuranceFunds = new ChangeinInsuranceFundsCashFlowStatement();
			ChangeinInvestmentContractLiabilities = new ChangeinInvestmentContractLiabilitiesCashFlowStatement();
			ChangeinInsuranceContractLiabilities = new ChangeinInsuranceContractLiabilitiesCashFlowStatement();
			ProvisionandWriteOffofAssets = new ProvisionandWriteOffofAssetsCashFlowStatement();
			ReceiptsfromCustomers = new ReceiptsfromCustomersCashFlowStatement();
			ReceiptsfromGovernmentGrants = new ReceiptsfromGovernmentGrantsCashFlowStatement();
			MinorityInterest = new MinorityInterestCashFlowStatement();
			CapExReported = new CapExReportedCashFlowStatement();
			CashReceiptsfromTaxRefunds = new CashReceiptsfromTaxRefundsCashFlowStatement();
			CashReceiptsfromDepositsbyBanksandCustomers = new CashReceiptsfromDepositsbyBanksandCustomersCashFlowStatement();
			CashReceiptsfromLoans = new CashReceiptsfromLoansCashFlowStatement();
			CashReceiptsfromSecuritiesRelatedActivities = new CashReceiptsfromSecuritiesRelatedActivitiesCashFlowStatement();
			CashReceiptsfromFeesandCommissions = new CashReceiptsfromFeesandCommissionsCashFlowStatement();
			CashPaymentsforDepositsbyBanksandCustomers = new CashPaymentsforDepositsbyBanksandCustomersCashFlowStatement();
			CashPaymentsforLoans = new CashPaymentsforLoansCashFlowStatement();
			InterestandCommissionPaid = new InterestandCommissionPaidCashFlowStatement();
			AllTaxesPaid = new AllTaxesPaidCashFlowStatement();
			CashReceivedfromInsuranceActivities = new CashReceivedfromInsuranceActivitiesCashFlowStatement();
			PremiumReceived = new PremiumReceivedCashFlowStatement();
			ReinsuranceandOtherRecoveriesReceived = new ReinsuranceandOtherRecoveriesReceivedCashFlowStatement();
			PolicyholderDepositInvestmentReceived = new PolicyholderDepositInvestmentReceivedCashFlowStatement();
			CashPaidforInsuranceActivities = new CashPaidforInsuranceActivitiesCashFlowStatement();
			ClaimsPaid = new ClaimsPaidCashFlowStatement();
			CommissionPaid = new CommissionPaidCashFlowStatement();
			CashPaidtoReinsurers = new CashPaidtoReinsurersCashFlowStatement();
			OtherUnderwritingExpensesPaid = new OtherUnderwritingExpensesPaidCashFlowStatement();
			CashDividendsForMinorities = new CashDividendsForMinoritiesCashFlowStatement();
			CashGeneratedfromOperatingActivities = new CashGeneratedfromOperatingActivitiesCashFlowStatement();
			FundFromOperation = new FundFromOperationCashFlowStatement();
			NetInvestmentPropertiesPurchaseAndSale = new NetInvestmentPropertiesPurchaseAndSaleCashFlowStatement();
			PurchaseOfInvestmentProperties = new PurchaseOfInvestmentPropertiesCashFlowStatement();
			SaleOfInvestmentProperties = new SaleOfInvestmentPropertiesCashFlowStatement();
			OtherCashAdjustIncludedIntoChangeinCash = new OtherCashAdjustIncludedIntoChangeinCashCashFlowStatement();
			OtherCashAdjustExcludeFromChangeinCash = new OtherCashAdjustExcludeFromChangeinCashCashFlowStatement();
			ChangeinCashSupplementalAsReported = new ChangeinCashSupplementalAsReportedCashFlowStatement();
		}

		/// <summary>
		/// Applies updated values from <paramref name="update"/> to this instance
		/// </summary>
		/// <remarks>Used to apply data updates to the current instance. This WILL overwrite existing values. Default update values are ignored.</remarks>
		/// <param name="update">The next data update for this instance</param>
		public void UpdateValues(CashFlowStatement update)
		{
			if (update == null) return;

			Amortization?.UpdateValues(update.Amortization);
			CapitalExpenditure?.UpdateValues(update.CapitalExpenditure);
			CashDividendsPaid?.UpdateValues(update.CashDividendsPaid);
			CashFlowFromContinuingFinancingActivities?.UpdateValues(update.CashFlowFromContinuingFinancingActivities);
			CashFlowFromContinuingInvestingActivities?.UpdateValues(update.CashFlowFromContinuingInvestingActivities);
			CashFlowFromContinuingOperatingActivities?.UpdateValues(update.CashFlowFromContinuingOperatingActivities);
			CashFlowFromDiscontinuedOperation?.UpdateValues(update.CashFlowFromDiscontinuedOperation);
			FinancingCashFlow?.UpdateValues(update.FinancingCashFlow);
			InvestingCashFlow?.UpdateValues(update.InvestingCashFlow);
			OperatingCashFlow?.UpdateValues(update.OperatingCashFlow);
			BeginningCashPosition?.UpdateValues(update.BeginningCashPosition);
			EndCashPosition?.UpdateValues(update.EndCashPosition);
			CashFromDiscontinuedFinancing?.UpdateValues(update.CashFromDiscontinuedFinancing);
			CashFromDiscontinuedFinancingActivities?.UpdateValues(update.CashFromDiscontinuedFinancingActivities);
			CashFromDiscontinuedInvesting?.UpdateValues(update.CashFromDiscontinuedInvesting);
			CashFromDiscontinuedInvestingActivities?.UpdateValues(update.CashFromDiscontinuedInvestingActivities);
			CashFromDiscontinuedOperating?.UpdateValues(update.CashFromDiscontinuedOperating);
			ChangeInAccountPayable?.UpdateValues(update.ChangeInAccountPayable);
			ChangeInTaxPayable?.UpdateValues(update.ChangeInTaxPayable);
			ChangeInAccruedExpense?.UpdateValues(update.ChangeInAccruedExpense);
			ChangeInAccruedInvestmentIncome?.UpdateValues(update.ChangeInAccruedInvestmentIncome);
			ChangesInCash?.UpdateValues(update.ChangesInCash);
			ChangeInDeferredAcquisitionCosts?.UpdateValues(update.ChangeInDeferredAcquisitionCosts);
			ChangeInFederalFundsAndSecuritiesSoldForRepurchase?.UpdateValues(update.ChangeInFederalFundsAndSecuritiesSoldForRepurchase);
			ChangeInFundsWithheld?.UpdateValues(update.ChangeInFundsWithheld);
			ChangeInIncomeTaxPayable?.UpdateValues(update.ChangeInIncomeTaxPayable);
			ChangeInInterestPayable?.UpdateValues(update.ChangeInInterestPayable);
			ChangeInInventory?.UpdateValues(update.ChangeInInventory);
			ChangeInLoans?.UpdateValues(update.ChangeInLoans);
			ChangeInLossAndLossAdjustmentExpenseReserves?.UpdateValues(update.ChangeInLossAndLossAdjustmentExpenseReserves);
			ChangeInPayable?.UpdateValues(update.ChangeInPayable);
			ChangeInPayablesAndAccruedExpense?.UpdateValues(update.ChangeInPayablesAndAccruedExpense);
			ChangeInPrepaidAssets?.UpdateValues(update.ChangeInPrepaidAssets);
			ChangeInReceivables?.UpdateValues(update.ChangeInReceivables);
			ChangeInReinsuranceRecoverableOnPaidAndUnpaidLosses?.UpdateValues(update.ChangeInReinsuranceRecoverableOnPaidAndUnpaidLosses);
			ChangeInRestrictedCash?.UpdateValues(update.ChangeInRestrictedCash);
			ChangeInTradingAccountSecurities?.UpdateValues(update.ChangeInTradingAccountSecurities);
			ChangeInWorkingCapital?.UpdateValues(update.ChangeInWorkingCapital);
			DeferredIncomeTax?.UpdateValues(update.DeferredIncomeTax);
			DeferredTax?.UpdateValues(update.DeferredTax);
			Depletion?.UpdateValues(update.Depletion);
			Depreciation?.UpdateValues(update.Depreciation);
			DepreciationAndAmortization?.UpdateValues(update.DepreciationAndAmortization);
			DepreciationAmortizationDepletion?.UpdateValues(update.DepreciationAmortizationDepletion);
			EffectOfExchangeRateChanges?.UpdateValues(update.EffectOfExchangeRateChanges);
			IncreaseDecreaseInDeposit?.UpdateValues(update.IncreaseDecreaseInDeposit);
			NetCommonStockIssuance?.UpdateValues(update.NetCommonStockIssuance);
			NetIssuancePaymentsOfDebt?.UpdateValues(update.NetIssuancePaymentsOfDebt);
			NetLongTermDebtIssuance?.UpdateValues(update.NetLongTermDebtIssuance);
			NetPreferredStockIssuance?.UpdateValues(update.NetPreferredStockIssuance);
			NetShortTermDebtIssuance?.UpdateValues(update.NetShortTermDebtIssuance);
			NetCashFromDiscontinuedOperations?.UpdateValues(update.NetCashFromDiscontinuedOperations);
			NetForeignCurrencyExchangeGainLoss?.UpdateValues(update.NetForeignCurrencyExchangeGainLoss);
			NetIncomeFromContinuingOperations?.UpdateValues(update.NetIncomeFromContinuingOperations);
			PaymentForLoans?.UpdateValues(update.PaymentForLoans);
			CommonStockPayments?.UpdateValues(update.CommonStockPayments);
			PreferredStockPayments?.UpdateValues(update.PreferredStockPayments);
			LongTermDebtPayments?.UpdateValues(update.LongTermDebtPayments);
			ShortTermDebtPayments?.UpdateValues(update.ShortTermDebtPayments);
			ProceedsFromLoans?.UpdateValues(update.ProceedsFromLoans);
			ProceedsFromStockOptionExercised?.UpdateValues(update.ProceedsFromStockOptionExercised);
			CommonStockIssuance?.UpdateValues(update.CommonStockIssuance);
			LongTermDebtIssuance?.UpdateValues(update.LongTermDebtIssuance);
			PreferredStockIssuance?.UpdateValues(update.PreferredStockIssuance);
			ShortTermDebtIssuance?.UpdateValues(update.ShortTermDebtIssuance);
			NetProceedsPaymentForLoan?.UpdateValues(update.NetProceedsPaymentForLoan);
			ProceedsPaymentInInterestBearingDepositsInBank?.UpdateValues(update.ProceedsPaymentInInterestBearingDepositsInBank);
			PurchaseOfIntangibles?.UpdateValues(update.PurchaseOfIntangibles);
			PurchaseOfInvestment?.UpdateValues(update.PurchaseOfInvestment);
			PurchaseOfPPE?.UpdateValues(update.PurchaseOfPPE);
			PurchaseOfBusiness?.UpdateValues(update.PurchaseOfBusiness);
			NetBusinessPurchaseAndSale?.UpdateValues(update.NetBusinessPurchaseAndSale);
			NetIntangiblesPurchaseAndSale?.UpdateValues(update.NetIntangiblesPurchaseAndSale);
			NetInvestmentPurchaseAndSale?.UpdateValues(update.NetInvestmentPurchaseAndSale);
			NetPPEPurchaseAndSale?.UpdateValues(update.NetPPEPurchaseAndSale);
			SaleOfBusiness?.UpdateValues(update.SaleOfBusiness);
			SaleOfIntangibles?.UpdateValues(update.SaleOfIntangibles);
			SaleOfInvestment?.UpdateValues(update.SaleOfInvestment);
			SaleOfPPE?.UpdateValues(update.SaleOfPPE);
			ChangesInAccountReceivables?.UpdateValues(update.ChangesInAccountReceivables);
			AmortizationOfFinancingCostsAndDiscounts?.UpdateValues(update.AmortizationOfFinancingCostsAndDiscounts);
			AmortizationOfSecurities?.UpdateValues(update.AmortizationOfSecurities);
			AssetImpairmentCharge?.UpdateValues(update.AssetImpairmentCharge);
			ChangeInDividendPayable?.UpdateValues(update.ChangeInDividendPayable);
			ChangeInDeferredCharges?.UpdateValues(update.ChangeInDeferredCharges);
			ChangeInOtherCurrentAssets?.UpdateValues(update.ChangeInOtherCurrentAssets);
			ChangeInOtherCurrentLiabilities?.UpdateValues(update.ChangeInOtherCurrentLiabilities);
			ChangeInOtherWorkingCapital?.UpdateValues(update.ChangeInOtherWorkingCapital);
			ChangeInUnearnedPremiums?.UpdateValues(update.ChangeInUnearnedPremiums);
			CommonStockDividendPaid?.UpdateValues(update.CommonStockDividendPaid);
			EarningsLossesFromEquityInvestments?.UpdateValues(update.EarningsLossesFromEquityInvestments);
			ExcessTaxBenefitFromStockBasedCompensation?.UpdateValues(update.ExcessTaxBenefitFromStockBasedCompensation);
			GainLossOnInvestmentSecurities?.UpdateValues(update.GainLossOnInvestmentSecurities);
			GainLossOnSaleOfBusiness?.UpdateValues(update.GainLossOnSaleOfBusiness);
			GainLossOnSaleOfPPE?.UpdateValues(update.GainLossOnSaleOfPPE);
			InterestCreditedOnPolicyholderDeposits?.UpdateValues(update.InterestCreditedOnPolicyholderDeposits);
			CashFromDiscontinuedOperatingActivities?.UpdateValues(update.CashFromDiscontinuedOperatingActivities);
			OperatingGainsLosses?.UpdateValues(update.OperatingGainsLosses);
			NetOtherFinancingCharges?.UpdateValues(update.NetOtherFinancingCharges);
			NetOtherInvestingChanges?.UpdateValues(update.NetOtherInvestingChanges);
			OtherNonCashItems?.UpdateValues(update.OtherNonCashItems);
			PensionAndEmployeeBenefitExpense?.UpdateValues(update.PensionAndEmployeeBenefitExpense);
			PreferredStockDividendPaid?.UpdateValues(update.PreferredStockDividendPaid);
			ProceedsPaymentFederalFundsSoldAndSecuritiesPurchasedUnderAgreementToResell?.UpdateValues(update.ProceedsPaymentFederalFundsSoldAndSecuritiesPurchasedUnderAgreementToResell);
			ProvisionForLoanLeaseAndOtherLosses?.UpdateValues(update.ProvisionForLoanLeaseAndOtherLosses);
			RealizedGainLossOnSaleOfLoansAndLease?.UpdateValues(update.RealizedGainLossOnSaleOfLoansAndLease);
			StockBasedCompensation?.UpdateValues(update.StockBasedCompensation);
			UnrealizedGainLossOnInvestmentSecurities?.UpdateValues(update.UnrealizedGainLossOnInvestmentSecurities);
			UnrealizedGainsLossesOnDerivatives?.UpdateValues(update.UnrealizedGainsLossesOnDerivatives);
			AmortizationOfIntangibles?.UpdateValues(update.AmortizationOfIntangibles);
			IncomeTaxPaidSupplementalData?.UpdateValues(update.IncomeTaxPaidSupplementalData);
			InterestPaidSupplementalData?.UpdateValues(update.InterestPaidSupplementalData);
			IssuanceOfCapitalStock?.UpdateValues(update.IssuanceOfCapitalStock);
			IssuanceOfDebt?.UpdateValues(update.IssuanceOfDebt);
			RepaymentOfDebt?.UpdateValues(update.RepaymentOfDebt);
			RepurchaseOfCapitalStock?.UpdateValues(update.RepurchaseOfCapitalStock);
			FreeCashFlow?.UpdateValues(update.FreeCashFlow);
			DecreaseinInterestBearingDepositsinBank?.UpdateValues(update.DecreaseinInterestBearingDepositsinBank);
			IncreaseinInterestBearingDepositsinBank?.UpdateValues(update.IncreaseinInterestBearingDepositsinBank);
			InterestReceivedCFO?.UpdateValues(update.InterestReceivedCFO);
			InterestPaidCFO?.UpdateValues(update.InterestPaidCFO);
			PurchaseofSubsidiaries?.UpdateValues(update.PurchaseofSubsidiaries);
			PurchaseofJointVentureAssociate?.UpdateValues(update.PurchaseofJointVentureAssociate);
			SaleofSubsidiaries?.UpdateValues(update.SaleofSubsidiaries);
			SaleofJointVentureAssociate?.UpdateValues(update.SaleofJointVentureAssociate);
			IncreaseDecreaseinLeaseFinancing?.UpdateValues(update.IncreaseDecreaseinLeaseFinancing);
			IncreaseinLeaseFinancing?.UpdateValues(update.IncreaseinLeaseFinancing);
			RepaymentinLeaseFinancing?.UpdateValues(update.RepaymentinLeaseFinancing);
			ShareofAssociates?.UpdateValues(update.ShareofAssociates);
			ProfitonDisposals?.UpdateValues(update.ProfitonDisposals);
			ReorganizationOtherCosts?.UpdateValues(update.ReorganizationOtherCosts);
			NetOutwardLoans?.UpdateValues(update.NetOutwardLoans);
			IssueExpenses?.UpdateValues(update.IssueExpenses);
			ChangeinDepositsbyBanksandCustomers?.UpdateValues(update.ChangeinDepositsbyBanksandCustomers);
			CashFlowsfromusedinOperatingActivitiesDirect?.UpdateValues(update.CashFlowsfromusedinOperatingActivitiesDirect);
			ClassesofCashReceiptsfromOperatingActivities?.UpdateValues(update.ClassesofCashReceiptsfromOperatingActivities);
			OtherCashReceiptsfromOperatingActivities?.UpdateValues(update.OtherCashReceiptsfromOperatingActivities);
			ClassesofCashPayments?.UpdateValues(update.ClassesofCashPayments);
			PaymentstoSuppliersforGoodsandServices?.UpdateValues(update.PaymentstoSuppliersforGoodsandServices);
			PaymentsonBehalfofEmployees?.UpdateValues(update.PaymentsonBehalfofEmployees);
			OtherCashPaymentsfromOperatingActivities?.UpdateValues(update.OtherCashPaymentsfromOperatingActivities);
			DividendsPaidDirect?.UpdateValues(update.DividendsPaidDirect);
			DividendsReceivedDirect?.UpdateValues(update.DividendsReceivedDirect);
			InterestPaidDirect?.UpdateValues(update.InterestPaidDirect);
			InterestReceivedDirect?.UpdateValues(update.InterestReceivedDirect);
			TaxesRefundPaidDirect?.UpdateValues(update.TaxesRefundPaidDirect);
			TotalAdjustmentsforNonCashItems?.UpdateValues(update.TotalAdjustmentsforNonCashItems);
			ImpairmentLossReversalRecognizedinProfitorLoss?.UpdateValues(update.ImpairmentLossReversalRecognizedinProfitorLoss);
			DividendPaidCFO?.UpdateValues(update.DividendPaidCFO);
			DividendReceivedCFO?.UpdateValues(update.DividendReceivedCFO);
			TaxesRefundPaid?.UpdateValues(update.TaxesRefundPaid);
			OtherOperatingInflowsOutflowsofCash?.UpdateValues(update.OtherOperatingInflowsOutflowsofCash);
			CashAdvancesandLoansMadetoOtherParties?.UpdateValues(update.CashAdvancesandLoansMadetoOtherParties);
			CashReceiptsfromRepaymentofAdvancesandLoansMadetoOtherParties?.UpdateValues(update.CashReceiptsfromRepaymentofAdvancesandLoansMadetoOtherParties);
			DividendsReceivedCFI?.UpdateValues(update.DividendsReceivedCFI);
			InterestReceivedCFI?.UpdateValues(update.InterestReceivedCFI);
			InterestPaidCFF?.UpdateValues(update.InterestPaidCFF);
			ChangeinAccruedIncome?.UpdateValues(update.ChangeinAccruedIncome);
			ChangeinFinancialAssets?.UpdateValues(update.ChangeinFinancialAssets);
			ChangeinAdvancesfromCentralBanks?.UpdateValues(update.ChangeinAdvancesfromCentralBanks);
			ChangeinFinancialLiabilities?.UpdateValues(update.ChangeinFinancialLiabilities);
			ChangeinInsuranceContractAssets?.UpdateValues(update.ChangeinInsuranceContractAssets);
			ChangeinReinsuranceReceivables?.UpdateValues(update.ChangeinReinsuranceReceivables);
			ChangeinDeferredAcquisitionCostsNet?.UpdateValues(update.ChangeinDeferredAcquisitionCostsNet);
			ChangeinInsuranceFunds?.UpdateValues(update.ChangeinInsuranceFunds);
			ChangeinInvestmentContractLiabilities?.UpdateValues(update.ChangeinInvestmentContractLiabilities);
			ChangeinInsuranceContractLiabilities?.UpdateValues(update.ChangeinInsuranceContractLiabilities);
			ProvisionandWriteOffofAssets?.UpdateValues(update.ProvisionandWriteOffofAssets);
			ReceiptsfromCustomers?.UpdateValues(update.ReceiptsfromCustomers);
			ReceiptsfromGovernmentGrants?.UpdateValues(update.ReceiptsfromGovernmentGrants);
			MinorityInterest?.UpdateValues(update.MinorityInterest);
			CapExReported?.UpdateValues(update.CapExReported);
			CashReceiptsfromTaxRefunds?.UpdateValues(update.CashReceiptsfromTaxRefunds);
			CashReceiptsfromDepositsbyBanksandCustomers?.UpdateValues(update.CashReceiptsfromDepositsbyBanksandCustomers);
			CashReceiptsfromLoans?.UpdateValues(update.CashReceiptsfromLoans);
			CashReceiptsfromSecuritiesRelatedActivities?.UpdateValues(update.CashReceiptsfromSecuritiesRelatedActivities);
			CashReceiptsfromFeesandCommissions?.UpdateValues(update.CashReceiptsfromFeesandCommissions);
			CashPaymentsforDepositsbyBanksandCustomers?.UpdateValues(update.CashPaymentsforDepositsbyBanksandCustomers);
			CashPaymentsforLoans?.UpdateValues(update.CashPaymentsforLoans);
			InterestandCommissionPaid?.UpdateValues(update.InterestandCommissionPaid);
			AllTaxesPaid?.UpdateValues(update.AllTaxesPaid);
			CashReceivedfromInsuranceActivities?.UpdateValues(update.CashReceivedfromInsuranceActivities);
			PremiumReceived?.UpdateValues(update.PremiumReceived);
			ReinsuranceandOtherRecoveriesReceived?.UpdateValues(update.ReinsuranceandOtherRecoveriesReceived);
			PolicyholderDepositInvestmentReceived?.UpdateValues(update.PolicyholderDepositInvestmentReceived);
			CashPaidforInsuranceActivities?.UpdateValues(update.CashPaidforInsuranceActivities);
			ClaimsPaid?.UpdateValues(update.ClaimsPaid);
			CommissionPaid?.UpdateValues(update.CommissionPaid);
			CashPaidtoReinsurers?.UpdateValues(update.CashPaidtoReinsurers);
			OtherUnderwritingExpensesPaid?.UpdateValues(update.OtherUnderwritingExpensesPaid);
			CashDividendsForMinorities?.UpdateValues(update.CashDividendsForMinorities);
			if (update.CFFileDate != default(DateTime)) CFFileDate = update.CFFileDate;
			CashGeneratedfromOperatingActivities?.UpdateValues(update.CashGeneratedfromOperatingActivities);
			FundFromOperation?.UpdateValues(update.FundFromOperation);
			NetInvestmentPropertiesPurchaseAndSale?.UpdateValues(update.NetInvestmentPropertiesPurchaseAndSale);
			PurchaseOfInvestmentProperties?.UpdateValues(update.PurchaseOfInvestmentProperties);
			SaleOfInvestmentProperties?.UpdateValues(update.SaleOfInvestmentProperties);
			OtherCashAdjustIncludedIntoChangeinCash?.UpdateValues(update.OtherCashAdjustIncludedIntoChangeinCash);
			OtherCashAdjustExcludeFromChangeinCash?.UpdateValues(update.OtherCashAdjustExcludeFromChangeinCash);
			ChangeinCashSupplementalAsReported?.UpdateValues(update.ChangeinCashSupplementalAsReported);
		}
	}
}
