/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// A Price Bucket represents a price available for an amount of liquidity
    /// </summary>
    [DataContract]
    public partial class PriceBucket :  IEquatable<PriceBucket>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="PriceBucket" /> class.
        /// </summary>
        /// <param name="Price">The Price offered by the PriceBucket.</param>
        /// <param name="Liquidity">The amount of liquidity offered by the PriceBucket.</param>
        public PriceBucket(string Price = default(string), int? Liquidity = default(int?))
        {
            this.Price = Price;
            this.Liquidity = Liquidity;
        }
        
        /// <summary>
        /// The Price offered by the PriceBucket
        /// </summary>
        /// <value>The Price offered by the PriceBucket</value>
        [DataMember(Name="price", EmitDefaultValue=false)]
        public string Price { get; set; }
        /// <summary>
        /// The amount of liquidity offered by the PriceBucket
        /// </summary>
        /// <value>The amount of liquidity offered by the PriceBucket</value>
        [DataMember(Name="liquidity", EmitDefaultValue=false)]
        public int? Liquidity { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class PriceBucket {\n");
            sb.Append("  Price: ").Append(Price).Append("\n");
            sb.Append("  Liquidity: ").Append(Liquidity).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as PriceBucket);
        }

        /// <summary>
        /// Returns true if PriceBucket instances are equal
        /// </summary>
        /// <param name="other">Instance of PriceBucket to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(PriceBucket other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Price == other.Price ||
                    this.Price != null &&
                    this.Price.Equals(other.Price)
                ) && 
                (
                    this.Liquidity == other.Liquidity ||
                    this.Liquidity != null &&
                    this.Liquidity.Equals(other.Liquidity)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.Price != null)
                    hash = hash * 59 + this.Price.GetHashCode();
                if (this.Liquidity != null)
                    hash = hash * 59 + this.Liquidity.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
