/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// The representation of a Position for a single direction (long or short).
    /// </summary>
    [DataContract]
    public partial class PositionSide :  IEquatable<PositionSide>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="PositionSide" /> class.
        /// </summary>
        /// <param name="Units">Number of units in the position (negative value indicates short position, positive indicates long position)..</param>
        /// <param name="AveragePrice">Volume-weighted average of the underlying Trade open prices for the Position..</param>
        /// <param name="TradeIDs">List of the open Trade IDs which contribute to the open Position..</param>
        /// <param name="Pl">Profit/loss realized by the PositionSide over the lifetime of the Account..</param>
        /// <param name="UnrealizedPL">The unrealized profit/loss of all open Trades that contribute to this PositionSide..</param>
        /// <param name="ResettablePL">Profit/loss realized by the PositionSide since the Account&#39;s resettablePL was last reset by the client..</param>
        public PositionSide(string Units = default(string), string AveragePrice = default(string), List<string> TradeIDs = default(List<string>), string Pl = default(string), string UnrealizedPL = default(string), string ResettablePL = default(string))
        {
            this.Units = Units;
            this.AveragePrice = AveragePrice;
            this.TradeIDs = TradeIDs;
            this.Pl = Pl;
            this.UnrealizedPL = UnrealizedPL;
            this.ResettablePL = ResettablePL;
        }
        
        /// <summary>
        /// Number of units in the position (negative value indicates short position, positive indicates long position).
        /// </summary>
        /// <value>Number of units in the position (negative value indicates short position, positive indicates long position).</value>
        [DataMember(Name="units", EmitDefaultValue=false)]
        public string Units { get; set; }
        /// <summary>
        /// Volume-weighted average of the underlying Trade open prices for the Position.
        /// </summary>
        /// <value>Volume-weighted average of the underlying Trade open prices for the Position.</value>
        [DataMember(Name="averagePrice", EmitDefaultValue=false)]
        public string AveragePrice { get; set; }
        /// <summary>
        /// List of the open Trade IDs which contribute to the open Position.
        /// </summary>
        /// <value>List of the open Trade IDs which contribute to the open Position.</value>
        [DataMember(Name="tradeIDs", EmitDefaultValue=false)]
        public List<string> TradeIDs { get; set; }
        /// <summary>
        /// Profit/loss realized by the PositionSide over the lifetime of the Account.
        /// </summary>
        /// <value>Profit/loss realized by the PositionSide over the lifetime of the Account.</value>
        [DataMember(Name="pl", EmitDefaultValue=false)]
        public string Pl { get; set; }
        /// <summary>
        /// The unrealized profit/loss of all open Trades that contribute to this PositionSide.
        /// </summary>
        /// <value>The unrealized profit/loss of all open Trades that contribute to this PositionSide.</value>
        [DataMember(Name="unrealizedPL", EmitDefaultValue=false)]
        public string UnrealizedPL { get; set; }
        /// <summary>
        /// Profit/loss realized by the PositionSide since the Account&#39;s resettablePL was last reset by the client.
        /// </summary>
        /// <value>Profit/loss realized by the PositionSide since the Account&#39;s resettablePL was last reset by the client.</value>
        [DataMember(Name="resettablePL", EmitDefaultValue=false)]
        public string ResettablePL { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class PositionSide {\n");
            sb.Append("  Units: ").Append(Units).Append("\n");
            sb.Append("  AveragePrice: ").Append(AveragePrice).Append("\n");
            sb.Append("  TradeIDs: ").Append(TradeIDs).Append("\n");
            sb.Append("  Pl: ").Append(Pl).Append("\n");
            sb.Append("  UnrealizedPL: ").Append(UnrealizedPL).Append("\n");
            sb.Append("  ResettablePL: ").Append(ResettablePL).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as PositionSide);
        }

        /// <summary>
        /// Returns true if PositionSide instances are equal
        /// </summary>
        /// <param name="other">Instance of PositionSide to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(PositionSide other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Units == other.Units ||
                    this.Units != null &&
                    this.Units.Equals(other.Units)
                ) && 
                (
                    this.AveragePrice == other.AveragePrice ||
                    this.AveragePrice != null &&
                    this.AveragePrice.Equals(other.AveragePrice)
                ) && 
                (
                    this.TradeIDs == other.TradeIDs ||
                    this.TradeIDs != null &&
                    this.TradeIDs.SequenceEqual(other.TradeIDs)
                ) && 
                (
                    this.Pl == other.Pl ||
                    this.Pl != null &&
                    this.Pl.Equals(other.Pl)
                ) && 
                (
                    this.UnrealizedPL == other.UnrealizedPL ||
                    this.UnrealizedPL != null &&
                    this.UnrealizedPL.Equals(other.UnrealizedPL)
                ) && 
                (
                    this.ResettablePL == other.ResettablePL ||
                    this.ResettablePL != null &&
                    this.ResettablePL.Equals(other.ResettablePL)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.Units != null)
                    hash = hash * 59 + this.Units.GetHashCode();
                if (this.AveragePrice != null)
                    hash = hash * 59 + this.AveragePrice.GetHashCode();
                if (this.TradeIDs != null)
                    hash = hash * 59 + this.TradeIDs.GetHashCode();
                if (this.Pl != null)
                    hash = hash * 59 + this.Pl.GetHashCode();
                if (this.UnrealizedPL != null)
                    hash = hash * 59 + this.UnrealizedPL.GetHashCode();
                if (this.ResettablePL != null)
                    hash = hash * 59 + this.ResettablePL.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
