/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// OpenTradeFinancing is used to pay/collect daily financing charge for a Position within an Account
    /// </summary>
    [DataContract]
    public partial class PositionFinancing :  IEquatable<PositionFinancing>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="PositionFinancing" /> class.
        /// </summary>
        /// <param name="InstrumentID">The instrument of the Position that financing is being paid/collected for..</param>
        /// <param name="Financing">The amount of financing paid/collected for the Position..</param>
        /// <param name="OpenTradeFinancings">The financing paid/collecte for each open Trade within the Position..</param>
        public PositionFinancing(string InstrumentID = default(string), string Financing = default(string), List<OpenTradeFinancing> OpenTradeFinancings = default(List<OpenTradeFinancing>))
        {
            this.InstrumentID = InstrumentID;
            this.Financing = Financing;
            this.OpenTradeFinancings = OpenTradeFinancings;
        }
        
        /// <summary>
        /// The instrument of the Position that financing is being paid/collected for.
        /// </summary>
        /// <value>The instrument of the Position that financing is being paid/collected for.</value>
        [DataMember(Name="instrumentID", EmitDefaultValue=false)]
        public string InstrumentID { get; set; }
        /// <summary>
        /// The amount of financing paid/collected for the Position.
        /// </summary>
        /// <value>The amount of financing paid/collected for the Position.</value>
        [DataMember(Name="financing", EmitDefaultValue=false)]
        public string Financing { get; set; }
        /// <summary>
        /// The financing paid/collecte for each open Trade within the Position.
        /// </summary>
        /// <value>The financing paid/collecte for each open Trade within the Position.</value>
        [DataMember(Name="openTradeFinancings", EmitDefaultValue=false)]
        public List<OpenTradeFinancing> OpenTradeFinancings { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class PositionFinancing {\n");
            sb.Append("  InstrumentID: ").Append(InstrumentID).Append("\n");
            sb.Append("  Financing: ").Append(Financing).Append("\n");
            sb.Append("  OpenTradeFinancings: ").Append(OpenTradeFinancings).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as PositionFinancing);
        }

        /// <summary>
        /// Returns true if PositionFinancing instances are equal
        /// </summary>
        /// <param name="other">Instance of PositionFinancing to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(PositionFinancing other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.InstrumentID == other.InstrumentID ||
                    this.InstrumentID != null &&
                    this.InstrumentID.Equals(other.InstrumentID)
                ) && 
                (
                    this.Financing == other.Financing ||
                    this.Financing != null &&
                    this.Financing.Equals(other.Financing)
                ) && 
                (
                    this.OpenTradeFinancings == other.OpenTradeFinancings ||
                    this.OpenTradeFinancings != null &&
                    this.OpenTradeFinancings.SequenceEqual(other.OpenTradeFinancings)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.InstrumentID != null)
                    hash = hash * 59 + this.InstrumentID.GetHashCode();
                if (this.Financing != null)
                    hash = hash * 59 + this.Financing.GetHashCode();
                if (this.OpenTradeFinancings != null)
                    hash = hash * 59 + this.OpenTradeFinancings.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
