/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// The specification of a Position within an Account.
    /// </summary>
    [DataContract]
    public partial class Position :  IEquatable<Position>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Position" /> class.
        /// </summary>
        /// <param name="Instrument">The Position&#39;s Instrument..</param>
        /// <param name="Pl">Profit/loss realized by the Position over the lifetime of the Account..</param>
        /// <param name="UnrealizedPL">The unrealized profit/loss of all open Trades that contribute to this Position..</param>
        /// <param name="ResettablePL">Profit/loss realized by the Position since the Account&#39;s resettablePL was last reset by the client..</param>
        /// <param name="_Long">_Long.</param>
        /// <param name="_Short">_Short.</param>
        public Position(string Instrument = default(string), string Pl = default(string), string UnrealizedPL = default(string), string ResettablePL = default(string), PositionSide _Long = default(PositionSide), PositionSide _Short = default(PositionSide))
        {
            this.Instrument = Instrument;
            this.Pl = Pl;
            this.UnrealizedPL = UnrealizedPL;
            this.ResettablePL = ResettablePL;
            this._Long = _Long;
            this._Short = _Short;
        }
        
        /// <summary>
        /// The Position&#39;s Instrument.
        /// </summary>
        /// <value>The Position&#39;s Instrument.</value>
        [DataMember(Name="instrument", EmitDefaultValue=false)]
        public string Instrument { get; set; }
        /// <summary>
        /// Profit/loss realized by the Position over the lifetime of the Account.
        /// </summary>
        /// <value>Profit/loss realized by the Position over the lifetime of the Account.</value>
        [DataMember(Name="pl", EmitDefaultValue=false)]
        public string Pl { get; set; }
        /// <summary>
        /// The unrealized profit/loss of all open Trades that contribute to this Position.
        /// </summary>
        /// <value>The unrealized profit/loss of all open Trades that contribute to this Position.</value>
        [DataMember(Name="unrealizedPL", EmitDefaultValue=false)]
        public string UnrealizedPL { get; set; }
        /// <summary>
        /// Profit/loss realized by the Position since the Account&#39;s resettablePL was last reset by the client.
        /// </summary>
        /// <value>Profit/loss realized by the Position since the Account&#39;s resettablePL was last reset by the client.</value>
        [DataMember(Name="resettablePL", EmitDefaultValue=false)]
        public string ResettablePL { get; set; }
        /// <summary>
        /// Gets or Sets _Long
        /// </summary>
        [DataMember(Name="long", EmitDefaultValue=false)]
        public PositionSide _Long { get; set; }
        /// <summary>
        /// Gets or Sets _Short
        /// </summary>
        [DataMember(Name="short", EmitDefaultValue=false)]
        public PositionSide _Short { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class Position {\n");
            sb.Append("  Instrument: ").Append(Instrument).Append("\n");
            sb.Append("  Pl: ").Append(Pl).Append("\n");
            sb.Append("  UnrealizedPL: ").Append(UnrealizedPL).Append("\n");
            sb.Append("  ResettablePL: ").Append(ResettablePL).Append("\n");
            sb.Append("  _Long: ").Append(_Long).Append("\n");
            sb.Append("  _Short: ").Append(_Short).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as Position);
        }

        /// <summary>
        /// Returns true if Position instances are equal
        /// </summary>
        /// <param name="other">Instance of Position to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Position other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Instrument == other.Instrument ||
                    this.Instrument != null &&
                    this.Instrument.Equals(other.Instrument)
                ) && 
                (
                    this.Pl == other.Pl ||
                    this.Pl != null &&
                    this.Pl.Equals(other.Pl)
                ) && 
                (
                    this.UnrealizedPL == other.UnrealizedPL ||
                    this.UnrealizedPL != null &&
                    this.UnrealizedPL.Equals(other.UnrealizedPL)
                ) && 
                (
                    this.ResettablePL == other.ResettablePL ||
                    this.ResettablePL != null &&
                    this.ResettablePL.Equals(other.ResettablePL)
                ) && 
                (
                    this._Long == other._Long ||
                    this._Long != null &&
                    this._Long.Equals(other._Long)
                ) && 
                (
                    this._Short == other._Short ||
                    this._Short != null &&
                    this._Short.Equals(other._Short)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.Instrument != null)
                    hash = hash * 59 + this.Instrument.GetHashCode();
                if (this.Pl != null)
                    hash = hash * 59 + this.Pl.GetHashCode();
                if (this.UnrealizedPL != null)
                    hash = hash * 59 + this.UnrealizedPL.GetHashCode();
                if (this.ResettablePL != null)
                    hash = hash * 59 + this.ResettablePL.GetHashCode();
                if (this._Long != null)
                    hash = hash * 59 + this._Long.GetHashCode();
                if (this._Short != null)
                    hash = hash * 59 + this._Short.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
