/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// An OrderCancelTransaction represents the cancellation of an Order in the client&#39;s Account.
    /// </summary>
    [DataContract]
    public partial class OrderCancelTransaction :  IEquatable<OrderCancelTransaction>, IValidatableObject
    {
        /// <summary>
        /// The Type of the Transaction. Always set to \"ORDER_CANCEL\" for an OrderCancelTransaction.
        /// </summary>
        /// <value>The Type of the Transaction. Always set to \"ORDER_CANCEL\" for an OrderCancelTransaction.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum TypeEnum
        {
            
            /// <summary>
            /// Enum CREATE for "CREATE"
            /// </summary>
            [EnumMember(Value = "CREATE")]
            CREATE,
            
            /// <summary>
            /// Enum CLOSE for "CLOSE"
            /// </summary>
            [EnumMember(Value = "CLOSE")]
            CLOSE,
            
            /// <summary>
            /// Enum REOPEN for "REOPEN"
            /// </summary>
            [EnumMember(Value = "REOPEN")]
            REOPEN,
            
            /// <summary>
            /// Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE"
            /// </summary>
            [EnumMember(Value = "CLIENT_CONFIGURE")]
            CLIENTCONFIGURE,
            
            /// <summary>
            /// Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT"
            /// </summary>
            [EnumMember(Value = "CLIENT_CONFIGURE_REJECT")]
            CLIENTCONFIGUREREJECT,
            
            /// <summary>
            /// Enum TRANSFERFUNDS for "TRANSFER_FUNDS"
            /// </summary>
            [EnumMember(Value = "TRANSFER_FUNDS")]
            TRANSFERFUNDS,
            
            /// <summary>
            /// Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT"
            /// </summary>
            [EnumMember(Value = "TRANSFER_FUNDS_REJECT")]
            TRANSFERFUNDSREJECT,
            
            /// <summary>
            /// Enum MARKETORDER for "MARKET_ORDER"
            /// </summary>
            [EnumMember(Value = "MARKET_ORDER")]
            MARKETORDER,
            
            /// <summary>
            /// Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "MARKET_ORDER_REJECT")]
            MARKETORDERREJECT,
            
            /// <summary>
            /// Enum LIMITORDER for "LIMIT_ORDER"
            /// </summary>
            [EnumMember(Value = "LIMIT_ORDER")]
            LIMITORDER,
            
            /// <summary>
            /// Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "LIMIT_ORDER_REJECT")]
            LIMITORDERREJECT,
            
            /// <summary>
            /// Enum STOPORDER for "STOP_ORDER"
            /// </summary>
            [EnumMember(Value = "STOP_ORDER")]
            STOPORDER,
            
            /// <summary>
            /// Enum STOPORDERREJECT for "STOP_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "STOP_ORDER_REJECT")]
            STOPORDERREJECT,
            
            /// <summary>
            /// Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER"
            /// </summary>
            [EnumMember(Value = "MARKET_IF_TOUCHED_ORDER")]
            MARKETIFTOUCHEDORDER,
            
            /// <summary>
            /// Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "MARKET_IF_TOUCHED_ORDER_REJECT")]
            MARKETIFTOUCHEDORDERREJECT,
            
            /// <summary>
            /// Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ORDER")]
            TAKEPROFITORDER,
            
            /// <summary>
            /// Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ORDER_REJECT")]
            TAKEPROFITORDERREJECT,
            
            /// <summary>
            /// Enum STOPLOSSORDER for "STOP_LOSS_ORDER"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ORDER")]
            STOPLOSSORDER,
            
            /// <summary>
            /// Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ORDER_REJECT")]
            STOPLOSSORDERREJECT,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ORDER")]
            TRAILINGSTOPLOSSORDER,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ORDER_REJECT")]
            TRAILINGSTOPLOSSORDERREJECT,
            
            /// <summary>
            /// Enum ORDERFILL for "ORDER_FILL"
            /// </summary>
            [EnumMember(Value = "ORDER_FILL")]
            ORDERFILL,
            
            /// <summary>
            /// Enum ORDERCANCEL for "ORDER_CANCEL"
            /// </summary>
            [EnumMember(Value = "ORDER_CANCEL")]
            ORDERCANCEL,
            
            /// <summary>
            /// Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT"
            /// </summary>
            [EnumMember(Value = "ORDER_CANCEL_REJECT")]
            ORDERCANCELREJECT,
            
            /// <summary>
            /// Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY"
            /// </summary>
            [EnumMember(Value = "ORDER_CLIENT_EXTENSIONS_MODIFY")]
            ORDERCLIENTEXTENSIONSMODIFY,
            
            /// <summary>
            /// Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT"
            /// </summary>
            [EnumMember(Value = "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT")]
            ORDERCLIENTEXTENSIONSMODIFYREJECT,
            
            /// <summary>
            /// Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY"
            /// </summary>
            [EnumMember(Value = "TRADE_CLIENT_EXTENSIONS_MODIFY")]
            TRADECLIENTEXTENSIONSMODIFY,
            
            /// <summary>
            /// Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT"
            /// </summary>
            [EnumMember(Value = "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT")]
            TRADECLIENTEXTENSIONSMODIFYREJECT,
            
            /// <summary>
            /// Enum MARGINCALLENTER for "MARGIN_CALL_ENTER"
            /// </summary>
            [EnumMember(Value = "MARGIN_CALL_ENTER")]
            MARGINCALLENTER,
            
            /// <summary>
            /// Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND"
            /// </summary>
            [EnumMember(Value = "MARGIN_CALL_EXTEND")]
            MARGINCALLEXTEND,
            
            /// <summary>
            /// Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT"
            /// </summary>
            [EnumMember(Value = "MARGIN_CALL_EXIT")]
            MARGINCALLEXIT,
            
            /// <summary>
            /// Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE"
            /// </summary>
            [EnumMember(Value = "DELAYED_TRADE_CLOSURE")]
            DELAYEDTRADECLOSURE,
            
            /// <summary>
            /// Enum DAILYFINANCING for "DAILY_FINANCING"
            /// </summary>
            [EnumMember(Value = "DAILY_FINANCING")]
            DAILYFINANCING,
            
            /// <summary>
            /// Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL"
            /// </summary>
            [EnumMember(Value = "RESET_RESETTABLE_PL")]
            RESETRESETTABLEPL
        }

        /// <summary>
        /// The reason that the Order was cancelled.
        /// </summary>
        /// <value>The reason that the Order was cancelled.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum ReasonEnum
        {
            
            /// <summary>
            /// Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR"
            /// </summary>
            [EnumMember(Value = "INTERNAL_SERVER_ERROR")]
            INTERNALSERVERERROR,
            
            /// <summary>
            /// Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED"
            /// </summary>
            [EnumMember(Value = "ACCOUNT_LOCKED")]
            ACCOUNTLOCKED,
            
            /// <summary>
            /// Enum ACCOUNTNEWPOSITIONSLOCKED for "ACCOUNT_NEW_POSITIONS_LOCKED"
            /// </summary>
            [EnumMember(Value = "ACCOUNT_NEW_POSITIONS_LOCKED")]
            ACCOUNTNEWPOSITIONSLOCKED,
            
            /// <summary>
            /// Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED"
            /// </summary>
            [EnumMember(Value = "ACCOUNT_ORDER_CREATION_LOCKED")]
            ACCOUNTORDERCREATIONLOCKED,
            
            /// <summary>
            /// Enum ACCOUNTORDERFILLLOCKED for "ACCOUNT_ORDER_FILL_LOCKED"
            /// </summary>
            [EnumMember(Value = "ACCOUNT_ORDER_FILL_LOCKED")]
            ACCOUNTORDERFILLLOCKED,
            
            /// <summary>
            /// Enum CLIENTREQUEST for "CLIENT_REQUEST"
            /// </summary>
            [EnumMember(Value = "CLIENT_REQUEST")]
            CLIENTREQUEST,
            
            /// <summary>
            /// Enum MIGRATION for "MIGRATION"
            /// </summary>
            [EnumMember(Value = "MIGRATION")]
            MIGRATION,
            
            /// <summary>
            /// Enum MARKETHALTED for "MARKET_HALTED"
            /// </summary>
            [EnumMember(Value = "MARKET_HALTED")]
            MARKETHALTED,
            
            /// <summary>
            /// Enum LINKEDTRADECLOSED for "LINKED_TRADE_CLOSED"
            /// </summary>
            [EnumMember(Value = "LINKED_TRADE_CLOSED")]
            LINKEDTRADECLOSED,
            
            /// <summary>
            /// Enum TIMEINFORCEEXPIRED for "TIME_IN_FORCE_EXPIRED"
            /// </summary>
            [EnumMember(Value = "TIME_IN_FORCE_EXPIRED")]
            TIMEINFORCEEXPIRED,
            
            /// <summary>
            /// Enum INSUFFICIENTMARGIN for "INSUFFICIENT_MARGIN"
            /// </summary>
            [EnumMember(Value = "INSUFFICIENT_MARGIN")]
            INSUFFICIENTMARGIN,
            
            /// <summary>
            /// Enum FIFOVIOLATION for "FIFO_VIOLATION"
            /// </summary>
            [EnumMember(Value = "FIFO_VIOLATION")]
            FIFOVIOLATION,
            
            /// <summary>
            /// Enum BOUNDSVIOLATION for "BOUNDS_VIOLATION"
            /// </summary>
            [EnumMember(Value = "BOUNDS_VIOLATION")]
            BOUNDSVIOLATION,
            
            /// <summary>
            /// Enum CLIENTREQUESTREPLACED for "CLIENT_REQUEST_REPLACED"
            /// </summary>
            [EnumMember(Value = "CLIENT_REQUEST_REPLACED")]
            CLIENTREQUESTREPLACED,
            
            /// <summary>
            /// Enum INSUFFICIENTLIQUIDITY for "INSUFFICIENT_LIQUIDITY"
            /// </summary>
            [EnumMember(Value = "INSUFFICIENT_LIQUIDITY")]
            INSUFFICIENTLIQUIDITY,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST")]
            TAKEPROFITONFILLGTDTIMESTAMPINPAST,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLLOSS for "TAKE_PROFIT_ON_FILL_LOSS"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_LOSS")]
            TAKEPROFITONFILLLOSS,
            
            /// <summary>
            /// Enum LOSINGTAKEPROFIT for "LOSING_TAKE_PROFIT"
            /// </summary>
            [EnumMember(Value = "LOSING_TAKE_PROFIT")]
            LOSINGTAKEPROFIT,
            
            /// <summary>
            /// Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST")]
            STOPLOSSONFILLGTDTIMESTAMPINPAST,
            
            /// <summary>
            /// Enum STOPLOSSONFILLLOSS for "STOP_LOSS_ON_FILL_LOSS"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_LOSS")]
            STOPLOSSONFILLLOSS,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST")]
            TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST,
            
            /// <summary>
            /// Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS"
            /// </summary>
            [EnumMember(Value = "CLIENT_TRADE_ID_ALREADY_EXISTS")]
            CLIENTTRADEIDALREADYEXISTS,
            
            /// <summary>
            /// Enum POSITIONCLOSEOUTFAILED for "POSITION_CLOSEOUT_FAILED"
            /// </summary>
            [EnumMember(Value = "POSITION_CLOSEOUT_FAILED")]
            POSITIONCLOSEOUTFAILED,
            
            /// <summary>
            /// Enum OPENTRADESALLOWEDEXCEEDED for "OPEN_TRADES_ALLOWED_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "OPEN_TRADES_ALLOWED_EXCEEDED")]
            OPENTRADESALLOWEDEXCEEDED,
            
            /// <summary>
            /// Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "PENDING_ORDERS_ALLOWED_EXCEEDED")]
            PENDINGORDERSALLOWEDEXCEEDED,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLCLIENTORDERIDALREADYEXISTS for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_ALREADY_EXISTS"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_ALREADY_EXISTS")]
            TAKEPROFITONFILLCLIENTORDERIDALREADYEXISTS,
            
            /// <summary>
            /// Enum STOPLOSSONFILLCLIENTORDERIDALREADYEXISTS for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_ALREADY_EXISTS"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_ALREADY_EXISTS")]
            STOPLOSSONFILLCLIENTORDERIDALREADYEXISTS,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDALREADYEXISTS for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_ALREADY_EXISTS"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_ALREADY_EXISTS")]
            TRAILINGSTOPLOSSONFILLCLIENTORDERIDALREADYEXISTS,
            
            /// <summary>
            /// Enum POSITIONSIZEEXCEEDED for "POSITION_SIZE_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "POSITION_SIZE_EXCEEDED")]
            POSITIONSIZEEXCEEDED
        }

        /// <summary>
        /// The Type of the Transaction. Always set to \"ORDER_CANCEL\" for an OrderCancelTransaction.
        /// </summary>
        /// <value>The Type of the Transaction. Always set to \"ORDER_CANCEL\" for an OrderCancelTransaction.</value>
        [DataMember(Name="type", EmitDefaultValue=false)]
        public TypeEnum? Type { get; set; }
        /// <summary>
        /// The reason that the Order was cancelled.
        /// </summary>
        /// <value>The reason that the Order was cancelled.</value>
        [DataMember(Name="reason", EmitDefaultValue=false)]
        public ReasonEnum? Reason { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="OrderCancelTransaction" /> class.
        /// </summary>
        /// <param name="Id">The Transaction&#39;s Identifier..</param>
        /// <param name="Time">The date/time when the Transaction was created..</param>
        /// <param name="UserID">The ID of the user that initiated the creation of the Transaction..</param>
        /// <param name="AccountID">The ID of the Account the Transaction was created for..</param>
        /// <param name="BatchID">The ID of the \&quot;batch\&quot; that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..</param>
        /// <param name="RequestID">The Request ID of the request which generated the transaction..</param>
        /// <param name="Type">The Type of the Transaction. Always set to \&quot;ORDER_CANCEL\&quot; for an OrderCancelTransaction..</param>
        /// <param name="OrderID">The ID of the Order cancelled.</param>
        /// <param name="ClientOrderID">The client ID of the Order cancelled (only provided if the Order has a client Order ID)..</param>
        /// <param name="Reason">The reason that the Order was cancelled..</param>
        /// <param name="ReplacedByOrderID">The ID of the Order that replaced this Order (only provided if this Order was cancelled for replacement)..</param>
        public OrderCancelTransaction(string Id = default(string), string Time = default(string), int? UserID = default(int?), string AccountID = default(string), string BatchID = default(string), string RequestID = default(string), TypeEnum? Type = default(TypeEnum?), string OrderID = default(string), string ClientOrderID = default(string), ReasonEnum? Reason = default(ReasonEnum?), string ReplacedByOrderID = default(string))
        {
            this.Id = Id;
            this.Time = Time;
            this.UserID = UserID;
            this.AccountID = AccountID;
            this.BatchID = BatchID;
            this.RequestID = RequestID;
            this.Type = Type;
            this.OrderID = OrderID;
            this.ClientOrderID = ClientOrderID;
            this.Reason = Reason;
            this.ReplacedByOrderID = ReplacedByOrderID;
        }
        
        /// <summary>
        /// The Transaction&#39;s Identifier.
        /// </summary>
        /// <value>The Transaction&#39;s Identifier.</value>
        [DataMember(Name="id", EmitDefaultValue=false)]
        public string Id { get; set; }
        /// <summary>
        /// The date/time when the Transaction was created.
        /// </summary>
        /// <value>The date/time when the Transaction was created.</value>
        [DataMember(Name="time", EmitDefaultValue=false)]
        public string Time { get; set; }
        /// <summary>
        /// The ID of the user that initiated the creation of the Transaction.
        /// </summary>
        /// <value>The ID of the user that initiated the creation of the Transaction.</value>
        [DataMember(Name="userID", EmitDefaultValue=false)]
        public int? UserID { get; set; }
        /// <summary>
        /// The ID of the Account the Transaction was created for.
        /// </summary>
        /// <value>The ID of the Account the Transaction was created for.</value>
        [DataMember(Name="accountID", EmitDefaultValue=false)]
        public string AccountID { get; set; }
        /// <summary>
        /// The ID of the \&quot;batch\&quot; that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously.
        /// </summary>
        /// <value>The ID of the \&quot;batch\&quot; that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously.</value>
        [DataMember(Name="batchID", EmitDefaultValue=false)]
        public string BatchID { get; set; }
        /// <summary>
        /// The Request ID of the request which generated the transaction.
        /// </summary>
        /// <value>The Request ID of the request which generated the transaction.</value>
        [DataMember(Name="requestID", EmitDefaultValue=false)]
        public string RequestID { get; set; }
        /// <summary>
        /// The ID of the Order cancelled
        /// </summary>
        /// <value>The ID of the Order cancelled</value>
        [DataMember(Name="orderID", EmitDefaultValue=false)]
        public string OrderID { get; set; }
        /// <summary>
        /// The client ID of the Order cancelled (only provided if the Order has a client Order ID).
        /// </summary>
        /// <value>The client ID of the Order cancelled (only provided if the Order has a client Order ID).</value>
        [DataMember(Name="clientOrderID", EmitDefaultValue=false)]
        public string ClientOrderID { get; set; }
        /// <summary>
        /// The ID of the Order that replaced this Order (only provided if this Order was cancelled for replacement).
        /// </summary>
        /// <value>The ID of the Order that replaced this Order (only provided if this Order was cancelled for replacement).</value>
        [DataMember(Name="replacedByOrderID", EmitDefaultValue=false)]
        public string ReplacedByOrderID { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class OrderCancelTransaction {\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Time: ").Append(Time).Append("\n");
            sb.Append("  UserID: ").Append(UserID).Append("\n");
            sb.Append("  AccountID: ").Append(AccountID).Append("\n");
            sb.Append("  BatchID: ").Append(BatchID).Append("\n");
            sb.Append("  RequestID: ").Append(RequestID).Append("\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("  OrderID: ").Append(OrderID).Append("\n");
            sb.Append("  ClientOrderID: ").Append(ClientOrderID).Append("\n");
            sb.Append("  Reason: ").Append(Reason).Append("\n");
            sb.Append("  ReplacedByOrderID: ").Append(ReplacedByOrderID).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as OrderCancelTransaction);
        }

        /// <summary>
        /// Returns true if OrderCancelTransaction instances are equal
        /// </summary>
        /// <param name="other">Instance of OrderCancelTransaction to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(OrderCancelTransaction other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Id == other.Id ||
                    this.Id != null &&
                    this.Id.Equals(other.Id)
                ) && 
                (
                    this.Time == other.Time ||
                    this.Time != null &&
                    this.Time.Equals(other.Time)
                ) && 
                (
                    this.UserID == other.UserID ||
                    this.UserID != null &&
                    this.UserID.Equals(other.UserID)
                ) && 
                (
                    this.AccountID == other.AccountID ||
                    this.AccountID != null &&
                    this.AccountID.Equals(other.AccountID)
                ) && 
                (
                    this.BatchID == other.BatchID ||
                    this.BatchID != null &&
                    this.BatchID.Equals(other.BatchID)
                ) && 
                (
                    this.RequestID == other.RequestID ||
                    this.RequestID != null &&
                    this.RequestID.Equals(other.RequestID)
                ) && 
                (
                    this.Type == other.Type ||
                    this.Type != null &&
                    this.Type.Equals(other.Type)
                ) && 
                (
                    this.OrderID == other.OrderID ||
                    this.OrderID != null &&
                    this.OrderID.Equals(other.OrderID)
                ) && 
                (
                    this.ClientOrderID == other.ClientOrderID ||
                    this.ClientOrderID != null &&
                    this.ClientOrderID.Equals(other.ClientOrderID)
                ) && 
                (
                    this.Reason == other.Reason ||
                    this.Reason != null &&
                    this.Reason.Equals(other.Reason)
                ) && 
                (
                    this.ReplacedByOrderID == other.ReplacedByOrderID ||
                    this.ReplacedByOrderID != null &&
                    this.ReplacedByOrderID.Equals(other.ReplacedByOrderID)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.Id != null)
                    hash = hash * 59 + this.Id.GetHashCode();
                if (this.Time != null)
                    hash = hash * 59 + this.Time.GetHashCode();
                if (this.UserID != null)
                    hash = hash * 59 + this.UserID.GetHashCode();
                if (this.AccountID != null)
                    hash = hash * 59 + this.AccountID.GetHashCode();
                if (this.BatchID != null)
                    hash = hash * 59 + this.BatchID.GetHashCode();
                if (this.RequestID != null)
                    hash = hash * 59 + this.RequestID.GetHashCode();
                if (this.Type != null)
                    hash = hash * 59 + this.Type.GetHashCode();
                if (this.OrderID != null)
                    hash = hash * 59 + this.OrderID.GetHashCode();
                if (this.ClientOrderID != null)
                    hash = hash * 59 + this.ClientOrderID.GetHashCode();
                if (this.Reason != null)
                    hash = hash * 59 + this.Reason.GetHashCode();
                if (this.ReplacedByOrderID != null)
                    hash = hash * 59 + this.ReplacedByOrderID.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
