/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// Properties related to an Account.
    /// </summary>
    [DataContract]
    public partial class AccountProperties :  IEquatable<AccountProperties>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="AccountProperties" /> class.
        /// </summary>
        /// <param name="Id">The Account&#39;s identifier.</param>
        /// <param name="Mt4AccountID">The Account&#39;s associated MT4 Account ID. This field will not be present if the Account is not an MT4 account..</param>
        /// <param name="Tags">The Account&#39;s tags.</param>
        public AccountProperties(string Id = default(string), int? Mt4AccountID = default(int?), List<string> Tags = default(List<string>))
        {
            this.Id = Id;
            this.Mt4AccountID = Mt4AccountID;
            this.Tags = Tags;
        }
        
        /// <summary>
        /// The Account&#39;s identifier
        /// </summary>
        /// <value>The Account&#39;s identifier</value>
        [DataMember(Name="id", EmitDefaultValue=false)]
        public string Id { get; set; }
        /// <summary>
        /// The Account&#39;s associated MT4 Account ID. This field will not be present if the Account is not an MT4 account.
        /// </summary>
        /// <value>The Account&#39;s associated MT4 Account ID. This field will not be present if the Account is not an MT4 account.</value>
        [DataMember(Name="mt4AccountID", EmitDefaultValue=false)]
        public int? Mt4AccountID { get; set; }
        /// <summary>
        /// The Account&#39;s tags
        /// </summary>
        /// <value>The Account&#39;s tags</value>
        [DataMember(Name="tags", EmitDefaultValue=false)]
        public List<string> Tags { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class AccountProperties {\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Mt4AccountID: ").Append(Mt4AccountID).Append("\n");
            sb.Append("  Tags: ").Append(Tags).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as AccountProperties);
        }

        /// <summary>
        /// Returns true if AccountProperties instances are equal
        /// </summary>
        /// <param name="other">Instance of AccountProperties to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(AccountProperties other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Id == other.Id ||
                    this.Id != null &&
                    this.Id.Equals(other.Id)
                ) && 
                (
                    this.Mt4AccountID == other.Mt4AccountID ||
                    this.Mt4AccountID != null &&
                    this.Mt4AccountID.Equals(other.Mt4AccountID)
                ) && 
                (
                    this.Tags == other.Tags ||
                    this.Tags != null &&
                    this.Tags.SequenceEqual(other.Tags)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.Id != null)
                    hash = hash * 59 + this.Id.GetHashCode();
                if (this.Mt4AccountID != null)
                    hash = hash * 59 + this.Mt4AccountID.GetHashCode();
                if (this.Tags != null)
                    hash = hash * 59 + this.Tags.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
