/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using RestSharp;
using Oanda.RestV20.Client;
using Oanda.RestV20.Model;

namespace Oanda.RestV20.Api
{
    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IDefaultApi : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// Cancel Order
        /// </summary>
        /// <remarks>
        /// Cancel a pending Order in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse2009</returns>
        InlineResponse2009 CancelOrder (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null);

        /// <summary>
        /// Cancel Order
        /// </summary>
        /// <remarks>
        /// Cancel a pending Order in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2009</returns>
        ApiResponse<InlineResponse2009> CancelOrderWithHttpInfo (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null);
        /// <summary>
        /// Close Position
        /// </summary>
        /// <remarks>
        /// Closeout the open Position for a specific instrument in an Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="closePositionBody">Representation of how to close the position</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20014</returns>
        InlineResponse20014 ClosePosition (string authorization, string accountID, string instrument, ClosePositionBody closePositionBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Close Position
        /// </summary>
        /// <remarks>
        /// Closeout the open Position for a specific instrument in an Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="closePositionBody">Representation of how to close the position</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20014</returns>
        ApiResponse<InlineResponse20014> ClosePositionWithHttpInfo (string authorization, string accountID, string instrument, ClosePositionBody closePositionBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Close Trade
        /// </summary>
        /// <remarks>
        /// Close (partially or fully) a specific open Trade in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="closeTradeBody">Details of how much of the open Trade to close.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20026</returns>
        InlineResponse20026 CloseTrade (string authorization, string accountID, string tradeSpecifier, CloseTradeBody closeTradeBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Close Trade
        /// </summary>
        /// <remarks>
        /// Close (partially or fully) a specific open Trade in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="closeTradeBody">Details of how much of the open Trade to close.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20026</returns>
        ApiResponse<InlineResponse20026> CloseTradeWithHttpInfo (string authorization, string accountID, string tradeSpecifier, CloseTradeBody closeTradeBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Configure Account
        /// </summary>
        /// <remarks>
        /// Set the client-configurable portions of an Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="configureAccountBody">Representation of the Account configuration to set (optional)</param>
        /// <returns>InlineResponse2004</returns>
        InlineResponse2004 ConfigureAccount (string authorization, string accountID, string acceptDatetimeFormat = null, ConfigureAccountBody configureAccountBody = null);

        /// <summary>
        /// Configure Account
        /// </summary>
        /// <remarks>
        /// Set the client-configurable portions of an Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="configureAccountBody">Representation of the Account configuration to set (optional)</param>
        /// <returns>ApiResponse of InlineResponse2004</returns>
        ApiResponse<InlineResponse2004> ConfigureAccountWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, ConfigureAccountBody configureAccountBody = null);
        /// <summary>
        /// Create Order
        /// </summary>
        /// <remarks>
        /// Create an Order for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="createOrderBody"></param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse201</returns>
        InlineResponse201 CreateOrder (string authorization, string accountID, CreateOrderBody createOrderBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Create Order
        /// </summary>
        /// <remarks>
        /// Create an Order for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="createOrderBody"></param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse201</returns>
        ApiResponse<InlineResponse201> CreateOrderWithHttpInfo (string authorization, string accountID, CreateOrderBody createOrderBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Account Details
        /// </summary>
        /// <remarks>
        /// Get the full details for a single Account that a client has access to. Full pending Order, open Trade and open Position representations are provided.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse2001</returns>
        InlineResponse2001 GetAccount (string authorization, string accountID, string acceptDatetimeFormat = null);

        /// <summary>
        /// Account Details
        /// </summary>
        /// <remarks>
        /// Get the full details for a single Account that a client has access to. Full pending Order, open Trade and open Position representations are provided.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2001</returns>
        ApiResponse<InlineResponse2001> GetAccountWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null);
        /// <summary>
        /// Poll Account Updates
        /// </summary>
        /// <remarks>
        /// Endpoint used to poll an Account for its current state and changes since a specified TransactionID.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="sinceTransactionID">ID of the Transaction to get Account changes since. (optional)</param>
        /// <returns>InlineResponse2005</returns>
        InlineResponse2005 GetAccountChanges (string authorization, string accountID, string acceptDatetimeFormat = null, string sinceTransactionID = null);

        /// <summary>
        /// Poll Account Updates
        /// </summary>
        /// <remarks>
        /// Endpoint used to poll an Account for its current state and changes since a specified TransactionID.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="sinceTransactionID">ID of the Transaction to get Account changes since. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2005</returns>
        ApiResponse<InlineResponse2005> GetAccountChangesWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, string sinceTransactionID = null);
        /// <summary>
        /// Account Instruments
        /// </summary>
        /// <remarks>
        /// Get the list of tradeable instruments for the given Account. The list of tradeable instruments is dependent on the regulatory division that the Account is located in, thus should be the same for all Accounts owned by a single user.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of instruments to query specifically. (optional)</param>
        /// <returns>InlineResponse2003</returns>
        InlineResponse2003 GetAccountInstruments (string authorization, string accountID, List<string> instruments = null);

        /// <summary>
        /// Account Instruments
        /// </summary>
        /// <remarks>
        /// Get the list of tradeable instruments for the given Account. The list of tradeable instruments is dependent on the regulatory division that the Account is located in, thus should be the same for all Accounts owned by a single user.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of instruments to query specifically. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2003</returns>
        ApiResponse<InlineResponse2003> GetAccountInstrumentsWithHttpInfo (string authorization, string accountID, List<string> instruments = null);
        /// <summary>
        /// Account Summary
        /// </summary>
        /// <remarks>
        /// Get a summary for a single Account that a client has access to.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse2002</returns>
        InlineResponse2002 GetAccountSummary (string authorization, string accountID, string acceptDatetimeFormat = null);

        /// <summary>
        /// Account Summary
        /// </summary>
        /// <remarks>
        /// Get a summary for a single Account that a client has access to.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2002</returns>
        ApiResponse<InlineResponse2002> GetAccountSummaryWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null);
        /// <summary>
        /// External User Info
        /// </summary>
        /// <remarks>
        /// Fetch the externally-available user information for the specified user. This endpoint is intended to be used by 3rd parties that have been authorized by a user to view their personal information.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>InlineResponse20016</returns>
        InlineResponse20016 GetExternalUserInfo (string authorization, string userSpecifier);

        /// <summary>
        /// External User Info
        /// </summary>
        /// <remarks>
        /// Fetch the externally-available user information for the specified user. This endpoint is intended to be used by 3rd parties that have been authorized by a user to view their personal information.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>ApiResponse of InlineResponse20016</returns>
        ApiResponse<InlineResponse20016> GetExternalUserInfoWithHttpInfo (string authorization, string userSpecifier);
        /// <summary>
        /// Get Candlesticks
        /// </summary>
        /// <remarks>
        /// Fetch candlestick data for an instrument.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="price">The Price component(s) to get candlestick data for. Can contain any combination of the characters \&quot;M\&quot; (midpoint candles) \&quot;B\&quot; (bid candles) and \&quot;A\&quot; (ask candles). (optional)</param>
        /// <param name="granularity">The granularity of the candlesticks to fetch (optional)</param>
        /// <param name="count">The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)</param>
        /// <param name="from">The start of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="to">The end of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="smooth">A flag that controls whether the candlestick is \&quot;smoothed\&quot; or not.  A smoothed candlestick uses the previous candle&#39;s close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)</param>
        /// <param name="includeFirst">A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)</param>
        /// <param name="dailyAlignment">The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)</param>
        /// <param name="alignmentTimezone">The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)</param>
        /// <param name="weeklyAlignment">The day of the week used for granularities that have weekly alignment. (optional)</param>
        /// <returns>InlineResponse20029</returns>
        InlineResponse20029 GetInstrumentCandles (string authorization, string instrument, string acceptDatetimeFormat = null, string price = null, string granularity = null, int? count = null, string from = null, string to = null, bool? smooth = null, bool? includeFirst = null, int? dailyAlignment = null, string alignmentTimezone = null, string weeklyAlignment = null);

        /// <summary>
        /// Get Candlesticks
        /// </summary>
        /// <remarks>
        /// Fetch candlestick data for an instrument.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="price">The Price component(s) to get candlestick data for. Can contain any combination of the characters \&quot;M\&quot; (midpoint candles) \&quot;B\&quot; (bid candles) and \&quot;A\&quot; (ask candles). (optional)</param>
        /// <param name="granularity">The granularity of the candlesticks to fetch (optional)</param>
        /// <param name="count">The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)</param>
        /// <param name="from">The start of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="to">The end of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="smooth">A flag that controls whether the candlestick is \&quot;smoothed\&quot; or not.  A smoothed candlestick uses the previous candle&#39;s close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)</param>
        /// <param name="includeFirst">A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)</param>
        /// <param name="dailyAlignment">The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)</param>
        /// <param name="alignmentTimezone">The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)</param>
        /// <param name="weeklyAlignment">The day of the week used for granularities that have weekly alignment. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20029</returns>
        ApiResponse<InlineResponse20029> GetInstrumentCandlesWithHttpInfo (string authorization, string instrument, string acceptDatetimeFormat = null, string price = null, string granularity = null, int? count = null, string from = null, string to = null, bool? smooth = null, bool? includeFirst = null, int? dailyAlignment = null, string alignmentTimezone = null, string weeklyAlignment = null);
        /// <summary>
        /// Get Order
        /// </summary>
        /// <remarks>
        /// Get details for a single Order in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse2008</returns>
        InlineResponse2008 GetOrder (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null);

        /// <summary>
        /// Get Order
        /// </summary>
        /// <remarks>
        /// Get details for a single Order in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2008</returns>
        ApiResponse<InlineResponse2008> GetOrderWithHttpInfo (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null);
        /// <summary>
        /// Instrument Position
        /// </summary>
        /// <remarks>
        /// Get the details of a single Instrument&#39;s Position in an Account. The Position may by open or not.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <returns>InlineResponse20013</returns>
        InlineResponse20013 GetPosition (string authorization, string accountID, string instrument);

        /// <summary>
        /// Instrument Position
        /// </summary>
        /// <remarks>
        /// Get the details of a single Instrument&#39;s Position in an Account. The Position may by open or not.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <returns>ApiResponse of InlineResponse20013</returns>
        ApiResponse<InlineResponse20013> GetPositionWithHttpInfo (string authorization, string accountID, string instrument);
        /// <summary>
        /// Current Account Prices
        /// </summary>
        /// <remarks>
        /// Get pricing information for a specified list of Instruments within an Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to get pricing for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="since">Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)</param>
        /// <param name="includeUnitsAvailable">Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)</param>
        /// <returns>InlineResponse20021</returns>
        InlineResponse20021 GetPrices (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, string since = null, bool? includeUnitsAvailable = null);

        /// <summary>
        /// Current Account Prices
        /// </summary>
        /// <remarks>
        /// Get pricing information for a specified list of Instruments within an Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to get pricing for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="since">Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)</param>
        /// <param name="includeUnitsAvailable">Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20021</returns>
        ApiResponse<InlineResponse20021> GetPricesWithHttpInfo (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, string since = null, bool? includeUnitsAvailable = null);
        /// <summary>
        /// Trade Details
        /// </summary>
        /// <remarks>
        /// Get the details of a specific Trade in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20025</returns>
        InlineResponse20025 GetTrade (string authorization, string accountID, string tradeSpecifier, string acceptDatetimeFormat = null);

        /// <summary>
        /// Trade Details
        /// </summary>
        /// <remarks>
        /// Get the details of a specific Trade in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20025</returns>
        ApiResponse<InlineResponse20025> GetTradeWithHttpInfo (string authorization, string accountID, string tradeSpecifier, string acceptDatetimeFormat = null);
        /// <summary>
        /// Transaction Details
        /// </summary>
        /// <remarks>
        /// Get the details of a single Account Transaction.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="transactionID">A Transaction ID</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20018</returns>
        InlineResponse20018 GetTransaction (string authorization, string accountID, string transactionID, string acceptDatetimeFormat = null);

        /// <summary>
        /// Transaction Details
        /// </summary>
        /// <remarks>
        /// Get the details of a single Account Transaction.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="transactionID">A Transaction ID</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20018</returns>
        ApiResponse<InlineResponse20018> GetTransactionWithHttpInfo (string authorization, string accountID, string transactionID, string acceptDatetimeFormat = null);
        /// <summary>
        /// Transaction ID Range
        /// </summary>
        /// <remarks>
        /// Get a range of Transactions for an Account based on the Transaction IDs.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="from">The starting Transacion ID (inclusive) to fetch.</param>
        /// <param name="to">The ending Transaction ID (inclusive) to fetch.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="type">The filter that restricts the types of Transactions to retreive. (optional)</param>
        /// <returns>InlineResponse20019</returns>
        InlineResponse20019 GetTransactionRange (string authorization, string accountID, string from, string to, string acceptDatetimeFormat = null, List<string> type = null);

        /// <summary>
        /// Transaction ID Range
        /// </summary>
        /// <remarks>
        /// Get a range of Transactions for an Account based on the Transaction IDs.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="from">The starting Transacion ID (inclusive) to fetch.</param>
        /// <param name="to">The ending Transaction ID (inclusive) to fetch.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="type">The filter that restricts the types of Transactions to retreive. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20019</returns>
        ApiResponse<InlineResponse20019> GetTransactionRangeWithHttpInfo (string authorization, string accountID, string from, string to, string acceptDatetimeFormat = null, List<string> type = null);
        /// <summary>
        /// Transactions Since ID
        /// </summary>
        /// <remarks>
        /// Get a range of Transactions for an Account starting at (but not including) a provided Transaction ID.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="id">The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20019</returns>
        InlineResponse20019 GetTransactionsSinceId (string authorization, string accountID, string id, string acceptDatetimeFormat = null);

        /// <summary>
        /// Transactions Since ID
        /// </summary>
        /// <remarks>
        /// Get a range of Transactions for an Account starting at (but not including) a provided Transaction ID.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="id">The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20019</returns>
        ApiResponse<InlineResponse20019> GetTransactionsSinceIdWithHttpInfo (string authorization, string accountID, string id, string acceptDatetimeFormat = null);
        /// <summary>
        /// User Info
        /// </summary>
        /// <remarks>
        /// Fetch the user information for the specified user. This endpoint is intended to be used by the user themself to obtain their own information.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>InlineResponse20015</returns>
        InlineResponse20015 GetUserInfo (string authorization, string userSpecifier);

        /// <summary>
        /// User Info
        /// </summary>
        /// <remarks>
        /// Fetch the user information for the specified user. This endpoint is intended to be used by the user themself to obtain their own information.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>ApiResponse of InlineResponse20015</returns>
        ApiResponse<InlineResponse20015> GetUserInfoWithHttpInfo (string authorization, string userSpecifier);
        /// <summary>
        /// List Accounts
        /// </summary>
        /// <remarks>
        /// Get a list of all Accounts authorized for the provided token.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <returns>InlineResponse200</returns>
        InlineResponse200 ListAccounts (string authorization);

        /// <summary>
        /// List Accounts
        /// </summary>
        /// <remarks>
        /// Get a list of all Accounts authorized for the provided token.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <returns>ApiResponse of InlineResponse200</returns>
        ApiResponse<InlineResponse200> ListAccountsWithHttpInfo (string authorization);
        /// <summary>
        /// Open Positions
        /// </summary>
        /// <remarks>
        /// List all open Positions for an Account. An open Position is a Position in an Account that currently has a Trade opened for it.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>InlineResponse20012</returns>
        InlineResponse20012 ListOpenPositions (string authorization, string accountID);

        /// <summary>
        /// Open Positions
        /// </summary>
        /// <remarks>
        /// List all open Positions for an Account. An open Position is a Position in an Account that currently has a Trade opened for it.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>ApiResponse of InlineResponse20012</returns>
        ApiResponse<InlineResponse20012> ListOpenPositionsWithHttpInfo (string authorization, string accountID);
        /// <summary>
        /// List Open Trades
        /// </summary>
        /// <remarks>
        /// Get the list of open Trades for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20024</returns>
        InlineResponse20024 ListOpenTrades (string authorization, string accountID, string acceptDatetimeFormat = null);

        /// <summary>
        /// List Open Trades
        /// </summary>
        /// <remarks>
        /// Get the list of open Trades for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20024</returns>
        ApiResponse<InlineResponse20024> ListOpenTradesWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null);
        /// <summary>
        /// List Orders
        /// </summary>
        /// <remarks>
        /// Get a list of Orders for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Order IDs to retrieve (optional)</param>
        /// <param name="state">The state to filter the requested Orders by (optional)</param>
        /// <param name="instrument">The instrument to filter the requested orders by (optional)</param>
        /// <param name="count">The maximum number of Orders to return (optional)</param>
        /// <param name="beforeID">The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)</param>
        /// <returns>InlineResponse2006</returns>
        InlineResponse2006 ListOrders (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null);

        /// <summary>
        /// List Orders
        /// </summary>
        /// <remarks>
        /// Get a list of Orders for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Order IDs to retrieve (optional)</param>
        /// <param name="state">The state to filter the requested Orders by (optional)</param>
        /// <param name="instrument">The instrument to filter the requested orders by (optional)</param>
        /// <param name="count">The maximum number of Orders to return (optional)</param>
        /// <param name="beforeID">The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)</param>
        /// <returns>ApiResponse of InlineResponse2006</returns>
        ApiResponse<InlineResponse2006> ListOrdersWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null);
        /// <summary>
        /// Pending Orders
        /// </summary>
        /// <remarks>
        /// List all pending Orders in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse2007</returns>
        InlineResponse2007 ListPendingOrders (string authorization, string accountID, string acceptDatetimeFormat = null);

        /// <summary>
        /// Pending Orders
        /// </summary>
        /// <remarks>
        /// List all pending Orders in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2007</returns>
        ApiResponse<InlineResponse2007> ListPendingOrdersWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null);
        /// <summary>
        /// List Positions
        /// </summary>
        /// <remarks>
        /// List all Positions for an Account. The Positions returned are for every instrument that has had a position during the lifetime of an the Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>InlineResponse20011</returns>
        InlineResponse20011 ListPositions (string authorization, string accountID);

        /// <summary>
        /// List Positions
        /// </summary>
        /// <remarks>
        /// List all Positions for an Account. The Positions returned are for every instrument that has had a position during the lifetime of an the Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>ApiResponse of InlineResponse20011</returns>
        ApiResponse<InlineResponse20011> ListPositionsWithHttpInfo (string authorization, string accountID);
        /// <summary>
        /// List Trades
        /// </summary>
        /// <remarks>
        /// Get a list of Trades for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Trade IDs to retrieve. (optional)</param>
        /// <param name="state">The state to filter the requested Trades by. (optional)</param>
        /// <param name="instrument">The instrument to filter the requested Trades by. (optional)</param>
        /// <param name="count">The maximum number of Trades to return. (optional)</param>
        /// <param name="beforeID">The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)</param>
        /// <returns>InlineResponse20023</returns>
        InlineResponse20023 ListTrades (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null);

        /// <summary>
        /// List Trades
        /// </summary>
        /// <remarks>
        /// Get a list of Trades for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Trade IDs to retrieve. (optional)</param>
        /// <param name="state">The state to filter the requested Trades by. (optional)</param>
        /// <param name="instrument">The instrument to filter the requested Trades by. (optional)</param>
        /// <param name="count">The maximum number of Trades to return. (optional)</param>
        /// <param name="beforeID">The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20023</returns>
        ApiResponse<InlineResponse20023> ListTradesWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null);
        /// <summary>
        /// List Transactions
        /// </summary>
        /// <remarks>
        /// Get a list of Transactions pages that satisfy a time-based Transaction query.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="from">The starting time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="to">The ending time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="pageSize">The number of Transactions to include in each page of the results. (optional)</param>
        /// <param name="type">A filter for restricting the types of Transactions to retreive. (optional)</param>
        /// <returns>InlineResponse20017</returns>
        InlineResponse20017 ListTransactions (string authorization, string accountID, string acceptDatetimeFormat = null, string from = null, string to = null, int? pageSize = null, List<string> type = null);

        /// <summary>
        /// List Transactions
        /// </summary>
        /// <remarks>
        /// Get a list of Transactions pages that satisfy a time-based Transaction query.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="from">The starting time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="to">The ending time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="pageSize">The number of Transactions to include in each page of the results. (optional)</param>
        /// <param name="type">A filter for restricting the types of Transactions to retreive. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20017</returns>
        ApiResponse<InlineResponse20017> ListTransactionsWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, string from = null, string to = null, int? pageSize = null, List<string> type = null);
        /// <summary>
        /// Replace Order
        /// </summary>
        /// <remarks>
        /// Replace an Order in an Account by simultaneously cancelling it and creating a replacement Order
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="replaceOrderBody">Specification of the replacing Order. The replacing order must have the same type as the replaced Order.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse2011</returns>
        InlineResponse2011 ReplaceOrder (string authorization, string accountID, string orderSpecifier, ReplaceOrderBody replaceOrderBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Replace Order
        /// </summary>
        /// <remarks>
        /// Replace an Order in an Account by simultaneously cancelling it and creating a replacement Order
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="replaceOrderBody">Specification of the replacing Order. The replacing order must have the same type as the replaced Order.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2011</returns>
        ApiResponse<InlineResponse2011> ReplaceOrderWithHttpInfo (string authorization, string accountID, string orderSpecifier, ReplaceOrderBody replaceOrderBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Set Order Extensions
        /// </summary>
        /// <remarks>
        /// Update the Client Extensions for an Order in an Account. Do not set, modify, or delete clientExtensions if your account is associated with MT4.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="setOrderClientExtensionsBody">Representation of the replacing Order</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20010</returns>
        InlineResponse20010 SetOrderClientExtensions (string authorization, string accountID, string orderSpecifier, SetOrderClientExtensionsBody setOrderClientExtensionsBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Set Order Extensions
        /// </summary>
        /// <remarks>
        /// Update the Client Extensions for an Order in an Account. Do not set, modify, or delete clientExtensions if your account is associated with MT4.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="setOrderClientExtensionsBody">Representation of the replacing Order</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20010</returns>
        ApiResponse<InlineResponse20010> SetOrderClientExtensionsWithHttpInfo (string authorization, string accountID, string orderSpecifier, SetOrderClientExtensionsBody setOrderClientExtensionsBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Set Trade Client Extensions
        /// </summary>
        /// <remarks>
        /// Update the Client Extensions for a Trade. Do not add, update, or delete the Client Extensions if your account is associated with MT4.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeClientExtensionsBody">Details of how to modify the Trade&#39;s Client Extensions.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20027</returns>
        InlineResponse20027 SetTradeClientExtensions (string authorization, string accountID, string tradeSpecifier, SetTradeClientExtensionsBody setTradeClientExtensionsBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Set Trade Client Extensions
        /// </summary>
        /// <remarks>
        /// Update the Client Extensions for a Trade. Do not add, update, or delete the Client Extensions if your account is associated with MT4.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeClientExtensionsBody">Details of how to modify the Trade&#39;s Client Extensions.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20027</returns>
        ApiResponse<InlineResponse20027> SetTradeClientExtensionsWithHttpInfo (string authorization, string accountID, string tradeSpecifier, SetTradeClientExtensionsBody setTradeClientExtensionsBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Set Dependent Orders
        /// </summary>
        /// <remarks>
        /// Create, replace and cancel a Trade&#39;s dependent Orders (Take Profit, Stop Loss and Trailing Stop Loss) through the Trade itself
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeDependentOrdersBody">Details of how to modify the Trade&#39;s dependent Orders.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20028</returns>
        InlineResponse20028 SetTradeDependentOrders (string authorization, string accountID, string tradeSpecifier, SetTradeDependentOrdersBody setTradeDependentOrdersBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Set Dependent Orders
        /// </summary>
        /// <remarks>
        /// Create, replace and cancel a Trade&#39;s dependent Orders (Take Profit, Stop Loss and Trailing Stop Loss) through the Trade itself
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeDependentOrdersBody">Details of how to modify the Trade&#39;s dependent Orders.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20028</returns>
        ApiResponse<InlineResponse20028> SetTradeDependentOrdersWithHttpInfo (string authorization, string accountID, string tradeSpecifier, SetTradeDependentOrdersBody setTradeDependentOrdersBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Price Stream
        /// </summary>
        /// <remarks>
        /// Get a stream of Account Prices starting from when the request is made. This pricing stream does not include every single price created for the Account, but instead will provide at most 4 prices per second (every 250 milliseconds) for each instrument being requested. If more than one price is created for an instrument during the 250 millisecond window, only the price in effect at the end of the window is sent. This means that during periods of rapid price movement, subscribers to this stream will not be sent every price. Pricing windows for different connections to the price stream are not all aligned in the same way (i.e. they are not all aligned to the top of the second). This means that during periods of rapid price movement, different subscribers may observe different prices depending on their alignment.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to stream Prices for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="snapshot">Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)</param>
        /// <returns>InlineResponse20022</returns>
        InlineResponse20022 StreamPricing (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, bool? snapshot = null);

        /// <summary>
        /// Price Stream
        /// </summary>
        /// <remarks>
        /// Get a stream of Account Prices starting from when the request is made. This pricing stream does not include every single price created for the Account, but instead will provide at most 4 prices per second (every 250 milliseconds) for each instrument being requested. If more than one price is created for an instrument during the 250 millisecond window, only the price in effect at the end of the window is sent. This means that during periods of rapid price movement, subscribers to this stream will not be sent every price. Pricing windows for different connections to the price stream are not all aligned in the same way (i.e. they are not all aligned to the top of the second). This means that during periods of rapid price movement, different subscribers may observe different prices depending on their alignment.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to stream Prices for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="snapshot">Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20022</returns>
        ApiResponse<InlineResponse20022> StreamPricingWithHttpInfo (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, bool? snapshot = null);
        /// <summary>
        /// Transaction Stream
        /// </summary>
        /// <remarks>
        /// Get a stream of Transactions for an Account starting from when the request is made.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>InlineResponse20020</returns>
        InlineResponse20020 StreamTransactions (string authorization, string accountID);

        /// <summary>
        /// Transaction Stream
        /// </summary>
        /// <remarks>
        /// Get a stream of Transactions for an Account starting from when the request is made.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>ApiResponse of InlineResponse20020</returns>
        ApiResponse<InlineResponse20020> StreamTransactionsWithHttpInfo (string authorization, string accountID);
        #endregion Synchronous Operations
        #region Asynchronous Operations
        /// <summary>
        /// Cancel Order
        /// </summary>
        /// <remarks>
        /// Cancel a pending Order in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse2009</returns>
        System.Threading.Tasks.Task<InlineResponse2009> CancelOrderAsync (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null);

        /// <summary>
        /// Cancel Order
        /// </summary>
        /// <remarks>
        /// Cancel a pending Order in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2009)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse2009>> CancelOrderAsyncWithHttpInfo (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null);
        /// <summary>
        /// Close Position
        /// </summary>
        /// <remarks>
        /// Closeout the open Position for a specific instrument in an Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="closePositionBody">Representation of how to close the position</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20014</returns>
        System.Threading.Tasks.Task<InlineResponse20014> ClosePositionAsync (string authorization, string accountID, string instrument, ClosePositionBody closePositionBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Close Position
        /// </summary>
        /// <remarks>
        /// Closeout the open Position for a specific instrument in an Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="closePositionBody">Representation of how to close the position</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20014)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20014>> ClosePositionAsyncWithHttpInfo (string authorization, string accountID, string instrument, ClosePositionBody closePositionBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Close Trade
        /// </summary>
        /// <remarks>
        /// Close (partially or fully) a specific open Trade in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="closeTradeBody">Details of how much of the open Trade to close.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20026</returns>
        System.Threading.Tasks.Task<InlineResponse20026> CloseTradeAsync (string authorization, string accountID, string tradeSpecifier, CloseTradeBody closeTradeBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Close Trade
        /// </summary>
        /// <remarks>
        /// Close (partially or fully) a specific open Trade in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="closeTradeBody">Details of how much of the open Trade to close.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20026)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20026>> CloseTradeAsyncWithHttpInfo (string authorization, string accountID, string tradeSpecifier, CloseTradeBody closeTradeBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Configure Account
        /// </summary>
        /// <remarks>
        /// Set the client-configurable portions of an Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="configureAccountBody">Representation of the Account configuration to set (optional)</param>
        /// <returns>Task of InlineResponse2004</returns>
        System.Threading.Tasks.Task<InlineResponse2004> ConfigureAccountAsync (string authorization, string accountID, string acceptDatetimeFormat = null, ConfigureAccountBody configureAccountBody = null);

        /// <summary>
        /// Configure Account
        /// </summary>
        /// <remarks>
        /// Set the client-configurable portions of an Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="configureAccountBody">Representation of the Account configuration to set (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2004)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse2004>> ConfigureAccountAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, ConfigureAccountBody configureAccountBody = null);
        /// <summary>
        /// Create Order
        /// </summary>
        /// <remarks>
        /// Create an Order for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="createOrderBody"></param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse201</returns>
        System.Threading.Tasks.Task<InlineResponse201> CreateOrderAsync (string authorization, string accountID, CreateOrderBody createOrderBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Create Order
        /// </summary>
        /// <remarks>
        /// Create an Order for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="createOrderBody"></param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse201)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse201>> CreateOrderAsyncWithHttpInfo (string authorization, string accountID, CreateOrderBody createOrderBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Account Details
        /// </summary>
        /// <remarks>
        /// Get the full details for a single Account that a client has access to. Full pending Order, open Trade and open Position representations are provided.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse2001</returns>
        System.Threading.Tasks.Task<InlineResponse2001> GetAccountAsync (string authorization, string accountID, string acceptDatetimeFormat = null);

        /// <summary>
        /// Account Details
        /// </summary>
        /// <remarks>
        /// Get the full details for a single Account that a client has access to. Full pending Order, open Trade and open Position representations are provided.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2001)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse2001>> GetAccountAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null);
        /// <summary>
        /// Poll Account Updates
        /// </summary>
        /// <remarks>
        /// Endpoint used to poll an Account for its current state and changes since a specified TransactionID.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="sinceTransactionID">ID of the Transaction to get Account changes since. (optional)</param>
        /// <returns>Task of InlineResponse2005</returns>
        System.Threading.Tasks.Task<InlineResponse2005> GetAccountChangesAsync (string authorization, string accountID, string acceptDatetimeFormat = null, string sinceTransactionID = null);

        /// <summary>
        /// Poll Account Updates
        /// </summary>
        /// <remarks>
        /// Endpoint used to poll an Account for its current state and changes since a specified TransactionID.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="sinceTransactionID">ID of the Transaction to get Account changes since. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2005)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse2005>> GetAccountChangesAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, string sinceTransactionID = null);
        /// <summary>
        /// Account Instruments
        /// </summary>
        /// <remarks>
        /// Get the list of tradeable instruments for the given Account. The list of tradeable instruments is dependent on the regulatory division that the Account is located in, thus should be the same for all Accounts owned by a single user.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of instruments to query specifically. (optional)</param>
        /// <returns>Task of InlineResponse2003</returns>
        System.Threading.Tasks.Task<InlineResponse2003> GetAccountInstrumentsAsync (string authorization, string accountID, List<string> instruments = null);

        /// <summary>
        /// Account Instruments
        /// </summary>
        /// <remarks>
        /// Get the list of tradeable instruments for the given Account. The list of tradeable instruments is dependent on the regulatory division that the Account is located in, thus should be the same for all Accounts owned by a single user.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of instruments to query specifically. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2003)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse2003>> GetAccountInstrumentsAsyncWithHttpInfo (string authorization, string accountID, List<string> instruments = null);
        /// <summary>
        /// Account Summary
        /// </summary>
        /// <remarks>
        /// Get a summary for a single Account that a client has access to.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse2002</returns>
        System.Threading.Tasks.Task<InlineResponse2002> GetAccountSummaryAsync (string authorization, string accountID, string acceptDatetimeFormat = null);

        /// <summary>
        /// Account Summary
        /// </summary>
        /// <remarks>
        /// Get a summary for a single Account that a client has access to.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2002)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse2002>> GetAccountSummaryAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null);
        /// <summary>
        /// External User Info
        /// </summary>
        /// <remarks>
        /// Fetch the externally-available user information for the specified user. This endpoint is intended to be used by 3rd parties that have been authorized by a user to view their personal information.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>Task of InlineResponse20016</returns>
        System.Threading.Tasks.Task<InlineResponse20016> GetExternalUserInfoAsync (string authorization, string userSpecifier);

        /// <summary>
        /// External User Info
        /// </summary>
        /// <remarks>
        /// Fetch the externally-available user information for the specified user. This endpoint is intended to be used by 3rd parties that have been authorized by a user to view their personal information.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>Task of ApiResponse (InlineResponse20016)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20016>> GetExternalUserInfoAsyncWithHttpInfo (string authorization, string userSpecifier);
        /// <summary>
        /// Get Candlesticks
        /// </summary>
        /// <remarks>
        /// Fetch candlestick data for an instrument.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="price">The Price component(s) to get candlestick data for. Can contain any combination of the characters \&quot;M\&quot; (midpoint candles) \&quot;B\&quot; (bid candles) and \&quot;A\&quot; (ask candles). (optional)</param>
        /// <param name="granularity">The granularity of the candlesticks to fetch (optional)</param>
        /// <param name="count">The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)</param>
        /// <param name="from">The start of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="to">The end of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="smooth">A flag that controls whether the candlestick is \&quot;smoothed\&quot; or not.  A smoothed candlestick uses the previous candle&#39;s close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)</param>
        /// <param name="includeFirst">A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)</param>
        /// <param name="dailyAlignment">The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)</param>
        /// <param name="alignmentTimezone">The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)</param>
        /// <param name="weeklyAlignment">The day of the week used for granularities that have weekly alignment. (optional)</param>
        /// <returns>Task of InlineResponse20029</returns>
        System.Threading.Tasks.Task<InlineResponse20029> GetInstrumentCandlesAsync (string authorization, string instrument, string acceptDatetimeFormat = null, string price = null, string granularity = null, int? count = null, string from = null, string to = null, bool? smooth = null, bool? includeFirst = null, int? dailyAlignment = null, string alignmentTimezone = null, string weeklyAlignment = null);

        /// <summary>
        /// Get Candlesticks
        /// </summary>
        /// <remarks>
        /// Fetch candlestick data for an instrument.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="price">The Price component(s) to get candlestick data for. Can contain any combination of the characters \&quot;M\&quot; (midpoint candles) \&quot;B\&quot; (bid candles) and \&quot;A\&quot; (ask candles). (optional)</param>
        /// <param name="granularity">The granularity of the candlesticks to fetch (optional)</param>
        /// <param name="count">The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)</param>
        /// <param name="from">The start of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="to">The end of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="smooth">A flag that controls whether the candlestick is \&quot;smoothed\&quot; or not.  A smoothed candlestick uses the previous candle&#39;s close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)</param>
        /// <param name="includeFirst">A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)</param>
        /// <param name="dailyAlignment">The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)</param>
        /// <param name="alignmentTimezone">The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)</param>
        /// <param name="weeklyAlignment">The day of the week used for granularities that have weekly alignment. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20029)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20029>> GetInstrumentCandlesAsyncWithHttpInfo (string authorization, string instrument, string acceptDatetimeFormat = null, string price = null, string granularity = null, int? count = null, string from = null, string to = null, bool? smooth = null, bool? includeFirst = null, int? dailyAlignment = null, string alignmentTimezone = null, string weeklyAlignment = null);
        /// <summary>
        /// Get Order
        /// </summary>
        /// <remarks>
        /// Get details for a single Order in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse2008</returns>
        System.Threading.Tasks.Task<InlineResponse2008> GetOrderAsync (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null);

        /// <summary>
        /// Get Order
        /// </summary>
        /// <remarks>
        /// Get details for a single Order in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2008)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse2008>> GetOrderAsyncWithHttpInfo (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null);
        /// <summary>
        /// Instrument Position
        /// </summary>
        /// <remarks>
        /// Get the details of a single Instrument&#39;s Position in an Account. The Position may by open or not.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <returns>Task of InlineResponse20013</returns>
        System.Threading.Tasks.Task<InlineResponse20013> GetPositionAsync (string authorization, string accountID, string instrument);

        /// <summary>
        /// Instrument Position
        /// </summary>
        /// <remarks>
        /// Get the details of a single Instrument&#39;s Position in an Account. The Position may by open or not.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <returns>Task of ApiResponse (InlineResponse20013)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20013>> GetPositionAsyncWithHttpInfo (string authorization, string accountID, string instrument);
        /// <summary>
        /// Current Account Prices
        /// </summary>
        /// <remarks>
        /// Get pricing information for a specified list of Instruments within an Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to get pricing for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="since">Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)</param>
        /// <param name="includeUnitsAvailable">Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)</param>
        /// <returns>Task of InlineResponse20021</returns>
        System.Threading.Tasks.Task<InlineResponse20021> GetPricesAsync (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, string since = null, bool? includeUnitsAvailable = null);

        /// <summary>
        /// Current Account Prices
        /// </summary>
        /// <remarks>
        /// Get pricing information for a specified list of Instruments within an Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to get pricing for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="since">Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)</param>
        /// <param name="includeUnitsAvailable">Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20021)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20021>> GetPricesAsyncWithHttpInfo (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, string since = null, bool? includeUnitsAvailable = null);
        /// <summary>
        /// Trade Details
        /// </summary>
        /// <remarks>
        /// Get the details of a specific Trade in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20025</returns>
        System.Threading.Tasks.Task<InlineResponse20025> GetTradeAsync (string authorization, string accountID, string tradeSpecifier, string acceptDatetimeFormat = null);

        /// <summary>
        /// Trade Details
        /// </summary>
        /// <remarks>
        /// Get the details of a specific Trade in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20025)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20025>> GetTradeAsyncWithHttpInfo (string authorization, string accountID, string tradeSpecifier, string acceptDatetimeFormat = null);
        /// <summary>
        /// Transaction Details
        /// </summary>
        /// <remarks>
        /// Get the details of a single Account Transaction.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="transactionID">A Transaction ID</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20018</returns>
        System.Threading.Tasks.Task<InlineResponse20018> GetTransactionAsync (string authorization, string accountID, string transactionID, string acceptDatetimeFormat = null);

        /// <summary>
        /// Transaction Details
        /// </summary>
        /// <remarks>
        /// Get the details of a single Account Transaction.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="transactionID">A Transaction ID</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20018)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20018>> GetTransactionAsyncWithHttpInfo (string authorization, string accountID, string transactionID, string acceptDatetimeFormat = null);
        /// <summary>
        /// Transaction ID Range
        /// </summary>
        /// <remarks>
        /// Get a range of Transactions for an Account based on the Transaction IDs.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="from">The starting Transacion ID (inclusive) to fetch.</param>
        /// <param name="to">The ending Transaction ID (inclusive) to fetch.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="type">The filter that restricts the types of Transactions to retreive. (optional)</param>
        /// <returns>Task of InlineResponse20019</returns>
        System.Threading.Tasks.Task<InlineResponse20019> GetTransactionRangeAsync (string authorization, string accountID, string from, string to, string acceptDatetimeFormat = null, List<string> type = null);

        /// <summary>
        /// Transaction ID Range
        /// </summary>
        /// <remarks>
        /// Get a range of Transactions for an Account based on the Transaction IDs.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="from">The starting Transacion ID (inclusive) to fetch.</param>
        /// <param name="to">The ending Transaction ID (inclusive) to fetch.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="type">The filter that restricts the types of Transactions to retreive. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20019)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20019>> GetTransactionRangeAsyncWithHttpInfo (string authorization, string accountID, string from, string to, string acceptDatetimeFormat = null, List<string> type = null);
        /// <summary>
        /// Transactions Since ID
        /// </summary>
        /// <remarks>
        /// Get a range of Transactions for an Account starting at (but not including) a provided Transaction ID.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="id">The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20019</returns>
        System.Threading.Tasks.Task<InlineResponse20019> GetTransactionsSinceIdAsync (string authorization, string accountID, string id, string acceptDatetimeFormat = null);

        /// <summary>
        /// Transactions Since ID
        /// </summary>
        /// <remarks>
        /// Get a range of Transactions for an Account starting at (but not including) a provided Transaction ID.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="id">The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20019)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20019>> GetTransactionsSinceIdAsyncWithHttpInfo (string authorization, string accountID, string id, string acceptDatetimeFormat = null);
        /// <summary>
        /// User Info
        /// </summary>
        /// <remarks>
        /// Fetch the user information for the specified user. This endpoint is intended to be used by the user themself to obtain their own information.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>Task of InlineResponse20015</returns>
        System.Threading.Tasks.Task<InlineResponse20015> GetUserInfoAsync (string authorization, string userSpecifier);

        /// <summary>
        /// User Info
        /// </summary>
        /// <remarks>
        /// Fetch the user information for the specified user. This endpoint is intended to be used by the user themself to obtain their own information.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>Task of ApiResponse (InlineResponse20015)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20015>> GetUserInfoAsyncWithHttpInfo (string authorization, string userSpecifier);
        /// <summary>
        /// List Accounts
        /// </summary>
        /// <remarks>
        /// Get a list of all Accounts authorized for the provided token.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <returns>Task of InlineResponse200</returns>
        System.Threading.Tasks.Task<InlineResponse200> ListAccountsAsync (string authorization);

        /// <summary>
        /// List Accounts
        /// </summary>
        /// <remarks>
        /// Get a list of all Accounts authorized for the provided token.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <returns>Task of ApiResponse (InlineResponse200)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse200>> ListAccountsAsyncWithHttpInfo (string authorization);
        /// <summary>
        /// Open Positions
        /// </summary>
        /// <remarks>
        /// List all open Positions for an Account. An open Position is a Position in an Account that currently has a Trade opened for it.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>Task of InlineResponse20012</returns>
        System.Threading.Tasks.Task<InlineResponse20012> ListOpenPositionsAsync (string authorization, string accountID);

        /// <summary>
        /// Open Positions
        /// </summary>
        /// <remarks>
        /// List all open Positions for an Account. An open Position is a Position in an Account that currently has a Trade opened for it.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>Task of ApiResponse (InlineResponse20012)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20012>> ListOpenPositionsAsyncWithHttpInfo (string authorization, string accountID);
        /// <summary>
        /// List Open Trades
        /// </summary>
        /// <remarks>
        /// Get the list of open Trades for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20024</returns>
        System.Threading.Tasks.Task<InlineResponse20024> ListOpenTradesAsync (string authorization, string accountID, string acceptDatetimeFormat = null);

        /// <summary>
        /// List Open Trades
        /// </summary>
        /// <remarks>
        /// Get the list of open Trades for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20024)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20024>> ListOpenTradesAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null);
        /// <summary>
        /// List Orders
        /// </summary>
        /// <remarks>
        /// Get a list of Orders for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Order IDs to retrieve (optional)</param>
        /// <param name="state">The state to filter the requested Orders by (optional)</param>
        /// <param name="instrument">The instrument to filter the requested orders by (optional)</param>
        /// <param name="count">The maximum number of Orders to return (optional)</param>
        /// <param name="beforeID">The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)</param>
        /// <returns>Task of InlineResponse2006</returns>
        System.Threading.Tasks.Task<InlineResponse2006> ListOrdersAsync (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null);

        /// <summary>
        /// List Orders
        /// </summary>
        /// <remarks>
        /// Get a list of Orders for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Order IDs to retrieve (optional)</param>
        /// <param name="state">The state to filter the requested Orders by (optional)</param>
        /// <param name="instrument">The instrument to filter the requested orders by (optional)</param>
        /// <param name="count">The maximum number of Orders to return (optional)</param>
        /// <param name="beforeID">The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2006)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse2006>> ListOrdersAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null);
        /// <summary>
        /// Pending Orders
        /// </summary>
        /// <remarks>
        /// List all pending Orders in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse2007</returns>
        System.Threading.Tasks.Task<InlineResponse2007> ListPendingOrdersAsync (string authorization, string accountID, string acceptDatetimeFormat = null);

        /// <summary>
        /// Pending Orders
        /// </summary>
        /// <remarks>
        /// List all pending Orders in an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2007)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse2007>> ListPendingOrdersAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null);
        /// <summary>
        /// List Positions
        /// </summary>
        /// <remarks>
        /// List all Positions for an Account. The Positions returned are for every instrument that has had a position during the lifetime of an the Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>Task of InlineResponse20011</returns>
        System.Threading.Tasks.Task<InlineResponse20011> ListPositionsAsync (string authorization, string accountID);

        /// <summary>
        /// List Positions
        /// </summary>
        /// <remarks>
        /// List all Positions for an Account. The Positions returned are for every instrument that has had a position during the lifetime of an the Account.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>Task of ApiResponse (InlineResponse20011)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20011>> ListPositionsAsyncWithHttpInfo (string authorization, string accountID);
        /// <summary>
        /// List Trades
        /// </summary>
        /// <remarks>
        /// Get a list of Trades for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Trade IDs to retrieve. (optional)</param>
        /// <param name="state">The state to filter the requested Trades by. (optional)</param>
        /// <param name="instrument">The instrument to filter the requested Trades by. (optional)</param>
        /// <param name="count">The maximum number of Trades to return. (optional)</param>
        /// <param name="beforeID">The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)</param>
        /// <returns>Task of InlineResponse20023</returns>
        System.Threading.Tasks.Task<InlineResponse20023> ListTradesAsync (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null);

        /// <summary>
        /// List Trades
        /// </summary>
        /// <remarks>
        /// Get a list of Trades for an Account
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Trade IDs to retrieve. (optional)</param>
        /// <param name="state">The state to filter the requested Trades by. (optional)</param>
        /// <param name="instrument">The instrument to filter the requested Trades by. (optional)</param>
        /// <param name="count">The maximum number of Trades to return. (optional)</param>
        /// <param name="beforeID">The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20023)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20023>> ListTradesAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null);
        /// <summary>
        /// List Transactions
        /// </summary>
        /// <remarks>
        /// Get a list of Transactions pages that satisfy a time-based Transaction query.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="from">The starting time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="to">The ending time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="pageSize">The number of Transactions to include in each page of the results. (optional)</param>
        /// <param name="type">A filter for restricting the types of Transactions to retreive. (optional)</param>
        /// <returns>Task of InlineResponse20017</returns>
        System.Threading.Tasks.Task<InlineResponse20017> ListTransactionsAsync (string authorization, string accountID, string acceptDatetimeFormat = null, string from = null, string to = null, int? pageSize = null, List<string> type = null);

        /// <summary>
        /// List Transactions
        /// </summary>
        /// <remarks>
        /// Get a list of Transactions pages that satisfy a time-based Transaction query.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="from">The starting time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="to">The ending time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="pageSize">The number of Transactions to include in each page of the results. (optional)</param>
        /// <param name="type">A filter for restricting the types of Transactions to retreive. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20017)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20017>> ListTransactionsAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, string from = null, string to = null, int? pageSize = null, List<string> type = null);
        /// <summary>
        /// Replace Order
        /// </summary>
        /// <remarks>
        /// Replace an Order in an Account by simultaneously cancelling it and creating a replacement Order
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="replaceOrderBody">Specification of the replacing Order. The replacing order must have the same type as the replaced Order.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse2011</returns>
        System.Threading.Tasks.Task<InlineResponse2011> ReplaceOrderAsync (string authorization, string accountID, string orderSpecifier, ReplaceOrderBody replaceOrderBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Replace Order
        /// </summary>
        /// <remarks>
        /// Replace an Order in an Account by simultaneously cancelling it and creating a replacement Order
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="replaceOrderBody">Specification of the replacing Order. The replacing order must have the same type as the replaced Order.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2011)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse2011>> ReplaceOrderAsyncWithHttpInfo (string authorization, string accountID, string orderSpecifier, ReplaceOrderBody replaceOrderBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Set Order Extensions
        /// </summary>
        /// <remarks>
        /// Update the Client Extensions for an Order in an Account. Do not set, modify, or delete clientExtensions if your account is associated with MT4.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="setOrderClientExtensionsBody">Representation of the replacing Order</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20010</returns>
        System.Threading.Tasks.Task<InlineResponse20010> SetOrderClientExtensionsAsync (string authorization, string accountID, string orderSpecifier, SetOrderClientExtensionsBody setOrderClientExtensionsBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Set Order Extensions
        /// </summary>
        /// <remarks>
        /// Update the Client Extensions for an Order in an Account. Do not set, modify, or delete clientExtensions if your account is associated with MT4.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="setOrderClientExtensionsBody">Representation of the replacing Order</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20010)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20010>> SetOrderClientExtensionsAsyncWithHttpInfo (string authorization, string accountID, string orderSpecifier, SetOrderClientExtensionsBody setOrderClientExtensionsBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Set Trade Client Extensions
        /// </summary>
        /// <remarks>
        /// Update the Client Extensions for a Trade. Do not add, update, or delete the Client Extensions if your account is associated with MT4.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeClientExtensionsBody">Details of how to modify the Trade&#39;s Client Extensions.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20027</returns>
        System.Threading.Tasks.Task<InlineResponse20027> SetTradeClientExtensionsAsync (string authorization, string accountID, string tradeSpecifier, SetTradeClientExtensionsBody setTradeClientExtensionsBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Set Trade Client Extensions
        /// </summary>
        /// <remarks>
        /// Update the Client Extensions for a Trade. Do not add, update, or delete the Client Extensions if your account is associated with MT4.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeClientExtensionsBody">Details of how to modify the Trade&#39;s Client Extensions.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20027)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20027>> SetTradeClientExtensionsAsyncWithHttpInfo (string authorization, string accountID, string tradeSpecifier, SetTradeClientExtensionsBody setTradeClientExtensionsBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Set Dependent Orders
        /// </summary>
        /// <remarks>
        /// Create, replace and cancel a Trade&#39;s dependent Orders (Take Profit, Stop Loss and Trailing Stop Loss) through the Trade itself
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeDependentOrdersBody">Details of how to modify the Trade&#39;s dependent Orders.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20028</returns>
        System.Threading.Tasks.Task<InlineResponse20028> SetTradeDependentOrdersAsync (string authorization, string accountID, string tradeSpecifier, SetTradeDependentOrdersBody setTradeDependentOrdersBody, string acceptDatetimeFormat = null);

        /// <summary>
        /// Set Dependent Orders
        /// </summary>
        /// <remarks>
        /// Create, replace and cancel a Trade&#39;s dependent Orders (Take Profit, Stop Loss and Trailing Stop Loss) through the Trade itself
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeDependentOrdersBody">Details of how to modify the Trade&#39;s dependent Orders.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20028)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20028>> SetTradeDependentOrdersAsyncWithHttpInfo (string authorization, string accountID, string tradeSpecifier, SetTradeDependentOrdersBody setTradeDependentOrdersBody, string acceptDatetimeFormat = null);
        /// <summary>
        /// Price Stream
        /// </summary>
        /// <remarks>
        /// Get a stream of Account Prices starting from when the request is made. This pricing stream does not include every single price created for the Account, but instead will provide at most 4 prices per second (every 250 milliseconds) for each instrument being requested. If more than one price is created for an instrument during the 250 millisecond window, only the price in effect at the end of the window is sent. This means that during periods of rapid price movement, subscribers to this stream will not be sent every price. Pricing windows for different connections to the price stream are not all aligned in the same way (i.e. they are not all aligned to the top of the second). This means that during periods of rapid price movement, different subscribers may observe different prices depending on their alignment.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to stream Prices for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="snapshot">Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)</param>
        /// <returns>Task of InlineResponse20022</returns>
        System.Threading.Tasks.Task<InlineResponse20022> StreamPricingAsync (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, bool? snapshot = null);

        /// <summary>
        /// Price Stream
        /// </summary>
        /// <remarks>
        /// Get a stream of Account Prices starting from when the request is made. This pricing stream does not include every single price created for the Account, but instead will provide at most 4 prices per second (every 250 milliseconds) for each instrument being requested. If more than one price is created for an instrument during the 250 millisecond window, only the price in effect at the end of the window is sent. This means that during periods of rapid price movement, subscribers to this stream will not be sent every price. Pricing windows for different connections to the price stream are not all aligned in the same way (i.e. they are not all aligned to the top of the second). This means that during periods of rapid price movement, different subscribers may observe different prices depending on their alignment.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to stream Prices for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="snapshot">Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20022)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20022>> StreamPricingAsyncWithHttpInfo (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, bool? snapshot = null);
        /// <summary>
        /// Transaction Stream
        /// </summary>
        /// <remarks>
        /// Get a stream of Transactions for an Account starting from when the request is made.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>Task of InlineResponse20020</returns>
        System.Threading.Tasks.Task<InlineResponse20020> StreamTransactionsAsync (string authorization, string accountID);

        /// <summary>
        /// Transaction Stream
        /// </summary>
        /// <remarks>
        /// Get a stream of Transactions for an Account starting from when the request is made.
        /// </remarks>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>Task of ApiResponse (InlineResponse20020)</returns>
        System.Threading.Tasks.Task<ApiResponse<InlineResponse20020>> StreamTransactionsAsyncWithHttpInfo (string authorization, string accountID);
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class DefaultApi : IDefaultApi
    {
        private Oanda.RestV20.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="DefaultApi"/> class.
        /// </summary>
        /// <returns></returns>
        public DefaultApi(String basePath)
        {
            this.Configuration = new Configuration(new ApiClient(basePath));

            ExceptionFactory = Oanda.RestV20.Client.Configuration.DefaultExceptionFactory;

            // ensure API client has configuration ready
            if (Configuration.ApiClient.Configuration == null)
            {
                this.Configuration.ApiClient.Configuration = this.Configuration;
            }
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="DefaultApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public DefaultApi(Configuration configuration = null)
        {
            if (configuration == null) // use the default one in Configuration
                this.Configuration = Configuration.Default;
            else
                this.Configuration = configuration;

            ExceptionFactory = Oanda.RestV20.Client.Configuration.DefaultExceptionFactory;

            // ensure API client has configuration ready
            if (Configuration.ApiClient.Configuration == null)
            {
                this.Configuration.ApiClient.Configuration = this.Configuration;
            }
        }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public String GetBasePath()
        {
            return this.Configuration.ApiClient.RestClient.BaseUrl.ToString();
        }

        /// <summary>
        /// Sets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        [Obsolete("SetBasePath is deprecated, please do 'Configuration.ApiClient = new ApiClient(\"http://new-path\")' instead.")]
        public void SetBasePath(String basePath)
        {
            // do nothing
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Configuration Configuration {get; set;}

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Oanda.RestV20.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Gets the default header.
        /// </summary>
        /// <returns>Dictionary of HTTP header</returns>
        [Obsolete("DefaultHeader is deprecated, please use Configuration.DefaultHeader instead.")]
        public Dictionary<String, String> DefaultHeader()
        {
            return this.Configuration.DefaultHeader;
        }

        /// <summary>
        /// Add default header.
        /// </summary>
        /// <param name="key">Header field name.</param>
        /// <param name="value">Header field value.</param>
        /// <returns></returns>
        [Obsolete("AddDefaultHeader is deprecated, please use Configuration.AddDefaultHeader instead.")]
        public void AddDefaultHeader(string key, string value)
        {
            this.Configuration.AddDefaultHeader(key, value);
        }

        /// <summary>
        /// Cancel Order Cancel a pending Order in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse2009</returns>
        public InlineResponse2009 CancelOrder (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse2009> localVarResponse = CancelOrderWithHttpInfo(authorization, accountID, orderSpecifier, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Cancel Order Cancel a pending Order in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2009</returns>
        public ApiResponse< InlineResponse2009 > CancelOrderWithHttpInfo (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->CancelOrder");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->CancelOrder");
            // verify the required parameter 'orderSpecifier' is set
            if (orderSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'orderSpecifier' when calling DefaultApi->CancelOrder");

            var localVarPath = "/accounts/{accountID}/orders/{orderSpecifier}/cancel";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (orderSpecifier != null) localVarPathParams.Add("orderSpecifier", Configuration.ApiClient.ParameterToString(orderSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("CancelOrder", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2009>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2009) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2009)));
            
        }

        /// <summary>
        /// Cancel Order Cancel a pending Order in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse2009</returns>
        public async System.Threading.Tasks.Task<InlineResponse2009> CancelOrderAsync (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse2009> localVarResponse = await CancelOrderAsyncWithHttpInfo(authorization, accountID, orderSpecifier, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Cancel Order Cancel a pending Order in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2009)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse2009>> CancelOrderAsyncWithHttpInfo (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->CancelOrder");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->CancelOrder");
            // verify the required parameter 'orderSpecifier' is set
            if (orderSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'orderSpecifier' when calling DefaultApi->CancelOrder");

            var localVarPath = "/accounts/{accountID}/orders/{orderSpecifier}/cancel";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (orderSpecifier != null) localVarPathParams.Add("orderSpecifier", Configuration.ApiClient.ParameterToString(orderSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("CancelOrder", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2009>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2009) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2009)));
            
        }

        /// <summary>
        /// Close Position Closeout the open Position for a specific instrument in an Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="closePositionBody">Representation of how to close the position</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20014</returns>
        public InlineResponse20014 ClosePosition (string authorization, string accountID, string instrument, ClosePositionBody closePositionBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20014> localVarResponse = ClosePositionWithHttpInfo(authorization, accountID, instrument, closePositionBody, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Close Position Closeout the open Position for a specific instrument in an Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="closePositionBody">Representation of how to close the position</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20014</returns>
        public ApiResponse< InlineResponse20014 > ClosePositionWithHttpInfo (string authorization, string accountID, string instrument, ClosePositionBody closePositionBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ClosePosition");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ClosePosition");
            // verify the required parameter 'instrument' is set
            if (instrument == null)
                throw new ApiException(400, "Missing required parameter 'instrument' when calling DefaultApi->ClosePosition");
            // verify the required parameter 'closePositionBody' is set
            if (closePositionBody == null)
                throw new ApiException(400, "Missing required parameter 'closePositionBody' when calling DefaultApi->ClosePosition");

            var localVarPath = "/accounts/{accountID}/positions/{instrument}/close";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (instrument != null) localVarPathParams.Add("instrument", Configuration.ApiClient.ParameterToString(instrument)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (closePositionBody != null && closePositionBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(closePositionBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = closePositionBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ClosePosition", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20014>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20014) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20014)));
            
        }

        /// <summary>
        /// Close Position Closeout the open Position for a specific instrument in an Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="closePositionBody">Representation of how to close the position</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20014</returns>
        public async System.Threading.Tasks.Task<InlineResponse20014> ClosePositionAsync (string authorization, string accountID, string instrument, ClosePositionBody closePositionBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20014> localVarResponse = await ClosePositionAsyncWithHttpInfo(authorization, accountID, instrument, closePositionBody, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Close Position Closeout the open Position for a specific instrument in an Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="closePositionBody">Representation of how to close the position</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20014)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20014>> ClosePositionAsyncWithHttpInfo (string authorization, string accountID, string instrument, ClosePositionBody closePositionBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ClosePosition");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ClosePosition");
            // verify the required parameter 'instrument' is set
            if (instrument == null)
                throw new ApiException(400, "Missing required parameter 'instrument' when calling DefaultApi->ClosePosition");
            // verify the required parameter 'closePositionBody' is set
            if (closePositionBody == null)
                throw new ApiException(400, "Missing required parameter 'closePositionBody' when calling DefaultApi->ClosePosition");

            var localVarPath = "/accounts/{accountID}/positions/{instrument}/close";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (instrument != null) localVarPathParams.Add("instrument", Configuration.ApiClient.ParameterToString(instrument)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (closePositionBody != null && closePositionBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(closePositionBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = closePositionBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ClosePosition", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20014>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20014) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20014)));
            
        }

        /// <summary>
        /// Close Trade Close (partially or fully) a specific open Trade in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="closeTradeBody">Details of how much of the open Trade to close.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20026</returns>
        public InlineResponse20026 CloseTrade (string authorization, string accountID, string tradeSpecifier, CloseTradeBody closeTradeBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20026> localVarResponse = CloseTradeWithHttpInfo(authorization, accountID, tradeSpecifier, closeTradeBody, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Close Trade Close (partially or fully) a specific open Trade in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="closeTradeBody">Details of how much of the open Trade to close.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20026</returns>
        public ApiResponse< InlineResponse20026 > CloseTradeWithHttpInfo (string authorization, string accountID, string tradeSpecifier, CloseTradeBody closeTradeBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->CloseTrade");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->CloseTrade");
            // verify the required parameter 'tradeSpecifier' is set
            if (tradeSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'tradeSpecifier' when calling DefaultApi->CloseTrade");
            // verify the required parameter 'closeTradeBody' is set
            if (closeTradeBody == null)
                throw new ApiException(400, "Missing required parameter 'closeTradeBody' when calling DefaultApi->CloseTrade");

            var localVarPath = "/accounts/{accountID}/trades/{tradeSpecifier}/close";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (tradeSpecifier != null) localVarPathParams.Add("tradeSpecifier", Configuration.ApiClient.ParameterToString(tradeSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (closeTradeBody != null && closeTradeBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(closeTradeBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = closeTradeBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("CloseTrade", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20026>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20026) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20026)));
            
        }

        /// <summary>
        /// Close Trade Close (partially or fully) a specific open Trade in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="closeTradeBody">Details of how much of the open Trade to close.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20026</returns>
        public async System.Threading.Tasks.Task<InlineResponse20026> CloseTradeAsync (string authorization, string accountID, string tradeSpecifier, CloseTradeBody closeTradeBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20026> localVarResponse = await CloseTradeAsyncWithHttpInfo(authorization, accountID, tradeSpecifier, closeTradeBody, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Close Trade Close (partially or fully) a specific open Trade in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="closeTradeBody">Details of how much of the open Trade to close.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20026)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20026>> CloseTradeAsyncWithHttpInfo (string authorization, string accountID, string tradeSpecifier, CloseTradeBody closeTradeBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->CloseTrade");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->CloseTrade");
            // verify the required parameter 'tradeSpecifier' is set
            if (tradeSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'tradeSpecifier' when calling DefaultApi->CloseTrade");
            // verify the required parameter 'closeTradeBody' is set
            if (closeTradeBody == null)
                throw new ApiException(400, "Missing required parameter 'closeTradeBody' when calling DefaultApi->CloseTrade");

            var localVarPath = "/accounts/{accountID}/trades/{tradeSpecifier}/close";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (tradeSpecifier != null) localVarPathParams.Add("tradeSpecifier", Configuration.ApiClient.ParameterToString(tradeSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (closeTradeBody != null && closeTradeBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(closeTradeBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = closeTradeBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("CloseTrade", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20026>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20026) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20026)));
            
        }

        /// <summary>
        /// Configure Account Set the client-configurable portions of an Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="configureAccountBody">Representation of the Account configuration to set (optional)</param>
        /// <returns>InlineResponse2004</returns>
        public InlineResponse2004 ConfigureAccount (string authorization, string accountID, string acceptDatetimeFormat = null, ConfigureAccountBody configureAccountBody = null)
        {
             ApiResponse<InlineResponse2004> localVarResponse = ConfigureAccountWithHttpInfo(authorization, accountID, acceptDatetimeFormat, configureAccountBody);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Configure Account Set the client-configurable portions of an Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="configureAccountBody">Representation of the Account configuration to set (optional)</param>
        /// <returns>ApiResponse of InlineResponse2004</returns>
        public ApiResponse< InlineResponse2004 > ConfigureAccountWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, ConfigureAccountBody configureAccountBody = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ConfigureAccount");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ConfigureAccount");

            var localVarPath = "/accounts/{accountID}/configuration";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (configureAccountBody != null && configureAccountBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(configureAccountBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = configureAccountBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.PATCH, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ConfigureAccount", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2004>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2004) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2004)));
            
        }

        /// <summary>
        /// Configure Account Set the client-configurable portions of an Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="configureAccountBody">Representation of the Account configuration to set (optional)</param>
        /// <returns>Task of InlineResponse2004</returns>
        public async System.Threading.Tasks.Task<InlineResponse2004> ConfigureAccountAsync (string authorization, string accountID, string acceptDatetimeFormat = null, ConfigureAccountBody configureAccountBody = null)
        {
             ApiResponse<InlineResponse2004> localVarResponse = await ConfigureAccountAsyncWithHttpInfo(authorization, accountID, acceptDatetimeFormat, configureAccountBody);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Configure Account Set the client-configurable portions of an Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="configureAccountBody">Representation of the Account configuration to set (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2004)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse2004>> ConfigureAccountAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, ConfigureAccountBody configureAccountBody = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ConfigureAccount");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ConfigureAccount");

            var localVarPath = "/accounts/{accountID}/configuration";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (configureAccountBody != null && configureAccountBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(configureAccountBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = configureAccountBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.PATCH, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ConfigureAccount", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2004>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2004) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2004)));
            
        }

        /// <summary>
        /// Create Order Create an Order for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="createOrderBody"></param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse201</returns>
        public InlineResponse201 CreateOrder (string authorization, string accountID, CreateOrderBody createOrderBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse201> localVarResponse = CreateOrderWithHttpInfo(authorization, accountID, createOrderBody, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Create Order Create an Order for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="createOrderBody"></param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse201</returns>
        public ApiResponse< InlineResponse201 > CreateOrderWithHttpInfo (string authorization, string accountID, CreateOrderBody createOrderBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->CreateOrder");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->CreateOrder");
            // verify the required parameter 'createOrderBody' is set
            if (createOrderBody == null)
                throw new ApiException(400, "Missing required parameter 'createOrderBody' when calling DefaultApi->CreateOrder");

            var localVarPath = "/accounts/{accountID}/orders";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (createOrderBody != null && createOrderBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(createOrderBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = createOrderBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.POST, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("CreateOrder", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse201>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse201) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse201)));
            
        }

        /// <summary>
        /// Create Order Create an Order for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="createOrderBody"></param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse201</returns>
        public async System.Threading.Tasks.Task<InlineResponse201> CreateOrderAsync (string authorization, string accountID, CreateOrderBody createOrderBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse201> localVarResponse = await CreateOrderAsyncWithHttpInfo(authorization, accountID, createOrderBody, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Create Order Create an Order for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="createOrderBody"></param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse201)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse201>> CreateOrderAsyncWithHttpInfo (string authorization, string accountID, CreateOrderBody createOrderBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->CreateOrder");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->CreateOrder");
            // verify the required parameter 'createOrderBody' is set
            if (createOrderBody == null)
                throw new ApiException(400, "Missing required parameter 'createOrderBody' when calling DefaultApi->CreateOrder");

            var localVarPath = "/accounts/{accountID}/orders";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (createOrderBody != null && createOrderBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(createOrderBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = createOrderBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.POST, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("CreateOrder", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse201>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse201) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse201)));
            
        }

        /// <summary>
        /// Account Details Get the full details for a single Account that a client has access to. Full pending Order, open Trade and open Position representations are provided.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse2001</returns>
        public InlineResponse2001 GetAccount (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse2001> localVarResponse = GetAccountWithHttpInfo(authorization, accountID, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Account Details Get the full details for a single Account that a client has access to. Full pending Order, open Trade and open Position representations are provided.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2001</returns>
        public ApiResponse< InlineResponse2001 > GetAccountWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetAccount");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetAccount");

            var localVarPath = "/accounts/{accountID}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetAccount", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2001>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2001) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2001)));
            
        }

        /// <summary>
        /// Account Details Get the full details for a single Account that a client has access to. Full pending Order, open Trade and open Position representations are provided.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse2001</returns>
        public async System.Threading.Tasks.Task<InlineResponse2001> GetAccountAsync (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse2001> localVarResponse = await GetAccountAsyncWithHttpInfo(authorization, accountID, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Account Details Get the full details for a single Account that a client has access to. Full pending Order, open Trade and open Position representations are provided.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2001)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse2001>> GetAccountAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetAccount");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetAccount");

            var localVarPath = "/accounts/{accountID}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetAccount", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2001>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2001) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2001)));
            
        }

        /// <summary>
        /// Poll Account Updates Endpoint used to poll an Account for its current state and changes since a specified TransactionID.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="sinceTransactionID">ID of the Transaction to get Account changes since. (optional)</param>
        /// <returns>InlineResponse2005</returns>
        public InlineResponse2005 GetAccountChanges (string authorization, string accountID, string acceptDatetimeFormat = null, string sinceTransactionID = null)
        {
             ApiResponse<InlineResponse2005> localVarResponse = GetAccountChangesWithHttpInfo(authorization, accountID, acceptDatetimeFormat, sinceTransactionID);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Poll Account Updates Endpoint used to poll an Account for its current state and changes since a specified TransactionID.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="sinceTransactionID">ID of the Transaction to get Account changes since. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2005</returns>
        public ApiResponse< InlineResponse2005 > GetAccountChangesWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, string sinceTransactionID = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetAccountChanges");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetAccountChanges");

            var localVarPath = "/accounts/{accountID}/changes";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (sinceTransactionID != null) localVarQueryParams.Add("sinceTransactionID", Configuration.ApiClient.ParameterToString(sinceTransactionID)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetAccountChanges", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2005>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2005) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2005)));
            
        }

        /// <summary>
        /// Poll Account Updates Endpoint used to poll an Account for its current state and changes since a specified TransactionID.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="sinceTransactionID">ID of the Transaction to get Account changes since. (optional)</param>
        /// <returns>Task of InlineResponse2005</returns>
        public async System.Threading.Tasks.Task<InlineResponse2005> GetAccountChangesAsync (string authorization, string accountID, string acceptDatetimeFormat = null, string sinceTransactionID = null)
        {
             ApiResponse<InlineResponse2005> localVarResponse = await GetAccountChangesAsyncWithHttpInfo(authorization, accountID, acceptDatetimeFormat, sinceTransactionID);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Poll Account Updates Endpoint used to poll an Account for its current state and changes since a specified TransactionID.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="sinceTransactionID">ID of the Transaction to get Account changes since. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2005)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse2005>> GetAccountChangesAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, string sinceTransactionID = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetAccountChanges");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetAccountChanges");

            var localVarPath = "/accounts/{accountID}/changes";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (sinceTransactionID != null) localVarQueryParams.Add("sinceTransactionID", Configuration.ApiClient.ParameterToString(sinceTransactionID)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetAccountChanges", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2005>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2005) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2005)));
            
        }

        /// <summary>
        /// Account Instruments Get the list of tradeable instruments for the given Account. The list of tradeable instruments is dependent on the regulatory division that the Account is located in, thus should be the same for all Accounts owned by a single user.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of instruments to query specifically. (optional)</param>
        /// <returns>InlineResponse2003</returns>
        public InlineResponse2003 GetAccountInstruments (string authorization, string accountID, List<string> instruments = null)
        {
             ApiResponse<InlineResponse2003> localVarResponse = GetAccountInstrumentsWithHttpInfo(authorization, accountID, instruments);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Account Instruments Get the list of tradeable instruments for the given Account. The list of tradeable instruments is dependent on the regulatory division that the Account is located in, thus should be the same for all Accounts owned by a single user.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of instruments to query specifically. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2003</returns>
        public ApiResponse< InlineResponse2003 > GetAccountInstrumentsWithHttpInfo (string authorization, string accountID, List<string> instruments = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetAccountInstruments");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetAccountInstruments");

            var localVarPath = "/accounts/{accountID}/instruments";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (instruments != null) localVarQueryParams.Add("instruments", Configuration.ApiClient.ParameterToString(instruments)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetAccountInstruments", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2003>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2003) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2003)));
            
        }

        /// <summary>
        /// Account Instruments Get the list of tradeable instruments for the given Account. The list of tradeable instruments is dependent on the regulatory division that the Account is located in, thus should be the same for all Accounts owned by a single user.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of instruments to query specifically. (optional)</param>
        /// <returns>Task of InlineResponse2003</returns>
        public async System.Threading.Tasks.Task<InlineResponse2003> GetAccountInstrumentsAsync (string authorization, string accountID, List<string> instruments = null)
        {
             ApiResponse<InlineResponse2003> localVarResponse = await GetAccountInstrumentsAsyncWithHttpInfo(authorization, accountID, instruments);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Account Instruments Get the list of tradeable instruments for the given Account. The list of tradeable instruments is dependent on the regulatory division that the Account is located in, thus should be the same for all Accounts owned by a single user.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of instruments to query specifically. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2003)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse2003>> GetAccountInstrumentsAsyncWithHttpInfo (string authorization, string accountID, List<string> instruments = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetAccountInstruments");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetAccountInstruments");

            var localVarPath = "/accounts/{accountID}/instruments";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (instruments != null) localVarQueryParams.Add("instruments", Configuration.ApiClient.ParameterToString(instruments)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetAccountInstruments", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2003>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2003) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2003)));
            
        }

        /// <summary>
        /// Account Summary Get a summary for a single Account that a client has access to.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse2002</returns>
        public InlineResponse2002 GetAccountSummary (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse2002> localVarResponse = GetAccountSummaryWithHttpInfo(authorization, accountID, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Account Summary Get a summary for a single Account that a client has access to.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2002</returns>
        public ApiResponse< InlineResponse2002 > GetAccountSummaryWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetAccountSummary");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetAccountSummary");

            var localVarPath = "/accounts/{accountID}/summary";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetAccountSummary", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2002>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2002) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2002)));
            
        }

        /// <summary>
        /// Account Summary Get a summary for a single Account that a client has access to.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse2002</returns>
        public async System.Threading.Tasks.Task<InlineResponse2002> GetAccountSummaryAsync (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse2002> localVarResponse = await GetAccountSummaryAsyncWithHttpInfo(authorization, accountID, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Account Summary Get a summary for a single Account that a client has access to.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2002)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse2002>> GetAccountSummaryAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetAccountSummary");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetAccountSummary");

            var localVarPath = "/accounts/{accountID}/summary";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetAccountSummary", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2002>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2002) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2002)));
            
        }

        /// <summary>
        /// External User Info Fetch the externally-available user information for the specified user. This endpoint is intended to be used by 3rd parties that have been authorized by a user to view their personal information.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>InlineResponse20016</returns>
        public InlineResponse20016 GetExternalUserInfo (string authorization, string userSpecifier)
        {
             ApiResponse<InlineResponse20016> localVarResponse = GetExternalUserInfoWithHttpInfo(authorization, userSpecifier);
             return localVarResponse.Data;
        }

        /// <summary>
        /// External User Info Fetch the externally-available user information for the specified user. This endpoint is intended to be used by 3rd parties that have been authorized by a user to view their personal information.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>ApiResponse of InlineResponse20016</returns>
        public ApiResponse< InlineResponse20016 > GetExternalUserInfoWithHttpInfo (string authorization, string userSpecifier)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetExternalUserInfo");
            // verify the required parameter 'userSpecifier' is set
            if (userSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'userSpecifier' when calling DefaultApi->GetExternalUserInfo");

            var localVarPath = "/users/{userSpecifier}/externalInfo";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (userSpecifier != null) localVarPathParams.Add("userSpecifier", Configuration.ApiClient.ParameterToString(userSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetExternalUserInfo", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20016>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20016) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20016)));
            
        }

        /// <summary>
        /// External User Info Fetch the externally-available user information for the specified user. This endpoint is intended to be used by 3rd parties that have been authorized by a user to view their personal information.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>Task of InlineResponse20016</returns>
        public async System.Threading.Tasks.Task<InlineResponse20016> GetExternalUserInfoAsync (string authorization, string userSpecifier)
        {
             ApiResponse<InlineResponse20016> localVarResponse = await GetExternalUserInfoAsyncWithHttpInfo(authorization, userSpecifier);
             return localVarResponse.Data;

        }

        /// <summary>
        /// External User Info Fetch the externally-available user information for the specified user. This endpoint is intended to be used by 3rd parties that have been authorized by a user to view their personal information.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>Task of ApiResponse (InlineResponse20016)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20016>> GetExternalUserInfoAsyncWithHttpInfo (string authorization, string userSpecifier)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetExternalUserInfo");
            // verify the required parameter 'userSpecifier' is set
            if (userSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'userSpecifier' when calling DefaultApi->GetExternalUserInfo");

            var localVarPath = "/users/{userSpecifier}/externalInfo";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (userSpecifier != null) localVarPathParams.Add("userSpecifier", Configuration.ApiClient.ParameterToString(userSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetExternalUserInfo", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20016>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20016) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20016)));
            
        }

        /// <summary>
        /// Get Candlesticks Fetch candlestick data for an instrument.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="price">The Price component(s) to get candlestick data for. Can contain any combination of the characters \&quot;M\&quot; (midpoint candles) \&quot;B\&quot; (bid candles) and \&quot;A\&quot; (ask candles). (optional)</param>
        /// <param name="granularity">The granularity of the candlesticks to fetch (optional)</param>
        /// <param name="count">The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)</param>
        /// <param name="from">The start of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="to">The end of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="smooth">A flag that controls whether the candlestick is \&quot;smoothed\&quot; or not.  A smoothed candlestick uses the previous candle&#39;s close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)</param>
        /// <param name="includeFirst">A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)</param>
        /// <param name="dailyAlignment">The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)</param>
        /// <param name="alignmentTimezone">The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)</param>
        /// <param name="weeklyAlignment">The day of the week used for granularities that have weekly alignment. (optional)</param>
        /// <returns>InlineResponse20029</returns>
        public InlineResponse20029 GetInstrumentCandles (string authorization, string instrument, string acceptDatetimeFormat = null, string price = null, string granularity = null, int? count = null, string from = null, string to = null, bool? smooth = null, bool? includeFirst = null, int? dailyAlignment = null, string alignmentTimezone = null, string weeklyAlignment = null)
        {
             ApiResponse<InlineResponse20029> localVarResponse = GetInstrumentCandlesWithHttpInfo(authorization, instrument, acceptDatetimeFormat, price, granularity, count, from, to, smooth, includeFirst, dailyAlignment, alignmentTimezone, weeklyAlignment);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get Candlesticks Fetch candlestick data for an instrument.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="price">The Price component(s) to get candlestick data for. Can contain any combination of the characters \&quot;M\&quot; (midpoint candles) \&quot;B\&quot; (bid candles) and \&quot;A\&quot; (ask candles). (optional)</param>
        /// <param name="granularity">The granularity of the candlesticks to fetch (optional)</param>
        /// <param name="count">The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)</param>
        /// <param name="from">The start of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="to">The end of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="smooth">A flag that controls whether the candlestick is \&quot;smoothed\&quot; or not.  A smoothed candlestick uses the previous candle&#39;s close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)</param>
        /// <param name="includeFirst">A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)</param>
        /// <param name="dailyAlignment">The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)</param>
        /// <param name="alignmentTimezone">The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)</param>
        /// <param name="weeklyAlignment">The day of the week used for granularities that have weekly alignment. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20029</returns>
        public ApiResponse< InlineResponse20029 > GetInstrumentCandlesWithHttpInfo (string authorization, string instrument, string acceptDatetimeFormat = null, string price = null, string granularity = null, int? count = null, string from = null, string to = null, bool? smooth = null, bool? includeFirst = null, int? dailyAlignment = null, string alignmentTimezone = null, string weeklyAlignment = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetInstrumentCandles");
            // verify the required parameter 'instrument' is set
            if (instrument == null)
                throw new ApiException(400, "Missing required parameter 'instrument' when calling DefaultApi->GetInstrumentCandles");

            var localVarPath = "/instruments/{instrument}/candles";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (instrument != null) localVarPathParams.Add("instrument", Configuration.ApiClient.ParameterToString(instrument)); // path parameter
            if (price != null) localVarQueryParams.Add("price", Configuration.ApiClient.ParameterToString(price)); // query parameter
            if (granularity != null) localVarQueryParams.Add("granularity", Configuration.ApiClient.ParameterToString(granularity)); // query parameter
            if (count != null) localVarQueryParams.Add("count", Configuration.ApiClient.ParameterToString(count)); // query parameter
            if (from != null) localVarQueryParams.Add("from", Configuration.ApiClient.ParameterToString(from)); // query parameter
            if (to != null) localVarQueryParams.Add("to", Configuration.ApiClient.ParameterToString(to)); // query parameter
            if (smooth != null) localVarQueryParams.Add("smooth", Configuration.ApiClient.ParameterToString(smooth)); // query parameter
            if (includeFirst != null) localVarQueryParams.Add("includeFirst", Configuration.ApiClient.ParameterToString(includeFirst)); // query parameter
            if (dailyAlignment != null) localVarQueryParams.Add("dailyAlignment", Configuration.ApiClient.ParameterToString(dailyAlignment)); // query parameter
            if (alignmentTimezone != null) localVarQueryParams.Add("alignmentTimezone", Configuration.ApiClient.ParameterToString(alignmentTimezone)); // query parameter
            if (weeklyAlignment != null) localVarQueryParams.Add("weeklyAlignment", Configuration.ApiClient.ParameterToString(weeklyAlignment)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetInstrumentCandles", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20029>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20029) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20029)));
            
        }

        /// <summary>
        /// Get Candlesticks Fetch candlestick data for an instrument.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="price">The Price component(s) to get candlestick data for. Can contain any combination of the characters \&quot;M\&quot; (midpoint candles) \&quot;B\&quot; (bid candles) and \&quot;A\&quot; (ask candles). (optional)</param>
        /// <param name="granularity">The granularity of the candlesticks to fetch (optional)</param>
        /// <param name="count">The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)</param>
        /// <param name="from">The start of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="to">The end of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="smooth">A flag that controls whether the candlestick is \&quot;smoothed\&quot; or not.  A smoothed candlestick uses the previous candle&#39;s close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)</param>
        /// <param name="includeFirst">A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)</param>
        /// <param name="dailyAlignment">The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)</param>
        /// <param name="alignmentTimezone">The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)</param>
        /// <param name="weeklyAlignment">The day of the week used for granularities that have weekly alignment. (optional)</param>
        /// <returns>Task of InlineResponse20029</returns>
        public async System.Threading.Tasks.Task<InlineResponse20029> GetInstrumentCandlesAsync (string authorization, string instrument, string acceptDatetimeFormat = null, string price = null, string granularity = null, int? count = null, string from = null, string to = null, bool? smooth = null, bool? includeFirst = null, int? dailyAlignment = null, string alignmentTimezone = null, string weeklyAlignment = null)
        {
             ApiResponse<InlineResponse20029> localVarResponse = await GetInstrumentCandlesAsyncWithHttpInfo(authorization, instrument, acceptDatetimeFormat, price, granularity, count, from, to, smooth, includeFirst, dailyAlignment, alignmentTimezone, weeklyAlignment);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get Candlesticks Fetch candlestick data for an instrument.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="price">The Price component(s) to get candlestick data for. Can contain any combination of the characters \&quot;M\&quot; (midpoint candles) \&quot;B\&quot; (bid candles) and \&quot;A\&quot; (ask candles). (optional)</param>
        /// <param name="granularity">The granularity of the candlesticks to fetch (optional)</param>
        /// <param name="count">The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)</param>
        /// <param name="from">The start of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="to">The end of the time range to fetch candlesticks for. (optional)</param>
        /// <param name="smooth">A flag that controls whether the candlestick is \&quot;smoothed\&quot; or not.  A smoothed candlestick uses the previous candle&#39;s close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)</param>
        /// <param name="includeFirst">A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)</param>
        /// <param name="dailyAlignment">The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)</param>
        /// <param name="alignmentTimezone">The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)</param>
        /// <param name="weeklyAlignment">The day of the week used for granularities that have weekly alignment. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20029)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20029>> GetInstrumentCandlesAsyncWithHttpInfo (string authorization, string instrument, string acceptDatetimeFormat = null, string price = null, string granularity = null, int? count = null, string from = null, string to = null, bool? smooth = null, bool? includeFirst = null, int? dailyAlignment = null, string alignmentTimezone = null, string weeklyAlignment = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetInstrumentCandles");
            // verify the required parameter 'instrument' is set
            if (instrument == null)
                throw new ApiException(400, "Missing required parameter 'instrument' when calling DefaultApi->GetInstrumentCandles");

            var localVarPath = "/instruments/{instrument}/candles";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (instrument != null) localVarPathParams.Add("instrument", Configuration.ApiClient.ParameterToString(instrument)); // path parameter
            if (price != null) localVarQueryParams.Add("price", Configuration.ApiClient.ParameterToString(price)); // query parameter
            if (granularity != null) localVarQueryParams.Add("granularity", Configuration.ApiClient.ParameterToString(granularity)); // query parameter
            if (count != null) localVarQueryParams.Add("count", Configuration.ApiClient.ParameterToString(count)); // query parameter
            if (from != null) localVarQueryParams.Add("from", Configuration.ApiClient.ParameterToString(from)); // query parameter
            if (to != null) localVarQueryParams.Add("to", Configuration.ApiClient.ParameterToString(to)); // query parameter
            if (smooth != null) localVarQueryParams.Add("smooth", Configuration.ApiClient.ParameterToString(smooth)); // query parameter
            if (includeFirst != null) localVarQueryParams.Add("includeFirst", Configuration.ApiClient.ParameterToString(includeFirst)); // query parameter
            if (dailyAlignment != null) localVarQueryParams.Add("dailyAlignment", Configuration.ApiClient.ParameterToString(dailyAlignment)); // query parameter
            if (alignmentTimezone != null) localVarQueryParams.Add("alignmentTimezone", Configuration.ApiClient.ParameterToString(alignmentTimezone)); // query parameter
            if (weeklyAlignment != null) localVarQueryParams.Add("weeklyAlignment", Configuration.ApiClient.ParameterToString(weeklyAlignment)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetInstrumentCandles", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20029>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20029) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20029)));
            
        }

        /// <summary>
        /// Get Order Get details for a single Order in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse2008</returns>
        public InlineResponse2008 GetOrder (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse2008> localVarResponse = GetOrderWithHttpInfo(authorization, accountID, orderSpecifier, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get Order Get details for a single Order in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2008</returns>
        public ApiResponse< InlineResponse2008 > GetOrderWithHttpInfo (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetOrder");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetOrder");
            // verify the required parameter 'orderSpecifier' is set
            if (orderSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'orderSpecifier' when calling DefaultApi->GetOrder");

            var localVarPath = "/accounts/{accountID}/orders/{orderSpecifier}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (orderSpecifier != null) localVarPathParams.Add("orderSpecifier", Configuration.ApiClient.ParameterToString(orderSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetOrder", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2008>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2008) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2008)));
            
        }

        /// <summary>
        /// Get Order Get details for a single Order in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse2008</returns>
        public async System.Threading.Tasks.Task<InlineResponse2008> GetOrderAsync (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse2008> localVarResponse = await GetOrderAsyncWithHttpInfo(authorization, accountID, orderSpecifier, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get Order Get details for a single Order in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2008)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse2008>> GetOrderAsyncWithHttpInfo (string authorization, string accountID, string orderSpecifier, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetOrder");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetOrder");
            // verify the required parameter 'orderSpecifier' is set
            if (orderSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'orderSpecifier' when calling DefaultApi->GetOrder");

            var localVarPath = "/accounts/{accountID}/orders/{orderSpecifier}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (orderSpecifier != null) localVarPathParams.Add("orderSpecifier", Configuration.ApiClient.ParameterToString(orderSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetOrder", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2008>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2008) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2008)));
            
        }

        /// <summary>
        /// Instrument Position Get the details of a single Instrument&#39;s Position in an Account. The Position may by open or not.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <returns>InlineResponse20013</returns>
        public InlineResponse20013 GetPosition (string authorization, string accountID, string instrument)
        {
             ApiResponse<InlineResponse20013> localVarResponse = GetPositionWithHttpInfo(authorization, accountID, instrument);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Instrument Position Get the details of a single Instrument&#39;s Position in an Account. The Position may by open or not.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <returns>ApiResponse of InlineResponse20013</returns>
        public ApiResponse< InlineResponse20013 > GetPositionWithHttpInfo (string authorization, string accountID, string instrument)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetPosition");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetPosition");
            // verify the required parameter 'instrument' is set
            if (instrument == null)
                throw new ApiException(400, "Missing required parameter 'instrument' when calling DefaultApi->GetPosition");

            var localVarPath = "/accounts/{accountID}/positions/{instrument}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (instrument != null) localVarPathParams.Add("instrument", Configuration.ApiClient.ParameterToString(instrument)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetPosition", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20013>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20013) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20013)));
            
        }

        /// <summary>
        /// Instrument Position Get the details of a single Instrument&#39;s Position in an Account. The Position may by open or not.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <returns>Task of InlineResponse20013</returns>
        public async System.Threading.Tasks.Task<InlineResponse20013> GetPositionAsync (string authorization, string accountID, string instrument)
        {
             ApiResponse<InlineResponse20013> localVarResponse = await GetPositionAsyncWithHttpInfo(authorization, accountID, instrument);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Instrument Position Get the details of a single Instrument&#39;s Position in an Account. The Position may by open or not.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instrument">Name of the Instrument</param>
        /// <returns>Task of ApiResponse (InlineResponse20013)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20013>> GetPositionAsyncWithHttpInfo (string authorization, string accountID, string instrument)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetPosition");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetPosition");
            // verify the required parameter 'instrument' is set
            if (instrument == null)
                throw new ApiException(400, "Missing required parameter 'instrument' when calling DefaultApi->GetPosition");

            var localVarPath = "/accounts/{accountID}/positions/{instrument}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (instrument != null) localVarPathParams.Add("instrument", Configuration.ApiClient.ParameterToString(instrument)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetPosition", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20013>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20013) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20013)));
            
        }

        /// <summary>
        /// Current Account Prices Get pricing information for a specified list of Instruments within an Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to get pricing for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="since">Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)</param>
        /// <param name="includeUnitsAvailable">Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)</param>
        /// <returns>InlineResponse20021</returns>
        public InlineResponse20021 GetPrices (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, string since = null, bool? includeUnitsAvailable = null)
        {
             ApiResponse<InlineResponse20021> localVarResponse = GetPricesWithHttpInfo(authorization, accountID, instruments, acceptDatetimeFormat, since, includeUnitsAvailable);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Current Account Prices Get pricing information for a specified list of Instruments within an Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to get pricing for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="since">Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)</param>
        /// <param name="includeUnitsAvailable">Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20021</returns>
        public ApiResponse< InlineResponse20021 > GetPricesWithHttpInfo (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, string since = null, bool? includeUnitsAvailable = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetPrices");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetPrices");
            // verify the required parameter 'instruments' is set
            if (instruments == null)
                throw new ApiException(400, "Missing required parameter 'instruments' when calling DefaultApi->GetPrices");

            var localVarPath = "/accounts/{accountID}/pricing";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (instruments != null) localVarQueryParams.Add("instruments", Configuration.ApiClient.ParameterToString(instruments)); // query parameter
            if (since != null) localVarQueryParams.Add("since", Configuration.ApiClient.ParameterToString(since)); // query parameter
            if (includeUnitsAvailable != null) localVarQueryParams.Add("includeUnitsAvailable", Configuration.ApiClient.ParameterToString(includeUnitsAvailable)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetPrices", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20021>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20021) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20021)));
            
        }

        /// <summary>
        /// Current Account Prices Get pricing information for a specified list of Instruments within an Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to get pricing for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="since">Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)</param>
        /// <param name="includeUnitsAvailable">Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)</param>
        /// <returns>Task of InlineResponse20021</returns>
        public async System.Threading.Tasks.Task<InlineResponse20021> GetPricesAsync (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, string since = null, bool? includeUnitsAvailable = null)
        {
             ApiResponse<InlineResponse20021> localVarResponse = await GetPricesAsyncWithHttpInfo(authorization, accountID, instruments, acceptDatetimeFormat, since, includeUnitsAvailable);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Current Account Prices Get pricing information for a specified list of Instruments within an Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to get pricing for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="since">Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)</param>
        /// <param name="includeUnitsAvailable">Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20021)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20021>> GetPricesAsyncWithHttpInfo (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, string since = null, bool? includeUnitsAvailable = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetPrices");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetPrices");
            // verify the required parameter 'instruments' is set
            if (instruments == null)
                throw new ApiException(400, "Missing required parameter 'instruments' when calling DefaultApi->GetPrices");

            var localVarPath = "/accounts/{accountID}/pricing";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (instruments != null) localVarQueryParams.Add("instruments", Configuration.ApiClient.ParameterToString(instruments)); // query parameter
            if (since != null) localVarQueryParams.Add("since", Configuration.ApiClient.ParameterToString(since)); // query parameter
            if (includeUnitsAvailable != null) localVarQueryParams.Add("includeUnitsAvailable", Configuration.ApiClient.ParameterToString(includeUnitsAvailable)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetPrices", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20021>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20021) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20021)));
            
        }

        /// <summary>
        /// Trade Details Get the details of a specific Trade in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20025</returns>
        public InlineResponse20025 GetTrade (string authorization, string accountID, string tradeSpecifier, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20025> localVarResponse = GetTradeWithHttpInfo(authorization, accountID, tradeSpecifier, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Trade Details Get the details of a specific Trade in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20025</returns>
        public ApiResponse< InlineResponse20025 > GetTradeWithHttpInfo (string authorization, string accountID, string tradeSpecifier, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetTrade");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetTrade");
            // verify the required parameter 'tradeSpecifier' is set
            if (tradeSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'tradeSpecifier' when calling DefaultApi->GetTrade");

            var localVarPath = "/accounts/{accountID}/trades/{tradeSpecifier}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (tradeSpecifier != null) localVarPathParams.Add("tradeSpecifier", Configuration.ApiClient.ParameterToString(tradeSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetTrade", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20025>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20025) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20025)));
            
        }

        /// <summary>
        /// Trade Details Get the details of a specific Trade in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20025</returns>
        public async System.Threading.Tasks.Task<InlineResponse20025> GetTradeAsync (string authorization, string accountID, string tradeSpecifier, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20025> localVarResponse = await GetTradeAsyncWithHttpInfo(authorization, accountID, tradeSpecifier, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Trade Details Get the details of a specific Trade in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20025)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20025>> GetTradeAsyncWithHttpInfo (string authorization, string accountID, string tradeSpecifier, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetTrade");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetTrade");
            // verify the required parameter 'tradeSpecifier' is set
            if (tradeSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'tradeSpecifier' when calling DefaultApi->GetTrade");

            var localVarPath = "/accounts/{accountID}/trades/{tradeSpecifier}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (tradeSpecifier != null) localVarPathParams.Add("tradeSpecifier", Configuration.ApiClient.ParameterToString(tradeSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetTrade", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20025>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20025) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20025)));
            
        }

        /// <summary>
        /// Transaction Details Get the details of a single Account Transaction.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="transactionID">A Transaction ID</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20018</returns>
        public InlineResponse20018 GetTransaction (string authorization, string accountID, string transactionID, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20018> localVarResponse = GetTransactionWithHttpInfo(authorization, accountID, transactionID, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Transaction Details Get the details of a single Account Transaction.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="transactionID">A Transaction ID</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20018</returns>
        public ApiResponse< InlineResponse20018 > GetTransactionWithHttpInfo (string authorization, string accountID, string transactionID, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetTransaction");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetTransaction");
            // verify the required parameter 'transactionID' is set
            if (transactionID == null)
                throw new ApiException(400, "Missing required parameter 'transactionID' when calling DefaultApi->GetTransaction");

            var localVarPath = "/accounts/{accountID}/transactions/{transactionID}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (transactionID != null) localVarPathParams.Add("transactionID", Configuration.ApiClient.ParameterToString(transactionID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetTransaction", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20018>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20018) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20018)));
            
        }

        /// <summary>
        /// Transaction Details Get the details of a single Account Transaction.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="transactionID">A Transaction ID</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20018</returns>
        public async System.Threading.Tasks.Task<InlineResponse20018> GetTransactionAsync (string authorization, string accountID, string transactionID, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20018> localVarResponse = await GetTransactionAsyncWithHttpInfo(authorization, accountID, transactionID, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Transaction Details Get the details of a single Account Transaction.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="transactionID">A Transaction ID</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20018)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20018>> GetTransactionAsyncWithHttpInfo (string authorization, string accountID, string transactionID, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetTransaction");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetTransaction");
            // verify the required parameter 'transactionID' is set
            if (transactionID == null)
                throw new ApiException(400, "Missing required parameter 'transactionID' when calling DefaultApi->GetTransaction");

            var localVarPath = "/accounts/{accountID}/transactions/{transactionID}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (transactionID != null) localVarPathParams.Add("transactionID", Configuration.ApiClient.ParameterToString(transactionID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetTransaction", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20018>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20018) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20018)));
            
        }

        /// <summary>
        /// Transaction ID Range Get a range of Transactions for an Account based on the Transaction IDs.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="from">The starting Transacion ID (inclusive) to fetch.</param>
        /// <param name="to">The ending Transaction ID (inclusive) to fetch.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="type">The filter that restricts the types of Transactions to retreive. (optional)</param>
        /// <returns>InlineResponse20019</returns>
        public InlineResponse20019 GetTransactionRange (string authorization, string accountID, string from, string to, string acceptDatetimeFormat = null, List<string> type = null)
        {
             ApiResponse<InlineResponse20019> localVarResponse = GetTransactionRangeWithHttpInfo(authorization, accountID, from, to, acceptDatetimeFormat, type);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Transaction ID Range Get a range of Transactions for an Account based on the Transaction IDs.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="from">The starting Transacion ID (inclusive) to fetch.</param>
        /// <param name="to">The ending Transaction ID (inclusive) to fetch.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="type">The filter that restricts the types of Transactions to retreive. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20019</returns>
        public ApiResponse< InlineResponse20019 > GetTransactionRangeWithHttpInfo (string authorization, string accountID, string from, string to, string acceptDatetimeFormat = null, List<string> type = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetTransactionRange");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetTransactionRange");
            // verify the required parameter 'from' is set
            if (from == null)
                throw new ApiException(400, "Missing required parameter 'from' when calling DefaultApi->GetTransactionRange");
            // verify the required parameter 'to' is set
            if (to == null)
                throw new ApiException(400, "Missing required parameter 'to' when calling DefaultApi->GetTransactionRange");

            var localVarPath = "/accounts/{accountID}/transactions/idrange";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (from != null) localVarQueryParams.Add("from", Configuration.ApiClient.ParameterToString(from)); // query parameter
            if (to != null) localVarQueryParams.Add("to", Configuration.ApiClient.ParameterToString(to)); // query parameter
            if (type != null) localVarQueryParams.Add("type", Configuration.ApiClient.ParameterToString(type)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetTransactionRange", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20019>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20019) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20019)));
            
        }

        /// <summary>
        /// Transaction ID Range Get a range of Transactions for an Account based on the Transaction IDs.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="from">The starting Transacion ID (inclusive) to fetch.</param>
        /// <param name="to">The ending Transaction ID (inclusive) to fetch.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="type">The filter that restricts the types of Transactions to retreive. (optional)</param>
        /// <returns>Task of InlineResponse20019</returns>
        public async System.Threading.Tasks.Task<InlineResponse20019> GetTransactionRangeAsync (string authorization, string accountID, string from, string to, string acceptDatetimeFormat = null, List<string> type = null)
        {
             ApiResponse<InlineResponse20019> localVarResponse = await GetTransactionRangeAsyncWithHttpInfo(authorization, accountID, from, to, acceptDatetimeFormat, type);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Transaction ID Range Get a range of Transactions for an Account based on the Transaction IDs.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="from">The starting Transacion ID (inclusive) to fetch.</param>
        /// <param name="to">The ending Transaction ID (inclusive) to fetch.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="type">The filter that restricts the types of Transactions to retreive. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20019)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20019>> GetTransactionRangeAsyncWithHttpInfo (string authorization, string accountID, string from, string to, string acceptDatetimeFormat = null, List<string> type = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetTransactionRange");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetTransactionRange");
            // verify the required parameter 'from' is set
            if (from == null)
                throw new ApiException(400, "Missing required parameter 'from' when calling DefaultApi->GetTransactionRange");
            // verify the required parameter 'to' is set
            if (to == null)
                throw new ApiException(400, "Missing required parameter 'to' when calling DefaultApi->GetTransactionRange");

            var localVarPath = "/accounts/{accountID}/transactions/idrange";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (from != null) localVarQueryParams.Add("from", Configuration.ApiClient.ParameterToString(from)); // query parameter
            if (to != null) localVarQueryParams.Add("to", Configuration.ApiClient.ParameterToString(to)); // query parameter
            if (type != null) localVarQueryParams.Add("type", Configuration.ApiClient.ParameterToString(type)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetTransactionRange", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20019>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20019) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20019)));
            
        }

        /// <summary>
        /// Transactions Since ID Get a range of Transactions for an Account starting at (but not including) a provided Transaction ID.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="id">The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20019</returns>
        public InlineResponse20019 GetTransactionsSinceId (string authorization, string accountID, string id, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20019> localVarResponse = GetTransactionsSinceIdWithHttpInfo(authorization, accountID, id, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Transactions Since ID Get a range of Transactions for an Account starting at (but not including) a provided Transaction ID.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="id">The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20019</returns>
        public ApiResponse< InlineResponse20019 > GetTransactionsSinceIdWithHttpInfo (string authorization, string accountID, string id, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetTransactionsSinceId");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetTransactionsSinceId");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling DefaultApi->GetTransactionsSinceId");

            var localVarPath = "/accounts/{accountID}/transactions/sinceid";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (id != null) localVarQueryParams.Add("id", Configuration.ApiClient.ParameterToString(id)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetTransactionsSinceId", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20019>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20019) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20019)));
            
        }

        /// <summary>
        /// Transactions Since ID Get a range of Transactions for an Account starting at (but not including) a provided Transaction ID.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="id">The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20019</returns>
        public async System.Threading.Tasks.Task<InlineResponse20019> GetTransactionsSinceIdAsync (string authorization, string accountID, string id, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20019> localVarResponse = await GetTransactionsSinceIdAsyncWithHttpInfo(authorization, accountID, id, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Transactions Since ID Get a range of Transactions for an Account starting at (but not including) a provided Transaction ID.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="id">The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20019)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20019>> GetTransactionsSinceIdAsyncWithHttpInfo (string authorization, string accountID, string id, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetTransactionsSinceId");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->GetTransactionsSinceId");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling DefaultApi->GetTransactionsSinceId");

            var localVarPath = "/accounts/{accountID}/transactions/sinceid";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (id != null) localVarQueryParams.Add("id", Configuration.ApiClient.ParameterToString(id)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetTransactionsSinceId", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20019>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20019) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20019)));
            
        }

        /// <summary>
        /// User Info Fetch the user information for the specified user. This endpoint is intended to be used by the user themself to obtain their own information.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>InlineResponse20015</returns>
        public InlineResponse20015 GetUserInfo (string authorization, string userSpecifier)
        {
             ApiResponse<InlineResponse20015> localVarResponse = GetUserInfoWithHttpInfo(authorization, userSpecifier);
             return localVarResponse.Data;
        }

        /// <summary>
        /// User Info Fetch the user information for the specified user. This endpoint is intended to be used by the user themself to obtain their own information.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>ApiResponse of InlineResponse20015</returns>
        public ApiResponse< InlineResponse20015 > GetUserInfoWithHttpInfo (string authorization, string userSpecifier)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetUserInfo");
            // verify the required parameter 'userSpecifier' is set
            if (userSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'userSpecifier' when calling DefaultApi->GetUserInfo");

            var localVarPath = "/users/{userSpecifier}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (userSpecifier != null) localVarPathParams.Add("userSpecifier", Configuration.ApiClient.ParameterToString(userSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetUserInfo", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20015>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20015) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20015)));
            
        }

        /// <summary>
        /// User Info Fetch the user information for the specified user. This endpoint is intended to be used by the user themself to obtain their own information.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>Task of InlineResponse20015</returns>
        public async System.Threading.Tasks.Task<InlineResponse20015> GetUserInfoAsync (string authorization, string userSpecifier)
        {
             ApiResponse<InlineResponse20015> localVarResponse = await GetUserInfoAsyncWithHttpInfo(authorization, userSpecifier);
             return localVarResponse.Data;

        }

        /// <summary>
        /// User Info Fetch the user information for the specified user. This endpoint is intended to be used by the user themself to obtain their own information.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="userSpecifier">The User Specifier</param>
        /// <returns>Task of ApiResponse (InlineResponse20015)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20015>> GetUserInfoAsyncWithHttpInfo (string authorization, string userSpecifier)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->GetUserInfo");
            // verify the required parameter 'userSpecifier' is set
            if (userSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'userSpecifier' when calling DefaultApi->GetUserInfo");

            var localVarPath = "/users/{userSpecifier}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (userSpecifier != null) localVarPathParams.Add("userSpecifier", Configuration.ApiClient.ParameterToString(userSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("GetUserInfo", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20015>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20015) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20015)));
            
        }

        /// <summary>
        /// List Accounts Get a list of all Accounts authorized for the provided token.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <returns>InlineResponse200</returns>
        public InlineResponse200 ListAccounts (string authorization)
        {
             ApiResponse<InlineResponse200> localVarResponse = ListAccountsWithHttpInfo(authorization);
             return localVarResponse.Data;
        }

        /// <summary>
        /// List Accounts Get a list of all Accounts authorized for the provided token.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <returns>ApiResponse of InlineResponse200</returns>
        public ApiResponse< InlineResponse200 > ListAccountsWithHttpInfo (string authorization)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListAccounts");

            var localVarPath = "/accounts";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListAccounts", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse200>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse200) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse200)));
            
        }

        /// <summary>
        /// List Accounts Get a list of all Accounts authorized for the provided token.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <returns>Task of InlineResponse200</returns>
        public async System.Threading.Tasks.Task<InlineResponse200> ListAccountsAsync (string authorization)
        {
             ApiResponse<InlineResponse200> localVarResponse = await ListAccountsAsyncWithHttpInfo(authorization);
             return localVarResponse.Data;

        }

        /// <summary>
        /// List Accounts Get a list of all Accounts authorized for the provided token.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <returns>Task of ApiResponse (InlineResponse200)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse200>> ListAccountsAsyncWithHttpInfo (string authorization)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListAccounts");

            var localVarPath = "/accounts";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListAccounts", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse200>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse200) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse200)));
            
        }

        /// <summary>
        /// Open Positions List all open Positions for an Account. An open Position is a Position in an Account that currently has a Trade opened for it.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>InlineResponse20012</returns>
        public InlineResponse20012 ListOpenPositions (string authorization, string accountID)
        {
             ApiResponse<InlineResponse20012> localVarResponse = ListOpenPositionsWithHttpInfo(authorization, accountID);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Open Positions List all open Positions for an Account. An open Position is a Position in an Account that currently has a Trade opened for it.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>ApiResponse of InlineResponse20012</returns>
        public ApiResponse< InlineResponse20012 > ListOpenPositionsWithHttpInfo (string authorization, string accountID)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListOpenPositions");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListOpenPositions");

            var localVarPath = "/accounts/{accountID}/openPositions";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListOpenPositions", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20012>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20012) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20012)));
            
        }

        /// <summary>
        /// Open Positions List all open Positions for an Account. An open Position is a Position in an Account that currently has a Trade opened for it.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>Task of InlineResponse20012</returns>
        public async System.Threading.Tasks.Task<InlineResponse20012> ListOpenPositionsAsync (string authorization, string accountID)
        {
             ApiResponse<InlineResponse20012> localVarResponse = await ListOpenPositionsAsyncWithHttpInfo(authorization, accountID);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Open Positions List all open Positions for an Account. An open Position is a Position in an Account that currently has a Trade opened for it.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>Task of ApiResponse (InlineResponse20012)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20012>> ListOpenPositionsAsyncWithHttpInfo (string authorization, string accountID)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListOpenPositions");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListOpenPositions");

            var localVarPath = "/accounts/{accountID}/openPositions";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListOpenPositions", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20012>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20012) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20012)));
            
        }

        /// <summary>
        /// List Open Trades Get the list of open Trades for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20024</returns>
        public InlineResponse20024 ListOpenTrades (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20024> localVarResponse = ListOpenTradesWithHttpInfo(authorization, accountID, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// List Open Trades Get the list of open Trades for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20024</returns>
        public ApiResponse< InlineResponse20024 > ListOpenTradesWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListOpenTrades");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListOpenTrades");

            var localVarPath = "/accounts/{accountID}/openTrades";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListOpenTrades", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20024>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20024) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20024)));
            
        }

        /// <summary>
        /// List Open Trades Get the list of open Trades for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20024</returns>
        public async System.Threading.Tasks.Task<InlineResponse20024> ListOpenTradesAsync (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20024> localVarResponse = await ListOpenTradesAsyncWithHttpInfo(authorization, accountID, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// List Open Trades Get the list of open Trades for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20024)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20024>> ListOpenTradesAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListOpenTrades");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListOpenTrades");

            var localVarPath = "/accounts/{accountID}/openTrades";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListOpenTrades", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20024>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20024) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20024)));
            
        }

        /// <summary>
        /// List Orders Get a list of Orders for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Order IDs to retrieve (optional)</param>
        /// <param name="state">The state to filter the requested Orders by (optional)</param>
        /// <param name="instrument">The instrument to filter the requested orders by (optional)</param>
        /// <param name="count">The maximum number of Orders to return (optional)</param>
        /// <param name="beforeID">The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)</param>
        /// <returns>InlineResponse2006</returns>
        public InlineResponse2006 ListOrders (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null)
        {
             ApiResponse<InlineResponse2006> localVarResponse = ListOrdersWithHttpInfo(authorization, accountID, acceptDatetimeFormat, ids, state, instrument, count, beforeID);
             return localVarResponse.Data;
        }

        /// <summary>
        /// List Orders Get a list of Orders for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Order IDs to retrieve (optional)</param>
        /// <param name="state">The state to filter the requested Orders by (optional)</param>
        /// <param name="instrument">The instrument to filter the requested orders by (optional)</param>
        /// <param name="count">The maximum number of Orders to return (optional)</param>
        /// <param name="beforeID">The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)</param>
        /// <returns>ApiResponse of InlineResponse2006</returns>
        public ApiResponse< InlineResponse2006 > ListOrdersWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListOrders");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListOrders");

            var localVarPath = "/accounts/{accountID}/orders";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (ids != null) localVarQueryParams.Add("ids", Configuration.ApiClient.ParameterToString(ids)); // query parameter
            if (state != null) localVarQueryParams.Add("state", Configuration.ApiClient.ParameterToString(state)); // query parameter
            if (instrument != null) localVarQueryParams.Add("instrument", Configuration.ApiClient.ParameterToString(instrument)); // query parameter
            if (count != null) localVarQueryParams.Add("count", Configuration.ApiClient.ParameterToString(count)); // query parameter
            if (beforeID != null) localVarQueryParams.Add("beforeID", Configuration.ApiClient.ParameterToString(beforeID)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListOrders", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2006>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2006) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2006)));
            
        }

        /// <summary>
        /// List Orders Get a list of Orders for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Order IDs to retrieve (optional)</param>
        /// <param name="state">The state to filter the requested Orders by (optional)</param>
        /// <param name="instrument">The instrument to filter the requested orders by (optional)</param>
        /// <param name="count">The maximum number of Orders to return (optional)</param>
        /// <param name="beforeID">The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)</param>
        /// <returns>Task of InlineResponse2006</returns>
        public async System.Threading.Tasks.Task<InlineResponse2006> ListOrdersAsync (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null)
        {
             ApiResponse<InlineResponse2006> localVarResponse = await ListOrdersAsyncWithHttpInfo(authorization, accountID, acceptDatetimeFormat, ids, state, instrument, count, beforeID);
             return localVarResponse.Data;

        }

        /// <summary>
        /// List Orders Get a list of Orders for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Order IDs to retrieve (optional)</param>
        /// <param name="state">The state to filter the requested Orders by (optional)</param>
        /// <param name="instrument">The instrument to filter the requested orders by (optional)</param>
        /// <param name="count">The maximum number of Orders to return (optional)</param>
        /// <param name="beforeID">The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2006)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse2006>> ListOrdersAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListOrders");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListOrders");

            var localVarPath = "/accounts/{accountID}/orders";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (ids != null) localVarQueryParams.Add("ids", Configuration.ApiClient.ParameterToString(ids)); // query parameter
            if (state != null) localVarQueryParams.Add("state", Configuration.ApiClient.ParameterToString(state)); // query parameter
            if (instrument != null) localVarQueryParams.Add("instrument", Configuration.ApiClient.ParameterToString(instrument)); // query parameter
            if (count != null) localVarQueryParams.Add("count", Configuration.ApiClient.ParameterToString(count)); // query parameter
            if (beforeID != null) localVarQueryParams.Add("beforeID", Configuration.ApiClient.ParameterToString(beforeID)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListOrders", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2006>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2006) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2006)));
            
        }

        /// <summary>
        /// Pending Orders List all pending Orders in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse2007</returns>
        public InlineResponse2007 ListPendingOrders (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse2007> localVarResponse = ListPendingOrdersWithHttpInfo(authorization, accountID, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Pending Orders List all pending Orders in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2007</returns>
        public ApiResponse< InlineResponse2007 > ListPendingOrdersWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListPendingOrders");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListPendingOrders");

            var localVarPath = "/accounts/{accountID}/pendingOrders";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListPendingOrders", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2007>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2007) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2007)));
            
        }

        /// <summary>
        /// Pending Orders List all pending Orders in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse2007</returns>
        public async System.Threading.Tasks.Task<InlineResponse2007> ListPendingOrdersAsync (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse2007> localVarResponse = await ListPendingOrdersAsyncWithHttpInfo(authorization, accountID, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Pending Orders List all pending Orders in an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2007)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse2007>> ListPendingOrdersAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListPendingOrders");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListPendingOrders");

            var localVarPath = "/accounts/{accountID}/pendingOrders";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListPendingOrders", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2007>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2007) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2007)));
            
        }

        /// <summary>
        /// List Positions List all Positions for an Account. The Positions returned are for every instrument that has had a position during the lifetime of an the Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>InlineResponse20011</returns>
        public InlineResponse20011 ListPositions (string authorization, string accountID)
        {
             ApiResponse<InlineResponse20011> localVarResponse = ListPositionsWithHttpInfo(authorization, accountID);
             return localVarResponse.Data;
        }

        /// <summary>
        /// List Positions List all Positions for an Account. The Positions returned are for every instrument that has had a position during the lifetime of an the Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>ApiResponse of InlineResponse20011</returns>
        public ApiResponse< InlineResponse20011 > ListPositionsWithHttpInfo (string authorization, string accountID)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListPositions");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListPositions");

            var localVarPath = "/accounts/{accountID}/positions";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListPositions", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20011>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20011) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20011)));
            
        }

        /// <summary>
        /// List Positions List all Positions for an Account. The Positions returned are for every instrument that has had a position during the lifetime of an the Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>Task of InlineResponse20011</returns>
        public async System.Threading.Tasks.Task<InlineResponse20011> ListPositionsAsync (string authorization, string accountID)
        {
             ApiResponse<InlineResponse20011> localVarResponse = await ListPositionsAsyncWithHttpInfo(authorization, accountID);
             return localVarResponse.Data;

        }

        /// <summary>
        /// List Positions List all Positions for an Account. The Positions returned are for every instrument that has had a position during the lifetime of an the Account.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>Task of ApiResponse (InlineResponse20011)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20011>> ListPositionsAsyncWithHttpInfo (string authorization, string accountID)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListPositions");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListPositions");

            var localVarPath = "/accounts/{accountID}/positions";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListPositions", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20011>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20011) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20011)));
            
        }

        /// <summary>
        /// List Trades Get a list of Trades for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Trade IDs to retrieve. (optional)</param>
        /// <param name="state">The state to filter the requested Trades by. (optional)</param>
        /// <param name="instrument">The instrument to filter the requested Trades by. (optional)</param>
        /// <param name="count">The maximum number of Trades to return. (optional)</param>
        /// <param name="beforeID">The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)</param>
        /// <returns>InlineResponse20023</returns>
        public InlineResponse20023 ListTrades (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null)
        {
             ApiResponse<InlineResponse20023> localVarResponse = ListTradesWithHttpInfo(authorization, accountID, acceptDatetimeFormat, ids, state, instrument, count, beforeID);
             return localVarResponse.Data;
        }

        /// <summary>
        /// List Trades Get a list of Trades for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Trade IDs to retrieve. (optional)</param>
        /// <param name="state">The state to filter the requested Trades by. (optional)</param>
        /// <param name="instrument">The instrument to filter the requested Trades by. (optional)</param>
        /// <param name="count">The maximum number of Trades to return. (optional)</param>
        /// <param name="beforeID">The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20023</returns>
        public ApiResponse< InlineResponse20023 > ListTradesWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListTrades");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListTrades");

            var localVarPath = "/accounts/{accountID}/trades";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (ids != null) localVarQueryParams.Add("ids", Configuration.ApiClient.ParameterToString(ids)); // query parameter
            if (state != null) localVarQueryParams.Add("state", Configuration.ApiClient.ParameterToString(state)); // query parameter
            if (instrument != null) localVarQueryParams.Add("instrument", Configuration.ApiClient.ParameterToString(instrument)); // query parameter
            if (count != null) localVarQueryParams.Add("count", Configuration.ApiClient.ParameterToString(count)); // query parameter
            if (beforeID != null) localVarQueryParams.Add("beforeID", Configuration.ApiClient.ParameterToString(beforeID)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListTrades", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20023>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20023) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20023)));
            
        }

        /// <summary>
        /// List Trades Get a list of Trades for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Trade IDs to retrieve. (optional)</param>
        /// <param name="state">The state to filter the requested Trades by. (optional)</param>
        /// <param name="instrument">The instrument to filter the requested Trades by. (optional)</param>
        /// <param name="count">The maximum number of Trades to return. (optional)</param>
        /// <param name="beforeID">The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)</param>
        /// <returns>Task of InlineResponse20023</returns>
        public async System.Threading.Tasks.Task<InlineResponse20023> ListTradesAsync (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null)
        {
             ApiResponse<InlineResponse20023> localVarResponse = await ListTradesAsyncWithHttpInfo(authorization, accountID, acceptDatetimeFormat, ids, state, instrument, count, beforeID);
             return localVarResponse.Data;

        }

        /// <summary>
        /// List Trades Get a list of Trades for an Account
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="ids">List of Trade IDs to retrieve. (optional)</param>
        /// <param name="state">The state to filter the requested Trades by. (optional)</param>
        /// <param name="instrument">The instrument to filter the requested Trades by. (optional)</param>
        /// <param name="count">The maximum number of Trades to return. (optional)</param>
        /// <param name="beforeID">The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20023)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20023>> ListTradesAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, List<string> ids = null, string state = null, string instrument = null, int? count = null, string beforeID = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListTrades");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListTrades");

            var localVarPath = "/accounts/{accountID}/trades";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (ids != null) localVarQueryParams.Add("ids", Configuration.ApiClient.ParameterToString(ids)); // query parameter
            if (state != null) localVarQueryParams.Add("state", Configuration.ApiClient.ParameterToString(state)); // query parameter
            if (instrument != null) localVarQueryParams.Add("instrument", Configuration.ApiClient.ParameterToString(instrument)); // query parameter
            if (count != null) localVarQueryParams.Add("count", Configuration.ApiClient.ParameterToString(count)); // query parameter
            if (beforeID != null) localVarQueryParams.Add("beforeID", Configuration.ApiClient.ParameterToString(beforeID)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListTrades", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20023>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20023) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20023)));
            
        }

        /// <summary>
        /// List Transactions Get a list of Transactions pages that satisfy a time-based Transaction query.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="from">The starting time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="to">The ending time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="pageSize">The number of Transactions to include in each page of the results. (optional)</param>
        /// <param name="type">A filter for restricting the types of Transactions to retreive. (optional)</param>
        /// <returns>InlineResponse20017</returns>
        public InlineResponse20017 ListTransactions (string authorization, string accountID, string acceptDatetimeFormat = null, string from = null, string to = null, int? pageSize = null, List<string> type = null)
        {
             ApiResponse<InlineResponse20017> localVarResponse = ListTransactionsWithHttpInfo(authorization, accountID, acceptDatetimeFormat, from, to, pageSize, type);
             return localVarResponse.Data;
        }

        /// <summary>
        /// List Transactions Get a list of Transactions pages that satisfy a time-based Transaction query.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="from">The starting time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="to">The ending time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="pageSize">The number of Transactions to include in each page of the results. (optional)</param>
        /// <param name="type">A filter for restricting the types of Transactions to retreive. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20017</returns>
        public ApiResponse< InlineResponse20017 > ListTransactionsWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, string from = null, string to = null, int? pageSize = null, List<string> type = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListTransactions");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListTransactions");

            var localVarPath = "/accounts/{accountID}/transactions";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (from != null) localVarQueryParams.Add("from", Configuration.ApiClient.ParameterToString(from)); // query parameter
            if (to != null) localVarQueryParams.Add("to", Configuration.ApiClient.ParameterToString(to)); // query parameter
            if (pageSize != null) localVarQueryParams.Add("pageSize", Configuration.ApiClient.ParameterToString(pageSize)); // query parameter
            if (type != null) localVarQueryParams.Add("type", Configuration.ApiClient.ParameterToString(type)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListTransactions", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20017>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20017) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20017)));
            
        }

        /// <summary>
        /// List Transactions Get a list of Transactions pages that satisfy a time-based Transaction query.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="from">The starting time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="to">The ending time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="pageSize">The number of Transactions to include in each page of the results. (optional)</param>
        /// <param name="type">A filter for restricting the types of Transactions to retreive. (optional)</param>
        /// <returns>Task of InlineResponse20017</returns>
        public async System.Threading.Tasks.Task<InlineResponse20017> ListTransactionsAsync (string authorization, string accountID, string acceptDatetimeFormat = null, string from = null, string to = null, int? pageSize = null, List<string> type = null)
        {
             ApiResponse<InlineResponse20017> localVarResponse = await ListTransactionsAsyncWithHttpInfo(authorization, accountID, acceptDatetimeFormat, from, to, pageSize, type);
             return localVarResponse.Data;

        }

        /// <summary>
        /// List Transactions Get a list of Transactions pages that satisfy a time-based Transaction query.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="from">The starting time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="to">The ending time (inclusive) of the time range for the Transactions being queried. (optional)</param>
        /// <param name="pageSize">The number of Transactions to include in each page of the results. (optional)</param>
        /// <param name="type">A filter for restricting the types of Transactions to retreive. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20017)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20017>> ListTransactionsAsyncWithHttpInfo (string authorization, string accountID, string acceptDatetimeFormat = null, string from = null, string to = null, int? pageSize = null, List<string> type = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ListTransactions");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ListTransactions");

            var localVarPath = "/accounts/{accountID}/transactions";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (from != null) localVarQueryParams.Add("from", Configuration.ApiClient.ParameterToString(from)); // query parameter
            if (to != null) localVarQueryParams.Add("to", Configuration.ApiClient.ParameterToString(to)); // query parameter
            if (pageSize != null) localVarQueryParams.Add("pageSize", Configuration.ApiClient.ParameterToString(pageSize)); // query parameter
            if (type != null) localVarQueryParams.Add("type", Configuration.ApiClient.ParameterToString(type)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ListTransactions", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20017>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20017) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20017)));
            
        }

        /// <summary>
        /// Replace Order Replace an Order in an Account by simultaneously cancelling it and creating a replacement Order
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="replaceOrderBody">Specification of the replacing Order. The replacing order must have the same type as the replaced Order.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse2011</returns>
        public InlineResponse2011 ReplaceOrder (string authorization, string accountID, string orderSpecifier, ReplaceOrderBody replaceOrderBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse2011> localVarResponse = ReplaceOrderWithHttpInfo(authorization, accountID, orderSpecifier, replaceOrderBody, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Replace Order Replace an Order in an Account by simultaneously cancelling it and creating a replacement Order
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="replaceOrderBody">Specification of the replacing Order. The replacing order must have the same type as the replaced Order.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse2011</returns>
        public ApiResponse< InlineResponse2011 > ReplaceOrderWithHttpInfo (string authorization, string accountID, string orderSpecifier, ReplaceOrderBody replaceOrderBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ReplaceOrder");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ReplaceOrder");
            // verify the required parameter 'orderSpecifier' is set
            if (orderSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'orderSpecifier' when calling DefaultApi->ReplaceOrder");
            // verify the required parameter 'replaceOrderBody' is set
            if (replaceOrderBody == null)
                throw new ApiException(400, "Missing required parameter 'replaceOrderBody' when calling DefaultApi->ReplaceOrder");

            var localVarPath = "/accounts/{accountID}/orders/{orderSpecifier}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (orderSpecifier != null) localVarPathParams.Add("orderSpecifier", Configuration.ApiClient.ParameterToString(orderSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (replaceOrderBody != null && replaceOrderBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(replaceOrderBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = replaceOrderBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ReplaceOrder", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2011>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2011) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2011)));
            
        }

        /// <summary>
        /// Replace Order Replace an Order in an Account by simultaneously cancelling it and creating a replacement Order
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="replaceOrderBody">Specification of the replacing Order. The replacing order must have the same type as the replaced Order.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse2011</returns>
        public async System.Threading.Tasks.Task<InlineResponse2011> ReplaceOrderAsync (string authorization, string accountID, string orderSpecifier, ReplaceOrderBody replaceOrderBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse2011> localVarResponse = await ReplaceOrderAsyncWithHttpInfo(authorization, accountID, orderSpecifier, replaceOrderBody, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Replace Order Replace an Order in an Account by simultaneously cancelling it and creating a replacement Order
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="replaceOrderBody">Specification of the replacing Order. The replacing order must have the same type as the replaced Order.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse2011)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse2011>> ReplaceOrderAsyncWithHttpInfo (string authorization, string accountID, string orderSpecifier, ReplaceOrderBody replaceOrderBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->ReplaceOrder");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->ReplaceOrder");
            // verify the required parameter 'orderSpecifier' is set
            if (orderSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'orderSpecifier' when calling DefaultApi->ReplaceOrder");
            // verify the required parameter 'replaceOrderBody' is set
            if (replaceOrderBody == null)
                throw new ApiException(400, "Missing required parameter 'replaceOrderBody' when calling DefaultApi->ReplaceOrder");

            var localVarPath = "/accounts/{accountID}/orders/{orderSpecifier}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (orderSpecifier != null) localVarPathParams.Add("orderSpecifier", Configuration.ApiClient.ParameterToString(orderSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (replaceOrderBody != null && replaceOrderBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(replaceOrderBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = replaceOrderBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ReplaceOrder", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse2011>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse2011) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse2011)));
            
        }

        /// <summary>
        /// Set Order Extensions Update the Client Extensions for an Order in an Account. Do not set, modify, or delete clientExtensions if your account is associated with MT4.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="setOrderClientExtensionsBody">Representation of the replacing Order</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20010</returns>
        public InlineResponse20010 SetOrderClientExtensions (string authorization, string accountID, string orderSpecifier, SetOrderClientExtensionsBody setOrderClientExtensionsBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20010> localVarResponse = SetOrderClientExtensionsWithHttpInfo(authorization, accountID, orderSpecifier, setOrderClientExtensionsBody, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Set Order Extensions Update the Client Extensions for an Order in an Account. Do not set, modify, or delete clientExtensions if your account is associated with MT4.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="setOrderClientExtensionsBody">Representation of the replacing Order</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20010</returns>
        public ApiResponse< InlineResponse20010 > SetOrderClientExtensionsWithHttpInfo (string authorization, string accountID, string orderSpecifier, SetOrderClientExtensionsBody setOrderClientExtensionsBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->SetOrderClientExtensions");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->SetOrderClientExtensions");
            // verify the required parameter 'orderSpecifier' is set
            if (orderSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'orderSpecifier' when calling DefaultApi->SetOrderClientExtensions");
            // verify the required parameter 'setOrderClientExtensionsBody' is set
            if (setOrderClientExtensionsBody == null)
                throw new ApiException(400, "Missing required parameter 'setOrderClientExtensionsBody' when calling DefaultApi->SetOrderClientExtensions");

            var localVarPath = "/accounts/{accountID}/orders/{orderSpecifier}/clientExtensions";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (orderSpecifier != null) localVarPathParams.Add("orderSpecifier", Configuration.ApiClient.ParameterToString(orderSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (setOrderClientExtensionsBody != null && setOrderClientExtensionsBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(setOrderClientExtensionsBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = setOrderClientExtensionsBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("SetOrderClientExtensions", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20010>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20010) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20010)));
            
        }

        /// <summary>
        /// Set Order Extensions Update the Client Extensions for an Order in an Account. Do not set, modify, or delete clientExtensions if your account is associated with MT4.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="setOrderClientExtensionsBody">Representation of the replacing Order</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20010</returns>
        public async System.Threading.Tasks.Task<InlineResponse20010> SetOrderClientExtensionsAsync (string authorization, string accountID, string orderSpecifier, SetOrderClientExtensionsBody setOrderClientExtensionsBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20010> localVarResponse = await SetOrderClientExtensionsAsyncWithHttpInfo(authorization, accountID, orderSpecifier, setOrderClientExtensionsBody, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Set Order Extensions Update the Client Extensions for an Order in an Account. Do not set, modify, or delete clientExtensions if your account is associated with MT4.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="orderSpecifier">The Order Specifier</param>
        /// <param name="setOrderClientExtensionsBody">Representation of the replacing Order</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20010)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20010>> SetOrderClientExtensionsAsyncWithHttpInfo (string authorization, string accountID, string orderSpecifier, SetOrderClientExtensionsBody setOrderClientExtensionsBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->SetOrderClientExtensions");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->SetOrderClientExtensions");
            // verify the required parameter 'orderSpecifier' is set
            if (orderSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'orderSpecifier' when calling DefaultApi->SetOrderClientExtensions");
            // verify the required parameter 'setOrderClientExtensionsBody' is set
            if (setOrderClientExtensionsBody == null)
                throw new ApiException(400, "Missing required parameter 'setOrderClientExtensionsBody' when calling DefaultApi->SetOrderClientExtensions");

            var localVarPath = "/accounts/{accountID}/orders/{orderSpecifier}/clientExtensions";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (orderSpecifier != null) localVarPathParams.Add("orderSpecifier", Configuration.ApiClient.ParameterToString(orderSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (setOrderClientExtensionsBody != null && setOrderClientExtensionsBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(setOrderClientExtensionsBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = setOrderClientExtensionsBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("SetOrderClientExtensions", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20010>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20010) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20010)));
            
        }

        /// <summary>
        /// Set Trade Client Extensions Update the Client Extensions for a Trade. Do not add, update, or delete the Client Extensions if your account is associated with MT4.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeClientExtensionsBody">Details of how to modify the Trade&#39;s Client Extensions.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20027</returns>
        public InlineResponse20027 SetTradeClientExtensions (string authorization, string accountID, string tradeSpecifier, SetTradeClientExtensionsBody setTradeClientExtensionsBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20027> localVarResponse = SetTradeClientExtensionsWithHttpInfo(authorization, accountID, tradeSpecifier, setTradeClientExtensionsBody, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Set Trade Client Extensions Update the Client Extensions for a Trade. Do not add, update, or delete the Client Extensions if your account is associated with MT4.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeClientExtensionsBody">Details of how to modify the Trade&#39;s Client Extensions.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20027</returns>
        public ApiResponse< InlineResponse20027 > SetTradeClientExtensionsWithHttpInfo (string authorization, string accountID, string tradeSpecifier, SetTradeClientExtensionsBody setTradeClientExtensionsBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->SetTradeClientExtensions");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->SetTradeClientExtensions");
            // verify the required parameter 'tradeSpecifier' is set
            if (tradeSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'tradeSpecifier' when calling DefaultApi->SetTradeClientExtensions");
            // verify the required parameter 'setTradeClientExtensionsBody' is set
            if (setTradeClientExtensionsBody == null)
                throw new ApiException(400, "Missing required parameter 'setTradeClientExtensionsBody' when calling DefaultApi->SetTradeClientExtensions");

            var localVarPath = "/accounts/{accountID}/trades/{tradeSpecifier}/clientExtensions";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (tradeSpecifier != null) localVarPathParams.Add("tradeSpecifier", Configuration.ApiClient.ParameterToString(tradeSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (setTradeClientExtensionsBody != null && setTradeClientExtensionsBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(setTradeClientExtensionsBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = setTradeClientExtensionsBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("SetTradeClientExtensions", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20027>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20027) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20027)));
            
        }

        /// <summary>
        /// Set Trade Client Extensions Update the Client Extensions for a Trade. Do not add, update, or delete the Client Extensions if your account is associated with MT4.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeClientExtensionsBody">Details of how to modify the Trade&#39;s Client Extensions.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20027</returns>
        public async System.Threading.Tasks.Task<InlineResponse20027> SetTradeClientExtensionsAsync (string authorization, string accountID, string tradeSpecifier, SetTradeClientExtensionsBody setTradeClientExtensionsBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20027> localVarResponse = await SetTradeClientExtensionsAsyncWithHttpInfo(authorization, accountID, tradeSpecifier, setTradeClientExtensionsBody, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Set Trade Client Extensions Update the Client Extensions for a Trade. Do not add, update, or delete the Client Extensions if your account is associated with MT4.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeClientExtensionsBody">Details of how to modify the Trade&#39;s Client Extensions.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20027)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20027>> SetTradeClientExtensionsAsyncWithHttpInfo (string authorization, string accountID, string tradeSpecifier, SetTradeClientExtensionsBody setTradeClientExtensionsBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->SetTradeClientExtensions");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->SetTradeClientExtensions");
            // verify the required parameter 'tradeSpecifier' is set
            if (tradeSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'tradeSpecifier' when calling DefaultApi->SetTradeClientExtensions");
            // verify the required parameter 'setTradeClientExtensionsBody' is set
            if (setTradeClientExtensionsBody == null)
                throw new ApiException(400, "Missing required parameter 'setTradeClientExtensionsBody' when calling DefaultApi->SetTradeClientExtensions");

            var localVarPath = "/accounts/{accountID}/trades/{tradeSpecifier}/clientExtensions";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (tradeSpecifier != null) localVarPathParams.Add("tradeSpecifier", Configuration.ApiClient.ParameterToString(tradeSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (setTradeClientExtensionsBody != null && setTradeClientExtensionsBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(setTradeClientExtensionsBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = setTradeClientExtensionsBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("SetTradeClientExtensions", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20027>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20027) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20027)));
            
        }

        /// <summary>
        /// Set Dependent Orders Create, replace and cancel a Trade&#39;s dependent Orders (Take Profit, Stop Loss and Trailing Stop Loss) through the Trade itself
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeDependentOrdersBody">Details of how to modify the Trade&#39;s dependent Orders.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>InlineResponse20028</returns>
        public InlineResponse20028 SetTradeDependentOrders (string authorization, string accountID, string tradeSpecifier, SetTradeDependentOrdersBody setTradeDependentOrdersBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20028> localVarResponse = SetTradeDependentOrdersWithHttpInfo(authorization, accountID, tradeSpecifier, setTradeDependentOrdersBody, acceptDatetimeFormat);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Set Dependent Orders Create, replace and cancel a Trade&#39;s dependent Orders (Take Profit, Stop Loss and Trailing Stop Loss) through the Trade itself
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeDependentOrdersBody">Details of how to modify the Trade&#39;s dependent Orders.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20028</returns>
        public ApiResponse< InlineResponse20028 > SetTradeDependentOrdersWithHttpInfo (string authorization, string accountID, string tradeSpecifier, SetTradeDependentOrdersBody setTradeDependentOrdersBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->SetTradeDependentOrders");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->SetTradeDependentOrders");
            // verify the required parameter 'tradeSpecifier' is set
            if (tradeSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'tradeSpecifier' when calling DefaultApi->SetTradeDependentOrders");
            // verify the required parameter 'setTradeDependentOrdersBody' is set
            if (setTradeDependentOrdersBody == null)
                throw new ApiException(400, "Missing required parameter 'setTradeDependentOrdersBody' when calling DefaultApi->SetTradeDependentOrders");

            var localVarPath = "/accounts/{accountID}/trades/{tradeSpecifier}/orders";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (tradeSpecifier != null) localVarPathParams.Add("tradeSpecifier", Configuration.ApiClient.ParameterToString(tradeSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (setTradeDependentOrdersBody != null && setTradeDependentOrdersBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(setTradeDependentOrdersBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = setTradeDependentOrdersBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("SetTradeDependentOrders", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20028>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20028) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20028)));
            
        }

        /// <summary>
        /// Set Dependent Orders Create, replace and cancel a Trade&#39;s dependent Orders (Take Profit, Stop Loss and Trailing Stop Loss) through the Trade itself
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeDependentOrdersBody">Details of how to modify the Trade&#39;s dependent Orders.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of InlineResponse20028</returns>
        public async System.Threading.Tasks.Task<InlineResponse20028> SetTradeDependentOrdersAsync (string authorization, string accountID, string tradeSpecifier, SetTradeDependentOrdersBody setTradeDependentOrdersBody, string acceptDatetimeFormat = null)
        {
             ApiResponse<InlineResponse20028> localVarResponse = await SetTradeDependentOrdersAsyncWithHttpInfo(authorization, accountID, tradeSpecifier, setTradeDependentOrdersBody, acceptDatetimeFormat);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Set Dependent Orders Create, replace and cancel a Trade&#39;s dependent Orders (Take Profit, Stop Loss and Trailing Stop Loss) through the Trade itself
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="tradeSpecifier">Specifier for the Trade</param>
        /// <param name="setTradeDependentOrdersBody">Details of how to modify the Trade&#39;s dependent Orders.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20028)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20028>> SetTradeDependentOrdersAsyncWithHttpInfo (string authorization, string accountID, string tradeSpecifier, SetTradeDependentOrdersBody setTradeDependentOrdersBody, string acceptDatetimeFormat = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->SetTradeDependentOrders");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->SetTradeDependentOrders");
            // verify the required parameter 'tradeSpecifier' is set
            if (tradeSpecifier == null)
                throw new ApiException(400, "Missing required parameter 'tradeSpecifier' when calling DefaultApi->SetTradeDependentOrders");
            // verify the required parameter 'setTradeDependentOrdersBody' is set
            if (setTradeDependentOrdersBody == null)
                throw new ApiException(400, "Missing required parameter 'setTradeDependentOrdersBody' when calling DefaultApi->SetTradeDependentOrders");

            var localVarPath = "/accounts/{accountID}/trades/{tradeSpecifier}/orders";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (tradeSpecifier != null) localVarPathParams.Add("tradeSpecifier", Configuration.ApiClient.ParameterToString(tradeSpecifier)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter
            if (setTradeDependentOrdersBody != null && setTradeDependentOrdersBody.GetType() != typeof(byte[]))
            {
                localVarPostBody = Configuration.ApiClient.Serialize(setTradeDependentOrdersBody); // http body (model) parameter
            }
            else
            {
                localVarPostBody = setTradeDependentOrdersBody; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.PUT, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("SetTradeDependentOrders", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20028>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20028) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20028)));
            
        }

        /// <summary>
        /// Price Stream Get a stream of Account Prices starting from when the request is made. This pricing stream does not include every single price created for the Account, but instead will provide at most 4 prices per second (every 250 milliseconds) for each instrument being requested. If more than one price is created for an instrument during the 250 millisecond window, only the price in effect at the end of the window is sent. This means that during periods of rapid price movement, subscribers to this stream will not be sent every price. Pricing windows for different connections to the price stream are not all aligned in the same way (i.e. they are not all aligned to the top of the second). This means that during periods of rapid price movement, different subscribers may observe different prices depending on their alignment.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to stream Prices for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="snapshot">Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)</param>
        /// <returns>InlineResponse20022</returns>
        public InlineResponse20022 StreamPricing (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, bool? snapshot = null)
        {
             ApiResponse<InlineResponse20022> localVarResponse = StreamPricingWithHttpInfo(authorization, accountID, instruments, acceptDatetimeFormat, snapshot);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Price Stream Get a stream of Account Prices starting from when the request is made. This pricing stream does not include every single price created for the Account, but instead will provide at most 4 prices per second (every 250 milliseconds) for each instrument being requested. If more than one price is created for an instrument during the 250 millisecond window, only the price in effect at the end of the window is sent. This means that during periods of rapid price movement, subscribers to this stream will not be sent every price. Pricing windows for different connections to the price stream are not all aligned in the same way (i.e. they are not all aligned to the top of the second). This means that during periods of rapid price movement, different subscribers may observe different prices depending on their alignment.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to stream Prices for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="snapshot">Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)</param>
        /// <returns>ApiResponse of InlineResponse20022</returns>
        public ApiResponse< InlineResponse20022 > StreamPricingWithHttpInfo (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, bool? snapshot = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->StreamPricing");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->StreamPricing");
            // verify the required parameter 'instruments' is set
            if (instruments == null)
                throw new ApiException(400, "Missing required parameter 'instruments' when calling DefaultApi->StreamPricing");

            var localVarPath = "/accounts/{accountID}/pricing/stream";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (instruments != null) localVarQueryParams.Add("instruments", Configuration.ApiClient.ParameterToString(instruments)); // query parameter
            if (snapshot != null) localVarQueryParams.Add("snapshot", Configuration.ApiClient.ParameterToString(snapshot)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("StreamPricing", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20022>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20022) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20022)));
            
        }

        /// <summary>
        /// Price Stream Get a stream of Account Prices starting from when the request is made. This pricing stream does not include every single price created for the Account, but instead will provide at most 4 prices per second (every 250 milliseconds) for each instrument being requested. If more than one price is created for an instrument during the 250 millisecond window, only the price in effect at the end of the window is sent. This means that during periods of rapid price movement, subscribers to this stream will not be sent every price. Pricing windows for different connections to the price stream are not all aligned in the same way (i.e. they are not all aligned to the top of the second). This means that during periods of rapid price movement, different subscribers may observe different prices depending on their alignment.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to stream Prices for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="snapshot">Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)</param>
        /// <returns>Task of InlineResponse20022</returns>
        public async System.Threading.Tasks.Task<InlineResponse20022> StreamPricingAsync (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, bool? snapshot = null)
        {
             ApiResponse<InlineResponse20022> localVarResponse = await StreamPricingAsyncWithHttpInfo(authorization, accountID, instruments, acceptDatetimeFormat, snapshot);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Price Stream Get a stream of Account Prices starting from when the request is made. This pricing stream does not include every single price created for the Account, but instead will provide at most 4 prices per second (every 250 milliseconds) for each instrument being requested. If more than one price is created for an instrument during the 250 millisecond window, only the price in effect at the end of the window is sent. This means that during periods of rapid price movement, subscribers to this stream will not be sent every price. Pricing windows for different connections to the price stream are not all aligned in the same way (i.e. they are not all aligned to the top of the second). This means that during periods of rapid price movement, different subscribers may observe different prices depending on their alignment.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <param name="instruments">List of Instruments to stream Prices for.</param>
        /// <param name="acceptDatetimeFormat">Format of DateTime fields in the request and response. (optional)</param>
        /// <param name="snapshot">Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)</param>
        /// <returns>Task of ApiResponse (InlineResponse20022)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20022>> StreamPricingAsyncWithHttpInfo (string authorization, string accountID, List<string> instruments, string acceptDatetimeFormat = null, bool? snapshot = null)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->StreamPricing");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->StreamPricing");
            // verify the required parameter 'instruments' is set
            if (instruments == null)
                throw new ApiException(400, "Missing required parameter 'instruments' when calling DefaultApi->StreamPricing");

            var localVarPath = "/accounts/{accountID}/pricing/stream";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (instruments != null) localVarQueryParams.Add("instruments", Configuration.ApiClient.ParameterToString(instruments)); // query parameter
            if (snapshot != null) localVarQueryParams.Add("snapshot", Configuration.ApiClient.ParameterToString(snapshot)); // query parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter
            if (acceptDatetimeFormat != null) localVarHeaderParams.Add("Accept-Datetime-Format", Configuration.ApiClient.ParameterToString(acceptDatetimeFormat)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("StreamPricing", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20022>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20022) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20022)));
            
        }

        /// <summary>
        /// Transaction Stream Get a stream of Transactions for an Account starting from when the request is made.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>InlineResponse20020</returns>
        public InlineResponse20020 StreamTransactions (string authorization, string accountID)
        {
             ApiResponse<InlineResponse20020> localVarResponse = StreamTransactionsWithHttpInfo(authorization, accountID);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Transaction Stream Get a stream of Transactions for an Account starting from when the request is made.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>ApiResponse of InlineResponse20020</returns>
        public ApiResponse< InlineResponse20020 > StreamTransactionsWithHttpInfo (string authorization, string accountID)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->StreamTransactions");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->StreamTransactions");

            var localVarPath = "/accounts/{accountID}/transactions/stream";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("StreamTransactions", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20020>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20020) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20020)));
            
        }

        /// <summary>
        /// Transaction Stream Get a stream of Transactions for an Account starting from when the request is made.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>Task of InlineResponse20020</returns>
        public async System.Threading.Tasks.Task<InlineResponse20020> StreamTransactionsAsync (string authorization, string accountID)
        {
             ApiResponse<InlineResponse20020> localVarResponse = await StreamTransactionsAsyncWithHttpInfo(authorization, accountID);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Transaction Stream Get a stream of Transactions for an Account starting from when the request is made.
        /// </summary>
        /// <exception cref="Oanda.RestV20.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorization">The authorization bearer token previously obtained by the client</param>
        /// <param name="accountID">Account Identifier</param>
        /// <returns>Task of ApiResponse (InlineResponse20020)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<InlineResponse20020>> StreamTransactionsAsyncWithHttpInfo (string authorization, string accountID)
        {
            // verify the required parameter 'authorization' is set
            if (authorization == null)
                throw new ApiException(400, "Missing required parameter 'authorization' when calling DefaultApi->StreamTransactions");
            // verify the required parameter 'accountID' is set
            if (accountID == null)
                throw new ApiException(400, "Missing required parameter 'accountID' when calling DefaultApi->StreamTransactions");

            var localVarPath = "/accounts/{accountID}/transactions/stream";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new Dictionary<String, String>();
            var localVarHeaderParams = new Dictionary<String, String>(Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            // set "format" to json by default
            // e.g. /pet/{petId}.{format} becomes /pet/{petId}.json
            localVarPathParams.Add("format", "json");
            if (accountID != null) localVarPathParams.Add("accountID", Configuration.ApiClient.ParameterToString(accountID)); // path parameter
            if (authorization != null) localVarHeaderParams.Add("Authorization", Configuration.ApiClient.ParameterToString(authorization)); // header parameter


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("StreamTransactions", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<InlineResponse20020>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (InlineResponse20020) Configuration.ApiClient.Deserialize(localVarResponse, typeof(InlineResponse20020)));
            
        }

    }
}
