/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// A TransferFundsRejectTransaction represents the rejection of the transfer of funds in/out of an Account.
    /// </summary>
    [DataContract]
    public partial class TransferFundsRejectTransaction :  IEquatable<TransferFundsRejectTransaction>, IValidatableObject
    {
        /// <summary>
        /// The Type of the Transaction. Always set to \"TRANSFER_FUNDS_REJECT\" in a TransferFundsRejectTransaction.
        /// </summary>
        /// <value>The Type of the Transaction. Always set to \"TRANSFER_FUNDS_REJECT\" in a TransferFundsRejectTransaction.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum TypeEnum
        {
            
            /// <summary>
            /// Enum CREATE for "CREATE"
            /// </summary>
            [EnumMember(Value = "CREATE")]
            CREATE,
            
            /// <summary>
            /// Enum CLOSE for "CLOSE"
            /// </summary>
            [EnumMember(Value = "CLOSE")]
            CLOSE,
            
            /// <summary>
            /// Enum REOPEN for "REOPEN"
            /// </summary>
            [EnumMember(Value = "REOPEN")]
            REOPEN,
            
            /// <summary>
            /// Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE"
            /// </summary>
            [EnumMember(Value = "CLIENT_CONFIGURE")]
            CLIENTCONFIGURE,
            
            /// <summary>
            /// Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT"
            /// </summary>
            [EnumMember(Value = "CLIENT_CONFIGURE_REJECT")]
            CLIENTCONFIGUREREJECT,
            
            /// <summary>
            /// Enum TRANSFERFUNDS for "TRANSFER_FUNDS"
            /// </summary>
            [EnumMember(Value = "TRANSFER_FUNDS")]
            TRANSFERFUNDS,
            
            /// <summary>
            /// Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT"
            /// </summary>
            [EnumMember(Value = "TRANSFER_FUNDS_REJECT")]
            TRANSFERFUNDSREJECT,
            
            /// <summary>
            /// Enum MARKETORDER for "MARKET_ORDER"
            /// </summary>
            [EnumMember(Value = "MARKET_ORDER")]
            MARKETORDER,
            
            /// <summary>
            /// Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "MARKET_ORDER_REJECT")]
            MARKETORDERREJECT,
            
            /// <summary>
            /// Enum LIMITORDER for "LIMIT_ORDER"
            /// </summary>
            [EnumMember(Value = "LIMIT_ORDER")]
            LIMITORDER,
            
            /// <summary>
            /// Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "LIMIT_ORDER_REJECT")]
            LIMITORDERREJECT,
            
            /// <summary>
            /// Enum STOPORDER for "STOP_ORDER"
            /// </summary>
            [EnumMember(Value = "STOP_ORDER")]
            STOPORDER,
            
            /// <summary>
            /// Enum STOPORDERREJECT for "STOP_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "STOP_ORDER_REJECT")]
            STOPORDERREJECT,
            
            /// <summary>
            /// Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER"
            /// </summary>
            [EnumMember(Value = "MARKET_IF_TOUCHED_ORDER")]
            MARKETIFTOUCHEDORDER,
            
            /// <summary>
            /// Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "MARKET_IF_TOUCHED_ORDER_REJECT")]
            MARKETIFTOUCHEDORDERREJECT,
            
            /// <summary>
            /// Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ORDER")]
            TAKEPROFITORDER,
            
            /// <summary>
            /// Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ORDER_REJECT")]
            TAKEPROFITORDERREJECT,
            
            /// <summary>
            /// Enum STOPLOSSORDER for "STOP_LOSS_ORDER"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ORDER")]
            STOPLOSSORDER,
            
            /// <summary>
            /// Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ORDER_REJECT")]
            STOPLOSSORDERREJECT,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ORDER")]
            TRAILINGSTOPLOSSORDER,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ORDER_REJECT")]
            TRAILINGSTOPLOSSORDERREJECT,
            
            /// <summary>
            /// Enum ORDERFILL for "ORDER_FILL"
            /// </summary>
            [EnumMember(Value = "ORDER_FILL")]
            ORDERFILL,
            
            /// <summary>
            /// Enum ORDERCANCEL for "ORDER_CANCEL"
            /// </summary>
            [EnumMember(Value = "ORDER_CANCEL")]
            ORDERCANCEL,
            
            /// <summary>
            /// Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT"
            /// </summary>
            [EnumMember(Value = "ORDER_CANCEL_REJECT")]
            ORDERCANCELREJECT,
            
            /// <summary>
            /// Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY"
            /// </summary>
            [EnumMember(Value = "ORDER_CLIENT_EXTENSIONS_MODIFY")]
            ORDERCLIENTEXTENSIONSMODIFY,
            
            /// <summary>
            /// Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT"
            /// </summary>
            [EnumMember(Value = "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT")]
            ORDERCLIENTEXTENSIONSMODIFYREJECT,
            
            /// <summary>
            /// Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY"
            /// </summary>
            [EnumMember(Value = "TRADE_CLIENT_EXTENSIONS_MODIFY")]
            TRADECLIENTEXTENSIONSMODIFY,
            
            /// <summary>
            /// Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT"
            /// </summary>
            [EnumMember(Value = "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT")]
            TRADECLIENTEXTENSIONSMODIFYREJECT,
            
            /// <summary>
            /// Enum MARGINCALLENTER for "MARGIN_CALL_ENTER"
            /// </summary>
            [EnumMember(Value = "MARGIN_CALL_ENTER")]
            MARGINCALLENTER,
            
            /// <summary>
            /// Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND"
            /// </summary>
            [EnumMember(Value = "MARGIN_CALL_EXTEND")]
            MARGINCALLEXTEND,
            
            /// <summary>
            /// Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT"
            /// </summary>
            [EnumMember(Value = "MARGIN_CALL_EXIT")]
            MARGINCALLEXIT,
            
            /// <summary>
            /// Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE"
            /// </summary>
            [EnumMember(Value = "DELAYED_TRADE_CLOSURE")]
            DELAYEDTRADECLOSURE,
            
            /// <summary>
            /// Enum DAILYFINANCING for "DAILY_FINANCING"
            /// </summary>
            [EnumMember(Value = "DAILY_FINANCING")]
            DAILYFINANCING,
            
            /// <summary>
            /// Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL"
            /// </summary>
            [EnumMember(Value = "RESET_RESETTABLE_PL")]
            RESETRESETTABLEPL
        }

        /// <summary>
        /// The reason that an Account is being funded.
        /// </summary>
        /// <value>The reason that an Account is being funded.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum FundingReasonEnum
        {
            
            /// <summary>
            /// Enum CLIENTFUNDING for "CLIENT_FUNDING"
            /// </summary>
            [EnumMember(Value = "CLIENT_FUNDING")]
            CLIENTFUNDING,
            
            /// <summary>
            /// Enum ACCOUNTTRANSFER for "ACCOUNT_TRANSFER"
            /// </summary>
            [EnumMember(Value = "ACCOUNT_TRANSFER")]
            ACCOUNTTRANSFER,
            
            /// <summary>
            /// Enum DIVISIONMIGRATION for "DIVISION_MIGRATION"
            /// </summary>
            [EnumMember(Value = "DIVISION_MIGRATION")]
            DIVISIONMIGRATION,
            
            /// <summary>
            /// Enum SITEMIGRATION for "SITE_MIGRATION"
            /// </summary>
            [EnumMember(Value = "SITE_MIGRATION")]
            SITEMIGRATION,
            
            /// <summary>
            /// Enum ADJUSTMENT for "ADJUSTMENT"
            /// </summary>
            [EnumMember(Value = "ADJUSTMENT")]
            ADJUSTMENT
        }

        /// <summary>
        /// The reason that the Reject Transaction was created
        /// </summary>
        /// <value>The reason that the Reject Transaction was created</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum RejectReasonEnum
        {
            
            /// <summary>
            /// Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR"
            /// </summary>
            [EnumMember(Value = "INTERNAL_SERVER_ERROR")]
            INTERNALSERVERERROR,
            
            /// <summary>
            /// Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN"
            /// </summary>
            [EnumMember(Value = "INSTRUMENT_PRICE_UNKNOWN")]
            INSTRUMENTPRICEUNKNOWN,
            
            /// <summary>
            /// Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE"
            /// </summary>
            [EnumMember(Value = "ACCOUNT_NOT_ACTIVE")]
            ACCOUNTNOTACTIVE,
            
            /// <summary>
            /// Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED"
            /// </summary>
            [EnumMember(Value = "ACCOUNT_LOCKED")]
            ACCOUNTLOCKED,
            
            /// <summary>
            /// Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED"
            /// </summary>
            [EnumMember(Value = "ACCOUNT_ORDER_CREATION_LOCKED")]
            ACCOUNTORDERCREATIONLOCKED,
            
            /// <summary>
            /// Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED"
            /// </summary>
            [EnumMember(Value = "ACCOUNT_CONFIGURATION_LOCKED")]
            ACCOUNTCONFIGURATIONLOCKED,
            
            /// <summary>
            /// Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED"
            /// </summary>
            [EnumMember(Value = "ACCOUNT_DEPOSIT_LOCKED")]
            ACCOUNTDEPOSITLOCKED,
            
            /// <summary>
            /// Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED"
            /// </summary>
            [EnumMember(Value = "ACCOUNT_WITHDRAWAL_LOCKED")]
            ACCOUNTWITHDRAWALLOCKED,
            
            /// <summary>
            /// Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED"
            /// </summary>
            [EnumMember(Value = "ACCOUNT_ORDER_CANCEL_LOCKED")]
            ACCOUNTORDERCANCELLOCKED,
            
            /// <summary>
            /// Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE"
            /// </summary>
            [EnumMember(Value = "INSTRUMENT_NOT_TRADEABLE")]
            INSTRUMENTNOTTRADEABLE,
            
            /// <summary>
            /// Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "PENDING_ORDERS_ALLOWED_EXCEEDED")]
            PENDINGORDERSALLOWEDEXCEEDED,
            
            /// <summary>
            /// Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED"
            /// </summary>
            [EnumMember(Value = "ORDER_ID_UNSPECIFIED")]
            ORDERIDUNSPECIFIED,
            
            /// <summary>
            /// Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST"
            /// </summary>
            [EnumMember(Value = "ORDER_DOESNT_EXIST")]
            ORDERDOESNTEXIST,
            
            /// <summary>
            /// Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY"
            /// </summary>
            [EnumMember(Value = "ORDER_IDENTIFIER_INCONSISTENCY")]
            ORDERIDENTIFIERINCONSISTENCY,
            
            /// <summary>
            /// Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED"
            /// </summary>
            [EnumMember(Value = "TRADE_ID_UNSPECIFIED")]
            TRADEIDUNSPECIFIED,
            
            /// <summary>
            /// Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST"
            /// </summary>
            [EnumMember(Value = "TRADE_DOESNT_EXIST")]
            TRADEDOESNTEXIST,
            
            /// <summary>
            /// Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY"
            /// </summary>
            [EnumMember(Value = "TRADE_IDENTIFIER_INCONSISTENCY")]
            TRADEIDENTIFIERINCONSISTENCY,
            
            /// <summary>
            /// Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING"
            /// </summary>
            [EnumMember(Value = "INSTRUMENT_MISSING")]
            INSTRUMENTMISSING,
            
            /// <summary>
            /// Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN"
            /// </summary>
            [EnumMember(Value = "INSTRUMENT_UNKNOWN")]
            INSTRUMENTUNKNOWN,
            
            /// <summary>
            /// Enum UNITSMISSING for "UNITS_MISSING"
            /// </summary>
            [EnumMember(Value = "UNITS_MISSING")]
            UNITSMISSING,
            
            /// <summary>
            /// Enum UNITSINVALID for "UNITS_INVALID"
            /// </summary>
            [EnumMember(Value = "UNITS_INVALID")]
            UNITSINVALID,
            
            /// <summary>
            /// Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "UNITS_PRECISION_EXCEEDED")]
            UNITSPRECISIONEXCEEDED,
            
            /// <summary>
            /// Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "UNITS_LIMIT_EXCEEDED")]
            UNITSLIMITEXCEEDED,
            
            /// <summary>
            /// Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET"
            /// </summary>
            [EnumMember(Value = "UNITS_MIMIMUM_NOT_MET")]
            UNITSMIMIMUMNOTMET,
            
            /// <summary>
            /// Enum PRICEMISSING for "PRICE_MISSING"
            /// </summary>
            [EnumMember(Value = "PRICE_MISSING")]
            PRICEMISSING,
            
            /// <summary>
            /// Enum PRICEINVALID for "PRICE_INVALID"
            /// </summary>
            [EnumMember(Value = "PRICE_INVALID")]
            PRICEINVALID,
            
            /// <summary>
            /// Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "PRICE_PRECISION_EXCEEDED")]
            PRICEPRECISIONEXCEEDED,
            
            /// <summary>
            /// Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING"
            /// </summary>
            [EnumMember(Value = "PRICE_DISTANCE_MISSING")]
            PRICEDISTANCEMISSING,
            
            /// <summary>
            /// Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID"
            /// </summary>
            [EnumMember(Value = "PRICE_DISTANCE_INVALID")]
            PRICEDISTANCEINVALID,
            
            /// <summary>
            /// Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "PRICE_DISTANCE_PRECISION_EXCEEDED")]
            PRICEDISTANCEPRECISIONEXCEEDED,
            
            /// <summary>
            /// Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "PRICE_DISTANCE_MAXIMUM_EXCEEDED")]
            PRICEDISTANCEMAXIMUMEXCEEDED,
            
            /// <summary>
            /// Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET"
            /// </summary>
            [EnumMember(Value = "PRICE_DISTANCE_MINIMUM_NOT_MET")]
            PRICEDISTANCEMINIMUMNOTMET,
            
            /// <summary>
            /// Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING"
            /// </summary>
            [EnumMember(Value = "TIME_IN_FORCE_MISSING")]
            TIMEINFORCEMISSING,
            
            /// <summary>
            /// Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID"
            /// </summary>
            [EnumMember(Value = "TIME_IN_FORCE_INVALID")]
            TIMEINFORCEINVALID,
            
            /// <summary>
            /// Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING"
            /// </summary>
            [EnumMember(Value = "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING")]
            TIMEINFORCEGTDTIMESTAMPMISSING,
            
            /// <summary>
            /// Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST"
            /// </summary>
            [EnumMember(Value = "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST")]
            TIMEINFORCEGTDTIMESTAMPINPAST,
            
            /// <summary>
            /// Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID"
            /// </summary>
            [EnumMember(Value = "PRICE_BOUND_INVALID")]
            PRICEBOUNDINVALID,
            
            /// <summary>
            /// Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "PRICE_BOUND_PRECISION_EXCEEDED")]
            PRICEBOUNDPRECISIONEXCEEDED,
            
            /// <summary>
            /// Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS"
            /// </summary>
            [EnumMember(Value = "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS")]
            ORDERSONFILLDUPLICATECLIENTORDERIDS,
            
            /// <summary>
            /// Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED"
            /// </summary>
            [EnumMember(Value = "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED")]
            TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED,
            
            /// <summary>
            /// Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID"
            /// </summary>
            [EnumMember(Value = "CLIENT_ORDER_ID_INVALID")]
            CLIENTORDERIDINVALID,
            
            /// <summary>
            /// Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS"
            /// </summary>
            [EnumMember(Value = "CLIENT_ORDER_ID_ALREADY_EXISTS")]
            CLIENTORDERIDALREADYEXISTS,
            
            /// <summary>
            /// Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID"
            /// </summary>
            [EnumMember(Value = "CLIENT_ORDER_TAG_INVALID")]
            CLIENTORDERTAGINVALID,
            
            /// <summary>
            /// Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID"
            /// </summary>
            [EnumMember(Value = "CLIENT_ORDER_COMMENT_INVALID")]
            CLIENTORDERCOMMENTINVALID,
            
            /// <summary>
            /// Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID"
            /// </summary>
            [EnumMember(Value = "CLIENT_TRADE_ID_INVALID")]
            CLIENTTRADEIDINVALID,
            
            /// <summary>
            /// Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS"
            /// </summary>
            [EnumMember(Value = "CLIENT_TRADE_ID_ALREADY_EXISTS")]
            CLIENTTRADEIDALREADYEXISTS,
            
            /// <summary>
            /// Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID"
            /// </summary>
            [EnumMember(Value = "CLIENT_TRADE_TAG_INVALID")]
            CLIENTTRADETAGINVALID,
            
            /// <summary>
            /// Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID"
            /// </summary>
            [EnumMember(Value = "CLIENT_TRADE_COMMENT_INVALID")]
            CLIENTTRADECOMMENTINVALID,
            
            /// <summary>
            /// Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING"
            /// </summary>
            [EnumMember(Value = "ORDER_FILL_POSITION_ACTION_MISSING")]
            ORDERFILLPOSITIONACTIONMISSING,
            
            /// <summary>
            /// Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID"
            /// </summary>
            [EnumMember(Value = "ORDER_FILL_POSITION_ACTION_INVALID")]
            ORDERFILLPOSITIONACTIONINVALID,
            
            /// <summary>
            /// Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING"
            /// </summary>
            [EnumMember(Value = "TRIGGER_CONDITION_MISSING")]
            TRIGGERCONDITIONMISSING,
            
            /// <summary>
            /// Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID"
            /// </summary>
            [EnumMember(Value = "TRIGGER_CONDITION_INVALID")]
            TRIGGERCONDITIONINVALID,
            
            /// <summary>
            /// Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING"
            /// </summary>
            [EnumMember(Value = "ORDER_PARTIAL_FILL_OPTION_MISSING")]
            ORDERPARTIALFILLOPTIONMISSING,
            
            /// <summary>
            /// Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID"
            /// </summary>
            [EnumMember(Value = "ORDER_PARTIAL_FILL_OPTION_INVALID")]
            ORDERPARTIALFILLOPTIONINVALID,
            
            /// <summary>
            /// Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL"
            /// </summary>
            [EnumMember(Value = "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL")]
            INVALIDREISSUEIMMEDIATEPARTIALFILL,
            
            /// <summary>
            /// Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ORDER_ALREADY_EXISTS")]
            TAKEPROFITORDERALREADYEXISTS,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_PRICE_MISSING")]
            TAKEPROFITONFILLPRICEMISSING,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_PRICE_INVALID")]
            TAKEPROFITONFILLPRICEINVALID,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED")]
            TAKEPROFITONFILLPRICEPRECISIONEXCEEDED,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING")]
            TAKEPROFITONFILLTIMEINFORCEMISSING,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID")]
            TAKEPROFITONFILLTIMEINFORCEINVALID,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING")]
            TAKEPROFITONFILLGTDTIMESTAMPMISSING,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST")]
            TAKEPROFITONFILLGTDTIMESTAMPINPAST,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID")]
            TAKEPROFITONFILLCLIENTORDERIDINVALID,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID")]
            TAKEPROFITONFILLCLIENTORDERTAGINVALID,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID")]
            TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING")]
            TAKEPROFITONFILLTRIGGERCONDITIONMISSING,
            
            /// <summary>
            /// Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID"
            /// </summary>
            [EnumMember(Value = "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID")]
            TAKEPROFITONFILLTRIGGERCONDITIONINVALID,
            
            /// <summary>
            /// Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ORDER_ALREADY_EXISTS")]
            STOPLOSSORDERALREADYEXISTS,
            
            /// <summary>
            /// Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_PRICE_MISSING")]
            STOPLOSSONFILLPRICEMISSING,
            
            /// <summary>
            /// Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_PRICE_INVALID")]
            STOPLOSSONFILLPRICEINVALID,
            
            /// <summary>
            /// Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED")]
            STOPLOSSONFILLPRICEPRECISIONEXCEEDED,
            
            /// <summary>
            /// Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING")]
            STOPLOSSONFILLTIMEINFORCEMISSING,
            
            /// <summary>
            /// Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID")]
            STOPLOSSONFILLTIMEINFORCEINVALID,
            
            /// <summary>
            /// Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING")]
            STOPLOSSONFILLGTDTIMESTAMPMISSING,
            
            /// <summary>
            /// Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST")]
            STOPLOSSONFILLGTDTIMESTAMPINPAST,
            
            /// <summary>
            /// Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID")]
            STOPLOSSONFILLCLIENTORDERIDINVALID,
            
            /// <summary>
            /// Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID")]
            STOPLOSSONFILLCLIENTORDERTAGINVALID,
            
            /// <summary>
            /// Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID")]
            STOPLOSSONFILLCLIENTORDERCOMMENTINVALID,
            
            /// <summary>
            /// Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING")]
            STOPLOSSONFILLTRIGGERCONDITIONMISSING,
            
            /// <summary>
            /// Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID"
            /// </summary>
            [EnumMember(Value = "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID")]
            STOPLOSSONFILLTRIGGERCONDITIONINVALID,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS")]
            TRAILINGSTOPLOSSORDERALREADYEXISTS,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING")]
            TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID")]
            TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED")]
            TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED")]
            TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET")]
            TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING")]
            TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID")]
            TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING")]
            TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST")]
            TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID")]
            TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID")]
            TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID")]
            TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED")]
            TRAILINGSTOPLOSSORDERSNOTSUPPORTED,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING")]
            TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING,
            
            /// <summary>
            /// Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID"
            /// </summary>
            [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID")]
            TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID,
            
            /// <summary>
            /// Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING"
            /// </summary>
            [EnumMember(Value = "CLOSE_TRADE_TYPE_MISSING")]
            CLOSETRADETYPEMISSING,
            
            /// <summary>
            /// Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING"
            /// </summary>
            [EnumMember(Value = "CLOSE_TRADE_PARTIAL_UNITS_MISSING")]
            CLOSETRADEPARTIALUNITSMISSING,
            
            /// <summary>
            /// Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE"
            /// </summary>
            [EnumMember(Value = "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE")]
            CLOSETRADEUNITSEXCEEDTRADESIZE,
            
            /// <summary>
            /// Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST"
            /// </summary>
            [EnumMember(Value = "CLOSEOUT_POSITION_DOESNT_EXIST")]
            CLOSEOUTPOSITIONDOESNTEXIST,
            
            /// <summary>
            /// Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION"
            /// </summary>
            [EnumMember(Value = "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION")]
            CLOSEOUTPOSITIONINCOMPLETESPECIFICATION,
            
            /// <summary>
            /// Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE"
            /// </summary>
            [EnumMember(Value = "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE")]
            CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE,
            
            /// <summary>
            /// Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT"
            /// </summary>
            [EnumMember(Value = "CLOSEOUT_POSITION_REJECT")]
            CLOSEOUTPOSITIONREJECT,
            
            /// <summary>
            /// Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING"
            /// </summary>
            [EnumMember(Value = "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING")]
            CLOSEOUTPOSITIONPARTIALUNITSMISSING,
            
            /// <summary>
            /// Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID"
            /// </summary>
            [EnumMember(Value = "MARKUP_GROUP_ID_INVALID")]
            MARKUPGROUPIDINVALID,
            
            /// <summary>
            /// Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID"
            /// </summary>
            [EnumMember(Value = "POSITION_AGGREGATION_MODE_INVALID")]
            POSITIONAGGREGATIONMODEINVALID,
            
            /// <summary>
            /// Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING"
            /// </summary>
            [EnumMember(Value = "ADMIN_CONFIGURE_DATA_MISSING")]
            ADMINCONFIGUREDATAMISSING,
            
            /// <summary>
            /// Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID"
            /// </summary>
            [EnumMember(Value = "MARGIN_RATE_INVALID")]
            MARGINRATEINVALID,
            
            /// <summary>
            /// Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT"
            /// </summary>
            [EnumMember(Value = "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT")]
            MARGINRATEWOULDTRIGGERCLOSEOUT,
            
            /// <summary>
            /// Enum ALIASINVALID for "ALIAS_INVALID"
            /// </summary>
            [EnumMember(Value = "ALIAS_INVALID")]
            ALIASINVALID,
            
            /// <summary>
            /// Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING"
            /// </summary>
            [EnumMember(Value = "CLIENT_CONFIGURE_DATA_MISSING")]
            CLIENTCONFIGUREDATAMISSING,
            
            /// <summary>
            /// Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL"
            /// </summary>
            [EnumMember(Value = "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL")]
            MARGINRATEWOULDTRIGGERMARGINCALL,
            
            /// <summary>
            /// Enum AMOUNTINVALID for "AMOUNT_INVALID"
            /// </summary>
            [EnumMember(Value = "AMOUNT_INVALID")]
            AMOUNTINVALID,
            
            /// <summary>
            /// Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS"
            /// </summary>
            [EnumMember(Value = "INSUFFICIENT_FUNDS")]
            INSUFFICIENTFUNDS,
            
            /// <summary>
            /// Enum AMOUNTMISSING for "AMOUNT_MISSING"
            /// </summary>
            [EnumMember(Value = "AMOUNT_MISSING")]
            AMOUNTMISSING,
            
            /// <summary>
            /// Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING"
            /// </summary>
            [EnumMember(Value = "FUNDING_REASON_MISSING")]
            FUNDINGREASONMISSING,
            
            /// <summary>
            /// Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING"
            /// </summary>
            [EnumMember(Value = "CLIENT_EXTENSIONS_DATA_MISSING")]
            CLIENTEXTENSIONSDATAMISSING,
            
            /// <summary>
            /// Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID"
            /// </summary>
            [EnumMember(Value = "REPLACING_ORDER_INVALID")]
            REPLACINGORDERINVALID,
            
            /// <summary>
            /// Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID"
            /// </summary>
            [EnumMember(Value = "REPLACING_TRADE_ID_INVALID")]
            REPLACINGTRADEIDINVALID
        }

        /// <summary>
        /// The Type of the Transaction. Always set to \"TRANSFER_FUNDS_REJECT\" in a TransferFundsRejectTransaction.
        /// </summary>
        /// <value>The Type of the Transaction. Always set to \"TRANSFER_FUNDS_REJECT\" in a TransferFundsRejectTransaction.</value>
        [DataMember(Name="type", EmitDefaultValue=false)]
        public TypeEnum? Type { get; set; }
        /// <summary>
        /// The reason that an Account is being funded.
        /// </summary>
        /// <value>The reason that an Account is being funded.</value>
        [DataMember(Name="fundingReason", EmitDefaultValue=false)]
        public FundingReasonEnum? FundingReason { get; set; }
        /// <summary>
        /// The reason that the Reject Transaction was created
        /// </summary>
        /// <value>The reason that the Reject Transaction was created</value>
        [DataMember(Name="rejectReason", EmitDefaultValue=false)]
        public RejectReasonEnum? RejectReason { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="TransferFundsRejectTransaction" /> class.
        /// </summary>
        /// <param name="Id">The Transaction&#39;s Identifier..</param>
        /// <param name="Time">The date/time when the Transaction was created..</param>
        /// <param name="UserID">The ID of the user that initiated the creation of the Transaction..</param>
        /// <param name="AccountID">The ID of the Account the Transaction was created for..</param>
        /// <param name="BatchID">The ID of the \&quot;batch\&quot; that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..</param>
        /// <param name="RequestID">The Request ID of the request which generated the transaction..</param>
        /// <param name="Type">The Type of the Transaction. Always set to \&quot;TRANSFER_FUNDS_REJECT\&quot; in a TransferFundsRejectTransaction..</param>
        /// <param name="Amount">The amount to deposit/withdraw from the Account in the Account&#39;s home currency. A positive value indicates a deposit, a negative value indicates a withdrawal..</param>
        /// <param name="FundingReason">The reason that an Account is being funded..</param>
        /// <param name="Comment">An optional comment that may be attached to a fund transfer for audit purposes.</param>
        /// <param name="RejectReason">The reason that the Reject Transaction was created.</param>
        public TransferFundsRejectTransaction(string Id = default(string), string Time = default(string), int? UserID = default(int?), string AccountID = default(string), string BatchID = default(string), string RequestID = default(string), TypeEnum? Type = default(TypeEnum?), string Amount = default(string), FundingReasonEnum? FundingReason = default(FundingReasonEnum?), string Comment = default(string), RejectReasonEnum? RejectReason = default(RejectReasonEnum?))
        {
            this.Id = Id;
            this.Time = Time;
            this.UserID = UserID;
            this.AccountID = AccountID;
            this.BatchID = BatchID;
            this.RequestID = RequestID;
            this.Type = Type;
            this.Amount = Amount;
            this.FundingReason = FundingReason;
            this.Comment = Comment;
            this.RejectReason = RejectReason;
        }
        
        /// <summary>
        /// The Transaction&#39;s Identifier.
        /// </summary>
        /// <value>The Transaction&#39;s Identifier.</value>
        [DataMember(Name="id", EmitDefaultValue=false)]
        public string Id { get; set; }
        /// <summary>
        /// The date/time when the Transaction was created.
        /// </summary>
        /// <value>The date/time when the Transaction was created.</value>
        [DataMember(Name="time", EmitDefaultValue=false)]
        public string Time { get; set; }
        /// <summary>
        /// The ID of the user that initiated the creation of the Transaction.
        /// </summary>
        /// <value>The ID of the user that initiated the creation of the Transaction.</value>
        [DataMember(Name="userID", EmitDefaultValue=false)]
        public int? UserID { get; set; }
        /// <summary>
        /// The ID of the Account the Transaction was created for.
        /// </summary>
        /// <value>The ID of the Account the Transaction was created for.</value>
        [DataMember(Name="accountID", EmitDefaultValue=false)]
        public string AccountID { get; set; }
        /// <summary>
        /// The ID of the \&quot;batch\&quot; that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously.
        /// </summary>
        /// <value>The ID of the \&quot;batch\&quot; that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously.</value>
        [DataMember(Name="batchID", EmitDefaultValue=false)]
        public string BatchID { get; set; }
        /// <summary>
        /// The Request ID of the request which generated the transaction.
        /// </summary>
        /// <value>The Request ID of the request which generated the transaction.</value>
        [DataMember(Name="requestID", EmitDefaultValue=false)]
        public string RequestID { get; set; }
        /// <summary>
        /// The amount to deposit/withdraw from the Account in the Account&#39;s home currency. A positive value indicates a deposit, a negative value indicates a withdrawal.
        /// </summary>
        /// <value>The amount to deposit/withdraw from the Account in the Account&#39;s home currency. A positive value indicates a deposit, a negative value indicates a withdrawal.</value>
        [DataMember(Name="amount", EmitDefaultValue=false)]
        public string Amount { get; set; }
        /// <summary>
        /// An optional comment that may be attached to a fund transfer for audit purposes
        /// </summary>
        /// <value>An optional comment that may be attached to a fund transfer for audit purposes</value>
        [DataMember(Name="comment", EmitDefaultValue=false)]
        public string Comment { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class TransferFundsRejectTransaction {\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Time: ").Append(Time).Append("\n");
            sb.Append("  UserID: ").Append(UserID).Append("\n");
            sb.Append("  AccountID: ").Append(AccountID).Append("\n");
            sb.Append("  BatchID: ").Append(BatchID).Append("\n");
            sb.Append("  RequestID: ").Append(RequestID).Append("\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("  Amount: ").Append(Amount).Append("\n");
            sb.Append("  FundingReason: ").Append(FundingReason).Append("\n");
            sb.Append("  Comment: ").Append(Comment).Append("\n");
            sb.Append("  RejectReason: ").Append(RejectReason).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as TransferFundsRejectTransaction);
        }

        /// <summary>
        /// Returns true if TransferFundsRejectTransaction instances are equal
        /// </summary>
        /// <param name="other">Instance of TransferFundsRejectTransaction to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(TransferFundsRejectTransaction other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Id == other.Id ||
                    this.Id != null &&
                    this.Id.Equals(other.Id)
                ) && 
                (
                    this.Time == other.Time ||
                    this.Time != null &&
                    this.Time.Equals(other.Time)
                ) && 
                (
                    this.UserID == other.UserID ||
                    this.UserID != null &&
                    this.UserID.Equals(other.UserID)
                ) && 
                (
                    this.AccountID == other.AccountID ||
                    this.AccountID != null &&
                    this.AccountID.Equals(other.AccountID)
                ) && 
                (
                    this.BatchID == other.BatchID ||
                    this.BatchID != null &&
                    this.BatchID.Equals(other.BatchID)
                ) && 
                (
                    this.RequestID == other.RequestID ||
                    this.RequestID != null &&
                    this.RequestID.Equals(other.RequestID)
                ) && 
                (
                    this.Type == other.Type ||
                    this.Type != null &&
                    this.Type.Equals(other.Type)
                ) && 
                (
                    this.Amount == other.Amount ||
                    this.Amount != null &&
                    this.Amount.Equals(other.Amount)
                ) && 
                (
                    this.FundingReason == other.FundingReason ||
                    this.FundingReason != null &&
                    this.FundingReason.Equals(other.FundingReason)
                ) && 
                (
                    this.Comment == other.Comment ||
                    this.Comment != null &&
                    this.Comment.Equals(other.Comment)
                ) && 
                (
                    this.RejectReason == other.RejectReason ||
                    this.RejectReason != null &&
                    this.RejectReason.Equals(other.RejectReason)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.Id != null)
                    hash = hash * 59 + this.Id.GetHashCode();
                if (this.Time != null)
                    hash = hash * 59 + this.Time.GetHashCode();
                if (this.UserID != null)
                    hash = hash * 59 + this.UserID.GetHashCode();
                if (this.AccountID != null)
                    hash = hash * 59 + this.AccountID.GetHashCode();
                if (this.BatchID != null)
                    hash = hash * 59 + this.BatchID.GetHashCode();
                if (this.RequestID != null)
                    hash = hash * 59 + this.RequestID.GetHashCode();
                if (this.Type != null)
                    hash = hash * 59 + this.Type.GetHashCode();
                if (this.Amount != null)
                    hash = hash * 59 + this.Amount.GetHashCode();
                if (this.FundingReason != null)
                    hash = hash * 59 + this.FundingReason.GetHashCode();
                if (this.Comment != null)
                    hash = hash * 59 + this.Comment.GetHashCode();
                if (this.RejectReason != null)
                    hash = hash * 59 + this.RejectReason.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
