/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// An OrderIdentifier is used to refer to an Order, and contains both the OrderID and the ClientOrderID.
    /// </summary>
    [DataContract]
    public partial class OrderIdentifier :  IEquatable<OrderIdentifier>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="OrderIdentifier" /> class.
        /// </summary>
        /// <param name="OrderID">The OANDA-assigned Order ID.</param>
        /// <param name="ClientOrderID">The client-provided client Order ID.</param>
        public OrderIdentifier(string OrderID = default(string), string ClientOrderID = default(string))
        {
            this.OrderID = OrderID;
            this.ClientOrderID = ClientOrderID;
        }
        
        /// <summary>
        /// The OANDA-assigned Order ID
        /// </summary>
        /// <value>The OANDA-assigned Order ID</value>
        [DataMember(Name="orderID", EmitDefaultValue=false)]
        public string OrderID { get; set; }
        /// <summary>
        /// The client-provided client Order ID
        /// </summary>
        /// <value>The client-provided client Order ID</value>
        [DataMember(Name="clientOrderID", EmitDefaultValue=false)]
        public string ClientOrderID { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class OrderIdentifier {\n");
            sb.Append("  OrderID: ").Append(OrderID).Append("\n");
            sb.Append("  ClientOrderID: ").Append(ClientOrderID).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as OrderIdentifier);
        }

        /// <summary>
        /// Returns true if OrderIdentifier instances are equal
        /// </summary>
        /// <param name="other">Instance of OrderIdentifier to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(OrderIdentifier other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.OrderID == other.OrderID ||
                    this.OrderID != null &&
                    this.OrderID.Equals(other.OrderID)
                ) && 
                (
                    this.ClientOrderID == other.ClientOrderID ||
                    this.ClientOrderID != null &&
                    this.ClientOrderID.Equals(other.ClientOrderID)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.OrderID != null)
                    hash = hash * 59 + this.OrderID.GetHashCode();
                if (this.ClientOrderID != null)
                    hash = hash * 59 + this.ClientOrderID.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
