/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// Details for the Market Order extensions specific to a Market Order placed with the intent of fully closing a specific open trade that should have already been closed but wasn&#39;t due to halted market conditions
    /// </summary>
    [DataContract]
    public partial class MarketOrderDelayedTradeClose :  IEquatable<MarketOrderDelayedTradeClose>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="MarketOrderDelayedTradeClose" /> class.
        /// </summary>
        /// <param name="TradeID">The ID of the Trade being closed.</param>
        /// <param name="ClientTradeID">The Client ID of the Trade being closed.</param>
        /// <param name="SourceTransactionID">The Transaction ID of the DelayedTradeClosure transaction to which this Delayed Trade Close belongs to.</param>
        public MarketOrderDelayedTradeClose(string TradeID = default(string), string ClientTradeID = default(string), string SourceTransactionID = default(string))
        {
            this.TradeID = TradeID;
            this.ClientTradeID = ClientTradeID;
            this.SourceTransactionID = SourceTransactionID;
        }
        
        /// <summary>
        /// The ID of the Trade being closed
        /// </summary>
        /// <value>The ID of the Trade being closed</value>
        [DataMember(Name="tradeID", EmitDefaultValue=false)]
        public string TradeID { get; set; }
        /// <summary>
        /// The Client ID of the Trade being closed
        /// </summary>
        /// <value>The Client ID of the Trade being closed</value>
        [DataMember(Name="clientTradeID", EmitDefaultValue=false)]
        public string ClientTradeID { get; set; }
        /// <summary>
        /// The Transaction ID of the DelayedTradeClosure transaction to which this Delayed Trade Close belongs to
        /// </summary>
        /// <value>The Transaction ID of the DelayedTradeClosure transaction to which this Delayed Trade Close belongs to</value>
        [DataMember(Name="sourceTransactionID", EmitDefaultValue=false)]
        public string SourceTransactionID { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class MarketOrderDelayedTradeClose {\n");
            sb.Append("  TradeID: ").Append(TradeID).Append("\n");
            sb.Append("  ClientTradeID: ").Append(ClientTradeID).Append("\n");
            sb.Append("  SourceTransactionID: ").Append(SourceTransactionID).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as MarketOrderDelayedTradeClose);
        }

        /// <summary>
        /// Returns true if MarketOrderDelayedTradeClose instances are equal
        /// </summary>
        /// <param name="other">Instance of MarketOrderDelayedTradeClose to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(MarketOrderDelayedTradeClose other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.TradeID == other.TradeID ||
                    this.TradeID != null &&
                    this.TradeID.Equals(other.TradeID)
                ) && 
                (
                    this.ClientTradeID == other.ClientTradeID ||
                    this.ClientTradeID != null &&
                    this.ClientTradeID.Equals(other.ClientTradeID)
                ) && 
                (
                    this.SourceTransactionID == other.SourceTransactionID ||
                    this.SourceTransactionID != null &&
                    this.SourceTransactionID.Equals(other.SourceTransactionID)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.TradeID != null)
                    hash = hash * 59 + this.TradeID.GetHashCode();
                if (this.ClientTradeID != null)
                    hash = hash * 59 + this.ClientTradeID.GetHashCode();
                if (this.SourceTransactionID != null)
                    hash = hash * 59 + this.SourceTransactionID.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
