/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

//------------------------------------------------------------------------------
// This code was generated by a tool.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
//------------------------------------------------------------------------------

// To get up to date fundamental definition files for your hedgefund contact sales@quantconnect.com

using System.Collections.Generic;
using Newtonsoft.Json;

namespace QuantConnect.Data.Fundamental
{
    /// <summary>
    /// The non-cash expense recognized on intangible assets over the benefit period of the asset.
    /// </summary>
    public class AmortizationIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AmortizationIncomeStatement class
        /// </summary>
        public AmortizationIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The gradual elimination of a liability, such as a mortgage, in regular payments over a specified period of time. Such payments must
    /// be sufficient to cover both principal and interest.
    /// </summary>
    public class SecuritiesAmortizationIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SecuritiesAmortizationIncomeStatement class
        /// </summary>
        public SecuritiesAmortizationIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate cost of goods produced and sold and services rendered during the reporting PeriodAsByte. It excludes all operating
    /// expenses such as depreciation, depletion, amortization, and SG&amp;A. For the must have cost industry, if the number is not reported
    /// by the company, it will be calculated based on accounting equation.
    /// Cost of Revenue = Revenue - Operating Expenses - Operating Profit.
    /// </summary>
    public class CostOfRevenueIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CostOfRevenueIncomeStatement class
        /// </summary>
        public CostOfRevenueIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The non-cash expense recognized on natural resources (eg. Oil and mineral deposits) over the benefit period of the asset.
    /// </summary>
    public class DepletionIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DepletionIncomeStatement class
        /// </summary>
        public DepletionIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The current period non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of
    /// assets over their useful lives, in the Income Statement. Examples of tangible asset include buildings, production and equipment.
    /// </summary>
    public class DepreciationIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DepreciationIncomeStatement class
        /// </summary>
        public DepreciationIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The sum of depreciation and amortization expense in the Income Statement.
    /// Depreciation is the non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of
    /// assets over their useful lives
    /// Amortization is the non-cash expense recognized on intangible assets over the benefit period of the asset.
    /// </summary>
    public class DepreciationAndAmortizationIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DepreciationAndAmortizationIncomeStatement class
        /// </summary>
        public DepreciationAndAmortizationIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The sum of depreciation, amortization and depletion expense in the Income Statement.
    /// Depreciation is the non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of
    /// assets over their useful lives
    /// Amortization is the non-cash expense recognized on intangible assets over the benefit period of the asset.
    /// Depletion is the non-cash expense recognized on natural resources (eg. Oil and mineral deposits) over the benefit period of the
    /// asset.
    /// </summary>
    public class DepreciationAmortizationDepletionIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DepreciationAmortizationDepletionIncomeStatement class
        /// </summary>
        public DepreciationAmortizationDepletionIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// To be classified as discontinued operations, if both of the following conditions are met:
    /// 1: The operations and cash flow of the component have been or will be removed from the ongoing operations of the entity as a
    /// result of the disposal transaction, and
    /// 2: The entity will have no significant continuing involvement in the operations of the component after the disposal transaction.
    /// The discontinued operation is reported net of tax.
    /// Gains/Loss on Disposal of Discontinued Operations: Any gains or loss recognized on disposal of discontinued operations,
    /// which is the difference between the carrying value of the division and its fair value less costs to sell.
    /// Provision for Gain/Loss on Disposal: The amount of current expense charged in order to prepare for the disposal of
    /// discontinued operations.
    /// </summary>
    public class NetIncomeDiscontinuousOperationsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetIncomeDiscontinuousOperationsIncomeStatement class
        /// </summary>
        public NetIncomeDiscontinuousOperationsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Excise taxes are taxes paid when purchases are made on a specific good, such as gasoline. Excise taxes are often included in the
    /// price of the product. There are also excise taxes on activities, such as on wagering or on highway usage by trucks.
    /// </summary>
    public class ExciseTaxesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ExciseTaxesIncomeStatement class
        /// </summary>
        public ExciseTaxesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Gains (losses), whether arising from extinguishment of debt, prior period adjustments, or from other events or transactions, that are
    /// both unusual in nature and infrequent in occurrence thereby meeting the criteria for an event or transaction to be classified as an
    /// extraordinary item.
    /// </summary>
    public class NetIncomeExtraordinaryIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetIncomeExtraordinaryIncomeStatement class
        /// </summary>
        public NetIncomeExtraordinaryIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of fees, commissions, and other income.
    /// </summary>
    public class FeeRevenueAndOtherIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FeeRevenueAndOtherIncomeIncomeStatement class
        /// </summary>
        public FeeRevenueAndOtherIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate total of general managing and administering expenses for the company.
    /// </summary>
    public class GeneralAndAdministrativeExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GeneralAndAdministrativeExpenseIncomeStatement class
        /// </summary>
        public GeneralAndAdministrativeExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total revenue less cost of revenue. The number is as reported by the company on the income statement; however, the number will
    /// be calculated if it is not reported. This field is null if the cost of revenue is not given.
    /// Gross Profit = Total Revenue - Cost of Revenue.
    /// </summary>
    public class GrossProfitIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GrossProfitIncomeStatement class
        /// </summary>
        public GrossProfitIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Relates to the general cost of borrowing money. It is the price that a lender charges a borrower for the use of the lender's money.
    /// </summary>
    public class InterestExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestExpenseIncomeStatement class
        /// </summary>
        public InterestExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Interest expense caused by long term financing activities; such as interest expense incurred on trading liabilities, commercial paper,
    /// long-term debt, capital leases, deposits, and all other borrowings.
    /// </summary>
    public class InterestExpenseNonOperatingIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestExpenseNonOperatingIncomeStatement class
        /// </summary>
        public InterestExpenseNonOperatingIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Net interest and dividend income or expense, including any amortization and accretion (as applicable) of discounts and premiums,
    /// including consideration of the provisions for loan, lease, credit, and other related losses, if any.
    /// </summary>
    public class InterestIncomeAfterProvisionForLoanLossIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestIncomeAfterProvisionForLoanLossIncomeStatement class
        /// </summary>
        public InterestIncomeAfterProvisionForLoanLossIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Interest income earned from long term financing activities.
    /// </summary>
    public class InterestIncomeNonOperatingIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestIncomeNonOperatingIncomeStatement class
        /// </summary>
        public InterestIncomeNonOperatingIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Net-Non Operating interest income or expenses caused by financing activities.
    /// </summary>
    public class NetNonOperatingInterestIncomeExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetNonOperatingInterestIncomeExpenseIncomeStatement class
        /// </summary>
        public NetNonOperatingInterestIncomeExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Losses generally refer to (1) the amount of reduction in the value of an insured's property caused by an insured peril, (2) the amount
    /// sought through an insured's claim, or (3) the amount paid on behalf of an insured under an insurance contract.  Loss Adjustment
    /// Expenses is expenses incurred in the course of investigating and settling claims that includes any legal and adjusters' fees and the
    /// costs of paying claims and all related expenses.
    /// </summary>
    public class LossAdjustmentExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LossAdjustmentExpenseIncomeStatement class
        /// </summary>
        public LossAdjustmentExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represents par or stated value of the subsidiary stock not owned by the parent company plus the minority interest's equity in the
    /// surplus of the subsidiary. This item includes preferred dividend averages on the minority preferred stock (preferred shares not
    /// owned by the reporting parent company). Minority interest also refers to stockholders who own less than 50% of a subsidiary's
    /// outstanding voting common stock. The minority stockholders hold an interest in the subsidiary's net assets and share earnings with
    /// the parent company.
    /// </summary>
    public class MinorityInterestsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the MinorityInterestsIncomeStatement class
        /// </summary>
        public MinorityInterestsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Includes all the operations (continuing and discontinued) and all the other income or charges (extraordinary, accounting changes,
    /// tax loss carry forward, and other gains and losses).
    /// </summary>
    public class NetIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetIncomeIncomeStatement class
        /// </summary>
        public NetIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Net income minus the preferred dividends paid as presented in the Income Statement.
    /// </summary>
    public class NetIncomeCommonStockholdersIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetIncomeCommonStockholdersIncomeStatement class
        /// </summary>
        public NetIncomeCommonStockholdersIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Revenue less expenses and taxes from the entity's ongoing operations and before income (loss) from: Preferred Dividends;
    /// Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing Operation; Income from Tax
    /// Loss Carry forward; Other Gains/Losses.
    /// </summary>
    public class NetIncomeContinuousOperationsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetIncomeContinuousOperationsIncomeStatement class
        /// </summary>
        public NetIncomeContinuousOperationsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total interest income minus total interest expense. It represents the difference between interest and dividends earned on interest-
    /// bearing assets and interest paid to depositors and other creditors.
    /// </summary>
    public class NetInterestIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetInterestIncomeIncomeStatement class
        /// </summary>
        public NetInterestIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total of interest, dividends, and other earnings derived from the insurance company's invested assets minus the expenses
    /// associated with these investments. Excluded from this income are capital gains or losses as the result of the sale of assets, as well
    /// as any unrealized capital gains or losses.
    /// </summary>
    public class NetInvestmentIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetInvestmentIncomeIncomeStatement class
        /// </summary>
        public NetInvestmentIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// All sales, business revenues and income that the company makes from its business operations, net of excise taxes. This applies for
    /// all companies and can be used as comparison for all industries.
    /// For Normal, Mining, Transportation and Utility templates companies, this is the sum of Operating Revenues, Excise Taxes and Fees.
    /// For Bank template companies, this is the sum of Net Interest Income and Non-Interest Income.
    /// For Insurance template companies, this is the sum of Premiums, Interest Income, Fees, Investment and Other Income.
    /// </summary>
    public class TotalRevenueIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalRevenueIncomeStatement class
        /// </summary>
        public TotalRevenueIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Any expenses that not related to interest. It includes labor and related expense, occupancy and equipment, commission,
    /// professional expense and contract services expenses, selling, general and administrative, research and development depreciation,
    /// amortization and depletion, and any other special income/charges.
    /// </summary>
    public class NonInterestExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonInterestExpenseIncomeStatement class
        /// </summary>
        public NonInterestExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The total amount of non-interest income which may be derived from: (1) fees and commissions; (2) premiums earned; (3) equity
    /// investment; (4) the sale or disposal of assets; and (5) other sources not otherwise specified.
    /// </summary>
    public class NonInterestIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonInterestIncomeIncomeStatement class
        /// </summary>
        public NonInterestIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Operating expenses are primary recurring costs associated with central operations (other than cost of goods sold) that are incurred
    /// in order to generate sales.
    /// </summary>
    public class OperatingExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OperatingExpenseIncomeStatement class
        /// </summary>
        public OperatingExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Income from normal business operations after deducting cost of revenue and operating expenses. It does not include income from
    /// any investing activities.
    /// </summary>
    public class OperatingIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OperatingIncomeIncomeStatement class
        /// </summary>
        public OperatingIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Sales and income that the company makes from its business operations. This applies only to non-bank and insurance companies.
    /// For Utility template companies, this is the sum of revenue from electric, gas, transportation and other operating revenue.
    /// For Transportation template companies, this is the sum of revenue-passenger, revenue-cargo, and other operating revenue.
    /// </summary>
    public class OperatingRevenueIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OperatingRevenueIncomeStatement class
        /// </summary>
        public OperatingRevenueIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Income or expense that comes from miscellaneous sources.
    /// </summary>
    public class OtherIncomeExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherIncomeExpenseIncomeStatement class
        /// </summary>
        public OtherIncomeExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Costs that vary with and are primarily related to the acquisition of new and renewal insurance contracts. Also referred to as
    /// underwriting expenses.
    /// </summary>
    public class PolicyAcquisitionExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PolicyAcquisitionExpenseIncomeStatement class
        /// </summary>
        public PolicyAcquisitionExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The net provision in current period for future policy benefits, claims, and claims settlement expenses incurred in the claims
    /// settlement process before the effects of reinsurance arrangements. The value is net of the effects of contracts assumed and
    /// ceded.
    /// </summary>
    public class NetPolicyholderBenefitsAndClaimsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetPolicyholderBenefitsAndClaimsIncomeStatement class
        /// </summary>
        public NetPolicyholderBenefitsAndClaimsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The amount of dividends declared or paid in the period to preferred shareholders, or the amount for which the obligation to pay
    /// them dividends arose in the PeriodAsByte. Preferred dividends are the amount required for the current year only, and not for any amount
    /// required in past years.
    /// </summary>
    public class PreferredStockDividendsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PreferredStockDividendsIncomeStatement class
        /// </summary>
        public PreferredStockDividendsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Premiums earned is the portion of an insurance written premium which is considered "earned" by the insurer, based on the part of
    /// the policy period that the insurance has been in effect, and during which the insurer has been exposed to loss.
    /// </summary>
    public class TotalPremiumsEarnedIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalPremiumsEarnedIncomeStatement class
        /// </summary>
        public TotalPremiumsEarnedIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Reported income before the deduction or benefit of income taxes.
    /// </summary>
    public class PretaxIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PretaxIncomeIncomeStatement class
        /// </summary>
        public PretaxIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Include any taxes on income, net of any investment tax credits for the current accounting PeriodAsByte.
    /// </summary>
    public class TaxProvisionIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TaxProvisionIncomeStatement class
        /// </summary>
        public TaxProvisionIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A charge to income which represents an expense deemed adequate by management given the composition of a bank's credit
    /// portfolios, their probability of default, the economic environment and the allowance for credit losses already established. Specific
    /// provisions are established to reduce the book value of specific assets (primarily loans) to establish the amount expected to be
    /// recovered on the loans.
    /// </summary>
    public class CreditLossesProvisionIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CreditLossesProvisionIncomeStatement class
        /// </summary>
        public CreditLossesProvisionIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of research and development expenses during the year.
    /// </summary>
    public class ResearchAndDevelopmentIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ResearchAndDevelopmentIncomeStatement class
        /// </summary>
        public ResearchAndDevelopmentIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate total amount of expenses directly related to the marketing or selling of products or services.
    /// </summary>
    public class SellingAndMarketingExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SellingAndMarketingExpenseIncomeStatement class
        /// </summary>
        public SellingAndMarketingExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate total costs related to selling a firm's product and services, as well as all other general and administrative expenses.
    /// Selling expenses are those directly related to the company's efforts to generate sales (e.g., sales salaries, commissions,
    /// advertising, delivery expenses). General and administrative expenses are expenses related to general administration of the
    /// company's operation (e.g., officers and office salaries, office supplies, telephone, accounting and legal services, and business
    /// licenses and fees).
    /// </summary>
    public class SellingGeneralAndAdministrationIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SellingGeneralAndAdministrationIncomeStatement class
        /// </summary>
        public SellingGeneralAndAdministrationIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Earnings or losses attributable to occurrences or actions by the firm that is either infrequent or unusual.
    /// </summary>
    public class SpecialIncomeChargesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SpecialIncomeChargesIncomeStatement class
        /// </summary>
        public SpecialIncomeChargesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The sum of operating expense and cost of revenue. If the company does not give the reported number, it will be calculated by
    /// adding operating expense and cost of revenue.
    /// </summary>
    public class TotalExpensesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalExpensesIncomeStatement class
        /// </summary>
        public TotalExpensesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Income generated from interest-bearing deposits or accounts.
    /// </summary>
    public class InterestIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestIncomeIncomeStatement class
        /// </summary>
        public InterestIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Earnings minus expenses (excluding interest and tax expenses).
    /// </summary>
    public class EBITIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the EBITIncomeStatement class
        /// </summary>
        public EBITIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Earnings minus expenses (excluding interest, tax, depreciation, and amortization expenses).
    /// </summary>
    public class EBITDAIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the EBITDAIncomeStatement class
        /// </summary>
        public EBITDAIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from:
    /// Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing
    /// Operation; Income from Tax Loss Carry forward; Other Gains/Losses.
    /// </summary>
    public class NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement class
        /// </summary>
        public NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The amount of premiums paid and payable to another insurer as a result of reinsurance arrangements in order to exchange for that
    /// company accepting all or part of insurance on a risk or exposure. This item is usually only available for insurance industry.
    /// </summary>
    public class CededPremiumsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CededPremiumsIncomeStatement class
        /// </summary>
        public CededPremiumsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// </summary>
    public class CommissionExpensesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CommissionExpensesIncomeStatement class
        /// </summary>
        public CommissionExpensesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Income earned from credit card services including late, over limit, and annual fees. This item is usually only available for bank
    /// industry.
    /// </summary>
    public class CreditCardIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CreditCardIncomeStatement class
        /// </summary>
        public CreditCardIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Dividends earned from equity investment securities. This item is usually only available for bank industry.
    /// </summary>
    public class DividendIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DividendIncomeIncomeStatement class
        /// </summary>
        public DividendIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The earnings from equity interest can be a result of any of the following: Income from earnings distribution of the business, either
    /// as dividends paid to corporate shareholders or as drawings in a partnership; Capital gain realized upon sale of the business; Capital
    /// gain realized from selling his or her interest to other partners. This item is usually not available for bank and insurance industries.
    /// </summary>
    public class EarningsFromEquityInterestIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the EarningsFromEquityInterestIncomeStatement class
        /// </summary>
        public EarningsFromEquityInterestIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Equipment expenses include depreciation, repairs, rentals, and service contract costs. This also includes equipment purchases
    /// which do not qualify for capitalization in accordance with the entity's accounting policy. This item may also include furniture
    /// expenses. This item is usually only available for bank industry.
    /// </summary>
    public class EquipmentIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the EquipmentIncomeStatement class
        /// </summary>
        public EquipmentIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Costs incurred in identifying areas that may warrant examination and in examining specific areas that are considered to have
    /// prospects of containing energy or metal reserves, including costs of drilling exploratory wells. Development expense is the
    /// capitalized costs incurred to obtain access to proved reserves and to provide facilities for extracting, treating, gathering and storing
    /// the energy and metal. Mineral property includes oil and gas wells, mines, and other natural deposits (including geothermal
    /// deposits). The payment for leasing those properties is called mineral property lease expense. Exploration expense is included in
    /// operation expenses for mining industry.
    /// </summary>
    public class ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement class
        /// </summary>
        public ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total fees and commissions earned from providing services such as leasing of space or maintaining: (1) depositor accounts; (2)
    /// transfer agent; (3) fiduciary and trust; (4) brokerage and underwriting; (5) mortgage; (6) credit cards; (7) correspondent clearing;
    /// and (8) other such services and activities performed for others. This item is usually available for bank and insurance industries.
    /// </summary>
    public class FeesAndCommissionsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FeesAndCommissionsIncomeStatement class
        /// </summary>
        public FeesAndCommissionsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Trading revenues that result from foreign exchange exposures such as cash instruments and off-balance sheet derivative
    /// instruments. This item is usually only available for bank industry.
    /// </summary>
    public class ForeignExchangeTradingGainsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ForeignExchangeTradingGainsIncomeStatement class
        /// </summary>
        public ForeignExchangeTradingGainsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of fuel cost for current period associated with the revenue generation. This item is usually only available for
    /// transportation industry.
    /// </summary>
    public class FuelIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FuelIncomeStatement class
        /// </summary>
        public FuelIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Cost of fuel, purchase power and gas associated with revenue generation. This item is usually only available for utility industry.
    /// </summary>
    public class FuelAndPurchasePowerIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FuelAndPurchasePowerIncomeStatement class
        /// </summary>
        public FuelAndPurchasePowerIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The amount of excess earned in comparison to fair value when selling a business. This item is usually not available for insurance
    /// industry.
    /// </summary>
    public class GainOnSaleOfBusinessIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GainOnSaleOfBusinessIncomeStatement class
        /// </summary>
        public GainOnSaleOfBusinessIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The amount of excess earned in comparison to the net book value for sale of property, plant, equipment. This item is usually not
    /// available for bank and insurance industries.
    /// </summary>
    public class GainOnSaleOfPPEIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GainOnSaleOfPPEIncomeStatement class
        /// </summary>
        public GainOnSaleOfPPEIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The amount of excess earned in comparison to the original purchase value of the security.
    /// </summary>
    public class GainOnSaleOfSecurityIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GainOnSaleOfSecurityIncomeStatement class
        /// </summary>
        public GainOnSaleOfSecurityIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total premiums generated from all policies written by an insurance company within a given period of time. This item is usually only
    /// available for insurance industry.
    /// </summary>
    public class GrossPremiumsWrittenIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GrossPremiumsWrittenIncomeStatement class
        /// </summary>
        public GrossPremiumsWrittenIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Impairments are considered to be permanent, which is a downward revaluation of fixed assets. If the sum of all estimated future
    /// cash flows is less than the carrying value of the asset, then the asset would be considered impaired and would have to be written
    /// down to its fair value. Once an asset is written down, it may only be written back up under very few circumstances. Usually the
    /// company uses the sum of undiscounted future cash flows to determine if the impairment should occur, and uses the sum of
    /// discounted future cash flows to make the impairment judgment. The impairment decision emphasizes on capital assets' future
    /// profit collection ability.
    /// </summary>
    public class ImpairmentOfCapitalAssetsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ImpairmentOfCapitalAssetsIncomeStatement class
        /// </summary>
        public ImpairmentOfCapitalAssetsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Premium might contain a portion of the amount that has been paid in advance for insurance that has not yet been provided, which
    /// is called unearned premium. If either party cancels the contract, the insurer must have the unearned premium ready to refund.
    /// Hence, the amount of premium reserve maintained by insurers is called unearned premium reserves, which is prepared for
    /// liquidation.  This item is usually only available for insurance industry.
    /// </summary>
    public class IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement class
        /// </summary>
        public IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Insurance and claims are the expenses in the period incurred with respect to protection provided by insurance entities against risks
    /// other than risks associated with production (which is allocated to cost of sales). This item is usually not available for insurance
    /// industries.
    /// </summary>
    public class InsuranceAndClaimsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InsuranceAndClaimsIncomeStatement class
        /// </summary>
        public InsuranceAndClaimsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Includes interest expense on the following deposit accounts: Interest-bearing Demand deposit; Checking account; Savings account;
    /// Deposit in foreign offices; Money Market Certificates &amp; Deposit Accounts. This item is usually only available for bank industry.
    /// </summary>
    public class InterestExpenseForDepositIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestExpenseForDepositIncomeStatement class
        /// </summary>
        public InterestExpenseForDepositIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Gross expenses on the purchase of Federal funds at a specified price with a simultaneous agreement to sell the same to the same
    /// counterparty at a fixed or determinable price at a future date. This item is usually only available for bank industry.
    /// </summary>
    public class InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement class
        /// </summary>
        public InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate interest expenses incurred on long-term borrowings and any interest expenses on fixed assets (property, plant,
    /// equipment) that are leased due longer than one year. This item is usually only available for bank industry.
    /// </summary>
    public class InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement class
        /// </summary>
        public InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate interest expenses incurred on short-term borrowings and any interest expenses on fixed assets (property, plant,
    /// equipment) that are leased within one year. This item is usually only available for bank industry.
    /// </summary>
    public class InterestExpenseForShortTermDebtIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestExpenseForShortTermDebtIncomeStatement class
        /// </summary>
        public InterestExpenseForShortTermDebtIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Interest income generated from all deposit accounts. This item is usually only available for bank industry.
    /// </summary>
    public class InterestIncomeFromDepositsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestIncomeFromDepositsIncomeStatement class
        /// </summary>
        public InterestIncomeFromDepositsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The carrying value of funds outstanding loaned in the form of security resale agreements if the agreement requires the purchaser to
    /// resell the identical security purchased or a security that meets the definition of ""substantially the same"" in the case of a dollar roll.
    /// Also includes purchases of participations in pools of securities that are subject to a resale agreement; This category includes all
    /// interest income generated from federal funds sold and securities purchases under agreements to resell; This category includes all
    /// interest income generated from federal funds sold and securities purchases under agreements to resell.
    /// </summary>
    public class InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement class
        /// </summary>
        public InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Includes interest and fee income generated by direct lease financing. This item is usually only available for bank industry.
    /// </summary>
    public class InterestIncomeFromLeasesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestIncomeFromLeasesIncomeStatement class
        /// </summary>
        public InterestIncomeFromLeasesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Loan is a common field to banks. Interest Income from Loans is interest and fee income generated from all loans, which includes
    /// Commercial loans; Credit loans; Other consumer loans; Real Estate - Construction; Real Estate - Mortgage; Foreign loans. Banks
    /// earn interest from loans. This item is usually only available for bank industry.
    /// </summary>
    public class InterestIncomeFromLoansIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestIncomeFromLoansIncomeStatement class
        /// </summary>
        public InterestIncomeFromLoansIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total interest and fee income generated by loans and lease. This item is usually only available for bank industry.
    /// </summary>
    public class InterestIncomeFromLoansAndLeaseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestIncomeFromLoansAndLeaseIncomeStatement class
        /// </summary>
        public InterestIncomeFromLoansAndLeaseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represents total interest and dividend income from U.S. Treasury securities, U.S. government agency and corporation obligations,
    /// securities issued by states and political subdivisions, other domestic debt securities, foreign debt securities, and equity securities
    /// (including investments in mutual funds). Excludes interest income from securities held in trading accounts. This item is usually only
    /// available for bank industry.
    /// </summary>
    public class InterestIncomeFromSecuritiesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestIncomeFromSecuritiesIncomeStatement class
        /// </summary>
        public InterestIncomeFromSecuritiesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Includes (1) underwriting revenue (the spread between the resale price received and the cost of the securities and related
    /// expenses) generated through the purchasing, distributing and reselling of new issues of securities (alternatively, could be a
    /// secondary offering of a large block of previously issued securities); and (2) fees earned for mergers, acquisitions, divestitures,
    /// restructurings, and other types of financial advisory services. This item is usually only available for bank industry.
    /// </summary>
    public class InvestmentBankingProfitIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InvestmentBankingProfitIncomeStatement class
        /// </summary>
        public InvestmentBankingProfitIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of maintenance and repair expenses in the current period associated with the revenue generation. Mainly
    /// for fixed assets. This item is usually only available for transportation industry.
    /// </summary>
    public class MaintenanceAndRepairsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the MaintenanceAndRepairsIncomeStatement class
        /// </summary>
        public MaintenanceAndRepairsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate foreign currency translation gain or loss (both realized and unrealized) included as part of revenue. This item is
    /// usually only available for insurance industry.
    /// </summary>
    public class NetForeignExchangeGainLossIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetForeignExchangeGainLossIncomeStatement class
        /// </summary>
        public NetForeignExchangeGainLossIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Occupancy expense may include items, such as depreciation of facilities and equipment, lease expenses, property taxes and
    /// property and casualty insurance expense. This item is usually only available for bank industry.
    /// </summary>
    public class NetOccupancyExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetOccupancyExpenseIncomeStatement class
        /// </summary>
        public NetOccupancyExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Net premiums written are gross premiums written less ceded premiums. This item is usually only available for insurance industry.
    /// </summary>
    public class NetPremiumsWrittenIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetPremiumsWrittenIncomeStatement class
        /// </summary>
        public NetPremiumsWrittenIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Gain or loss realized during the period of time for all kinds of investment securities. In might include trading, available-for-sale, or
    /// held-to-maturity securities. This item is usually only available for insurance industry.
    /// </summary>
    public class NetRealizedGainLossOnInvestmentsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetRealizedGainLossOnInvestmentsIncomeStatement class
        /// </summary>
        public NetRealizedGainLossOnInvestmentsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Includes total expenses of occupancy and equipment. This item is usually only available for bank industry.
    /// </summary>
    public class OccupancyAndEquipmentIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OccupancyAndEquipmentIncomeStatement class
        /// </summary>
        public OccupancyAndEquipmentIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of operation and maintenance expenses, which is the one important operating expense for the utility
    /// industry. It includes any costs related to production and maintenance cost of the property during the revenue generation process.
    /// This item is usually only available for mining and utility industries.
    /// </summary>
    public class OperationAndMaintenanceIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OperationAndMaintenanceIncomeStatement class
        /// </summary>
        public OperationAndMaintenanceIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represents fees and commissions earned from provide other services. This item is usually only available for bank industry.
    /// </summary>
    public class OtherCustomerServicesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherCustomerServicesIncomeStatement class
        /// </summary>
        public OtherCustomerServicesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// All other interest expense that is not otherwise classified
    /// </summary>
    public class OtherInterestExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherInterestExpenseIncomeStatement class
        /// </summary>
        public OtherInterestExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// All other interest income that is not otherwise classified
    /// </summary>
    public class OtherInterestIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherInterestIncomeIncomeStatement class
        /// </summary>
        public OtherInterestIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// All other non interest expense that is not otherwise classified
    /// </summary>
    public class OtherNonInterestExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherNonInterestExpenseIncomeStatement class
        /// </summary>
        public OtherNonInterestExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// All other special charges that are not otherwise classified
    /// </summary>
    public class OtherSpecialChargesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherSpecialChargesIncomeStatement class
        /// </summary>
        public OtherSpecialChargesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Any taxes that are not part of income taxes. This item is usually not available for bank and insurance industries.
    /// </summary>
    public class OtherTaxesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherTaxesIncomeStatement class
        /// </summary>
        public OtherTaxesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The provision in current period for future policy benefits, claims, and claims settlement, which is under reinsurance arrangements.
    /// This item is usually only available for insurance industry.
    /// </summary>
    public class PolicyholderBenefitsCededIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PolicyholderBenefitsCededIncomeStatement class
        /// </summary>
        public PolicyholderBenefitsCededIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The gross amount of provision in current period for future policyholder benefits, claims, and claims settlement, incurred in the
    /// claims settlement process before the effects of reinsurance arrangements. This item is usually only available for insurance industry.
    /// </summary>
    public class PolicyholderBenefitsGrossIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PolicyholderBenefitsGrossIncomeStatement class
        /// </summary>
        public PolicyholderBenefitsGrossIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Payments made or credits extended to the insured by the company, usually at the end of a policy year results in reducing the net
    /// insurance cost to the policyholder. Such dividends may be paid in cash to the insured or applied by the insured as reductions of the
    /// premiums due for the next policy year. This item is usually only available for insurance industry.
    /// </summary>
    public class PolicyholderDividendsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PolicyholderDividendsIncomeStatement class
        /// </summary>
        public PolicyholderDividendsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The periodic income payment provided to the annuitant by the insurance company, which is determined by the assumed interest
    /// rate (AIR) and other factors. This item is usually only available for insurance industry.
    /// </summary>
    public class PolicyholderInterestIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PolicyholderInterestIncomeStatement class
        /// </summary>
        public PolicyholderInterestIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Professional and contract service expense includes cost reimbursements for support services related to contracted projects,
    /// outsourced management, technical and staff support. This item is usually only available for bank industry.
    /// </summary>
    public class ProfessionalExpenseAndContractServicesExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ProfessionalExpenseAndContractServicesExpenseIncomeStatement class
        /// </summary>
        public ProfessionalExpenseAndContractServicesExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Amount of the current period expense charged against operations, the offset which is generally to the allowance for doubtful
    /// accounts for the purpose of reducing receivables, including notes receivable, to an amount that approximates their net realizable
    /// value (the amount expected to be collected). The category includes provision for loan losses, provision for any doubtful account
    /// receivable, and bad debt expenses. This item is usually not available for bank and insurance industries.
    /// </summary>
    public class ProvisionForDoubtfulAccountsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ProvisionForDoubtfulAccountsIncomeStatement class
        /// </summary>
        public ProvisionForDoubtfulAccountsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Rent fees are the cost of occupying space during the accounting PeriodAsByte. Landing fees are a change paid to an airport company for
    /// landing at a particular airport. This item is not available for insurance industry.
    /// </summary>
    public class RentAndLandingFeesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the RentAndLandingFeesIncomeStatement class
        /// </summary>
        public RentAndLandingFeesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Expenses are related to restructuring, merger, or acquisitions. Restructuring expenses are charges associated with the
    /// consolidation and relocation of operations, disposition or abandonment of operations or productive assets. Merger and acquisition
    /// expenses are the amount of costs of a business combination including legal, accounting, and other costs that were charged to
    /// expense during the PeriodAsByte.
    /// </summary>
    public class RestructuringAndMergernAcquisitionIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the RestructuringAndMergernAcquisitionIncomeStatement class
        /// </summary>
        public RestructuringAndMergernAcquisitionIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// All salary, wages, compensation, management fees, and employee benefit expenses.
    /// </summary>
    public class SalariesAndWagesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SalariesAndWagesIncomeStatement class
        /// </summary>
        public SalariesAndWagesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Income/Loss from Securities and Activities
    /// </summary>
    public class SecuritiesActivitiesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SecuritiesActivitiesIncomeStatement class
        /// </summary>
        public SecuritiesActivitiesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Includes any service charges on following accounts: Demand Deposit; Checking account; Savings account; Deposit in foreign
    /// offices; ESCROW accounts; Money Market Certificates &amp; Deposit accounts, CDs (Negotiable Certificates of Deposits); NOW
    /// Accounts (Negotiable Order of Withdrawal); IRAs (Individual Retirement Accounts). This item is usually only available for bank
    /// industry.
    /// </summary>
    public class ServiceChargeOnDepositorAccountsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ServiceChargeOnDepositorAccountsIncomeStatement class
        /// </summary>
        public ServiceChargeOnDepositorAccountsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A broker-dealer or other financial entity may buy and sell securities exclusively for its own account, sometimes referred to as
    /// proprietary trading. The profit or loss is measured by the difference between the acquisition cost and the selling price or current
    /// market or fair value. The net gain or loss, includes both realized and unrealized, from trading cash instruments, equities and
    /// derivative contracts (including commodity contracts) that has been recognized during the accounting period for the broker dealer or
    /// other financial entity's own account. This item is typically available for bank industry.
    /// </summary>
    public class TradingGainLossIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TradingGainLossIncomeStatement class
        /// </summary>
        public TradingGainLossIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Bank manages funds on behalf of its customers through the operation of various trust accounts. Any fees earned through managing
    /// those funds are called trust fees, which are recognized when earned. This item is typically available for bank industry.
    /// </summary>
    public class TrustFeesbyCommissionsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TrustFeesbyCommissionsIncomeStatement class
        /// </summary>
        public TrustFeesbyCommissionsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Also known as Policy Acquisition Costs; and reported by insurance companies.  The cost incurred by an insurer when deciding
    /// whether to accept or decline a risk; may include meetings with the insureds or brokers, actuarial review of loss history, or physical
    /// inspections of exposures. Also, expenses deducted from insurance company revenues (including incurred losses and acquisition
    /// costs) to determine underwriting profit.
    /// </summary>
    public class UnderwritingExpensesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the UnderwritingExpensesIncomeStatement class
        /// </summary>
        public UnderwritingExpensesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A reduction in the value of an asset or earnings by the amount of an expense or loss.
    /// </summary>
    public class WriteOffIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the WriteOffIncomeStatement class
        /// </summary>
        public WriteOffIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Usually available for the banking industry.  This is Non-Interest Income that is not otherwise classified.
    /// </summary>
    public class OtherNonInterestIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherNonInterestIncomeIncomeStatement class
        /// </summary>
        public OtherNonInterestIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate expense charged against earnings to allocate the cost of intangible assets (nonphysical assets not used in
    /// production) in a systematic and rational manner to the periods expected to benefit from such assets.
    /// </summary>
    public class AmortizationOfIntangiblesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AmortizationOfIntangiblesIncomeStatement class
        /// </summary>
        public AmortizationOfIntangiblesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Net Income from Continuing Operations and Discontinued Operations, added together.
    /// </summary>
    public class NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement class
        /// </summary>
        public NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Occurs if a company has had a net loss from operations on a previous year that can be carried forward to reduce net income for tax
    /// purposes.
    /// </summary>
    public class NetIncomeFromTaxLossCarryforwardIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetIncomeFromTaxLossCarryforwardIncomeStatement class
        /// </summary>
        public NetIncomeFromTaxLossCarryforwardIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of operating expenses associated with normal operations. Will not include any gain, loss, benefit, or income;
    /// and its value reported by the company should be &lt;0.
    /// </summary>
    public class OtherOperatingExpensesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherOperatingExpensesIncomeStatement class
        /// </summary>
        public OtherOperatingExpensesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The sum of the money market investments held by a bank's depositors, which are FDIC insured.
    /// </summary>
    public class TotalMoneyMarketInvestmentsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalMoneyMarketInvestmentsIncomeStatement class
        /// </summary>
        public TotalMoneyMarketInvestmentsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The Cost Of Revenue plus Depreciation, Depletion &amp; Amortization from the IncomeStatement; minus Depreciation, Depletion &amp;
    /// Amortization from the Cash Flow Statement
    /// </summary>
    public class ReconciledCostOfRevenueIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ReconciledCostOfRevenueIncomeStatement class
        /// </summary>
        public ReconciledCostOfRevenueIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Is Depreciation, Depletion &amp; Amortization from the Cash Flow Statement
    /// </summary>
    public class ReconciledDepreciationIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ReconciledDepreciationIncomeStatement class
        /// </summary>
        public ReconciledDepreciationIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This calculation represents earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be
    /// used to fairly measure a company's profitability. This is calculated using Net Income from Continuing Operations plus/minus any tax
    /// affected unusual Items and Goodwill Impairments/Write Offs.
    /// </summary>
    public class NormalizedIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NormalizedIncomeIncomeStatement class
        /// </summary>
        public NormalizedIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from:
    /// Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing
    /// Operation; Income from Tax Loss Carry forward; Other Gains/Losses.
    /// </summary>
    public class NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement class
        /// </summary>
        public NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Any gain (loss) recognized on the sale of assets or a sale which generates profit or loss, which is a difference between sales price
    /// and net book value at the disposal time.
    /// </summary>
    public class GainLossonSaleofAssetsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GainLossonSaleofAssetsIncomeStatement class
        /// </summary>
        public GainLossonSaleofAssetsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Gain on sale of any loans investment.
    /// </summary>
    public class GainonSaleofLoansIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GainonSaleofLoansIncomeStatement class
        /// </summary>
        public GainonSaleofLoansIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Gain on the disposal of investment property.
    /// </summary>
    public class GainonSaleofInvestmentPropertyIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GainonSaleofInvestmentPropertyIncomeStatement class
        /// </summary>
        public GainonSaleofInvestmentPropertyIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Loss on extinguishment of debt is the accounting loss that results from a debt extinguishment. A debt shall be accounted for as
    /// having been extinguished in a number of circumstances, including when it has been settled through repayment or replacement by
    /// another liability. It generally results in an accounting gain or loss. Amount represents the difference between the fair value of the
    /// payments made and the carrying amount of the debt at the time of its extinguishment.
    /// </summary>
    public class LossonExtinguishmentofDebtIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LossonExtinguishmentofDebtIncomeStatement class
        /// </summary>
        public LossonExtinguishmentofDebtIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Income from other equity interest reported after Provision of Tax. This applies to all industries.
    /// </summary>
    public class EarningsfromEquityInterestNetOfTaxIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the EarningsfromEquityInterestNetOfTaxIncomeStatement class
        /// </summary>
        public EarningsfromEquityInterestNetOfTaxIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Net income of the group after the adjustment of all expenses and benefit.
    /// </summary>
    public class NetIncomeIncludingNoncontrollingInterestsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetIncomeIncludingNoncontrollingInterestsIncomeStatement class
        /// </summary>
        public NetIncomeIncludingNoncontrollingInterestsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Dividend paid to the preferred shareholders before the common stock shareholders.
    /// </summary>
    public class OtherunderPreferredStockDividendIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherunderPreferredStockDividendIncomeStatement class
        /// </summary>
        public OtherunderPreferredStockDividendIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total staff cost which is paid to the employees that is not part of Selling, General, and Administration expense.
    /// </summary>
    public class StaffCostsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the StaffCostsIncomeStatement class
        /// </summary>
        public StaffCostsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Benefits paid to the employees in respect of their work.
    /// </summary>
    public class SocialSecurityCostsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SocialSecurityCostsIncomeStatement class
        /// </summary>
        public SocialSecurityCostsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The expense that a company incurs each year by providing a pension plan for its employees. Major expenses in the pension cost
    /// include employer matching contributions and management fees.
    /// </summary>
    public class PensionCostsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PensionCostsIncomeStatement class
        /// </summary>
        public PensionCostsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total Other Operating Income- including interest income, dividend income and other types of operating income.
    /// </summary>
    public class OtherOperatingIncomeTotalIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherOperatingIncomeTotalIncomeStatement class
        /// </summary>
        public OtherOperatingIncomeTotalIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total income from the associates and joint venture via investment, accounted for in the Non-Operating section.
    /// </summary>
    public class IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement class
        /// </summary>
        public IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Any other finance cost which is not clearly defined in the Non-Operating section.
    /// </summary>
    public class TotalOtherFinanceCostIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalOtherFinanceCostIncomeStatement class
        /// </summary>
        public TotalOtherFinanceCostIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total amount paid in dividends to investors- this includes dividends paid on equity and non-equity shares.
    /// </summary>
    public class GrossDividendPaymentIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GrossDividendPaymentIncomeStatement class
        /// </summary>
        public GrossDividendPaymentIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Fees and commission income earned by bank and insurance companies on the rendering services.
    /// </summary>
    public class FeesandCommissionIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FeesandCommissionIncomeIncomeStatement class
        /// </summary>
        public FeesandCommissionIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Cost incurred by bank and insurance companies for fees and commission income.
    /// </summary>
    public class FeesandCommissionExpenseIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FeesandCommissionExpenseIncomeStatement class
        /// </summary>
        public FeesandCommissionExpenseIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Any trading income on the securities.
    /// </summary>
    public class NetTradingIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetTradingIncomeIncomeStatement class
        /// </summary>
        public NetTradingIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other costs in incurred in lieu of the employees that cannot be identified by other specific items in the Staff Costs section.
    /// </summary>
    public class OtherStaffCostsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherStaffCostsIncomeStatement class
        /// </summary>
        public OtherStaffCostsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Gain on disposal and change in fair value of investment properties.
    /// </summary>
    public class GainonInvestmentPropertiesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GainonInvestmentPropertiesIncomeStatement class
        /// </summary>
        public GainonInvestmentPropertiesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Adjustments to reported net income to calculate Diluted EPS, by assuming that all convertible instruments are converted to
    /// Common Equity. The adjustments usually include the interest expense of debentures when assumed converted and preferred
    /// dividends of convertible preferred stock when assumed converted.
    /// </summary>
    public class AverageDilutionEarningsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AverageDilutionEarningsIncomeStatement class
        /// </summary>
        public AverageDilutionEarningsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Gain/Loss through hedging activities.
    /// </summary>
    public class GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement class
        /// </summary>
        public GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Gain/loss on the write-off of financial assets available-for-sale.
    /// </summary>
    public class GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement class
        /// </summary>
        public GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Negative Goodwill recognized in the Income Statement. Negative Goodwill arises where the net assets at the date of acquisition,
    /// fairly valued, falls below the cost of acquisition.
    /// </summary>
    public class NegativeGoodwillImmediatelyRecognizedIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NegativeGoodwillImmediatelyRecognizedIncomeStatement class
        /// </summary>
        public NegativeGoodwillImmediatelyRecognizedIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Gain or loss on derivatives investment due to the fair value adjustment.
    /// </summary>
    public class GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement class
        /// </summary>
        public GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Impairment or reversal of impairment on financial instrument such as derivative. This is a contra account under Total Revenue in
    /// banks.
    /// </summary>
    public class ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement class
        /// </summary>
        public ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// All reported claims arising out of incidents in that year are considered incurred grouped with claims paid out.
    /// </summary>
    public class ClaimsandPaidIncurredIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ClaimsandPaidIncurredIncomeStatement class
        /// </summary>
        public ClaimsandPaidIncurredIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Claim on the reinsurance company and take the benefits.
    /// </summary>
    public class ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement class
        /// </summary>
        public ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Income/Expense due to changes between periods in insurance liabilities.
    /// </summary>
    public class ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement class
        /// </summary>
        public ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Income/Expense due to changes between periods in Investment Contracts.
    /// </summary>
    public class ChangeinInvestmentContractIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ChangeinInvestmentContractIncomeStatement class
        /// </summary>
        public ChangeinInvestmentContractIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Provision for the risk of loss of principal or loss of a financial reward stemming from a borrower's failure to repay a loan or otherwise
    /// meet a contractual obligation. Credit risk arises whenever a borrower is expecting to use future cash flows to pay a current debt.
    /// Investors are compensated for assuming credit risk by way of interest payments from the borrower or issuer of a debt obligation.
    /// This is a contra account under Total Revenue in banks.
    /// </summary>
    public class CreditRiskProvisionsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CreditRiskProvisionsIncomeStatement class
        /// </summary>
        public CreditRiskProvisionsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This is the portion under Staff Costs that represents salary paid to the employees in respect of their work.
    /// </summary>
    public class WagesandSalariesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the WagesandSalariesIncomeStatement class
        /// </summary>
        public WagesandSalariesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total other income and expense of the company that cannot be identified by other specific items in the Non-Operating section.
    /// </summary>
    public class OtherNonOperatingIncomeExpensesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherNonOperatingIncomeExpensesIncomeStatement class
        /// </summary>
        public OtherNonOperatingIncomeExpensesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other income of the company that cannot be identified by other specific items in the Non-Operating section.
    /// </summary>
    public class OtherNonOperatingIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherNonOperatingIncomeIncomeStatement class
        /// </summary>
        public OtherNonOperatingIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other expenses of the company that cannot be identified by other specific items in the Non-Operating section.
    /// </summary>
    public class OtherNonOperatingExpensesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherNonOperatingExpensesIncomeStatement class
        /// </summary>
        public OtherNonOperatingExpensesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total unusual items including Negative Goodwill.
    /// </summary>
    public class TotalUnusualItemsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalUnusualItemsIncomeStatement class
        /// </summary>
        public TotalUnusualItemsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The sum of all the identifiable operating and non-operating unusual items.
    /// </summary>
    public class TotalUnusualItemsExcludingGoodwillIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalUnusualItemsExcludingGoodwillIncomeStatement class
        /// </summary>
        public TotalUnusualItemsExcludingGoodwillIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Tax rate used for Morningstar calculations.
    /// </summary>
    public class TaxRateForCalcsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TaxRateForCalcsIncomeStatement class
        /// </summary>
        public TaxRateForCalcsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Tax effect of the usual items
    /// </summary>
    public class TaxEffectOfUnusualItemsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TaxEffectOfUnusualItemsIncomeStatement class
        /// </summary>
        public TaxEffectOfUnusualItemsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// EBITDA less Total Unusual Items
    /// </summary>
    public class NormalizedEBITDAIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NormalizedEBITDAIncomeStatement class
        /// </summary>
        public NormalizedEBITDAIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The cost to the company for granting stock options to reward employees.
    /// </summary>
    public class StockBasedCompensationIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the StockBasedCompensationIncomeStatement class
        /// </summary>
        public StockBasedCompensationIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Net income to calculate Diluted EPS, accounting for adjustments assuming that all the convertible instruments are being converted
    /// to Common Equity.
    /// </summary>
    public class DilutedNIAvailtoComStockholdersIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DilutedNIAvailtoComStockholdersIncomeStatement class
        /// </summary>
        public DilutedNIAvailtoComStockholdersIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Income/Expenses due to the insurer's liabilities incurred in Investment Contracts.
    /// </summary>
    public class InvestmentContractLiabilitiesIncurredIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InvestmentContractLiabilitiesIncurredIncomeStatement class
        /// </summary>
        public InvestmentContractLiabilitiesIncurredIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Income/Expense due to recoveries from reinsurers for Investment Contracts.
    /// </summary>
    public class ReinsuranceRecoveriesofInvestmentContractIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ReinsuranceRecoveriesofInvestmentContractIncomeStatement class
        /// </summary>
        public ReinsuranceRecoveriesofInvestmentContractIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total amount paid in dividends to equity securities investors.
    /// </summary>
    public class TotalDividendPaymentofEquitySharesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalDividendPaymentofEquitySharesIncomeStatement class
        /// </summary>
        public TotalDividendPaymentofEquitySharesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total amount paid in dividends to Non-Equity securities investors.
    /// </summary>
    public class TotalDividendPaymentofNonEquitySharesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalDividendPaymentofNonEquitySharesIncomeStatement class
        /// </summary>
        public TotalDividendPaymentofNonEquitySharesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The change in the amount of the unearned premium reserves maintained by insurers.
    /// </summary>
    public class ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement class
        /// </summary>
        public ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The change in the amount of unearned premium reserve to be covered by reinsurers.
    /// </summary>
    public class ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement class
        /// </summary>
        public ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Income/Expense due to the insurer's changes in insurance liabilities.
    /// </summary>
    public class ClaimsandChangeinInsuranceLiabilitiesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ClaimsandChangeinInsuranceLiabilitiesIncomeStatement class
        /// </summary>
        public ClaimsandChangeinInsuranceLiabilitiesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Income/Expense due to recoveries from reinsurers for insurance liabilities.
    /// </summary>
    public class ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement class
        /// </summary>
        public ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Operating profit/loss as reported by the company, may be the same or not the same as Morningstar's standardized definition.
    /// </summary>
    public class TotalOperatingIncomeAsReportedIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalOperatingIncomeAsReportedIncomeStatement class
        /// </summary>
        public TotalOperatingIncomeAsReportedIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other General and Administrative Expenses not categorized that the company incurs that are not directly tied to a specific function
    /// such as manufacturing, production, or sales.
    /// </summary>
    public class OtherGAIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherGAIncomeStatement class
        /// </summary>
        public OtherGAIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other costs associated with the revenue-generating activities of the company not categorized above.
    /// </summary>
    public class OtherCostofRevenueIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherCostofRevenueIncomeStatement class
        /// </summary>
        public OtherCostofRevenueIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Costs paid to use the facilities necessary to generate revenue during the accounting PeriodAsByte.
    /// </summary>
    public class RentandLandingFeesCostofRevenueIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the RentandLandingFeesCostofRevenueIncomeStatement class
        /// </summary>
        public RentandLandingFeesCostofRevenueIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Costs of depreciation and amortization on assets used for the revenue-generating activities during the accounting period
    /// </summary>
    public class DDACostofRevenueIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DDACostofRevenueIncomeStatement class
        /// </summary>
        public DDACostofRevenueIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The sum of all rent expenses incurred by the company for operating leases during the year, it is a supplemental value which would
    /// be reported outside consolidated statements or consolidated statement's footnotes.
    /// </summary>
    public class RentExpenseSupplementalIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the RentExpenseSupplementalIncomeStatement class
        /// </summary>
        public RentExpenseSupplementalIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This calculation represents pre-tax earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This
    /// can be used to fairly measure a company's profitability. This is calculated using Pre-Tax Income plus/minus any unusual Items and
    /// Goodwill Impairments/Write Offs.
    /// </summary>
    public class NormalizedPreTaxIncomeIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NormalizedPreTaxIncomeIncomeStatement class
        /// </summary>
        public NormalizedPreTaxIncomeIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of research and development expenses during the year. It is a supplemental value which would be reported
    /// outside consolidated statements.
    /// </summary>
    public class ResearchAndDevelopmentExpensesSupplementalIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ResearchAndDevelopmentExpensesSupplementalIncomeStatement class
        /// </summary>
        public ResearchAndDevelopmentExpensesSupplementalIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The current period expense charged against earnings on tangible asset over its useful life. It is a supplemental value which would
    /// be reported outside consolidated statements.
    /// </summary>
    public class DepreciationSupplementalIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DepreciationSupplementalIncomeStatement class
        /// </summary>
        public DepreciationSupplementalIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The current period expense charged against earnings on intangible asset over its useful life. It is a supplemental value which would
    /// be reported outside consolidated statements.
    /// </summary>
    public class AmortizationSupplementalIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AmortizationSupplementalIncomeStatement class
        /// </summary>
        public AmortizationSupplementalIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total revenue as reported by the company, may be the same or not the same as Morningstar's standardized definition.
    /// </summary>
    public class TotalRevenueAsReportedIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalRevenueAsReportedIncomeStatement class
        /// </summary>
        public TotalRevenueAsReportedIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Operating expense as reported by the company, may be the same or not the same as Morningstar's standardized definition.
    /// </summary>
    public class OperatingExpenseAsReportedIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OperatingExpenseAsReportedIncomeStatement class
        /// </summary>
        public OperatingExpenseAsReportedIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly measure a
    /// company's profitability. This is as reported by the company, may be the same or not the same as Morningstar's standardized
    /// definition.
    /// </summary>
    public class NormalizedIncomeAsReportedIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NormalizedIncomeAsReportedIncomeStatement class
        /// </summary>
        public NormalizedIncomeAsReportedIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// EBITDA less Total Unusual Items. This is as reported by the company, may be the same or not the same as Morningstar's
    /// standardized definition.
    /// </summary>
    public class NormalizedEBITDAAsReportedIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NormalizedEBITDAAsReportedIncomeStatement class
        /// </summary>
        public NormalizedEBITDAAsReportedIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// EBIT less Total Unusual Items. This is as reported by the company, may be the same or not the same as Morningstar's standardized
    /// definition.
    /// </summary>
    public class NormalizedEBITAsReportedIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NormalizedEBITAsReportedIncomeStatement class
        /// </summary>
        public NormalizedEBITAsReportedIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Operating profit adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly
    /// measure a company's profitability. This is as reported by the company, may be the same or not the same as Morningstar's
    /// standardized definition.
    /// </summary>
    public class NormalizedOperatingProfitAsReportedIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NormalizedOperatingProfitAsReportedIncomeStatement class
        /// </summary>
        public NormalizedOperatingProfitAsReportedIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The average tax rate for the period as reported by the company, may be the same or not the same as Morningstar's standardized
    /// definition.
    /// </summary>
    public class EffectiveTaxRateAsReportedIncomeStatement : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the EffectiveTaxRateAsReportedIncomeStatement class
        /// </summary>
        public EffectiveTaxRateAsReportedIncomeStatement(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Any money that a company owes its suppliers for goods and services purchased on credit and is expected to pay within the next
    /// year or operating cycle.
    /// </summary>
    public class AccountsPayableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AccountsPayableBalanceSheet class
        /// </summary>
        public AccountsPayableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Accounts owed to a company by customers within a year as a result of exchanging goods or services on credit.
    /// </summary>
    public class AccountsReceivableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AccountsReceivableBalanceSheet class
        /// </summary>
        public AccountsReceivableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// An expense recognized before it is paid for. Includes compensation, interest, pensions and all other miscellaneous accruals
    /// reported by the company. Expenses incurred during the accounting period, but not required to be paid until a later date.
    /// </summary>
    public class CurrentAccruedExpensesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CurrentAccruedExpensesBalanceSheet class
        /// </summary>
        public CurrentAccruedExpensesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// An expense that has occurred but the transaction has not been entered in the accounting records. Accordingly, an adjusting entry
    /// is made to debit the appropriate expense account and to credit a liability account such as accrued expenses payable or accounts
    /// payable.
    /// </summary>
    public class NonCurrentAccruedExpensesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonCurrentAccruedExpensesBalanceSheet class
        /// </summary>
        public NonCurrentAccruedExpensesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Interest, dividends, rents, ancillary and other revenues earned but not yet received by the entity on its investments.
    /// </summary>
    public class AccruedInvestmentIncomeBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AccruedInvestmentIncomeBalanceSheet class
        /// </summary>
        public AccruedInvestmentIncomeBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The cumulative amount of wear and tear or obsolescence charged against the fixed assets of a company.
    /// </summary>
    public class AccumulatedDepreciationBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AccumulatedDepreciationBalanceSheet class
        /// </summary>
        public AccumulatedDepreciationBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of gains or losses that are not part of retained earnings. It is also called other comprehensive income.
    /// </summary>
    public class GainsLossesNotAffectingRetainedEarningsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GainsLossesNotAffectingRetainedEarningsBalanceSheet class
        /// </summary>
        public GainsLossesNotAffectingRetainedEarningsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Excess of issue price over par or stated value of the entity's capital stock and amounts received from other transactions involving
    /// the entity's stock or stockholders. Includes adjustments to additional paid in capital. There are two major categories of additional
    /// paid in capital: 1) Paid in capital in excess of par/stated value, which is the difference between the actual issue price of the shares
    /// and the shares' par/stated value. 2) Paid in capital from other transactions which includes treasury stock, retirement of stock, stock
    /// dividends recorded at market, lapse of stock purchase warrants, conversion of convertible bonds in excess of the par value of the
    /// stock, and any other additional capital from the company's own stock transactions.
    /// </summary>
    public class AdditionalPaidInCapitalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AdditionalPaidInCapitalBalanceSheet class
        /// </summary>
        public AdditionalPaidInCapitalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A contra account sets aside as an allowance for bad loans (e.g. customer defaults).
    /// </summary>
    public class AllowanceForLoansAndLeaseLossesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AllowanceForLoansAndLeaseLossesBalanceSheet class
        /// </summary>
        public AllowanceForLoansAndLeaseLossesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// For an unclassified balance sheet, this item represents equity securities categorized neither as held-to-maturity nor trading. Equity
    /// securities represent ownership interests or the right to acquire ownership interests in corporations and other legal entities which
    /// ownership interest is represented by shares of common or preferred stock (which is not mandatory redeemable or redeemable at
    /// the option of the holder), convertible securities, stock rights, or stock warrants. This category includes preferred stocks, available-
    /// for-sale and common stock, available-for-sale.
    /// </summary>
    public class AvailableForSaleSecuritiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AvailableForSaleSecuritiesBalanceSheet class
        /// </summary>
        public AvailableForSaleSecuritiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The total amount of stock authorized for issue by a corporation, including common and preferred stock.
    /// </summary>
    public class CapitalStockBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CapitalStockBalanceSheet class
        /// </summary>
        public CapitalStockBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Cash includes currency on hand as well as demand deposits with banks or financial institutions. It also includes other kinds of
    /// accounts that have the general characteristics of demand deposits in that the customer may deposit additional funds at any time
    /// and also effectively may withdraw funds at any time without prior notice or penalty.
    /// </summary>
    public class CashBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CashBalanceSheet class
        /// </summary>
        public CashBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Cash equivalents, excluding items classified as marketable securities, include short-term, highly liquid investments that are both
    /// readily convertible to known amounts of cash, and so near their maturity that they present insignificant risk of changes in value
    /// because of changes in interest rates.  Generally, only investments with original maturities of three months or less qualify under this
    /// definition. Original maturity means original maturity to the entity holding the investment. For example, both a three-month US
    /// Treasury bill and a three-year Treasury note purchased three months from maturity qualify as cash equivalents. However, a Treasury
    /// note purchased three years ago does not become a cash equivalent when its remaining maturity is three months.
    /// </summary>
    public class CashEquivalentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CashEquivalentsBalanceSheet class
        /// </summary>
        public CashEquivalentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Includes unrestricted cash on hand, money market instruments and other debt securities which can be converted to cash
    /// immediately.
    /// </summary>
    public class CashAndCashEquivalentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CashAndCashEquivalentsBalanceSheet class
        /// </summary>
        public CashAndCashEquivalentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Includes cash on hand (currency and coin), cash items in process of collection, non-interest bearing deposits due from other
    /// financial institutions (including corporate credit unions), and balances with the Federal Reserve Banks, Federal Home Loan Banks
    /// and central banks.
    /// </summary>
    public class CashAndDueFromBanksBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CashAndDueFromBanksBalanceSheet class
        /// </summary>
        public CashAndDueFromBanksBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of cash, cash equivalents, and federal funds sold.
    /// </summary>
    public class CashCashEquivalentsAndFederalFundsSoldBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CashCashEquivalentsAndFederalFundsSoldBalanceSheet class
        /// </summary>
        public CashCashEquivalentsAndFederalFundsSoldBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of cash, cash equivalents, and marketable securities.
    /// </summary>
    public class CashCashEquivalentsAndMarketableSecuritiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CashCashEquivalentsAndMarketableSecuritiesBalanceSheet class
        /// </summary>
        public CashCashEquivalentsAndMarketableSecuritiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Common stock (all issues) at par value, as reported within the Stockholder's Equity section of the balance sheet; i.e. it is one
    /// component of Common Stockholder's Equity
    /// </summary>
    public class CommonStockBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CommonStockBalanceSheet class
        /// </summary>
        public CommonStockBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The total amount of assets considered to be convertible into cash within a relatively short period of time, usually a year.
    /// </summary>
    public class CurrentAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CurrentAssetsBalanceSheet class
        /// </summary>
        public CurrentAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represents the total amount of long-term debt such as bank loans and commercial paper, which is due within one year.
    /// </summary>
    public class CurrentDebtBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CurrentDebtBalanceSheet class
        /// </summary>
        public CurrentDebtBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// All borrowings due within one year including current portions of long-term debt and capital leases as well as short-term debt such
    /// as bank loans and commercial paper.
    /// </summary>
    public class CurrentDebtAndCapitalLeaseObligationBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CurrentDebtAndCapitalLeaseObligationBalanceSheet class
        /// </summary>
        public CurrentDebtAndCapitalLeaseObligationBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The debts or obligations of the firm that are due within one year.
    /// </summary>
    public class CurrentLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CurrentLiabilitiesBalanceSheet class
        /// </summary>
        public CurrentLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represents the total amount of long-term capital leases that must be paid within the next accounting PeriodAsByte. Capital lease
    /// obligations are contractual obligations that arise from obtaining the use of property or equipment via a capital lease contract.
    /// </summary>
    public class CurrentCapitalLeaseObligationBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CurrentCapitalLeaseObligationBalanceSheet class
        /// </summary>
        public CurrentCapitalLeaseObligationBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// An amount owed to a firm that is not expected to be received by the firm within one year from the date of the balance sheet.
    /// </summary>
    public class DeferredAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DeferredAssetsBalanceSheet class
        /// </summary>
        public DeferredAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// An expenditure not recognized as a cost of operation of the period in which incurred, but carried forward to be written off in future
    /// periods.
    /// </summary>
    public class DeferredCostsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DeferredCostsBalanceSheet class
        /// </summary>
        public DeferredCostsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represents the non-current portion of obligations, which is a liability that usually would have been paid but is now past due.
    /// </summary>
    public class NonCurrentDeferredLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonCurrentDeferredLiabilitiesBalanceSheet class
        /// </summary>
        public NonCurrentDeferredLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represents the current portion of obligations, which is a liability that usually would have been paid but is now past due.
    /// </summary>
    public class CurrentDeferredLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CurrentDeferredLiabilitiesBalanceSheet class
        /// </summary>
        public CurrentDeferredLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Net amount of deferred policy acquisition costs capitalized on contracts remaining in force as of the balance sheet date.
    /// </summary>
    public class DeferredPolicyAcquisitionCostsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DeferredPolicyAcquisitionCostsBalanceSheet class
        /// </summary>
        public DeferredPolicyAcquisitionCostsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represents collections of cash or other assets related to revenue producing activity for which revenue has not yet been recognized.
    /// Generally, an entity records deferred revenue when it receives consideration from a customer before achieving certain criteria that
    /// must be met for revenue to be recognized in conformity with GAAP. It can be either current or non-current item. Also called
    /// unearned revenue.
    /// </summary>
    public class CurrentDeferredRevenueBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CurrentDeferredRevenueBalanceSheet class
        /// </summary>
        public CurrentDeferredRevenueBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The non-current portion of deferred revenue amount as of the balance sheet date. Deferred revenue is a liability related to revenue
    /// producing activity for which revenue has not yet been recognized, and is not expected be recognized in the next twelve months.
    /// </summary>
    public class NonCurrentDeferredRevenueBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonCurrentDeferredRevenueBalanceSheet class
        /// </summary>
        public NonCurrentDeferredRevenueBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// An asset on a company's balance sheet that may be used to reduce any subsequent period's income tax expense. Deferred tax
    /// assets can arise due to net loss carryovers, which are only recorded as assets if it is deemed more likely than not that the asset
    /// will be used in future fiscal periods.
    /// </summary>
    public class DeferredTaxAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DeferredTaxAssetsBalanceSheet class
        /// </summary>
        public DeferredTaxAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Meaning a future tax asset, resulting from temporary differences between book (accounting) value of assets and liabilities and their
    /// tax value, or timing differences between the recognition of gains and losses in financial statements and their recognition in a tax
    /// computation. It is also called future tax.
    /// </summary>
    public class CurrentDeferredTaxesAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CurrentDeferredTaxesAssetsBalanceSheet class
        /// </summary>
        public CurrentDeferredTaxesAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Meaning a future tax liability, resulting from temporary differences between book (accounting) value of assets and liabilities and
    /// their tax value, or timing differences between the recognition of gains and losses in financial statements and their recognition in a
    /// tax computation. Deferred tax liabilities generally arise where tax relief is provided in advance of an accounting expense, or income
    /// is accrued but not taxed until received.
    /// </summary>
    public class CurrentDeferredTaxesLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CurrentDeferredTaxesLiabilitiesBalanceSheet class
        /// </summary>
        public CurrentDeferredTaxesLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A result of timing differences between taxable incomes reported on the income statement and taxable income from the company's
    /// tax return. Depending on the positioning of deferred income taxes, the field may be either current (within current assets) or non-
    /// current (below total current assets). Typically a company will have two deferred income taxes fields.
    /// </summary>
    public class NonCurrentDeferredTaxesAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonCurrentDeferredTaxesAssetsBalanceSheet class
        /// </summary>
        public NonCurrentDeferredTaxesAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The estimated future tax obligations, which usually arise when different accounting methods are used for financial statements and
    /// tax statement It is also an add-back to the cash flow statement. Deferred income taxes include accumulated tax deferrals due to
    /// accelerated depreciation and investment credit.
    /// </summary>
    public class NonCurrentDeferredTaxesLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonCurrentDeferredTaxesLiabilitiesBalanceSheet class
        /// </summary>
        public NonCurrentDeferredTaxesLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This asset represents equity securities categorized neither as held-to-maturity nor trading.
    /// </summary>
    public class EquityInvestmentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the EquityInvestmentsBalanceSheet class
        /// </summary>
        public EquityInvestmentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This liability refers to the amount shown on the books that a bank with insufficient reserves borrows, at the federal funds rate, from
    /// another bank to meet its reserve requirements; and the amount of securities that an institution sells and agrees to repurchase at a
    /// specified date for a specified price, net of any reductions or offsets.
    /// </summary>
    public class FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchaseBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchaseBalanceSheet class
        /// </summary>
        public FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchaseBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This asset refers to very-short-term loans of funds to other banks and securities dealers.
    /// </summary>
    public class FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellBalanceSheet class
        /// </summary>
        public FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This asset refers to types of investments that may be contained within the fixed maturity category which securities are having a
    /// stated final repayment date. Examples of items within this category may include bonds, including convertibles and bonds with
    /// warrants, and redeemable preferred stocks.
    /// </summary>
    public class FixedMaturityInvestmentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FixedMaturityInvestmentsBalanceSheet class
        /// </summary>
        public FixedMaturityInvestmentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Accounting policy pertaining to an insurance entity's net liability for future benefits (for example, death, cash surrender value) to be
    /// paid to or on behalf of policyholders, describing the bases, methodologies and components of the reserve, and assumptions
    /// regarding estimates of expected investment yields, mortality, morbidity, terminations and expenses.
    /// </summary>
    public class FuturePolicyBenefitsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FuturePolicyBenefitsBalanceSheet class
        /// </summary>
        public FuturePolicyBenefitsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// In a limited partnership or master limited partnership form of business, this represents the balance of capital held by the general
    /// partners.
    /// </summary>
    public class GeneralPartnershipCapitalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GeneralPartnershipCapitalBalanceSheet class
        /// </summary>
        public GeneralPartnershipCapitalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The excess of the cost of an acquired company over the sum of the fair market value of its identifiable individual assets less the
    /// liabilities.
    /// </summary>
    public class GoodwillBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GoodwillBalanceSheet class
        /// </summary>
        public GoodwillBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Rights or economic benefits, such as patents and goodwill, that is not physical in nature. They are those that are neither physical
    /// nor financial in nature, nevertheless, have value to the company. Intangibles are listed net of accumulated amortization.
    /// </summary>
    public class GoodwillAndOtherIntangibleAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GoodwillAndOtherIntangibleAssetsBalanceSheet class
        /// </summary>
        public GoodwillAndOtherIntangibleAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represents the sum of all loans (commercial, consumer, mortgage, etc.) as well as leases before any provisions for loan losses or
    /// unearned discounts.
    /// </summary>
    public class GrossLoanBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GrossLoanBalanceSheet class
        /// </summary>
        public GrossLoanBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Carrying amount at the balance sheet date for long-lived physical assets used in the normal conduct of business and not intended
    /// for resale. This can include land, physical structures, machinery, vehicles, furniture, computer equipment, construction in progress,
    /// and similar items. Amount does not include depreciation.
    /// </summary>
    public class GrossPPEBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GrossPPEBalanceSheet class
        /// </summary>
        public GrossPPEBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Debt securities that a firm has the ability and intent to hold until maturity.
    /// </summary>
    public class HeldToMaturitySecuritiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the HeldToMaturitySecuritiesBalanceSheet class
        /// </summary>
        public HeldToMaturitySecuritiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A current liability account which reflects the amount of income taxes currently due to the federal, state, and local governments.
    /// </summary>
    public class IncomeTaxPayableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the IncomeTaxPayableBalanceSheet class
        /// </summary>
        public IncomeTaxPayableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate of all domestic and foreign deposits in the bank that earns interests.
    /// </summary>
    public class InterestBearingDepositsLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestBearingDepositsLiabilitiesBalanceSheet class
        /// </summary>
        public InterestBearingDepositsLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Sum of the carrying values as of the balance sheet date of interest payable on all forms of debt, including trade payable that has
    /// been incurred.
    /// </summary>
    public class InterestPayableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestPayableBalanceSheet class
        /// </summary>
        public InterestPayableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Deposit of money with a financial institution, in consideration of which the financial institution pays or credits interest, or amounts in the nature
    /// of interest.
    /// </summary>
    public class InterestBearingDepositsAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestBearingDepositsAssetsBalanceSheet class
        /// </summary>
        public InterestBearingDepositsAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A company's merchandise, raw materials, and finished and unfinished products which have not yet been sold.
    /// </summary>
    public class InventoryBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InventoryBalanceSheet class
        /// </summary>
        public InventoryBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// All investments in affiliates, real estate, securities, etc. Non-current investment, not including marketable securities.
    /// </summary>
    public class InvestmentsAndAdvancesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InvestmentsAndAdvancesBalanceSheet class
        /// </summary>
        public InvestmentsAndAdvancesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// In a limited partnership or master limited partnership form of business, this represents the balance of capital held by the limited
    /// partners.
    /// </summary>
    public class LimitedPartnershipCapitalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LimitedPartnershipCapitalBalanceSheet class
        /// </summary>
        public LimitedPartnershipCapitalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Sum of the carrying values as of the balance sheet date of all long-term debt, which is debt initially having maturities due after one
    /// year or beyond the operating cycle, if longer, but excluding the portions thereof scheduled to be repaid within one year or the
    /// normal operating cycle, if longer. Long-term debt includes notes payable, bonds payable, mortgage loans, convertible debt,
    /// subordinated debt and other types of long term debt.
    /// </summary>
    public class LongTermDebtBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LongTermDebtBalanceSheet class
        /// </summary>
        public LongTermDebtBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// All borrowings lasting over one year including long-term debt and long-term portion of capital lease obligations.
    /// </summary>
    public class LongTermDebtAndCapitalLeaseObligationBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LongTermDebtAndCapitalLeaseObligationBalanceSheet class
        /// </summary>
        public LongTermDebtAndCapitalLeaseObligationBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Often referred to simply as "investments". Long-term investments are to be held for many years and are not intended to be
    /// disposed in the near future. This group usually consists of four types of investments.
    /// </summary>
    public class LongTermInvestmentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LongTermInvestmentsBalanceSheet class
        /// </summary>
        public LongTermInvestmentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represents the total liability for long-term leases lasting over one year. Amount equal to the present value (the principal) at the
    /// beginning of the lease term less lease payments during the lease term.
    /// </summary>
    public class LongTermCapitalLeaseObligationBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LongTermCapitalLeaseObligationBalanceSheet class
        /// </summary>
        public LongTermCapitalLeaseObligationBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Carrying amount of the equity interests owned by non-controlling shareholders, partners, or other equity holders in one or more of
    /// the entities included in the reporting entity's consolidated financial statements.
    /// </summary>
    public class MinorityInterestBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the MinorityInterestBalanceSheet class
        /// </summary>
        public MinorityInterestBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Short-term (typical maturity is less than one year), highly liquid government or corporate debt instrument such as bankers'
    /// acceptance, promissory notes, and treasury bills.
    /// </summary>
    public class MoneyMarketInvestmentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the MoneyMarketInvestmentsBalanceSheet class
        /// </summary>
        public MoneyMarketInvestmentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represents the value of all loans after deduction of the appropriate allowances for loan and lease losses.
    /// </summary>
    public class NetLoanBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetLoanBalanceSheet class
        /// </summary>
        public NetLoanBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Tangible assets that are held by an entity for use in the production or supply of goods and services, for rental to others, or for
    /// administrative purposes and that are expected to provide economic benefit for more than one year; net of accumulated
    /// depreciation.
    /// </summary>
    public class NetPPEBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetPPEBalanceSheet class
        /// </summary>
        public NetPPEBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of all domestic and foreign deposits in the banks that do not draw interest.
    /// </summary>
    public class NonInterestBearingDepositsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonInterestBearingDepositsBalanceSheet class
        /// </summary>
        public NonInterestBearingDepositsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Written promises to pay a stated sum at one or more specified dates in the future, within the accounting PeriodAsByte.
    /// </summary>
    public class CurrentNotesPayableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CurrentNotesPayableBalanceSheet class
        /// </summary>
        public CurrentNotesPayableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// An amount representing an agreement for an unconditional promise by the maker to pay the entity (holder) a definite sum of money
    /// at a future date(s) within one year of the balance sheet date or the normal operating cycle, whichever is longer. Such amount may
    /// include accrued interest receivable in accordance with the terms of the note. The note also may contain provisions including a
    /// discount or premium, payable on demand, secured, or unsecured, interest bearing or non-interest bearing, among a myriad of other
    /// features and characteristics.
    /// </summary>
    public class NotesReceivableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NotesReceivableBalanceSheet class
        /// </summary>
        public NotesReceivableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// An amount representing an agreement for an unconditional promise by the maker to pay the entity (holder) a definite sum of money
    /// at a future date(s), excluding the portion that is expected to be received within one year of the balance sheet date or the normal
    /// operating cycle, whichever is longer.
    /// </summary>
    public class NonCurrentNoteReceivablesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonCurrentNoteReceivablesBalanceSheet class
        /// </summary>
        public NonCurrentNoteReceivablesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other current liabilities = Total current liabilities - Payables and accrued Expenses - Current debt and capital lease obligation -
    /// provisions, current - deferred liabilities, current.
    /// </summary>
    public class OtherCurrentLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherCurrentLiabilitiesBalanceSheet class
        /// </summary>
        public OtherCurrentLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Sum of the carrying amounts of all intangible assets, excluding goodwill.
    /// </summary>
    public class OtherIntangibleAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherIntangibleAssetsBalanceSheet class
        /// </summary>
        public OtherIntangibleAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of short term investments, which will be expired within one year that are not specifically classified as
    /// Available-for-Sale, Held-to-Maturity,  nor Trading investments.
    /// </summary>
    public class OtherShortTermInvestmentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherShortTermInvestmentsBalanceSheet class
        /// </summary>
        public OtherShortTermInvestmentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The sum of all payables owed and expected to be paid within one year or one operating cycle, including accounts payables, taxes
    /// payable, dividends payable and all other current payables.
    /// </summary>
    public class PayablesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PayablesBalanceSheet class
        /// </summary>
        public PayablesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This balance sheet account includes all current payables and accrued expenses.
    /// </summary>
    public class PayablesAndAccruedExpensesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PayablesAndAccruedExpensesBalanceSheet class
        /// </summary>
        public PayablesAndAccruedExpensesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Accounting policy pertaining to an insurance entity's net liability for future benefits (for example, death, cash surrender value) to be
    /// paid to or on behalf of policyholders, describing the bases, methodologies and components of the reserve, and assumptions
    /// regarding estimates of expected investment yields, mortality, morbidity, terminations and expenses.
    /// </summary>
    public class PolicyReservesBenefitsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PolicyReservesBenefitsBalanceSheet class
        /// </summary>
        public PolicyReservesBenefitsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The total liability as of the balance sheet date of amounts due to policy holders, excluding future policy benefits and claims,
    /// including unpaid policy dividends, retrospective refunds, and undistributed earnings on participating business.
    /// </summary>
    public class PolicyholderFundsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PolicyholderFundsBalanceSheet class
        /// </summary>
        public PolicyholderFundsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Preferred securities that that firm treats as a liability. It includes convertible preferred stock or redeemable preferred stock.
    /// </summary>
    public class PreferredSecuritiesOutsideStockEquityBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PreferredSecuritiesOutsideStockEquityBalanceSheet class
        /// </summary>
        public PreferredSecuritiesOutsideStockEquityBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Preferred stock (all issues) at par value, as reported within the Stockholder's Equity section of the balance sheet.
    /// </summary>
    public class PreferredStockBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PreferredStockBalanceSheet class
        /// </summary>
        public PreferredStockBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Sum of the carrying amounts that are paid in advance for expenses, which will be charged against earnings in subsequent periods.
    /// </summary>
    public class PrepaidAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PrepaidAssetsBalanceSheet class
        /// </summary>
        public PrepaidAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Sum of the carrying amounts that are paid in advance for expenses, which will be charged against earnings in periods after one
    /// year or beyond the operating cycle, if longer.
    /// </summary>
    public class NonCurrentPrepaidAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonCurrentPrepaidAssetsBalanceSheet class
        /// </summary>
        public NonCurrentPrepaidAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The sum of all receivables owed by customers and affiliates within one year, including accounts receivable, notes receivable,
    /// premiums receivable, and other current receivables.
    /// </summary>
    public class ReceivablesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ReceivablesBalanceSheet class
        /// </summary>
        public ReceivablesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The amount of benefits the ceding insurer expects to recover on insurance policies ceded to other insurance entities as of the
    /// balance sheet date for all guaranteed benefit types. It includes estimated amounts for claims incurred but not reported, and policy
    /// benefits, net of any related valuation allowance.
    /// </summary>
    public class ReinsuranceRecoverableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ReinsuranceRecoverableBalanceSheet class
        /// </summary>
        public ReinsuranceRecoverableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The cumulative net income of the company from the date of its inception (or reorganization) to the date of the financial statement
    /// less the cumulative distributions to shareholders either directly (dividends) or indirectly (treasury stock).
    /// </summary>
    public class RetainedEarningsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the RetainedEarningsBalanceSheet class
        /// </summary>
        public RetainedEarningsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The carrying value as of the balance sheet date of the liabilities collateral securities loaned to other broker-dealers. Borrowers of
    /// securities generally are required to provide collateral to the lenders of securities, commonly cash but sometimes other securities or
    /// standby letters of credit, with a value slightly higher than that of the securities borrowed.
    /// </summary>
    public class SecuritiesLendingCollateralBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SecuritiesLendingCollateralBalanceSheet class
        /// </summary>
        public SecuritiesLendingCollateralBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The carrying value of funds outstanding loaned in the form of security resale agreements if the agreement requires the purchaser to
    /// resell the identical security purchased or a security that meets the definition of "substantially the same" in the case of a dollar roll.
    /// Also includes purchases of participations in pools of securities that are subject to a resale agreement.
    /// </summary>
    public class SecurityAgreeToBeResellBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SecurityAgreeToBeResellBalanceSheet class
        /// </summary>
        public SecurityAgreeToBeResellBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represent obligations of the company to deliver the specified security at the contracted price and, thereby, create a liability to
    /// purchase the security in the market at prevailing prices.
    /// </summary>
    public class SecuritySoldNotYetRepurchasedBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SecuritySoldNotYetRepurchasedBalanceSheet class
        /// </summary>
        public SecuritySoldNotYetRepurchasedBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The fair value of the assets held by the company for the benefit of separate account policyholders.
    /// </summary>
    public class SeparateAccountAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SeparateAccountAssetsBalanceSheet class
        /// </summary>
        public SeparateAccountAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Refers to revenue that is generated that is not part of typical operations.
    /// </summary>
    public class SeparateAccountBusinessBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SeparateAccountBusinessBalanceSheet class
        /// </summary>
        public SeparateAccountBusinessBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The current assets section of a company's balance sheet that contains the investments that a company holds with the purpose for
    /// trading.
    /// </summary>
    public class ShortTermInvestmentsAvailableForSaleBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ShortTermInvestmentsAvailableForSaleBalanceSheet class
        /// </summary>
        public ShortTermInvestmentsAvailableForSaleBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The current assets section of a company's balance sheet that contains the investments that a company has made that will expire
    /// at a fixed date within one year.
    /// </summary>
    public class ShortTermInvestmentsHeldToMaturityBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ShortTermInvestmentsHeldToMaturityBalanceSheet class
        /// </summary>
        public ShortTermInvestmentsHeldToMaturityBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The current assets section of a company's balance sheet that contains the investments that a company can trade at any moment.
    /// </summary>
    public class ShortTermInvestmentsTradingBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ShortTermInvestmentsTradingBalanceSheet class
        /// </summary>
        public ShortTermInvestmentsTradingBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The residual interest in the assets of the enterprise that remains after deducting its liabilities. Equity is increased by owners'
    /// investments and by comprehensive income, and it is reduced by distributions to the owners.
    /// </summary>
    public class StockholdersEquityBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the StockholdersEquityBalanceSheet class
        /// </summary>
        public StockholdersEquityBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A liability that reflects the taxes owed to federal, state, and local tax authorities. It is the carrying value as of the balance sheet
    /// date of obligations incurred and payable for statutory income, sales, use, payroll, excise, real, property and other taxes.
    /// </summary>
    public class TotalTaxPayableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalTaxPayableBalanceSheet class
        /// </summary>
        public TotalTaxPayableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of probable future economic benefits obtained or controlled by a particular enterprise as a result of past
    /// transactions or events.
    /// </summary>
    public class TotalAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalAssetsBalanceSheet class
        /// </summary>
        public TotalAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A liability account which represents the total amount of funds deposited.
    /// </summary>
    public class TotalDepositsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalDepositsBalanceSheet class
        /// </summary>
        public TotalDepositsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Asset that refers to the sum of all available for sale securities and other investments often reported on the balance sheet of
    /// insurance firms.
    /// </summary>
    public class TotalInvestmentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalInvestmentsBalanceSheet class
        /// </summary>
        public TotalInvestmentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Sum of the carrying amounts as of the balance sheet date of all assets that are expected to be realized in cash, sold or consumed
    /// after one year or beyond the normal operating cycle, if longer.
    /// </summary>
    public class TotalNonCurrentAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalNonCurrentAssetsBalanceSheet class
        /// </summary>
        public TotalNonCurrentAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Ownership interest of different classes of partners in the publicly listed limited partnership or master limited partnership. Partners
    /// include general, limited and preferred partners.
    /// </summary>
    public class TotalPartnershipCapitalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalPartnershipCapitalBalanceSheet class
        /// </summary>
        public TotalPartnershipCapitalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Trading account assets are bought and held principally for the purpose of selling them in the near term (thus held for only a short
    /// period of time). Unrealized holding gains and losses for trading securities are included in earnings.
    /// </summary>
    public class TradingAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TradingAssetsBalanceSheet class
        /// </summary>
        public TradingAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The carrying amount of liabilities as of the balance sheet date that pertain to principal and customer trading transactions, or which
    /// may be incurred with the objective of generating a profit from short-term fluctuations in price as part of an entity's market-making,
    /// hedging and proprietary trading. Examples include short positions in securities, derivatives and commodities, obligations under
    /// repurchase agreements, and securities borrowed arrangements.
    /// </summary>
    public class TradingLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TradingLiabilitiesBalanceSheet class
        /// </summary>
        public TradingLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The total of financial instruments that are bought and held principally for the purpose of selling them in the near term (thus held for
    /// only a short period of time) or for debt and equity securities formerly categorized as available-for-sale or held-to-maturity which the
    /// company held as of the date it opted to account for such securities at fair value.
    /// </summary>
    public class TradingSecuritiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TradingSecuritiesBalanceSheet class
        /// </summary>
        public TradingSecuritiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The portion of shares that a company keeps in their own treasury. Treasury stock may have come from a repurchase or buyback
    /// from shareholders; or it may have never been issued to the public in the first place. These shares don't pay dividends, have no
    /// voting rights, and are not included in shares outstanding calculations.
    /// </summary>
    public class TreasuryStockBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TreasuryStockBalanceSheet class
        /// </summary>
        public TreasuryStockBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Income received but not yet earned, it represents the unearned amount that is netted against the total loan.
    /// </summary>
    public class UnearnedIncomeBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the UnearnedIncomeBalanceSheet class
        /// </summary>
        public UnearnedIncomeBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Carrying amount of premiums written on insurance contracts that have not been earned as of the balance sheet date.
    /// </summary>
    public class UnearnedPremiumsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the UnearnedPremiumsBalanceSheet class
        /// </summary>
        public UnearnedPremiumsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Liability amount that reflects claims that are expected based upon statistical projections, but which have not been reported to the
    /// insurer.
    /// </summary>
    public class UnpaidLossAndLossReserveBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the UnpaidLossAndLossReserveBalanceSheet class
        /// </summary>
        public UnpaidLossAndLossReserveBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Invested capital = common shareholders' equity + long term debt + current debt
    /// </summary>
    public class InvestedCapitalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InvestedCapitalBalanceSheet class
        /// </summary>
        public InvestedCapitalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Payments that will be assigned as expenses with one accounting period, but that are paid in advance and temporarily set up as
    /// current assets on the balance sheet.
    /// </summary>
    public class CurrentDeferredAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CurrentDeferredAssetsBalanceSheet class
        /// </summary>
        public CurrentDeferredAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Payments that will be assigned as expenses longer than one accounting period, but that are paid in advance and temporarily set up
    /// as non-current assets on the balance sheet.
    /// </summary>
    public class NonCurrentDeferredAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonCurrentDeferredAssetsBalanceSheet class
        /// </summary>
        public NonCurrentDeferredAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Asset, often applicable to Banks, which refers to the aggregate amount of all securities and investments.
    /// </summary>
    public class SecuritiesAndInvestmentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SecuritiesAndInvestmentsBalanceSheet class
        /// </summary>
        public SecuritiesAndInvestmentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Probable future sacrifices of economic benefits arising from present obligations of an enterprise to transfer assets or provide
    /// services to others in the future as a result of past transactions or events, excluding minority interest.
    /// </summary>
    public class TotalLiabilitiesNetMinorityInterestBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalLiabilitiesNetMinorityInterestBalanceSheet class
        /// </summary>
        public TotalLiabilitiesNetMinorityInterestBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total obligations, net minority interest, incurred as part of normal operations that is expected to be repaid beyond the following
    /// twelve months or one business cycle; excludes minority interest.
    /// </summary>
    public class TotalNonCurrentLiabilitiesNetMinorityInterestBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalNonCurrentLiabilitiesNetMinorityInterestBalanceSheet class
        /// </summary>
        public TotalNonCurrentLiabilitiesNetMinorityInterestBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Residual interest, including minority interest, that remains in the assets of the enterprise after deducting its liabilities. Equity is
    /// increased by owners' investments and by comprehensive income, and it is reduced by distributions to the owners.
    /// </summary>
    public class TotalEquityGrossMinorityInterestBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalEquityGrossMinorityInterestBalanceSheet class
        /// </summary>
        public TotalEquityGrossMinorityInterestBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Accounts owed to a company by customers within a year as a result of exchanging goods or services on credit.
    /// </summary>
    public class GrossAccountsReceivableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GrossAccountsReceivableBalanceSheet class
        /// </summary>
        public GrossAccountsReceivableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Accounts receivable represents sums owed to the business that the business records as revenue. Gross accounts receivable is
    /// accounts receivable before the business deducts uncollectable accounts to calculate the true value of accounts receivable.
    /// </summary>
    public class NonCurrentAccountsReceivableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonCurrentAccountsReceivableBalanceSheet class
        /// </summary>
        public NonCurrentAccountsReceivableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This account shows the amount of unpaid interest accrued to the date of purchase and included in the purchase price of securities
    /// purchased between interest dates.
    /// </summary>
    public class AccruedInterestReceivableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AccruedInterestReceivableBalanceSheet class
        /// </summary>
        public AccruedInterestReceivableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This item is typically available for bank industry. It's the amount of borrowings as of the balance sheet date from the Federal Home
    /// Loan Bank, which are primarily used to cover shortages in the required reserve balance and liquidity shortages.
    /// </summary>
    public class AdvanceFromFederalHomeLoanBanksBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AdvanceFromFederalHomeLoanBanksBalanceSheet class
        /// </summary>
        public AdvanceFromFederalHomeLoanBanksBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// An Allowance for Doubtful Accounts measures receivables recorded but not expected to be collected.
    /// </summary>
    public class AllowanceForDoubtfulAccountsReceivableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AllowanceForDoubtfulAccountsReceivableBalanceSheet class
        /// </summary>
        public AllowanceForDoubtfulAccountsReceivableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This item is typically available for bank industry. It represents a provision relating to a written agreement to receive money  with the
    /// terms of the note (at a specified future date(s) within one year from the reporting date (or the normal operating cycle, whichever is
    /// longer), consisting of principal as well as any accrued interest) for the portion that is expected to be uncollectible.
    /// </summary>
    public class AllowanceForNotesReceivableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AllowanceForNotesReceivableBalanceSheet class
        /// </summary>
        public AllowanceForNotesReceivableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This item is typically available for bank industry. It's a part of long-lived assets, which has been decided for sale in the future.
    /// </summary>
    public class AssetsHeldForSaleBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AssetsHeldForSaleBalanceSheet class
        /// </summary>
        public AssetsHeldForSaleBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A portion of a company's business that has been disposed of or sold.
    /// </summary>
    public class AssetsOfDiscontinuedOperationsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AssetsOfDiscontinuedOperationsBalanceSheet class
        /// </summary>
        public AssetsOfDiscontinuedOperationsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// All indebtedness for borrowed money or the deferred purchase price of property or services, including without limitation
    /// reimbursement and other obligations with respect to surety bonds and letters of credit, all obligations evidenced by notes, bonds
    /// debentures or similar instruments, all capital lease obligations and all contingent obligations. 
    /// </summary>
    public class BankIndebtednessBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the BankIndebtednessBalanceSheet class
        /// </summary>
        public BankIndebtednessBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The carrying amount of a life insurance policy on an officer, executive or employee for which the reporting entity (a bank) is entitled
    /// to proceeds from the policy upon death of the insured or surrender of the insurance policy.
    /// </summary>
    public class BankOwnedLifeInsuranceBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the BankOwnedLifeInsuranceBalanceSheet class
        /// </summary>
        public BankOwnedLifeInsuranceBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The securities borrowed or on loan, which is the temporary loan of securities by a lender to a borrower in exchange for cash.  This
    /// item is usually only available for bank industry.
    /// </summary>
    public class SecurityBorrowedBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SecurityBorrowedBalanceSheet class
        /// </summary>
        public SecurityBorrowedBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Fixed assets that specifically deal with the facilities a company owns. Include the improvements associated with buildings.
    /// </summary>
    public class BuildingsAndImprovementsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the BuildingsAndImprovementsBalanceSheet class
        /// </summary>
        public BuildingsAndImprovementsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Short-term loan, typically 90 days, used by a company to finance seasonal working capital needs.
    /// </summary>
    public class CommercialLoanBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CommercialLoanBalanceSheet class
        /// </summary>
        public CommercialLoanBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Commercial paper is a money-market security issued by large banks and corporations. It represents the current obligation for the
    /// company. There are four basic kinds of commercial paper: promissory notes, drafts, checks, and certificates of deposit. The
    /// maturities of these money market securities generally do not exceed 270 days.
    /// </summary>
    public class CommercialPaperBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CommercialPaperBalanceSheet class
        /// </summary>
        public CommercialPaperBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The portion of the Stockholders' Equity that reflects the amount of common stock, which are units of ownership.
    /// </summary>
    public class CommonStockEquityBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CommonStockEquityBalanceSheet class
        /// </summary>
        public CommonStockEquityBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// It represents carrying amount of long-lived asset under construction that includes construction costs to date on capital projects.
    /// Assets constructed, but not completed.
    /// </summary>
    public class ConstructionInProgressBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ConstructionInProgressBalanceSheet class
        /// </summary>
        public ConstructionInProgressBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A loan that establishes consumer credit that is granted for personal use; usually unsecured and based on the borrower's integrity
    /// and ability to pay.
    /// </summary>
    public class ConsumerLoanBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ConsumerLoanBalanceSheet class
        /// </summary>
        public ConsumerLoanBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The company's minimum pension obligations to its former employees, paid into a defined pension plan to satisfy all pension
    /// entitlements that have been earned by employees to date.
    /// </summary>
    public class MinimumPensionLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the MinimumPensionLiabilitiesBalanceSheet class
        /// </summary>
        public MinimumPensionLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Amounts receivable from customers on short-term negotiable time drafts drawn on and accepted by the institution (also known as
    /// banker's acceptance transactions) that are outstanding on the reporting date.
    /// </summary>
    public class CustomerAcceptancesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CustomerAcceptancesBalanceSheet class
        /// </summary>
        public CustomerAcceptancesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The recognition of an asset where pension fund assets exceed promised benefits.
    /// </summary>
    public class DefinedPensionBenefitBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DefinedPensionBenefitBalanceSheet class
        /// </summary>
        public DefinedPensionBenefitBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Fair values of all liabilities resulting from contracts that meet the criteria of being accounted for as derivative instruments; and
    /// which are expected to be extinguished or otherwise disposed of after one year or beyond the normal operating cycle.
    /// </summary>
    public class DerivativeProductLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DerivativeProductLiabilitiesBalanceSheet class
        /// </summary>
        public DerivativeProductLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Fair values of assets resulting from contracts that meet the criteria of being accounted for as derivative instruments, net of the
    /// effects of master netting arrangements.
    /// </summary>
    public class DerivativeAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DerivativeAssetsBalanceSheet class
        /// </summary>
        public DerivativeAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Sum of the carrying values of dividends declared but unpaid on equity securities issued and outstanding (also includes dividends
    /// collected on behalf of another owner of securities that are being held by entity) by the entity.
    /// </summary>
    public class DividendsPayableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DividendsPayableBalanceSheet class
        /// </summary>
        public DividendsPayableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Carrying amount as of the balance sheet date of the portion of the obligations recognized for the various benefits provided to former
    /// or inactive employees, their beneficiaries, and covered dependents after employment but before retirement.
    /// </summary>
    public class EmployeeBenefitsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the EmployeeBenefitsBalanceSheet class
        /// </summary>
        public EmployeeBenefitsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The amount borrowed by a bank, at the federal funds rate, from another bank to meet its reserve requirements.  This item is
    /// typically available for the bank industry.
    /// </summary>
    public class FederalFundsPurchasedBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FederalFundsPurchasedBalanceSheet class
        /// </summary>
        public FederalFundsPurchasedBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Federal funds transactions involve lending (federal funds sold) or borrowing (federal funds purchased) of immediately available
    /// reserve balances.  This item is typically available for the bank industry.
    /// </summary>
    public class FederalFundsSoldBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FederalFundsSoldBalanceSheet class
        /// </summary>
        public FederalFundsSoldBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Federal Home Loan Bank stock represents an equity interest in a FHLB. It does not have a readily determinable fair value because
    /// its ownership is restricted and it lacks a market (liquidity).  This item is typically available for the bank industry.
    /// </summary>
    public class FederalHomeLoanBankStockBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FederalHomeLoanBankStockBalanceSheet class
        /// </summary>
        public FederalHomeLoanBankStockBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Fair values as of the balance sheet date of all assets resulting from contracts that meet the criteria of being accounted for as
    /// derivative instruments, net of the effects of master netting arrangements.
    /// </summary>
    public class FinancialAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FinancialAssetsBalanceSheet class
        /// </summary>
        public FinancialAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The carrying value as of the balance sheet date of securities that an institution sells and agrees to repurchase (the identical or
    /// substantially the same securities) as a seller-borrower at a specified date for a specified price, also known as a repurchase
    /// agreement.  This item is typically available for bank industry.
    /// </summary>
    public class FinancialInstrumentsSoldUnderAgreementsToRepurchaseBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FinancialInstrumentsSoldUnderAgreementsToRepurchaseBalanceSheet class
        /// </summary>
        public FinancialInstrumentsSoldUnderAgreementsToRepurchaseBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The carrying amount as of the balance sheet date of merchandise or goods held by the company that are readily available for sale.
    /// This item is typically available for mining and manufacturing industries.
    /// </summary>
    public class FinishedGoodsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FinishedGoodsBalanceSheet class
        /// </summary>
        public FinishedGoodsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// It is one of the important fixed assets for transportation industry, which includes bicycles, cars, motorcycles, trains, ships, boats,
    /// and aircraft.  This item is typically available for transportation industry.
    /// </summary>
    public class FlightFleetVehicleAndRelatedEquipmentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FlightFleetVehicleAndRelatedEquipmentsBalanceSheet class
        /// </summary>
        public FlightFleetVehicleAndRelatedEquipmentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The carrying amount as of the balance sheet date of all assets obtained in full or partial satisfaction of a debt arrangement through
    /// foreclosure proceedings or defeasance; includes real and personal property; equity interests in corporations, partnerships, and joint
    /// ventures; and beneficial interest in trusts.  This item is typically typically available for bank industry.
    /// </summary>
    public class ForeclosedAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ForeclosedAssetsBalanceSheet class
        /// </summary>
        public ForeclosedAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Changes to accumulated comprehensive income that results from the process of translating subsidiary financial statements and
    /// foreign equity investments into functional currency of the reporting company.
    /// </summary>
    public class ForeignCurrencyTranslationAdjustmentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ForeignCurrencyTranslationAdjustmentsBalanceSheet class
        /// </summary>
        public ForeignCurrencyTranslationAdjustmentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This item represents certain charges made in the current period in inventory resulting from such factors as breakage, spoilage,
    /// employee theft and shoplifting. This item is typically available for manufacturing, mining and utility industries.
    /// </summary>
    public class InventoriesAdjustmentsAllowancesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InventoriesAdjustmentsAllowancesBalanceSheet class
        /// </summary>
        public InventoriesAdjustmentsAllowancesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This item represents the carrying amount on the company's balance sheet of its investments in common stock of an equity method.
    /// This item is typically available for the insurance industry.
    /// </summary>
    public class InvestmentsInOtherVenturesUnderEquityMethodBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InvestmentsInOtherVenturesUnderEquityMethodBalanceSheet class
        /// </summary>
        public InvestmentsInOtherVenturesUnderEquityMethodBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Fixed Assets that specifically deal with land a company owns. Includes the improvements associated with land. This excludes land
    /// held for sale.
    /// </summary>
    public class LandAndImprovementsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LandAndImprovementsBalanceSheet class
        /// </summary>
        public LandAndImprovementsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Carrying amount at the balance sheet date of a long-lived, depreciable asset that is an addition or improvement to assets held
    /// under lease arrangement. This item is usually not available for the insurance industry.
    /// </summary>
    public class LeasesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LeasesBalanceSheet class
        /// </summary>
        public LeasesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The obligations arising from the sale, disposal, or planned sale in the near future (generally within one year) of a disposal group,
    /// including a component of the entity (discontinued operation). This item is typically available for bank industry.
    /// </summary>
    public class LiabilitiesOfDiscontinuedOperationsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LiabilitiesOfDiscontinuedOperationsBalanceSheet class
        /// </summary>
        public LiabilitiesOfDiscontinuedOperationsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The carrying value as of the balance sheet date of obligations drawn from a line of credit, which is a bank's commitment to make
    /// loans up to a specific amount.
    /// </summary>
    public class LineOfCreditBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LineOfCreditBalanceSheet class
        /// </summary>
        public LineOfCreditBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// It means the aggregate amount of loans receivable that will be sold to other entities.  This item is typically available for bank
    /// industry.
    /// </summary>
    public class LoansHeldForSaleBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LoansHeldForSaleBalanceSheet class
        /// </summary>
        public LoansHeldForSaleBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Reflects the carrying amount of unpaid loans issued to other institutions for cash needs or an asset purchase.
    /// </summary>
    public class LoansReceivableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LoansReceivableBalanceSheet class
        /// </summary>
        public LoansReceivableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Fixed assets specifically dealing with tools, equipment and office furniture. This item is usually not available for the insurance and
    /// utility industries.
    /// </summary>
    public class MachineryFurnitureEquipmentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the MachineryFurnitureEquipmentBalanceSheet class
        /// </summary>
        public MachineryFurnitureEquipmentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Aggregated amount of unprocessed materials to be used in manufacturing or production process and supplies that will be
    /// consumed. This item is typically available for the utility industry.
    /// </summary>
    public class MaterialsAndSuppliesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the MaterialsAndSuppliesBalanceSheet class
        /// </summary>
        public MaterialsAndSuppliesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A fixed asset that represents strictly mineral type properties.  This item is typically available for mining industry.
    /// </summary>
    public class MineralPropertiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the MineralPropertiesBalanceSheet class
        /// </summary>
        public MineralPropertiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This is a lien on real estate to protect a lender.  This item is typically available for bank industry.
    /// </summary>
    public class MortgageLoanBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the MortgageLoanBalanceSheet class
        /// </summary>
        public MortgageLoanBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// It means the aggregate amount of mortgage and consumer loans.  This item is typically available for the insurance industry.
    /// </summary>
    public class MortgageAndConsumerloansBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the MortgageAndConsumerloansBalanceSheet class
        /// </summary>
        public MortgageAndConsumerloansBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// An amount representing an agreement for an unconditional promise by the maker to pay the entity (holder) a definite sum of money
    /// at a future date(s) within one year of the balance sheet date or the normal operating cycle. Such amount may include accrued
    /// interest receivable in accordance with the terms of the note. The note also may contain provisions including a discount or premium,
    /// payable on demand, secured, or unsecured, interest bearing or non-interest bearing, among myriad other features and
    /// characteristics. This item is typically available for bank industry.
    /// </summary>
    public class GrossNotesReceivableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the GrossNotesReceivableBalanceSheet class
        /// </summary>
        public GrossNotesReceivableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other non-current assets that are not otherwise classified.
    /// </summary>
    public class OtherAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherAssetsBalanceSheet class
        /// </summary>
        public OtherAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other Capital Stock that is not otherwise classified.
    /// </summary>
    public class OtherCapitalStockBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherCapitalStockBalanceSheet class
        /// </summary>
        public OtherCapitalStockBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other current assets that are not otherwise classified.
    /// </summary>
    public class OtherCurrentAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherCurrentAssetsBalanceSheet class
        /// </summary>
        public OtherCurrentAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Short Term Borrowings that are not otherwise classified.
    /// </summary>
    public class OtherCurrentBorrowingsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherCurrentBorrowingsBalanceSheet class
        /// </summary>
        public OtherCurrentBorrowingsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other adjustments to stockholders' equity that is not otherwise classified, including other reserves.
    /// </summary>
    public class OtherEquityAdjustmentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherEquityAdjustmentsBalanceSheet class
        /// </summary>
        public OtherEquityAdjustmentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other non-current inventories not otherwise classified.
    /// </summary>
    public class OtherInventoriesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherInventoriesBalanceSheet class
        /// </summary>
        public OtherInventoriesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// An item represents all the other investments or/and securities that cannot be defined into any category above. This item is typically
    /// available for the insurance industry.
    /// </summary>
    public class OtherInvestedAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherInvestedAssetsBalanceSheet class
        /// </summary>
        public OtherInvestedAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other non-current assets that are not otherwise classified.
    /// </summary>
    public class OtherNonCurrentAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherNonCurrentAssetsBalanceSheet class
        /// </summary>
        public OtherNonCurrentAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other fixed assets not otherwise classified.
    /// </summary>
    public class OtherPropertiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherPropertiesBalanceSheet class
        /// </summary>
        public OtherPropertiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The Carrying amount as of the balance sheet date of other real estate, which may include real estate investments, real estate loans
    /// that qualify as investments in real estate, and premises that are no longer used in operations may also be included in real estate
    /// owned. This does not include real estate assets taken in settlement of troubled loans through surrender or foreclosure.  This item is
    /// typically available for bank industry.
    /// </summary>
    public class OtherRealEstateOwnedBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherRealEstateOwnedBalanceSheet class
        /// </summary>
        public OtherRealEstateOwnedBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other non-current receivables not otherwise classified.
    /// </summary>
    public class OtherReceivablesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherReceivablesBalanceSheet class
        /// </summary>
        public OtherReceivablesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A loan issued by an insurance company that uses the cash value of a person's life insurance policy as collateral.  This item is usually
    /// only available in the insurance industry.
    /// </summary>
    public class NonCurrentPensionAndOtherPostretirementBenefitPlansBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonCurrentPensionAndOtherPostretirementBenefitPlansBalanceSheet class
        /// </summary>
        public NonCurrentPensionAndOtherPostretirementBenefitPlansBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A loan issued by an insurance company that uses the cash value of a person's life insurance policy as collateral. This item is usually
    /// only available for insurance industry.
    /// </summary>
    public class PolicyLoansBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PolicyLoansBalanceSheet class
        /// </summary>
        public PolicyLoansBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A class of ownership in a company that has a higher claim on the assets and earnings than common stock. Preferred stock
    /// generally has a dividend that must be paid out before dividends to common stockholders and the shares usually do not have voting
    /// rights.
    /// </summary>
    public class PreferredStockEquityBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PreferredStockEquityBalanceSheet class
        /// </summary>
        public PreferredStockEquityBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Tangible assets that are held by an entity for use in the production or supply of goods and services, for rental to others, or for
    /// administrative purposes and that are expected to provide economic benefit for more than one year. This item is available for
    /// manufacturing, bank and transportation industries.
    /// </summary>
    public class PropertiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PropertiesBalanceSheet class
        /// </summary>
        public PropertiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Provisions are created to protect the interests of one or both parties named in a contract or legal document which is a preparatory
    /// action or measure. Current provision is expired within one accounting PeriodAsByte.
    /// </summary>
    public class CurrentProvisionsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CurrentProvisionsBalanceSheet class
        /// </summary>
        public CurrentProvisionsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Provisions are created to protect the interests of one or both parties named in a contract or legal document which is a preparatory
    /// action or measure. Long-term provision is expired beyond one accounting PeriodAsByte.
    /// </summary>
    public class LongTermProvisionsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LongTermProvisionsBalanceSheet class
        /// </summary>
        public LongTermProvisionsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Carrying amount as of the balance sheet data of unprocessed items to be consumed in the manufacturing or production process.
    /// This item is available for manufacturing and mining industries.
    /// </summary>
    public class RawMaterialsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the RawMaterialsBalanceSheet class
        /// </summary>
        public RawMaterialsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A provision relating to a written agreement to receive money at a specified future date(s) (within one year from the reporting date
    /// or the normal operating cycle, whichever is longer), consisting of principal as well as any accrued interest).
    /// </summary>
    public class ReceivablesAdjustmentsAllowancesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ReceivablesAdjustmentsAllowancesBalanceSheet class
        /// </summary>
        public ReceivablesAdjustmentsAllowancesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Carrying amount as of the balance sheet date of capitalized costs of regulated entities that are expected to be recovered through
    /// revenue sources over one year or beyond the normal operating cycle.
    /// </summary>
    public class RegulatoryAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the RegulatoryAssetsBalanceSheet class
        /// </summary>
        public RegulatoryAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The amount for the individual regulatory noncurrent liability as itemized in a table of regulatory noncurrent liabilities as of the end of
    /// the PeriodAsByte. Such things as the costs of energy efficiency programs and low-income energy assistances programs and deferred fuel.
    /// This item is usually only available for utility industry.
    /// </summary>
    public class RegulatoryLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the RegulatoryLiabilitiesBalanceSheet class
        /// </summary>
        public RegulatoryLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The carrying amount as of the balance sheet date of the known and estimated amounts owed to insurers under reinsurance
    /// treaties or other arrangements. This item is usually only available for insurance industry.
    /// </summary>
    public class ReinsuranceBalancesPayableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ReinsuranceBalancesPayableBalanceSheet class
        /// </summary>
        public ReinsuranceBalancesPayableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The carrying amounts of cash and cash equivalent items, which are restricted as to withdrawal or usage. Restrictions may include
    /// legally restricted deposits held as compensating balances against short-term borrowing arrangements, contracts entered into with
    /// others, or entity statements of intention with regard to particular deposits; however, time deposits and short-term certificates of
    /// deposit are not generally included in legally restricted deposits. Excludes compensating balance arrangements that are not
    /// agreements, which legally restrict the use of cash amounts shown on the balance sheet. For a classified balance sheet, represents
    /// the current portion only (the non-current portion has a separate concept); for an unclassified balance sheet represents the entire
    /// amount. This item is usually not available for bank and insurance industries.
    /// </summary>
    public class RestrictedCashBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the RestrictedCashBalanceSheet class
        /// </summary>
        public RestrictedCashBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The carrying amounts of cash and cash equivalent items which are restricted as to withdrawal or usage. This item is available for
    /// bank and insurance industries.
    /// </summary>
    public class RestrictedCashAndCashEquivalentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the RestrictedCashAndCashEquivalentsBalanceSheet class
        /// </summary>
        public RestrictedCashAndCashEquivalentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The cash and investments whose use in whole or in part is restricted for the long-term, generally by contractual agreements or
    /// regulatory requirements. This item is usually only available for bank industry.
    /// </summary>
    public class RestrictedCashAndInvestmentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the RestrictedCashAndInvestmentsBalanceSheet class
        /// </summary>
        public RestrictedCashAndInvestmentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Shares of stock for which sale is contractually or governmentally restricted for a given period of time. Stock that is acquired through
    /// an employee stock option plan or other private means may not be transferred. Restricted stock must be traded in compliance with
    /// special SEC regulations.
    /// </summary>
    public class RestrictedCommonStockBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the RestrictedCommonStockBalanceSheet class
        /// </summary>
        public RestrictedCommonStockBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Investments whose use is restricted in whole or in part, generally by contractual agreements or regulatory requirements. This item
    /// is usually only available for bank industry.
    /// </summary>
    public class RestrictedInvestmentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the RestrictedInvestmentsBalanceSheet class
        /// </summary>
        public RestrictedInvestmentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Carrying amount due within one year of the balance sheet date (or one operating cycle, if longer) from tax authorities as of the
    /// balance sheet date representing refunds of overpayments or recoveries based on agreed-upon resolutions of disputes. This item is
    /// usually not available for bank industry.
    /// </summary>
    public class TaxesReceivableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TaxesReceivableBalanceSheet class
        /// </summary>
        public TaxesReceivableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Stockholder's Equity plus Long Term Debt.
    /// </summary>
    public class TotalCapitalizationBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalCapitalizationBalanceSheet class
        /// </summary>
        public TotalCapitalizationBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Revenue received by a firm but not yet reported as income.  This item is usually only available for utility industry.
    /// </summary>
    public class TotalDeferredCreditsAndOtherNonCurrentLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalDeferredCreditsAndOtherNonCurrentLiabilitiesBalanceSheet class
        /// </summary>
        public TotalDeferredCreditsAndOtherNonCurrentLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Revenues that are not currently billed from the customer under the terms of the contract.  This item is usually only available for
    /// utility industry.
    /// </summary>
    public class UnbilledReceivablesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the UnbilledReceivablesBalanceSheet class
        /// </summary>
        public UnbilledReceivablesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A profit or loss that results from holding onto an asset rather than cashing it in and officially taking the profit or loss.
    /// </summary>
    public class UnrealizedGainLossBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the UnrealizedGainLossBalanceSheet class
        /// </summary>
        public UnrealizedGainLossBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Work, or goods, in the process of being fabricated or manufactured but not yet completed as finished goods. This item is usually
    /// available for manufacturing and mining industries.
    /// </summary>
    public class WorkInProcessBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the WorkInProcessBalanceSheet class
        /// </summary>
        public WorkInProcessBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This item is usually not available for bank and insurance industries.
    /// </summary>
    public class OtherNonCurrentLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherNonCurrentLiabilitiesBalanceSheet class
        /// </summary>
        public OtherNonCurrentLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Current Portion of Capital Lease Obligation plus Long Term Portion of Capital Lease Obligation.
    /// </summary>
    public class CapitalLeaseObligationsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CapitalLeaseObligationsBalanceSheet class
        /// </summary>
        public CapitalLeaseObligationsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This item is available for bank and insurance industries.
    /// </summary>
    public class OtherLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherLiabilitiesBalanceSheet class
        /// </summary>
        public OtherLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Payables and Accrued Expenses that are not defined as Trade, Tax or Dividends related.
    /// </summary>
    public class OtherPayableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherPayableBalanceSheet class
        /// </summary>
        public OtherPayableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The company's total book value less the value of any intangible assets.
    /// Methodology: Common Stock Equity minus Goodwill and Other Intangible Assets
    /// </summary>
    public class TangibleBookValueBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TangibleBookValueBalanceSheet class
        /// </summary>
        public TangibleBookValueBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total Equity equals Preferred Stock Equity + Common Stock Equity.
    /// </summary>
    public class TotalEquityBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalEquityBalanceSheet class
        /// </summary>
        public TotalEquityBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Current Assets minus Current Liabilities.  This item is usually not available for bank and insurance industries.
    /// </summary>
    public class WorkingCapitalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the WorkingCapitalBalanceSheet class
        /// </summary>
        public WorkingCapitalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// All borrowings incurred by the company including debt and capital lease obligations.
    /// </summary>
    public class TotalDebtBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalDebtBalanceSheet class
        /// </summary>
        public TotalDebtBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The amount for the other plant related to the utility industry fix assets.
    /// </summary>
    public class CommonUtilityPlantBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CommonUtilityPlantBalanceSheet class
        /// </summary>
        public CommonUtilityPlantBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The amount for the electric plant related to the utility industry.
    /// </summary>
    public class ElectricUtilityPlantBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ElectricUtilityPlantBalanceSheet class
        /// </summary>
        public ElectricUtilityPlantBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The amount for the natural gas, fuel and other items related to the utility industry, which might include oil and gas wells, the
    /// properties to exploit oil and gas or liquefied natural gas sites.
    /// </summary>
    public class NaturalGasFuelAndOtherBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NaturalGasFuelAndOtherBalanceSheet class
        /// </summary>
        public NaturalGasFuelAndOtherBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Net utility plant might include water production, electric utility plan, natural gas, fuel and other, common utility plant and
    /// accumulated depreciation. This item is usually only available for utility industry.
    /// </summary>
    public class NetUtilityPlantBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetUtilityPlantBalanceSheet class
        /// </summary>
        public NetUtilityPlantBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The amount for a facility and plant that provides water which might include wells, reservoirs, pumping stations, and control
    /// facilities; and waste water systems which includes the waste treatment and disposal facility and equipment. This item is usually
    /// only available for utility industry.
    /// </summary>
    public class WaterProductionBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the WaterProductionBalanceSheet class
        /// </summary>
        public WaterProductionBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Number of Common or Ordinary Shares.
    /// </summary>
    public class OrdinarySharesNumberBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OrdinarySharesNumberBalanceSheet class
        /// </summary>
        public OrdinarySharesNumberBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Number of Preferred Shares.
    /// </summary>
    public class PreferredSharesNumberBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PreferredSharesNumberBalanceSheet class
        /// </summary>
        public PreferredSharesNumberBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Number of Treasury Shares.
    /// </summary>
    public class TreasurySharesNumberBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TreasurySharesNumberBalanceSheet class
        /// </summary>
        public TreasurySharesNumberBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This will serve as the "parent" value to AccountsReceivable (DataId 23001) and OtherReceivables (DataId 23342) for all company
    /// financials reported in the IFRS GAAP.
    /// </summary>
    public class TradingAndOtherReceivableBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TradingAndOtherReceivableBalanceSheet class
        /// </summary>
        public TradingAndOtherReceivableBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// </summary>
    public class EquityAttributableToOwnersOfParentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the EquityAttributableToOwnersOfParentBalanceSheet class
        /// </summary>
        public EquityAttributableToOwnersOfParentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The carrying value as of the balance sheet date of securities loaned to other broker dealers, typically used by such parties to cover
    /// short sales, secured by cash or other securities furnished by such parties until the borrowing is closed.
    /// </summary>
    public class SecuritiesLoanedBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SecuritiesLoanedBalanceSheet class
        /// </summary>
        public SecuritiesLoanedBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Net assets in physical form. This is calculated using Stockholders' Equity less Intangible Assets (including Goodwill).
    /// </summary>
    public class NetTangibleAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the OneMonth period value for the field
        /// </summary>
        [JsonProperty(Period.OneMonth)]
        public decimal OneMonth
        {
            get { return GetPeriodValue(PeriodAsByte.OneMonth); }
            set { SetPeriodValue(PeriodAsByte.OneMonth, value); }
        }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the SixMonths period value for the field
        /// </summary>
        [JsonProperty(Period.SixMonths)]
        public decimal SixMonths
        {
            get { return GetPeriodValue(PeriodAsByte.SixMonths); }
            set { SetPeriodValue(PeriodAsByte.SixMonths, value); }
        }

        /// <summary>
        /// Gets/sets the NineMonths period value for the field
        /// </summary>
        [JsonProperty(Period.NineMonths)]
        public decimal NineMonths
        {
            get { return GetPeriodValue(PeriodAsByte.NineMonths); }
            set { SetPeriodValue(PeriodAsByte.NineMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NetTangibleAssetsBalanceSheet class
        /// </summary>
        public NetTangibleAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Amounts owed to the company from a non-arm's length entity, due within the company's current operating cycle.
    /// </summary>
    public class DuefromRelatedPartiesCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DuefromRelatedPartiesCurrentBalanceSheet class
        /// </summary>
        public DuefromRelatedPartiesCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Amounts owed to the company from a non-arm's length entity, due after the company's current operating cycle.
    /// </summary>
    public class DuefromRelatedPartiesNonCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DuefromRelatedPartiesNonCurrentBalanceSheet class
        /// </summary>
        public DuefromRelatedPartiesNonCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Amounts owed by the company to a non-arm's length entity.
    /// </summary>
    public class DuetoRelatedPartiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DuetoRelatedPartiesBalanceSheet class
        /// </summary>
        public DuetoRelatedPartiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Amounts owed by the company to a non-arm's length entity that has to be repaid within the company's current operating cycle.
    /// </summary>
    public class DuetoRelatedPartiesCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DuetoRelatedPartiesCurrentBalanceSheet class
        /// </summary>
        public DuetoRelatedPartiesCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Amounts owed by the company to a non-arm's length entity that has to be repaid after the company's current operating cycle.
    /// </summary>
    public class DuetoRelatedPartiesNonCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DuetoRelatedPartiesNonCurrentBalanceSheet class
        /// </summary>
        public DuetoRelatedPartiesNonCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Company's investments in properties net of accumulated depreciation, which generate a return.
    /// </summary>
    public class InvestmentPropertiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InvestmentPropertiesBalanceSheet class
        /// </summary>
        public InvestmentPropertiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A stake in any company which is more than 51%.
    /// </summary>
    public class InvestmentsinSubsidiariesatCostBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InvestmentsinSubsidiariesatCostBalanceSheet class
        /// </summary>
        public InvestmentsinSubsidiariesatCostBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A stake in any company which is more than 20% but less than 50%.
    /// </summary>
    public class InvestmentsinAssociatesatCostBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InvestmentsinAssociatesatCostBalanceSheet class
        /// </summary>
        public InvestmentsinAssociatesatCostBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A 50% stake in any company in which remaining 50% belongs to other company.
    /// </summary>
    public class InvestmentsinJointVenturesatCostBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InvestmentsinJointVenturesatCostBalanceSheet class
        /// </summary>
        public InvestmentsinJointVenturesatCostBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represents the sum of all financial investments (trading securities, available-for-sale securities, held-to-maturity securities, etc.)
    /// </summary>
    public class InvestmentinFinancialAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InvestmentinFinancialAssetsBalanceSheet class
        /// </summary>
        public InvestmentinFinancialAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Accounts owed to the bank in relation to capital leases. Capital/ finance lease obligation are contractual obligations that arise from
    /// obtaining the use of property or equipment via a capital lease contract.
    /// </summary>
    public class FinanceLeaseReceivablesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FinanceLeaseReceivablesBalanceSheet class
        /// </summary>
        public FinanceLeaseReceivablesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// This represents loans that entitle the lender (or the holder of loan debenture) to convert the loan to common or preferred stock
    /// (ordinary or preference shares) within the next 12 months or operating cycle.
    /// </summary>
    public class ConvertibleLoansCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ConvertibleLoansCurrentBalanceSheet class
        /// </summary>
        public ConvertibleLoansCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A debt financing obligation issued by a bank or similar financial institution to a company, that entitles the lender or holder of the
    /// instrument to interest payments and the repayment of principal at a specified time within the next 12 months or operating cycle.
    /// </summary>
    public class BankLoansCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the BankLoansCurrentBalanceSheet class
        /// </summary>
        public BankLoansCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other loans between the customer and bank which cannot be identified by other specific items in the Debt section, due within the
    /// next 12 months or operating cycle.
    /// </summary>
    public class OtherLoansCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherLoansCurrentBalanceSheet class
        /// </summary>
        public OtherLoansCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Sum of accrued liabilities and deferred income (amount received in advance but the services are not provided in respect of
    /// amount).
    /// </summary>
    public class AccruedandDeferredIncomeBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AccruedandDeferredIncomeBalanceSheet class
        /// </summary>
        public AccruedandDeferredIncomeBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A debt financing obligation issued by a bank or similar financial institution to a company, that entitles the lender or holder of the
    /// instrument to interest payments and the repayment of principal at a specified time beyond the current accounting PeriodAsByte.
    /// </summary>
    public class BankLoansNonCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the BankLoansNonCurrentBalanceSheet class
        /// </summary>
        public BankLoansNonCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other loans between the customer and bank which cannot be identified by other specific items in the Debt section, due beyond the
    /// current operating cycle.
    /// </summary>
    public class OtherLoansNonCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherLoansNonCurrentBalanceSheet class
        /// </summary>
        public OtherLoansNonCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other reserves owned by the company that cannot be identified by other specific items in the Reserves section.
    /// </summary>
    public class OtherReservesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherReservesBalanceSheet class
        /// </summary>
        public OtherReservesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of loans and advances made to a bank or financial institution.
    /// </summary>
    public class LoansandAdvancestoBankBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LoansandAdvancestoBankBalanceSheet class
        /// </summary>
        public LoansandAdvancestoBankBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The aggregate amount of loans and advances made to customers.
    /// </summary>
    public class LoansandAdvancestoCustomerBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LoansandAdvancestoCustomerBalanceSheet class
        /// </summary>
        public LoansandAdvancestoCustomerBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Investments backed by the central government, it usually carries less risk than other investments.
    /// </summary>
    public class TreasuryBillsandOtherEligibleBillsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TreasuryBillsandOtherEligibleBillsBalanceSheet class
        /// </summary>
        public TreasuryBillsandOtherEligibleBillsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Investments in shares of a company representing ownership in that company.
    /// </summary>
    public class EquitySharesInvestmentsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the EquitySharesInvestmentsBalanceSheet class
        /// </summary>
        public EquitySharesInvestmentsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Banks investment in the ongoing entity.
    /// </summary>
    public class DepositsbyBankBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DepositsbyBankBalanceSheet class
        /// </summary>
        public DepositsbyBankBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Carrying value of amounts transferred by customers to third parties for security purposes that are expected to be returned or
    /// applied towards payment after one year or beyond the operating cycle, if longer.
    /// </summary>
    public class CustomerAccountsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the CustomerAccountsBalanceSheet class
        /// </summary>
        public CustomerAccountsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Carrying amount as of the balance sheet date of drafts and bills of exchange that have been accepted by the reporting bank or by
    /// others for its own account, as its liability to holders of the drafts.
    /// </summary>
    public class ItemsinTheCourseofTransmissiontoOtherBanksBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ItemsinTheCourseofTransmissiontoOtherBanksBalanceSheet class
        /// </summary>
        public ItemsinTheCourseofTransmissiontoOtherBanksBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total carrying amount of total trading, financial liabilities and debt in a non-differentiated balance sheet.
    /// </summary>
    public class TradingandFinancialLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TradingandFinancialLiabilitiesBalanceSheet class
        /// </summary>
        public TradingandFinancialLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Any debt financial instrument issued instead of cash loan.
    /// </summary>
    public class DebtSecuritiesinIssueBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DebtSecuritiesinIssueBalanceSheet class
        /// </summary>
        public DebtSecuritiesinIssueBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// The total carrying value of securities loaned to other broker dealers, typically used by such parties to cover short sales, secured by
    /// cash or other securities furnished by such parties until the borrowing is closed; in a Non-Differentiated Balance Sheet.
    /// </summary>
    public class SubordinatedLiabilitiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the SubordinatedLiabilitiesBalanceSheet class
        /// </summary>
        public SubordinatedLiabilitiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Provisions are created to protect the interests of one or both parties named in a contract or legal document, which is a preparatory
    /// action or measure. Current provision is expired within one accounting PeriodAsByte.
    /// </summary>
    public class ProvisionsTotalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ProvisionsTotalBalanceSheet class
        /// </summary>
        public ProvisionsTotalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A contract that allows for the use of an asset, but does not convey rights of ownership of the asset. An operating lease is not
    /// capitalized; it is accounted for as a rental expense in what is known as "off balance sheet financing." For the lessor, the asset being
    /// leased is accounted for as an asset and is depreciated as such.
    /// </summary>
    public class OperatingLeaseAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OperatingLeaseAssetsBalanceSheet class
        /// </summary>
        public OperatingLeaseAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Amounts owing to policy holders who have filed claims but have not yet been settled or paid.
    /// </summary>
    public class ClaimsOutstandingBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ClaimsOutstandingBalanceSheet class
        /// </summary>
        public ClaimsOutstandingBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Liabilities due within the next 12 months related from an asset classified as Held for Sale.
    /// </summary>
    public class LiabilitiesHeldforSaleCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LiabilitiesHeldforSaleCurrentBalanceSheet class
        /// </summary>
        public LiabilitiesHeldforSaleCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Liabilities related to an asset classified as held for sale excluding the portion due the next 12 months or operating cycle.
    /// </summary>
    public class LiabilitiesHeldforSaleNonCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the LiabilitiesHeldforSaleNonCurrentBalanceSheet class
        /// </summary>
        public LiabilitiesHeldforSaleNonCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Debt securities held as investments.
    /// </summary>
    public class DebtSecuritiesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DebtSecuritiesBalanceSheet class
        /// </summary>
        public DebtSecuritiesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Represents the total amount of long-term capital leases that must be paid within the next accounting period for a Non-
    /// Differentiated Balance Sheet. Capital lease obligations are contractual obligations that arise from obtaining the use of property or
    /// equipment via a capital lease contract.
    /// </summary>
    public class TotalFinancialLeaseObligationsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TotalFinancialLeaseObligationsBalanceSheet class
        /// </summary>
        public TotalFinancialLeaseObligationsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Sum of Accrued Liabilities and Deferred Income (amount received in advance but the services are not provided in respect of
    /// amount) due within 1 year.
    /// </summary>
    public class AccruedandDeferredIncomeCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AccruedandDeferredIncomeCurrentBalanceSheet class
        /// </summary>
        public AccruedandDeferredIncomeCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Sum of Accrued Liabilities and Deferred Income (amount received in advance but the services are not provided in respect of
    /// amount) due after 1 year.
    /// </summary>
    public class AccruedandDeferredIncomeNonCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AccruedandDeferredIncomeNonCurrentBalanceSheet class
        /// </summary>
        public AccruedandDeferredIncomeNonCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Accounts owed to the bank in relation to capital leases to be received within the next accounting PeriodAsByte. Capital/ finance lease
    /// obligations are contractual obligations that arise from obtaining the use of property or equipment via a capital lease contract.
    /// </summary>
    public class FinanceLeaseReceivablesCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FinanceLeaseReceivablesCurrentBalanceSheet class
        /// </summary>
        public FinanceLeaseReceivablesCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Accounts owed to the bank in relation to capital leases to be received beyond the next accounting PeriodAsByte. Capital/ finance lease
    /// obligations are contractual obligations that arise from obtaining the use of property or equipment via a capital lease contract.
    /// </summary>
    public class FinanceLeaseReceivablesNonCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FinanceLeaseReceivablesNonCurrentBalanceSheet class
        /// </summary>
        public FinanceLeaseReceivablesNonCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Financial related liabilities due within one year, including short term and current portions of long-term debt, capital leases and
    /// derivative liabilities.
    /// </summary>
    public class FinancialLiabilitiesCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FinancialLiabilitiesCurrentBalanceSheet class
        /// </summary>
        public FinancialLiabilitiesCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Financial related liabilities due beyond one year, including long term debt, capital leases and derivative liabilities.
    /// </summary>
    public class FinancialLiabilitiesNonCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FinancialLiabilitiesNonCurrentBalanceSheet class
        /// </summary>
        public FinancialLiabilitiesNonCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Financial assets that are held at fair value through profit or loss comprise assets held for trading and those financial assets
    /// designated as being held at fair value through profit or loss.
    /// </summary>
    public class FinancialAssetsDesignatedasFairValueThroughProfitorLossTotalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FinancialAssetsDesignatedasFairValueThroughProfitorLossTotalBalanceSheet class
        /// </summary>
        public FinancialAssetsDesignatedasFairValueThroughProfitorLossTotalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Carrying amount due within one year of the balance sheet date (or one operating cycle, if longer) from tax authorities as of the
    /// balance sheet date representing refunds of overpayments or recoveries based on agreed-upon resolutions of disputes, and current
    /// deferred tax assets.
    /// </summary>
    public class TaxesAssetsCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TaxesAssetsCurrentBalanceSheet class
        /// </summary>
        public TaxesAssetsCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other equity instruments issued by the company that cannot be identified by other specific items in the Equity section.
    /// </summary>
    public class OtherEquityInterestBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherEquityInterestBalanceSheet class
        /// </summary>
        public OtherEquityInterestBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Carrying amount of any interest-bearing loan which is due after one year.
    /// </summary>
    public class InterestBearingBorrowingsNonCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the InterestBearingBorrowingsNonCurrentBalanceSheet class
        /// </summary>
        public InterestBearingBorrowingsNonCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Non-interest bearing borrowings due after a year.
    /// </summary>
    public class NonInterestBearingBorrowingsNonCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonInterestBearingBorrowingsNonCurrentBalanceSheet class
        /// </summary>
        public NonInterestBearingBorrowingsNonCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Sum of all non-current payables and accrued expenses.
    /// </summary>
    public class TradeandOtherPayablesNonCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TradeandOtherPayablesNonCurrentBalanceSheet class
        /// </summary>
        public TradeandOtherPayablesNonCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Non-interest bearing deposits in other financial institutions for short periods of time, usually less than 12 months.
    /// </summary>
    public class NonInterestBearingBorrowingsCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonInterestBearingBorrowingsCurrentBalanceSheet class
        /// </summary>
        public NonInterestBearingBorrowingsCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total of the carrying values as of the balance sheet date of obligations incurred through that date and payable for obligations related
    /// to services received from employees, such as accrued salaries and bonuses, payroll taxes and fringe benefits.
    /// </summary>
    public class PensionandOtherPostRetirementBenefitPlansCurrentBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the PensionandOtherPostRetirementBenefitPlansCurrentBalanceSheet class
        /// </summary>
        public PensionandOtherPostRetirementBenefitPlansCurrentBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Reflects the carrying amount of any other unpaid loans, an asset of the bank.
    /// </summary>
    public class OtherLoanAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherLoanAssetsBalanceSheet class
        /// </summary>
        public OtherLoanAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Total value collateral assets pledged to the bank that can be sold or used as collateral for other loans.
    /// </summary>
    public class AssetsPledgedasCollateralSubjecttoSaleorRepledgingTotalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AssetsPledgedasCollateralSubjecttoSaleorRepledgingTotalBalanceSheet class
        /// </summary>
        public AssetsPledgedasCollateralSubjecttoSaleorRepledgingTotalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Sum of total tax assets in a Non-Differentiated Balance Sheet, includes Tax Receivables and Deferred Tax Assets.
    /// </summary>
    public class TaxAssetsTotalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the TaxAssetsTotalBalanceSheet class
        /// </summary>
        public TaxAssetsTotalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Borrowings from the central bank, which are primarily used to cover shortages in the required reserve balance and liquidity
    /// shortages.
    /// </summary>
    public class AdvancesfromCentralBanksBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AdvancesfromCentralBanksBalanceSheet class
        /// </summary>
        public AdvancesfromCentralBanksBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A savings certificate entitling the bearer to receive interest. A CD bears a maturity date, a specified fixed interest rate and can be
    /// issued in any denomination.
    /// </summary>
    public class DepositCertificatesBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DepositCertificatesBalanceSheet class
        /// </summary>
        public DepositCertificatesBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Non-interest bearing deposits in other financial institutions for relatively short periods of time; on a Non-Differentiated Balance
    /// Sheet.
    /// </summary>
    public class NonInterestBearingBorrowingsTotalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the NonInterestBearingBorrowingsTotalBalanceSheet class
        /// </summary>
        public NonInterestBearingBorrowingsTotalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Other borrowings by the bank to fund its activities that cannot be identified by other specific items in the Liabilities section.
    /// </summary>
    public class OtherBorrowedFundsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the OtherBorrowedFundsBalanceSheet class
        /// </summary>
        public OtherBorrowedFundsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Financial liabilities that are held at fair value through profit or loss.
    /// </summary>
    public class FinancialLiabilitiesDesignatedasFairValueThroughProfitorLossTotalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FinancialLiabilitiesDesignatedasFairValueThroughProfitorLossTotalBalanceSheet class
        /// </summary>
        public FinancialLiabilitiesDesignatedasFairValueThroughProfitorLossTotalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Financial liabilities carried at amortized cost.
    /// </summary>
    public class FinancialLiabilitiesMeasuredatAmortizedCostTotalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the FinancialLiabilitiesMeasuredatAmortizedCostTotalBalanceSheet class
        /// </summary>
        public FinancialLiabilitiesMeasuredatAmortizedCostTotalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Liabilities which have occurred, but have not been paid or logged under accounts payable during an accounting PeriodAsByte. In other
    /// words, obligations for goods and services provided to a company for which invoices have not yet been received; on a Non-
    /// Differentiated Balance Sheet.
    /// </summary>
    public class AccruedLiabilitiesTotalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the TwoMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwoMonths)]
        public decimal TwoMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwoMonths); }
            set { SetPeriodValue(PeriodAsByte.TwoMonths, value); }
        }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the AccruedLiabilitiesTotalBalanceSheet class
        /// </summary>
        public AccruedLiabilitiesTotalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Collections of cash or other assets related to revenue producing activity for which revenue has not yet been recognized on a Non-
    /// Differentiated Balance Sheet.
    /// </summary>
    public class DeferredIncomeTotalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DeferredIncomeTotalBalanceSheet class
        /// </summary>
        public DeferredIncomeTotalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// A future tax liability, resulting from temporary differences between book (accounting) value of assets and liabilities and their tax
    /// value or timing differences between the recognition of gains and losses in financial statements, on a Non-Differentiated Balance
    /// Sheet.
    /// </summary>
    public class DeferredTaxLiabilitiesTotalBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the DeferredTaxLiabilitiesTotalBalanceSheet class
        /// </summary>
        public DeferredTaxLiabilitiesTotalBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    }

    /// <summary>
    /// Reinsurance asset is insurance that is purchased by an insurance company from another insurance company.
    /// </summary>
    public class ReinsuranceAssetsBalanceSheet : MultiPeriodField
    {
        /// <summary>
        /// Gets the default period for the field
        /// </summary>
        protected override byte DefaultPeriod { get { return PeriodAsByte.TwelveMonths; } }

        /// <summary>
        /// Gets/sets the ThreeMonths period value for the field
        /// </summary>
        [JsonProperty(Period.ThreeMonths)]
        public decimal ThreeMonths
        {
            get { return GetPeriodValue(PeriodAsByte.ThreeMonths); }
            set { SetPeriodValue(PeriodAsByte.ThreeMonths, value); }
        }

        /// <summary>
        /// Gets/sets the TwelveMonths period value for the field
        /// </summary>
        [JsonProperty(Period.TwelveMonths)]
        public decimal TwelveMonths
        {
            get { return GetPeriodValue(PeriodAsByte.TwelveMonths); }
            set { SetPeriodValue(PeriodAsByte.TwelveMonths, value); }
        }

        /// <summary>
        /// Creates an instance of the ReinsuranceAssetsBalanceSheet class
        /// </summary>
        public ReinsuranceAssetsBalanceSheet(IDictionary<string, decimal> store = null)
            : base(store)
        {
        }
    