/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// Representation of how many units of an Instrument are available to be traded by an Order depending on its postionFill option.
    /// </summary>
    [DataContract]
    public partial class UnitsAvailable :  IEquatable<UnitsAvailable>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="UnitsAvailable" /> class.
        /// </summary>
        /// <param name="_Default">_Default.</param>
        /// <param name="ReduceFirst">ReduceFirst.</param>
        /// <param name="ReduceOnly">ReduceOnly.</param>
        /// <param name="OpenOnly">OpenOnly.</param>
        public UnitsAvailable(UnitsAvailableDetails _Default = default(UnitsAvailableDetails), UnitsAvailableDetails ReduceFirst = default(UnitsAvailableDetails), UnitsAvailableDetails ReduceOnly = default(UnitsAvailableDetails), UnitsAvailableDetails OpenOnly = default(UnitsAvailableDetails))
        {
            this._Default = _Default;
            this.ReduceFirst = ReduceFirst;
            this.ReduceOnly = ReduceOnly;
            this.OpenOnly = OpenOnly;
        }
        
        /// <summary>
        /// Gets or Sets _Default
        /// </summary>
        [DataMember(Name="default", EmitDefaultValue=false)]
        public UnitsAvailableDetails _Default { get; set; }
        /// <summary>
        /// Gets or Sets ReduceFirst
        /// </summary>
        [DataMember(Name="reduceFirst", EmitDefaultValue=false)]
        public UnitsAvailableDetails ReduceFirst { get; set; }
        /// <summary>
        /// Gets or Sets ReduceOnly
        /// </summary>
        [DataMember(Name="reduceOnly", EmitDefaultValue=false)]
        public UnitsAvailableDetails ReduceOnly { get; set; }
        /// <summary>
        /// Gets or Sets OpenOnly
        /// </summary>
        [DataMember(Name="openOnly", EmitDefaultValue=false)]
        public UnitsAvailableDetails OpenOnly { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class UnitsAvailable {\n");
            sb.Append("  _Default: ").Append(_Default).Append("\n");
            sb.Append("  ReduceFirst: ").Append(ReduceFirst).Append("\n");
            sb.Append("  ReduceOnly: ").Append(ReduceOnly).Append("\n");
            sb.Append("  OpenOnly: ").Append(OpenOnly).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as UnitsAvailable);
        }

        /// <summary>
        /// Returns true if UnitsAvailable instances are equal
        /// </summary>
        /// <param name="other">Instance of UnitsAvailable to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(UnitsAvailable other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this._Default == other._Default ||
                    this._Default != null &&
                    this._Default.Equals(other._Default)
                ) && 
                (
                    this.ReduceFirst == other.ReduceFirst ||
                    this.ReduceFirst != null &&
                    this.ReduceFirst.Equals(other.ReduceFirst)
                ) && 
                (
                    this.ReduceOnly == other.ReduceOnly ||
                    this.ReduceOnly != null &&
                    this.ReduceOnly.Equals(other.ReduceOnly)
                ) && 
                (
                    this.OpenOnly == other.OpenOnly ||
                    this.OpenOnly != null &&
                    this.OpenOnly.Equals(other.OpenOnly)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this._Default != null)
                    hash = hash * 59 + this._Default.GetHashCode();
                if (this.ReduceFirst != null)
                    hash = hash * 59 + this.ReduceFirst.GetHashCode();
                if (this.ReduceOnly != null)
                    hash = hash * 59 + this.ReduceOnly.GetHashCode();
                if (this.OpenOnly != null)
                    hash = hash * 59 + this.OpenOnly.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
