/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// The reason that a Transaction was rejected.
    /// </summary>
    /// <value>The reason that a Transaction was rejected.</value>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum TransactionRejectReason
    {
        
        /// <summary>
        /// Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR"
        /// </summary>
        [EnumMember(Value = "INTERNAL_SERVER_ERROR")]
        INTERNALSERVERERROR,
        
        /// <summary>
        /// Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN"
        /// </summary>
        [EnumMember(Value = "INSTRUMENT_PRICE_UNKNOWN")]
        INSTRUMENTPRICEUNKNOWN,
        
        /// <summary>
        /// Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE"
        /// </summary>
        [EnumMember(Value = "ACCOUNT_NOT_ACTIVE")]
        ACCOUNTNOTACTIVE,
        
        /// <summary>
        /// Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED"
        /// </summary>
        [EnumMember(Value = "ACCOUNT_LOCKED")]
        ACCOUNTLOCKED,
        
        /// <summary>
        /// Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED"
        /// </summary>
        [EnumMember(Value = "ACCOUNT_ORDER_CREATION_LOCKED")]
        ACCOUNTORDERCREATIONLOCKED,
        
        /// <summary>
        /// Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED"
        /// </summary>
        [EnumMember(Value = "ACCOUNT_CONFIGURATION_LOCKED")]
        ACCOUNTCONFIGURATIONLOCKED,
        
        /// <summary>
        /// Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED"
        /// </summary>
        [EnumMember(Value = "ACCOUNT_DEPOSIT_LOCKED")]
        ACCOUNTDEPOSITLOCKED,
        
        /// <summary>
        /// Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED"
        /// </summary>
        [EnumMember(Value = "ACCOUNT_WITHDRAWAL_LOCKED")]
        ACCOUNTWITHDRAWALLOCKED,
        
        /// <summary>
        /// Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED"
        /// </summary>
        [EnumMember(Value = "ACCOUNT_ORDER_CANCEL_LOCKED")]
        ACCOUNTORDERCANCELLOCKED,
        
        /// <summary>
        /// Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE"
        /// </summary>
        [EnumMember(Value = "INSTRUMENT_NOT_TRADEABLE")]
        INSTRUMENTNOTTRADEABLE,
        
        /// <summary>
        /// Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED"
        /// </summary>
        [EnumMember(Value = "PENDING_ORDERS_ALLOWED_EXCEEDED")]
        PENDINGORDERSALLOWEDEXCEEDED,
        
        /// <summary>
        /// Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED"
        /// </summary>
        [EnumMember(Value = "ORDER_ID_UNSPECIFIED")]
        ORDERIDUNSPECIFIED,
        
        /// <summary>
        /// Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST"
        /// </summary>
        [EnumMember(Value = "ORDER_DOESNT_EXIST")]
        ORDERDOESNTEXIST,
        
        /// <summary>
        /// Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY"
        /// </summary>
        [EnumMember(Value = "ORDER_IDENTIFIER_INCONSISTENCY")]
        ORDERIDENTIFIERINCONSISTENCY,
        
        /// <summary>
        /// Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED"
        /// </summary>
        [EnumMember(Value = "TRADE_ID_UNSPECIFIED")]
        TRADEIDUNSPECIFIED,
        
        /// <summary>
        /// Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST"
        /// </summary>
        [EnumMember(Value = "TRADE_DOESNT_EXIST")]
        TRADEDOESNTEXIST,
        
        /// <summary>
        /// Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY"
        /// </summary>
        [EnumMember(Value = "TRADE_IDENTIFIER_INCONSISTENCY")]
        TRADEIDENTIFIERINCONSISTENCY,
        
        /// <summary>
        /// Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING"
        /// </summary>
        [EnumMember(Value = "INSTRUMENT_MISSING")]
        INSTRUMENTMISSING,
        
        /// <summary>
        /// Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN"
        /// </summary>
        [EnumMember(Value = "INSTRUMENT_UNKNOWN")]
        INSTRUMENTUNKNOWN,
        
        /// <summary>
        /// Enum UNITSMISSING for "UNITS_MISSING"
        /// </summary>
        [EnumMember(Value = "UNITS_MISSING")]
        UNITSMISSING,
        
        /// <summary>
        /// Enum UNITSINVALID for "UNITS_INVALID"
        /// </summary>
        [EnumMember(Value = "UNITS_INVALID")]
        UNITSINVALID,
        
        /// <summary>
        /// Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED"
        /// </summary>
        [EnumMember(Value = "UNITS_PRECISION_EXCEEDED")]
        UNITSPRECISIONEXCEEDED,
        
        /// <summary>
        /// Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED"
        /// </summary>
        [EnumMember(Value = "UNITS_LIMIT_EXCEEDED")]
        UNITSLIMITEXCEEDED,
        
        /// <summary>
        /// Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET"
        /// </summary>
        [EnumMember(Value = "UNITS_MIMIMUM_NOT_MET")]
        UNITSMIMIMUMNOTMET,
        
        /// <summary>
        /// Enum PRICEMISSING for "PRICE_MISSING"
        /// </summary>
        [EnumMember(Value = "PRICE_MISSING")]
        PRICEMISSING,
        
        /// <summary>
        /// Enum PRICEINVALID for "PRICE_INVALID"
        /// </summary>
        [EnumMember(Value = "PRICE_INVALID")]
        PRICEINVALID,
        
        /// <summary>
        /// Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED"
        /// </summary>
        [EnumMember(Value = "PRICE_PRECISION_EXCEEDED")]
        PRICEPRECISIONEXCEEDED,
        
        /// <summary>
        /// Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING"
        /// </summary>
        [EnumMember(Value = "PRICE_DISTANCE_MISSING")]
        PRICEDISTANCEMISSING,
        
        /// <summary>
        /// Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID"
        /// </summary>
        [EnumMember(Value = "PRICE_DISTANCE_INVALID")]
        PRICEDISTANCEINVALID,
        
        /// <summary>
        /// Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED"
        /// </summary>
        [EnumMember(Value = "PRICE_DISTANCE_PRECISION_EXCEEDED")]
        PRICEDISTANCEPRECISIONEXCEEDED,
        
        /// <summary>
        /// Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED"
        /// </summary>
        [EnumMember(Value = "PRICE_DISTANCE_MAXIMUM_EXCEEDED")]
        PRICEDISTANCEMAXIMUMEXCEEDED,
        
        /// <summary>
        /// Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET"
        /// </summary>
        [EnumMember(Value = "PRICE_DISTANCE_MINIMUM_NOT_MET")]
        PRICEDISTANCEMINIMUMNOTMET,
        
        /// <summary>
        /// Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING"
        /// </summary>
        [EnumMember(Value = "TIME_IN_FORCE_MISSING")]
        TIMEINFORCEMISSING,
        
        /// <summary>
        /// Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID"
        /// </summary>
        [EnumMember(Value = "TIME_IN_FORCE_INVALID")]
        TIMEINFORCEINVALID,
        
        /// <summary>
        /// Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING"
        /// </summary>
        [EnumMember(Value = "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING")]
        TIMEINFORCEGTDTIMESTAMPMISSING,
        
        /// <summary>
        /// Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST"
        /// </summary>
        [EnumMember(Value = "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST")]
        TIMEINFORCEGTDTIMESTAMPINPAST,
        
        /// <summary>
        /// Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID"
        /// </summary>
        [EnumMember(Value = "PRICE_BOUND_INVALID")]
        PRICEBOUNDINVALID,
        
        /// <summary>
        /// Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED"
        /// </summary>
        [EnumMember(Value = "PRICE_BOUND_PRECISION_EXCEEDED")]
        PRICEBOUNDPRECISIONEXCEEDED,
        
        /// <summary>
        /// Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS"
        /// </summary>
        [EnumMember(Value = "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS")]
        ORDERSONFILLDUPLICATECLIENTORDERIDS,
        
        /// <summary>
        /// Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED"
        /// </summary>
        [EnumMember(Value = "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED")]
        TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED,
        
        /// <summary>
        /// Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID"
        /// </summary>
        [EnumMember(Value = "CLIENT_ORDER_ID_INVALID")]
        CLIENTORDERIDINVALID,
        
        /// <summary>
        /// Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS"
        /// </summary>
        [EnumMember(Value = "CLIENT_ORDER_ID_ALREADY_EXISTS")]
        CLIENTORDERIDALREADYEXISTS,
        
        /// <summary>
        /// Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID"
        /// </summary>
        [EnumMember(Value = "CLIENT_ORDER_TAG_INVALID")]
        CLIENTORDERTAGINVALID,
        
        /// <summary>
        /// Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID"
        /// </summary>
        [EnumMember(Value = "CLIENT_ORDER_COMMENT_INVALID")]
        CLIENTORDERCOMMENTINVALID,
        
        /// <summary>
        /// Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID"
        /// </summary>
        [EnumMember(Value = "CLIENT_TRADE_ID_INVALID")]
        CLIENTTRADEIDINVALID,
        
        /// <summary>
        /// Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS"
        /// </summary>
        [EnumMember(Value = "CLIENT_TRADE_ID_ALREADY_EXISTS")]
        CLIENTTRADEIDALREADYEXISTS,
        
        /// <summary>
        /// Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID"
        /// </summary>
        [EnumMember(Value = "CLIENT_TRADE_TAG_INVALID")]
        CLIENTTRADETAGINVALID,
        
        /// <summary>
        /// Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID"
        /// </summary>
        [EnumMember(Value = "CLIENT_TRADE_COMMENT_INVALID")]
        CLIENTTRADECOMMENTINVALID,
        
        /// <summary>
        /// Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING"
        /// </summary>
        [EnumMember(Value = "ORDER_FILL_POSITION_ACTION_MISSING")]
        ORDERFILLPOSITIONACTIONMISSING,
        
        /// <summary>
        /// Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID"
        /// </summary>
        [EnumMember(Value = "ORDER_FILL_POSITION_ACTION_INVALID")]
        ORDERFILLPOSITIONACTIONINVALID,
        
        /// <summary>
        /// Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING"
        /// </summary>
        [EnumMember(Value = "TRIGGER_CONDITION_MISSING")]
        TRIGGERCONDITIONMISSING,
        
        /// <summary>
        /// Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID"
        /// </summary>
        [EnumMember(Value = "TRIGGER_CONDITION_INVALID")]
        TRIGGERCONDITIONINVALID,
        
        /// <summary>
        /// Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING"
        /// </summary>
        [EnumMember(Value = "ORDER_PARTIAL_FILL_OPTION_MISSING")]
        ORDERPARTIALFILLOPTIONMISSING,
        
        /// <summary>
        /// Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID"
        /// </summary>
        [EnumMember(Value = "ORDER_PARTIAL_FILL_OPTION_INVALID")]
        ORDERPARTIALFILLOPTIONINVALID,
        
        /// <summary>
        /// Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL"
        /// </summary>
        [EnumMember(Value = "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL")]
        INVALIDREISSUEIMMEDIATEPARTIALFILL,
        
        /// <summary>
        /// Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS"
        /// </summary>
        [EnumMember(Value = "TAKE_PROFIT_ORDER_ALREADY_EXISTS")]
        TAKEPROFITORDERALREADYEXISTS,
        
        /// <summary>
        /// Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING"
        /// </summary>
        [EnumMember(Value = "TAKE_PROFIT_ON_FILL_PRICE_MISSING")]
        TAKEPROFITONFILLPRICEMISSING,
        
        /// <summary>
        /// Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID"
        /// </summary>
        [EnumMember(Value = "TAKE_PROFIT_ON_FILL_PRICE_INVALID")]
        TAKEPROFITONFILLPRICEINVALID,
        
        /// <summary>
        /// Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED"
        /// </summary>
        [EnumMember(Value = "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED")]
        TAKEPROFITONFILLPRICEPRECISIONEXCEEDED,
        
        /// <summary>
        /// Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING"
        /// </summary>
        [EnumMember(Value = "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING")]
        TAKEPROFITONFILLTIMEINFORCEMISSING,
        
        /// <summary>
        /// Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID"
        /// </summary>
        [EnumMember(Value = "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID")]
        TAKEPROFITONFILLTIMEINFORCEINVALID,
        
        /// <summary>
        /// Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING"
        /// </summary>
        [EnumMember(Value = "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING")]
        TAKEPROFITONFILLGTDTIMESTAMPMISSING,
        
        /// <summary>
        /// Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST"
        /// </summary>
        [EnumMember(Value = "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST")]
        TAKEPROFITONFILLGTDTIMESTAMPINPAST,
        
        /// <summary>
        /// Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID"
        /// </summary>
        [EnumMember(Value = "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID")]
        TAKEPROFITONFILLCLIENTORDERIDINVALID,
        
        /// <summary>
        /// Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID"
        /// </summary>
        [EnumMember(Value = "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID")]
        TAKEPROFITONFILLCLIENTORDERTAGINVALID,
        
        /// <summary>
        /// Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID"
        /// </summary>
        [EnumMember(Value = "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID")]
        TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID,
        
        /// <summary>
        /// Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING"
        /// </summary>
        [EnumMember(Value = "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING")]
        TAKEPROFITONFILLTRIGGERCONDITIONMISSING,
        
        /// <summary>
        /// Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID"
        /// </summary>
        [EnumMember(Value = "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID")]
        TAKEPROFITONFILLTRIGGERCONDITIONINVALID,
        
        /// <summary>
        /// Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS"
        /// </summary>
        [EnumMember(Value = "STOP_LOSS_ORDER_ALREADY_EXISTS")]
        STOPLOSSORDERALREADYEXISTS,
        
        /// <summary>
        /// Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING"
        /// </summary>
        [EnumMember(Value = "STOP_LOSS_ON_FILL_PRICE_MISSING")]
        STOPLOSSONFILLPRICEMISSING,
        
        /// <summary>
        /// Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID"
        /// </summary>
        [EnumMember(Value = "STOP_LOSS_ON_FILL_PRICE_INVALID")]
        STOPLOSSONFILLPRICEINVALID,
        
        /// <summary>
        /// Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED"
        /// </summary>
        [EnumMember(Value = "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED")]
        STOPLOSSONFILLPRICEPRECISIONEXCEEDED,
        
        /// <summary>
        /// Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING"
        /// </summary>
        [EnumMember(Value = "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING")]
        STOPLOSSONFILLTIMEINFORCEMISSING,
        
        /// <summary>
        /// Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID"
        /// </summary>
        [EnumMember(Value = "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID")]
        STOPLOSSONFILLTIMEINFORCEINVALID,
        
        /// <summary>
        /// Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING"
        /// </summary>
        [EnumMember(Value = "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING")]
        STOPLOSSONFILLGTDTIMESTAMPMISSING,
        
        /// <summary>
        /// Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST"
        /// </summary>
        [EnumMember(Value = "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST")]
        STOPLOSSONFILLGTDTIMESTAMPINPAST,
        
        /// <summary>
        /// Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID"
        /// </summary>
        [EnumMember(Value = "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID")]
        STOPLOSSONFILLCLIENTORDERIDINVALID,
        
        /// <summary>
        /// Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID"
        /// </summary>
        [EnumMember(Value = "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID")]
        STOPLOSSONFILLCLIENTORDERTAGINVALID,
        
        /// <summary>
        /// Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID"
        /// </summary>
        [EnumMember(Value = "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID")]
        STOPLOSSONFILLCLIENTORDERCOMMENTINVALID,
        
        /// <summary>
        /// Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING"
        /// </summary>
        [EnumMember(Value = "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING")]
        STOPLOSSONFILLTRIGGERCONDITIONMISSING,
        
        /// <summary>
        /// Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID"
        /// </summary>
        [EnumMember(Value = "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID")]
        STOPLOSSONFILLTRIGGERCONDITIONINVALID,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS")]
        TRAILINGSTOPLOSSORDERALREADYEXISTS,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING")]
        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID")]
        TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED")]
        TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED")]
        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET")]
        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING")]
        TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID")]
        TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING")]
        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST")]
        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID")]
        TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID")]
        TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID")]
        TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED")]
        TRAILINGSTOPLOSSORDERSNOTSUPPORTED,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING")]
        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING,
        
        /// <summary>
        /// Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID"
        /// </summary>
        [EnumMember(Value = "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID")]
        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID,
        
        /// <summary>
        /// Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING"
        /// </summary>
        [EnumMember(Value = "CLOSE_TRADE_TYPE_MISSING")]
        CLOSETRADETYPEMISSING,
        
        /// <summary>
        /// Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING"
        /// </summary>
        [EnumMember(Value = "CLOSE_TRADE_PARTIAL_UNITS_MISSING")]
        CLOSETRADEPARTIALUNITSMISSING,
        
        /// <summary>
        /// Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE"
        /// </summary>
        [EnumMember(Value = "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE")]
        CLOSETRADEUNITSEXCEEDTRADESIZE,
        
        /// <summary>
        /// Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST"
        /// </summary>
        [EnumMember(Value = "CLOSEOUT_POSITION_DOESNT_EXIST")]
        CLOSEOUTPOSITIONDOESNTEXIST,
        
        /// <summary>
        /// Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION"
        /// </summary>
        [EnumMember(Value = "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION")]
        CLOSEOUTPOSITIONINCOMPLETESPECIFICATION,
        
        /// <summary>
        /// Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE"
        /// </summary>
        [EnumMember(Value = "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE")]
        CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE,
        
        /// <summary>
        /// Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT"
        /// </summary>
        [EnumMember(Value = "CLOSEOUT_POSITION_REJECT")]
        CLOSEOUTPOSITIONREJECT,
        
        /// <summary>
        /// Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING"
        /// </summary>
        [EnumMember(Value = "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING")]
        CLOSEOUTPOSITIONPARTIALUNITSMISSING,
        
        /// <summary>
        /// Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID"
        /// </summary>
        [EnumMember(Value = "MARKUP_GROUP_ID_INVALID")]
        MARKUPGROUPIDINVALID,
        
        /// <summary>
        /// Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID"
        /// </summary>
        [EnumMember(Value = "POSITION_AGGREGATION_MODE_INVALID")]
        POSITIONAGGREGATIONMODEINVALID,
        
        /// <summary>
        /// Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING"
        /// </summary>
        [EnumMember(Value = "ADMIN_CONFIGURE_DATA_MISSING")]
        ADMINCONFIGUREDATAMISSING,
        
        /// <summary>
        /// Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID"
        /// </summary>
        [EnumMember(Value = "MARGIN_RATE_INVALID")]
        MARGINRATEINVALID,
        
        /// <summary>
        /// Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT"
        /// </summary>
        [EnumMember(Value = "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT")]
        MARGINRATEWOULDTRIGGERCLOSEOUT,
        
        /// <summary>
        /// Enum ALIASINVALID for "ALIAS_INVALID"
        /// </summary>
        [EnumMember(Value = "ALIAS_INVALID")]
        ALIASINVALID,
        
        /// <summary>
        /// Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING"
        /// </summary>
        [EnumMember(Value = "CLIENT_CONFIGURE_DATA_MISSING")]
        CLIENTCONFIGUREDATAMISSING,
        
        /// <summary>
        /// Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL"
        /// </summary>
        [EnumMember(Value = "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL")]
        MARGINRATEWOULDTRIGGERMARGINCALL,
        
        /// <summary>
        /// Enum AMOUNTINVALID for "AMOUNT_INVALID"
        /// </summary>
        [EnumMember(Value = "AMOUNT_INVALID")]
        AMOUNTINVALID,
        
        /// <summary>
        /// Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS"
        /// </summary>
        [EnumMember(Value = "INSUFFICIENT_FUNDS")]
        INSUFFICIENTFUNDS,
        
        /// <summary>
        /// Enum AMOUNTMISSING for "AMOUNT_MISSING"
        /// </summary>
        [EnumMember(Value = "AMOUNT_MISSING")]
        AMOUNTMISSING,
        
        /// <summary>
        /// Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING"
        /// </summary>
        [EnumMember(Value = "FUNDING_REASON_MISSING")]
        FUNDINGREASONMISSING,
        
        /// <summary>
        /// Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING"
        /// </summary>
        [EnumMember(Value = "CLIENT_EXTENSIONS_DATA_MISSING")]
        CLIENTEXTENSIONSDATAMISSING,
        
        /// <summary>
        /// Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID"
        /// </summary>
        [EnumMember(Value = "REPLACING_ORDER_INVALID")]
        REPLACINGORDERINVALID,
        
        /// <summary>
        /// Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID"
        /// </summary>
        [EnumMember(Value = "REPLACING_TRADE_ID_INVALID")]
        REPLACINGTRADEIDINVALID
    }

}
