/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// The summary of a Trade within an Account. This representation does not provide the full details of the Trade&#39;s dependent Orders.
    /// </summary>
    [DataContract]
    public partial class TradeSummary :  IEquatable<TradeSummary>, IValidatableObject
    {
        /// <summary>
        /// The current state of the Trade.
        /// </summary>
        /// <value>The current state of the Trade.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum StateEnum
        {
            
            /// <summary>
            /// Enum OPEN for "OPEN"
            /// </summary>
            [EnumMember(Value = "OPEN")]
            OPEN,
            
            /// <summary>
            /// Enum CLOSED for "CLOSED"
            /// </summary>
            [EnumMember(Value = "CLOSED")]
            CLOSED,
            
            /// <summary>
            /// Enum CLOSEWHENTRADEABLE for "CLOSE_WHEN_TRADEABLE"
            /// </summary>
            [EnumMember(Value = "CLOSE_WHEN_TRADEABLE")]
            CLOSEWHENTRADEABLE
        }

        /// <summary>
        /// The current state of the Trade.
        /// </summary>
        /// <value>The current state of the Trade.</value>
        [DataMember(Name="state", EmitDefaultValue=false)]
        public StateEnum? State { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="TradeSummary" /> class.
        /// </summary>
        /// <param name="Id">The Trade&#39;s identifier, unique within the Trade&#39;s Account..</param>
        /// <param name="Instrument">The Trade&#39;s Instrument..</param>
        /// <param name="Price">The execution price of the Trade..</param>
        /// <param name="OpenTime">The date/time when the Trade was opened..</param>
        /// <param name="State">The current state of the Trade..</param>
        /// <param name="InitialUnits">The initial size of the Trade. Negative values indicate a short Trade, and positive values indicate a long Trade..</param>
        /// <param name="CurrentUnits">The number of units currently open for the Trade. This value is reduced to 0.0 as the Trade is closed..</param>
        /// <param name="RealizedPL">The total profit/loss realized on the closed portion of the Trade..</param>
        /// <param name="UnrealizedPL">The unrealized profit/loss on the open portion of the Trade..</param>
        /// <param name="AverageClosePrice">The average closing price of the Trade. Only present if the Trade has been closed or reduced at least once..</param>
        /// <param name="ClosingTransactionIDs">The IDs of the Transactions that have closed portions of this Trade..</param>
        /// <param name="Financing">The financing paid/collected for this Trade..</param>
        /// <param name="CloseTime">The date/time when the Trade was fully closed. Only provided for Trades whose state is CLOSED..</param>
        /// <param name="ClientExtensions">ClientExtensions.</param>
        /// <param name="TakeProfitOrderID">ID of the Trade&#39;s Take Profit Order, only provided if such an Order exists..</param>
        /// <param name="StopLossOrderID">ID of the Trade&#39;s Stop Loss Order, only provided if such an Order exists..</param>
        /// <param name="TrailingStopLossOrderID">ID of the Trade&#39;s Trailing Stop Loss Order, only provided if such an Order exists..</param>
        public TradeSummary(string Id = default(string), string Instrument = default(string), string Price = default(string), string OpenTime = default(string), StateEnum? State = default(StateEnum?), string InitialUnits = default(string), string CurrentUnits = default(string), string RealizedPL = default(string), string UnrealizedPL = default(string), string AverageClosePrice = default(string), List<string> ClosingTransactionIDs = default(List<string>), string Financing = default(string), string CloseTime = default(string), ClientExtensions ClientExtensions = default(ClientExtensions), string TakeProfitOrderID = default(string), string StopLossOrderID = default(string), string TrailingStopLossOrderID = default(string))
        {
            this.Id = Id;
            this.Instrument = Instrument;
            this.Price = Price;
            this.OpenTime = OpenTime;
            this.State = State;
            this.InitialUnits = InitialUnits;
            this.CurrentUnits = CurrentUnits;
            this.RealizedPL = RealizedPL;
            this.UnrealizedPL = UnrealizedPL;
            this.AverageClosePrice = AverageClosePrice;
            this.ClosingTransactionIDs = ClosingTransactionIDs;
            this.Financing = Financing;
            this.CloseTime = CloseTime;
            this.ClientExtensions = ClientExtensions;
            this.TakeProfitOrderID = TakeProfitOrderID;
            this.StopLossOrderID = StopLossOrderID;
            this.TrailingStopLossOrderID = TrailingStopLossOrderID;
        }
        
        /// <summary>
        /// The Trade&#39;s identifier, unique within the Trade&#39;s Account.
        /// </summary>
        /// <value>The Trade&#39;s identifier, unique within the Trade&#39;s Account.</value>
        [DataMember(Name="id", EmitDefaultValue=false)]
        public string Id { get; set; }
        /// <summary>
        /// The Trade&#39;s Instrument.
        /// </summary>
        /// <value>The Trade&#39;s Instrument.</value>
        [DataMember(Name="instrument", EmitDefaultValue=false)]
        public string Instrument { get; set; }
        /// <summary>
        /// The execution price of the Trade.
        /// </summary>
        /// <value>The execution price of the Trade.</value>
        [DataMember(Name="price", EmitDefaultValue=false)]
        public string Price { get; set; }
        /// <summary>
        /// The date/time when the Trade was opened.
        /// </summary>
        /// <value>The date/time when the Trade was opened.</value>
        [DataMember(Name="openTime", EmitDefaultValue=false)]
        public string OpenTime { get; set; }
        /// <summary>
        /// The initial size of the Trade. Negative values indicate a short Trade, and positive values indicate a long Trade.
        /// </summary>
        /// <value>The initial size of the Trade. Negative values indicate a short Trade, and positive values indicate a long Trade.</value>
        [DataMember(Name="initialUnits", EmitDefaultValue=false)]
        public string InitialUnits { get; set; }
        /// <summary>
        /// The number of units currently open for the Trade. This value is reduced to 0.0 as the Trade is closed.
        /// </summary>
        /// <value>The number of units currently open for the Trade. This value is reduced to 0.0 as the Trade is closed.</value>
        [DataMember(Name="currentUnits", EmitDefaultValue=false)]
        public string CurrentUnits { get; set; }
        /// <summary>
        /// The total profit/loss realized on the closed portion of the Trade.
        /// </summary>
        /// <value>The total profit/loss realized on the closed portion of the Trade.</value>
        [DataMember(Name="realizedPL", EmitDefaultValue=false)]
        public string RealizedPL { get; set; }
        /// <summary>
        /// The unrealized profit/loss on the open portion of the Trade.
        /// </summary>
        /// <value>The unrealized profit/loss on the open portion of the Trade.</value>
        [DataMember(Name="unrealizedPL", EmitDefaultValue=false)]
        public string UnrealizedPL { get; set; }
        /// <summary>
        /// The average closing price of the Trade. Only present if the Trade has been closed or reduced at least once.
        /// </summary>
        /// <value>The average closing price of the Trade. Only present if the Trade has been closed or reduced at least once.</value>
        [DataMember(Name="averageClosePrice", EmitDefaultValue=false)]
        public string AverageClosePrice { get; set; }
        /// <summary>
        /// The IDs of the Transactions that have closed portions of this Trade.
        /// </summary>
        /// <value>The IDs of the Transactions that have closed portions of this Trade.</value>
        [DataMember(Name="closingTransactionIDs", EmitDefaultValue=false)]
        public List<string> ClosingTransactionIDs { get; set; }
        /// <summary>
        /// The financing paid/collected for this Trade.
        /// </summary>
        /// <value>The financing paid/collected for this Trade.</value>
        [DataMember(Name="financing", EmitDefaultValue=false)]
        public string Financing { get; set; }
        /// <summary>
        /// The date/time when the Trade was fully closed. Only provided for Trades whose state is CLOSED.
        /// </summary>
        /// <value>The date/time when the Trade was fully closed. Only provided for Trades whose state is CLOSED.</value>
        [DataMember(Name="closeTime", EmitDefaultValue=false)]
        public string CloseTime { get; set; }
        /// <summary>
        /// Gets or Sets ClientExtensions
        /// </summary>
        [DataMember(Name="clientExtensions", EmitDefaultValue=false)]
        public ClientExtensions ClientExtensions { get; set; }
        /// <summary>
        /// ID of the Trade&#39;s Take Profit Order, only provided if such an Order exists.
        /// </summary>
        /// <value>ID of the Trade&#39;s Take Profit Order, only provided if such an Order exists.</value>
        [DataMember(Name="takeProfitOrderID", EmitDefaultValue=false)]
        public string TakeProfitOrderID { get; set; }
        /// <summary>
        /// ID of the Trade&#39;s Stop Loss Order, only provided if such an Order exists.
        /// </summary>
        /// <value>ID of the Trade&#39;s Stop Loss Order, only provided if such an Order exists.</value>
        [DataMember(Name="stopLossOrderID", EmitDefaultValue=false)]
        public string StopLossOrderID { get; set; }
        /// <summary>
        /// ID of the Trade&#39;s Trailing Stop Loss Order, only provided if such an Order exists.
        /// </summary>
        /// <value>ID of the Trade&#39;s Trailing Stop Loss Order, only provided if such an Order exists.</value>
        [DataMember(Name="trailingStopLossOrderID", EmitDefaultValue=false)]
        public string TrailingStopLossOrderID { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class TradeSummary {\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Instrument: ").Append(Instrument).Append("\n");
            sb.Append("  Price: ").Append(Price).Append("\n");
            sb.Append("  OpenTime: ").Append(OpenTime).Append("\n");
            sb.Append("  State: ").Append(State).Append("\n");
            sb.Append("  InitialUnits: ").Append(InitialUnits).Append("\n");
            sb.Append("  CurrentUnits: ").Append(CurrentUnits).Append("\n");
            sb.Append("  RealizedPL: ").Append(RealizedPL).Append("\n");
            sb.Append("  UnrealizedPL: ").Append(UnrealizedPL).Append("\n");
            sb.Append("  AverageClosePrice: ").Append(AverageClosePrice).Append("\n");
            sb.Append("  ClosingTransactionIDs: ").Append(ClosingTransactionIDs).Append("\n");
            sb.Append("  Financing: ").Append(Financing).Append("\n");
            sb.Append("  CloseTime: ").Append(CloseTime).Append("\n");
            sb.Append("  ClientExtensions: ").Append(ClientExtensions).Append("\n");
            sb.Append("  TakeProfitOrderID: ").Append(TakeProfitOrderID).Append("\n");
            sb.Append("  StopLossOrderID: ").Append(StopLossOrderID).Append("\n");
            sb.Append("  TrailingStopLossOrderID: ").Append(TrailingStopLossOrderID).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as TradeSummary);
        }

        /// <summary>
        /// Returns true if TradeSummary instances are equal
        /// </summary>
        /// <param name="other">Instance of TradeSummary to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(TradeSummary other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Id == other.Id ||
                    this.Id != null &&
                    this.Id.Equals(other.Id)
                ) && 
                (
                    this.Instrument == other.Instrument ||
                    this.Instrument != null &&
                    this.Instrument.Equals(other.Instrument)
                ) && 
                (
                    this.Price == other.Price ||
                    this.Price != null &&
                    this.Price.Equals(other.Price)
                ) && 
                (
                    this.OpenTime == other.OpenTime ||
                    this.OpenTime != null &&
                    this.OpenTime.Equals(other.OpenTime)
                ) && 
                (
                    this.State == other.State ||
                    this.State != null &&
                    this.State.Equals(other.State)
                ) && 
                (
                    this.InitialUnits == other.InitialUnits ||
                    this.InitialUnits != null &&
                    this.InitialUnits.Equals(other.InitialUnits)
                ) && 
                (
                    this.CurrentUnits == other.CurrentUnits ||
                    this.CurrentUnits != null &&
                    this.CurrentUnits.Equals(other.CurrentUnits)
                ) && 
                (
                    this.RealizedPL == other.RealizedPL ||
                    this.RealizedPL != null &&
                    this.RealizedPL.Equals(other.RealizedPL)
                ) && 
                (
                    this.UnrealizedPL == other.UnrealizedPL ||
                    this.UnrealizedPL != null &&
                    this.UnrealizedPL.Equals(other.UnrealizedPL)
                ) && 
                (
                    this.AverageClosePrice == other.AverageClosePrice ||
                    this.AverageClosePrice != null &&
                    this.AverageClosePrice.Equals(other.AverageClosePrice)
                ) && 
                (
                    this.ClosingTransactionIDs == other.ClosingTransactionIDs ||
                    this.ClosingTransactionIDs != null &&
                    this.ClosingTransactionIDs.SequenceEqual(other.ClosingTransactionIDs)
                ) && 
                (
                    this.Financing == other.Financing ||
                    this.Financing != null &&
                    this.Financing.Equals(other.Financing)
                ) && 
                (
                    this.CloseTime == other.CloseTime ||
                    this.CloseTime != null &&
                    this.CloseTime.Equals(other.CloseTime)
                ) && 
                (
                    this.ClientExtensions == other.ClientExtensions ||
                    this.ClientExtensions != null &&
                    this.ClientExtensions.Equals(other.ClientExtensions)
                ) && 
                (
                    this.TakeProfitOrderID == other.TakeProfitOrderID ||
                    this.TakeProfitOrderID != null &&
                    this.TakeProfitOrderID.Equals(other.TakeProfitOrderID)
                ) && 
                (
                    this.StopLossOrderID == other.StopLossOrderID ||
                    this.StopLossOrderID != null &&
                    this.StopLossOrderID.Equals(other.StopLossOrderID)
                ) && 
                (
                    this.TrailingStopLossOrderID == other.TrailingStopLossOrderID ||
                    this.TrailingStopLossOrderID != null &&
                    this.TrailingStopLossOrderID.Equals(other.TrailingStopLossOrderID)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.Id != null)
                    hash = hash * 59 + this.Id.GetHashCode();
                if (this.Instrument != null)
                    hash = hash * 59 + this.Instrument.GetHashCode();
                if (this.Price != null)
                    hash = hash * 59 + this.Price.GetHashCode();
                if (this.OpenTime != null)
                    hash = hash * 59 + this.OpenTime.GetHashCode();
                if (this.State != null)
                    hash = hash * 59 + this.State.GetHashCode();
                if (this.InitialUnits != null)
                    hash = hash * 59 + this.InitialUnits.GetHashCode();
                if (this.CurrentUnits != null)
                    hash = hash * 59 + this.CurrentUnits.GetHashCode();
                if (this.RealizedPL != null)
                    hash = hash * 59 + this.RealizedPL.GetHashCode();
                if (this.UnrealizedPL != null)
                    hash = hash * 59 + this.UnrealizedPL.GetHashCode();
                if (this.AverageClosePrice != null)
                    hash = hash * 59 + this.AverageClosePrice.GetHashCode();
                if (this.ClosingTransactionIDs != null)
                    hash = hash * 59 + this.ClosingTransactionIDs.GetHashCode();
                if (this.Financing != null)
                    hash = hash * 59 + this.Financing.GetHashCode();
                if (this.CloseTime != null)
                    hash = hash * 59 + this.CloseTime.GetHashCode();
                if (this.ClientExtensions != null)
                    hash = hash * 59 + this.ClientExtensions.GetHashCode();
                if (this.TakeProfitOrderID != null)
                    hash = hash * 59 + this.TakeProfitOrderID.GetHashCode();
                if (this.StopLossOrderID != null)
                    hash = hash * 59 + this.StopLossOrderID.GetHashCode();
                if (this.TrailingStopLossOrderID != null)
                    hash = hash * 59 + this.TrailingStopLossOrderID.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
