/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// The specification of an Account-specific Price.
    /// </summary>
    [DataContract]
    public partial class Price :  IEquatable<Price>, IValidatableObject
    {
        /// <summary>
        /// The status of the Price.
        /// </summary>
        /// <value>The status of the Price.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum StatusEnum
        {
            
            /// <summary>
            /// Enum Tradeable for "tradeable"
            /// </summary>
            [EnumMember(Value = "tradeable")]
            Tradeable,
            
            /// <summary>
            /// Enum Nontradeable for "non-tradeable"
            /// </summary>
            [EnumMember(Value = "non-tradeable")]
            Nontradeable,
            
            /// <summary>
            /// Enum Invalid for "invalid"
            /// </summary>
            [EnumMember(Value = "invalid")]
            Invalid
        }

        /// <summary>
        /// The status of the Price.
        /// </summary>
        /// <value>The status of the Price.</value>
        [DataMember(Name="status", EmitDefaultValue=false)]
        public StatusEnum? Status { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="Price" /> class.
        /// </summary>
        /// <param name="Type">The string \&quot;PRICE\&quot;. Used to identify the a Price object when found in a stream..</param>
        /// <param name="Instrument">The Price&#39;s Instrument..</param>
        /// <param name="Time">The date/time when the Price was created.</param>
        /// <param name="Status">The status of the Price..</param>
        /// <param name="Tradeable">Flag indicating if the Price is tradeable or not.</param>
        /// <param name="Bids">The list of prices and liquidity available on the Instrument&#39;s bid side. It is possible for this list to be empty if there is no bid liquidity currently available for the Instrument in the Account..</param>
        /// <param name="Asks">The list of prices and liquidity available on the Instrument&#39;s ask side. It is possible for this list to be empty if there is no ask liquidity currently available for the Instrument in the Account..</param>
        /// <param name="CloseoutBid">The closeout bid Price. This Price is used when a bid is required to closeout a Position (margin closeout or manual) yet there is no bid liquidity. The closeout bid is never used to open a new position..</param>
        /// <param name="CloseoutAsk">The closeout ask Price. This Price is used when a ask is required to closeout a Position (margin closeout or manual) yet there is no ask liquidity. The closeout ask is never used to open a new position..</param>
        /// <param name="QuoteHomeConversionFactors">QuoteHomeConversionFactors.</param>
        /// <param name="UnitsAvailable">UnitsAvailable.</param>
        public Price(string Type = default(string), string Instrument = default(string), string Time = default(string), StatusEnum? Status = default(StatusEnum?), bool? Tradeable = default(bool?), List<PriceBucket> Bids = default(List<PriceBucket>), List<PriceBucket> Asks = default(List<PriceBucket>), string CloseoutBid = default(string), string CloseoutAsk = default(string), QuoteHomeConversionFactors QuoteHomeConversionFactors = default(QuoteHomeConversionFactors), UnitsAvailable UnitsAvailable = default(UnitsAvailable))
        {
            this.Type = Type;
            this.Instrument = Instrument;
            this.Time = Time;
            this.Status = Status;
            this.Tradeable = Tradeable;
            this.Bids = Bids;
            this.Asks = Asks;
            this.CloseoutBid = CloseoutBid;
            this.CloseoutAsk = CloseoutAsk;
            this.QuoteHomeConversionFactors = QuoteHomeConversionFactors;
            this.UnitsAvailable = UnitsAvailable;
        }
        
        /// <summary>
        /// The string \&quot;PRICE\&quot;. Used to identify the a Price object when found in a stream.
        /// </summary>
        /// <value>The string \&quot;PRICE\&quot;. Used to identify the a Price object when found in a stream.</value>
        [DataMember(Name="type", EmitDefaultValue=false)]
        public string Type { get; set; }
        /// <summary>
        /// The Price&#39;s Instrument.
        /// </summary>
        /// <value>The Price&#39;s Instrument.</value>
        [DataMember(Name="instrument", EmitDefaultValue=false)]
        public string Instrument { get; set; }
        /// <summary>
        /// The date/time when the Price was created
        /// </summary>
        /// <value>The date/time when the Price was created</value>
        [DataMember(Name="time", EmitDefaultValue=false)]
        public string Time { get; set; }
        /// <summary>
        /// Flag indicating if the Price is tradeable or not
        /// </summary>
        /// <value>Flag indicating if the Price is tradeable or not</value>
        [DataMember(Name="tradeable", EmitDefaultValue=false)]
        public bool? Tradeable { get; set; }
        /// <summary>
        /// The list of prices and liquidity available on the Instrument&#39;s bid side. It is possible for this list to be empty if there is no bid liquidity currently available for the Instrument in the Account.
        /// </summary>
        /// <value>The list of prices and liquidity available on the Instrument&#39;s bid side. It is possible for this list to be empty if there is no bid liquidity currently available for the Instrument in the Account.</value>
        [DataMember(Name="bids", EmitDefaultValue=false)]
        public List<PriceBucket> Bids { get; set; }
        /// <summary>
        /// The list of prices and liquidity available on the Instrument&#39;s ask side. It is possible for this list to be empty if there is no ask liquidity currently available for the Instrument in the Account.
        /// </summary>
        /// <value>The list of prices and liquidity available on the Instrument&#39;s ask side. It is possible for this list to be empty if there is no ask liquidity currently available for the Instrument in the Account.</value>
        [DataMember(Name="asks", EmitDefaultValue=false)]
        public List<PriceBucket> Asks { get; set; }
        /// <summary>
        /// The closeout bid Price. This Price is used when a bid is required to closeout a Position (margin closeout or manual) yet there is no bid liquidity. The closeout bid is never used to open a new position.
        /// </summary>
        /// <value>The closeout bid Price. This Price is used when a bid is required to closeout a Position (margin closeout or manual) yet there is no bid liquidity. The closeout bid is never used to open a new position.</value>
        [DataMember(Name="closeoutBid", EmitDefaultValue=false)]
        public string CloseoutBid { get; set; }
        /// <summary>
        /// The closeout ask Price. This Price is used when a ask is required to closeout a Position (margin closeout or manual) yet there is no ask liquidity. The closeout ask is never used to open a new position.
        /// </summary>
        /// <value>The closeout ask Price. This Price is used when a ask is required to closeout a Position (margin closeout or manual) yet there is no ask liquidity. The closeout ask is never used to open a new position.</value>
        [DataMember(Name="closeoutAsk", EmitDefaultValue=false)]
        public string CloseoutAsk { get; set; }
        /// <summary>
        /// Gets or Sets QuoteHomeConversionFactors
        /// </summary>
        [DataMember(Name="quoteHomeConversionFactors", EmitDefaultValue=false)]
        public QuoteHomeConversionFactors QuoteHomeConversionFactors { get; set; }
        /// <summary>
        /// Gets or Sets UnitsAvailable
        /// </summary>
        [DataMember(Name="unitsAvailable", EmitDefaultValue=false)]
        public UnitsAvailable UnitsAvailable { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class Price {\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("  Instrument: ").Append(Instrument).Append("\n");
            sb.Append("  Time: ").Append(Time).Append("\n");
            sb.Append("  Status: ").Append(Status).Append("\n");
            sb.Append("  Tradeable: ").Append(Tradeable).Append("\n");
            sb.Append("  Bids: ").Append(Bids).Append("\n");
            sb.Append("  Asks: ").Append(Asks).Append("\n");
            sb.Append("  CloseoutBid: ").Append(CloseoutBid).Append("\n");
            sb.Append("  CloseoutAsk: ").Append(CloseoutAsk).Append("\n");
            sb.Append("  QuoteHomeConversionFactors: ").Append(QuoteHomeConversionFactors).Append("\n");
            sb.Append("  UnitsAvailable: ").Append(UnitsAvailable).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as Price);
        }

        /// <summary>
        /// Returns true if Price instances are equal
        /// </summary>
        /// <param name="other">Instance of Price to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Price other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Type == other.Type ||
                    this.Type != null &&
                    this.Type.Equals(other.Type)
                ) && 
                (
                    this.Instrument == other.Instrument ||
                    this.Instrument != null &&
                    this.Instrument.Equals(other.Instrument)
                ) && 
                (
                    this.Time == other.Time ||
                    this.Time != null &&
                    this.Time.Equals(other.Time)
                ) && 
                (
                    this.Status == other.Status ||
                    this.Status != null &&
                    this.Status.Equals(other.Status)
                ) && 
                (
                    this.Tradeable == other.Tradeable ||
                    this.Tradeable != null &&
                    this.Tradeable.Equals(other.Tradeable)
                ) && 
                (
                    this.Bids == other.Bids ||
                    this.Bids != null &&
                    this.Bids.SequenceEqual(other.Bids)
                ) && 
                (
                    this.Asks == other.Asks ||
                    this.Asks != null &&
                    this.Asks.SequenceEqual(other.Asks)
                ) && 
                (
                    this.CloseoutBid == other.CloseoutBid ||
                    this.CloseoutBid != null &&
                    this.CloseoutBid.Equals(other.CloseoutBid)
                ) && 
                (
                    this.CloseoutAsk == other.CloseoutAsk ||
                    this.CloseoutAsk != null &&
                    this.CloseoutAsk.Equals(other.CloseoutAsk)
                ) && 
                (
                    this.QuoteHomeConversionFactors == other.QuoteHomeConversionFactors ||
                    this.QuoteHomeConversionFactors != null &&
                    this.QuoteHomeConversionFactors.Equals(other.QuoteHomeConversionFactors)
                ) && 
                (
                    this.UnitsAvailable == other.UnitsAvailable ||
                    this.UnitsAvailable != null &&
                    this.UnitsAvailable.Equals(other.UnitsAvailable)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.Type != null)
                    hash = hash * 59 + this.Type.GetHashCode();
                if (this.Instrument != null)
                    hash = hash * 59 + this.Instrument.GetHashCode();
                if (this.Time != null)
                    hash = hash * 59 + this.Time.GetHashCode();
                if (this.Status != null)
                    hash = hash * 59 + this.Status.GetHashCode();
                if (this.Tradeable != null)
                    hash = hash * 59 + this.Tradeable.GetHashCode();
                if (this.Bids != null)
                    hash = hash * 59 + this.Bids.GetHashCode();
                if (this.Asks != null)
                    hash = hash * 59 + this.Asks.GetHashCode();
                if (this.CloseoutBid != null)
                    hash = hash * 59 + this.CloseoutBid.GetHashCode();
                if (this.CloseoutAsk != null)
                    hash = hash * 59 + this.CloseoutAsk.GetHashCode();
                if (this.QuoteHomeConversionFactors != null)
                    hash = hash * 59 + this.QuoteHomeConversionFactors.GetHashCode();
                if (this.UnitsAvailable != null)
                    hash = hash * 59 + this.UnitsAvailable.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
