/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// A liquidity regeneration schedule Step indicates the amount of bid and ask liquidity that is used by the Account at a certain time. These amounts will only change at the timestamp of the following step.
    /// </summary>
    [DataContract]
    public partial class LiquidityRegenerationScheduleStep :  IEquatable<LiquidityRegenerationScheduleStep>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="LiquidityRegenerationScheduleStep" /> class.
        /// </summary>
        /// <param name="Timestamp">The timestamp of the schedule step..</param>
        /// <param name="BidLiquidityUsed">The amount of bid liquidity used at this step in the schedule..</param>
        /// <param name="AskLiquidityUsed">The amount of ask liquidity used at this step in the schedule..</param>
        public LiquidityRegenerationScheduleStep(string Timestamp = default(string), string BidLiquidityUsed = default(string), string AskLiquidityUsed = default(string))
        {
            this.Timestamp = Timestamp;
            this.BidLiquidityUsed = BidLiquidityUsed;
            this.AskLiquidityUsed = AskLiquidityUsed;
        }
        
        /// <summary>
        /// The timestamp of the schedule step.
        /// </summary>
        /// <value>The timestamp of the schedule step.</value>
        [DataMember(Name="timestamp", EmitDefaultValue=false)]
        public string Timestamp { get; set; }
        /// <summary>
        /// The amount of bid liquidity used at this step in the schedule.
        /// </summary>
        /// <value>The amount of bid liquidity used at this step in the schedule.</value>
        [DataMember(Name="bidLiquidityUsed", EmitDefaultValue=false)]
        public string BidLiquidityUsed { get; set; }
        /// <summary>
        /// The amount of ask liquidity used at this step in the schedule.
        /// </summary>
        /// <value>The amount of ask liquidity used at this step in the schedule.</value>
        [DataMember(Name="askLiquidityUsed", EmitDefaultValue=false)]
        public string AskLiquidityUsed { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class LiquidityRegenerationScheduleStep {\n");
            sb.Append("  Timestamp: ").Append(Timestamp).Append("\n");
            sb.Append("  BidLiquidityUsed: ").Append(BidLiquidityUsed).Append("\n");
            sb.Append("  AskLiquidityUsed: ").Append(AskLiquidityUsed).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as LiquidityRegenerationScheduleStep);
        }

        /// <summary>
        /// Returns true if LiquidityRegenerationScheduleStep instances are equal
        /// </summary>
        /// <param name="other">Instance of LiquidityRegenerationScheduleStep to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(LiquidityRegenerationScheduleStep other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Timestamp == other.Timestamp ||
                    this.Timestamp != null &&
                    this.Timestamp.Equals(other.Timestamp)
                ) && 
                (
                    this.BidLiquidityUsed == other.BidLiquidityUsed ||
                    this.BidLiquidityUsed != null &&
                    this.BidLiquidityUsed.Equals(other.BidLiquidityUsed)
                ) && 
                (
                    this.AskLiquidityUsed == other.AskLiquidityUsed ||
                    this.AskLiquidityUsed != null &&
                    this.AskLiquidityUsed.Equals(other.AskLiquidityUsed)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.Timestamp != null)
                    hash = hash * 59 + this.Timestamp.GetHashCode();
                if (this.BidLiquidityUsed != null)
                    hash = hash * 59 + this.BidLiquidityUsed.GetHashCode();
                if (this.AskLiquidityUsed != null)
                    hash = hash * 59 + this.AskLiquidityUsed.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
