/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// InlineResponse20029
    /// </summary>
    [DataContract]
    public partial class InlineResponse20029 :  IEquatable<InlineResponse20029>, IValidatableObject
    {
        /// <summary>
        /// The granularity of the candlesticks provided.
        /// </summary>
        /// <value>The granularity of the candlesticks provided.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum GranularityEnum
        {
            
            /// <summary>
            /// Enum S5 for "S5"
            /// </summary>
            [EnumMember(Value = "S5")]
            S5,
            
            /// <summary>
            /// Enum S10 for "S10"
            /// </summary>
            [EnumMember(Value = "S10")]
            S10,
            
            /// <summary>
            /// Enum S15 for "S15"
            /// </summary>
            [EnumMember(Value = "S15")]
            S15,
            
            /// <summary>
            /// Enum S30 for "S30"
            /// </summary>
            [EnumMember(Value = "S30")]
            S30,
            
            /// <summary>
            /// Enum M1 for "M1"
            /// </summary>
            [EnumMember(Value = "M1")]
            M1,
            
            /// <summary>
            /// Enum M2 for "M2"
            /// </summary>
            [EnumMember(Value = "M2")]
            M2,
            
            /// <summary>
            /// Enum M4 for "M4"
            /// </summary>
            [EnumMember(Value = "M4")]
            M4,
            
            /// <summary>
            /// Enum M5 for "M5"
            /// </summary>
            [EnumMember(Value = "M5")]
            M5,
            
            /// <summary>
            /// Enum M10 for "M10"
            /// </summary>
            [EnumMember(Value = "M10")]
            M10,
            
            /// <summary>
            /// Enum M15 for "M15"
            /// </summary>
            [EnumMember(Value = "M15")]
            M15,
            
            /// <summary>
            /// Enum M30 for "M30"
            /// </summary>
            [EnumMember(Value = "M30")]
            M30,
            
            /// <summary>
            /// Enum H1 for "H1"
            /// </summary>
            [EnumMember(Value = "H1")]
            H1,
            
            /// <summary>
            /// Enum H2 for "H2"
            /// </summary>
            [EnumMember(Value = "H2")]
            H2,
            
            /// <summary>
            /// Enum H3 for "H3"
            /// </summary>
            [EnumMember(Value = "H3")]
            H3,
            
            /// <summary>
            /// Enum H4 for "H4"
            /// </summary>
            [EnumMember(Value = "H4")]
            H4,
            
            /// <summary>
            /// Enum H6 for "H6"
            /// </summary>
            [EnumMember(Value = "H6")]
            H6,
            
            /// <summary>
            /// Enum H8 for "H8"
            /// </summary>
            [EnumMember(Value = "H8")]
            H8,
            
            /// <summary>
            /// Enum H12 for "H12"
            /// </summary>
            [EnumMember(Value = "H12")]
            H12,
            
            /// <summary>
            /// Enum D for "D"
            /// </summary>
            [EnumMember(Value = "D")]
            D,
            
            /// <summary>
            /// Enum W for "W"
            /// </summary>
            [EnumMember(Value = "W")]
            W,
            
            /// <summary>
            /// Enum M for "M"
            /// </summary>
            [EnumMember(Value = "M")]
            M
        }

        /// <summary>
        /// The granularity of the candlesticks provided.
        /// </summary>
        /// <value>The granularity of the candlesticks provided.</value>
        [DataMember(Name="granularity", EmitDefaultValue=false)]
        public GranularityEnum? Granularity { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="InlineResponse20029" /> class.
        /// </summary>
        /// <param name="Instrument">The instrument whose Prices are represented by the candlesticks..</param>
        /// <param name="Granularity">The granularity of the candlesticks provided..</param>
        /// <param name="Candles">The list of candlesticks that satisfy the request..</param>
        public InlineResponse20029(string Instrument = default(string), GranularityEnum? Granularity = default(GranularityEnum?), List<Candlestick> Candles = default(List<Candlestick>))
        {
            this.Instrument = Instrument;
            this.Granularity = Granularity;
            this.Candles = Candles;
        }
        
        /// <summary>
        /// The instrument whose Prices are represented by the candlesticks.
        /// </summary>
        /// <value>The instrument whose Prices are represented by the candlesticks.</value>
        [DataMember(Name="instrument", EmitDefaultValue=false)]
        public string Instrument { get; set; }
        /// <summary>
        /// The list of candlesticks that satisfy the request.
        /// </summary>
        /// <value>The list of candlesticks that satisfy the request.</value>
        [DataMember(Name="candles", EmitDefaultValue=false)]
        public List<Candlestick> Candles { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class InlineResponse20029 {\n");
            sb.Append("  Instrument: ").Append(Instrument).Append("\n");
            sb.Append("  Granularity: ").Append(Granularity).Append("\n");
            sb.Append("  Candles: ").Append(Candles).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as InlineResponse20029);
        }

        /// <summary>
        /// Returns true if InlineResponse20029 instances are equal
        /// </summary>
        /// <param name="other">Instance of InlineResponse20029 to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(InlineResponse20029 other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Instrument == other.Instrument ||
                    this.Instrument != null &&
                    this.Instrument.Equals(other.Instrument)
                ) && 
                (
                    this.Granularity == other.Granularity ||
                    this.Granularity != null &&
                    this.Granularity.Equals(other.Granularity)
                ) && 
                (
                    this.Candles == other.Candles ||
                    this.Candles != null &&
                    this.Candles.SequenceEqual(other.Candles)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.Instrument != null)
                    hash = hash * 59 + this.Instrument.GetHashCode();
                if (this.Granularity != null)
                    hash = hash * 59 + this.Granularity.GetHashCode();
                if (this.Candles != null)
                    hash = hash * 59 + this.Candles.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
