/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// ConfigureAccountBody
    /// </summary>
    [DataContract]
    public partial class ConfigureAccountBody :  IEquatable<ConfigureAccountBody>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ConfigureAccountBody" /> class.
        /// </summary>
        /// <param name="Alias">Client-defined alias (name) for the Account.</param>
        /// <param name="MarginRate">The string representation of a decimal number..</param>
        public ConfigureAccountBody(string Alias = default(string), string MarginRate = default(string))
        {
            this.Alias = Alias;
            this.MarginRate = MarginRate;
        }
        
        /// <summary>
        /// Client-defined alias (name) for the Account
        /// </summary>
        /// <value>Client-defined alias (name) for the Account</value>
        [DataMember(Name="alias", EmitDefaultValue=false)]
        public string Alias { get; set; }
        /// <summary>
        /// The string representation of a decimal number.
        /// </summary>
        /// <value>The string representation of a decimal number.</value>
        [DataMember(Name="marginRate", EmitDefaultValue=false)]
        public string MarginRate { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class ConfigureAccountBody {\n");
            sb.Append("  Alias: ").Append(Alias).Append("\n");
            sb.Append("  MarginRate: ").Append(MarginRate).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as ConfigureAccountBody);
        }

        /// <summary>
        /// Returns true if ConfigureAccountBody instances are equal
        /// </summary>
        /// <param name="other">Instance of ConfigureAccountBody to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(ConfigureAccountBody other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Alias == other.Alias ||
                    this.Alias != null &&
                    this.Alias.Equals(other.Alias)
                ) && 
                (
                    this.MarginRate == other.MarginRate ||
                    this.MarginRate != null &&
                    this.MarginRate.Equals(other.MarginRate)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.Alias != null)
                    hash = hash * 59 + this.Alias.GetHashCode();
                if (this.MarginRate != null)
                    hash = hash * 59 + this.MarginRate.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
