/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// ClosePositionBody
    /// </summary>
    [DataContract]
    public partial class ClosePositionBody :  IEquatable<ClosePositionBody>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ClosePositionBody" /> class.
        /// </summary>
        /// <param name="LongUnits">Indication of how much of the long Position to closeout. Either the string \&quot;ALL\&quot;, the string \&quot;NONE\&quot;, or a DecimalNumber representing how many units of the long position to close using a PositionCloseout MarketOrder. The units specified must always be positive..</param>
        /// <param name="LongClientExtensions">LongClientExtensions.</param>
        /// <param name="ShortUnits">Indication of how much of the short Position to closeout. Either the string \&quot;ALL\&quot;, the string \&quot;NONE\&quot;, or a DecimalNumber representing how many units of the short position to close using a PositionCloseout MarketOrder. The units specified must always be positive..</param>
        /// <param name="ShortClientExtensions">ShortClientExtensions.</param>
        public ClosePositionBody(string LongUnits = default(string), ClientExtensions LongClientExtensions = default(ClientExtensions), string ShortUnits = default(string), ClientExtensions ShortClientExtensions = default(ClientExtensions))
        {
            this.LongUnits = LongUnits;
            this.LongClientExtensions = LongClientExtensions;
            this.ShortUnits = ShortUnits;
            this.ShortClientExtensions = ShortClientExtensions;
        }
        
        /// <summary>
        /// Indication of how much of the long Position to closeout. Either the string \&quot;ALL\&quot;, the string \&quot;NONE\&quot;, or a DecimalNumber representing how many units of the long position to close using a PositionCloseout MarketOrder. The units specified must always be positive.
        /// </summary>
        /// <value>Indication of how much of the long Position to closeout. Either the string \&quot;ALL\&quot;, the string \&quot;NONE\&quot;, or a DecimalNumber representing how many units of the long position to close using a PositionCloseout MarketOrder. The units specified must always be positive.</value>
        [DataMember(Name="longUnits", EmitDefaultValue=false)]
        public string LongUnits { get; set; }
        /// <summary>
        /// Gets or Sets LongClientExtensions
        /// </summary>
        [DataMember(Name="longClientExtensions", EmitDefaultValue=false)]
        public ClientExtensions LongClientExtensions { get; set; }
        /// <summary>
        /// Indication of how much of the short Position to closeout. Either the string \&quot;ALL\&quot;, the string \&quot;NONE\&quot;, or a DecimalNumber representing how many units of the short position to close using a PositionCloseout MarketOrder. The units specified must always be positive.
        /// </summary>
        /// <value>Indication of how much of the short Position to closeout. Either the string \&quot;ALL\&quot;, the string \&quot;NONE\&quot;, or a DecimalNumber representing how many units of the short position to close using a PositionCloseout MarketOrder. The units specified must always be positive.</value>
        [DataMember(Name="shortUnits", EmitDefaultValue=false)]
        public string ShortUnits { get; set; }
        /// <summary>
        /// Gets or Sets ShortClientExtensions
        /// </summary>
        [DataMember(Name="shortClientExtensions", EmitDefaultValue=false)]
        public ClientExtensions ShortClientExtensions { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class ClosePositionBody {\n");
            sb.Append("  LongUnits: ").Append(LongUnits).Append("\n");
            sb.Append("  LongClientExtensions: ").Append(LongClientExtensions).Append("\n");
            sb.Append("  ShortUnits: ").Append(ShortUnits).Append("\n");
            sb.Append("  ShortClientExtensions: ").Append(ShortClientExtensions).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as ClosePositionBody);
        }

        /// <summary>
        /// Returns true if ClosePositionBody instances are equal
        /// </summary>
        /// <param name="other">Instance of ClosePositionBody to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(ClosePositionBody other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.LongUnits == other.LongUnits ||
                    this.LongUnits != null &&
                    this.LongUnits.Equals(other.LongUnits)
                ) && 
                (
                    this.LongClientExtensions == other.LongClientExtensions ||
                    this.LongClientExtensions != null &&
                    this.LongClientExtensions.Equals(other.LongClientExtensions)
                ) && 
                (
                    this.ShortUnits == other.ShortUnits ||
                    this.ShortUnits != null &&
                    this.ShortUnits.Equals(other.ShortUnits)
                ) && 
                (
                    this.ShortClientExtensions == other.ShortClientExtensions ||
                    this.ShortClientExtensions != null &&
                    this.ShortClientExtensions.Equals(other.ShortClientExtensions)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.LongUnits != null)
                    hash = hash * 59 + this.LongUnits.GetHashCode();
                if (this.LongClientExtensions != null)
                    hash = hash * 59 + this.LongClientExtensions.GetHashCode();
                if (this.ShortUnits != null)
                    hash = hash * 59 + this.ShortUnits.GetHashCode();
                if (this.ShortClientExtensions != null)
                    hash = hash * 59 + this.ShortClientExtensions.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
