/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// The Candlestick representation
    /// </summary>
    [DataContract]
    public partial class Candlestick :  IEquatable<Candlestick>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Candlestick" /> class.
        /// </summary>
        /// <param name="Time">The start time of the candlestick.</param>
        /// <param name="Bid">Bid.</param>
        /// <param name="Ask">Ask.</param>
        /// <param name="Mid">Mid.</param>
        /// <param name="Volume">The number of prices created during the time-range represented by the candlestick..</param>
        /// <param name="Complete">A flag indicating if the candlestick is complete. A complete candlestick is one whose ending time is not in the future..</param>
        public Candlestick(string Time = default(string), CandlestickData Bid = default(CandlestickData), CandlestickData Ask = default(CandlestickData), CandlestickData Mid = default(CandlestickData), int? Volume = default(int?), bool? Complete = default(bool?))
        {
            this.Time = Time;
            this.Bid = Bid;
            this.Ask = Ask;
            this.Mid = Mid;
            this.Volume = Volume;
            this.Complete = Complete;
        }
        
        /// <summary>
        /// The start time of the candlestick
        /// </summary>
        /// <value>The start time of the candlestick</value>
        [DataMember(Name="time", EmitDefaultValue=false)]
        public string Time { get; set; }
        /// <summary>
        /// Gets or Sets Bid
        /// </summary>
        [DataMember(Name="bid", EmitDefaultValue=false)]
        public CandlestickData Bid { get; set; }
        /// <summary>
        /// Gets or Sets Ask
        /// </summary>
        [DataMember(Name="ask", EmitDefaultValue=false)]
        public CandlestickData Ask { get; set; }
        /// <summary>
        /// Gets or Sets Mid
        /// </summary>
        [DataMember(Name="mid", EmitDefaultValue=false)]
        public CandlestickData Mid { get; set; }
        /// <summary>
        /// The number of prices created during the time-range represented by the candlestick.
        /// </summary>
        /// <value>The number of prices created during the time-range represented by the candlestick.</value>
        [DataMember(Name="volume", EmitDefaultValue=false)]
        public int? Volume { get; set; }
        /// <summary>
        /// A flag indicating if the candlestick is complete. A complete candlestick is one whose ending time is not in the future.
        /// </summary>
        /// <value>A flag indicating if the candlestick is complete. A complete candlestick is one whose ending time is not in the future.</value>
        [DataMember(Name="complete", EmitDefaultValue=false)]
        public bool? Complete { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class Candlestick {\n");
            sb.Append("  Time: ").Append(Time).Append("\n");
            sb.Append("  Bid: ").Append(Bid).Append("\n");
            sb.Append("  Ask: ").Append(Ask).Append("\n");
            sb.Append("  Mid: ").Append(Mid).Append("\n");
            sb.Append("  Volume: ").Append(Volume).Append("\n");
            sb.Append("  Complete: ").Append(Complete).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as Candlestick);
        }

        /// <summary>
        /// Returns true if Candlestick instances are equal
        /// </summary>
        /// <param name="other">Instance of Candlestick to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Candlestick other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Time == other.Time ||
                    this.Time != null &&
                    this.Time.Equals(other.Time)
                ) && 
                (
                    this.Bid == other.Bid ||
                    this.Bid != null &&
                    this.Bid.Equals(other.Bid)
                ) && 
                (
                    this.Ask == other.Ask ||
                    this.Ask != null &&
                    this.Ask.Equals(other.Ask)
                ) && 
                (
                    this.Mid == other.Mid ||
                    this.Mid != null &&
                    this.Mid.Equals(other.Mid)
                ) && 
                (
                    this.Volume == other.Volume ||
                    this.Volume != null &&
                    this.Volume.Equals(other.Volume)
                ) && 
                (
                    this.Complete == other.Complete ||
                    this.Complete != null &&
                    this.Complete.Equals(other.Complete)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.Time != null)
                    hash = hash * 59 + this.Time.GetHashCode();
                if (this.Bid != null)
                    hash = hash * 59 + this.Bid.GetHashCode();
                if (this.Ask != null)
                    hash = hash * 59 + this.Ask.GetHashCode();
                if (this.Mid != null)
                    hash = hash * 59 + this.Mid.GetHashCode();
                if (this.Volume != null)
                    hash = hash * 59 + this.Volume.GetHashCode();
                if (this.Complete != null)
                    hash = hash * 59 + this.Complete.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
