/* 
 * OANDA v20 REST API
 *
 * The full OANDA v20 REST API Specification. This specification defines how to interact with v20 Accounts, Trades, Orders, Pricing and more.
 *
 * OpenAPI spec version: 3.0.15
 * Contact: api@oanda.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;

namespace Oanda.RestV20.Model
{
    /// <summary>
    /// An AccountChanges Object is used to represent the changes to an Account&#39;s Orders, Trades and Positions since a specified Account TransactionID in the past.
    /// </summary>
    [DataContract]
    public partial class AccountChanges :  IEquatable<AccountChanges>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="AccountChanges" /> class.
        /// </summary>
        /// <param name="OrdersCreated">The Orders created. These Orders may have been filled, cancelled or triggered in the same period..</param>
        /// <param name="OrdersCancelled">The Orders cancelled..</param>
        /// <param name="OrdersFilled">The Orders filled..</param>
        /// <param name="OrdersTriggered">The Orders triggered..</param>
        /// <param name="TradesOpened">The Trades opened..</param>
        /// <param name="TradesReduced">The Trades reduced..</param>
        /// <param name="TradesClosed">The Trades closed..</param>
        /// <param name="Positions">The Positions changed..</param>
        /// <param name="Transactions">The Transactions that have been generated..</param>
        public AccountChanges(List<Order> OrdersCreated = default(List<Order>), List<Order> OrdersCancelled = default(List<Order>), List<Order> OrdersFilled = default(List<Order>), List<Order> OrdersTriggered = default(List<Order>), List<TradeSummary> TradesOpened = default(List<TradeSummary>), List<TradeSummary> TradesReduced = default(List<TradeSummary>), List<TradeSummary> TradesClosed = default(List<TradeSummary>), List<Position> Positions = default(List<Position>), List<Transaction> Transactions = default(List<Transaction>))
        {
            this.OrdersCreated = OrdersCreated;
            this.OrdersCancelled = OrdersCancelled;
            this.OrdersFilled = OrdersFilled;
            this.OrdersTriggered = OrdersTriggered;
            this.TradesOpened = TradesOpened;
            this.TradesReduced = TradesReduced;
            this.TradesClosed = TradesClosed;
            this.Positions = Positions;
            this.Transactions = Transactions;
        }
        
        /// <summary>
        /// The Orders created. These Orders may have been filled, cancelled or triggered in the same period.
        /// </summary>
        /// <value>The Orders created. These Orders may have been filled, cancelled or triggered in the same period.</value>
        [DataMember(Name="ordersCreated", EmitDefaultValue=false)]
        public List<Order> OrdersCreated { get; set; }
        /// <summary>
        /// The Orders cancelled.
        /// </summary>
        /// <value>The Orders cancelled.</value>
        [DataMember(Name="ordersCancelled", EmitDefaultValue=false)]
        public List<Order> OrdersCancelled { get; set; }
        /// <summary>
        /// The Orders filled.
        /// </summary>
        /// <value>The Orders filled.</value>
        [DataMember(Name="ordersFilled", EmitDefaultValue=false)]
        public List<Order> OrdersFilled { get; set; }
        /// <summary>
        /// The Orders triggered.
        /// </summary>
        /// <value>The Orders triggered.</value>
        [DataMember(Name="ordersTriggered", EmitDefaultValue=false)]
        public List<Order> OrdersTriggered { get; set; }
        /// <summary>
        /// The Trades opened.
        /// </summary>
        /// <value>The Trades opened.</value>
        [DataMember(Name="tradesOpened", EmitDefaultValue=false)]
        public List<TradeSummary> TradesOpened { get; set; }
        /// <summary>
        /// The Trades reduced.
        /// </summary>
        /// <value>The Trades reduced.</value>
        [DataMember(Name="tradesReduced", EmitDefaultValue=false)]
        public List<TradeSummary> TradesReduced { get; set; }
        /// <summary>
        /// The Trades closed.
        /// </summary>
        /// <value>The Trades closed.</value>
        [DataMember(Name="tradesClosed", EmitDefaultValue=false)]
        public List<TradeSummary> TradesClosed { get; set; }
        /// <summary>
        /// The Positions changed.
        /// </summary>
        /// <value>The Positions changed.</value>
        [DataMember(Name="positions", EmitDefaultValue=false)]
        public List<Position> Positions { get; set; }
        /// <summary>
        /// The Transactions that have been generated.
        /// </summary>
        /// <value>The Transactions that have been generated.</value>
        [DataMember(Name="transactions", EmitDefaultValue=false)]
        public List<Transaction> Transactions { get; set; }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class AccountChanges {\n");
            sb.Append("  OrdersCreated: ").Append(OrdersCreated).Append("\n");
            sb.Append("  OrdersCancelled: ").Append(OrdersCancelled).Append("\n");
            sb.Append("  OrdersFilled: ").Append(OrdersFilled).Append("\n");
            sb.Append("  OrdersTriggered: ").Append(OrdersTriggered).Append("\n");
            sb.Append("  TradesOpened: ").Append(TradesOpened).Append("\n");
            sb.Append("  TradesReduced: ").Append(TradesReduced).Append("\n");
            sb.Append("  TradesClosed: ").Append(TradesClosed).Append("\n");
            sb.Append("  Positions: ").Append(Positions).Append("\n");
            sb.Append("  Transactions: ").Append(Transactions).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as AccountChanges);
        }

        /// <summary>
        /// Returns true if AccountChanges instances are equal
        /// </summary>
        /// <param name="other">Instance of AccountChanges to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(AccountChanges other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.OrdersCreated == other.OrdersCreated ||
                    this.OrdersCreated != null &&
                    this.OrdersCreated.SequenceEqual(other.OrdersCreated)
                ) && 
                (
                    this.OrdersCancelled == other.OrdersCancelled ||
                    this.OrdersCancelled != null &&
                    this.OrdersCancelled.SequenceEqual(other.OrdersCancelled)
                ) && 
                (
                    this.OrdersFilled == other.OrdersFilled ||
                    this.OrdersFilled != null &&
                    this.OrdersFilled.SequenceEqual(other.OrdersFilled)
                ) && 
                (
                    this.OrdersTriggered == other.OrdersTriggered ||
                    this.OrdersTriggered != null &&
                    this.OrdersTriggered.SequenceEqual(other.OrdersTriggered)
                ) && 
                (
                    this.TradesOpened == other.TradesOpened ||
                    this.TradesOpened != null &&
                    this.TradesOpened.SequenceEqual(other.TradesOpened)
                ) && 
                (
                    this.TradesReduced == other.TradesReduced ||
                    this.TradesReduced != null &&
                    this.TradesReduced.SequenceEqual(other.TradesReduced)
                ) && 
                (
                    this.TradesClosed == other.TradesClosed ||
                    this.TradesClosed != null &&
                    this.TradesClosed.SequenceEqual(other.TradesClosed)
                ) && 
                (
                    this.Positions == other.Positions ||
                    this.Positions != null &&
                    this.Positions.SequenceEqual(other.Positions)
                ) && 
                (
                    this.Transactions == other.Transactions ||
                    this.Transactions != null &&
                    this.Transactions.SequenceEqual(other.Transactions)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                if (this.OrdersCreated != null)
                    hash = hash * 59 + this.OrdersCreated.GetHashCode();
                if (this.OrdersCancelled != null)
                    hash = hash * 59 + this.OrdersCancelled.GetHashCode();
                if (this.OrdersFilled != null)
                    hash = hash * 59 + this.OrdersFilled.GetHashCode();
                if (this.OrdersTriggered != null)
                    hash = hash * 59 + this.OrdersTriggered.GetHashCode();
                if (this.TradesOpened != null)
                    hash = hash * 59 + this.TradesOpened.GetHashCode();
                if (this.TradesReduced != null)
                    hash = hash * 59 + this.TradesReduced.GetHashCode();
                if (this.TradesClosed != null)
                    hash = hash * 59 + this.TradesClosed.GetHashCode();
                if (this.Positions != null)
                    hash = hash * 59 + this.Positions.GetHashCode();
                if (this.Transactions != null)
                    hash = hash * 59 + this.Transactions.GetHashCode();
                return hash;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        { 
            yield break;
        }
    }

}
