from .__Fundamental_35 import *
import typing
import System.IO
import System.Collections.Generic
import System
import QuantConnect.Data.Fundamental.MultiPeriodField
import QuantConnect.Data.Fundamental
import QuantConnect.Data
import QuantConnect
import datetime


class InterestIncomeAfterProvisionForLoanLossIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Net interest and dividend income or expense, including any amortization and accretion (as applicable) of discounts and premiums,
                including consideration of the provisions for loan, lease, credit, and other related losses, if any.
    
    InterestIncomeAfterProvisionForLoanLossIncomeStatement(store: IDictionary[str, Decimal])
    """
    def GetPeriodValue(self, period: str) -> float:
        pass

    def SetPeriodValue(self, period: str, value: float) -> None:
        pass

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float]) -> QuantConnect.Data.Fundamental.InterestIncomeAfterProvisionForLoanLossIncomeStatement:
        pass

    NineMonths: float

    OneMonth: float

    SixMonths: float

    ThreeMonths: float

    TwelveMonths: float

    TwoMonths: float

    Store: typing.List[QuantConnect.Data.Fundamental.MultiPeriodField.PeriodField]


class InterestIncomeFromDepositsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Interest income generated from all deposit accounts. This item is usually only available for bank industry.
    
    InterestIncomeFromDepositsIncomeStatement(store: IDictionary[str, Decimal])
    """
    def GetPeriodValue(self, period: str) -> float:
        pass

    def SetPeriodValue(self, period: str, value: float) -> None:
        pass

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float]) -> QuantConnect.Data.Fundamental.InterestIncomeFromDepositsIncomeStatement:
        pass

    NineMonths: float

    OneMonth: float

    SixMonths: float

    ThreeMonths: float

    TwelveMonths: float

    Store: typing.List[QuantConnect.Data.Fundamental.MultiPeriodField.PeriodField]


class InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying value of funds outstanding loaned in the form of security resale agreements if the agreement requires the purchaser to
                resell the identical security purchased or a security that meets the definition of ""substantially the same"" in the case of a dollar roll.
                Also includes purchases of participations in pools of securities that are subject to a resale agreement; This category includes all
                interest income generated from federal funds sold and securities purchases under agreements to resell; This category includes all
                interest income generated from federal funds sold and securities purchases under agreements to resell.
    
    InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement(store: IDictionary[str, Decimal])
    """
    def GetPeriodValue(self, period: str) -> float:
        pass

    def SetPeriodValue(self, period: str, value: float) -> None:
        pass

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float]) -> QuantConnect.Data.Fundamental.InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement:
        pass

    NineMonths: float

    SixMonths: float

    ThreeMonths: float

    TwelveMonths: float

    Store: typing.List[QuantConnect.Data.Fundamental.MultiPeriodField.PeriodField]


class InterestIncomeFromLeasesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Includes interest and fee income generated by direct lease financing. This item is usually only available for bank industry.
    
    InterestIncomeFromLeasesIncomeStatement(store: IDictionary[str, Decimal])
    """
    def GetPeriodValue(self, period: str) -> float:
        pass

    def SetPeriodValue(self, period: str, value: float) -> None:
        pass

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float]) -> QuantConnect.Data.Fundamental.InterestIncomeFromLeasesIncomeStatement:
        pass

    NineMonths: float

    OneMonth: float

    SixMonths: float

    ThreeMonths: float

    TwelveMonths: float

    Store: typing.List[QuantConnect.Data.Fundamental.MultiPeriodField.PeriodField]


class InterestIncomeFromLoansAndLeaseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Total interest and fee income generated by loans and lease. This item is usually only available for bank industry.
    
    InterestIncomeFromLoansAndLeaseIncomeStatement(store: IDictionary[str, Decimal])
    """
    def GetPeriodValue(self, period: str) -> float:
        pass

    def SetPeriodValue(self, period: str, value: float) -> None:
        pass

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float]) -> QuantConnect.Data.Fundamental.InterestIncomeFromLoansAndLeaseIncomeStatement:
        pass

    NineMonths: float

    OneMonth: float

    SixMonths: float

    ThreeMonths: float

    TwelveMonths: float

    Store: typing.List[QuantConnect.Data.Fundamental.MultiPeriodField.PeriodField]


class InterestIncomeFromLoansIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Loan is a common field to banks. Interest Income from Loans is interest and fee income generated from all loans, which includes
                Commercial loans; Credit loans; Other consumer loans; Real Estate - Construction; Real Estate - Mortgage; Foreign loans. Banks
                earn interest from loans. This item is usually only available for bank industry.
    
    InterestIncomeFromLoansIncomeStatement(store: IDictionary[str, Decimal])
    """
    def GetPeriodValue(self, period: str) -> float:
        pass

    def SetPeriodValue(self, period: str, value: float) -> None:
        pass

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float]) -> QuantConnect.Data.Fundamental.InterestIncomeFromLoansIncomeStatement:
        pass

    NineMonths: float

    OneMonth: float

    SixMonths: float

    ThreeMonths: float

    TwelveMonths: float

    Store: typing.List[QuantConnect.Data.Fundamental.MultiPeriodField.PeriodField]


class InterestIncomeFromSecuritiesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Represents total interest and dividend income from U.S. Treasury securities, U.S. government agency and corporation obligations,
                securities issued by states and political subdivisions, other domestic debt securities, foreign debt securities, and equity securities
                (including investments in mutual funds). Excludes interest income from securities held in trading accounts. This item is usually only
                available for bank industry.
    
    InterestIncomeFromSecuritiesIncomeStatement(store: IDictionary[str, Decimal])
    """
    def GetPeriodValue(self, period: str) -> float:
        pass

    def SetPeriodValue(self, period: str, value: float) -> None:
        pass

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float]) -> QuantConnect.Data.Fundamental.InterestIncomeFromSecuritiesIncomeStatement:
        pass

    NineMonths: float

    OneMonth: float

    SixMonths: float

    ThreeMonths: float

    TwelveMonths: float

    TwoMonths: float

    Store: typing.List[QuantConnect.Data.Fundamental.MultiPeriodField.PeriodField]


class InterestIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Income generated from interest-bearing deposits or accounts.
    
    InterestIncomeIncomeStatement(store: IDictionary[str, Decimal])
    """
    def GetPeriodValue(self, period: str) -> float:
        pass

    def SetPeriodValue(self, period: str, value: float) -> None:
        pass

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float]) -> QuantConnect.Data.Fundamental.InterestIncomeIncomeStatement:
        pass

    NineMonths: float

    OneMonth: float

    SixMonths: float

    ThreeMonths: float

    TwelveMonths: float

    TwoMonths: float

    Store: typing.List[QuantConnect.Data.Fundamental.MultiPeriodField.PeriodField]


class InterestIncomeNonOperatingIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Interest income earned from long term financing activities.
    
    InterestIncomeNonOperatingIncomeStatement(store: IDictionary[str, Decimal])
    """
    def GetPeriodValue(self, period: str) -> float:
        pass

    def SetPeriodValue(self, period: str, value: float) -> None:
        pass

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float]) -> QuantConnect.Data.Fundamental.InterestIncomeNonOperatingIncomeStatement:
        pass

    NineMonths: float

    OneMonth: float

    SixMonths: float

    ThreeMonths: float

    TwelveMonths: float

    TwoMonths: float

    Store: typing.List[QuantConnect.Data.Fundamental.MultiPeriodField.PeriodField]


class InterestPaidCFFCashFlowStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Interest paid on loans, debt or borrowings, in the Financing Cash Flow section.
    
    InterestPaidCFFCashFlowStatement(store: IDictionary[str, Decimal])
    """
    def GetPeriodValue(self, period: str) -> float:
        pass

    def SetPeriodValue(self, period: str, value: float) -> None:
        pass

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float]) -> QuantConnect.Data.Fundamental.InterestPaidCFFCashFlowStatement:
        pass

    NineMonths: float

    SixMonths: float

    ThreeMonths: float

    TwelveMonths: float

    Store: typing.List[QuantConnect.Data.Fundamental.MultiPeriodField.PeriodField]


class InterestPaidCFOCashFlowStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Interest paid on loans, debt or borrowings, in the Operating Cash Flow section.
    
    InterestPaidCFOCashFlowStatement(store: IDictionary[str, Decimal])
    """
    def GetPeriodValue(self, period: str) -> float:
        pass

    def SetPeriodValue(self, period: str, value: float) -> None:
        pass

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float]) -> QuantConnect.Data.Fundamental.InterestPaidCFOCashFlowStatement:
        pass

    NineMonths: float

    SixMonths: float

    ThreeMonths: float

    TwelveMonths: float

    Store: typing.List[QuantConnect.Data.Fundamental.MultiPeriodField.PeriodField]
