# StackEdit

[![Build Status](https://img.shields.io/travis/benweet/stackedit.svg?style=flat)](https://travis-ci.org/benweet/stackedit) [![NPM version](https://img.shields.io/npm/v/stackedit.svg?style=flat)](https://www.npmjs.org/package/stackedit)

> Full-featured, open-source Markdown editor based on PageDown, the Markdown library used by Stack Overflow and the other Stack Exchange sites.

https://stackedit.io/

### Ecosystem

- [Chrome app](https://chrome.google.com/webstore/detail/iiooodelglhkcpgbajoejffhijaclcdg)
- NEW! Embed StackEdit in any website with [stackedit.js](https://github.com/benweet/stackedit.js)
- NEW! [Chrome extension](https://chrome.google.com/webstore/detail/ajehldoplanpchfokmeempkekhnhmoha) that uses stackedit.js
- [Community](https://community.stackedit.io/)

### Build Setup

``` bash
# install dependencies
npm install

# serve with hot reload at localhost:8080
npm start

# build for production with minification
npm run build

# build for production and view the bundle analyzer report
npm run build --report
```

### StackEdit can:

 - Manage multiple Markdown files online or offline
 - Export your files in Markdown, HTML, PDF, Word, EPUB...
 - Synchronize your Markdown files in the Cloud
 - Edit existing Markdown files from Google Drive, Dropbox and your local hard drive
 - Post your Markdown file on Blogger/Blogspot, WordPress, Zendesk
 - Publish your Markdown file on GitHub, Gist, Google Drive, Dropbox
 - Share a workspace over Google Drive, CouchDB

### Features:

 - Real-time HTML preview with Scroll Sync feature to bind editor and preview scrollbars
 - Markdown Extra/GitHub Flavored Markdown support and Prism.js syntax highlighting
 - LaTeX mathematical expressions using KaTeX
 - Diagrams and flowcharts using Mermaid
 - WYSIWYG control buttons
 - Smart layout
 - Offline editing
 - Online synchronization using Google Drive, Dropbox and GitHub
 - One click publish to Blogger, Dropbox, Gist, GitHub, Google Drive, WordPress, Zendesk

> **NOTE:** This page has been written and published with [StackEdit](https://stackedit.io/ "StackEdit").
