﻿using Healthcheck.Service.Core.Messages;
using Microsoft.Azure.ServiceBus.Core;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Healthcheck.Service.Core.Senders
{
    public class MessageBusSender
    {
        public static void Send(string type, OutGoingMessage message)
        {
            var busMessage = new Microsoft.Azure.ServiceBus.Message
            {
                ContentType = "application/json",
                Label = type,
                Body = Encoding.UTF8.GetBytes(JsonConvert.SerializeObject(message))
            };

            var messageSender = new MessageSender(SharedConfig.ConnectionStringOrKey, SharedConfig.TopicName);
            messageSender.SendAsync(busMessage).ConfigureAwait(false).GetAwaiter().GetResult();
        }
    }
}
