/**
 * External dependencies
 */
import { includes } from 'lodash';

/**
 * Return true if platform is MacOS.
 *
 * @param {Object} _window   window object by default; used for DI testing.
 *
 * @return {boolean}         True if MacOS; false otherwise.
 */
export function isAppleOS( _window = window ) {
	const { platform } = _window.navigator;

	return platform.indexOf( 'Mac' ) !== -1 ||
		includes( [ 'iPad', 'iPhone' ], platform );
}
