# mlx_steering_dump_parser
This is Mellanox SW steering parser and triggering for dump files in **CSV format**.
The supported dump files are those generated by ConnectX5 and ConnectX6DX.

For JSON dump parser please move to branch [`json_parser`](https://github.com/Mellanox/mlx_steering_dump/tree/json_parser).

How to trigger a dump.file generation
=====================================
Dump generation is available in:

    1. rdma-core:
        It can be done directly by calling mlx5dv_dump_dr_domain API or using mlx5_pmd
        To trigger DPDK app run:
            mlx_steering_dump_parser.py -p <DPDK PID> -f <dump_file>

    2. mlnx-ofed kernel steering (SMFS):
        Generated by reading the interface proc file under /proc/driver/mlx5_core/smfs_dump/fdb/<PCI>
        For example:
            cat /proc/driver/mlx5_core/smfs_dump/fdb/0000\:82\:00.0 > /dump_file
            mlx_steering_dump_parser.py -f /dump_file

Running syntax
================

| Flags | meaning |
| :---: | :---: |
| -f <PATH> | path to file |
| -r  | show raw data |
| -t  | Show steering tree/hierarchy    |
| -p <DPDK PID> | Trigger DPDK app           |
| -v  | Verbose view               |
| -vv | Extra verbose view      |
| -c  | show colored prints |

Running examples
================

example.csv is part of this porject can be viewed using:

	mlx_steering_dump_parser.py -f example.csv    
	mlx_steering_dump_parser.py -f example.csv -t 
	mlx_steering_dump_parser.py -f example.csv -v 
	mlx_steering_dump_parser.py -f example.csv -vv

Trigger a new testpmd dump using:

	mlx_steering_dump_parser.py -p `pidof testpmd` -f new_dump.csv

Trigger a new kernel SMFS dump using:

	cat /proc/driver/mlx5_core/smfs_dump/fdb/0000\:82\:00.0 > /new_dump.csv
	mlx_steering_dump_parser.py -f /new_dump.csv

Recommended packages
==================
Python 2 or 3

Support
==================
OFED kernel proc dump support from OFED 5.0.2

RDMA CORE user dump support from version 28.0

TESTPMD trigger dump support from version 17.11
