// Copyright (c) Aptos
// SPDX-License-Identifier: Apache-2.0

use forge::{forge_main, ForgeConfig, InitialVersion, LocalFactory, Options, Result};
use std::num::NonZeroUsize;
use testcases::{
    fixed_tps_test::FixedTpsTest, gas_price_test::NonZeroGasPrice,
    performance_test::PerformanceBenchmark,
};

fn main() -> Result<()> {
    ::aptos_logger::Logger::init_for_testing();

    let tests = ForgeConfig::default()
        .with_initial_validator_count(NonZeroUsize::new(4).unwrap())
        .with_initial_version(InitialVersion::Newest)
        .with_network_tests(&[&PerformanceBenchmark, &NonZeroGasPrice, &FixedTpsTest]);

    let options = Options::from_args();
    forge_main(tests, LocalFactory::from_workspace()?, &options)
}
