---
title: "Getting started"
slug: "getting-started"
sidebar_position: 0
---

# Getting Started

This is a guide to kick-start your journey as a developer in the Aptos ecosystem!

## Prepare for Aptos Development

Aptos-core is available on [GitHub](https://github.com/aptos-labs/aptos-core)

```bash
git clone https://github.com/aptos-labs/aptos-core.git
cd aptos-core
./scripts/dev_setup.sh
source ~/.cargo/env
```

## Explore the tutorials

* [Your first transaction](/tutorials/your-first-transaction)
* [Your first Move module](/tutorials/your-first-move-module)
* [Your first NFT](/tutorials/your-first-nft)
* [Run a local testnet](/tutorials/run-a-local-testnet)
* [Run a FullNode](/tutorials/run-a-fullnode)
* [Wallet Extension With dApp Integration](/tutorials/building-wallet-extension)

## Start Developing Move Modules

* Read the [Move book](https://diem.github.io/move/)
* Learn more about [interacting with the Aptos Blockchain](/transactions/interacting-with-the-aptos-blockchain)
* Explore the [Framework documentation](https://github.com/aptos-labs/aptos-core/tree/framework-docs)
* Start building and publishing your own modules on our public Devnet or on your own Testnet

## Devnet Details

* Faucet endpoint: [https://faucet.devnet.aptoslabs.com](https://faucet.devnet.aptoslabs.com)
* REST interface endpoint: [https://fullnode.devnet.aptoslabs.com](https://fullnode.devnet.aptoslabs.com)
* [Genesis](https://devnet.aptoslabs.com/genesis.blob)
* [Waypoint](https://devnet.aptoslabs.com/waypoint.txt)
* [ChainID](https://devnet.aptoslabs.com/chainid.txt)
