/*

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha2 "kubesphere.io/fluentbit-operator/api/fluentbitoperator/v1alpha2"
)

// FakeFluentBitConfigs implements FluentBitConfigInterface
type FakeFluentBitConfigs struct {
	Fake *FakeLoggingV1alpha2
	ns   string
}

var fluentbitconfigsResource = schema.GroupVersionResource{Group: "logging.kubesphere.io", Version: "v1alpha2", Resource: "fluentbitconfigs"}

var fluentbitconfigsKind = schema.GroupVersionKind{Group: "logging.kubesphere.io", Version: "v1alpha2", Kind: "FluentBitConfig"}

// Get takes name of the fluentBitConfig, and returns the corresponding fluentBitConfig object, and an error if there is any.
func (c *FakeFluentBitConfigs) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha2.FluentBitConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(fluentbitconfigsResource, c.ns, name), &v1alpha2.FluentBitConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.FluentBitConfig), err
}

// List takes label and field selectors, and returns the list of FluentBitConfigs that match those selectors.
func (c *FakeFluentBitConfigs) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha2.FluentBitConfigList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(fluentbitconfigsResource, fluentbitconfigsKind, c.ns, opts), &v1alpha2.FluentBitConfigList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha2.FluentBitConfigList{ListMeta: obj.(*v1alpha2.FluentBitConfigList).ListMeta}
	for _, item := range obj.(*v1alpha2.FluentBitConfigList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested fluentBitConfigs.
func (c *FakeFluentBitConfigs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(fluentbitconfigsResource, c.ns, opts))

}

// Create takes the representation of a fluentBitConfig and creates it.  Returns the server's representation of the fluentBitConfig, and an error, if there is any.
func (c *FakeFluentBitConfigs) Create(ctx context.Context, fluentBitConfig *v1alpha2.FluentBitConfig, opts v1.CreateOptions) (result *v1alpha2.FluentBitConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(fluentbitconfigsResource, c.ns, fluentBitConfig), &v1alpha2.FluentBitConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.FluentBitConfig), err
}

// Update takes the representation of a fluentBitConfig and updates it. Returns the server's representation of the fluentBitConfig, and an error, if there is any.
func (c *FakeFluentBitConfigs) Update(ctx context.Context, fluentBitConfig *v1alpha2.FluentBitConfig, opts v1.UpdateOptions) (result *v1alpha2.FluentBitConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(fluentbitconfigsResource, c.ns, fluentBitConfig), &v1alpha2.FluentBitConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.FluentBitConfig), err
}

// Delete takes name of the fluentBitConfig and deletes it. Returns an error if one occurs.
func (c *FakeFluentBitConfigs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(fluentbitconfigsResource, c.ns, name), &v1alpha2.FluentBitConfig{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeFluentBitConfigs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(fluentbitconfigsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha2.FluentBitConfigList{})
	return err
}

// Patch applies the patch and returns the patched fluentBitConfig.
func (c *FakeFluentBitConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.FluentBitConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(fluentbitconfigsResource, c.ns, name, pt, data, subresources...), &v1alpha2.FluentBitConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.FluentBitConfig), err
}
