/*

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha2 "kubesphere.io/fluentbit-operator/api/fluentbitoperator/v1alpha2"
)

// FakeFluentBits implements FluentBitInterface
type FakeFluentBits struct {
	Fake *FakeLoggingV1alpha2
	ns   string
}

var fluentbitsResource = schema.GroupVersionResource{Group: "logging.kubesphere.io", Version: "v1alpha2", Resource: "fluentbits"}

var fluentbitsKind = schema.GroupVersionKind{Group: "logging.kubesphere.io", Version: "v1alpha2", Kind: "FluentBit"}

// Get takes name of the fluentBit, and returns the corresponding fluentBit object, and an error if there is any.
func (c *FakeFluentBits) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha2.FluentBit, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(fluentbitsResource, c.ns, name), &v1alpha2.FluentBit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.FluentBit), err
}

// List takes label and field selectors, and returns the list of FluentBits that match those selectors.
func (c *FakeFluentBits) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha2.FluentBitList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(fluentbitsResource, fluentbitsKind, c.ns, opts), &v1alpha2.FluentBitList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha2.FluentBitList{ListMeta: obj.(*v1alpha2.FluentBitList).ListMeta}
	for _, item := range obj.(*v1alpha2.FluentBitList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested fluentBits.
func (c *FakeFluentBits) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(fluentbitsResource, c.ns, opts))

}

// Create takes the representation of a fluentBit and creates it.  Returns the server's representation of the fluentBit, and an error, if there is any.
func (c *FakeFluentBits) Create(ctx context.Context, fluentBit *v1alpha2.FluentBit, opts v1.CreateOptions) (result *v1alpha2.FluentBit, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(fluentbitsResource, c.ns, fluentBit), &v1alpha2.FluentBit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.FluentBit), err
}

// Update takes the representation of a fluentBit and updates it. Returns the server's representation of the fluentBit, and an error, if there is any.
func (c *FakeFluentBits) Update(ctx context.Context, fluentBit *v1alpha2.FluentBit, opts v1.UpdateOptions) (result *v1alpha2.FluentBit, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(fluentbitsResource, c.ns, fluentBit), &v1alpha2.FluentBit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.FluentBit), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeFluentBits) UpdateStatus(ctx context.Context, fluentBit *v1alpha2.FluentBit, opts v1.UpdateOptions) (*v1alpha2.FluentBit, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(fluentbitsResource, "status", c.ns, fluentBit), &v1alpha2.FluentBit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.FluentBit), err
}

// Delete takes name of the fluentBit and deletes it. Returns an error if one occurs.
func (c *FakeFluentBits) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(fluentbitsResource, c.ns, name), &v1alpha2.FluentBit{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeFluentBits) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(fluentbitsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha2.FluentBitList{})
	return err
}

// Patch applies the patch and returns the patched fluentBit.
func (c *FakeFluentBits) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.FluentBit, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(fluentbitsResource, c.ns, name, pt, data, subresources...), &v1alpha2.FluentBit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.FluentBit), err
}
