/*

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha2 "kubesphere.io/fluentbit-operator/api/fluentbitoperator/v1alpha2"
)

// FakeOutputs implements OutputInterface
type FakeOutputs struct {
	Fake *FakeLoggingV1alpha2
	ns   string
}

var outputsResource = schema.GroupVersionResource{Group: "logging.kubesphere.io", Version: "v1alpha2", Resource: "outputs"}

var outputsKind = schema.GroupVersionKind{Group: "logging.kubesphere.io", Version: "v1alpha2", Kind: "Output"}

// Get takes name of the output, and returns the corresponding output object, and an error if there is any.
func (c *FakeOutputs) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha2.Output, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(outputsResource, c.ns, name), &v1alpha2.Output{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.Output), err
}

// List takes label and field selectors, and returns the list of Outputs that match those selectors.
func (c *FakeOutputs) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha2.OutputList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(outputsResource, outputsKind, c.ns, opts), &v1alpha2.OutputList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha2.OutputList{ListMeta: obj.(*v1alpha2.OutputList).ListMeta}
	for _, item := range obj.(*v1alpha2.OutputList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested outputs.
func (c *FakeOutputs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(outputsResource, c.ns, opts))

}

// Create takes the representation of a output and creates it.  Returns the server's representation of the output, and an error, if there is any.
func (c *FakeOutputs) Create(ctx context.Context, output *v1alpha2.Output, opts v1.CreateOptions) (result *v1alpha2.Output, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(outputsResource, c.ns, output), &v1alpha2.Output{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.Output), err
}

// Update takes the representation of a output and updates it. Returns the server's representation of the output, and an error, if there is any.
func (c *FakeOutputs) Update(ctx context.Context, output *v1alpha2.Output, opts v1.UpdateOptions) (result *v1alpha2.Output, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(outputsResource, c.ns, output), &v1alpha2.Output{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.Output), err
}

// Delete takes name of the output and deletes it. Returns an error if one occurs.
func (c *FakeOutputs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(outputsResource, c.ns, name), &v1alpha2.Output{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeOutputs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(outputsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha2.OutputList{})
	return err
}

// Patch applies the patch and returns the patched output.
func (c *FakeOutputs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.Output, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(outputsResource, c.ns, name, pt, data, subresources...), &v1alpha2.Output{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha2.Output), err
}
