/*

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package v1alpha2

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha2 "kubesphere.io/fluentbit-operator/api/fluentbitoperator/v1alpha2"
	scheme "kubesphere.io/fluentbit-operator/api/generated/clientset/versioned/scheme"
)

// FiltersGetter has a method to return a FilterInterface.
// A group's client should implement this interface.
type FiltersGetter interface {
	Filters(namespace string) FilterInterface
}

// FilterInterface has methods to work with Filter resources.
type FilterInterface interface {
	Create(ctx context.Context, filter *v1alpha2.Filter, opts v1.CreateOptions) (*v1alpha2.Filter, error)
	Update(ctx context.Context, filter *v1alpha2.Filter, opts v1.UpdateOptions) (*v1alpha2.Filter, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha2.Filter, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha2.FilterList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.Filter, err error)
	FilterExpansion
}

// filters implements FilterInterface
type filters struct {
	client rest.Interface
	ns     string
}

// newFilters returns a Filters
func newFilters(c *FluentbitoperatorV1alpha2Client, namespace string) *filters {
	return &filters{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the filter, and returns the corresponding filter object, and an error if there is any.
func (c *filters) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha2.Filter, err error) {
	result = &v1alpha2.Filter{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("filters").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Filters that match those selectors.
func (c *filters) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha2.FilterList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha2.FilterList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("filters").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested filters.
func (c *filters) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("filters").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a filter and creates it.  Returns the server's representation of the filter, and an error, if there is any.
func (c *filters) Create(ctx context.Context, filter *v1alpha2.Filter, opts v1.CreateOptions) (result *v1alpha2.Filter, err error) {
	result = &v1alpha2.Filter{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("filters").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(filter).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a filter and updates it. Returns the server's representation of the filter, and an error, if there is any.
func (c *filters) Update(ctx context.Context, filter *v1alpha2.Filter, opts v1.UpdateOptions) (result *v1alpha2.Filter, err error) {
	result = &v1alpha2.Filter{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("filters").
		Name(filter.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(filter).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the filter and deletes it. Returns an error if one occurs.
func (c *filters) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("filters").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *filters) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("filters").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched filter.
func (c *filters) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.Filter, err error) {
	result = &v1alpha2.Filter{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("filters").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
