//
//  SpringViewController.swift
//  DesignerNewsApp
//
//  Created by Meng To on 2015-01-02.
//  Copyright (c) 2015 Meng To. All rights reserved.
//

import UIKit
import Spring

class SpringViewController: UIViewController, UIPickerViewDelegate, UIPickerViewDataSource, OptionsViewControllerDelegate {

    @IBOutlet weak var delayLabel: UILabel!
    @IBOutlet weak var durationLabel: UILabel!
    @IBOutlet weak var forceLabel: UILabel!
    @IBOutlet weak var delaySlider: UISlider!
    @IBOutlet weak var durationSlider: UISlider!
    @IBOutlet weak var forceSlider: UISlider!
    @IBOutlet weak var ballView: SpringView!
    @IBOutlet weak var animationPicker: UIPickerView!
    
    var selectedRow: Int = 0
    var selectedEasing: Int = 0
    
    var selectedForce: CGFloat = 1
    var selectedDuration: CGFloat = 1
    var selectedDelay: CGFloat = 0
    
    var selectedDamping: CGFloat = 0.7
    var selectedVelocity: CGFloat = 0.7
    var selectedScale: CGFloat = 1
    var selectedX: CGFloat = 0
    var selectedY: CGFloat = 0
    var selectedRotate: CGFloat = 0
    
    @IBAction func forceSliderChanged(sender: AnyObject) {
        selectedForce = sender.valueForKey("value") as CGFloat
        animateView()
        forceLabel.text = String(format: "Force: %.1f", Double(selectedForce))
    }
    @IBAction func durationSliderChanged(sender: AnyObject) {
        selectedDuration = sender.valueForKey("value") as CGFloat
        animateView()
        durationLabel.text = String(format: "Duration: %.1f", Double(selectedDuration))
    }
    @IBAction func delaySliderChanged(sender: AnyObject) {
        selectedDelay = sender.valueForKey("value") as CGFloat
        animateView()
        delayLabel.text = String(format: "Delay: %.1f", Double(selectedDelay))
    }

    func dampingSliderChanged(sender: AnyObject) {
        selectedDamping = sender.valueForKey("value") as CGFloat
        animateView()
    }
    
    func velocitySliderChanged(sender: AnyObject) {
        selectedVelocity = sender.valueForKey("value") as CGFloat
        animateView()
    }
    
    func scaleSliderChanged(sender: AnyObject) {
        selectedScale = sender.valueForKey("value") as CGFloat
        animateView()
    }
    
    func xSliderChanged(sender: AnyObject) {
        selectedX = sender.valueForKey("value") as CGFloat
        animateView()
    }
    
    func ySliderChanged(sender: AnyObject) {
        selectedY = sender.valueForKey("value") as CGFloat
        animateView()
    }
    
    func rotateSliderChanged(sender: AnyObject) {
        selectedRotate = sender.valueForKey("value") as CGFloat
        animateView()
    }
    
    func animateView() {
        setOptions()
        ballView.animate()
    }
    
    func setOptions() {
        ballView.force = selectedForce
        ballView.duration = selectedDuration
        ballView.delay = selectedDelay
        
        ballView.damping = selectedDamping
        ballView.velocity = selectedVelocity
        ballView.scaleX = selectedScale
        ballView.scaleY = selectedScale
        ballView.x = selectedX
        ballView.y = selectedY
        ballView.rotate = selectedRotate
        
        ballView.animation = data[0][selectedRow]
        ballView.curve = data[1][selectedEasing]
    }
    
    func minimizeView(sender: AnyObject) {
        spring(0.7, {
            self.view.transform = CGAffineTransformMakeScale(0.935, 0.935)
        })
        UIApplication.sharedApplication().setStatusBarStyle(UIStatusBarStyle.LightContent, animated: true)
    }
    
    func maximizeView(sender: AnyObject) {
        spring(0.7, {
            self.view.transform = CGAffineTransformMakeScale(1, 1)
        })
        UIApplication.sharedApplication().setStatusBarStyle(UIStatusBarStyle.Default, animated: true)
    }
    
    var data = [[
        "shake",
        "pop",
        "morph",
        "squeeze",
        "wobble",
        "swing",
        "flipX",
        "flipY",
        "fall",
        "squeezeLeft",
        "squeezeRight",
        "squeezeDown",
        "squeezeUp",
        "slideLeft",
        "slideRight",
        "slideDown",
        "slideUp",
        "fadeIn",
        "fadeOut",
        "fadeInLeft",
        "fadeInRight",
        "fadeInDown",
        "fadeInUp",
        "zoomIn",
        "zoomOut",
        "flash",
    ], ["spring", "linear", "easeIn", "easeOut", "easeInOut"]]
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        animationPicker.delegate = self
        animationPicker.dataSource = self
        animationPicker.showsSelectionIndicator = true
    }
    
    @IBAction func ballButtonPressed(sender: AnyObject) {
        
        UIView.animateWithDuration(0.1, animations: {
            self.ballView.backgroundColor = UIColor(hex: "#69DBFF")
        }, completion: { finished in
            UIView.animateWithDuration(0.5, animations: {
                self.ballView.backgroundColor = UIColor(hex: "#279CEB")
            })
        })
        
        animateView()
    }
    
    var ballState = 0
    func changeBall() {
        switch ballState {
        case 1:
            let animation = CABasicAnimation()
            animation.keyPath = "cornerRadius"
            animation.fromValue = 50
            animation.toValue = 10
            animation.duration = 0.2
            ballView.layer.cornerRadius = 10
            ballView.layer.addAnimation(animation, forKey: "radius")
            
            ballState = 0
        default:
            let animation = CABasicAnimation()
            animation.keyPath = "cornerRadius"
            animation.fromValue = 10
            animation.toValue = 50
            animation.duration = 0.2
            ballView.layer.cornerRadius = 50
            ballView.layer.addAnimation(animation, forKey: "radius")
            
            ballState++
        }
        
        let animation = CABasicAnimation()
        animation.keyPath = "opacity"
        animation.fromValue = 1
        animation.toValue = 0
        animation.duration = 0.2
        animation.autoreverses = true
        ballView.layer.addAnimation(animation, forKey: "fade")
    }
    
    @IBAction func shapeButtonPressed(sender: AnyObject) {
        changeBall()
    }
    
    func resetButtonPressed(sender: AnyObject) {
        selectedForce = 1
        selectedDuration = 1
        selectedDelay = 0
        
        selectedDamping = 0.7
        selectedVelocity = 0.7
        selectedScale = 1
        selectedX = 0
        selectedY = 0
        selectedRotate = 0
        
        forceSlider.setValue(Float(selectedForce), animated: true)
        durationSlider.setValue(Float(selectedDuration), animated: true)
        delaySlider.setValue(Float(selectedDelay), animated: true)
        
        forceLabel.text = String(format: "Force: %.1f", Double(selectedForce))
        durationLabel.text = String(format: "Duration: %.1f", Double(selectedDuration))
        delayLabel.text = String(format: "Delay: %.1f", Double(selectedDelay))
    }
    
    func numberOfComponentsInPickerView(pickerView: UIPickerView) -> Int {
        return 2
    }
    
    func pickerView(pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        return data[component].count
    }
    
    func pickerView(pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String! {
        return data[component][row]
    }
    
    func pickerView(pickerView: UIPickerView, didSelectRow row: Int, inComponent component: Int) {
        switch component {
        case 0:
            selectedRow = row
            animateView()
        default:
            selectedEasing = row
            animateView()
        }
    }
    
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        if let optionsViewController = segue.destinationViewController as? OptionsViewController {
            optionsViewController.delegate = self
            setOptions()
            optionsViewController.data = ballView
        }
        else if let codeViewController = segue.destinationViewController as? CodeViewController {
            setOptions()
            codeViewController.data = ballView
        }
    }
}