/**
 * Swagger Petstore
 * This is a sample server Petstore server.  You can find out more about Swagger at <a href=\"http://swagger.io\">http://swagger.io</a> or on irc.freenode.net, #swagger.  For this sample, you can use the api key \"special-key\" to test the authorization filters
 *
 * OpenAPI spec version: 1.0.0
 * Contact: apiteam@wordnik.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

import * as querystring from "querystring";
import * as url from "url";

import * as isomorphicFetch from "isomorphic-fetch";

interface Dictionary<T> { [index: string]: T; }
export interface FetchAPI { (url: string, init?: any): Promise<any>; }

const BASE_PATH = "http://petstore.swagger.io/v2".replace(/\/+$/, "");

export interface FetchArgs {
    url: string;
    options: any;
}

export class BaseAPI {
    basePath: string;
    fetch: FetchAPI;

    constructor(fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) {
        this.basePath = basePath;
        this.fetch = fetch;
    }
};

export interface Category {
    "id"?: number;
    "name"?: string;
}

export interface Order {
    "id"?: number;
    "petId"?: number;
    "quantity"?: number;
    "shipDate"?: Date;
    /**
     * Order Status
     */
    "status"?: OrderStatusEnum;
    "complete"?: boolean;
}

export type OrderStatusEnum = "placed" | "approved" | "delivered";
export interface Pet {
    "id"?: number;
    "category"?: Category;
    "name": string;
    "photoUrls": Array<string>;
    "tags"?: Array<Tag>;
    /**
     * pet status in the store
     */
    "status"?: PetStatusEnum;
}

export type PetStatusEnum = "available" | "pending" | "sold";
export interface Tag {
    "id"?: number;
    "name"?: string;
}

export interface User {
    "id"?: number;
    "username"?: string;
    "firstName"?: string;
    "lastName"?: string;
    "email"?: string;
    "password"?: string;
    "phone"?: string;
    /**
     * User Status
     */
    "userStatus"?: number;
}



/**
 * PetApi - fetch parameter creator
 */
export const PetApiFetchParamCreator = {
    /** 
     * Add a new pet to the store
     * 
     * @param body Pet object that needs to be added to the store
     */
    addPet(params: {  "body"?: Pet; }, options?: any): FetchArgs {
        const baseUrl = `/pet`;
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "POST" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        contentTypeHeader = { "Content-Type": "application/json" };
        if (params["body"]) {
            fetchOptions.body = JSON.stringify(params["body"] || {});
        }
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Deletes a pet
     * 
     * @param petId Pet id to delete
     * @param apiKey 
     */
    deletePet(params: {  "petId": number; "apiKey"?: string; }, options?: any): FetchArgs {
        // verify required parameter "petId" is set
        if (params["petId"] == null) {
            throw new Error("Missing required parameter petId when calling deletePet");
        }
        const baseUrl = `/pet/{petId}`
            .replace(`{${"petId"}}`, `${ params["petId"] }`);
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "DELETE" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        fetchOptions.headers = Object.assign({
            "api_key": params["apiKey"],
        }, contentTypeHeader);
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Finds Pets by status
     * Multiple status values can be provided with comma separated strings
     * @param status Status values that need to be considered for filter
     */
    findPetsByStatus(params: {  "status"?: Array<string>; }, options?: any): FetchArgs {
        const baseUrl = `/pet/findByStatus`;
        let urlObj = url.parse(baseUrl, true);
        urlObj.query = Object.assign({}, urlObj.query, {
            "status": params["status"],
        });
        let fetchOptions: RequestInit = Object.assign({}, { method: "GET" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Finds Pets by tags
     * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
     * @param tags Tags to filter by
     */
    findPetsByTags(params: {  "tags"?: Array<string>; }, options?: any): FetchArgs {
        const baseUrl = `/pet/findByTags`;
        let urlObj = url.parse(baseUrl, true);
        urlObj.query = Object.assign({}, urlObj.query, {
            "tags": params["tags"],
        });
        let fetchOptions: RequestInit = Object.assign({}, { method: "GET" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Find pet by ID
     * Returns a pet when ID &lt; 10.  ID &gt; 10 or nonintegers will simulate API error conditions
     * @param petId ID of pet that needs to be fetched
     */
    getPetById(params: {  "petId": number; }, options?: any): FetchArgs {
        // verify required parameter "petId" is set
        if (params["petId"] == null) {
            throw new Error("Missing required parameter petId when calling getPetById");
        }
        const baseUrl = `/pet/{petId}`
            .replace(`{${"petId"}}`, `${ params["petId"] }`);
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "GET" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Update an existing pet
     * 
     * @param body Pet object that needs to be added to the store
     */
    updatePet(params: {  "body"?: Pet; }, options?: any): FetchArgs {
        const baseUrl = `/pet`;
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "PUT" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        contentTypeHeader = { "Content-Type": "application/json" };
        if (params["body"]) {
            fetchOptions.body = JSON.stringify(params["body"] || {});
        }
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Updates a pet in the store with form data
     * 
     * @param petId ID of pet that needs to be updated
     * @param name Updated name of the pet
     * @param status Updated status of the pet
     */
    updatePetWithForm(params: {  "petId": string; "name"?: string; "status"?: string; }, options?: any): FetchArgs {
        // verify required parameter "petId" is set
        if (params["petId"] == null) {
            throw new Error("Missing required parameter petId when calling updatePetWithForm");
        }
        const baseUrl = `/pet/{petId}`
            .replace(`{${"petId"}}`, `${ params["petId"] }`);
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "POST" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        contentTypeHeader = { "Content-Type": "application/x-www-form-urlencoded" };
        fetchOptions.body = querystring.stringify({
            "name": params["name"],
            "status": params["status"],
        });
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * uploads an image
     * 
     * @param petId ID of pet to update
     * @param additionalMetadata Additional data to pass to server
     * @param file file to upload
     */
    uploadFile(params: {  "petId": number; "additionalMetadata"?: string; "file"?: any; }, options?: any): FetchArgs {
        // verify required parameter "petId" is set
        if (params["petId"] == null) {
            throw new Error("Missing required parameter petId when calling uploadFile");
        }
        const baseUrl = `/pet/{petId}/uploadImage`
            .replace(`{${"petId"}}`, `${ params["petId"] }`);
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "POST" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        contentTypeHeader = { "Content-Type": "application/x-www-form-urlencoded" };
        fetchOptions.body = querystring.stringify({
            "additionalMetadata": params["additionalMetadata"],
            "file": params["file"],
        });
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
};

/**
 * PetApi - functional programming interface
 */
export const PetApiFp = {
    /** 
     * Add a new pet to the store
     * 
     * @param body Pet object that needs to be added to the store
     */
    addPet(params: { "body"?: Pet;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
        const fetchArgs = PetApiFetchParamCreator.addPet(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response;
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Deletes a pet
     * 
     * @param petId Pet id to delete
     * @param apiKey 
     */
    deletePet(params: { "petId": number; "apiKey"?: string;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
        const fetchArgs = PetApiFetchParamCreator.deletePet(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response;
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Finds Pets by status
     * Multiple status values can be provided with comma separated strings
     * @param status Status values that need to be considered for filter
     */
    findPetsByStatus(params: { "status"?: Array<string>;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<Array<Pet>> {
        const fetchArgs = PetApiFetchParamCreator.findPetsByStatus(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response.json();
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Finds Pets by tags
     * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
     * @param tags Tags to filter by
     */
    findPetsByTags(params: { "tags"?: Array<string>;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<Array<Pet>> {
        const fetchArgs = PetApiFetchParamCreator.findPetsByTags(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response.json();
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Find pet by ID
     * Returns a pet when ID &lt; 10.  ID &gt; 10 or nonintegers will simulate API error conditions
     * @param petId ID of pet that needs to be fetched
     */
    getPetById(params: { "petId": number;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<Pet> {
        const fetchArgs = PetApiFetchParamCreator.getPetById(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response.json();
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Update an existing pet
     * 
     * @param body Pet object that needs to be added to the store
     */
    updatePet(params: { "body"?: Pet;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
        const fetchArgs = PetApiFetchParamCreator.updatePet(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response;
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Updates a pet in the store with form data
     * 
     * @param petId ID of pet that needs to be updated
     * @param name Updated name of the pet
     * @param status Updated status of the pet
     */
    updatePetWithForm(params: { "petId": string; "name"?: string; "status"?: string;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
        const fetchArgs = PetApiFetchParamCreator.updatePetWithForm(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response;
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * uploads an image
     * 
     * @param petId ID of pet to update
     * @param additionalMetadata Additional data to pass to server
     * @param file file to upload
     */
    uploadFile(params: { "petId": number; "additionalMetadata"?: string; "file"?: any;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
        const fetchArgs = PetApiFetchParamCreator.uploadFile(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response;
                } else {
                    throw response;
                }
            });
        };
    },
};

/**
 * PetApi - object-oriented interface
 */
export class PetApi extends BaseAPI {
    /** 
     * Add a new pet to the store
     * 
     * @param body Pet object that needs to be added to the store
     */
    addPet(params: {  "body"?: Pet; }, options?: any) {
        return PetApiFp.addPet(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Deletes a pet
     * 
     * @param petId Pet id to delete
     * @param apiKey 
     */
    deletePet(params: {  "petId": number; "apiKey"?: string; }, options?: any) {
        return PetApiFp.deletePet(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Finds Pets by status
     * Multiple status values can be provided with comma separated strings
     * @param status Status values that need to be considered for filter
     */
    findPetsByStatus(params: {  "status"?: Array<string>; }, options?: any) {
        return PetApiFp.findPetsByStatus(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Finds Pets by tags
     * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
     * @param tags Tags to filter by
     */
    findPetsByTags(params: {  "tags"?: Array<string>; }, options?: any) {
        return PetApiFp.findPetsByTags(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Find pet by ID
     * Returns a pet when ID &lt; 10.  ID &gt; 10 or nonintegers will simulate API error conditions
     * @param petId ID of pet that needs to be fetched
     */
    getPetById(params: {  "petId": number; }, options?: any) {
        return PetApiFp.getPetById(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Update an existing pet
     * 
     * @param body Pet object that needs to be added to the store
     */
    updatePet(params: {  "body"?: Pet; }, options?: any) {
        return PetApiFp.updatePet(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Updates a pet in the store with form data
     * 
     * @param petId ID of pet that needs to be updated
     * @param name Updated name of the pet
     * @param status Updated status of the pet
     */
    updatePetWithForm(params: {  "petId": string; "name"?: string; "status"?: string; }, options?: any) {
        return PetApiFp.updatePetWithForm(params, options)(this.fetch, this.basePath);
    }
    /** 
     * uploads an image
     * 
     * @param petId ID of pet to update
     * @param additionalMetadata Additional data to pass to server
     * @param file file to upload
     */
    uploadFile(params: {  "petId": number; "additionalMetadata"?: string; "file"?: any; }, options?: any) {
        return PetApiFp.uploadFile(params, options)(this.fetch, this.basePath);
    }
};

/**
 * PetApi - factory interface
 */
export const PetApiFactory = function (fetch?: FetchAPI, basePath?: string) {
    return {
        /** 
         * Add a new pet to the store
         * 
         * @param body Pet object that needs to be added to the store
         */
        addPet(params: {  "body"?: Pet; }, options?: any) {
            return PetApiFp.addPet(params, options)(fetch, basePath);
        },
        /** 
         * Deletes a pet
         * 
         * @param petId Pet id to delete
         * @param apiKey 
         */
        deletePet(params: {  "petId": number; "apiKey"?: string; }, options?: any) {
            return PetApiFp.deletePet(params, options)(fetch, basePath);
        },
        /** 
         * Finds Pets by status
         * Multiple status values can be provided with comma separated strings
         * @param status Status values that need to be considered for filter
         */
        findPetsByStatus(params: {  "status"?: Array<string>; }, options?: any) {
            return PetApiFp.findPetsByStatus(params, options)(fetch, basePath);
        },
        /** 
         * Finds Pets by tags
         * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
         * @param tags Tags to filter by
         */
        findPetsByTags(params: {  "tags"?: Array<string>; }, options?: any) {
            return PetApiFp.findPetsByTags(params, options)(fetch, basePath);
        },
        /** 
         * Find pet by ID
         * Returns a pet when ID &lt; 10.  ID &gt; 10 or nonintegers will simulate API error conditions
         * @param petId ID of pet that needs to be fetched
         */
        getPetById(params: {  "petId": number; }, options?: any) {
            return PetApiFp.getPetById(params, options)(fetch, basePath);
        },
        /** 
         * Update an existing pet
         * 
         * @param body Pet object that needs to be added to the store
         */
        updatePet(params: {  "body"?: Pet; }, options?: any) {
            return PetApiFp.updatePet(params, options)(fetch, basePath);
        },
        /** 
         * Updates a pet in the store with form data
         * 
         * @param petId ID of pet that needs to be updated
         * @param name Updated name of the pet
         * @param status Updated status of the pet
         */
        updatePetWithForm(params: {  "petId": string; "name"?: string; "status"?: string; }, options?: any) {
            return PetApiFp.updatePetWithForm(params, options)(fetch, basePath);
        },
        /** 
         * uploads an image
         * 
         * @param petId ID of pet to update
         * @param additionalMetadata Additional data to pass to server
         * @param file file to upload
         */
        uploadFile(params: {  "petId": number; "additionalMetadata"?: string; "file"?: any; }, options?: any) {
            return PetApiFp.uploadFile(params, options)(fetch, basePath);
        },
    };
};


/**
 * StoreApi - fetch parameter creator
 */
export const StoreApiFetchParamCreator = {
    /** 
     * Delete purchase order by ID
     * For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
     * @param orderId ID of the order that needs to be deleted
     */
    deleteOrder(params: {  "orderId": string; }, options?: any): FetchArgs {
        // verify required parameter "orderId" is set
        if (params["orderId"] == null) {
            throw new Error("Missing required parameter orderId when calling deleteOrder");
        }
        const baseUrl = `/store/order/{orderId}`
            .replace(`{${"orderId"}}`, `${ params["orderId"] }`);
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "DELETE" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Returns pet inventories by status
     * Returns a map of status codes to quantities
     */
    getInventory(options?: any): FetchArgs {
        const baseUrl = `/store/inventory`;
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "GET" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Find purchase order by ID
     * For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generated exceptions
     * @param orderId ID of pet that needs to be fetched
     */
    getOrderById(params: {  "orderId": string; }, options?: any): FetchArgs {
        // verify required parameter "orderId" is set
        if (params["orderId"] == null) {
            throw new Error("Missing required parameter orderId when calling getOrderById");
        }
        const baseUrl = `/store/order/{orderId}`
            .replace(`{${"orderId"}}`, `${ params["orderId"] }`);
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "GET" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Place an order for a pet
     * 
     * @param body order placed for purchasing the pet
     */
    placeOrder(params: {  "body"?: Order; }, options?: any): FetchArgs {
        const baseUrl = `/store/order`;
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "POST" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        contentTypeHeader = { "Content-Type": "application/json" };
        if (params["body"]) {
            fetchOptions.body = JSON.stringify(params["body"] || {});
        }
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
};

/**
 * StoreApi - functional programming interface
 */
export const StoreApiFp = {
    /** 
     * Delete purchase order by ID
     * For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
     * @param orderId ID of the order that needs to be deleted
     */
    deleteOrder(params: { "orderId": string;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
        const fetchArgs = StoreApiFetchParamCreator.deleteOrder(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response;
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Returns pet inventories by status
     * Returns a map of status codes to quantities
     */
    getInventory(options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<{ [key: string]: number; }> {
        const fetchArgs = StoreApiFetchParamCreator.getInventory(options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response.json();
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Find purchase order by ID
     * For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generated exceptions
     * @param orderId ID of pet that needs to be fetched
     */
    getOrderById(params: { "orderId": string;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<Order> {
        const fetchArgs = StoreApiFetchParamCreator.getOrderById(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response.json();
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Place an order for a pet
     * 
     * @param body order placed for purchasing the pet
     */
    placeOrder(params: { "body"?: Order;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<Order> {
        const fetchArgs = StoreApiFetchParamCreator.placeOrder(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response.json();
                } else {
                    throw response;
                }
            });
        };
    },
};

/**
 * StoreApi - object-oriented interface
 */
export class StoreApi extends BaseAPI {
    /** 
     * Delete purchase order by ID
     * For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
     * @param orderId ID of the order that needs to be deleted
     */
    deleteOrder(params: {  "orderId": string; }, options?: any) {
        return StoreApiFp.deleteOrder(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Returns pet inventories by status
     * Returns a map of status codes to quantities
     */
    getInventory(options?: any) {
        return StoreApiFp.getInventory(options)(this.fetch, this.basePath);
    }
    /** 
     * Find purchase order by ID
     * For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generated exceptions
     * @param orderId ID of pet that needs to be fetched
     */
    getOrderById(params: {  "orderId": string; }, options?: any) {
        return StoreApiFp.getOrderById(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Place an order for a pet
     * 
     * @param body order placed for purchasing the pet
     */
    placeOrder(params: {  "body"?: Order; }, options?: any) {
        return StoreApiFp.placeOrder(params, options)(this.fetch, this.basePath);
    }
};

/**
 * StoreApi - factory interface
 */
export const StoreApiFactory = function (fetch?: FetchAPI, basePath?: string) {
    return {
        /** 
         * Delete purchase order by ID
         * For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
         * @param orderId ID of the order that needs to be deleted
         */
        deleteOrder(params: {  "orderId": string; }, options?: any) {
            return StoreApiFp.deleteOrder(params, options)(fetch, basePath);
        },
        /** 
         * Returns pet inventories by status
         * Returns a map of status codes to quantities
         */
        getInventory(options?: any) {
            return StoreApiFp.getInventory(options)(fetch, basePath);
        },
        /** 
         * Find purchase order by ID
         * For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generated exceptions
         * @param orderId ID of pet that needs to be fetched
         */
        getOrderById(params: {  "orderId": string; }, options?: any) {
            return StoreApiFp.getOrderById(params, options)(fetch, basePath);
        },
        /** 
         * Place an order for a pet
         * 
         * @param body order placed for purchasing the pet
         */
        placeOrder(params: {  "body"?: Order; }, options?: any) {
            return StoreApiFp.placeOrder(params, options)(fetch, basePath);
        },
    };
};


/**
 * UserApi - fetch parameter creator
 */
export const UserApiFetchParamCreator = {
    /** 
     * Create user
     * This can only be done by the logged in user.
     * @param body Created user object
     */
    createUser(params: {  "body"?: User; }, options?: any): FetchArgs {
        const baseUrl = `/user`;
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "POST" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        contentTypeHeader = { "Content-Type": "application/json" };
        if (params["body"]) {
            fetchOptions.body = JSON.stringify(params["body"] || {});
        }
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Creates list of users with given input array
     * 
     * @param body List of user object
     */
    createUsersWithArrayInput(params: {  "body"?: Array<User>; }, options?: any): FetchArgs {
        const baseUrl = `/user/createWithArray`;
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "POST" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        contentTypeHeader = { "Content-Type": "application/json" };
        if (params["body"]) {
            fetchOptions.body = JSON.stringify(params["body"] || {});
        }
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Creates list of users with given input array
     * 
     * @param body List of user object
     */
    createUsersWithListInput(params: {  "body"?: Array<User>; }, options?: any): FetchArgs {
        const baseUrl = `/user/createWithList`;
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "POST" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        contentTypeHeader = { "Content-Type": "application/json" };
        if (params["body"]) {
            fetchOptions.body = JSON.stringify(params["body"] || {});
        }
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Delete user
     * This can only be done by the logged in user.
     * @param username The name that needs to be deleted
     */
    deleteUser(params: {  "username": string; }, options?: any): FetchArgs {
        // verify required parameter "username" is set
        if (params["username"] == null) {
            throw new Error("Missing required parameter username when calling deleteUser");
        }
        const baseUrl = `/user/{username}`
            .replace(`{${"username"}}`, `${ params["username"] }`);
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "DELETE" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Get user by user name
     * 
     * @param username The name that needs to be fetched. Use user1 for testing. 
     */
    getUserByName(params: {  "username": string; }, options?: any): FetchArgs {
        // verify required parameter "username" is set
        if (params["username"] == null) {
            throw new Error("Missing required parameter username when calling getUserByName");
        }
        const baseUrl = `/user/{username}`
            .replace(`{${"username"}}`, `${ params["username"] }`);
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "GET" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Logs user into the system
     * 
     * @param username The user name for login
     * @param password The password for login in clear text
     */
    loginUser(params: {  "username"?: string; "password"?: string; }, options?: any): FetchArgs {
        const baseUrl = `/user/login`;
        let urlObj = url.parse(baseUrl, true);
        urlObj.query = Object.assign({}, urlObj.query, {
            "username": params["username"],
            "password": params["password"],
        });
        let fetchOptions: RequestInit = Object.assign({}, { method: "GET" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Logs out current logged in user session
     * 
     */
    logoutUser(options?: any): FetchArgs {
        const baseUrl = `/user/logout`;
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "GET" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
    /** 
     * Updated user
     * This can only be done by the logged in user.
     * @param username name that need to be deleted
     * @param body Updated user object
     */
    updateUser(params: {  "username": string; "body"?: User; }, options?: any): FetchArgs {
        // verify required parameter "username" is set
        if (params["username"] == null) {
            throw new Error("Missing required parameter username when calling updateUser");
        }
        const baseUrl = `/user/{username}`
            .replace(`{${"username"}}`, `${ params["username"] }`);
        let urlObj = url.parse(baseUrl, true);
        let fetchOptions: RequestInit = Object.assign({}, { method: "PUT" }, options);

        let contentTypeHeader: Dictionary<string> = {};
        contentTypeHeader = { "Content-Type": "application/json" };
        if (params["body"]) {
            fetchOptions.body = JSON.stringify(params["body"] || {});
        }
        if (contentTypeHeader) {
            fetchOptions.headers = contentTypeHeader;
        }
        return {
            url: url.format(urlObj),
            options: fetchOptions,
        };
    },
};

/**
 * UserApi - functional programming interface
 */
export const UserApiFp = {
    /** 
     * Create user
     * This can only be done by the logged in user.
     * @param body Created user object
     */
    createUser(params: { "body"?: User;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
        const fetchArgs = UserApiFetchParamCreator.createUser(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response;
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Creates list of users with given input array
     * 
     * @param body List of user object
     */
    createUsersWithArrayInput(params: { "body"?: Array<User>;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
        const fetchArgs = UserApiFetchParamCreator.createUsersWithArrayInput(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response;
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Creates list of users with given input array
     * 
     * @param body List of user object
     */
    createUsersWithListInput(params: { "body"?: Array<User>;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
        const fetchArgs = UserApiFetchParamCreator.createUsersWithListInput(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response;
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Delete user
     * This can only be done by the logged in user.
     * @param username The name that needs to be deleted
     */
    deleteUser(params: { "username": string;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
        const fetchArgs = UserApiFetchParamCreator.deleteUser(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response;
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Get user by user name
     * 
     * @param username The name that needs to be fetched. Use user1 for testing. 
     */
    getUserByName(params: { "username": string;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<User> {
        const fetchArgs = UserApiFetchParamCreator.getUserByName(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response.json();
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Logs user into the system
     * 
     * @param username The user name for login
     * @param password The password for login in clear text
     */
    loginUser(params: { "username"?: string; "password"?: string;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<string> {
        const fetchArgs = UserApiFetchParamCreator.loginUser(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response.json();
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Logs out current logged in user session
     * 
     */
    logoutUser(options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
        const fetchArgs = UserApiFetchParamCreator.logoutUser(options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response;
                } else {
                    throw response;
                }
            });
        };
    },
    /** 
     * Updated user
     * This can only be done by the logged in user.
     * @param username name that need to be deleted
     * @param body Updated user object
     */
    updateUser(params: { "username": string; "body"?: User;  }, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
        const fetchArgs = UserApiFetchParamCreator.updateUser(params, options);
        return (fetch: FetchAPI = isomorphicFetch, basePath: string = BASE_PATH) => {
            return fetch(basePath + fetchArgs.url, fetchArgs.options).then((response) => {
                if (response.status >= 200 && response.status < 300) {
                    return response;
                } else {
                    throw response;
                }
            });
        };
    },
};

/**
 * UserApi - object-oriented interface
 */
export class UserApi extends BaseAPI {
    /** 
     * Create user
     * This can only be done by the logged in user.
     * @param body Created user object
     */
    createUser(params: {  "body"?: User; }, options?: any) {
        return UserApiFp.createUser(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Creates list of users with given input array
     * 
     * @param body List of user object
     */
    createUsersWithArrayInput(params: {  "body"?: Array<User>; }, options?: any) {
        return UserApiFp.createUsersWithArrayInput(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Creates list of users with given input array
     * 
     * @param body List of user object
     */
    createUsersWithListInput(params: {  "body"?: Array<User>; }, options?: any) {
        return UserApiFp.createUsersWithListInput(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Delete user
     * This can only be done by the logged in user.
     * @param username The name that needs to be deleted
     */
    deleteUser(params: {  "username": string; }, options?: any) {
        return UserApiFp.deleteUser(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Get user by user name
     * 
     * @param username The name that needs to be fetched. Use user1 for testing. 
     */
    getUserByName(params: {  "username": string; }, options?: any) {
        return UserApiFp.getUserByName(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Logs user into the system
     * 
     * @param username The user name for login
     * @param password The password for login in clear text
     */
    loginUser(params: {  "username"?: string; "password"?: string; }, options?: any) {
        return UserApiFp.loginUser(params, options)(this.fetch, this.basePath);
    }
    /** 
     * Logs out current logged in user session
     * 
     */
    logoutUser(options?: any) {
        return UserApiFp.logoutUser(options)(this.fetch, this.basePath);
    }
    /** 
     * Updated user
     * This can only be done by the logged in user.
     * @param username name that need to be deleted
     * @param body Updated user object
     */
    updateUser(params: {  "username": string; "body"?: User; }, options?: any) {
        return UserApiFp.updateUser(params, options)(this.fetch, this.basePath);
    }
};

/**
 * UserApi - factory interface
 */
export const UserApiFactory = function (fetch?: FetchAPI, basePath?: string) {
    return {
        /** 
         * Create user
         * This can only be done by the logged in user.
         * @param body Created user object
         */
        createUser(params: {  "body"?: User; }, options?: any) {
            return UserApiFp.createUser(params, options)(fetch, basePath);
        },
        /** 
         * Creates list of users with given input array
         * 
         * @param body List of user object
         */
        createUsersWithArrayInput(params: {  "body"?: Array<User>; }, options?: any) {
            return UserApiFp.createUsersWithArrayInput(params, options)(fetch, basePath);
        },
        /** 
         * Creates list of users with given input array
         * 
         * @param body List of user object
         */
        createUsersWithListInput(params: {  "body"?: Array<User>; }, options?: any) {
            return UserApiFp.createUsersWithListInput(params, options)(fetch, basePath);
        },
        /** 
         * Delete user
         * This can only be done by the logged in user.
         * @param username The name that needs to be deleted
         */
        deleteUser(params: {  "username": string; }, options?: any) {
            return UserApiFp.deleteUser(params, options)(fetch, basePath);
        },
        /** 
         * Get user by user name
         * 
         * @param username The name that needs to be fetched. Use user1 for testing. 
         */
        getUserByName(params: {  "username": string; }, options?: any) {
            return UserApiFp.getUserByName(params, options)(fetch, basePath);
        },
        /** 
         * Logs user into the system
         * 
         * @param username The user name for login
         * @param password The password for login in clear text
         */
        loginUser(params: {  "username"?: string; "password"?: string; }, options?: any) {
            return UserApiFp.loginUser(params, options)(fetch, basePath);
        },
        /** 
         * Logs out current logged in user session
         * 
         */
        logoutUser(options?: any) {
            return UserApiFp.logoutUser(options)(fetch, basePath);
        },
        /** 
         * Updated user
         * This can only be done by the logged in user.
         * @param username name that need to be deleted
         * @param body Updated user object
         */
        updateUser(params: {  "username": string; "body"?: User; }, options?: any) {
            return UserApiFp.updateUser(params, options)(fetch, basePath);
        },
    };
};

