using System;
using System.IO;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Reflection;
using RestSharp;
using NUnit.Framework;
using Newtonsoft.Json;

using IO.Swagger.Client;
using IO.Swagger.Api;
using IO.Swagger.Model;

namespace IO.Swagger.Test
{
    /// <summary>
    ///  Class for testing StoreApi
    /// </summary>
    /// <remarks>
    /// This file is automatically generated by Swagger Codegen.
    /// Please update the test case below to test the API endpoint.
    /// </remarks>
    [TestFixture]
    public class StoreApiTests
    {
        private StoreApi instance;

        /// <summary>
        /// Setup before each unit test
        /// </summary>
        [SetUp]
        public void Init()
        {
           instance = new StoreApi();
        }

        /// <summary>
        /// Clean up after each unit test
        /// </summary>
        [TearDown]
        public void Cleanup()
        {

        }

        /// <summary>
        /// Test an instance of StoreApi
        /// </summary>
        [Test]
        public void InstanceTest()
        {
			Assert.IsInstanceOfType(typeof(StoreApi), instance, "instance is a StoreApi");
        }

        
        /// <summary>
        /// Test DeleteOrder
        /// </summary>
        [Test]
        public void DeleteOrderTest()
        {
            // TODO: add unit test for the method 'DeleteOrder'
            //string orderId = null; // TODO: replace null with proper value
            //instance.DeleteOrder(orderId);
            
        }
        
        /// <summary>
        /// Test GetInventory
        /// </summary>
        [Test]
        public void GetInventoryTest()
        {
            // TODO: add unit test for the method 'GetInventory'
            //var response = instance.GetInventory();
            //Assert.IsInstanceOf<Dictionary<string, int?>> (response, "response is Dictionary<string, int?>");

			// set timeout to 10 seconds
			Configuration c1 = new Configuration (timeout: 10000);

			StoreApi storeApi = new StoreApi (c1);
			Dictionary<String, int?> response = storeApi.GetInventory ();

			foreach(KeyValuePair<string, int?> entry in response)
			{
				Assert.IsInstanceOfType(typeof(int?), entry.Value);
			}
        }
        
        /// <summary>
        /// Test GetOrderById
        /// </summary>
        [Test]
        public void GetOrderByIdTest()
        {
            // TODO: add unit test for the method 'GetOrderById'
            //long? orderId = null; // TODO: replace null with proper value
            //var response = instance.GetOrderById(orderId);
            //Assert.IsInstanceOf<Order> (response, "response is Order");
        }
        
        /// <summary>
        /// Test PlaceOrder
        /// </summary>
        [Test]
        public void PlaceOrderTest()
        {
            // TODO: add unit test for the method 'PlaceOrder'
            //Order body = null; // TODO: replace null with proper value
            //var response = instance.PlaceOrder(body);
            //Assert.IsInstanceOf<Order> (response, "response is Order");
        }
        
		/// <summary>
		/// Test Enum
		/// </summary>
		[Test ()]
		public void TestEnum ()
		{
			Assert.AreEqual (Order.StatusEnum.Approved.ToString(), "Approved");
		}

		/// <summary>
		/// Test deserialization of JSON to Order and its readonly property
		/// </summary>
		[Test ()]
		public void TesOrderDeserialization()
		{
			string json = @"{
'id': 1982,
'petId': 1020,
'quantity': 1,
'status': 'placed',
'complete': true,
}";
			var o = JsonConvert.DeserializeObject<Order>(json);
			Assert.AreEqual (1982, o.Id);
			Assert.AreEqual (1020, o.PetId);
			Assert.AreEqual (1, o.Quantity);
			Assert.AreEqual (Order.StatusEnum.Placed, o.Status);
			Assert.AreEqual (true, o.Complete);

		}
    }

}
