//
// StoreAPI.swift
//
// Generated by swagger-codegen
// https://github.com/swagger-api/swagger-codegen
//

import Alamofire
import PromiseKit

extension PetstoreClientAPI {
    
    class StoreAPI: APIBase {
    
        /**
         
         Returns pet inventories by status
         
         - GET /store/inventory
         - Returns a map of status codes to quantities
         - API Key:
           - type: apiKey api_key 
           - name: api_key
         - examples: [{example={
  "key" : 123
}, contentType=application/json}, {example=not implemented io.swagger.models.properties.MapProperty@3e, contentType=application/xml}]
         - examples: [{example={
  "key" : 123
}, contentType=application/json}, {example=not implemented io.swagger.models.properties.MapProperty@3e, contentType=application/xml}]

         :returns: Promise<Response<[String:Int]>> 
         */
        func getInventory() -> RequestBuilder<[String:Int]> {
            let path = "/store/inventory"
            let url = PetstoreClientAPI.basePath + path
            
            let nillableParameters: [String:AnyObject?] = [:]
            let parameters = APIHelper.rejectNil(nillableParameters)

            let requestBuilder: RequestBuilder<[String:Int]>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "GET", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         Place an order for a pet
         
         - POST /store/order
         - 
         - examples: [{example={
  "id" : 123456789,
  "petId" : 123456789,
  "complete" : true,
  "status" : "aeiou",
  "quantity" : 123,
  "shipDate" : "2015-06-27T13:41:28.102+0000"
}, contentType=application/json}, {example=<Order>
  <id>123456</id>
  <petId>123456</petId>
  <quantity>0</quantity>
  <shipDate>2015-06-27T22:41:28.105Z</shipDate>
  <status>string</status>
  <complete>true</complete>
</Order>, contentType=application/xml}]
         - examples: [{example={
  "id" : 123456789,
  "petId" : 123456789,
  "complete" : true,
  "status" : "aeiou",
  "quantity" : 123,
  "shipDate" : "2015-06-27T13:41:28.102+0000"
}, contentType=application/json}, {example=<Order>
  <id>123456</id>
  <petId>123456</petId>
  <quantity>0</quantity>
  <shipDate>2015-06-27T22:41:28.105Z</shipDate>
  <status>string</status>
  <complete>true</complete>
</Order>, contentType=application/xml}]
         
         :param: body (body) order placed for purchasing the pet

         :returns: Promise<Response<Order>> 
         */
        func placeOrder(#body: Order?) -> RequestBuilder<Order> {
            let path = "/store/order"
            let url = PetstoreClientAPI.basePath + path
            
            let parameters = body?.encodeToJSON() as? [String:AnyObject]

            let requestBuilder: RequestBuilder<Order>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "POST", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         Find purchase order by ID
         
         - GET /store/order/{orderId}
         - For valid response try integer IDs with value <= 5 or > 10. Other values will generated exceptions
         - examples: [{example={
  "id" : 123456789,
  "petId" : 123456789,
  "complete" : true,
  "status" : "aeiou",
  "quantity" : 123,
  "shipDate" : "2015-06-27T13:41:28.106+0000"
}, contentType=application/json}, {example=<Order>
  <id>123456</id>
  <petId>123456</petId>
  <quantity>0</quantity>
  <shipDate>2015-06-27T22:41:28.106Z</shipDate>
  <status>string</status>
  <complete>true</complete>
</Order>, contentType=application/xml}]
         - examples: [{example={
  "id" : 123456789,
  "petId" : 123456789,
  "complete" : true,
  "status" : "aeiou",
  "quantity" : 123,
  "shipDate" : "2015-06-27T13:41:28.106+0000"
}, contentType=application/json}, {example=<Order>
  <id>123456</id>
  <petId>123456</petId>
  <quantity>0</quantity>
  <shipDate>2015-06-27T22:41:28.106Z</shipDate>
  <status>string</status>
  <complete>true</complete>
</Order>, contentType=application/xml}]
         
         :param: orderId (path) ID of pet that needs to be fetched

         :returns: Promise<Response<Order>> 
         */
        func getOrderById(#orderId: String) -> RequestBuilder<Order> {
            var path = "/store/order/{orderId}"
            path = path.stringByReplacingOccurrencesOfString("{orderId}", withString: "\(orderId)", options: .LiteralSearch, range: nil)
            let url = PetstoreClientAPI.basePath + path
            
            let nillableParameters: [String:AnyObject?] = [:]
            let parameters = APIHelper.rejectNil(nillableParameters)

            let requestBuilder: RequestBuilder<Order>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "GET", URLString: url, parameters: parameters, isBody: true)
        }
    
        /**
         
         Delete purchase order by ID
         
         - DELETE /store/order/{orderId}
         - For valid response try integer IDs with value < 1000. Anything above 1000 or nonintegers will generate API errors
         
         :param: orderId (path) ID of the order that needs to be deleted

         :returns: Promise<Response<Void>> 
         */
        func deleteOrder(#orderId: String) -> RequestBuilder<Void> {
            var path = "/store/order/{orderId}"
            path = path.stringByReplacingOccurrencesOfString("{orderId}", withString: "\(orderId)", options: .LiteralSearch, range: nil)
            let url = PetstoreClientAPI.basePath + path
            
            let nillableParameters: [String:AnyObject?] = [:]
            let parameters = APIHelper.rejectNil(nillableParameters)

            let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

            return requestBuilder(method: "DELETE", URLString: url, parameters: parameters, isBody: true)
        }
    
    }
}
