package io.swagger.client;

import java.io.IOException;

import java.util.Map;
import java.util.List;

/**
 * Callback for asynchronous API call.
 *
 * @param <T> The return type
 */
public interface ApiCallback<T> {
  /**
   * This is called when the API call fails.
   *
   * @param e The exception causing the failure
   * @param statusCode Status code of the response if available, otherwise it would be 0
   * @param responseHeaders Headers of the response if available, otherwise it would be null
   */
  void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders);

  /**
   * This is called when the API call succeeded.
   *
   * @param result The result deserialized from response
   * @param statusCode Status code of the response
   * @param responseHeaders Headers of the response
   */
  void onSuccess(T result, int statusCode, Map<String, List<String>> responseHeaders);
}
