package io.swagger.client.api {

import io.swagger.common.ApiInvoker;
import io.swagger.exception.ApiErrorCodes;
import io.swagger.exception.ApiError;
import io.swagger.common.ApiUserCredentials;
import io.swagger.event.Response;
import io.swagger.common.SwaggerApi;
import io.swagger.client.model.User;

import mx.rpc.AsyncToken;
import mx.utils.UIDUtil;
import flash.utils.Dictionary;
import flash.events.EventDispatcher;

public class UserApi extends SwaggerApi {
    /**
    * Constructor for the UserApi api client
    * @param apiCredentials Wrapper object for tokens and hostName required towards authentication
    * @param eventDispatcher Optional event dispatcher that when provided is used by the SDK to dispatch any Response
    */
    public function UserApi(apiCredentials: ApiUserCredentials, eventDispatcher: EventDispatcher = null) {
        super(apiCredentials, eventDispatcher);
    }

        public static const event_create_user: String = "create_user";
        public static const event_create_users_with_array_input: String = "create_users_with_array_input";
        public static const event_create_users_with_list_input: String = "create_users_with_list_input";
        public static const event_login_user: String = "login_user";
        public static const event_logout_user: String = "logout_user";
        public static const event_get_user_by_name: String = "get_user_by_name";
        public static const event_update_user: String = "update_user";
        public static const event_delete_user: String = "delete_user";


    /*
     * Returns void 
     */
    public function create_user (body: User): String {
        // create path and map variables
        var path: String = "/user".replace(/{format}/g,"xml");

        // query params
        var queryParams: Dictionary = new Dictionary();
        var headerParams: Dictionary = new Dictionary();

        

        

        

        var token:AsyncToken = getApiInvoker().invokeAPI(path, "POST", queryParams, body, headerParams);

        var requestId: String = getUniqueId();

        token.requestId = requestId;
        token.completionEventType = "create_user";

        token.returnType = null ;
        return requestId;

    }
    
    /*
     * Returns void 
     */
    public function create_users_with_array_input (body: Array): String {
        // create path and map variables
        var path: String = "/user/createWithArray".replace(/{format}/g,"xml");

        // query params
        var queryParams: Dictionary = new Dictionary();
        var headerParams: Dictionary = new Dictionary();

        

        

        

        var token:AsyncToken = getApiInvoker().invokeAPI(path, "POST", queryParams, body, headerParams);

        var requestId: String = getUniqueId();

        token.requestId = requestId;
        token.completionEventType = "create_users_with_array_input";

        token.returnType = null ;
        return requestId;

    }
    
    /*
     * Returns void 
     */
    public function create_users_with_list_input (body: Array): String {
        // create path and map variables
        var path: String = "/user/createWithList".replace(/{format}/g,"xml");

        // query params
        var queryParams: Dictionary = new Dictionary();
        var headerParams: Dictionary = new Dictionary();

        

        

        

        var token:AsyncToken = getApiInvoker().invokeAPI(path, "POST", queryParams, body, headerParams);

        var requestId: String = getUniqueId();

        token.requestId = requestId;
        token.completionEventType = "create_users_with_list_input";

        token.returnType = null ;
        return requestId;

    }
    
    /*
     * Returns String 
     */
    public function login_user (username: String, password: String): String {
        // create path and map variables
        var path: String = "/user/login".replace(/{format}/g,"xml");

        // query params
        var queryParams: Dictionary = new Dictionary();
        var headerParams: Dictionary = new Dictionary();

        

        if("null" != String(username))
            queryParams["username"] = toPathValue(username);
        if("null" != String(password))
            queryParams["password"] = toPathValue(password);
        

        

        var token:AsyncToken = getApiInvoker().invokeAPI(path, "GET", queryParams, null, headerParams);

        var requestId: String = getUniqueId();

        token.requestId = requestId;
        token.completionEventType = "login_user";

        token.returnType = String;
        return requestId;

    }
    
    /*
     * Returns void 
     */
    public function logout_user (): String {
        // create path and map variables
        var path: String = "/user/logout".replace(/{format}/g,"xml");

        // query params
        var queryParams: Dictionary = new Dictionary();
        var headerParams: Dictionary = new Dictionary();

        

        

        

        var token:AsyncToken = getApiInvoker().invokeAPI(path, "GET", queryParams, null, headerParams);

        var requestId: String = getUniqueId();

        token.requestId = requestId;
        token.completionEventType = "logout_user";

        token.returnType = null ;
        return requestId;

    }
    
    /*
     * Returns User 
     */
    public function get_user_by_name (username: String): String {
        // create path and map variables
        var path: String = "/user/{username}".replace(/{format}/g,"xml").replace("{" + "username" + "}", getApiInvoker().escapeString(username));

        // query params
        var queryParams: Dictionary = new Dictionary();
        var headerParams: Dictionary = new Dictionary();

        

        

        

        var token:AsyncToken = getApiInvoker().invokeAPI(path, "GET", queryParams, null, headerParams);

        var requestId: String = getUniqueId();

        token.requestId = requestId;
        token.completionEventType = "get_user_by_name";

        token.returnType = User;
        return requestId;

    }
    
    /*
     * Returns void 
     */
    public function update_user (username: String, body: User): String {
        // create path and map variables
        var path: String = "/user/{username}".replace(/{format}/g,"xml").replace("{" + "username" + "}", getApiInvoker().escapeString(username));

        // query params
        var queryParams: Dictionary = new Dictionary();
        var headerParams: Dictionary = new Dictionary();

        

        

        

        var token:AsyncToken = getApiInvoker().invokeAPI(path, "PUT", queryParams, body, headerParams);

        var requestId: String = getUniqueId();

        token.requestId = requestId;
        token.completionEventType = "update_user";

        token.returnType = null ;
        return requestId;

    }
    
    /*
     * Returns void 
     */
    public function delete_user (username: String): String {
        // create path and map variables
        var path: String = "/user/{username}".replace(/{format}/g,"xml").replace("{" + "username" + "}", getApiInvoker().escapeString(username));

        // query params
        var queryParams: Dictionary = new Dictionary();
        var headerParams: Dictionary = new Dictionary();

        

        

        

        var token:AsyncToken = getApiInvoker().invokeAPI(path, "DELETE", queryParams, null, headerParams);

        var requestId: String = getUniqueId();

        token.requestId = requestId;
        token.completionEventType = "delete_user";

        token.returnType = null ;
        return requestId;

    }
    
}
        
}
