/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import com.ice.jni.registry.HexNumberFormat;
import com.ice.jni.registry.NoSuchKeyException;
import com.ice.jni.registry.NoSuchValueException;
import com.ice.jni.registry.RegBinaryValue;
import com.ice.jni.registry.RegDWordValue;
import com.ice.jni.registry.RegMultiStringValue;
import com.ice.jni.registry.RegStringValue;
import com.ice.jni.registry.RegistryException;
import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Registry {
    public static RegistryKey HKEY_CLASSES_ROOT;
    public static RegistryKey HKEY_CURRENT_USER;
    public static RegistryKey HKEY_LOCAL_MACHINE;
    public static RegistryKey HKEY_USERS;
    public static RegistryKey HKEY_PERFORMANCE_DATA;
    public static RegistryKey HKEY_CURRENT_CONFIG;
    public static RegistryKey HKEY_DYN_DATA;
    private static RegistryKey HKEY_ICE_TESTKEY;
    private static String[] preDefines;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_INVALID_HANDLE = 6;
    public static final int ERROR_INVALID_PARAMETER = 87;
    public static final int ERROR_CALL_NOT_IMPLEMENTED = 120;
    public static final int ERROR_INSUFFICIENT_BUFFER = 122;
    public static final int ERROR_LOCK_FAILED = 167;
    public static final int ERROR_TRANSFER_TOO_LONG = 222;
    public static final int ERROR_MORE_DATA = 234;
    public static final int ERROR_NO_MORE_ITEMS = 259;
    public static final int ERROR_BADDB = 1009;
    public static final int ERROR_BADKEY = 1010;
    public static final int ERROR_CANTOPEN = 1011;
    public static final int ERROR_CANTREAD = 1012;
    public static final int ERROR_CANTWRITE = 1013;
    public static final int ERROR_REGISTRY_RECOVERED = 1014;
    public static final int ERROR_REGISTRY_CORRUPT = 1015;
    public static final int ERROR_REGISTRY_IO_FAILED = 1016;
    public static final int ERROR_NOT_REGISTRY_FILE = 1017;
    public static final int ERROR_KEY_DELETED = 1018;
    private static final int ROW_BYTES = 16;
    private static final int ROW_QTR1 = 3;
    private static final int ROW_HALF = 7;
    private static final int ROW_QTR2 = 11;
    private static String saveKey;
    private static Hashtable topLevelKeys;
    public boolean debugLevel;

    static {
        HKEY_ICE_TESTKEY = null;
        saveKey = null;
        topLevelKeys = null;
        HKEY_CLASSES_ROOT = new RegistryKey(Integer.MIN_VALUE, "HKEY_CLASSES_ROOT");
        HKEY_CURRENT_USER = new RegistryKey(-2147483647, "HKEY_CURRENT_USER");
        HKEY_LOCAL_MACHINE = new RegistryKey(-2147483646, "HKEY_LOCAL_MACHINE");
        HKEY_USERS = new RegistryKey(-2147483645, "HKEY_USERS");
        HKEY_PERFORMANCE_DATA = new RegistryKey(-2147483644, "HKEY_PERFORMANCE_DATA");
        HKEY_CURRENT_CONFIG = new RegistryKey(-2147483643, "HKEY_CURRENT_CONFIG");
        HKEY_DYN_DATA = new RegistryKey(-2147483642, "HKEY_DYN_DATA");
        topLevelKeys = new Hashtable(16);
        topLevelKeys.put("HKCR", HKEY_CLASSES_ROOT);
        topLevelKeys.put("HKEY_CLASSES_ROOT", HKEY_CLASSES_ROOT);
        topLevelKeys.put("HKCU", HKEY_CURRENT_USER);
        topLevelKeys.put("HKEY_CURRENT_USER", HKEY_CURRENT_USER);
        topLevelKeys.put("HKLM", HKEY_LOCAL_MACHINE);
        topLevelKeys.put("HKEY_LOCAL_MACHINE", HKEY_LOCAL_MACHINE);
        topLevelKeys.put("HKU", HKEY_USERS);
        topLevelKeys.put("HKUS", HKEY_USERS);
        topLevelKeys.put("HKEY_USERS", HKEY_USERS);
        topLevelKeys.put("HKPD", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKEY_PERFORMANCE_DATA", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKCC", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKEY_CURRENT_CONFIG", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKDD", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKEY_DYN_DATA", HKEY_PERFORMANCE_DATA);
    }

    public static RegistryKey getTopLevelKey(String keyName) {
        return (RegistryKey)topLevelKeys.get(keyName);
    }

    public static RegistryKey openSubkey(RegistryKey topKey, String keyName, int access) {
        RegistryKey subKey = null;
        try {
            subKey = topKey.openSubKey(keyName, access);
        }
        catch (NoSuchKeyException ex) {
            subKey = null;
        }
        catch (RegistryException ex) {
            subKey = null;
        }
        return subKey;
    }

    public static String getErrorMessage(int errCode) {
        switch (errCode) {
            case 0: {
                return "success";
            }
            case 2: {
                return "key or value not found";
            }
            case 5: {
                return "access denied";
            }
            case 6: {
                return "invalid handle";
            }
            case 87: {
                return "invalid parameter";
            }
            case 120: {
                return "call not implemented";
            }
            case 122: {
                return "insufficient buffer";
            }
            case 167: {
                return "lock failed";
            }
            case 222: {
                return "transfer was too long";
            }
            case 234: {
                return "more data buffer needed";
            }
            case 259: {
                return "no more items";
            }
            case 1009: {
                return "bad database";
            }
            case 1010: {
                return "bad key";
            }
            case 1011: {
                return "can not open";
            }
            case 1012: {
                return "can not read";
            }
            case 1013: {
                return "can not write";
            }
            case 1014: {
                return "registry recovered";
            }
            case 1015: {
                return "registry corrupt";
            }
            case 1016: {
                return "registry IO failed";
            }
            case 1017: {
                return "not a registry file";
            }
            case 1018: {
                return "key has been deleted";
            }
        }
        return "errCode=" + errCode;
    }

    public static void exportRegistryKey(String pathName, RegistryKey key, boolean descend) throws IOException, NoSuchKeyException, RegistryException {
        PrintWriter out = new PrintWriter(new FileWriter(pathName));
        out.println("REGEDIT4");
        out.println("");
        key.export(out, descend);
        out.flush();
        out.close();
    }

    public static void main(String[] argv) {
        preDefines = new String[10];
        Registry.preDefines[0] = "HKLM\\System\\CurrentControlSet\\control";
        Registry.preDefines[1] = "HKLM\\Software";
        Registry.preDefines[2] = "HKLM\\Software\\Miscrosoft";
        Registry.preDefines[3] = "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion";
        Registry.preDefines[4] = "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\ProfileList";
        Registry.preDefines[5] = "HKCU\\Software";
        Registry.preDefines[6] = "HKCU\\Software\\Microsoft";
        Registry.preDefines[7] = "HKCU\\AppEvents";
        Registry.preDefines[8] = "HKCU\\AppEvents\\Schemes";
        Registry.preDefines[9] = "HKCU\\AppEvents\\Schemes";
        try {
            HKEY_ICE_TESTKEY = HKEY_CURRENT_USER.openSubKey("Software\\ICE Engineering\\test");
        }
        catch (NoSuchKeyException noSuchKeyException) {
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        if (argv.length > 0) {
            Registry.subMain(argv);
        } else {
            String saveLine = null;
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                String[] subArgs;
                String inLine;
                System.out.print("command: ");
                System.out.flush();
                try {
                    inLine = input.readLine();
                }
                catch (IOException ex) {
                    inLine = null;
                }
                if (inLine == null || inLine.length() == 0) break;
                if (inLine.equalsIgnoreCase("help")) {
                    Registry.usage(null);
                    continue;
                }
                if (inLine.equals("!!") && saveLine != null) {
                    subArgs = Registry.parseArgumentString(saveLine);
                } else {
                    subArgs = Registry.parseArgumentString(inLine);
                    saveLine = inLine;
                }
                Registry.subMain(subArgs);
            }
        }
    }

    public static void usage(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println("keys regKey -- print the key names");
        System.err.println("values regKey -- print the value names");
        System.err.println("data regKey subKey -- print the key's data");
        System.err.println("string regKey subKey -- print REG_SZ key's string");
        System.err.println("setbin regKey subKey  binaryString -- set REG_BINARY");
        System.err.println("setdw regKey subKey int -- set REG_DWORD");
        System.err.println("setstr regKey subKey string -- set REG_SZ");
        System.err.println("setmulti regKey subKey semiColonString -- set REG_MULTI_SZ");
        System.err.println("delkey regKey subKey -- delete key 'subKey' of regKey");
        System.err.println("delval regKey subKey -- delete value 'subKey' of regKey");
        System.err.println("export regKey fileName -- export registry key to fileName");
        System.err.println("expand regKey valueName -- expand string value");
        System.err.println("");
        System.err.println("!! -- repeats last command");
        System.err.println("$$ -- re-uses previous keyname");
        System.err.println("Predefined Key Prefixes: (e.g. $0-9)");
        int idx = 0;
        while (idx < preDefines.length) {
            System.err.println("   $" + idx + "=" + preDefines[idx]);
            ++idx;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void subMain(String[] argv) {
        void var8_16;
        void var8_12;
        int index;
        void var8_10;
        RegistryKey topKey = null;
        boolean isRemote = false;
        String topKeyName = null;
        String hostName = null;
        if (argv.length < 1 || argv[0].equals("help")) {
            Registry.usage(null);
            return;
        }
        if (argv.length < 2) {
            Registry.usage(null);
            return;
        }
        String string = argv[1];
        if (saveKey != null && string.equals("$$")) {
            String string2 = saveKey;
        } else if (string.equals("@@")) {
            String string3 = "HKCU\\Software\\ICE Engineering\\test";
        } else {
            char ch1 = string.charAt(0);
            char ch2 = string.charAt(1);
            if (ch1 == '$' && ch2 >= '0' && ch2 <= '9') {
                int pIdx = ch2 - 48;
                if (preDefines[pIdx] == null) {
                    System.err.println("Predefine '" + string + "' not defined.");
                    return;
                }
                if (string.length() < 3) {
                    String string4 = preDefines[pIdx];
                } else {
                    String string5 = String.valueOf(preDefines[pIdx]) + string.substring(2);
                }
            } else {
                saveKey = argv[1];
            }
        }
        if (var8_10.startsWith("\\\\")) {
            isRemote = true;
            index = var8_10.indexOf(92, 2);
            hostName = var8_10.substring(2, index);
            String string6 = var8_10.substring(index + 1);
        }
        if ((index = var8_12.indexOf(92)) < 0) {
            topKeyName = var8_12;
            Object var8_13 = null;
        } else {
            if (index < 4) {
                System.err.println("Invalid key '" + (String)var8_12 + "', top level key name too short.");
                return;
            }
            topKeyName = var8_12.substring(0, index);
            if (index + 1 >= var8_12.length()) {
                Object var8_14 = null;
            } else {
                String string7 = var8_12.substring(index + 1);
            }
        }
        topKey = Registry.getTopLevelKey(topKeyName);
        if (topKey == null) {
            System.err.println("ERROR, toplevel key '" + topKeyName + "' not resolved!");
            return;
        }
        if (isRemote) {
            System.err.println("REMOTE Key host='" + hostName + "'");
            RegistryKey remoteKey = null;
            try {
                remoteKey = topKey.connectRegistry(hostName);
            }
            catch (NoSuchKeyException ex) {
                System.err.println("ERROR No such key connecting to '" + hostName + "', " + ex.getMessage());
                return;
            }
            catch (RegistryException ex) {
                System.err.println("ERROR errCode=" + ex.getErrorCode() + "' connecting to '" + hostName + "', " + ex.getMessage());
                return;
            }
            if (remoteKey != null) {
                topKey = remoteKey;
            }
        }
        if (argv[0].equalsIgnoreCase("create")) {
            Registry.createCommand(topKey, (String)var8_16);
            return;
        }
        if (argv[0].equalsIgnoreCase("setbin")) {
            Registry.setBinaryCommand(topKey, (String)var8_16, argv[2], argv[3]);
            return;
        }
        if (argv[0].equalsIgnoreCase("setdw")) {
            Registry.setBinaryCommand(topKey, (String)var8_16, argv[2], argv[3]);
            return;
        }
        if (argv[0].equalsIgnoreCase("setstr")) {
            Registry.setStringCommand(topKey, (String)var8_16, argv[2], argv[3]);
            return;
        }
        if (argv[0].equalsIgnoreCase("setmulti")) {
            Registry.setMultiStringCommand(topKey, (String)var8_16, argv[2], argv[3]);
            return;
        }
        if (argv[0].equalsIgnoreCase("keys")) {
            Registry.listKeysCommand(topKey, (String)var8_16);
            return;
        }
        if (argv[0].equalsIgnoreCase("values")) {
            Registry.listValuesCommand(topKey, (String)var8_16);
            return;
        }
        if (argv[0].equalsIgnoreCase("delkey")) {
            Registry.deleteKeyCommand(topKey, (String)var8_16, argv[2]);
            return;
        }
        if (argv[0].equalsIgnoreCase("delval")) {
            Registry.deleteValueCommand(topKey, (String)var8_16, argv[2]);
            return;
        }
        if (argv[0].equalsIgnoreCase("data")) {
            Registry.getDataCommand(topKey, (String)var8_16, argv[2]);
            return;
        }
        if (argv[0].equalsIgnoreCase("string")) {
            Registry.getStringCommand(topKey, (String)var8_16, argv[2]);
            return;
        }
        if (argv[0].equalsIgnoreCase("export")) {
            Registry.exportKeyCommand(topKey, (String)var8_16, argv[2]);
            return;
        }
        if (!argv[0].equalsIgnoreCase("expand")) return;
        Registry.expandStringCommand(topKey, (String)var8_16, argv[2]);
    }

    private static void exportKeyCommand(RegistryKey topKey, String keyName, String pathName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 1);
        if (subKey == null) {
            return;
        }
        try {
            Registry.exportRegistryKey(pathName, subKey, true);
        }
        catch (IOException ex) {
            System.err.println("IO Exception: '" + ex.getMessage() + "'");
        }
        catch (NoSuchKeyException ex) {
            System.err.println("Error, encountered non-existent key during export.");
        }
        catch (RegistryException ex) {
            System.err.println("ERROR registry error=" + ex.getErrorCode() + ", " + ex.getMessage());
        }
    }

    private static void getDataCommand(RegistryKey topKey, String keyName, String valueName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 1);
        if (subKey == null) {
            return;
        }
        RegistryValue data = null;
        try {
            data = subKey.getValue(valueName);
        }
        catch (NoSuchValueException ex) {
            System.err.println("Value '" + valueName + "' does not exist.");
            return;
        }
        catch (RegistryException ex) {
            System.err.println("ERROR registry error=" + ex.getErrorCode() + ", " + ex.getMessage());
            return;
        }
        System.err.println("Value '" + valueName + "' is " + data.toString());
        if (data instanceof RegStringValue) {
            RegStringValue val = (RegStringValue)data;
            System.err.println("REG_SZ '" + val.getData() + "'");
        } else if (data instanceof RegMultiStringValue) {
            RegMultiStringValue val = (RegMultiStringValue)data;
            String[] args = val.getData();
            int idx = 0;
            while (idx < args.length) {
                System.err.println("REG_MULTI_SZ[" + idx + "] '" + args[idx] + "'");
                ++idx;
            }
        } else if (data instanceof RegDWordValue) {
            RegDWordValue val = (RegDWordValue)data;
            HexNumberFormat xFmt = new HexNumberFormat("XXXXXXXX");
            System.err.println("REG_DWORD" + (5 == val.getType() ? "_BIG_ENDIAN" : "") + " '" + val.getData() + "' [x" + xFmt.format(val.getData()) + "]");
        } else {
            RegBinaryValue val = (RegBinaryValue)data;
            Registry.dumpHexData(System.err, "REG_BINARY '" + val.getName() + "', len=" + val.getLength(), val.getData(), val.getLength());
        }
    }

    private static void getStringCommand(RegistryKey topKey, String keyName, String valueName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 1);
        if (subKey == null) {
            return;
        }
        try {
            String value = subKey.getStringValue(valueName);
            System.err.println("String Value " + valueName + "='" + value + "'");
        }
        catch (RegistryException ex) {
            System.err.println("ERROR getting value '" + valueName + "', " + ex.getMessage());
            return;
        }
    }

    private static void expandStringCommand(RegistryKey topKey, String keyName, String valueName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 1);
        if (subKey == null) {
            return;
        }
        try {
            String value = subKey.getStringValue(valueName);
            System.err.println("String Value " + valueName + "='" + value + "'");
            value = RegistryKey.expandEnvStrings(value);
            System.err.println("Expanded Value " + valueName + "='" + value + "'");
        }
        catch (RegistryException ex) {
            System.err.println("ERROR getting value '" + valueName + "', " + ex.getMessage());
            return;
        }
    }

    private static void deleteKeyCommand(RegistryKey topKey, String keyName, String deleteKeyName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 2);
        if (subKey == null) {
            return;
        }
        try {
            subKey.deleteSubKey(deleteKeyName);
        }
        catch (NoSuchKeyException ex) {
            System.err.println("Key '" + keyName + "\\" + deleteKeyName + "' does not exist.");
            return;
        }
        catch (RegistryException ex) {
            System.err.println("ERROR deleting key '" + keyName + "', " + ex.getMessage());
            return;
        }
    }

    private static void deleteValueCommand(RegistryKey topKey, String keyName, String valueName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 2);
        if (subKey == null) {
            return;
        }
        try {
            subKey.deleteValue(valueName);
        }
        catch (NoSuchValueException ex) {
            System.err.println("Value '" + valueName + "' does not exist.");
            return;
        }
        catch (RegistryException ex) {
            System.err.println("ERROR deleting value '" + valueName + "', " + ex.getMessage());
            return;
        }
    }

    private static void listKeysCommand(RegistryKey topKey, String keyName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 1);
        if (subKey == null) {
            return;
        }
        try {
            Enumeration enumeration = subKey.keyElements();
            int kIdx = 0;
            while (enumeration.hasMoreElements()) {
                String keyStr = (String)enumeration.nextElement();
                System.err.println("Subkey[" + kIdx + "] = '" + keyStr + "'");
                ++kIdx;
            }
        }
        catch (RegistryException ex) {
            System.err.println("ERROR getting key enumerator, " + ex.getMessage());
            return;
        }
    }

    private static void listValuesCommand(RegistryKey topKey, String keyName) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 1);
        if (subKey == null) {
            return;
        }
        try {
            Enumeration enumeration = subKey.valueElements();
            int kIdx = 0;
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                System.err.println("Value Name[" + kIdx + "] = '" + name + "'");
                ++kIdx;
            }
        }
        catch (RegistryException ex) {
            System.err.println("ERROR getting value enumerator, " + ex.getMessage());
            return;
        }
    }

    private static void setDWordCommand(RegistryKey topKey, String keyName, String valueName, String data) {
        int anInt;
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 2);
        if (subKey == null) {
            return;
        }
        try {
            anInt = Integer.parseInt(data);
        }
        catch (NumberFormatException ex) {
            System.err.println("ERROR bad int: '" + ex.getMessage() + "'");
            return;
        }
        RegDWordValue val = new RegDWordValue(subKey, valueName);
        val.setData(anInt);
        Registry.setValue(subKey, val);
    }

    private static void setMultiStringCommand(RegistryKey topKey, String keyName, String valueName, String data) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 2);
        if (subKey == null) {
            return;
        }
        String[] strArray = Registry.splitString(data, ";");
        RegMultiStringValue val = new RegMultiStringValue(subKey, valueName, strArray);
        Registry.setValue(subKey, val);
    }

    private static void setStringCommand(RegistryKey topKey, String keyName, String valueName, String data) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 2);
        if (subKey == null) {
            return;
        }
        RegStringValue val = new RegStringValue(subKey, valueName, data);
        Registry.setValue(subKey, val);
    }

    private static void setBinaryCommand(RegistryKey topKey, String keyName, String valueName, String data) {
        RegistryKey subKey = Registry.openSubKeyVerbose(topKey, keyName, 2);
        if (subKey == null) {
            return;
        }
        byte[] binData = data.getBytes();
        RegBinaryValue val = new RegBinaryValue(subKey, valueName, binData);
        Registry.setValue(subKey, val);
    }

    private static void createCommand(RegistryKey topKey, String keyName) {
        RegistryKey subKey;
        try {
            subKey = topKey.createSubKey(keyName, "", 2);
        }
        catch (RegistryException ex) {
            subKey = null;
            System.err.println("ERROR creating subKey: " + ex.getMessage());
        }
        if (subKey != null) {
            try {
                subKey.flushKey();
                subKey.closeKey();
            }
            catch (RegistryException ex) {
                subKey = null;
                System.err.println("ERROR flushing and closing key: " + ex.getMessage());
            }
        }
        if (subKey != null) {
            System.err.println("SUCCEEDED " + (subKey.wasCreated() ? "Creating" : "Opening via create") + " Key '" + keyName + "'");
        } else {
            System.err.println("FAILED Creating Key '" + keyName + "'");
        }
    }

    private static RegistryKey openSubKeyVerbose(RegistryKey topKey, String keyName, int access) {
        RegistryKey subKey = null;
        try {
            subKey = topKey.openSubKey(keyName, access);
        }
        catch (NoSuchKeyException ex) {
            subKey = null;
            System.err.println("Key '" + keyName + "' does not exist.");
        }
        catch (RegistryException ex) {
            subKey = null;
            System.err.println("ERROR registry error=" + ex.getErrorCode() + ", " + ex.getMessage());
        }
        return subKey;
    }

    private static void setValue(RegistryKey subKey, RegistryValue value) {
        try {
            subKey.setValue(value);
            subKey.flushKey();
        }
        catch (RegistryException ex) {
            System.err.println("ERROR setting MULTI_SZ value '" + value.getName() + "', " + ex.getMessage());
        }
    }

    public static void dumpHexData(PrintStream out, String title, byte[] buf, int numBytes) {
        PrintWriter wrtr = new PrintWriter(new OutputStreamWriter(out));
        Registry.dumpHexData(wrtr, title, buf, 0, numBytes);
    }

    public static void dumpHexData(PrintWriter out, String title, byte[] buf, int offset, int numBytes) {
        byte[] save_buf = new byte[18];
        char[] hex_buf = new char[4];
        char[] idx_buf = new char[8];
        char[] hex_chars = new char[20];
        hex_chars[0] = 48;
        hex_chars[1] = 49;
        hex_chars[2] = 50;
        hex_chars[3] = 51;
        hex_chars[4] = 52;
        hex_chars[5] = 53;
        hex_chars[6] = 54;
        hex_chars[7] = 55;
        hex_chars[8] = 56;
        hex_chars[9] = 57;
        hex_chars[10] = 65;
        hex_chars[11] = 66;
        hex_chars[12] = 67;
        hex_chars[13] = 68;
        hex_chars[14] = 69;
        hex_chars[15] = 70;
        out.println(String.valueOf(title) + " - " + numBytes + " bytes.");
        int rows = (numBytes + 15) / 16;
        int residue = numBytes % 16;
        int i = 0;
        while (i < rows) {
            int hexVal = i * 16;
            idx_buf[0] = hex_chars[hexVal >> 12 & 0xF];
            idx_buf[1] = hex_chars[hexVal >> 8 & 0xF];
            idx_buf[2] = hex_chars[hexVal >> 4 & 0xF];
            idx_buf[3] = hex_chars[hexVal & 0xF];
            String idxStr = new String(idx_buf, 0, 4);
            out.print(String.valueOf(idxStr) + ": ");
            int j = 0;
            while (j < 16) {
                if (i == rows - 1 && j >= residue) {
                    save_buf[j] = 32;
                    out.print("   ");
                    if (j == 3 || j == 7 || j == 11) {
                        out.print(' ');
                    }
                } else {
                    save_buf[j] = buf[offset + i * 16 + j];
                    hex_buf[0] = hex_chars[save_buf[j] >> 4 & 0xF];
                    hex_buf[1] = hex_chars[save_buf[j] & 0xF];
                    out.print(hex_buf[0]);
                    out.print(hex_buf[1]);
                    out.print(' ');
                    if (j == 3 || j == 7 || j == 11) {
                        out.print(' ');
                    }
                    if (save_buf[j] < 32 || save_buf[j] > 126) {
                        save_buf[j] = 46;
                    }
                }
                ++j;
            }
            String saveStr = new String(save_buf, 0, j);
            out.println(" | " + saveStr + " |");
            ++i;
        }
        out.flush();
    }

    public static String[] splitString(String splitStr, String delim) {
        StringTokenizer toker = new StringTokenizer(splitStr, delim);
        int count = toker.countTokens();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            try {
                result[i] = toker.nextToken();
            }
            catch (NoSuchElementException ex) {
                result = null;
                break;
            }
            ++i;
        }
        return result;
    }

    public static String[] parseArgumentString(String argStr) {
        Object[] result = null;
        Vector vector = Registry.parseArgumentVector(argStr);
        if (vector != null && vector.size() > 0) {
            result = new String[vector.size()];
            vector.copyInto(result);
        }
        return result;
    }

    public static Vector parseArgumentVector(String argStr) {
        Vector<String> result = new Vector<String>();
        StringBuffer argBuf = new StringBuffer();
        boolean backSlash = false;
        boolean matchSglQuote = false;
        boolean matchDblQuote = false;
        int cIdx = 0;
        while (cIdx < argStr.length()) {
            char ch = argStr.charAt(cIdx);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (backSlash) {
                        argBuf.append(ch);
                        backSlash = false;
                        break;
                    }
                    if (matchSglQuote || matchDblQuote) {
                        argBuf.append(ch);
                        break;
                    }
                    if (argBuf.length() <= 0) break;
                    result.addElement(argBuf.toString());
                    argBuf.setLength(0);
                    break;
                }
                case '\\': {
                    if (backSlash) {
                        argBuf.append("\\");
                    }
                    backSlash = !backSlash;
                    break;
                }
                case '\'': {
                    if (backSlash) {
                        argBuf.append("'");
                        backSlash = false;
                        break;
                    }
                    if (matchSglQuote) {
                        result.addElement(argBuf.toString());
                        argBuf.setLength(0);
                        matchSglQuote = false;
                        break;
                    }
                    if (matchDblQuote) break;
                    matchSglQuote = true;
                    break;
                }
                case '\"': {
                    if (backSlash) {
                        argBuf.append("\"");
                        backSlash = false;
                        break;
                    }
                    if (matchDblQuote) {
                        result.addElement(argBuf.toString());
                        argBuf.setLength(0);
                        matchDblQuote = false;
                        break;
                    }
                    if (matchSglQuote) break;
                    matchDblQuote = true;
                    break;
                }
                default: {
                    if (backSlash) {
                        switch (ch) {
                            case 'b': {
                                argBuf.append('\b');
                                break;
                            }
                            case 'f': {
                                argBuf.append('\f');
                                break;
                            }
                            case 'n': {
                                argBuf.append('\n');
                                break;
                            }
                            case 'r': {
                                argBuf.append('\r');
                                break;
                            }
                            case 't': {
                                argBuf.append('\t');
                                break;
                            }
                            default: {
                                char ch2 = argStr.charAt(cIdx + 1);
                                char ch3 = argStr.charAt(cIdx + 2);
                                if (ch >= '0' && ch <= '7' && ch2 >= '0' && ch2 <= '7' && ch3 >= '0' && ch3 <= '7') {
                                    int octal = (ch - 48) * 64 + (ch2 - 48) * 8 + (ch3 - 48);
                                    argBuf.append((char)octal);
                                    cIdx += 2;
                                    break;
                                }
                                if (ch == '0') {
                                    argBuf.append('\u0000');
                                    break;
                                }
                                argBuf.append(ch);
                                break;
                            }
                        }
                    } else {
                        argBuf.append(ch);
                    }
                    backSlash = false;
                }
            }
            ++cIdx;
        }
        if (argBuf.length() > 0) {
            result.addElement(argBuf.toString());
        }
        return result;
    }
}

