### v0.8.0 -> v0.9.0

#### Features

- 8428bd5 feat(router): proxy builder through router
- bddb43e feat(user-data): adds nsenter alias
- 5ad1fc0 feat(router): route deis.domain to controller
- 5d60551 feat(vagrant): make rsync as default
- e86d9d8 feat(builder): build apps from more than master
- 321b96c feat(controller): allow shared users domain access
- 65bf80e feat(controller): log domains deployed
- c1c7ee7 feat(controller): hook up domains to router
- 23df4ab feat(controller): add Domain model
- fcadd48 feat(controller): Toggle registration using etcd
- 730149c feat(builder): update builder to pass SHA/Procfile/Dockerfile (if available)
- c5aec20 feat(dockerfile): improve dockerfile and procfile workflow
- f330bfd feat(router): support for multiple routers
- f845dc8 feat(router): configurable gzip settings
- e0ba0a9 feat(builder): expose runtime configuration during slugbuilder execution
- 097827c feat(Vagrantfile): add fallback to rsync
- 2bce3f4 feat(contrib): add changelog script
- 4712658 feat(contrib): add CoreOS flair to motd
- 11b07e2 feat(contrib/coreos/user-data): create Deis motd
- 4808ea9 feat(client): add --app option to apps:run
- b2e2b78 feat(client): add auth command

#### Fixes

- 0470a38 fix(controller): add source release version
- d290bb2 fix(controller): revert "<no value>" polling target to confd_settings.py
- 733a61c fix(docker): always use ":latest" tag in docker pull
- b800e9b fix(router): restore check_cmd and grep nginx.conf
- f349741 fix(controller): change timeout for docker container template
- 2767c47 fix(travis): add dummy FLEETCTL_TUNNEL envvar
- c0eae21 fix(Makefile): enable targets to work for non-Vagrant
- 07d49ef fix(controller): watch fifth column for state
- 82a0339 fix(controller): use new `fleetctl` semantics
- 1c67726 fix(data-containers): change test command to "inspect"
- 52b93ac fix(Makefile): update to work with fleetctl 0.3.2
- 91e7e21 fix(test): update example-ruby-sinatra location
- 77c1703 fix(contrib): revert seed hosts for CDN workaround
- 3e1708c fix(Makefile): Information about missing FLEETCTL_TUNNEL
- f4a41ad fix(Makefile): include router component in `make build` and friends
- 1fdbf2c fix(Makefile): use fleetctl to filter actual deis-* units
- 129ad5d fix(controller): change api logs response to 204 when no logs
- bdf08ba fix(signals): use different dispatch_uid for log signals
- 6aad59c fix(*): set etcd keys safely in /bin/boot
- 968efd0 fix(router): create /deis/domains
- 6886795 fix(controller): give access to /domains
- dbfed01 fix(client): handle created response code on domains:add
- 9a9c40c fix(controller): do not deploy releases on domains
- 526cd06 fix(client): cleanup domains output
- ed642ff fix(router): resolve golang template scoping issue
- 1646f72 fix(controller): add /domains access in confd
- 133f707 fix(controller): revert e647336741
- 64c90e7 fix(confd): give controller/router /deis access
- 1c06b51 fix(controller): cast registrationEnabled to bool
- 2dee62c fix(scheduler): detect exposed ports from image for PORT envvar
- 3d5d243 fix(tests): close db connections during threaded execution
- 5710ccb fix(flake8): resolve code formatting issues
- f680df6 fix(deploy): rework initial deploy logic based on workflow
- 877a87b fix(builder): include default_process_types from .release
- b4ff75e fix(migration): squash migrations, add newline
- cdbd9b9 fix(scale): move initial scaling logic to model, add tests
- 553978c fix(controller): only scale web=1 if procfile has web entry
- 2984581 fix(schema): remove uniqueness constraint on containers
- c8efffd fix(announcer): detect first exposed port instead of hardcoding to 5000/tcp
- a056894 fix(test): remove `-K` ssh-add option that isn't available on Linux
- 1d46330 fix(builder): add scale() back to first build
- fd88251 fix(flake8): fix spaces and a docstring
- 95c2c77 fix(app): only set initial structure when build hook is triggered
- c951ffa fix(Vagrantfile): fix vagrant sync command
- 96e0428 fix(README): fix typo
- d3dfa37 fix(contrib): seed hosts for CDN workaround
- 166282a fix(CHANGELOG): prep for changelog script
- 90c73d0 fix(test): don't fail if already registered, and pause for builder
- 48cd94f fix(client): return 1 on two more error cases
- 45e5e0c fix(contrib): correct coloring
- 23f0f0c fix(logger): allow digits in app name when parsing log file
- 33f72a1 fix(controller): restore App.destroy() and call delete()
- 998498f fix(Makefile): fix 'check-fleet' rule for $FLEETCTL_TUNNEL with port.
- 6d64cbf fix(readme): unify language with deis.io
- c510fc5 fix(controller): give processes unique counters
- 2c699ed fix(controller): remove username length validation
- 75aeb67 fix(registry): store apps as appname
- 926c8f4 fix(client): return non-zero on errors
- a0cf80c fix(docker): use btrfs inside builder
- 15751ad fix(builder): do not check for a Procfile
- 4edfb2c fix(pip): update location of pip installer

#### Documentation

- 70fe559 docs(*): document DEIS_NUM_ROUTERS
- ad8eabd docs(readme): remove cruft and add clarifications
- ccdfc34 Revert "docs(contrib/rackspace): document manual update for CoreOS"
- d759e1e docs(README.md): Update Documentation for creating Applicaiton
- e98d9c2 docs(releases): update for Docker Index tagging capability
- d459eec docs(configure-dns): fix typo
- d4aa8c9 docs(UPGRADING.md): add upgrade documentation
- 20ecc29 docs(contrib/rackspace): document manual update for CoreOS
- 54888af docs(developer): use note styling
- dbbb7b4 docs(developer): add domain documentation
- 87159d5 docs(developer): flesh out developer docs
- ae0365b docs(*): update docs for local3.deisapp.com, local5.deisapp.com
- db2d845 docs(bare-metal): filled in bare metal section in provision doc
- ff3e029 docs(*): add bare-metal guide
- 9435bfd docs(README): add troubleshooting for 'not reachable' peers
- f3c60cc docs(contrib): github-changes -> changelog script
- b70aa56 docs(*): clarify clusters:create options
- ac15bce docs(README): adds troubleshooting information
- 28f3727 docs(*): strongly suggest Deis clusters of 3+ nodes
- 900e583 docs(contributing): add TESTING footer
- 842838a docs(vagrant): update references to vagrant files
- 2dd299c docs(README): install nfs on Ubuntu
- 98b478a docs(contributing): split out DCO

### v0.8.0 (2014/05/06 18:30 +00:00)
- [54ff9ca](https://github.com/deis/deis/commit/54ff9caaaaa2be20960afe41c883014a796b81b2) Updated CLI binaries and links in client README. (@mboersma)
- [4694844](https://github.com/deis/deis/commit/4694844e603583d2b0cee0fa0b4922a9857dc5d9) Switch master to v0.8.0. (@mboersma)
- [#715](https://github.com/deis/deis/pull/715) Merge pull request #715 from opdemand/filesystem-docs (@opdemand)
- [469ee72](https://github.com/deis/deis/commit/469ee72a8e180485fbe7a394f052b1a47f3ae234) refactor(scheduler): use coreos/fleet for container scheduling (@gabrtv)
- [aa8bafc](https://github.com/deis/deis/commit/aa8bafc5608862f220f7fea245b2a6e27141fa91) refactor(scheduler): adapt web app to new cluster domain object (@gabrtv)
- [b5aea48](https://github.com/deis/deis/commit/b5aea482dd567ba8bfe4c4a9009bfe18e7afeec1) refactor(cm): remove deprecated cm and provider packages from test and coverage (@gabrtv)
- [10c8c4e](https://github.com/deis/deis/commit/10c8c4eaa428bc9a691931e5e315ba57882a824e) refactor(client): changes for scheduler refactoring (@gabrtv)
- [51f5d6d](https://github.com/deis/deis/commit/51f5d6d57bc80c882c07ef3c649892bcbbdfed10) chore(builder): upgrade to docker 0.9.1 (@gabrtv)
- [30f1651](https://github.com/deis/deis/commit/30f1651c8939db20920f87d0b92912cd8b8748cf) feat(docker): deis meta project (@gabrtv)
- [d4e13a4](https://github.com/deis/deis/commit/d4e13a44961010ac9776bc3878d434537b09d53c) refactor(scheduler): coreos scheduler implementation (@gabrtv)
- [2c72ff2](https://github.com/deis/deis/commit/2c72ff23d0c2333fe9359b06bc750cc37c16b561) refactor(builder): improve build + config = release (@gabrtv)
- [e1ccc29](https://github.com/deis/deis/commit/e1ccc29c4c72458be0683dc0442f0a99a50f5740) refactor(builder): remove slug metadata from builder (@gabrtv)
- [a20798a](https://github.com/deis/deis/commit/a20798aa4b91919c2800d9871d0a9e9c594e0576) feat(scheduler): add command handling for procfile-style execution (@gabrtv)
- [0a217fc](https://github.com/deis/deis/commit/0a217fcdd83bac96543a29d60958e974907992e8) refactor(vagrant): new CoreOS Vagrantfile (@gabrtv)
- [8110aaf](https://github.com/deis/deis/commit/8110aaf91b876ea885c96a5031fdc795c4cd5489) refactor(makefile): dispatch to relevant coreos utilities (@gabrtv)
- [4220183](https://github.com/deis/deis/commit/4220183ff633b77d297c0e65363e4fb8bd388a0c) feat(registry): add private docker registry (@gabrtv)
- [8d9f314](https://github.com/deis/deis/commit/8d9f31400562a4abce66c0c9a1bfb0690d89f301) feat(router): add nginx router driven by confd/etcd (@gabrtv)
- [0a081cd](https://github.com/deis/deis/commit/0a081cdc0248ada1f3fe0cb489b085fb471e7f8f) chore(ruby): remove ruby files (@gabrtv)
- [72ddbaa](https://github.com/deis/deis/commit/72ddbaa5a7f6e7a1fa4d5ed3ff54e2f0bf2551a5) chore(docker): remove registry from deis meta project (@gabrtv)
- [bc422ef](https://github.com/deis/deis/commit/bc422ef605efd25b6f7c2863f3c5d2b1ad2e22a0) chore(builder): show `docker push` output from builder for debugging (@gabrtv)
- [98387cf](https://github.com/deis/deis/commit/98387cfb172aab60c14e19f4de65ab72a263e8cb) chore(coverage): add .coveragerc in controller root (@gabrtv)
- [680f1a8](https://github.com/deis/deis/commit/680f1a8b1ff34237d9a0032a12644196c2536f8f) chore(router): expose router on 80 and 443, add timeout for image download (@gabrtv)
- [dd065bd](https://github.com/deis/deis/commit/dd065bd054ffcb373c258bd4f95df75da4880208) refactor(client): make apps_open cluster aware (@gabrtv)
- [039ad59](https://github.com/deis/deis/commit/039ad5916124cd0c04a998253570de8deb97ab70) refactor(deis-run): new `deis run` implementation and celery task (@gabrtv)
- [ac956d1](https://github.com/deis/deis/commit/ac956d1ee28091c211e688126f4a98ab1c65ecaa) refactor(registry): new registry package with mock and private implementations (@gabrtv)
- [ba19ac2](https://github.com/deis/deis/commit/ba19ac2385130eb77e93aa8bca9b3045523fd0ff) fix(boot): dot remove docker.pid, fix sock test (@gabrtv)
- [e07b18d](https://github.com/deis/deis/commit/e07b18d8fb0f13c11ac27d029a73c4b7dae60e39) fix(cache): change cache workdir to /var/lib/redis for read/write filesystem (@gabrtv)
- [426fbce](https://github.com/deis/deis/commit/426fbce728a92c54dc999b6394a408c115042b4b) fix(boot): only remove docker.sock if it exists (@gabrtv)
- [01f2225](https://github.com/deis/deis/commit/01f222551cb1b82594c6fb22de8dec4096cf41f8) refactor(bin/boot) consolidate into a single script with debug and optional publishing (@gabrtv)
- [41645ee](https://github.com/deis/deis/commit/41645ee2463f5645f5569b0beacf84e58c454f65) doc(readme): update README instructions for dev setup (@gabrtv)
- [37964ae](https://github.com/deis/deis/commit/37964aeff8efa521c214fc00dae323a2c8d9a2a5) chore(builder): add debug, move confd loop before daemon execs (@gabrtv)
- [f46834a](https://github.com/deis/deis/commit/f46834ab1e76b9ecf03984906cef3da486df9f39) fix(builder): add bridge CIDR address to fix etcd connectivity (@gabrtv)
- [162928c](https://github.com/deis/deis/commit/162928c11610d276c2e3614294e7a77e51ca7f43) chore(systemd): change units to publish on known ports (@gabrtv)
- [802666b](https://github.com/deis/deis/commit/802666b8fee0ae307780c2fd287d353ca8dca599) chore(scheduler): disable auto router and logger on cluster creation (@gabrtv)
- [be7a003](https://github.com/deis/deis/commit/be7a00361c063fc16a9a18eb805abab92e62f550) chore(docker): move deis meta project to contrib/docker (@gabrtv)
- [c08eaf8](https://github.com/deis/deis/commit/c08eaf839943cafaaeff55f426c2f9f1b253691a) chore(user-data): change yaml content to literal block (@gabrtv)
- [18d1626](https://github.com/deis/deis/commit/18d1626d15117f41c086205528fee72e5a8dc314) fix(vagrant): switch vm to 2gb of memory (@gabrtv)
- [b7f29fa](https://github.com/deis/deis/commit/b7f29fad0a69e52d635a004332b8969327a4a272) chore(router): disable check_cmd for now (@gabrtv)
- [bb67e58](https://github.com/deis/deis/commit/bb67e581eb468b0239409b26397cc2f0ad4481ab) chore(registry): turn logging to info (@gabrtv)
- [6e1d70d](https://github.com/deis/deis/commit/6e1d70d98607bc578df75d917faaf6cf9843fe8d) chore(database): remove conf.d comments (@gabrtv)
- [774ef63](https://github.com/deis/deis/commit/774ef6303b44c0b6d58c2f600bc9fd8391cfe9a2) fix(vagrant): add host ip to /etc/hosts (@gabrtv)
- [0e2b42b](https://github.com/deis/deis/commit/0e2b42bd025f785af5130197f110089257b8896c) chore(makefile): remove docker daemon from logs (@gabrtv)
- [34aab76](https://github.com/deis/deis/commit/34aab76228596db5eb95114abcbbbb5f2b42994d) chore(vagrant): bump memory to 4096 (@gabrtv)
- [6c15217](https://github.com/deis/deis/commit/6c15217c5e13d32c99ccded949504a10d3d91eba) fix(router): handle non-zero rc from etcdctl mkdir (@gabrtv)
- [dfc762c](https://github.com/deis/deis/commit/dfc762ca1923ffc5aa9dd4608730e07f7b899159) fix(scheduler) switch to getent for host resolution (@gabrtv)
- [2b9fa82](https://github.com/deis/deis/commit/2b9fa8292d99556db465d4155f73c99e7ca3fe0c) fix(etcdctl): use no-sync option to prevent connectivity issues (@gabrtv)
- [0b54a13](https://github.com/deis/deis/commit/0b54a135a54bc3b58d9a179a1395a3e82bc57a76) fix(docker): switch to aufs storage backend (@gabrtv)
- [7e9b418](https://github.com/deis/deis/commit/7e9b41853f74c23ca23d533f7258d5e2dee9a4d3) fix(systemd): wait for etcd.service (@gabrtv)
- [6aa0092](https://github.com/deis/deis/commit/6aa0092df404c127eef85af7e52638b902ea2e54) chore(journal): suppress etcdctl output, add other clarifying output (@gabrtv)
- [e173103](https://github.com/deis/deis/commit/e173103aa86759ff6d989192603876b3b65e099a) perf(images): seed docker images as a oneshot (@gabrtv)
- [4029205](https://github.com/deis/deis/commit/4029205c775b6518969aaf14810cfb1c30232324) fix(scheduler): remove unused functions (@bacongobbler)
- [853ed89](https://github.com/deis/deis/commit/853ed8970a441c27dd979ac43bd1b47a93fdb06c) docs(readme): `make pull` of cached layers to speed `make build` (@gabrtv)
- [6efe264](https://github.com/deis/deis/commit/6efe2640228471b85c3542ba384f4294ca11648a) perf(images): seed the deis-registry with slugrunner on boot (@gabrtv)
- [decd712](https://github.com/deis/deis/commit/decd71211b8b900780822e7e4cae73b6b708f446) fix(builder): fix typo in confd toml (@gabrtv)
- [163359a](https://github.com/deis/deis/commit/163359a61d55e99b3c399b332f7c2b6da4aaa1b4) feat(builder): scale the web process by 1 (@bacongobbler)
- [f849c47](https://github.com/deis/deis/commit/f849c4765d5949817f1bfbd8a2ee0270d31cfb07) fix(docker): use btrfs as coreos does. (@mboersma)
- [2fb3dfd](https://github.com/deis/deis/commit/2fb3dfd86ac1433892ed64cec6e5185b0a877721) refactor(controller): remove chef gem (@bacongobbler)
- [9e11148](https://github.com/deis/deis/commit/9e111489a7458d4567715ab5b384be5b64035a31) fix(tests): use TransactionTestCase where threads are used (@gabrtv)
- [17d36e1](https://github.com/deis/deis/commit/17d36e1cd7c2f9eb02576d15d0236e10fdf5731b) fix(controller): use postgresql for tests (@bacongobbler)
- [42e45a6](https://github.com/deis/deis/commit/42e45a6a14c540ad8d083dd46d8aad9ffa82a106) fix(controller): allow only admins cluster access (@bacongobbler)
- [5b3d268](https://github.com/deis/deis/commit/5b3d268062834455d20191e272b297f72585b79f) bug(contrib/coreos): fix Docker bridge (@carmstrong)
- [231ede3](https://github.com/deis/deis/commit/231ede3816c3d0bb8576ca46d7a7d2c453f5c390) fix(contrib): update ec2 cloudformation docs (@bacongobbler)
- [110f093](https://github.com/deis/deis/commit/110f09360213975ec13b577f4b556e01e15333ba) bug(docker): bind docker bridge to a specific IP (@carmstrong)
- [741825c](https://github.com/deis/deis/commit/741825cc3588f79ad83dc4daa8f197e7069d6d26) bug(systemd): fix dependencies (@carmstrong)
- [48c06f7](https://github.com/deis/deis/commit/48c06f700b0e58a44d0106006c93ed8995da4859) fix(docs): remove outdated autodocs (@bacongobbler)
- [fd9b42e](https://github.com/deis/deis/commit/fd9b42eff5e2d3e8f7bbb44c8284da6aa3e3121f) fix(client): add clusters command to `deis help` (@bacongobbler)
- [8952179](https://github.com/deis/deis/commit/8952179cd5544f18af98be1dffcde32ff444b087) fix(*): make containers host-aware (@bacongobbler)
- [75ed9d7](https://github.com/deis/deis/commit/75ed9d71c95b4e3398f6464b98d2c01dd09d0619) docs(scheduler): update documentation for CoreOS/Fleet/cluster changes (@mboersma)
- [cfafc0d](https://github.com/deis/deis/commit/cfafc0dbb921ccba26630ab0826dd6c43b5bbc44) refactor(discovery): remove discovery component (@bacongobbler)
- [57cde57](https://github.com/deis/deis/commit/57cde575651a094c4273df201b47c6579c7ec437) feat(contrib/vagrant): support multiple-VM environment (@carmstrong)
- [4111501](https://github.com/deis/deis/commit/4111501dc9de0c99fdda42d82b822d989d6d382f) refactor(contrib): update Deis deployment on AWS (@bacongobbler)
- [a0f3437](https://github.com/deis/deis/commit/a0f3437cd0f7897b399174b2bb049e879b8ce267) refactor(controller): optimize docker build layers (@bacongobbler)
- [cd6a38e](https://github.com/deis/deis/commit/cd6a38e798fbd1ef60efa518efbee473d8d9e580) feat(controller): add container state via FSM (@bacongobbler)
- [e1eafbc](https://github.com/deis/deis/commit/e1eafbc516ec9c2fc6f237b575f5ccff6d421e32) fix(registry): chown /data for data container (@gabrtv)
- [418c025](https://github.com/deis/deis/commit/418c0253c03ea59f91c441e9a129c9afebf7b7e9) fix(controller): install git (@bacongobbler)
- [06659ec](https://github.com/deis/deis/commit/06659eccc1cc9be645d4b32e192f376a8cc325e7) feat(*): add data containers (@bacongobbler)
- [ef67e1b](https://github.com/deis/deis/commit/ef67e1be3eba4a0300308bf65d4a3362673a7b7a) docs(scheduler): removed most references to old concepts (@mboersma)
- [eaa2688](https://github.com/deis/deis/commit/eaa26886e84ca2bba1748c21bff00a7055a9a8d2) docs(scheduler): cleaned up index and concepts (@mboersma)
- [7be28e0](https://github.com/deis/deis/commit/7be28e0420c44ca01a3fc4aadbd14990b2f19072) docs(scheduler): added copy of draft architectural diagram (@mboersma)
- [36e578d](https://github.com/deis/deis/commit/36e578de4d8aebbf35f11cd65c228cf4b6c222e0) fix(*): use host's IP address (@bacongobbler)
- [d5aa3dd](https://github.com/deis/deis/commit/d5aa3ddc3a32902f62a66be6745ebaf8a657756b) docs(scheduler): add and update README.md files (@mboersma)
- [16f7621](https://github.com/deis/deis/commit/16f762101730c5ecbfd3baf3ffe807f63129a87b) docs(contrib/digitalocean): remove support for Digital Ocean (@carmstrong)
- [859940d](https://github.com/deis/deis/commit/859940d271e702f42ef28dde98d044a5064c92f5) fix(systemd): lookup default gateway interface for HOST_IP (@gabrtv)
- [4a1beb1](https://github.com/deis/deis/commit/4a1beb1d67d5aab87d293909634ae5aaee772cb9) fix(docker): add docker-patch.service for symlink workaround (@gabrtv)
- [41489c1](https://github.com/deis/deis/commit/41489c1d5a1110c66352be64102d715cf17f6bbe) fix(systemd): remove path to docker dev binary (@gabrtv)
- [df11de0](https://github.com/deis/deis/commit/df11de09ee4018ae592d66397e8a0bd6adf6ba1a) fix(builder): fix data container volume mounts (@gabrtv)
- [71fb3e6](https://github.com/deis/deis/commit/71fb3e688a86dc50429bb949f24a84a9a73a20f5) chore(builder): remove docker push debug prints (@gabrtv)
- [bb87d3c](https://github.com/deis/deis/commit/bb87d3c197e38215a29e2acf1c8b00486ad958ea) docs(contrib/ec2): add ssh-add command (@bacongobbler)
- [b8df76a](https://github.com/deis/deis/commit/b8df76a845236c3960bf86581b38f43f51505659) fix(registry): wait for port to become available in ExecPostStart (@gabrtv)
- [7dc4a3a](https://github.com/deis/deis/commit/7dc4a3a4f5ec369801e8f1696b7c4cf7aa0e731d) fix(user-data): support dynamic interface for seed-deis-registry (@gabrtv)
- [101c88b](https://github.com/deis/deis/commit/101c88b72bb0ebedbdd10fc1f033850f4fd801f0) fix(*): be more permissive with etcd (@bacongobbler)
- [1dcf378](https://github.com/deis/deis/commit/1dcf3786f110942e1562dcae722013793ff29bd7) chore(client): remove apps:calculate (@bacongobbler)
- [ecf167d](https://github.com/deis/deis/commit/ecf167d762d3153b9385a7c2faecdb3d727c2bad) fix(builder): reside beside the controller (@bacongobbler)
- [e3e8c18](https://github.com/deis/deis/commit/e3e8c183d40a9f5958c9f4d4ce2abe0f90e867f2) fix(fsm): save state transitions as they happen (@gabrtv)
- [b531857](https://github.com/deis/deis/commit/b53185703deceb455500253f53778cbeced383c3) fix(seed-registry): fix typo in ExecStart (@gabrtv)
- [06f4c79](https://github.com/deis/deis/commit/06f4c794890447bcc66ed6bc5d91f46b6a13ad3b) docs(contrib/rackspace): update to reflect CoreOS (@carmstrong)
- [e3c06dc](https://github.com/deis/deis/commit/e3c06dca9770a8ea064b574e8179bf89f48fdba5) docs(contrib): fix ec2 and rackspace formatting (@carmstrong)
- [af7a177](https://github.com/deis/deis/commit/af7a1774c091597379d9e6b370ad7d37030368c7) refactor(contrib): remove check-deis-deps (@carmstrong)
- [78f05d4](https://github.com/deis/deis/commit/78f05d4fb533a363002115cf8c8fe168b88d05ae) fix(app): restored apps:rollback functionality (@mboersma)
- [08d6d24](https://github.com/deis/deis/commit/08d6d240811434f7d9a5fc558650403c71fa5152) fix(contrib/ec2): add custom template (@bacongobbler)
- [6575e4f](https://github.com/deis/deis/commit/6575e4f27c9a1a9ca06f3842b7fd0e8a46e5a6cc) fix(contrib/ec2): be more restrictive with ports (@bacongobbler)
- [8965c0f](https://github.com/deis/deis/commit/8965c0f6c68268bc2c2976029fcbd14c4b699036) fix(contrib/ec2): add UDP perms to the logger (@bacongobbler)
- [b8ced1b](https://github.com/deis/deis/commit/b8ced1b5f1db32bf7c00d404ca0dba0977a95cd4) docs(contrib/ec2): use public DNS name (@bacongobbler)
- [7701372](https://github.com/deis/deis/commit/7701372aa44792ee53311a6ba5dc1d9f4a54d900) feat(logger): add new syslog daemon based on https://github.com/ziutek/syslog (@gabrtv)
- [7216f73](https://github.com/deis/deis/commit/7216f73ea4842a6387558b496347159f54de9e50) feat(logger): use new logger component from controller (@gabrtv)
- [4c99c2b](https://github.com/deis/deis/commit/4c99c2bc3bcd322a6092bdc04066f79fa3cb0037) fix(coreos): add wait_for_announcer to block until containers are ready (@gabrtv)
- [66f4b3d](https://github.com/deis/deis/commit/66f4b3d46e6a5161d19d72f67a9a188219770f9a) docs(scheduler): updated CLI instructions and developer docs (@mboersma)
- [4757378](https://github.com/deis/deis/commit/475737883cd3f1852e3606af65a24742bf8aa52d) fix(controller): use Deis' fork of django-fsm (@bacongobbler)
- [385dd6a](https://github.com/deis/deis/commit/385dd6ae9ff5ee05dc96e8507dec4da8fb46507b) docs(scheduler): add migration doc, update faq and localdev (@mboersma)
- [c35a25f](https://github.com/deis/deis/commit/c35a25f297f96e9a6b9708ebd58fde5274a45f19) fix(registry): Use cache host and port from confd (@johanneswuerbach)
- [1cd651e](https://github.com/deis/deis/commit/1cd651e1a2d88ee29a95b8f43dbc02bb8a926408) docs(scheduler): update "provision a controller" doc (@mboersma)
- [c264205](https://github.com/deis/deis/commit/c264205242541ae8c964e700669a39ec8321904c) docs(scheduler): mention coreos-vagrant reboot known issue (@mboersma)
- [ed6a3b8](https://github.com/deis/deis/commit/ed6a3b88c0474289553d0818e17459212d4f4560) fix(controller): use django.conf (@bacongobbler)
- [f45919c](https://github.com/deis/deis/commit/f45919c0c68fa09fd22492008013f64e137162cb) docs(scheduler): add reminder about migration and v0.7.0 (@mboersma)
- [#713](https://github.com/deis/deis/pull/713) Merge pull request #713 from opdemand/scheduler (@opdemand)
- [d9b8578](https://github.com/deis/deis/commit/d9b8578b0fc4c155d0428818574cfa5eb0ada3bd) fix(router): docker build fails when apt archive is stale (@mboersma)
- [#733](https://github.com/deis/deis/pull/733) Merge pull request #733 from opdemand/fix-router-build (@opdemand)
- [5f8f775](https://github.com/deis/deis/commit/5f8f77556030f04fe92e7e1b8652f22eb7b43516) fix(controller/systemd): schedule on same machine as logger (@carmstrong)
- [#734](https://github.com/deis/deis/pull/734) Merge pull request #734 from opdemand/fix_controller_unit (@opdemand)
- [28458f2](https://github.com/deis/deis/commit/28458f2397f499e14e8e5645851c19fe53a32dc0) fix(docs): mention "easy-fix" tag in contributing docs (@mboersma)
- [dfd202b](https://github.com/deis/deis/commit/dfd202b6e43d4440ef767ed5298df0e561898e93) docs(migrating): remove "nothing changes" phrase (@mboersma)
- [8eb5a01](https://github.com/deis/deis/commit/8eb5a01e85dc9e52ac4210e34cd2fac9436fa59e) docs(contrib/vagrant): update location of fleetctl (@bacongobbler)
- [#735](https://github.com/deis/deis/pull/735) Merge pull request #735 from opdemand/easy-fix-contrib (@opdemand)
- [e08de54](https://github.com/deis/deis/commit/e08de5496e53831dd21c4361f9b70686960cb239) fix(travis-ci): remove defunct "scheduler" branch (@mboersma)
- [0695711](https://github.com/deis/deis/commit/06957116f216783d78f245e25b2807299b69040e) fix(controller/tests): run coverage with "--timid" flag (@mboersma)
- [aae8fcd](https://github.com/deis/deis/commit/aae8fcd13fe0d82cd4bc5e5499e4acb2d4bcaa8a) chore(contrib/vagrant): lower memory to 2GB (@carmstrong)
- [3dda9fb](https://github.com/deis/deis/commit/3dda9fbeab1c546b8f137ea22bb4492d7e6f9112) fix(controller): fix container admin view (@bacongobbler)
- [746e140](https://github.com/deis/deis/commit/746e140cbd89aa29d3a813c270611394851bfb80) feat(controller): make coreos the default cluster (@bacongobbler)
- [ac966be](https://github.com/deis/deis/commit/ac966be8261dd9c0b024a19a2a8d50df8fb02f27) feat(controller): add faulty cluster (@bacongobbler)
- [#742](https://github.com/deis/deis/pull/742) Merge pull request #742 from opdemand/postgresql-test-errors (@opdemand)
- [8517d7d](https://github.com/deis/deis/commit/8517d7dff3e57b839a3c1825843e24486a8c5a22) test(controller): add more container state tests (@bacongobbler)
- [1d05e0d](https://github.com/deis/deis/commit/1d05e0d18061ad2559ecf16dead104dffb2c632c) fix(controller): remove cluster from list_filter (@bacongobbler)
- [33eee91](https://github.com/deis/deis/commit/33eee91c916b00fa8e84bd977be016ca847f8f01) fix(controller): fix flake8 (@bacongobbler)
- [#745](https://github.com/deis/deis/pull/745) Merge pull request #745 from opdemand/better-scheduling-tests (@opdemand)
- [#744](https://github.com/deis/deis/pull/744) Merge pull request #744 from opdemand/vagrant_memory (@opdemand)
- [#728](https://github.com/deis/deis/pull/728) Merge pull request #728 from johanneswuerbach/fix-prod-registry (@johanneswuerbach)
- [084dc18](https://github.com/deis/deis/commit/084dc18c264285280e744b4669ee4806901343ec) fix(vagrant): enable patch-docker (@bacongobbler)
- [0f6761e](https://github.com/deis/deis/commit/0f6761e23debb211bcd5b81b623a0862672670cc) feat(client): add --no-remote option (@bacongobbler)
- [9614d3b](https://github.com/deis/deis/commit/9614d3b6c1560f2c2d15cd0dc8aadafa0890cfa8) fix(contrib/vagrant): prevent Vagrant reboots (@carmstrong)
- [c9d0feb](https://github.com/deis/deis/commit/c9d0febcc5ca1f4260e338358f3076f901c26159) chore(contrib/vagrant): update CoreOS box image (@carmstrong)
- [5dc2abe](https://github.com/deis/deis/commit/5dc2abe784f565fdb20bf7e1345d42d57e62be23) refactor(client): fix program flow of --no-remote (@bacongobbler)
- [#754](https://github.com/deis/deis/pull/754) Merge pull request #754 from opdemand/stop_vagrant_reboots (@opdemand)
- [#757](https://github.com/deis/deis/pull/757) Merge pull request #757 from opdemand/hotfix-no-remote (@opdemand)
- [#750](https://github.com/deis/deis/pull/750) Merge pull request #750 from opdemand/enable-patched-docker (@opdemand)
- [#756](https://github.com/deis/deis/pull/756) Merge pull request #756 from opdemand/update_virtualbox_image (@opdemand)
- [4db0fe4](https://github.com/deis/deis/commit/4db0fe40f8ba026e384e17ba1a7cc7ba69473dc9) docs(concepts): add back build/release/run docs (@bacongobbler)
- [a9685e3](https://github.com/deis/deis/commit/a9685e3dd4fbcf6a14767f2d60204e4e882dcdd7) revert aafe0dd813591254471db597d452d75791f9280f (@bacongobbler)
- [#758](https://github.com/deis/deis/pull/758) Merge pull request #758 from opdemand/build-release-run (@opdemand)
- [af3bf60](https://github.com/deis/deis/commit/af3bf602ca2c7e0665d21e045d66689b4c5e1ee9) Fix contrib/vagrant/Makefile to work on non bash-symlinked /bin/sh. (@jperville)
- [cff6b59](https://github.com/deis/deis/commit/cff6b59502c9d4cb95cb661204e3137fe5e17687) fix(controller): update Django admin fields (@mboersma)
- [#761](https://github.com/deis/deis/pull/761) Merge pull request #761 from jperville/makefile-bashism-fix (@jperville)
- [3d09675](https://github.com/deis/deis/commit/3d096758cd9919b33c24819e20115e79f90ae07e) fix(contrib/vagrant): fix vagrant n-node Makefile (@carmstrong)
- [#759](https://github.com/deis/deis/pull/759) Merge pull request #759 from opdemand/vagrant_3node_makefile (@opdemand)
- [2b23db5](https://github.com/deis/deis/commit/2b23db5583c8f08feb800d54d5d0e3ee063fb9f7) feat(registry): add s3 redirect support (@johanneswuerbach)
- [#764](https://github.com/deis/deis/pull/764) Merge pull request #764 from johanneswuerbach/registry-s3-redirect (@johanneswuerbach)
- [d857735](https://github.com/deis/deis/commit/d85773542a54a972f9eb9ffb8493d3e35a44bc03) fix(logger): fix publish loop (@bacongobbler)
- [29f503a](https://github.com/deis/deis/commit/29f503afba0d95a713782a37052f6b6d6299ce87) feat(contrib/ec2): add m3 instances to template (@bacongobbler)
- [67ebd8c](https://github.com/deis/deis/commit/67ebd8c529812b15d90a4afbbc265e5f1717c635) refactor(seed-deis-registry): move to .service file (@carmstrong)
- [#770](https://github.com/deis/deis/pull/770) Merge pull request #770 from opdemand/move_seed_registry (@opdemand)
- [8f48f64](https://github.com/deis/deis/commit/8f48f64ef727e528c01357c1dce3beb69a9f0a56) docs(contrib): maintainers merge their own PRs (@bacongobbler)
- [b657d18](https://github.com/deis/deis/commit/b657d18d43eeae124d430e7fc418da31d5ed5049) fix(vagrant): use start on make run (@bacongobbler)
- [#763](https://github.com/deis/deis/pull/763) Merge pull request #763 from opdemand/fix-django-admin (@opdemand)
- [6ce0371](https://github.com/deis/deis/commit/6ce03710ff921a4fef72c619a083f3bc8cd90ec1) fix(seed-deis-registry): move into deis-registry.service (@carmstrong)
- [#775](https://github.com/deis/deis/pull/775) Merge pull request #775 from opdemand/seed_registry_fix (@opdemand)
- [#771](https://github.com/deis/deis/pull/771) Merge pull request #771 from opdemand/more-contrib-standards (@opdemand)
- [#772](https://github.com/deis/deis/pull/772) Merge pull request #772 from opdemand/use-make-start (@opdemand)
- [#766](https://github.com/deis/deis/pull/766) Merge pull request #766 from opdemand/fix-logger-publish-loop (@opdemand)
- [90c2ead](https://github.com/deis/deis/commit/90c2ead381c57194fc91aefb79a839b53010b111) fix(contrib/ec2): bump size to m3.large (@bacongobbler)
- [faf2c92](https://github.com/deis/deis/commit/faf2c920a0422254acc74c22393fe3e7bbc3ac6e) fix(docker): remove patched docker, switch to deis/base data container (@gabrtv)
- [a43e0d6](https://github.com/deis/deis/commit/a43e0d6a238a679983de6b3306a27fce69f74602) feat(coreos): update vagrant box to coreos-291.0.0 (@mboersma)
- [#778](https://github.com/deis/deis/pull/778) Merge pull request #778 from opdemand/remove-patched-docker (@opdemand)
- [#777](https://github.com/deis/deis/pull/777) Merge pull request #777 from opdemand/coreos-289.0.0 (@opdemand)
- [90dab33](https://github.com/deis/deis/commit/90dab33613be96e618d1def677db852c21b47010) fix(contrib/vagrant): fix Makefile loop (@carmstrong)
- [aab675a](https://github.com/deis/deis/commit/aab675aeed62d5e42a76e085387e710b09c5f04f) fix(controller): fix registry API calls (@bacongobbler)
- [#782](https://github.com/deis/deis/pull/782) Merge pull request #782 from opdemand/fix-registry-errors (@opdemand)
- [#768](https://github.com/deis/deis/pull/768) Merge pull request #768 from opdemand/add-m3-instances (@opdemand)
- [#780](https://github.com/deis/deis/pull/780) Merge pull request #780 from opdemand/fix_makefile_loop (@opdemand)
- [0c80d53](https://github.com/deis/deis/commit/0c80d53444a5d58f1c783b600b8d992a116b6d0e) fix(logger): import syslog package from github (@bacongobbler)
- [825a0c6](https://github.com/deis/deis/commit/825a0c65c4e1a2265f43d036c34fa48728417c20) refactor(seed-deis-registry): remove seed-deis-registry dependency (@carmstrong)
- [#788](https://github.com/deis/deis/pull/788) Merge pull request #788 from opdemand/remove_registry_block (@opdemand)
- [a678b23](https://github.com/deis/deis/commit/a678b239df793680b073c20bef5338f26e16285a) fix(Makefile): alphabetize component names (@bacongobbler)
- [#789](https://github.com/deis/deis/pull/789) Merge pull request #789 from opdemand/import-syslog (@opdemand)
- [d4bb423](https://github.com/deis/deis/commit/d4bb423bf0febbf0b69a5c7b5ec24dc4ff810b75) fix(logger): install deps in proper location (@bacongobbler)
- [2731b3a](https://github.com/deis/deis/commit/2731b3a352201313d0f24fd087dc9e5f03375743) chore(controller): remove provider libraries from requirements.txt (@mboersma)
- [#793](https://github.com/deis/deis/pull/793) Merge pull request #793 from opdemand/fix-syslogd (@opdemand)
- [#790](https://github.com/deis/deis/pull/790) Merge pull request #790 from opdemand/alphabetized (@opdemand)
- [0e32e03](https://github.com/deis/deis/commit/0e32e039397730701980906bc5306f24e98e970c) chore(contrib/vagrant): update vagrant box to coreos-295.0.0 (@mboersma)
- [#795](https://github.com/deis/deis/pull/795) Merge pull request #795 from opdemand/requirements-diet (@opdemand)
- [#796](https://github.com/deis/deis/pull/796) Merge pull request #796 from deis/coreos-295.0.0 (@deis)
- [7ac2e85](https://github.com/deis/deis/commit/7ac2e858d3457aa544a9108743e1c2564998ecb2) fix(github): update URL references to opdemand/deis (@mboersma)
- [#801](https://github.com/deis/deis/pull/801) Merge pull request #801 from deis/deis-deis-fixup (@deis)
- [cd66fd2](https://github.com/deis/deis/commit/cd66fd281181384ec9c4f9e7c5cd18aa89da1923) refactor(Vagrantfile): merge Vagrantfiles and update to upstream (@carmstrong)
- [241c696](https://github.com/deis/deis/commit/241c6960c85ce329377ba5699c805b1ea19c6c80) fix(tests): skip problematic section of BuildTest (@mboersma)
- [3b2ee0d](https://github.com/deis/deis/commit/3b2ee0d7dd14178eb99bc609b396798aca527f6a) fix(coverage): revert addition of "--timid" flag to coverage (@mboersma)
- [#803](https://github.com/deis/deis/pull/803) Merge pull request #803 from deis/postgres-tests-workaround (@deis)
- [#799](https://github.com/deis/deis/pull/799) Merge pull request #799 from deis/merge_vagrantfiles (@deis)
- [828a1df](https://github.com/deis/deis/commit/828a1dfc22c07ac9d22419bacd4e33805b5f393f) fix(Makefile): upload fleetctl units all at once (@carmstrong)
- [71a86d9](https://github.com/deis/deis/commit/71a86d9d08ca654344dabf60bd61cfdfba29163c) fix(README): remove extraneous ` (@carmstrong)
- [#807](https://github.com/deis/deis/pull/807) Merge pull request #807 from deis/fix_fleetctl_scheduling (@deis)
- [2ce2c3e](https://github.com/deis/deis/commit/2ce2c3e10b851db9967ffdcb0b6563978eccf3d2) chore(contrib/vagrant): update vagrant box to coreos-296.0.0 (@mboersma)
- [#808](https://github.com/deis/deis/pull/808) Merge pull request #808 from deis/coreos-296.0.0 (@deis)
- [3ddbccf](https://github.com/deis/deis/commit/3ddbccfddf694c783274adf1d0a903403927a1b6) refactor(client): rename containers to ps (@bacongobbler)
- [0f5c460](https://github.com/deis/deis/commit/0f5c460c07dee0347b6c92b28d33cc37a8e59d7d) fix(scheduler): announce proper address (@bacongobbler)
- [#813](https://github.com/deis/deis/pull/813) Merge pull request #813 from deis/rename-containers (@deis)
- [#814](https://github.com/deis/deis/pull/814) Merge pull request #814 from deis/fix-announce (@deis)
- [123776e](https://github.com/deis/deis/commit/123776e9d1dd8224b6269f423ff40eed344d40b4) Removed duplicate etcdctl installation statements (@zyegfryed)
- [#822](https://github.com/deis/deis/pull/822) Merge pull request #822 from zyegfryed/patch-1 (@zyegfryed)
- [69f138a](https://github.com/deis/deis/commit/69f138a4cfc17c00222460454975ef799f031a7c) chore(vagrant): update box to coreos-298.0.0 (@mboersma)
- [#824](https://github.com/deis/deis/pull/824) Merge pull request #824 from deis/coreos-298.0.0 (@deis)
- [787d857](https://github.com/deis/deis/commit/787d857e97e46fed661bb0c51fc651cb8a3abc46) fix(services): manage dependencies manually (@carmstrong)
- [#821](https://github.com/deis/deis/pull/821) Merge pull request #821 from deis/fix_scheduling (@deis)
- [04b21e4](https://github.com/deis/deis/commit/04b21e4df88cfdbb5de5df5d7664751fa386591a) chore(controller): update to Django 1.6.3 security release (@mboersma)
- [6783d9a](https://github.com/deis/deis/commit/6783d9a787c719d98f032591d8a5851a20849dea) fix(contrib/ec2): fix ephemeral port range (@bacongobbler)
- [4a029f6](https://github.com/deis/deis/commit/4a029f63ed5accdeee934fad9509bd20d1cc5c59) fix(coverage): cd to controller dir before submitting to coveralls.io (@mboersma)
- [#827](https://github.com/deis/deis/pull/827) Merge pull request #827 from deis/fix-ephemeral-port-range (@deis)
- [#828](https://github.com/deis/deis/pull/828) Merge pull request #828 from deis/fix-coveralls-io (@deis)
- [#794](https://github.com/deis/deis/pull/794) Merge pull request #794 from deis/django-1.6.3 (@deis)
- [1fb49d8](https://github.com/deis/deis/commit/1fb49d8493839fb69eee5247d3b6b65ea1f9c3f4) fix(Makefile): use /bin/sh if syntax (@bacongobbler)
- [#829](https://github.com/deis/deis/pull/829) Merge pull request #829 from deis/make-controller (@deis)
- [a2d006c](https://github.com/deis/deis/commit/a2d006cd8b8a5c9336319bee98835d7b54610145) fix(builder): update Docker to v0.10.0 (@mboersma)
- [f112a5f](https://github.com/deis/deis/commit/f112a5f0e0d2eaa2bdbdecf5fe2b7f084f2d4179) feat(Makefile): pull deis/slugrunner (@bacongobbler)
- [#832](https://github.com/deis/deis/pull/832) Merge pull request #832 from deis/slugrunner-pull (@deis)
- [b81f4a8](https://github.com/deis/deis/commit/b81f4a85abc2ea3980d998a0bebde812e4c53ae4) feat(controller): make Procfile mandatory (@bacongobbler)
- [a4da57d](https://github.com/deis/deis/commit/a4da57daac768e0f5e49f32d6c714ffcdcd6d915) fix(Makefile): 'make run' starts Deis in one shot (@carmstrong)
- [#833](https://github.com/deis/deis/pull/833) Merge pull request #833 from deis/builder-docker-0.10.0 (@deis)
- [#831](https://github.com/deis/deis/pull/831) Merge pull request #831 from deis/makefile_friendly_loop (@deis)
- [c7a3247](https://github.com/deis/deis/commit/c7a3247fafd086554516991d1131da0c4ed9b05b) chore(contrib/ec2): update AMIs for build 298.0.0 (@bacongobbler)
- [326d383](https://github.com/deis/deis/commit/326d3838d72f3752609d6a50c334e11a7cf377b5) chore(contrib): remove docker project (@bacongobbler)
- [#835](https://github.com/deis/deis/pull/835) Merge pull request #835 from deis/update-amis (@deis)
- [#836](https://github.com/deis/deis/pull/836) Merge pull request #836 from deis/remove-docker-contrib (@deis)
- [bc5f72b](https://github.com/deis/deis/commit/bc5f72bf2cf09e3a31622aed45fcbb286dee5a5a) fix(controller): rename destroy() to delete() and call its super() (@mboersma)
- [027a001](https://github.com/deis/deis/commit/027a0019c410cdb88d6cbb6a85a75344be6c7d02) chore(controller): update to Django 1.6.4 bugfix release (@mboersma)
- [c90614a](https://github.com/deis/deis/commit/c90614adecaa31fe7a865fa9dc42423a3fece1c1) fix(docs): rename client/containers.rst to ps.rst (@mboersma)
- [42d2122](https://github.com/deis/deis/commit/42d2122b978fece5e87894fae8b68b42a26139f6) docs(localdev): add "Test Your Changes" section to local dev docs (@mboersma)
- [2a0bd99](https://github.com/deis/deis/commit/2a0bd99c37572b3f8c34bbf216c7730a538c8c90) docs(ec2): remove reference to obsolete script (@mboersma)
- [#842](https://github.com/deis/deis/pull/842) Merge pull request #842 from deis/add-interactive-dev-docs (@deis)
- [#841](https://github.com/deis/deis/pull/841) Merge pull request #841 from deis/fix-client-ps-docs (@deis)
- [#840](https://github.com/deis/deis/pull/840) Merge pull request #840 from deis/django-1.6.4 (@deis)
- [#839](https://github.com/deis/deis/pull/839) Merge pull request #839 from deis/app-fleet-delete (@deis)
- [#844](https://github.com/deis/deis/pull/844) Merge pull request #844 from deis/ec2-readme-cleanup (@deis)
- [#834](https://github.com/deis/deis/pull/834) Merge pull request #834 from deis/procfile-mandatory (@deis)
- [c2f4085](https://github.com/deis/deis/commit/c2f4085ed5f26c46ccc1c07cf8c289d2aea78837) feat(test): add integration tests (@carmstrong)
- [#837](https://github.com/deis/deis/pull/837) Merge pull request #837 from deis/integration_tests (@deis)
- [ebf51c2](https://github.com/deis/deis/commit/ebf51c23b8d903385714355571e6e05e8ec256da) docs(contrib/ec2): generate the keypair (@bacongobbler)
- [ac0ae39](https://github.com/deis/deis/commit/ac0ae39fdae724e64cca7c7bc8181b1382286d6b) docs(contrib/ec2): use ~/.ssh/deis instead (@bacongobbler)
- [#853](https://github.com/deis/deis/pull/853) Merge pull request #853 from deis/ec2-keypair (@deis)
- [df5f1d1](https://github.com/deis/deis/commit/df5f1d13af6beb0fc888ae9a474de9d2ef2c460a) feat(Makefile): status reports and better error handling (@carmstrong)
- [50b0cda](https://github.com/deis/deis/commit/50b0cdab0c6a6fd7741bd0a12e8dc784694c39bd) docs(release): update procedure for v0.8.0 release (@mboersma)
- [#854](https://github.com/deis/deis/pull/854) Merge pull request #854 from deis/more_makefile_error_checking (@deis)
- [#855](https://github.com/deis/deis/pull/855) Merge pull request #855 from deis/update-release-doc (@deis)
- [2c0e4c6](https://github.com/deis/deis/commit/2c0e4c60194a9f736c0a486c2285d1c91b7fef8a) fix(services): use COREOS_PUBLIC_IPV4 for advertised IP (@carmstrong)
- [#851](https://github.com/deis/deis/pull/851) Merge pull request #851 from deis/dont_guess_advertised_ip (@deis)
- [8d2f30a](https://github.com/deis/deis/commit/8d2f30a715f21c40f51230266646a00427a83ec4) docs(client): update links to binary versions for v0.8.0 (@mboersma)
- [b493ad9](https://github.com/deis/deis/commit/b493ad9961480b2635491c2e1a7d2b845715549e) fix(builder): start after controller, block until running (@carmstrong)
- [4f92caf](https://github.com/deis/deis/commit/4f92caf601e161c72ef687c5f3ca5eb68d6226a5) Revert "feat(controller): make Procfile mandatory" (@bacongobbler)
- [d1e14a6](https://github.com/deis/deis/commit/d1e14a6f76789a86f1959ba7bf6057b3abe3b960) feat(controller): handle special cmd proctype (@bacongobbler)
- [#861](https://github.com/deis/deis/pull/861) Merge pull request #861 from deis/binary-clients-v0.8.0 (@deis)
- [#862](https://github.com/deis/deis/pull/862) Merge pull request #862 from deis/cmd-proctype (@deis)
- [#863](https://github.com/deis/deis/pull/863) Merge pull request #863 from deis/block_builder (@deis)
- [198e550](https://github.com/deis/deis/commit/198e55005faf45ab0491bfa07d069a87a07a030c) docs(readme): move cluster testing section out of developer workflow (@gabrtv)
- [8cf66bd](https://github.com/deis/deis/commit/8cf66bd3328a8185096dff59be5fbc6470fde92d) docs(readme): add ref to integration tests, reorder language (@gabrtv)
- [#864](https://github.com/deis/deis/pull/864) Merge pull request #864 from deis/reorder-readme (@deis)
- [1286afc](https://github.com/deis/deis/commit/1286afc86f5d45abafc1e896e5784a39030595d4) docs(ec2): add CLI key import, explicit chdir (@gabrtv)
- [a8869a9](https://github.com/deis/deis/commit/a8869a98d11ca820ccd822f5dbc55810356d58ed) docs(rackspace): add explicit chdir (@gabrtv)
- [cbeca5a](https://github.com/deis/deis/commit/cbeca5ae4fd3726619ec0c5ca6bf24fec53e8c91) docs(ec2): add CLI key import, explicit chdir (@gabrtv)
- [#865](https://github.com/deis/deis/pull/865) Merge pull request #865 from deis/fix-ec2-readme (@deis)
- [57ceade](https://github.com/deis/deis/commit/57ceade32933c583b80ad0888c2df96e81109676) fix(contrib/ec2): fix README from #865 (@carmstrong)
- [#868](https://github.com/deis/deis/pull/868) Merge pull request #868 from deis/fix_865 (@deis)
- [5d3cebf](https://github.com/deis/deis/commit/5d3cebf9e29654b70790585d404aa1189cb05b56) refactor(Makefile): better multi-node support (@carmstrong)
- [66660a4](https://github.com/deis/deis/commit/66660a41b8be0a1e795a77973394737fed0f1044) fix(systemd): handle starting containers that already exist (@gabrtv)
- [#871](https://github.com/deis/deis/pull/871) Merge pull request #871 from deis/remove-on-start (@deis)
- [0426805](https://github.com/deis/deis/commit/04268059cc2f9e76814c742cda417a8d1bd7bb7e) docs(dns): move content from README.md into "Configure DNS" doc (@mboersma)
- [#870](https://github.com/deis/deis/pull/870) Merge pull request #870 from deis/dns_readme (@deis)
- [09dc820](https://github.com/deis/deis/commit/09dc8207a0d34f2b6d124e4bba2798fab50eb2bc) fix(docker): add an ARP entry each time a container comes up (@mboersma)
- [9502968](https://github.com/deis/deis/commit/9502968080cc07e43e37fc71fbe13ebc192772ae) fix(contrib): #859 remove update manager stop commands from Vagrantfile (@dginther)
- [8dfbe8c](https://github.com/deis/deis/commit/8dfbe8c5ce6aac0f62c695ec722fe38c841b1816) fix(user-data): use $private_ipv4 for etcd/fleet (@carmstrong)
- [9e3b471](https://github.com/deis/deis/commit/9e3b4712a16d08828aa2c8ec3d4aad100cb9895c) fix(contrib/ec2): use shared user-data (@carmstrong)
- [a99c75a](https://github.com/deis/deis/commit/a99c75ae8b222eda0843e036f9d06fef5ff0127f) docs(typo): change "EC2" to "Rackspace" (@mboersma)
- [#869](https://github.com/deis/deis/pull/869) Merge pull request #869 from deis/contrib_use_user_data (@deis)
- [0818b79](https://github.com/deis/deis/commit/0818b79484c78bc321c9e8381ed0283358a4757c) style(coreos): remove unused systemd template strings (@mboersma)
- [22681a3](https://github.com/deis/deis/commit/22681a3aa6b2f27ac65a1033040104754d54da23) fix(controller): start logger service after container (@mboersma)
- [c383ba1](https://github.com/deis/deis/commit/c383ba1ef8bb376edcdc965bc22a97127422c773) refactor(controller): remove duplicate run() method (@mboersma)
- [#877](https://github.com/deis/deis/pull/877) Merge pull request #877 from deis/logger-after-container (@deis)
- [#873](https://github.com/deis/deis/pull/873) Merge pull request #873 from deis/prime-arp-workaround (@deis)
- [aac4f6a](https://github.com/deis/deis/commit/aac4f6a5198e8060032d42a9f411167f8c0a51f7) fix(Makefile): check for errors after controller (@carmstrong)
- [#881](https://github.com/deis/deis/pull/881) Merge pull request #881 from deis/add_check_errors (@deis)
- [#879](https://github.com/deis/deis/pull/879) Merge pull request #879 from deis/vestigial-templates (@deis)
- [5521435](https://github.com/deis/deis/commit/5521435c8a82dd555fea0b7330ca7b17af092a37) fix(systemd): handle app containers on restarts (@bacongobbler)
- [#872](https://github.com/deis/deis/pull/872) Merge pull request #872 from deis/remove-containers-on-start (@deis)
- [dd6e16d](https://github.com/deis/deis/commit/dd6e16deefd5f435aebcc2ce9f556b0716a876e5) docs(contributing): add skip ci tag (@bacongobbler)
- [fb38eb6](https://github.com/deis/deis/commit/fb38eb65ab7ad50386216f470e1656dbee3b0cd2) fix(test): specify machine IPs (@carmstrong)
- [#886](https://github.com/deis/deis/pull/886) Merge pull request #886 from deis/docs-no-ci (@deis)
- [ff24d62](https://github.com/deis/deis/commit/ff24d62c43f0724c7ba47e13bc3cbb48809bec04) fix(ec2): add explicit 100GB root volume (@gabrtv)
- [#889](https://github.com/deis/deis/pull/889) Merge pull request #889 from deis/test_hosts (@deis)
- [#895](https://github.com/deis/deis/pull/895) Merge pull request #895 from deis/fix-ec2-space (@deis)

### v0.7.0 (2014/04/10 22:42 +00:00)
- [273551c](https://github.com/deis/deis/commit/273551cd7cb65a329156385966cccc127a213a27) Switch master to v0.7.0. (@mboersma)
- [a6a3410](https://github.com/deis/deis/commit/a6a3410625da298fd0594fa1797c1268183844f8) Standardize containers on WORKDIR /app (@mboersma)
- [5e672cd](https://github.com/deis/deis/commit/5e672cda1e03aecd75e3e9d729d18302bcbb9067) Standardize install of pip 1.5.4. (@mboersma)
- [ac12f9a](https://github.com/deis/deis/commit/ac12f9abdc6ff2de3b9e40feaa7ce7faadf827d2) Clarify binding to $PORT with Dockerfiles (@gabrtv)
- [c20082c](https://github.com/deis/deis/commit/c20082c1ef5b074cf5d5b869675799b962301e81) Restored deis data bags creation to provision script. (@mboersma)
- [#665](https://github.com/deis/deis/pull/665) Merge pull request #665 from opdemand/664-vagrant-data-bags (@opdemand)
- [31af241](https://github.com/deis/deis/commit/31af241b2bf767311f3afff938aaf57ad52422b4) Clarify 2-LGTM code approval policy. (@mboersma)
- [#666](https://github.com/deis/deis/pull/666) Merge pull request #666 from opdemand/merge-approval (@opdemand)
- [a1e2ee0](https://github.com/deis/deis/commit/a1e2ee07e25ddde294d41c8c008b37521074f9c7) Adds friendly name in VirtualBox and Vagrant (@carmstrong)
- [#663](https://github.com/deis/deis/pull/663) Merge pull request #663 from opdemand/dockerfile-makefile-cleanup (@opdemand)
- [060cfc1](https://github.com/deis/deis/commit/060cfc1f1d55e45d681f8eba729261ca17f2e44a) Let berkshelf resolve dependencies itself (@carmstrong)
- [38647cb](https://github.com/deis/deis/commit/38647cbfd5dc79b38b74aa3cb3ffa611a8122aa7) pin pep8, pyflakes and flake8 to avoid travis errors (@gabrtv)
- [#670](https://github.com/deis/deis/pull/670) Merge pull request #670 from opdemand/pin-pep-pyflakes (@opdemand)
- [#669](https://github.com/deis/deis/pull/669) Merge pull request #669 from opdemand/carmstrong/fix_berksfile (@opdemand)
- [#667](https://github.com/deis/deis/pull/667) Merge pull request #667 from opdemand/carmstrong/vagrant_name (@opdemand)
- [#651](https://github.com/deis/deis/pull/651) Merge pull request #651 from opdemand/548-update-docker (@opdemand)
- [6a2ca5e](https://github.com/deis/deis/commit/6a2ca5e41adaaa2f66e05087bd039c0b04011031) Install lxc explicitly (@carmstrong)
- [d749d14](https://github.com/deis/deis/commit/d749d14190dcde1b18bb3d45db1b517e3af80194) Added major *scheduler* branch to Travis CI. (@mboersma)
- [5a5392f](https://github.com/deis/deis/commit/5a5392f4ee5cacfa2715f2a864adfae0ece62dd0) Reimplemented `deis shortcuts` command. (@mboersma)
- [#676](https://github.com/deis/deis/pull/676) Merge pull request #676 from opdemand/travis-scheduler-branch (@opdemand)
- [#677](https://github.com/deis/deis/pull/677) Merge pull request #677 from opdemand/deis-shortcuts (@opdemand)
- [deb6a14](https://github.com/deis/deis/commit/deb6a14c02a0fae2990b95f7f0d3c84b83984c29) dynamically disable registration (@bacongobbler)
- [3c6d792](https://github.com/deis/deis/commit/3c6d7925aebea9bdf3e66f7b586126cb5f1d90d7) import from django.conf instead (@bacongobbler)
- [d66bc17](https://github.com/deis/deis/commit/d66bc178c09fef1274649d7bdc59ad6fd00e8e2e) docs(standards): add commit style guide (@bacongobbler)
- [88a32c5](https://github.com/deis/deis/commit/88a32c5b425cdc71963adc83a33b1b533376fc60) docs(standards): update old commands (@bacongobbler)
- [6833b28](https://github.com/deis/deis/commit/6833b28603f2846ec52498a20c50905419ba146a) docs(standards): use proper english (@bacongobbler)
- [#672](https://github.com/deis/deis/pull/672) Merge pull request #672 from opdemand/carmstrong/install_lxc (@opdemand)
- [e99cc41](https://github.com/deis/deis/commit/e99cc41a3fd07f46d60f53ed05e26f7b39ae4a88) fix(logger): update rsyslog repo endpoint (@bacongobbler)
- [#681](https://github.com/deis/deis/pull/681) Merge pull request #681 from opdemand/rsyslog-repo-update (@opdemand)
- [207d7a7](https://github.com/deis/deis/commit/207d7a71970ad8669a970a7f3f7dc240c0ab55b9) docs(chef): update for the new manage.opscode.com (@mboersma)
- [#682](https://github.com/deis/deis/pull/682) Merge pull request #682 from opdemand/update-chef-admins (@opdemand)
- [#679](https://github.com/deis/deis/pull/679) Merge pull request #679 from opdemand/disable-registration (@opdemand)
- [#653](https://github.com/deis/deis/pull/653) Merge pull request #653 from opdemand/makefile (@opdemand)
- [#680](https://github.com/deis/deis/pull/680) Merge pull request #680 from opdemand/add-contributing (@opdemand)
- [bdb9f7c](https://github.com/deis/deis/commit/bdb9f7c3bc0d922e751bec372bcd40d926500a52) fix(docs): add codeblock spacing (@bacongobbler)
- [#683](https://github.com/deis/deis/pull/683) Merge pull request #683 from opdemand/fix-docs-formatting (@opdemand)
- [2b19dfd](https://github.com/deis/deis/commit/2b19dfd6911085b2b8db6d50d7a6f873196f8461) use force yes to install required packages (@jstop)
- [#688](https://github.com/deis/deis/pull/688) Merge pull request #688 from clyphub/master (@clyphub)
- [bd5f76f](https://github.com/deis/deis/commit/bd5f76f364c451f0f27fdd1a1821b410bf625226) fix(providers): update dop calls (@bacongobbler)
- [#691](https://github.com/deis/deis/pull/691) Merge pull request #691 from opdemand/fix-digitalocean (@opdemand)
- [#690](https://github.com/deis/deis/pull/690) Merge pull request #690 from opdemand/carmstrong/contributing_docs_stove (@opdemand)
- [#693](https://github.com/deis/deis/pull/693) Merge pull request #693 from opdemand/fix-logger (@opdemand)
- [d2dacb2](https://github.com/deis/deis/commit/d2dacb282c1fca7b104201f0b963ebe032f1e8e4) docs(components): explain a container's filesystem (@bacongobbler)
- [49b2907](https://github.com/deis/deis/commit/49b2907fd02687ff455028a261b7056220c77e6f) Updated CHANGELOG.md. (@mboersma)

### v0.6.0 (2014/03/24 02:55 +00:00)
- [d741c5f](https://github.com/deis/deis/commit/d741c5f52325ad203ca601ac3208be357f96c0ff) Switch master to v0.6.0. (@mboersma)
- [a51d0d2](https://github.com/deis/deis/commit/a51d0d2fce3d429b93b998d34840a77d4f07fc72) import submodules into project (@bacongobbler)
- [60da28e](https://github.com/deis/deis/commit/60da28ea49cd22a1160f172f5e752dff03f832d1) remove unused scripts (@bacongobbler)
- [822762f](https://github.com/deis/deis/commit/822762f23faf545362621e1625032324593766bf) move deis controller to separate project (@bacongobbler)
- [56603dc](https://github.com/deis/deis/commit/56603dcae81c70b42012e12761f8f2fc677302be) updated test suite to point to controller project (@bacongobbler)
- [887732e](https://github.com/deis/deis/commit/887732e92e2641f6b6794f3a0b29fbd221e5efb4) remove client module from controller settings (@bacongobbler)
- [f9f60b3](https://github.com/deis/deis/commit/f9f60b3df7b078d2b23c97551853141200f7991d) fix docs path issue (@bacongobbler)
- [3d079b9](https://github.com/deis/deis/commit/3d079b9e7f62a26309f7e7ee2ab91958619d0fa6) import deis/server (@bacongobbler)
- [7595ecf](https://github.com/deis/deis/commit/7595ecffd3e15e49eb188f9f091acd33bb1399b6) fix test locations (@bacongobbler)
- [bab9616](https://github.com/deis/deis/commit/bab96161998cba2d20bf066b2c9014046886b9a5) set exec bit on controller/bin/boot (@bacongobbler)
- [45c78fb](https://github.com/deis/deis/commit/45c78fb5fc4985cf9fa522cdf257dccfc5c4090a) use the -C option instead (@bacongobbler)
- [3b9518e](https://github.com/deis/deis/commit/3b9518ecfd82dffa4e2c0ceeb4e0c157aa7a7630) move `make client_binary` to client project (@bacongobbler)
- [3310a23](https://github.com/deis/deis/commit/3310a23d396af35218be68a8967c9903c7ba88c2) add back init (@bacongobbler)
- [44eab43](https://github.com/deis/deis/commit/44eab43cef9eadf3226673ec7f4dc22aaa2250c6) Fixed PYTHONPATH for Sphinx docs generation. (@mboersma)
- [b5440da](https://github.com/deis/deis/commit/b5440daa79b132adf7d011d0d33318de80698f92) Install latest pip. (@mboersma)
- [#641](https://github.com/deis/deis/pull/641) Merge pull request #641 from opdemand/godmode (@opdemand)
- [2a63d16](https://github.com/deis/deis/commit/2a63d16c1857eb5727e79f891ec75c45c538bfc4) add build command (@bacongobbler)
- [ebc5acb](https://github.com/deis/deis/commit/ebc5acbc89416ce93f0473f8500658770a47b1b6) Pin pip at v1.5.4. (@mboersma)
- [#644](https://github.com/deis/deis/pull/644) Merge pull request #644 from opdemand/642-pin-pip (@opdemand)
- [884fed5](https://github.com/deis/deis/commit/884fed539dd28d4174d7ee640ac391565bcecbdc) Replaced refs to server and worker with controller. (@mboersma)
- [2931ac6](https://github.com/deis/deis/commit/2931ac6cb3d60aeb0d1b802c7d545e371dc5b56c) fix confd wait issue (@bacongobbler)
- [6fe22d9](https://github.com/deis/deis/commit/6fe22d9429146729f2f3e0e441b45f9f1e5f03e4) only write out chef config if necessary, restart based on pid files (@gabrtv)
- [d179eed](https://github.com/deis/deis/commit/d179eedbd775e8947da455e09fcb2fb6fcc7feac) fix overlapping bind-mount issues (@bacongobbler)
- [#646](https://github.com/deis/deis/pull/646) Merge pull request #646 from opdemand/fix-registry-seed (@opdemand)
- [#635](https://github.com/deis/deis/pull/635) Merge pull request #635 from opdemand/pin-ruby-version (@opdemand)
- [#643](https://github.com/deis/deis/pull/643) Merge pull request #643 from opdemand/add-build-cmd (@opdemand)
- [#645](https://github.com/deis/deis/pull/645) Merge pull request #645 from opdemand/deis-controller-refs (@opdemand)
- [ce5b1bf](https://github.com/deis/deis/commit/ce5b1bfd8dd34bfc014806181befc5be4e1fb107) Run django unit tests via 'make test'. (@mboersma)
- [#650](https://github.com/deis/deis/pull/650) Merge pull request #650 from opdemand/fix-controller-make-test (@opdemand)
- [451711b](https://github.com/deis/deis/commit/451711bd41cc12eed36ecdb9aee252bfbb4c5e25) bump docker to v0.9.0 (@bacongobbler)
- [ba235f4](https://github.com/deis/deis/commit/ba235f4def550f2e7b760df5b4823d44ebbf4cb5) Added release instructions to create CHANGELOG.md files. (@mboersma)
- [063a328](https://github.com/deis/deis/commit/063a328f2b6484910709e16ed6b6a5425b84cd88) let each project manage how they build (@bacongobbler)
- [18f8d38](https://github.com/deis/deis/commit/18f8d38e1eb978fe16c0301ea6906f44a225f36e) Hide 'Versions' links unless at readthedocs.org, fixes #602. (@mboersma)
- [#654](https://github.com/deis/deis/pull/654) Merge pull request #654 from opdemand/fix-docs-versions-link (@opdemand)
- [#652](https://github.com/deis/deis/pull/652) Merge pull request #652 from opdemand/changelog-md (@opdemand)
- [7aa925c](https://github.com/deis/deis/commit/7aa925caf287280440088ad6f19826063453643c) Updated CLI binaries and links in client README. (@mboersma)
- [#658](https://github.com/deis/deis/pull/658) Merge pull request #658 from opdemand/update-cli-binaries (@opdemand)
- [bac1bcd](https://github.com/deis/deis/commit/bac1bcd4454178dcd1d88e76757da292dde5a387) Updated EC2 AMIs for v0.6.0 release. (@mboersma)
- [#659](https://github.com/deis/deis/pull/659) Merge pull request #659 from opdemand/time-to-make-the-amis (@opdemand)
- [7be8b3c](https://github.com/deis/deis/commit/7be8b3c5fbe45589cb1030c677f775f788aabc95) make SSH key and host nodes dir available (@bacongobbler)
- [99a43de](https://github.com/deis/deis/commit/99a43defd92f3f4cbab30a3a0a08c656622a11cc) add empty host_nodes_dir (@bacongobbler)
- [b55f6ff](https://github.com/deis/deis/commit/b55f6ff648da309d414b3d45d35b62ce6dbcde78) fix typo (@bacongobbler)
- [6550851](https://github.com/deis/deis/commit/65508513d4d78de7d94edcc9d5ad279100434b67) Revert "add empty host_nodes_dir" (@bacongobbler)
- [ffafee4](https://github.com/deis/deis/commit/ffafee4b9d9a25c335b01c31385bf6139bdb0dbc) fix path issue (@bacongobbler)
- [3f58af1](https://github.com/deis/deis/commit/3f58af1e94c3858f886cb4b719bd455933dbbf3a) fix dop images function call (@bacongobbler)
- [#662](https://github.com/deis/deis/pull/662) Merge pull request #662 from opdemand/fix-dop-images (@opdemand)
- [#661](https://github.com/deis/deis/pull/661) Merge pull request #661 from opdemand/655-vagrant-nodes (@opdemand)
- [f05ea96](https://github.com/deis/deis/commit/f05ea963779c3b5eb230e537b6b366558069c898) Updated CHANGELOG.md. (@mboersma)

### v0.5.2 (2014/03/18 15:42 +00:00)
- [1f8e06f](https://github.com/deis/deis/commit/1f8e06f963d20f4b51b91824e976da4433d930f9) Switch master to v0.5.2. (@mboersma)
- [f039d79](https://github.com/deis/deis/commit/f039d79703b5f4fa3565dce31666db40bd5c3f50) update script name (@bacongobbler)
- [#601](https://github.com/deis/deis/pull/601) Merge pull request #601 from opdemand/fix-rackspace-provider (@opdemand)
- [#609](https://github.com/deis/deis/pull/609) Merge pull request #609 from opdemand/vagrant-readme (@opdemand)
- [832b868](https://github.com/deis/deis/commit/832b86847316d93cdcd623a5818929ab612c9768) update developer docs to match containerize (@bacongobbler)
- [b0cc506](https://github.com/deis/deis/commit/b0cc506330e880e2e090074710d45f32956687e7) move etcd import to external module imports (@bacongobbler)
- [af4a9d5](https://github.com/deis/deis/commit/af4a9d5df89558e9000c2baf5b58fac20b8e8bf1) typo: use --formation option (@bacongobbler)
- [cf928d7](https://github.com/deis/deis/commit/cf928d7cd7441934ba3a953040c37cdead87169a) add Dockerfile docs and example apps (@bacongobbler)
- [79f1bfa](https://github.com/deis/deis/commit/79f1bfafd1fb6a27450e2a49e64d6554576558ab) elaborate on app deployment (@bacongobbler)
- [#611](https://github.com/deis/deis/pull/611) Merge pull request #611 from opdemand/534-dev-docs-update (@opdemand)
- [fef8241](https://github.com/deis/deis/commit/fef8241fc556ae5eb157c1f012b7574c0c43d255) add docs for buildpacks and dockerfiles (@bacongobbler)
- [44a040f](https://github.com/deis/deis/commit/44a040f5598b1c4aba5c83ec19efad081563dfff) just use links instead of the URL (@bacongobbler)
- [0745b27](https://github.com/deis/deis/commit/0745b275038214c0c1c4784716bf5070c1136dff) update local development docs (@bacongobbler)
- [3b91ff4](https://github.com/deis/deis/commit/3b91ff4d87f95be9e3986533303f692256ed0b7b) update buildstep to slugbuilder (@bacongobbler)
- [0e71835](https://github.com/deis/deis/commit/0e718357c38cc9341df3fa15a66908d8ab75ec21) remove double spaces (@bacongobbler)
- [72363e7](https://github.com/deis/deis/commit/72363e794029ffec562ba51ef7f0cad4a00c0cd5) update Deis' architecture docs (@bacongobbler)
- [3d12f6e](https://github.com/deis/deis/commit/3d12f6ef375c8df343716dafe856b2fcff877ff1) update operator's documentation (@bacongobbler)
- [#615](https://github.com/deis/deis/pull/615) Merge pull request #615 from opdemand/operations-update-docs (@opdemand)
- [#612](https://github.com/deis/deis/pull/612) Merge pull request #612 from opdemand/604-dockerfile-docs (@opdemand)
- [#613](https://github.com/deis/deis/pull/613) Merge pull request #613 from opdemand/localdev-docs (@opdemand)
- [#614](https://github.com/deis/deis/pull/614) Merge pull request #614 from opdemand/architecture-docs (@opdemand)
- [83e2b38](https://github.com/deis/deis/commit/83e2b3868583ab97899e9d51dcd2474a9ef69746) Removed old branch and service from .travis.yml. (@mboersma)
- [72ff95f](https://github.com/deis/deis/commit/72ff95fb2f02a14f774c00195ca64357f80725d8) make notes neon pink and warnings neon orange (@bacongobbler)
- [#616](https://github.com/deis/deis/pull/616) Merge pull request #616 from opdemand/update-travis-yml (@opdemand)
- [a961ea3](https://github.com/deis/deis/commit/a961ea3bc311cb54d5fd17e2beec0ab5b9d94e4d) Updated vagrant readme (@tscheepers)
- [3c5178a](https://github.com/deis/deis/commit/3c5178ae488494b9d9f1326a0157748521ffe526) Fixed grammer error (@tscheepers)
- [1b8af22](https://github.com/deis/deis/commit/1b8af22f92dd14463f27b09098855044cc377ee5) Set hostname of chefserver in provisioning (@tscheepers)
- [df32775](https://github.com/deis/deis/commit/df32775b4652818ca8089a8b71cf97714137c184) fix #542 (@bacongobbler)
- [#623](https://github.com/deis/deis/pull/623) Merge pull request #623 from tscheepers/patch-1 (@tscheepers)
- [#625](https://github.com/deis/deis/pull/625) Merge pull request #625 from opdemand/542-config-vars (@opdemand)
- [4393806](https://github.com/deis/deis/commit/43938065230e6f727d98dc22057333e19f4a52a0) move config test to before initial release (@bacongobbler)
- [55cc766](https://github.com/deis/deis/commit/55cc76661549eb154151de004c2f279562ec16dc) Updated the docs_requirements file, fixes #624. (@mboersma)
- [#626](https://github.com/deis/deis/pull/626) Merge pull request #626 from opdemand/624-fix-rest-docs (@opdemand)
- [#617](https://github.com/deis/deis/pull/617) Merge pull request #617 from opdemand/doc-message-colors (@opdemand)
- [ca72140](https://github.com/deis/deis/commit/ca72140ea89b2c615f8373becb27ce260f2ca781) Merge branch 'dsh-perm-fix' of https://github.com/tombh/deis into tombh-dsh-perm-fix (@mboersma)
- [6ab9df7](https://github.com/deis/deis/commit/6ab9df7628b05f6fa494b188ad1457f7ed22706d) Use sudo when invoking dshell/dsh command. (@mboersma)
- [6ba78b2](https://github.com/deis/deis/commit/6ba78b2b7f4e172b3fbf74cbb2fee8c60c70da97) raise BuildFormationError on build or delete (@bacongobbler)
- [abdf9bd](https://github.com/deis/deis/commit/abdf9bd2788bfa84491feb00f92aee8cd192c302) test new behaviour returns HTTP 400 (@bacongobbler)
- [#628](https://github.com/deis/deis/pull/628) Merge pull request #628 from opdemand/490-formation-without-credentials (@opdemand)
- [b3202fd](https://github.com/deis/deis/commit/b3202fd046ee0f8990fcc1ec657886c7090aaa3c) set min username length to 4 (@bacongobbler)
- [175fdf5](https://github.com/deis/deis/commit/175fdf530a3ca129ccb5b17adc98d82f6ed0560a) typo: must be >= 4 (@bacongobbler)
- [#594](https://github.com/deis/deis/pull/594) Merge pull request #594 from Springest/private_networking_support (@Springest)
- [49f0feb](https://github.com/deis/deis/commit/49f0feb2d21ee83fa1b95d965ad83d51e22c32c1) update dop to v0.1.6 (@bacongobbler)
- [#631](https://github.com/deis/deis/pull/631) Merge pull request #631 from opdemand/add-custom-user-auth (@opdemand)
- [8dde760](https://github.com/deis/deis/commit/8dde760afa7d7263e0d60ed6b0d273e77c6ed0ff) update registry submodule (@bacongobbler)
- [#633](https://github.com/deis/deis/pull/633) Merge pull request #633 from opdemand/update-registry (@opdemand)
- [3dcf63e](https://github.com/deis/deis/commit/3dcf63eda984590116ecb37699a2495a12d2b381) bump registry submodule (@bacongobbler)
- [742cd97](https://github.com/deis/deis/commit/742cd979b296400ea363e8d3f6c5fccdc8237dca) Update submodule SHAs. (@mboersma)
- [be65525](https://github.com/deis/deis/commit/be655252687afe649ab3753f5f74e1cbef3f4ae9) fix versioning typo for docs (@bacongobbler)
- [3c0c887](https://github.com/deis/deis/commit/3c0c887e8ca881992c347de621fd1ee6dde94949) added documentation on the default attributes (@bacongobbler)
- [b3881d0](https://github.com/deis/deis/commit/b3881d0b6a3528a30038de0646721d22a2391fa2) pin ruby to 2.0.0 (@bacongobbler)
- [#634](https://github.com/deis/deis/pull/634) Merge pull request #634 from opdemand/cookbook-docs (@opdemand)
- [02d2d1e](https://github.com/deis/deis/commit/02d2d1e2728b35d2f4e9758463467f7536a118ea) added rsyslog export documentation (@bacongobbler)
- [0ba71d0](https://github.com/deis/deis/commit/0ba71d09c71c364f30e2e3a8231e0aa2a3e88a63) Updated docs_requirements.txt, fixed warnings and api.admin docs. (@mboersma)
- [542f6d2](https://github.com/deis/deis/commit/542f6d2c8255d7f7d10b283a8ed93d5bc851c6ff) changed title to "Manage the Controller" (@bacongobbler)
- [#637](https://github.com/deis/deis/pull/637) Merge pull request #637 from opdemand/sphinx-cleanup (@opdemand)
- [#636](https://github.com/deis/deis/pull/636) Merge pull request #636 from opdemand/rsyslog-docs (@opdemand)
- [1de1ea2](https://github.com/deis/deis/commit/1de1ea222d9e28abb6ca65484bf7dea3126c43a5) Updated submodule SHAs. (@mboersma)
- [4163ef6](https://github.com/deis/deis/commit/4163ef6ac2099bf987370040210fe5963cd0538b) Updated CLI binary locations in README.rst. (@mboersma)

### v0.5.1 (2014/03/07 19:26 +00:00)
- [2df6f9a](https://github.com/deis/deis/commit/2df6f9ac1b3d5d415f69ac190747cbbc0d185577) Switch master to v0.5.1. (@mboersma)
- [58e007e](https://github.com/deis/deis/commit/58e007e969387c1e9b3d238b3f1b285732129398) Added django-guardian to docs_requirements.txt. (@mboersma)
- [6e1e2b4](https://github.com/deis/deis/commit/6e1e2b4b005b1e43fb6dde3e76fd631f59ad6d1f) Update Gemfile.lock (@mo-mughrabi)
- [#524](https://github.com/deis/deis/pull/524) Merge pull request #524 from mo-mughrabi/master (@mo-mughrabi)
- [cf79eab](https://github.com/deis/deis/commit/cf79eabb55517b925370b09c0b05300aa388e007) Added client binary support via PyInstaller, refs #472. (@mboersma)
- [6ffaeb6](https://github.com/deis/deis/commit/6ffaeb6a7727193cb4b0e6ed724dd8c2ba088274) Ease vagrant activation rule, now that port 8000 is default. (@mboersma)
- [048e389](https://github.com/deis/deis/commit/048e3899331f2bb2ce1b44a551a37a152f14a014) Removed default args from layers:update, fixes #525. (@mboersma)
- [#526](https://github.com/deis/deis/pull/526) Merge pull request #526 from opdemand/layers-update-bug-525 (@opdemand)
- [#527](https://github.com/deis/deis/pull/527) Merge pull request #527 from opdemand/pyinstaller-cli (@opdemand)
- [fc5b8b3](https://github.com/deis/deis/commit/fc5b8b3a4d558a8ebab1dccc887f86117cdf498f) Enabled Django ATOMIC_REQUESTS to map views to transactions. (@mboersma)
- [8214f74](https://github.com/deis/deis/commit/8214f748d1e1a341c41ddd3604d5ad01c5f54fcb) Clarify that gabrtv is BDFL for Deis decisions. (@mboersma)
- [#538](https://github.com/deis/deis/pull/538) Merge pull request #538 from opdemand/bdfl-notice (@opdemand)
- [b8bd170](https://github.com/deis/deis/commit/b8bd170054ee29a66bcb8969ac366a291f67cc07) change in name of prepare script. (@paulczar)
- [#539](https://github.com/deis/deis/pull/539) Merge pull request #539 from paulczar/patch-1 (@paulczar)
- [d82905d](https://github.com/deis/deis/commit/d82905d7035508cf8edf7d98f927d2573702e598) Updated chef-docker to 0.31.0. (@mboersma)
- [7f3685c](https://github.com/deis/deis/commit/7f3685c35e322446eacffaeb49a2b548fe2f44da) Updated deis/builder to v0.1.1. (@mboersma)
- [#537](https://github.com/deis/deis/pull/537) Merge pull request #537 from opdemand/474-atomic-requests (@opdemand)
- [6c902a6](https://github.com/deis/deis/commit/6c902a6cd53939b78036428ca6d2d65cfa3d9b9c) Revert ATOMIC_REQUESTS, fixes #541. (@mboersma)
- [9632606](https://github.com/deis/deis/commit/9632606b7c545eb882c95225e2aec5d8b56949ac) Adding port 8000 to the EC2 security group (@fagiani)
- [c1e23d5](https://github.com/deis/deis/commit/c1e23d554ccd5a202af879e5072cbbd525823fe1) `deis destroy` removes git remote only if it matches app, fixes #544. (@mboersma)
- [#545](https://github.com/deis/deis/pull/545) Merge pull request #545 from fagiani/master (@fagiani)
- [3ffc956](https://github.com/deis/deis/commit/3ffc95673c411ac4893eac8b0619b1ff7593f5c6) fix some inconstancies within the rackspace contrib instructions (@davidcollom)
- [#546](https://github.com/deis/deis/pull/546) Merge pull request #546 from davidcollom/rackspace_contrib (@davidcollom)
- [0abf453](https://github.com/deis/deis/commit/0abf4536034da03c2afaada83b34764c8aa6a646) Updated controller prep scripts to cache current Docker images. (@mboersma)
- [b8bf42b](https://github.com/deis/deis/commit/b8bf42b07f490780e4a003c037c45e6937301205) Added registry port 5000 to EC2 provisioning script, refs #550. (@mboersma)
- [be69e78](https://github.com/deis/deis/commit/be69e781f3b38465b4d419e5b89505f99adddb8c) Noted how to build CLI binaries for a release, fixes #472. (@mboersma)
- [#557](https://github.com/deis/deis/pull/557) Merge pull request #557 from opdemand/472-cli-binaries (@opdemand)
- [96b9074](https://github.com/deis/deis/commit/96b9074233a729a39cfc2918ec9ef638c9145c99) Updated deis-cookbook SHA. (@mboersma)
- [8912540](https://github.com/deis/deis/commit/89125404ea709d4c78cba84c96ee379ee5e4f28a) Removed 'converging formation' section, fixes #432. (@mboersma)
- [0cec11d](https://github.com/deis/deis/commit/0cec11d852e7e6980cab0ff20acc42d41a17c74f) Add knife params support to EC2 controller provisioner (@TiuTalk)
- [#559](https://github.com/deis/deis/pull/559) Merge pull request #559 from espnbr/feature/add-knife-params-support-to-ec2 (@espnbr)
- [67f9d78](https://github.com/deis/deis/commit/67f9d7884e7ed18879dca43a0f10ec0fffe1ccdb) Updated container submodules and cookbook SHA. (@mboersma)
- [f145a1f](https://github.com/deis/deis/commit/f145a1f3a323da700e3138ac56e4c9846fbd8594) Updated docker tags in image prep scripts. (@mboersma)
- [71779a2](https://github.com/deis/deis/commit/71779a25e94480589e485d75596a01db1d157372) Removed docker tags now that we're back to trusted builds. (@mboersma)
- [#566](https://github.com/deis/deis/pull/566) Merge pull request #566 from opdemand/remove-docker-tags (@opdemand)
- [7cbfc5d](https://github.com/deis/deis/commit/7cbfc5d60f98304041a601932ceca136134b04ff) Allow controller to run behind an SSL termination proxy (@jwilder)
- [85928c3](https://github.com/deis/deis/commit/85928c376384a63375b729ded0a39e37289f29a8) Updated EC2 AMIs for v0.5.1, fixes #567. (@mboersma)
- [#571](https://github.com/deis/deis/pull/571) Merge pull request #571 from opdemand/567-time-to-make-the-amis (@opdemand)
- [#570](https://github.com/deis/deis/pull/570) Merge pull request #570 from jwilder/jw-ec2-ssl (@jwilder)
- [91f1687](https://github.com/deis/deis/commit/91f1687b4c492a31f9988a296f64c2222fb9c1a2) Added comment about HTTPS proxy setting. (@mboersma)
- [f67bdee](https://github.com/deis/deis/commit/f67bdee07f18c36f1b4095ed58a6e626c7559c16) Updated Sphinx to v1.2.2. (@mboersma)
- [0171cc5](https://github.com/deis/deis/commit/0171cc5a04c98694903af24a6cdfd810dde2b026) Updated release procedure doc for upcoming v0.5.1. (@mboersma)
- [14bbd55](https://github.com/deis/deis/commit/14bbd5516e703ec3927bd2da1bdbc35689390201) removed provision-controller.sh (@bacongobbler)
- [#572](https://github.com/deis/deis/pull/572) Merge pull request #572 from opdemand/update-releases-doc (@opdemand)
- [#574](https://github.com/deis/deis/pull/574) Merge pull request #574 from opdemand/remove-provision-script (@opdemand)
- [5917999](https://github.com/deis/deis/commit/5917999e0552699f08d92469d29b2e66a2d62d40) Added missing DigitalOcean cloud regions. (@mboersma)
- [87096ec](https://github.com/deis/deis/commit/87096ecde1da0a53fba15e1e085b01f86001ac57) Always use :latest tag for Deis docker images. (@mboersma)
- [605e274](https://github.com/deis/deis/commit/605e274aaf1ab93194673123235a1cac4c67b076) Added :latest tag to slugrunner image pulls. (@mboersma)
- [#576](https://github.com/deis/deis/pull/576) Merge pull request #576 from opdemand/docker-tag-latest (@opdemand)
- [#575](https://github.com/deis/deis/pull/575) Merge pull request #575 from opdemand/digitalocean-regions (@opdemand)
- [31693ee](https://github.com/deis/deis/commit/31693ee3abaa249a324635fa3d74398905efe341) Updated submodules to match :latest tags. (@mboersma)
- [63954fc](https://github.com/deis/deis/commit/63954fcc843c95cf017193a0d75302c4fddc3126) Revert "removed provision-controller.sh" (@bacongobbler)
- [#579](https://github.com/deis/deis/pull/579) Merge pull request #579 from opdemand/remove-provision-script (@opdemand)
- [5b95c59](https://github.com/deis/deis/commit/5b95c5951f373926bf8852b4d16422c7a671c79e) Changes to Vagrant provisioner and environment to accomodate new (@tombh)
- [#528](https://github.com/deis/deis/pull/528) Merge pull request #528 from tombh/vagrant-provisioning (@tombh)
- [5083540](https://github.com/deis/deis/commit/508354092783f8eb85519d48a012e3dd9bb70263) fix merge comments from #528 (@bacongobbler)
- [#580](https://github.com/deis/deis/pull/580) Merge pull request #580 from opdemand/merge-fixes-from-528 (@opdemand)
- [bfaea45](https://github.com/deis/deis/commit/bfaea459c7a7644154e67e8fb77e33e0f2706940) change box_url to be the same as controller (@bacongobbler)
- [c9d6be0](https://github.com/deis/deis/commit/c9d6be0c470584dc19de4a158f190fba6f32fb16) change box name to deis-controller for consistency (@bacongobbler)
- [2814cce](https://github.com/deis/deis/commit/2814cce319fe54a408acc3beea0cd61919bd7c55) s/controller/server/g for consistency (@bacongobbler)
- [90dc2d8](https://github.com/deis/deis/commit/90dc2d81c34cf333409cdf9469426a1d3b9dc747) change default box_url. Fixes #581 (@bacongobbler)
- [#582](https://github.com/deis/deis/pull/582) Merge pull request #582 from opdemand/change-vagrantfile-template-url (@opdemand)
- [1a89091](https://github.com/deis/deis/commit/1a89091b05c78342b4c83ceb5d272060b8a14eb6) Updated EC2 AMIs from prep scripts. (@mboersma)
- [50193e8](https://github.com/deis/deis/commit/50193e892683c68d01b583e27d2271451a8cb1b0) Updated Chef references to 11.8.2. (@mboersma)
- [#584](https://github.com/deis/deis/pull/584) Merge pull request #584 from opdemand/chef-up (@opdemand)
- [#583](https://github.com/deis/deis/pull/583) Merge pull request #583 from opdemand/new-amis (@opdemand)
- [a2c194e](https://github.com/deis/deis/commit/a2c194e195dd9d8eba47b796d66b877a4c8d5235) fix buff-extensions downgrading (@bacongobbler)
- [#585](https://github.com/deis/deis/pull/585) Merge pull request #585 from opdemand/fix-buff-extensions (@opdemand)
- [aa25034](https://github.com/deis/deis/commit/aa25034cc707e06dd84e63417f46d60c55e8519a) Updated submodule SHAs. (@mboersma)
- [b1a8e14](https://github.com/deis/deis/commit/b1a8e14d1f08e542aa728de62694217df118c511) update DO readme to match correct script name (@davidcollom)
- [9cc0740](https://github.com/deis/deis/commit/9cc07409dd07c523ca7efb451cb819a9f042e5e0) be a little more explicit with the creation of snapshots (@davidcollom)
- [#588](https://github.com/deis/deis/pull/588) Merge pull request #588 from davidcollom/patch-1 (@davidcollom)
- [36a55b9](https://github.com/deis/deis/commit/36a55b91937812c95134887da524af61a1944dd5) pin knife-rackspace to 0.9.0 or higher (@bacongobbler)
- [43b170f](https://github.com/deis/deis/commit/43b170f234e6566f7807cbf41608bc9845095b23) Adds private networking for Digital Ocean (@Milodv)
- [66c93bc](https://github.com/deis/deis/commit/66c93bc0f0a672ad4a3264da8416050f227c3e5c) Updates dop version to support private networking and scrubbing (@Milodv)
- [ad784b7](https://github.com/deis/deis/commit/ad784b761a708b95e603f14c32533032d7bbc373) Updated deis-cookbook SHA to match master. (@mboersma)
- [9f7c761](https://github.com/deis/deis/commit/9f7c76131446221da974d96ed622a5e2d5d666d7) Fixed a typo in vagrant provisioning script. (@mboersma)
- [e7ad308](https://github.com/deis/deis/commit/e7ad308fe45fd0b2a11f395867c03e570aef5cfa) Use sudo to create symlink to dsh. #596 (@tombh)
- [723f985](https://github.com/deis/deis/commit/723f9852cc914cbade6b075d0ed3e2f527088e6c) added install script for avahi (@bacongobbler)
- [6c57c76](https://github.com/deis/deis/commit/6c57c7696032c51e826bf96396dd2d0cba453081) add avahi to other inline script instead (@bacongobbler)
- [85f8c1e](https://github.com/deis/deis/commit/85f8c1e5ed469a05427ac52ba9e25b467c3b7d95) make small improvements to the rackspace script (@bacongobbler)
- [#600](https://github.com/deis/deis/pull/600) Merge pull request #600 from opdemand/vagrant-avahi (@opdemand)
- [a54538a](https://github.com/deis/deis/commit/a54538a9667c6aa9d0598c61698bd33665311e61) remove redundant prepare script (@bacongobbler)
- [1350307](https://github.com/deis/deis/commit/135030730e3120ccf5fc911b032e7c5d6e3b3edd) use standardized format for naming nodes/layers (@bacongobbler)
- [b432280](https://github.com/deis/deis/commit/b432280b810e5752d4221ae790475f7be2335bca) append node id to end of name (@bacongobbler)
- [7de5caf](https://github.com/deis/deis/commit/7de5caf88ec03ecd17855871beec0ac51bcc3484) renamed prepare script (@bacongobbler)
- [9019f0d](https://github.com/deis/deis/commit/9019f0d526b0e537c93ada7b230707f9b80f0fb8) added nova client fo uploading SSH keys (@bacongobbler)
- [80e6a02](https://github.com/deis/deis/commit/80e6a028261cfd80d8147736fd2291e1945cd980) update Rackspace readme docs (@bacongobbler)
- [a5d8c05](https://github.com/deis/deis/commit/a5d8c0533094ab24315393851535dea7628953d1) bash script should source rackspacerc (@bacongobbler)
- [c6d4e43](https://github.com/deis/deis/commit/c6d4e4387e123343713c831f36806dee4d11dbfd) update prepare script reference (@bacongobbler)
- [eddea17](https://github.com/deis/deis/commit/eddea1702d35cd38436cc668e8b83c696da8cf11) make small improvements to the rackspace script (@bacongobbler)
- [cc805ee](https://github.com/deis/deis/commit/cc805ee8a592ebec331beb19ebbc42a7c33a9309) pin knife-rackspace to 0.9.0 or higher (@bacongobbler)
- [eed52c7](https://github.com/deis/deis/commit/eed52c70e34d4e8330856e93be0f1b18bee161f2) use standardized format for naming nodes/layers (@bacongobbler)
- [336d967](https://github.com/deis/deis/commit/336d967d3afb55c27a3df249a4cc111e3082cbfd) bash script should source rackspacerc (@bacongobbler)
- [196f996](https://github.com/deis/deis/commit/196f996bdb3bf534d52113a2c01372831c15a11d) added nova client fo uploading SSH keys (@bacongobbler)
- [f51eea3](https://github.com/deis/deis/commit/f51eea39f42f22c4c830f1287eb5c3e5a9947e1e) update prepare script reference (@bacongobbler)
- [145f7a2](https://github.com/deis/deis/commit/145f7a226aa80b3a2328b53692e8d3f8449cecba) append node id to end of name (@bacongobbler)
- [e31d9bd](https://github.com/deis/deis/commit/e31d9bd708d6fe7ba6632b4e83d7f85aeb956863) renamed prepare script (@bacongobbler)
- [7df9fcb](https://github.com/deis/deis/commit/7df9fcb5986cb40959b968aa215c7ffd939a0cf9) update Rackspace readme docs (@bacongobbler)
- [239ea2f](https://github.com/deis/deis/commit/239ea2fdbce2bce18564df266dd663e8e319ea19) remove redundant prepare script (@bacongobbler)
- [1e8395d](https://github.com/deis/deis/commit/1e8395de9511caa017f7e97d96221c85ab7dc24a) Merge branch 'fix-rackspace-provider' of github.com:opdemand/deis into fix-rackspace-provider (@bacongobbler)
- [3cea2ce](https://github.com/deis/deis/commit/3cea2cec985616b21cecfa934bc1095e7182aeea) Added description for releases:rollback. (@mboersma)
- [e3ab738](https://github.com/deis/deis/commit/e3ab73817dd4072fd28133e080229885a4d7df9a) Updated SHA to match deis-cookbook. (@mboersma)

### v0.5.0 (2014/02/13 04:18 +00:00)
- [d2e307d](https://github.com/deis/deis/commit/d2e307d4529d063a8dd2d6cb715701393e569f45) Switch master to v0.5.0. (@mboersma)
- [#503](https://github.com/deis/deis/pull/503) Merge pull request #503 from tombh/493-vagrant-detection (@tombh)
- [9885226](https://github.com/deis/deis/commit/9885226bfecdcbdcacd754597674fc4f4e1116af) rename gitignore to gitkeep
- [03bbaa1](https://github.com/deis/deis/commit/03bbaa1f69f99e99f6755f76b6c62456db45f7a5) Added containerize branch to Travis CI. (@mboersma)
- [#505](https://github.com/deis/deis/pull/505) Merge pull request #505 from opdemand/rename-gitignore (@opdemand)
- [0f83f6a](https://github.com/deis/deis/commit/0f83f6a995ff6df15819977ad87506c327983de2) Updated Django to v1.6.2. (@mboersma)
- [b85954d](https://github.com/deis/deis/commit/b85954d4ece060cba7d9b932d9255b92ae2ab3ff) Fixed build status badge to refer to master branch. (@mboersma)
- [98296b7](https://github.com/deis/deis/commit/98296b72540c5c0a82ee40b0aa9bd7e005fb833f) add dynamic confd settings lookup (with local_settings override) (@gabrtv)
- [3dfe59c](https://github.com/deis/deis/commit/3dfe59cbe6b575810fc715d29ac79618cecef724) install etcd gem prior to chef run, cleanup cruft (@gabrtv)
- [b8a5518](https://github.com/deis/deis/commit/b8a5518efeb693a686b9fa7b0e572fe981159d22) shift ssh:// to https:// for read-only access (@gabrtv)
- [37a3fe6](https://github.com/deis/deis/commit/37a3fe6928f38f5f90a4eef24e6d8073f4ed592d) bump docker images (@gabrtv)
- [2acdd2a](https://github.com/deis/deis/commit/2acdd2aaeec216c2fbf39befb2ff6caad04a475a) new hooks API for push/build, deprecate Build.push() (@gabrtv)
- [323af3b](https://github.com/deis/deis/commit/323af3b355339ddff2e9a49fc92c46ae16e192e1) update image SHAs (@gabrtv)
- [17aaac7](https://github.com/deis/deis/commit/17aaac7358dcd684823dc110a4f0e24e474682ac) remove builder debug (@gabrtv)
- [15a71a8](https://github.com/deis/deis/commit/15a71a803291cc97383116be71568fe72343311c) handle builder target that contains a port (@gabrtv)
- [5af0968](https://github.com/deis/deis/commit/5af0968ce71fea52d9539a08eeb903d0c83ec86e) stop using sudo in chef setup (@gabrtv)
- [b2858fe](https://github.com/deis/deis/commit/b2858fea970bb9bc9dda6694bcf08711f44527c8) switch from rabbitmq to redis, install gunicorn app for run_gunicorn support (@gabrtv)
- [1b1875b](https://github.com/deis/deis/commit/1b1875b8effc62dd4fc9223a849f3774814b47a5) new redis 2.8 dependency (@gabrtv)
- [fd9bbcf](https://github.com/deis/deis/commit/fd9bbcfbcb3d051cb865cc5d82f8d0230b8da257) ignore import errors on local_settings (@gabrtv)
- [b98e4d8](https://github.com/deis/deis/commit/b98e4d8b988ed22b8ef4c07cf645adee4b43d4bb) new vagrantfile for container-based deployment (@gabrtv)
- [0331f51](https://github.com/deis/deis/commit/0331f51677ab089b36e09139b849181b6bed0e51) initial pass at architecture docs (@gabrtv)
- [81c9ca4](https://github.com/deis/deis/commit/81c9ca4bb85b0774ce739d9452a66f259763e1ae) add docker images as submodules (@gabrtv)
- [f5312c5](https://github.com/deis/deis/commit/f5312c58ef7ae197955fe4d49d8cbc0eb7b57bc1) switch git remote to ssh:// syntax with 2222/tcp (@gabrtv)
- [d42cee2](https://github.com/deis/deis/commit/d42cee226058568dbd982f2fbc11037b21e76d44) change vagrant base box to vanilla ubuntu 12.04 w/ 3.8 kernel (@gabrtv)
- [b467998](https://github.com/deis/deis/commit/b4679982b614e22efde21734bd520587836e5021) fix vagrant provider in containerized env by using ip_addr instead of avahi hostnames (@gabrtv)
- [c1f4dc5](https://github.com/deis/deis/commit/c1f4dc524c4596d4bd91facc12fad4c5abce295b) pre-install required etcd gem before knife bootstrap using template-file option (@gabrtv)
- [b6c4451](https://github.com/deis/deis/commit/b6c4451ca21824b6b03d1ed38921eefa32188171) change run to use build.image instead of a slug mount (@gabrtv)
- [9bdba6c](https://github.com/deis/deis/commit/9bdba6ccb8533e6bfe230385fe09904f56f21f46) deprecate converge_controller (@gabrtv)
- [bd31773](https://github.com/deis/deis/commit/bd31773dc2faf7f2e35b16aa6de31c1223419bcf) update container SHAs (@gabrtv)
- [5a1eb0b](https://github.com/deis/deis/commit/5a1eb0beccc9dfb3884a48b1f2920f41596302fe) add rsyslog logger component (@gabrtv)
- [ae37b11](https://github.com/deis/deis/commit/ae37b11105f62d24b8ea435ded752ddd095e0df8) add vagrant authorized-keys setup script (@gabrtv)
- [b33775f](https://github.com/deis/deis/commit/b33775f3d87f937f14ba8cddd2ba8ff4f725c544) switch to containerized cookbooks branch (@gabrtv)
- [af2785a](https://github.com/deis/deis/commit/af2785af9da3ae20f5a4a79b99f03961d45d5b0b) remove knife template for etcd gem at load-time (@gabrtv)
- [bd89618](https://github.com/deis/deis/commit/bd8961843c8ecdfd88b3ed24051d5408df18a731) add dev mode/source flags to Vagrantfile (@gabrtv)
- [eca3d9f](https://github.com/deis/deis/commit/eca3d9fcde4db6ce8adc4c879811c0ebbf0b2bf8) separate controller/node ec2 ami prep (@gabrtv)
- [bd2ba0a](https://github.com/deis/deis/commit/bd2ba0ad9ebdb450a98c35e5d399e8f985f8f2ab) publish SSH Keys to etcd instead of a chef data bag (@gabrtv)
- [405245b](https://github.com/deis/deis/commit/405245b749dfe5033c5f886c194cb4044b6c949b) deprecate deis-users databag (@gabrtv)
- [4edac55](https://github.com/deis/deis/commit/4edac55531433363ec0a09e498e31f8d6a52442b) update docker image SHAs (@gabrtv)
- [56c28e1](https://github.com/deis/deis/commit/56c28e18461311208e9cb5eca135c17f89a065ff) Updated DigitalOcean scripts for containerize support. (@mboersma)
- [08fd115](https://github.com/deis/deis/commit/08fd115562aa83fb3a05852c956c77af0adc4089) Fixed flake8 errors. (@mboersma)
- [cf4f174](https://github.com/deis/deis/commit/cf4f174dabc8a632512cc00f1a8209ebb93f1b7b) Updated Rackspace scripts for containerize support. (@mboersma)
- [c82b8fb](https://github.com/deis/deis/commit/c82b8fb7908f8edb53cb04be55153976036df336) update build and server images (@gabrtv)
- [3913498](https://github.com/deis/deis/commit/391349860d2de18ad44b1a1c8216f8e776c1b3fc) return app info on build hook (@gabrtv)
- [c7251a7](https://github.com/deis/deis/commit/c7251a73754038d018e1ea94d5db6101c112cad0) spaces > tabs (@gabrtv)
- [ae23502](https://github.com/deis/deis/commit/ae235021705434571893f91eff8a217ec63cc218) fix `deis run` target image (@gabrtv)
- [a3c2124](https://github.com/deis/deis/commit/a3c212426b543e19dc4a2c81bc32686585cd8a0a) update registry and server images (@gabrtv)
- [1b7e1f3](https://github.com/deis/deis/commit/1b7e1f3c7d25095ce20d91a8521db2ea570c2b44) publish every release as a tagged docker image (ex: gabrtv/myapp:v23) (@gabrtv)
- [8afa178](https://github.com/deis/deis/commit/8afa178973173fff468ed05755d6e95dd163b3fc) update server image w/ missing logs directory (@gabrtv)
- [daafe17](https://github.com/deis/deis/commit/daafe175e47594044567a4cf4357ce853cd1aaca) upgrade to chef-docker 0.28.0 for new :pull behavior (@gabrtv)
- [27f483c](https://github.com/deis/deis/commit/27f483ce13fb080ac27ec30b1725616ce9635e57) Added containerize branch to Travis CI. (@mboersma)
- [b40aa2a](https://github.com/deis/deis/commit/b40aa2a5a9a973d16b5ce486f8057c9c969eed0e) remove dupe release, fix rollback publishing (@gabrtv)
- [27c1efe](https://github.com/deis/deis/commit/27c1efe698a3a42c190b29e1f30fb7389f28f613) include sha on every git push event (@gabrtv)
- [1427d75](https://github.com/deis/deis/commit/1427d755d77ec666d08e94ec12a17c8e3483aaa3) Updated SHA for deis-cookbook containerize branch. (@mboersma)
- [89e649e](https://github.com/deis/deis/commit/89e649edb9185362957418d67b4bae950e72d083) Updated Django to v1.6.2. (@mboersma)
- [0fb67df](https://github.com/deis/deis/commit/0fb67df19df13cf50687d1bdedd68289c54ee911) Updated requirements files and deis/server SHA. (@mboersma)
- [2a5439e](https://github.com/deis/deis/commit/2a5439e40c01b4fc7327877ab053c1fc38808971) Added static file serving WSGI app, fixes #507. (@mboersma)
- [2693349](https://github.com/deis/deis/commit/2693349d3181cdbbbf6ff0c843cd6599c5dd86c9) rename submodules to match container names (@gabrtv)
- [31d455f](https://github.com/deis/deis/commit/31d455f831ae1aaf58d4bb9e1dca4080bb913509) update server/worker SHAs (@gabrtv)
- [ef0dcff](https://github.com/deis/deis/commit/ef0dcff5db61804fafe6ebe12ca996937150e1a6) Removed references to gitosis. (@mboersma)
- [008042b](https://github.com/deis/deis/commit/008042b728eb70294f1c2f8c881a5b827d4cfbcf) added vagrant plugin commands
- [29733f7](https://github.com/deis/deis/commit/29733f7e49d029be83b1917bb421237fcd7ed5aa) remove tab in vagrantfile
- [0f2b688](https://github.com/deis/deis/commit/0f2b68863e1cbaff1b3278dc6f363b3aaea49150) Removed references to obsolete deis-users data bag. (@mboersma)
- [b5a55c5](https://github.com/deis/deis/commit/b5a55c54b305150da58719a3a36787f131193aa5) new images (@gabrtv)
- [4e94fce](https://github.com/deis/deis/commit/4e94fce119fa02e76f2db3b8989c46d3c7280a39) Updated SHAs for submodules and cookbook. (@mboersma)
- [b5afa5a](https://github.com/deis/deis/commit/b5afa5a230e2baf38013bacbc1ffce39d00e1edb) Dockerfile support no longer 'coming soon'. (@mboersma)
- [c5ea9b2](https://github.com/deis/deis/commit/c5ea9b28200b15d751cdb2fd26f632e6f9cdadbe) Updated SHAs to latest deis projects. (@mboersma)
- [4fbe908](https://github.com/deis/deis/commit/4fbe908a46d26cc27bafd7a41194743193577cb7) assert flavor count is > 0 (@gabrtv)
- [9f0ad15](https://github.com/deis/deis/commit/9f0ad156cbaf26d2ebaea5fa476ef7d72847f0b3) remove deprecated key CM test (@gabrtv)
- [99b236a](https://github.com/deis/deis/commit/99b236ac606abe653adc105ce25495a5b979aa7f) defaut to sqlite3 if not defined (@gabrtv)
- [2c923fd](https://github.com/deis/deis/commit/2c923fd9faecbc392994cc621459833c088f52ac) move PROVIDER_MODULES into component images (@gabrtv)
- [c942eec](https://github.com/deis/deis/commit/c942eec4e7500f1b76fe2cdb9c7d8af678fe8d24) fix hook tests and import into test runner (@gabrtv)
- [b14246b](https://github.com/deis/deis/commit/b14246ba34f72f321faae939b660a00329421dfc) rename default database to deis.db (@gabrtv)
- [795bf9d](https://github.com/deis/deis/commit/795bf9d753378b771dbd92b846d4ec34a911fb28) add test for ssh key fingerprinting (@gabrtv)
- [129a381](https://github.com/deis/deis/commit/129a381fd9ec01780e77ae99c59abe070275da29) exclude osx system libs and docker registry integration from coverage (@gabrtv)
- [859646f](https://github.com/deis/deis/commit/859646f9bff344fedf78892b0ed301f2f6fbba3f) flake8 fixes (@gabrtv)
- [78c7696](https://github.com/deis/deis/commit/78c76967ddc20fb0cfec61e0833699957c028c89) update server and worker w/ v0.5.0 tag (@gabrtv)
- [#522](https://github.com/deis/deis/pull/522) Merge pull request #522 from opdemand/containerize (@opdemand)
- [1b7033c](https://github.com/deis/deis/commit/1b7033c2362b6322f4e7ff4f1f895d16917fc098) Fixed merge remnant in Berksfile.lock. (@mboersma)
- [bbe2ea9](https://github.com/deis/deis/commit/bbe2ea930173fc3b1d231cb7089dc264c4f5dd9a) Updated deis-cookbook SHA. (@mboersma)
- [58c0429](https://github.com/deis/deis/commit/58c042955d8fa4a8a6688b80792b3e2d3647bc15) re-target Berksfile to deis-cookbook master, update other cookbooks (@gabrtv)
- [9cacbac](https://github.com/deis/deis/commit/9cacbac5b3bccf83a9c7b42c7dd7a6bfe6b93c91) Updated image prep scripts. (@mboersma)

### v0.4.1 (2014/02/04 16:42 +00:00)
- [44a73c3](https://github.com/deis/deis/commit/44a73c38a7ab40ffb883fcdf0bd8d804a2dae640) Fixed required libs in setup.py to use newer install_requires. (@mboersma)
- [36b6a9c](https://github.com/deis/deis/commit/36b6a9c3bb691693c7a6069b9569cb5ae8b32300) Switch master to v0.4.1. (@mboersma)
- [bba5f3d](https://github.com/deis/deis/commit/bba5f3d1111a4e64f40dca4d075118dfb0140bae) Updated djangorestframework to 2.3.12 security fix. (@mboersma)
- [0317227](https://github.com/deis/deis/commit/031722771ea810f80e78dc247b6823f5c3eee3f0) Updated Docker to v0.7.6. (@mboersma)
- [#463](https://github.com/deis/deis/pull/463) Merge pull request #463 from opdemand/docker-0.7.6 (@opdemand)
- [86e8268](https://github.com/deis/deis/commit/86e826802eb26877b8d4387fe379672759801315) Show the list of config variables sorted by name (@nathansamson)
- [6572323](https://github.com/deis/deis/commit/657232350be6a2be45acac369e5da66cf6be69e0) Tabularize config output (@nathansamson)
- [7419a54](https://github.com/deis/deis/commit/7419a54527980b1466782d4095277650b9f7e815) Add a --oneline option to config:list (@nathansamson)
- [#469](https://github.com/deis/deis/pull/469) Merge pull request #469 from nathansamson/nathan/client-config-improvements (@nathansamson)
- [ccbf33d](https://github.com/deis/deis/commit/ccbf33dc9c94b934bc0ef9cccba1fcb873e59362) significant typo ("no" -> "yes") (@jfw)
- [0ba9ed1](https://github.com/deis/deis/commit/0ba9ed1bdb726cdc8ca03c3ff6c2f28b4ca61a18) Allow the provision-controller.sh script to run in a directory with spaces (@nathansamson)
- [#471](https://github.com/deis/deis/pull/471) Merge pull request #471 from nathansamson/nathan/vagrant-space-fix (@nathansamson)
- [#470](https://github.com/deis/deis/pull/470) Merge pull request #470 from jfw/patch-1 (@jfw)
- [fdb1b30](https://github.com/deis/deis/commit/fdb1b30c0e3b8ed29a10cb5a4df4b1ce54a7e3c3) Fix another space-in-path issue in vagrant provisioner (@nathansamson)
- [410ebac](https://github.com/deis/deis/commit/410ebac516277b0c6a82967d77470623088833a6) Fix spaces-in-path issues for DigitalOcean contrib scripts. (@nathansamson)
- [8201066](https://github.com/deis/deis/commit/8201066250ec05a568ffee229d1cce3c745508d3) Fix EC2 provision script (space in path issue) (@nathansamson)
- [21ac978](https://github.com/deis/deis/commit/21ac978bcdab66681ef0882fc28e4cc9018a1e33) Fix space issue for rackspace controller (@nathansamson)
- [db9404e](https://github.com/deis/deis/commit/db9404ea3e6016f5ef79de380c43ef4e491628e1) Allow vagrant (host sytem) to run in a directory with spaces (@nathansamson)
- [5c0ddb6](https://github.com/deis/deis/commit/5c0ddb6e0690cf579fd3c4a9b1df40a6a0798249) For dev convenience, added a DB-reset script and some basic fixtures. Also attempt to deal with git-ignoring 'static' (@tombh)
- [#473](https://github.com/deis/deis/pull/473) Merge pull request #473 from nathansamson/nathan/vagrant-space-fix2 (@nathansamson)
- [#479](https://github.com/deis/deis/pull/479) Merge pull request #479 from nathansamson/vagrant-fixes (@nathansamson)
- [#483](https://github.com/deis/deis/pull/483) Merge pull request #483 from tombh/db-reset-script (@tombh)
- [bd0b0dc](https://github.com/deis/deis/commit/bd0b0dc1ac3812a8a5162e4c3aaa97ceba716054) DigitalOcean: Fix for #477 (@nathansamson)
- [#487](https://github.com/deis/deis/pull/487) Merge pull request #487 from nathansamson/nathan/477 (@nathansamson)
- [c2951f9](https://github.com/deis/deis/commit/c2951f91d19d65b415777754ab3a681b70b4c411) Showing containers for the correct app when running scale --app=X. Fixes #481 (@nathansamson)
- [bbda0a6](https://github.com/deis/deis/commit/bbda0a69999673bc8789e08abc2f36786dc119ef) Allow users to patsh to enters SSH keys in the CLI client (@nathansamson)
- [0dc199f](https://github.com/deis/deis/commit/0dc199fcf16f658b3a9b4810f85ec1f30ee9803f) Correctly honor args for deis config comand (@nathansamson)
- [7af2427](https://github.com/deis/deis/commit/7af24272a4ebaa6b4b89141a1bb86c681c2e923c) Correctly honor args for deis perms comand (@nathansamson)
- [9d23b0f](https://github.com/deis/deis/commit/9d23b0f7969b3735c29adb335c2ca0351ab0e27c) Change the arg parsing for fallback :list commands according to a found example in the code (@nathansamson)
- [7f3b95f](https://github.com/deis/deis/commit/7f3b95f836bd1a3ca7246bf848c9b1d31ff512f4) change `deis run` bind-mount to read-only to prevent disruptive modification (@gabrtv)
- [#489](https://github.com/deis/deis/pull/489) Merge pull request #489 from opdemand/fix-deis-run (@opdemand)
- [93f8210](https://github.com/deis/deis/commit/93f82102af8d85ecc1e443b8fb9cef3f1bb77c59) Trick flake into decreasing keys_add CC (@nathansamson)
- [#488](https://github.com/deis/deis/pull/488) Merge pull request #488 from nathansamson/nathan/cli-improvements (@nathansamson)
- [0e768b8](https://github.com/deis/deis/commit/0e768b84682218e87a8c8f0cf39f11e554e050ee) clean up /etc/chef, install inotify-tools (@paulczar)
- [1d1c661](https://github.com/deis/deis/commit/1d1c66105441097804f32f43ba3f63d5ec0018b5) Clean up /etc/chef and install inotify-tools across all providers. (@mboersma)
- [b7751ab](https://github.com/deis/deis/commit/b7751ab212d1abf93bf245efe688772a027fa4a7) Removed deprecated pip --use-mirrors flag. (@mboersma)
- [a355a0e](https://github.com/deis/deis/commit/a355a0e487ce95ac18a81bf63fdffc8af336bd24) Updated celery, requests, Sphinx. (@mboersma)
- [d601fd8](https://github.com/deis/deis/commit/d601fd8bf2b9cbff3923efd290ea2b5fca34a008) Updated requests version in setup.py to 2.2.1. (@mboersma)
- [169627f](https://github.com/deis/deis/commit/169627f63563a595f7f062da12fa4705696927c9) Add formation, provider and flavours to fixtures for more complete seeding (@tombh)
- [#491](https://github.com/deis/deis/pull/491) Merge pull request #491 from opdemand/pypi-updates (@opdemand)
- [45aff6c](https://github.com/deis/deis/commit/45aff6ca665a11aacbbfaa1c2826a5cccd5ab0e3) Updated Berksfile.lock to latest deis-cookbook (@mboersma)
- [cf6f74f](https://github.com/deis/deis/commit/cf6f74f9efe613ba2454e52c24756851d987fd7a) Only take into account the first equal sign when setting config vars (@nathansamson)
- [42d1d0b](https://github.com/deis/deis/commit/42d1d0b11a6205dfe51208ca07922c4b29fd36e8) Updated knife-digital_ocean to v0.4.0. (@mboersma)
- [#500](https://github.com/deis/deis/pull/500) Merge pull request #500 from nathansamson/nathan/equalsinvars (@nathansamson)
- [f804ed8](https://github.com/deis/deis/commit/f804ed8323ba99a2d9d48f648089ff2c42c2ea3b) Revert bind-mounting slugs read-only. (@mboersma)
- [#502](https://github.com/deis/deis/pull/502) Merge pull request #502 from opdemand/revert-pr-489 (@opdemand)
- [#501](https://github.com/deis/deis/pull/501) Merge pull request #501 from opdemand/knife-do-update (@opdemand)
- [#494](https://github.com/deis/deis/pull/494) Merge pull request #494 from tombh/db-reset-script (@tombh)
- [4e79646](https://github.com/deis/deis/commit/4e796464c15acaddd09322ee91f0401eb350b1a3) Added detailed steps to add deis-controller to admin group (@shredder12)
- [a2ad8a0](https://github.com/deis/deis/commit/a2ad8a0651a6b2e84c1ce89350e0149dc83a0f24) Added link to Chef admins edit, admonition section. (@mboersma)
- [2d10965](https://github.com/deis/deis/commit/2d1096508fbf1f63fcd49c210e8beaadf4ee1fdf) Replace method for checking if client is in a vagrant setup. Use (@tombh)

### v0.4.0 (2014/01/14 19:19 +00:00)
- [a5731be](https://github.com/deis/deis/commit/a5731be3dcd288c854c253294a0d2e3d9a2fc767) Switch master to v0.4.0. (@mboersma)
- [e1d60b2](https://github.com/deis/deis/commit/e1d60b2e392365cf34f1d28d2fb97afb7e245c79) Restored pypip.in download badge, added license badge. (@mboersma)
- [2b4a8db](https://github.com/deis/deis/commit/2b4a8db663d053d4c4819a9f17ad84daa08df903) Added reminder to rebuild all published readthedocs versions on release. (@mboersma)
- [f22a6e5](https://github.com/deis/deis/commit/f22a6e573227f4cb0bf17801f2968471e59fe24a) Updated DigitalOcean snapshot script in line with other providers. (@mboersma)
- [ac35cd8](https://github.com/deis/deis/commit/ac35cd859ed55c6369f5df5836f32241ee40b12a) Updated boto to 2.21.2 (@mboersma)
- [75674ac](https://github.com/deis/deis/commit/75674acdd6e7e5c2c2d88ae0765aed4d4ae6bc04) Simplified IsAnonymous test. (@mboersma)
- [c1e60ee](https://github.com/deis/deis/commit/c1e60ee1008602ae50235f58eab7a10ae810d69b) Added docstrings for the decorated api.tasks module. (@mboersma)
- [9f9f861](https://github.com/deis/deis/commit/9f9f86122256225db8f29db09a69452174a0cf01) Improved CSS styling for [source] / [docs] links in documentation. (@mboersma)
- [01928c4](https://github.com/deis/deis/commit/01928c48462edb52b6aeb8cc4df20f649916f7cc) Cleaned up a few docstrings and removed dead South introspections. (@mboersma)
- [8d8daef](https://github.com/deis/deis/commit/8d8daef0ad890a21b3c6e42ee07d8fc0e9d9ea5d) Fixed #435 -- document how to use custom buildpacks in the FAQ. (@mboersma)
- [#437](https://github.com/deis/deis/pull/437) Merge pull request #437 from opdemand/more-docstrings (@opdemand)
- [ee796fe](https://github.com/deis/deis/commit/ee796fe723c4c444beca21dbf9cadccddc436e16) Updated Docker to v0.7.3. (@mboersma)
- [4646a95](https://github.com/deis/deis/commit/4646a95450a4686f12dd65b364423076c6caf1e4) Fixed typo (@joelvh)
- [#443](https://github.com/deis/deis/pull/443) Merge pull request #443 from opdemand/docker-0.7.3 (@opdemand)
- [#442](https://github.com/deis/deis/pull/442) Merge pull request #442 from joelvh/patch-1 (@joelvh)
- [#410](https://github.com/deis/deis/pull/410) Merge pull request #410 from tombh/376-move-slugbuilder-hook (@tombh)
- [a3aa6d4](https://github.com/deis/deis/commit/a3aa6d4a0787ba255ebbbc65e6c68f47c993954b) Swap steps 4 and 5 in vagrant README. Add step to use Makefile when installing deis client. (@tombh)
- [#445](https://github.com/deis/deis/pull/445) Merge pull request #445 from tombh/improve-vagrant-docs-for-niccolox (@tombh)
- [5d0deae](https://github.com/deis/deis/commit/5d0deae9f26992ef7956147a58322ddc2941de2c) Fixed #449 -- `deis releases:info` honors specified version. (@mboersma)
- [#450](https://github.com/deis/deis/pull/450) Merge pull request #450 from opdemand/449-get-release-version (@opdemand)
- [f7d887d](https://github.com/deis/deis/commit/f7d887dda25e003908ab9377ef74372a472d7e09) Added support for `deis release:rollback`, fixes #382. (@mboersma)
- [#451](https://github.com/deis/deis/pull/451) Merge pull request #451 from opdemand/382-release-rollback (@opdemand)
- [4586f61](https://github.com/deis/deis/commit/4586f61d7735a453678ec01833c3499c2eea36d1) Remove Authors from README (@gabrtv)
- [18f1810](https://github.com/deis/deis/commit/18f18108de066f45f23765808609710d3bc607d6) push implementation and tests for external builder module (@gabrtv)
- [f73b941](https://github.com/deis/deis/commit/f73b941ddef2678ca1c38a24657c1252cc7e55d4) remove providers from coveragerc, while continuing to import them (@gabrtv)
- [#453](https://github.com/deis/deis/pull/453) Merge pull request #453 from opdemand/docker-0.7.5 (@opdemand)
- [#452](https://github.com/deis/deis/pull/452) Merge pull request #452 from opdemand/external-push (@opdemand)
- [2f039e7](https://github.com/deis/deis/commit/2f039e7f4c7a20caef6257b328293e3aa8ea6e87) Fixed #383 -- Added summaries to `deis releases:list` (@mboersma)
- [263df70](https://github.com/deis/deis/commit/263df706b1a2e5ad252e0ae7ce58e9e8449bc6cb) Get returns current Config, not latest Config. Fixes #455. (@mboersma)
- [bf4de12](https://github.com/deis/deis/commit/bf4de12937044829641d0054d402ef1de9af0181) Reduce complexity in deis.py's main() by refactoring command dispatch lines (@tombh)
- [#456](https://github.com/deis/deis/pull/456) Merge pull request #456 from opdemand/455-get-config (@opdemand)
- [aa6f4c2](https://github.com/deis/deis/commit/aa6f4c24d5ec9b733f2aaf8f2b61f1e9a93f0f77) Added syslog events for app lifecycle. (@mboersma)
- [#446](https://github.com/deis/deis/pull/446) Merge pull request #446 from opdemand/383-releases-list (@opdemand)
- [#444](https://github.com/deis/deis/pull/444) Merge pull request #444 from tombh/client-feedback-for-unresponsive-controller (@tombh)
- [#457](https://github.com/deis/deis/pull/457) Merge pull request #457 from opdemand/394-app-lifecycle-events (@opdemand)
- [fe5a2c3](https://github.com/deis/deis/commit/fe5a2c3a28cce51f2c72db469d9dbb3ae205145d) Updated boto, paramiko, psycopg2, requests. (@mboersma)
- [#460](https://github.com/deis/deis/pull/460) Merge pull request #460 from opdemand/package-updates (@opdemand)
- [ad22b6c](https://github.com/deis/deis/commit/ad22b6ce8af5031db6a4bbf006d745cfadcd879e) Add the step of prepare a new image to the Rackspace contrib README (@stackedsax)
- [8d21adc](https://github.com/deis/deis/commit/8d21adc3030ed788dfb4b8e83c4efaac5cb0ac0d) upgrade the Rackspace prepare, provision, and provider scripts to use newer Rackspace performance flavors (@stackedsax)
- [6a32c8e](https://github.com/deis/deis/commit/6a32c8e078159f1ae07287245ef9bc9286e359da) Make the instructions simpler and clearer on how to run the prepare-rackspace-image.sh script.  Run from curl | bash (@stackedsax)
- [0e5312a](https://github.com/deis/deis/commit/0e5312a310eebe7d694ba55176cac7ebe6463995) Add a note to direct people to the old OpsCode control panel to add deis-controller to the admins group. (@stackedsax)
- [c1721ac](https://github.com/deis/deis/commit/c1721ac6425121d76894a7795056c9c5c54cf04f) Fixed test_auth after Rackspace changes removed one default flavor. (@mboersma)
- [4ca1c43](https://github.com/deis/deis/commit/4ca1c43e25e4830f207d7439adfd50a348973f56) Updated EC2 AMIs for v0.4.0, fixes #458 (@mboersma)

### v0.3.1 (2013/12/31 16:09 +00:00)
- [82a4799](https://github.com/deis/deis/commit/82a4799f21561301c8058a36cd7fc09514f9b245) Switch master to v0.3.1 (@mboersma)
- [78efe2c](https://github.com/deis/deis/commit/78efe2c210435615288a1a8a0d3c05aa9f80c913) Make $node_name unique to avoid deleting wrong droplet on failed provision (@tombh)
- [c91da1b](https://github.com/deis/deis/commit/c91da1b1bcf63ee44f6d902d488137fe7473210b) Removed .gitignore entry that prevented adding static assets. (@mboersma)
- [12ab065](https://github.com/deis/deis/commit/12ab0650c6aeb26dc7940f96c9f52727e829a344) Updated docs styling to avoid theme breakage on mobile devices (@bengrunfeld)
- [57d7a50](https://github.com/deis/deis/commit/57d7a50db257e0e890aed0d36d5375e23b9ede47) Added navigation elements for docset versions. Refs #256. (@mboersma)
- [#393](https://github.com/deis/deis/pull/393) Merge pull request #393 from opdemand/rtfd (@opdemand)
- [0bfba55](https://github.com/deis/deis/commit/0bfba55d9252968cb47ddd405d0cf54693db807c) Updated to Django 1.6.1. (@mboersma)
- [#395](https://github.com/deis/deis/pull/395) Merge pull request #395 from opdemand/django-1.6.1 (@opdemand)
- [3a627ed](https://github.com/deis/deis/commit/3a627ed8b4eb54c7567c7cf7b748017edbf0cdd0) Added Bing Webmaster Tools validation token (@bengrunfeld)
- [#392](https://github.com/deis/deis/pull/392) Merge pull request #392 from tombh/digital-ocean-provision-error-tolerance (@tombh)
- [6bd1fc1](https://github.com/deis/deis/commit/6bd1fc1c0006b3d96fa880ef05242d9cf217b170) Tweak tr command to work on OSX. Chef object deletion should use $node_name. opdemand/deis#396 (@tombh)
- [#401](https://github.com/deis/deis/pull/401) Merge pull request #401 from tombh/digital-ocean-provision-error-tolerance (@tombh)
- [c6d986a](https://github.com/deis/deis/commit/c6d986acdacf7ed527323f6fe7f4454fcc47911b) Moved slugbuilder from cookbook to deis. opdemand/deis#376 (@tombh)
- [f581767](https://github.com/deis/deis/commit/f5817672b2e64d01c25a291e3e1c5ef0ec690b3a) When checking the error type from a failed vagrant desutrcution, make comparison case insensitve - for BASH and ZSH support. opdemand/deis#346 (@tombh)
- [953e329](https://github.com/deis/deis/commit/953e3290d9fc65de330418b50bd67aa9afb9305b) Change Installation link to Operations Guide (@gabrtv)
- [#407](https://github.com/deis/deis/pull/407) Merge pull request #407 from tombh/346-node-del-check-case-insensitive (@tombh)
- [a3ac632](https://github.com/deis/deis/commit/a3ac6327ca7c24560128267dcd344164b3a78704) Updated several python packages. (@mboersma)
- [8e17497](https://github.com/deis/deis/commit/8e1749770025bf5ecd94481f68d80251249dd15d) Remove check for set env vars os.environ() does that anyway (@tombh)
- [#411](https://github.com/deis/deis/pull/411) Merge pull request #411 from opdemand/pypi-updates (@opdemand)
- [a2b446c](https://github.com/deis/deis/commit/a2b446cb4273c3fee8baf73f9566de726b0cdedf) Be specific about required package versions in client setup.py. (@mboersma)
- [0896b9b](https://github.com/deis/deis/commit/0896b9b562180368f143d767002a61ca064bf653) Fixed flake8 errors (@tombh)
- [a8e19d3](https://github.com/deis/deis/commit/a8e19d3e05f680bc937f39ac029c8b9901b5b76c) Updated README.rst for Deis CLI, fixes #409. (@mboersma)
- [#417](https://github.com/deis/deis/pull/417) Merge pull request #417 from opdemand/fix-409-client-readme (@opdemand)
- [#414](https://github.com/deis/deis/pull/414) Merge pull request #414 from opdemand/fix-413-requests-version (@opdemand)
- [676aa57](https://github.com/deis/deis/commit/676aa571516d5cad9e009188b6f4c036c704b086) Fixed #418 -- handle `deis keys:add ~/.ssh/mykey.pub` properly. (@mboersma)
- [5a38afd](https://github.com/deis/deis/commit/5a38afd7c34d39188110f3b22b0878c660eda52f) Added several tests and improved coverage definition. (@mboersma)
- [#420](https://github.com/deis/deis/pull/420) Merge pull request #420 from opdemand/fix-cli-keys-add (@opdemand)
- [#421](https://github.com/deis/deis/pull/421) Merge pull request #421 from opdemand/more-better-tests (@opdemand)
- [95d750f](https://github.com/deis/deis/commit/95d750f502ccc6338af7e954f37b48148379d4f4) Fixed #355 -- retry deleting EC2 security group. (@mboersma)
- [#422](https://github.com/deis/deis/pull/422) Merge pull request #422 from opdemand/fix-delete-ec2-sg (@opdemand)
- [711eba4](https://github.com/deis/deis/commit/711eba4e09183eeac3fdd2adf0e6c90f42f40213) Fixed #402 -- hide web signup, point users to CLI. (@mboersma)
- [#423](https://github.com/deis/deis/pull/423) Merge pull request #423 from opdemand/hide-web-signup (@opdemand)
- [8e5778d](https://github.com/deis/deis/commit/8e5778d5024384db6b2af3b17a9fff08523718a6) Fixed #406 -- return error detail if sudo fails in knife bootstrap. (@mboersma)
- [#425](https://github.com/deis/deis/pull/425) Merge pull request #425 from opdemand/406-knife-bootstrap-err (@opdemand)
- [24f4d0f](https://github.com/deis/deis/commit/24f4d0f8a7310e6f86d6baaafc679f44d15f0a9b) Added tests pointed out by coverage.py. (@mboersma)
- [#426](https://github.com/deis/deis/pull/426) Merge pull request #426 from opdemand/more-tests (@opdemand)
- [99f33ca](https://github.com/deis/deis/commit/99f33cac3c6654d253e70864ac681e9042d9a98c) Removed autofunction docs for non-existent methods. (@mboersma)
- [bf993a2](https://github.com/deis/deis/commit/bf993a2fd90c6878c4219363438cd0e89277e2d3) Fixed #353 -- added permalinks to Sphinx documentation. (@mboersma)
- [#427](https://github.com/deis/deis/pull/427) Merge pull request #427 from opdemand/353-doc-permalinks (@opdemand)
- [a862b91](https://github.com/deis/deis/commit/a862b91050dce4ea7c8f13dd844f303c8e8d56aa) Note that deis only supports `git push` to master, refs #419. (@mboersma)
- [59a4f8b](https://github.com/deis/deis/commit/59a4f8b011091fd5591a3535356812249c5ae860) Note that `nodes:create` requires password-less sudo, refs #362. (@mboersma)
- [#428](https://github.com/deis/deis/pull/428) Merge pull request #428 from opdemand/419-git-push-master-doc (@opdemand)
- [#429](https://github.com/deis/deis/pull/429) Merge pull request #429 from opdemand/362-manual-ssh-sudo (@opdemand)
- [b725bce](https://github.com/deis/deis/commit/b725bce802319b9b94f4ea16ef45c889e2ae97c3) Fixed #430 -- updated EC2 AMIs for 0.3.1 release. (@mboersma)
- [dbae8a2](https://github.com/deis/deis/commit/dbae8a2aa3d56f3178590813ff7c28a41366d8db) Updated release procedure docs. (@mboersma)

### v0.3.0 (2013/12/12 22:06 +00:00)
- [79e4899](https://github.com/deis/deis/commit/79e4899524f1e71b1e3c5916652738c756910761) Switch master to v0.3.0 (@mboersma)
- [c6835f4](https://github.com/deis/deis/commit/c6835f41eedd29dfc8c1b2090219eb31db4477f6) Updated gevent to 1.0, removed Cython dependency. (@mboersma)
- [946c5a7](https://github.com/deis/deis/commit/946c5a765148af11ba5b2de64793327e2d028ed5) add flavors:update to `deis help flavors` (@gabrtv)
- [#341](https://github.com/deis/deis/pull/341) Merge pull request #341 from opdemand/339-gevent-1.0 (@opdemand)
- [25a1f6f](https://github.com/deis/deis/commit/25a1f6ff959f4104b90fe802a168808cb65b2e53) Updated to Django 1.6. (@mboersma)
- [#340](https://github.com/deis/deis/pull/340) Merge pull request #340 from opdemand/django-1.6 (@opdemand)
- [396e3f0](https://github.com/deis/deis/commit/396e3f0e9f84a3e6c74a80685bde00fbf49a1b4f) Fixed query in several build_layer() implementations. (@mboersma)
- [#345](https://github.com/deis/deis/pull/345) Merge pull request #345 from opdemand/344-layer-query-fix (@opdemand)
- [4331cac](https://github.com/deis/deis/commit/4331cac92e3bc94b7f4954208ce76f215fadce0a) Removed the unused allauth.socialaccount app. (@mboersma)
- [2c2e4d9](https://github.com/deis/deis/commit/2c2e4d9cee1e7f9fe2b8b4e84ab4fb624fb7373e) Updated boto, pyrax, django-allauth, and smartypants. (@mboersma)
- [#349](https://github.com/deis/deis/pull/349) Merge pull request #349 from opdemand/remove-socialaccount (@opdemand)
- [#351](https://github.com/deis/deis/pull/351) Merge pull request #351 from opdemand/package-updates (@opdemand)
- [7bd348a](https://github.com/deis/deis/commit/7bd348a7b8c6facbac97c4f5176a9e97bc41f66b) Made vagrant destroy_node() RuntimeError into a warning. (@mboersma)
- [#347](https://github.com/deis/deis/pull/347) Merge pull request #347 from opdemand/346-vagrant-node-dir-err (@opdemand)
- [463dfcf](https://github.com/deis/deis/commit/463dfcfcac9fed865b3cced58411bc951c65b680) Updated to Celery 3.1.6. (@mboersma)
- [#350](https://github.com/deis/deis/pull/350) Merge pull request #350 from opdemand/update-celery (@opdemand)
- [f04cf65](https://github.com/deis/deis/commit/f04cf65cdddd98beabd65bf6903c9a3b7904e312) Fixed missing SECRET_KEY issue for docs generation. (@mboersma)
- [776b425](https://github.com/deis/deis/commit/776b4256130279a77442dbf25549f3e6fdd720af) implement default formation lookup on application creation, with tests (@gabrtv)
- [#357](https://github.com/deis/deis/pull/357) Merge pull request #357 from opdemand/default-formation (@opdemand)
- [7e57b37](https://github.com/deis/deis/commit/7e57b3799a84f1c5f38a19dddbeb8c5031c2bff3) Specify celery worker concurrency on the command-line. (@mboersma)
- [3fb232d](https://github.com/deis/deis/commit/3fb232de00a281639070e54ac00e9d2bcc211d32) downgrade to berkshelf stable, since 3.0.0 beta is problematic (@gabrtv)
- [#358](https://github.com/deis/deis/pull/358) Merge pull request #358 from opdemand/berkshelf-stable (@opdemand)
- [48ac3ee](https://github.com/deis/deis/commit/48ac3ee52d90b35292420868179ee6f9969d54a2) fix celery deadlocks by removing all blocking tasks from other (parent) tasks, and moving the logic to inline model methods (@gabrtv)
- [#359](https://github.com/deis/deis/pull/359) Merge pull request #359 from opdemand/fix-celery-deadlock (@opdemand)
- [b508280](https://github.com/deis/deis/commit/b508280241a706f3254871a2c769f0ca98a7081e) hardcode celeryd concurrency (@gabrtv)
- [5ba327e](https://github.com/deis/deis/commit/5ba327e4fc30d400253e00bc84282983da2d4b20) return the body of chef-client even on failed node convergence (@gabrtv)
- [145a5b6](https://github.com/deis/deis/commit/145a5b679113ae9169548f774c0f374de31bb5ef) Docs - Fix typo (@kumavis)
- [#361](https://github.com/deis/deis/pull/361) Merge pull request #361 from kumavis/patch-1 (@kumavis)
- [#360](https://github.com/deis/deis/pull/360) Merge pull request #360 from opdemand/show-node-converge-error (@opdemand)
- [ac26eb7](https://github.com/deis/deis/commit/ac26eb7c9d43ae6d0a3dd920f3df56612338e34c) update App.run for docker 0.7 and slugrunner syntax (@gabrtv)
- [bf3a57d](https://github.com/deis/deis/commit/bf3a57d284489c78c06833356ac0eab34d3ba11f) switch to docker 0.7.1 and pull progrium/cedarish docker image (@gabrtv)
- [362f95b](https://github.com/deis/deis/commit/362f95b2c9482393889632163d370a1567977b54) Fixed #364 - Updated EC2 AMIs for Deis 0.3.0. (@mboersma)
- [#363](https://github.com/deis/deis/pull/363) Merge pull request #363 from opdemand/docker-0.7 (@opdemand)
- [a27500b](https://github.com/deis/deis/commit/a27500bab2988ef4c1817fabded33fee4a1a7840) initial pass at developer guide and operations guide (@gabrtv)
- [11cae2a](https://github.com/deis/deis/commit/11cae2a12457b279a8e147d9428155d4dedd6a68) Merge branch 'master' into tutorial-docs (@mboersma)
- [575c707](https://github.com/deis/deis/commit/575c707409e08fab8eb17cbcfe9c24870f082b92) update master with latest cookbook for 0.3 (@gabrtv)
- [12dbdbd](https://github.com/deis/deis/commit/12dbdbd3da8a42f941c301ec1be354d6b09cb06d) move chef server to private network along w/ other vagrant components (@gabrtv)
- [a7c6356](https://github.com/deis/deis/commit/a7c6356ceed862b5cac3174e37e6381683aecdcd) fix refs to operations guide (@gabrtv)
- [7e5ff6b](https://github.com/deis/deis/commit/7e5ff6b435e0e2bb2323af2d03cf2cc3740367f3) purge old installation docs (@gabrtv)
- [0e77c57](https://github.com/deis/deis/commit/0e77c576f048d6eee3c5ffe2e9d6a615415bddd4) new local development docs deprecating old devsetup docs (@gabrtv)
- [#374](https://github.com/deis/deis/pull/374) Merge pull request #374 from opdemand/localdev-docs (@opdemand)
- [98bd137](https://github.com/deis/deis/commit/98bd137249088f666ff4b1deed0f17a9d58849eb) restrict converge controller to recipe[deis::gitosis] (@gabrtv)
- [#375](https://github.com/deis/deis/pull/375) Merge pull request #375 from opdemand/upgrade-workflow (@opdemand)
- [8b69f4b](https://github.com/deis/deis/commit/8b69f4b2c1142f08b6cb8c6389048284abba7e14) Removed ref to obsolete app_tasks in formation.destroy. (@mboersma)
- [db6f436](https://github.com/deis/deis/commit/db6f436e2a7f4a8c86edf9cfc65089bd5e9a5c98) set devmode to true for Vagrant controller (@gabrtv)
- [3d48e9f](https://github.com/deis/deis/commit/3d48e9f1c66987adb4646cdbc2bf22b656aa45d8) Fixed app deletion when formation is destroyed. (@mboersma)
- [682d1f8](https://github.com/deis/deis/commit/682d1f80ccb3a0c806b15f00da9470a841840b61) Fix markdown formatting issue in EC2 README (@gabrtv)
- [a707311](https://github.com/deis/deis/commit/a7073118241d783a3db2bc1d76efae0ea190ea9a) remove reuse controller tip (@gabrtv)
- [4790335](https://github.com/deis/deis/commit/4790335faf0f525e9e85c01cd23bc36c1c5feca8) on `deis run` add release environment and auto-remove container (@gabrtv)
- [#378](https://github.com/deis/deis/pull/378) Merge pull request #378 from opdemand/example-apps-tests (@opdemand)
- [#379](https://github.com/deis/deis/pull/379) Merge pull request #379 from opdemand/fix-deis-run (@opdemand)
- [ce13287](https://github.com/deis/deis/commit/ce13287ebc29c107ad2509f357b2d89629bbd592) update Berksfile.lock with latest master (@gabrtv)
- [910146f](https://github.com/deis/deis/commit/910146f3ded7346972cb5e60cb5228a382fdec0d) Check for DO credentials in ENV first then fallback to knife.rb. Add -y to Chef deletion commands. (@tombh)
- [c807cc2](https://github.com/deis/deis/commit/c807cc2d97ea74c2741f9b8c4b6e45dfc34d32a3) Fixed typo in vagrant provision-controller.sh (@mboersma)
- [#348](https://github.com/deis/deis/pull/348) Merge pull request #348 from tombh/digital-ocean-provision-error-tolerance (@tombh)
- [fb87ffd](https://github.com/deis/deis/commit/fb87ffd90282b61db8c70499f16fd703b482c2c0) add admonitions testing section to welcome page (to be reverted after styling) (@gabrtv)
- [86ed2b6](https://github.com/deis/deis/commit/86ed2b676114e026481268b33417c1aa17f88e43) Added icons and styling to Sphinx Admonitions (@bengrunfeld)
- [8f4867a](https://github.com/deis/deis/commit/8f4867a40f4b20325eb49c850f2cabe6563d7cbf) remove admonitions testing from main index (@bengrunfeld)
- [#380](https://github.com/deis/deis/pull/380) Merge pull request #380 from opdemand/sphinx-icons (@opdemand)
- [490e8e0](https://github.com/deis/deis/commit/490e8e0bb6e08858b8ea8d7df5c86d0b7503ceea) Implemented app, formation, superuser sharing permissions. (@mboersma)
- [e363b38](https://github.com/deis/deis/commit/e363b384a8d86bc95a7edfd089167c4bd8308b54) Updated permissions tests. (@mboersma)
- [85954c0](https://github.com/deis/deis/commit/85954c0976f67e0fd59c2926150fd4829522efba) Fixed #368 -- add model custom permissions in migration. (@mboersma)
- [2b8d21a](https://github.com/deis/deis/commit/2b8d21a9f699eb1d5d14218808235c0edc0e654c) Fixed #370 -- added CLI tests for app sharing workflow. (@mboersma)
- [5dcd7a5](https://github.com/deis/deis/commit/5dcd7a573d35102022041ade334b31fffe7bf6bf) Fixed #369 -- added migration to drop djcelery & socialaccount. (@mboersma)
- [#381](https://github.com/deis/deis/pull/381) Merge pull request #381 from opdemand/226-formation-sharing (@opdemand)
- [9529fa0](https://github.com/deis/deis/commit/9529fa086ef8f161251f4ab10ad5a226047248a5) Added basic documentation for `deis sharing` commands. (@mboersma)
- [efdec5c](https://github.com/deis/deis/commit/efdec5c7925c37b780d207e2e9c8862ee32f4b82) fix adominition title and type (@gabrtv)
- [#385](https://github.com/deis/deis/pull/385) Merge pull request #385 from opdemand/sharing-docs (@opdemand)
- [030d0de](https://github.com/deis/deis/commit/030d0dea2a1ae86ea4e7c015ec468f4fd40d0677) working integration suite for example apps (@gabrtv)
- [#386](https://github.com/deis/deis/pull/386) Merge pull request #386 from opdemand/fix-example-tests (@opdemand)
- [ad3028d](https://github.com/deis/deis/commit/ad3028df0316957af1d21711a05b90c2bf8cc20b) swallow the error if the node we're destroying no longer exists (@gabrtv)
- [#387](https://github.com/deis/deis/pull/387) Merge pull request #387 from opdemand/ignore-missing-instance (@opdemand)
- [00f4450](https://github.com/deis/deis/commit/00f4450528760dae2df72603f2ccdd326680004c) Added unit tests for Deis controller web views. (@mboersma)
- [37ce448](https://github.com/deis/deis/commit/37ce448e2854783844c576fd244ad7caeb5dc476) first pass at formation permissions (@gabrtv)
- [7b236d8](https://github.com/deis/deis/commit/7b236d8513dc7a33dcc4fb56201e858e0ce3dca2) Removed the unused /docs/ web view. (@mboersma)
- [fe4af27](https://github.com/deis/deis/commit/fe4af27488718bbce685f0b46ae364a84e590532) raise ResponseError on perms operations (@gabrtv)
- [#388](https://github.com/deis/deis/pull/388) Merge pull request #388 from opdemand/web-view-tests (@opdemand)
- [#389](https://github.com/deis/deis/pull/389) Merge pull request #389 from opdemand/formations-perms (@opdemand)
- [8fa1014](https://github.com/deis/deis/commit/8fa1014787b23a6452831bd47ce9cd2caac6cd62) Added is_staff flag to initial superuser, refs #389. (@mboersma)

### v0.2.1 (2013/11/26 18:41 +00:00)
- [5f8d83b](https://github.com/deis/deis/commit/5f8d83be50767bdf350856f09f2baf01b05a8247) Switch master to v0.2.1 (@mboersma)
- [ce2afc6](https://github.com/deis/deis/commit/ce2afc6a11edbb6c237550e6afd55d85178a4868) Started on docs (@mboersma)
- [f69b0da](https://github.com/deis/deis/commit/f69b0daf01c03910c1eb06dec31fe3f1564aaf21) Fixed Flake8 errors (@tombh)
- [03ed368](https://github.com/deis/deis/commit/03ed3681a70a31e8fd1b426606d59910b7e6d8af) Updated Berksfile format for 3.0.0 beta 3 and Chef to 11.6.2. (@mboersma)
- [8fff79e](https://github.com/deis/deis/commit/8fff79e30474df5e3d920ade041b28a5ca87788f) Silence the McCabe checker on two methods, refs #276. (@mboersma)
- [e86d7c3](https://github.com/deis/deis/commit/e86d7c35574ec0fcd463ad95f63788663b093634) Changed sync_folder path in Vagrantfile.local.example to mount parent path (@tombh)
- [34c70c8](https://github.com/deis/deis/commit/34c70c81368334be9f7fbfb8df7894192ac78f5b) Full Vagrant provider. Squashed commits (@tombh)
- [17efd9d](https://github.com/deis/deis/commit/17efd9dc75168109f7946c0740d6cad6eff59ae6) Added missing warning to vagrant provisioning script. (@mboersma)
- [4786ec8](https://github.com/deis/deis/commit/4786ec8c439dd53256413a58644b6d0aef939a55) Default login/register URL to http:// schema if it's not specified. (@mboersma)
- [7ecb90f](https://github.com/deis/deis/commit/7ecb90f77d4d380bae6a4a8b35b13f98fc955a8e) Moved "Terms" section back to top level nav in docs. (@mboersma)
- [#300](https://github.com/deis/deis/pull/300) Merge pull request #300 from opdemand/299-no-schema-supplied (@opdemand)
- [#301](https://github.com/deis/deis/pull/301) Merge pull request #301 from opdemand/296-terms-sphinx-nav (@opdemand)
- [13d0adc](https://github.com/deis/deis/commit/13d0adcc622331e1c7c63668fc0771db59fe4553) Don't prompt users to create an app if runtime=0 (@mboersma)
- [#302](https://github.com/deis/deis/pull/302) Merge pull request #302 from opdemand/250-nodes-scale-msg (@opdemand)
- [28e395a](https://github.com/deis/deis/commit/28e395a6ea5001add742e92dd08c261765e56132) Experimenting with using hostname rather than IP to SSH into host. (@tombh)
- [96ae777](https://github.com/deis/deis/commit/96ae777e9bb8de4012ecf0e5c1cd2d7b80d5f435) 1) Use private network and static IPs for all vagrant VMs. 2) Use (@tombh)
- [bf234f7](https://github.com/deis/deis/commit/bf234f72d07962e4a9ad9db0185b05613d48d0f2) Override rsyslog behaviour by using Vagrantfile to create a higher (@tombh)
- [6083875](https://github.com/deis/deis/commit/6083875b8ef0a4cd5b968627ac100d94a4595958) added some error checking for digital ocean
- [4c74f1e](https://github.com/deis/deis/commit/4c74f1eeb621a1119f4e5e6701b2e0df08ef145d) use region_id, not location_id
- [6ef32c7](https://github.com/deis/deis/commit/6ef32c71986b3e6ed825b457a0f430955d7a7850) Refactored provider creds discovery to be more DRY, added alternate AWS vars. (@mboersma)
- [#308](https://github.com/deis/deis/pull/308) Merge pull request #308 from bacongobbler/306-snapshot-error-checking (@bacongobbler)
- [#309](https://github.com/deis/deis/pull/309) Merge pull request #309 from opdemand/276-providers-discover-refactor (@opdemand)
- [f0fd45f](https://github.com/deis/deis/commit/f0fd45f398641266e40c1081e7ac0920684b42fc) If CM's purge_node() fails then raise an error. (@tombh)
- [0c0f7ca](https://github.com/deis/deis/commit/0c0f7caa73e5d7fb4be4000ad8a3d6cf32f23172) If CM's purge_node() fails then raise an error. (@tombh)
- [#310](https://github.com/deis/deis/pull/310) Merge pull request #310 from tombh/purge-node-feedback (@tombh)
- [be45748](https://github.com/deis/deis/commit/be457480450a26ec152be7a494b903904c8e315b) Instructions to add Controller to Chef's admin group and note to install avahi-daemon/Bonjour (@tombh)
- [691461d](https://github.com/deis/deis/commit/691461dc85ecca3e61334e06e239fda93c890e88) Merge branch '232-vagrant-provider-full' of https://github.com/tombh/deis into tombh-232-vagrant-provider-full (@mboersma)
- [66493b1](https://github.com/deis/deis/commit/66493b1058b53939cf415d23cdba2bf90b5675f9) Updated docs and only test for avahi-daemon on Linux. (@mboersma)
- [3e3c14a](https://github.com/deis/deis/commit/3e3c14a9b9e7d9cfc5c456655ee3a6c1251dafe4) Merge branch 'patch-2' of https://github.com/scottstamp/deis into scottstamp-patch-2 (@mboersma)
- [5d5bf1b](https://github.com/deis/deis/commit/5d5bf1b6080073c48ab8ee3351a559c6a252421c) Updated Berksfile for latest deis-cookbook SHA. (@mboersma)
- [f18f32c](https://github.com/deis/deis/commit/f18f32cf4ad32cb0ff10b85f05004264b2c16148) Made vagrant provider's config not a fatal IOError. (@mboersma)
- [#314](https://github.com/deis/deis/pull/314) Merge pull request #314 from opdemand/313-vagrant-ioerror (@opdemand)
- [21d0634](https://github.com/deis/deis/commit/21d0634a7ea84d25a9691a82d39c227bfe2e2f45) Ignore Chef 404s when destroying a node. (@mboersma)
- [#315](https://github.com/deis/deis/pull/315) Merge pull request #315 from opdemand/312-node-purge-404 (@opdemand)
- [ef4b021](https://github.com/deis/deis/commit/ef4b021e3807ff61808cd57fdfbb0b039118c478) Created a separate pip requirements file for doc generation. (@mboersma)
- [#316](https://github.com/deis/deis/pull/316) Merge pull request #316 from opdemand/311-orphaned-sphinx-docs (@opdemand)
- [b59f28b](https://github.com/deis/deis/commit/b59f28b0c290b26dc2d14487ad7e5f37c7779dc8) Added more helpful error when `deis run` comes before `git push`. (@mboersma)
- [#323](https://github.com/deis/deis/pull/323) Merge pull request #323 from opdemand/304-run-before-push (@opdemand)
- [19b6e5b](https://github.com/deis/deis/commit/19b6e5be39d430195db02f48a96a7793860bebc8) Added ssh-key generation per test user. (@mboersma)
- [#324](https://github.com/deis/deis/pull/324) Merge pull request #324 from opdemand/214=cli-acceptance-tests (@opdemand)
- [503f282](https://github.com/deis/deis/commit/503f28205d269f6d28d09fcbc5660dfc1293e5b3) Create fake home dir per test user, refs #214. (@mboersma)
- [#330](https://github.com/deis/deis/pull/330) Merge pull request #330 from opdemand/214-cli-acceptance-tests (@opdemand)
- [97781ee](https://github.com/deis/deis/commit/97781ee8310486e4f155359870f0963e5ca71c8b) Added test_examples to hit each example-* project, WIP refs #214. (@mboersma)
- [8ce7fa0](https://github.com/deis/deis/commit/8ce7fa005099085f078c8d9c83f7c4665172cdac) Implemented missing chef.purge_user() and connected it to a signal. (@mboersma)
- [#332](https://github.com/deis/deis/pull/332) Merge pull request #332 from opdemand/331-cm-purge-user (@opdemand)
- [d4c1938](https://github.com/deis/deis/commit/d4c1938e660c101f4fab3f1f024c3547c9bf67b3) Added documentation for static / bare metal installation. (@mboersma)
- [#333](https://github.com/deis/deis/pull/333) Merge pull request #333 from opdemand/214-cli-tests (@opdemand)
- [#335](https://github.com/deis/deis/pull/335) Merge pull request #335 from opdemand/295-static-installation (@opdemand)
- [f34ea7d](https://github.com/deis/deis/commit/f34ea7d70fb39588013355b9878c6a81d1529e08) Fixed PHP detect regex in test_examples, refs #214. (@mboersma)
- [c75566d](https://github.com/deis/deis/commit/c75566d14386063c39184e178068f124f75492ad) Increase vagrant controller RAM to 2G, closes #336. (@mboersma)
- [6756763](https://github.com/deis/deis/commit/67567630ba4f6109757b3ba5df6f7191b6a3d0a8) fix jquery in airplane-mode (@gabrtv)
- [7c4baee](https://github.com/deis/deis/commit/7c4baeea9120b20b041d25105e4fafcbd38c9337) lay down initial structure dev/ops tutorials (@gabrtv)
- [f367c7e](https://github.com/deis/deis/commit/f367c7e26838672892a8d9e1e63340d92c304fc2) Fixed #327 -- updated EC2 AMIs for 0.2.1 release. (@mboersma)

### v0.2.0 (2013/11/05 18:56 +00:00)
- [d783c24](https://github.com/deis/deis/commit/d783c244db85a7b152c4578f3d208435f9399001) Switch master to v0.1.2 (@mboersma)
- [29929dd](https://github.com/deis/deis/commit/29929dd507b5152a59fba0b19a6ee2f99bacb4f3) Fixed reference to "only EC2" in client README.rst. (@mboersma)
- [5f83a5e](https://github.com/deis/deis/commit/5f83a5e87cd0ea6702b10a2a9826a3cf99ec6a72) Updated Django to 1.5.5 security/bugfix release. (@mboersma)
- [4190cef](https://github.com/deis/deis/commit/4190cef097846f470c3387544f44a0d7458ec8a4) Updated opdemand/buildstep build procedure. (@mboersma)
- [0c6f8cd](https://github.com/deis/deis/commit/0c6f8cd2c08d2db047b56283dec2378e7d8f2443) Fixed #248 -- exposed `deis layers:update` in CLI. (@mboersma)
- [7f17ffb](https://github.com/deis/deis/commit/7f17ffbc6ebdd6a89440f343e36f3cb3ddce1339) Fixed #242 -- update "no proxy" error message. (@mboersma)
- [#253](https://github.com/deis/deis/pull/253) Merge pull request #253 from opdemand/248-layers-update (@opdemand)
- [c9127c1](https://github.com/deis/deis/commit/c9127c1b80a666c1e9bf86d3a6d31cfb0a384c8b) Fixed TypeError in formations:create. (@mboersma)
- [5bcae3f](https://github.com/deis/deis/commit/5bcae3f20b2a84f7a4cc7e2328f650790ec47f88) Fixed #232 -- add vagrant support for Deis development. (@mboersma)
- [3b45465](https://github.com/deis/deis/commit/3b45465c5f7dfbfc4089d5dae939a1e9276b5624) validate that App.id only contains [a-z0-9-] and is a valid domain name, with tests (@gabrtv)
- [94d714d](https://github.com/deis/deis/commit/94d714df444efbf2224e5b52d8ed3007c24f7462) fix variable naming to be clear about app vs. formation (@gabrtv)
- [1ca8d84](https://github.com/deis/deis/commit/1ca8d840f5b655a269370aa9d7a8fe8e7c8da577) add digital ocean provider
- [878e769](https://github.com/deis/deis/commit/878e769e7dab9076e3271d6605af93729af683b7) Added a script to help create the vagrant static formation. (@mboersma)
- [#254](https://github.com/deis/deis/pull/254) Merge pull request #254 from opdemand/fix-id-override (@opdemand)
- [#257](https://github.com/deis/deis/pull/257) Merge pull request #257 from opdemand/232-vagrant-dev (@opdemand)
- [3ba4960](https://github.com/deis/deis/commit/3ba4960fc323a30aef862ce19bade60d672743c4) changed controller size to 2GB
- [e054ffb](https://github.com/deis/deis/commit/e054ffb9674392ede1b8a22b9ff3b59ed855639a) Merge branch '73-digitalocean-provider' of https://github.com/bacongobbler/deis into bacongobbler-73-digitalocean-provider (@mboersma)
- [765a9cc](https://github.com/deis/deis/commit/765a9ccf98b8515c7627d46a87845df94410a142) Fixed PEP8 errors missed on previous merge. (@mboersma)
- [124ff26](https://github.com/deis/deis/commit/124ff26914cec56f56da485e0ac5bf70074389f1) Include provider.digitalocean in API docs, refs #73. (@mboersma)
- [4e4303a](https://github.com/deis/deis/commit/4e4303aba10031ea80059136991c27cf0431974f) Fixed #258 -- removed errant print statement. (@mboersma)
- [ce064c5](https://github.com/deis/deis/commit/ce064c56f0a59d9836291c8f7b1149a9eed568b4) remove ffi dependency
- [#261](https://github.com/deis/deis/pull/261) Merge pull request #261 from bacongobbler/patch-1 (@bacongobbler)
- [572a1c9](https://github.com/deis/deis/commit/572a1c9115f832beae9b8fcb994a4b6f6f9f9bcc) downgrade eventmachine version to v1.0.0
- [#263](https://github.com/deis/deis/pull/263) Merge pull request #263 from bacongobbler/patch-2 (@bacongobbler)
- [7740d7f](https://github.com/deis/deis/commit/7740d7f9247f45f89fb0bd7a20b9bd0cd6ea09e7) remove EC2 only from README (@gabrtv)
- [4cf312f](https://github.com/deis/deis/commit/4cf312f3505b23422c5a6d2847f6c38babf0e6d0) Proposed fix for gh#264 (@scottstamp)
- [b666811](https://github.com/deis/deis/commit/b666811335cb5e3baa657b7017a4440ef05d85e0) Update chef.py (@scottstamp)
- [#265](https://github.com/deis/deis/pull/265) Merge pull request #265 from scottstamp/patch-1 (@scottstamp)
- [39e211c](https://github.com/deis/deis/commit/39e211c395ff91e76799c0a5b9ac300c88e6f9a3) Added a reminder about Chef admin perms after provisioning. (@mboersma)
- [c132663](https://github.com/deis/deis/commit/c1326630a6b4c7405d96c8b65e3b7ca6957d6acd) Use correct method in socket module, gethostname() (@gabrtv)
- [b800549](https://github.com/deis/deis/commit/b800549dd8ea0479f5c04bf56abc94396ffb6bbb) Fixed #267 -- updated controller web UI. (@mboersma)
- [#272](https://github.com/deis/deis/pull/272) Merge pull request #272 from opdemand/267-web-ui (@opdemand)
- [b8d2cbf](https://github.com/deis/deis/commit/b8d2cbf7b9d549e5ab214196bae8b51d2314f735) Updated Chef version to 11.6.2. (@mboersma)
- [358d36b](https://github.com/deis/deis/commit/358d36b15f0d758d29b2c1ff5ed9b989a700cf9d) Updated to new Berksfile format to silence deprecation warnings. (@mboersma)
- [c72e970](https://github.com/deis/deis/commit/c72e9708e23b912bb33590cfdf651248d59f6894) Created provider-specific installation docs, refs #227. (@mboersma)
- [#283](https://github.com/deis/deis/pull/283) Merge pull request #283 from opdemand/227-provider-docs (@opdemand)
- [#280](https://github.com/deis/deis/pull/280) Merge pull request #280 from opdemand/271-chef-version (@opdemand)
- [059ba16](https://github.com/deis/deis/commit/059ba16b5d5294e1e2c23018c4a030dbefd28c3e) Reverted Berksfile format. (@mboersma)
- [5ee80eb](https://github.com/deis/deis/commit/5ee80ebf6e4f310a7323a012cfac03e1c280ac1a) Updated sadly hard-coded JS nav code for new docs, refs #283. (@mboersma)
- [1eb1dc4](https://github.com/deis/deis/commit/1eb1dc47f3bc4eedacf31ab1187173219da70748) Clarify that Dockerfiles are not yet supported directly. (@mboersma)
- [1838ae3](https://github.com/deis/deis/commit/1838ae3e1014bcf00b36ef0f4895e25d38223d1f) Updated several python packages. (@mboersma)
- [29ba038](https://github.com/deis/deis/commit/29ba038207219c33efded90bc700ab80f77a995f) Specified package version 0.6.4 for Docker, not virtual package. (@mboersma)
- [b4b1272](https://github.com/deis/deis/commit/b4b127259b9b56f877a3537a7b16e257ec5d6aaa) Updated EC2 AMIs in all regions for security updates. (@mboersma)
- [#289](https://github.com/deis/deis/pull/289) Merge pull request #289 from opdemand/236-refresh-amis (@opdemand)
- [cb97507](https://github.com/deis/deis/commit/cb97507703a8ee320132a411e757ebfca59f21f3) Updated prepare-image-* scripts for minor optimizations. (@mboersma)
- [ef9290b](https://github.com/deis/deis/commit/ef9290b81590db602022dad407a5c9dda671c4f6) Updated project version strings to 0.2.0. (@mboersma)
- [d25c2c2](https://github.com/deis/deis/commit/d25c2c2c233f7001a42de3680c8fbe8128f4eff9) Updated Ruby gems dependencies. (@mboersma)

### v0.1.1 (2013/10/22 16:42 +00:00)
- [4836b99](https://github.com/deis/deis/commit/4836b998fb6bb627f00bd58093d33e7414b20fe2) switch master to v0.1.1 (@gabrtv)
- [3c64f7f](https://github.com/deis/deis/commit/3c64f7fb34f7fcbe0d94425ce42d372b9375d7e2) update release instructions post git-flow (@gabrtv)
- [12d6f07](https://github.com/deis/deis/commit/12d6f07f98ebbcafb4c7a9999d76fc8a5bf1acbd) Fixed a RST format bug in client README.rst. (@mboersma)
- [2228d6c](https://github.com/deis/deis/commit/2228d6ca16f02e29f9520128149d2e9be9c3b751) Fixed #215 -- allow flavors:update from CLI. (@mboersma)
- [#217](https://github.com/deis/deis/pull/217) Merge pull request #217 from opdemand/215-flavors-update (@opdemand)
- [f4f3ae3](https://github.com/deis/deis/commit/f4f3ae38c5cd6d3e91c07aa02d3ba4630c097b9c) Added bing webmaster tools verification meta (@bengrunfeld)
- [#218](https://github.com/deis/deis/pull/218) Merge pull request #218 from opdemand/add-bing-meta (@opdemand)
- [f3154e6](https://github.com/deis/deis/commit/f3154e6196f3dd83200dd52ff032450af6cebd7c) Updated client version to 0.1.1 per release process. (@mboersma)
- [767f090](https://github.com/deis/deis/commit/767f090fe8ddf19fe5a93ef3ca9aa0294fa6eec1) Remove refs to old 'azure' attempt. See also #219. (@mboersma)
- [1746bc4](https://github.com/deis/deis/commit/1746bc4c385d468ee8c13ee8fab2ce56ef13fab9) Updated paramiko and Sphinx. (@mboersma)
- [f320a77](https://github.com/deis/deis/commit/f320a7740000a2f198ced6f4b6884f4825ec55e0) Updated coverage to 3.7. (@mboersma)
- [b848ae3](https://github.com/deis/deis/commit/b848ae37f02280c8261e626ec76eb68d157e2b0e) Fixed #121 -- added support for Rackspace open cloud (@mboersma)
- [5c00f05](https://github.com/deis/deis/commit/5c00f057bbe46a086d7e6671a780db6ef45578c4) Fixed a few typos. (@mboersma)
- [9605456](https://github.com/deis/deis/commit/9605456da0522a6eb56fb766d4b3c9953bacd47e) update docs sitemap.xml post 0.1.0 refactoring (@gabrtv)
- [#224](https://github.com/deis/deis/pull/224) Merge pull request #224 from opdemand/121-rackspace-provider (@opdemand)
- [#225](https://github.com/deis/deis/pull/225) Merge pull request #225 from opdemand/update-sitemap (@opdemand)
- [35c371f](https://github.com/deis/deis/commit/35c371ff9df1706f83541665773265a4c2502a72) Fixed #222 -- CLI scaling error msg when no Rackspace image exists (@mboersma)
- [#228](https://github.com/deis/deis/pull/228) Merge pull request #228 from opdemand/222-better-500-error (@opdemand)
- [217f7dc](https://github.com/deis/deis/commit/217f7dcc22b71394d0053c228bba33c850ee1e16) only run commands against nodes in runtime layers (@gabrtv)
- [#229](https://github.com/deis/deis/pull/229) Merge pull request #229 from opdemand/fix-run-selection (@opdemand)
- [551e742](https://github.com/deis/deis/commit/551e742fa727a4523e44caf9b08fc6fb18acee80) Fixed possible exception case from previous commit. (@mboersma)
- [77a571f](https://github.com/deis/deis/commit/77a571fdf46274531428c7568afd59a7ce830412) Fixed #233 -- made buildstep fork cleaner WRT progrium/buildstep (@mboersma)
- [05ff02a](https://github.com/deis/deis/commit/05ff02a12461bd61a71e7b3ae6a0b0ec9aa636ba) Fixed #220 -- add standard footer to Sphinx template for readthedocs.org (@mboersma)
- [6b1a5b3](https://github.com/deis/deis/commit/6b1a5b3175c476be2c4ab546ebdf2a63d4abe3b5) Updated boto, pycrypto, yamlfield. (@mboersma)
- [b58105a](https://github.com/deis/deis/commit/b58105af2207b3fc08b9a36b61f7db6b0dcbef90) Updated gevent to 1.0rc3, fixes vagrant DNS issues, refs #232. (@mboersma)
- [278244e](https://github.com/deis/deis/commit/278244eb6c55e5c74b9a75a7e72e388bb50dcaab) Fixes #240. Updated docs layout.html file and main.css to fix the style breakage that adding Read The Docs footer caused. (@bengrunfeld)
- [85444c0](https://github.com/deis/deis/commit/85444c069b2a5ecafed9fd012d4d4591c5b1e8fb) Updates main.css to fix styling break caused by ReadTheDocs footer template tag. (@bengrunfeld)
- [d6eeeec](https://github.com/deis/deis/commit/d6eeeec8b53aecc8741a53d1cd95b9c5e3838dc7) refs #240. Hopefully fixes style breakages. (@bengrunfeld)
- [5fc6d3d](https://github.com/deis/deis/commit/5fc6d3debb78e25b151b2dd18bc8312d018ec5a0) refs #240. Hopefully fixes style breakages. (@bengrunfeld)
- [c0d6576](https://github.com/deis/deis/commit/c0d6576f9bb920620abd1a71ef4776a422c0f484) Fixed #234 -- refreshed EC2 AMI images. (@mboersma)
- [#241](https://github.com/deis/deis/pull/241) Merge pull request #241 from opdemand/234-refresh-amis (@opdemand)
- [ec4899c](https://github.com/deis/deis/commit/ec4899c9830db59d9e91193348d59abdd1b952c2) Minor update to release procedure doc. (@mboersma)

### v0.1.0 (2013/10/01 22:14 +00:00)
- [e027393](https://github.com/deis/deis/commit/e027393920181373c216864aa1aca33c79db7927) switch master to v0.0.8 (@gabrtv)
- [a24f0dd](https://github.com/deis/deis/commit/a24f0dd59d772d2d5255994f278a996a0e79f361) Updated release procedure notes. (@mboersma)
- [bc27e99](https://github.com/deis/deis/commit/bc27e9969cf63d765f7c670201a9fb4cd8f0eace) refactor wip (@gabrtv)
- [5280796](https://github.com/deis/deis/commit/52807965b84f431622645fa4e0616074cdcb8330) Updated to Django 1.5.3 security release. (@mboersma)
- [032f908](https://github.com/deis/deis/commit/032f908312cb9c8f853954def955043eaeafa14d) updated to Django v1.5.4 security release
- [#173](https://github.com/deis/deis/pull/173) Merge pull request #173 from bacongobbler/172-django-174-security-release (@bacongobbler)
- [df50eee](https://github.com/deis/deis/commit/df50eee1aeb3b478bcbe1cb5b56c1da8a614aec1) add test coverage for cm synchronization using mock CM module (@gabrtv)
- [0edb429](https://github.com/deis/deis/commit/0edb429825b2c10fdf099e879373e31260f1314f) create the 3 necessary data bags (@gabrtv)
- [3f33765](https://github.com/deis/deis/commit/3f33765701eba1bd04a70977f01f87d71c861ffe) fix bug in key deletion api call (@gabrtv)
- [f306aad](https://github.com/deis/deis/commit/f306aadc39d7258b634730da1214a39b5b9ff3f8) move run_node to CM module, add container list/info endpoints, beef test coverage (@gabrtv)
- [74dfe2e](https://github.com/deis/deis/commit/74dfe2e6264dffb3ceba2094390f6d41889c8f58) check for initial web container in build.push (@gabrtv)
- [d045377](https://github.com/deis/deis/commit/d045377c14b62c01d7b3b968bead3d513c24ab34) add Build.push test coverage (@gabrtv)
- [591ba16](https://github.com/deis/deis/commit/591ba16ab5ee467d5d1d0f10c15bfd520e196df4) fix layer tests (@gabrtv)
- [ff28545](https://github.com/deis/deis/commit/ff2854532e55ed0b050a126097e0231e3b5c3d41) converge on app scale operation (@gabrtv)
- [ea24ebb](https://github.com/deis/deis/commit/ea24ebb729f9aa625de888479e3432e6a048d728) Updated to Django 1.5.3 security release. (@mboersma)
- [8abeea0](https://github.com/deis/deis/commit/8abeea03918110921c75719d6ec43b0861ec0ecd) updated to Django v1.5.4 security release
- [60bdbdd](https://github.com/deis/deis/commit/60bdbdde6642519d73699cc8d0530f95e70e84f5) improve code coverage on api views/models (@gabrtv)
- [f62a0cb](https://github.com/deis/deis/commit/f62a0cb31d9b09b556962dccd2f504adeb68de49) add apps:calculate functionality (@gabrtv)
- [7f8debc](https://github.com/deis/deis/commit/7f8debcd9513cf92a8426ed17ee158910f81d19d) add containers to application databag (@gabrtv)
- [7ae9c90](https://github.com/deis/deis/commit/7ae9c9050096b26f3f0d40df96c00a22a5e6aaa0) add nodes:converge, nodes:ssh, fix `deis open` (@gabrtv)
- [f88e782](https://github.com/deis/deis/commit/f88e78286a711bf3f2146674564e37bf39ccf720) move logs to apps:logs and create shortcut (@gabrtv)
- [e6b57a0](https://github.com/deis/deis/commit/e6b57a0cd6a919f5693a6fa7783a7e5c1e4c1149) fix bug with git push working after formation destroy (@gabrtv)
- [77e266a](https://github.com/deis/deis/commit/77e266a37598561ada8b322f9cb555322f6e0dda) switch release endpoints to app (@gabrtv)
- [df72bc7](https://github.com/deis/deis/commit/df72bc7dcc8ff6772442d7d0f2edd907d09155ce) change config:list, set and unset to use app endpoints (@gabrtv)
- [eb7067f](https://github.com/deis/deis/commit/eb7067faa7486b566a97e963a9a73b08d6ef9c22) move open to apps:open (@gabrtv)
- [a05b5c8](https://github.com/deis/deis/commit/a05b5c89c70d0d23278bc192e623e79a145f5e68) change app databag format from proxies to domains (@gabrtv)
- [c64c2e2](https://github.com/deis/deis/commit/c64c2e2bcfb271b19e17901bdf303b682ed16667) add test coverage around mutiple apps for formations that do/dont support it (@gabrtv)
- [28af652](https://github.com/deis/deis/commit/28af65204e2115eae52c4e3913815b1c81ab16ea) move image into build for better 12 factor compatibility (@gabrtv)
- [2e0eb69](https://github.com/deis/deis/commit/2e0eb6920fca13ffc6fdd68ba64879c6770e2ce5) add formations:update to set domain used in multi-app (@gabrtv)
- [318d9b4](https://github.com/deis/deis/commit/318d9b4468c5a3cd32f0895571434a74e6cd72cf) add container.port and make it unique across a formation for multi-app (@gabrtv)
- [f6f13b4](https://github.com/deis/deis/commit/f6f13b4ac3a8913d4a30f0950550ed04d22eec12) Fixed #174 -- updated Sphinx docs to match refactored modules. (@mboersma)
- [cd28ce4](https://github.com/deis/deis/commit/cd28ce404d140e7055db3abeb2fe19509e7f3a19) remove ops commands from client help (@gabrtv)
- [f16dd02](https://github.com/deis/deis/commit/f16dd0215ce0887bf3d67922a1b73aafb8be3787) Fixed #175 -- update REST API documentation for application-refactor. (@mboersma)
- [3ad53ce](https://github.com/deis/deis/commit/3ad53ce38496c37eb4ccd3fa0cb636cafac2ef9b) fix missing command bug during dispatching (@gabrtv)
- [131bf8f](https://github.com/deis/deis/commit/131bf8fdce1d15bed491336021cbe3f0fae080b1) fix bug with apps:run task dispatch (@gabrtv)
- [e54f9e2](https://github.com/deis/deis/commit/e54f9e2849f0214cb1a24abcd0aed0c1a46b527d) fix formation databag after app destroy, with test (@gabrtv)
- [#179](https://github.com/deis/deis/pull/179) Merge pull request #179 from opdemand/application-refactor (@opdemand)
- [d05ca70](https://github.com/deis/deis/commit/d05ca706964da5b5d20736b6ef5ee8a920107be6) deprecate provider.controller module, now handled by cm package (@gabrtv)
- [3e12255](https://github.com/deis/deis/commit/3e122552ef840151fe48bafa4c700e5807a636de) Removed Sphinx docs referencing obsolete provider.controller module. (@mboersma)
- [#180](https://github.com/deis/deis/pull/180) Merge pull request #180 from opdemand/deprecate-old-providers (@opdemand)
- [f856c67](https://github.com/deis/deis/commit/f856c671adc6485895bd454109f0b62c761a49f8) Fixed #167 -- allow underscore in slug-type field regexes. (@mboersma)
- [#183](https://github.com/deis/deis/pull/183) Merge pull request #183 from opdemand/167-underscores-in-name (@opdemand)
- [a646fbc](https://github.com/deis/deis/commit/a646fbc2ff17ecc05181184ac00bff2f8e443610) add ssh public key to Node.flat() data structure (@gabrtv)
- [#184](https://github.com/deis/deis/pull/184) Merge pull request #184 from opdemand/add-node-ssh-pubkey (@opdemand)
- [99da003](https://github.com/deis/deis/commit/99da003dce661d35b6c31d209438228281d0a7f8) Fixed #176 -- added docstrings for provider modules. (@mboersma)
- [#185](https://github.com/deis/deis/pull/185) Merge pull request #185 from opdemand/176-provider-docstrings (@opdemand)
- [2b4d7f8](https://github.com/deis/deis/commit/2b4d7f8df9ca74b7de32d3693bad18516aed8ddb) Fixed #177 -- added docstrings for cm modules. (@mboersma)
- [#186](https://github.com/deis/deis/pull/186) Merge pull request #186 from opdemand/177-cm-docstrings (@opdemand)
- [4f04098](https://github.com/deis/deis/commit/4f04098005777af0fd553f28561cae4634e05f5d) cli doc updates and cleanup for app refactoring (@gabrtv)
- [a254564](https://github.com/deis/deis/commit/a254564ba79664178ff4eefee9848f3dcff19a9a) update client reference docs (@gabrtv)
- [ca46506](https://github.com/deis/deis/commit/ca46506e04d27cb3229a8975b59564e3ab781f7b) update terms post application object model changes (@gabrtv)
- [5f09ad8](https://github.com/deis/deis/commit/5f09ad8c3c68889f0205eed6ed5cbc3eef64eaca) update concepts post application object model changes (@gabrtv)
- [75487ed](https://github.com/deis/deis/commit/75487ed48c61df6cb9152e73fed7a97ebb255a85) add apps:info with info shortcut (@gabrtv)
- [8940321](https://github.com/deis/deis/commit/89403219dd25bfc08b3e1171a8b4bb826e487dc5) remove unnecesary JSONField subclasses, remote undoc'd members from api.models (@gabrtv)
- [ed22d9a](https://github.com/deis/deis/commit/ed22d9ab73c9d24d9066af82b87c6247db272ca7) standardize on spaces instead of tabs to fix code block formatting (@gabrtv)
- [3d9142f](https://github.com/deis/deis/commit/3d9142f7ade378386037af7be8f07cc19c4257c1) fix noindex indentation (@gabrtv)
- [425d498](https://github.com/deis/deis/commit/425d498798b98143b29f7d8ce4a558c5e9bd4026) add escaping of astericks for sphinx (@gabrtv)
- [66d6427](https://github.com/deis/deis/commit/66d6427e12d5687a4e80611ac9b3aec2a6ee6257) update installation docs (@gabrtv)
- [c7c6e9e](https://github.com/deis/deis/commit/c7c6e9ec60b93282c500d7973aa46d71d8f639e3) remove todos from toctree (@gabrtv)
- [65245e2](https://github.com/deis/deis/commit/65245e2f19b9f29cf5d9c9cb721b1436bb8d1f99) update readme with new app-oriented workflow (@gabrtv)
- [369ac79](https://github.com/deis/deis/commit/369ac795c38e86f9bbe9267f4f6eff50280eea56) fix typo in deploy language (@gabrtv)
- [#189](https://github.com/deis/deis/pull/189) Merge pull request #189 from opdemand/doc-updates (@opdemand)
- [fda0f27](https://github.com/deis/deis/commit/fda0f2706f0a237dfe71251b6730d250ba8baf6b) return 404 if app cannot be found during queryset lookup, fixes #182 (@gabrtv)
- [2f269fa](https://github.com/deis/deis/commit/2f269fad14330e9b24a87071c6aa6569c12b95eb) add simple password confirmation on registration fixes #188 (@gabrtv)
- [#192](https://github.com/deis/deis/pull/192) Merge pull request #192 from opdemand/confirm-pw-on-register (@opdemand)
- [#191](https://github.com/deis/deis/pull/191) Merge pull request #191 from opdemand/app-endpoint-500s (@opdemand)
- [fdcd7d9](https://github.com/deis/deis/commit/fdcd7d9710facf7a10291ee1504239ab45021877) more doc updates (@gabrtv)
- [7e3230b](https://github.com/deis/deis/commit/7e3230b909af21a0d2c2e15ac429fa4bf8a22aa4) cleanup line breaks, update command output (@gabrtv)
- [678a6b8](https://github.com/deis/deis/commit/678a6b897156019afce22aa469a0e46d26bf75d4) reset initial south migration, fixes opdemand/deis-cookbook#14 (@gabrtv)
- [#194](https://github.com/deis/deis/pull/194) Merge pull request #194 from opdemand/more-doc-updates (@opdemand)
- [#193](https://github.com/deis/deis/pull/193) Merge pull request #193 from opdemand/reset-south-migrations (@opdemand)
- [8e4f60f](https://github.com/deis/deis/commit/8e4f60f8a04a52a7642607d7234e35a92bc8bbbb) Updated and tested boto, requests, djangorestframework, and paramiko. (@mboersma)
- [#195](https://github.com/deis/deis/pull/195) Merge pull request #195 from opdemand/pypi_updates (@opdemand)
- [0388366](https://github.com/deis/deis/commit/0388366b3eeb0f3397cbd4ea6462e6bc74fe9a08) fix ssh_username not being read in 'deis ssh'
- [#196](https://github.com/deis/deis/pull/196) Merge pull request #196 from bacongobbler/deis-ssh-username-fix (@bacongobbler)
- [4df6164](https://github.com/deis/deis/commit/4df6164e3084ca5dc7219e5f2812d1124912b18d) Added a django admin class for api.models.App. (@mboersma)
- [#197](https://github.com/deis/deis/pull/197) Merge pull request #197 from opdemand/app-in-django-admin (@opdemand)
- [034a4ac](https://github.com/deis/deis/commit/034a4ac500ad2164a713512555625112b0d3e344) Fixed #198 -- ensure new users have is_active == True. (@mboersma)
- [#200](https://github.com/deis/deis/pull/200) Merge pull request #200 from opdemand/198-user-isnt-active (@opdemand)
- [8210ff9](https://github.com/deis/deis/commit/8210ff9e289ef043901aa7ddd54d04240a98ea24) Fixed #202 -- adding content-type header broke registration. (@mboersma)
- [68f40b3](https://github.com/deis/deis/commit/68f40b31aca499e576316bdd1e4b49b64ded5f01) Fixed #170 -- "deis nodes:create" allows adding external instances. (@mboersma)
- [#201](https://github.com/deis/deis/pull/201) Merge pull request #201 from opdemand/170-manually-add-nodes (@opdemand)
- [0d43479](https://github.com/deis/deis/commit/0d43479b095ea1348a0b810f7de010b31560ce0f) Fixed #56 -- implemented account cancellation. (@mboersma)
- [#203](https://github.com/deis/deis/pull/203) Merge pull request #203 from opdemand/56-account-cancellation (@opdemand)
- [29a3a09](https://github.com/deis/deis/commit/29a3a093b28df33ec40d430bee8a748780d5e8d6) Fixed #205 -- updated with fresher AMIs. (@mboersma)
- [8a6f44e](https://github.com/deis/deis/commit/8a6f44e78bb25b32786ac0bb648f9ae28dbbd75d) Fixed #204 -- `deis containers` works before `git push` without error. (@mboersma)
- [#207](https://github.com/deis/deis/pull/207) Merge pull request #207 from opdemand/205-update-amis (@opdemand)
- [ef59b7c](https://github.com/deis/deis/commit/ef59b7cf36dbfc84365adc83e784702665f71a08) Fixed #122 -- CLI-driven test suite. (@mboersma)
- [88bd938](https://github.com/deis/deis/commit/88bd938e9048e6986a51606a0864fca07284f274) Updated tests (@mboersma)
- [a531dbc](https://github.com/deis/deis/commit/a531dbcd8cacde233035701a552c980bd0527a09) Merge branch '122-acceptance-test' of https://github.com/opdemand/deis into 122-acceptance-test (@mboersma)
- [d071885](https://github.com/deis/deis/commit/d0718855557961a0a30f2da75431f9861e199890) Updated version strings to 0.1.0. (@mboersma)
- [5ffb41f](https://github.com/deis/deis/commit/5ffb41f1d15ed29024abe90b9733a821eb9d630b) write knife output to celery logs regardless of success or failure fixes #206 (@gabrtv)
- [#209](https://github.com/deis/deis/pull/209) Merge pull request #209 from opdemand/log-knife-output (@opdemand)
- [b58cb38](https://github.com/deis/deis/commit/b58cb385686c45ca5c5a2f93c5986f28de96eafc) Changed DEIS_SERVER import error to a warning message. (@mboersma)
- [639c530](https://github.com/deis/deis/commit/639c53047a53a3780320821294dd3dcc8a9eee48) Remove client tests from default targets; they're too expensive. (@mboersma)
- [24d6aa7](https://github.com/deis/deis/commit/24d6aa78e3f1eec3b259f2060a2d65b0a94cd130) update docs, and remove line break from command output (@gabrtv)
- [96b7251](https://github.com/deis/deis/commit/96b72518c0ecb94fb581c86fac935a33aad4127b) update berksfile and gemfile for 0.1.0 (@gabrtv)
- [#210](https://github.com/deis/deis/pull/210) Merge pull request #210 from opdemand/122-acceptance-test (@opdemand)
- [#213](https://github.com/deis/deis/pull/213) Merge pull request #213 from opdemand/update-docs (@opdemand)
- [#212](https://github.com/deis/deis/pull/212) Merge pull request #212 from opdemand/update-ruby-deps (@opdemand)
- [0cf1279](https://github.com/deis/deis/commit/0cf127953c79032893c739b980ae2c833ab26a6d) print converge output for every node converge, success or fail (@gabrtv)
- [59706e1](https://github.com/deis/deis/commit/59706e172818230a903508af59a3553c3794abbe) remove converge from release handling, fixes double-converge issue on build/config changes (@gabrtv)
- [#216](https://github.com/deis/deis/pull/216) Merge pull request #216 from opdemand/fix-double-converge (@opdemand)
- [e829988](https://github.com/deis/deis/commit/e829988d54e10a9ceb4f4ff99531cceb60b3c6dd) Updated client README. (@mboersma)

### v0.0.7 (2013/09/10 17:06 +00:00)
- [9420dfd](https://github.com/deis/deis/commit/9420dfd017b6232e31040f5de0119a24deef619c) switch back to dev release for 0.0.7 (@gabrtv)
- [f6de3f4](https://github.com/deis/deis/commit/f6de3f43ad2c9d2445a69633e10b78ce041f0b51) Updated release docs and bumped CLI version to 0.0.7 dev. (@mboersma)
- [1274278](https://github.com/deis/deis/commit/127427894d1e52edc441b54f337434cd137f15cb) Closes #126. Updated RHS sidebar to float right. Updated the social bar to adjust its top margin on page resize. Updated typography in RHS sidebar. Updated social bar to align to bottom of page text. Updated search results page styling. (@bengrunfeld)
- [1fe584f](https://github.com/deis/deis/commit/1fe584f3d67f5000f36138b2312d9b0d7d280edc) Fixed styling error on short documentation pages (@bengrunfeld)
- [3ea1730](https://github.com/deis/deis/commit/3ea1730d749fbf92796156db58e5be44bc761cb3) Fixed #127 -- use re.search since re.match always matches string start. (@mboersma)
- [3f73d81](https://github.com/deis/deis/commit/3f73d811fa968965d053aee0d6ce696297f9398e) Removed empty docs for intentionally empty web/models.py (@mboersma)
- [f39246a](https://github.com/deis/deis/commit/f39246a3cd1f768f4c2a84b15f09e719aa218860) Fixed #128 -- @task-decorated functions need autofunction for docs (@mboersma)
- [#133](https://github.com/deis/deis/pull/133) Merge pull request #133 from opdemand/128-sphinx-task-decorator (@opdemand)
- [784358a](https://github.com/deis/deis/commit/784358aa1e4c37dca58c73e27bb1c01b4fde0918) Fixed #131 -- better error handling in `deis open` (@mboersma)
- [85afc09](https://github.com/deis/deis/commit/85afc0979279f59b3e2a9a5650b2b72b4c0f8287) Fixed #129 -- work around EC2's laggy create_security_group(). (@mboersma)
- [5150a73](https://github.com/deis/deis/commit/5150a73e77450e4bfdc5b7641697f7c79446a9f2) Fixed #135 -- better container allocation when removing nodes. (@mboersma)
- [9704d86](https://github.com/deis/deis/commit/9704d86dfa028da8cca719ea5745e152c2761100) Added container allocation tests, re #135. (@mboersma)
- [5de5cd1](https://github.com/deis/deis/commit/5de5cd1280199342b6cd80c50430440ec7401688) Fixed stupid flake8 errors. (@mboersma)
- [3ae5b4c](https://github.com/deis/deis/commit/3ae5b4c5fbe567f5dad1ae7652c8d8a0f16267e1) Fixed #140 -- more compatible usage of mktemp in provision script. (@mboersma)
- [259134c](https://github.com/deis/deis/commit/259134c9e136b29f2fdf6902007512f1800e79c0) Fixed searchbar breaking when user inputs too much text (@bengrunfeld)
- [c2fccb7](https://github.com/deis/deis/commit/c2fccb7f0a56ea470f92a43f6b2f830053e96e50) Fixes #141. Adds sitemap to docs. jQuery for menu functionality adjusted to speed up load time. (@bengrunfeld)
- [c2f9f28](https://github.com/deis/deis/commit/c2f9f28239c5f9a6204b2931074a94aff974b100) Updated comments on adjustment.js file (@bengrunfeld)
- [2c314c9](https://github.com/deis/deis/commit/2c314c912f49253bf458a87672b84b2b9ab71fa2) Fixes #142. Meta tag containing noindex,nofollow removed. (@bengrunfeld)
- [ed7e044](https://github.com/deis/deis/commit/ed7e0440806c4260b10ced94180fff86dae6a3a0) Updated gunicorn and django-json-field. (@mboersma)
- [e4110c3](https://github.com/deis/deis/commit/e4110c3794ddf2316a6b0fa9916ffc8d4d09203d) Fixes #143. Adjusted canoncial tag to point to correct URL (@bengrunfeld)
- [44a5a9e](https://github.com/deis/deis/commit/44a5a9e53d84ae955c10838564241a1c47c7ea6d) Fixed #145 -- allow empty comment/email in SSH key regex. (@mboersma)
- [9ba636d](https://github.com/deis/deis/commit/9ba636dbc4a5b93dd4231cf3ad0b41facbcd9a24) Fixed #148 -- stick with celery 3.0.22 for now. (@mboersma)
- [#149](https://github.com/deis/deis/pull/149) Merge pull request #149 from opdemand/148-new-celery-breaks (@opdemand)
- [#146](https://github.com/deis/deis/pull/146) Merge pull request #146 from opdemand/145-ssh-key-regex (@opdemand)
- [e40d0aa](https://github.com/deis/deis/commit/e40d0aa2371012d0218e33a139f080132bbc0b8d) Fixed #153 -- warn and return if no SSH keys found. (@mboersma)
- [#154](https://github.com/deis/deis/pull/154) Merge pull request #154 from opdemand/153-no-ssh-keys (@opdemand)
- [32d61e5](https://github.com/deis/deis/commit/32d61e54793d0f164ef45e44cae9b9b054513051) add timeout/attempts to util.connect_ssh, use 120s by default (@gabrtv)
- [1c39a12](https://github.com/deis/deis/commit/1c39a12c536f666f589aed28ac120e63ca9c1e71) Added the develop branch to Travis CI. (@mboersma)
- [#155](https://github.com/deis/deis/pull/155) Merge pull request #155 from opdemand/fix-ec2-ssh-timeout (@opdemand)
- [86227fa](https://github.com/deis/deis/commit/86227fa39e9e5153eebec0348f53aad761c33f2d) raise EnvironmentError if no credentials provided (@gabrtv)
- [0a47d7c](https://github.com/deis/deis/commit/0a47d7cef83b887a14e71ecdc40dc1ac3cf032f5) raise 400 on environment error, as in case of missing credentials (@gabrtv)
- [bea8963](https://github.com/deis/deis/commit/bea89638217c03649493701e9b67c83f8df7ae2c) handle no credentials error on formation/node destroy (@gabrtv)
- [#158](https://github.com/deis/deis/pull/158) Merge pull request #158 from opdemand/fix-missing-credentials (@opdemand)
- [dc7ae67](https://github.com/deis/deis/commit/dc7ae672a449f526336602c5f7224d9597692b66) Fixed #124 -- fill in explicit values for Flavor params. (@mboersma)
- [#159](https://github.com/deis/deis/pull/159) Merge pull request #159 from opdemand/124-ami-in-flavors (@opdemand)
- [b466011](https://github.com/deis/deis/commit/b466011d738f1a4335b906c1678d7199320d6762) add uniqueness constraint on public key field, with migration and test (@gabrtv)
- [#160](https://github.com/deis/deis/pull/160) Merge pull request #160 from opdemand/fix-duplicate-sshkey (@opdemand)
- [1e0cbe6](https://github.com/deis/deis/commit/1e0cbe622973875cc7ffaa0e87e03717b63046a3) add 500.html template as part of api staticfiles (@gabrtv)
- [#161](https://github.com/deis/deis/pull/161) Merge pull request #161 from opdemand/add-500-template (@opdemand)
- [b209957](https://github.com/deis/deis/commit/b20995746ca5117229aad45bbd9e2995651f7374) Fixed #144 -- check provisioning dependencies before running script (@mboersma)
- [#162](https://github.com/deis/deis/pull/162) Merge pull request #162 from opdemand/144-check-deis-deps (@opdemand)
- [9433bf2](https://github.com/deis/deis/commit/9433bf2efc903f0402651be135d3dd480a8b8d43) retry all chef api calls with configurable attempts and interval (@gabrtv)
- [#163](https://github.com/deis/deis/pull/163) Merge pull request #163 from opdemand/feature/chef-api-retries (@opdemand)
- [fe70977](https://github.com/deis/deis/commit/fe70977ea2fc46283c9c3e1a6baf320aa49f8b43) Fixed #123 -- updated EC2 AMIs and pointers to them. (@mboersma)
- [#164](https://github.com/deis/deis/pull/164) Merge pull request #164 from opdemand/123-update-amis (@opdemand)
- [1614736](https://github.com/deis/deis/commit/16147368a222c4a756f5e6733a7bcd51f20d4ed2) Added tests for Flavor updating. (@mboersma)
- [7fc1413](https://github.com/deis/deis/commit/7fc141346ec01a8c38eb91c23200369a7e9326d6) Fixed #151 -- `deis flavors:update` working with tests. (@mboersma)
- [#165](https://github.com/deis/deis/pull/165) Merge pull request #165 from opdemand/151-update-flavors (@opdemand)
- [fe0283e](https://github.com/deis/deis/commit/fe0283e8a3cb42890ec0dc028cb36f4732267232) Removed "develop" from Travis CI, we're not git-flowing now. (@mboersma)
- [#168](https://github.com/deis/deis/pull/168) Merge pull request #168 from opdemand/develop (@opdemand)

### v0.0.6 (2013/08/21 15:49 +00:00)
- [3a48716](https://github.com/deis/deis/commit/3a48716595c6c33696cc03efac5004b2d4e6483e) Fixed #71 -- help sphinx work on Windows. (@mboersma)
- [e48b264](https://github.com/deis/deis/commit/e48b264a61a726027758f0af324ac1c4cbac4a28) Updated jQuery page height detection. Updated styling: added rollover functionality. #29 (@bengrunfeld)
- [dcc2859](https://github.com/deis/deis/commit/dcc2859f7bdfb76080140cef847f1006052764f4) Updated Releases link in Docs #29 (@bengrunfeld)
- [1788290](https://github.com/deis/deis/commit/1788290a24718e350cbd675c564eca278321a481) Updated styling on docs. #29 (@bengrunfeld)
- [7cd482d](https://github.com/deis/deis/commit/7cd482d60df09a69150ab337c30ce8a36f6ddfb5) Silenced some sphinx warnings. (@mboersma)
- [7d3549c](https://github.com/deis/deis/commit/7d3549c8e4a409078e36c852b818817b470b9ada) Updated releases doc. (@mboersma)
- [c3d1800](https://github.com/deis/deis/commit/c3d1800f7c991bf6b6795eaa407e3fb4103f0c99) Add meta tags for Terms section #61 (@JoshuaSchnell)
- [be982a9](https://github.com/deis/deis/commit/be982a97c65c6812293971909f99ca21f6ef7651) Add meta tags to client reference, community, etc. #61 (@JoshuaSchnell)
- [6bd1d52](https://github.com/deis/deis/commit/6bd1d52a928f9c3d2b812d83cda5ceefb7d30d9e) Add meta to getting started and index #61 (@JoshuaSchnell)
- [882940b](https://github.com/deis/deis/commit/882940be8113925cfbc267bfd7a3f3e653aba6eb) Fixed #59 -- restore boilerplate JS to fix Sphinx quick search. (@mboersma)
- [671e0de](https://github.com/deis/deis/commit/671e0de7467584bfb1253c813d3bd4200c79ad87) Added local copy of searchtools.js for tweaking. (@mboersma)
- [3953b9f](https://github.com/deis/deis/commit/3953b9f44c26d9761df37ef9d4a890c1544a64da) Updated Sphinx documentation templates (@bengrunfeld)
- [ba7d671](https://github.com/deis/deis/commit/ba7d6710d530dfbab69c67b18834efa8423b8f1d) Updated documentatipon theme. Removed elements from Search Results page and adjusted the Search box in the sidebar. Changed searchtools.js to resize footer to align with bottom of content (@bengrunfeld)
- [8c2ca4d](https://github.com/deis/deis/commit/8c2ca4d9deb5b6660de1b9d8c8cb7156095e6039) Fixed #67 -- synced up README.rst with other intro docs. (@mboersma)
- [#81](https://github.com/deis/deis/pull/81) Merge pull request #81 from opdemand/67-cli-readme (@opdemand)
- [89ee756](https://github.com/deis/deis/commit/89ee75620e01387cf52d06e5ecea2a86dbe0c805) Moved checkURL.js out of the docs _build directory. (@mboersma)
- [552b4f2](https://github.com/deis/deis/commit/552b4f28c78e832123ac517532ad3770ee384c32) Fixed #61 -- finished adding META desc & keywords to server API docs. (@mboersma)
- [4edc8f6](https://github.com/deis/deis/commit/4edc8f6d4f5b4155ec3c1eb7664b5d2877310a62) Fixed #83 - use vert bar as docs title separator. (@mboersma)
- [acd23f3](https://github.com/deis/deis/commit/acd23f3c97864c52c159c295931d1b6d12233903) Removed reference to "categories" when search returns no results. (@mboersma)
- [bddf4ca](https://github.com/deis/deis/commit/bddf4caa89a79ac5d14143ce4bcf6783643cdb18) Removed extra copy of checkURL.js under sphinx theme dir. (@mboersma)
- [392c9fb](https://github.com/deis/deis/commit/392c9fb5274a7ef78d6818546cc5654c634cca18) Change example IP address per RFC 5737 (@mboersma)
- [de4f700](https://github.com/deis/deis/commit/de4f700814a024fe2271863651f48a5503d1871e) Updated South to 0.8.2. (@mboersma)
- [594d68c](https://github.com/deis/deis/commit/594d68c9eca47063f5738728f58088b63a4b43a4) Fixed #66 -- developer setup docs done. (@mboersma)
- [5e0f219](https://github.com/deis/deis/commit/5e0f21959bb1ef71301ef66afad6a2c5b732fda9) Updated to Django 1.5.2 security release, also boto 2.10.0. (@mboersma)
- [f6a46f1](https://github.com/deis/deis/commit/f6a46f1908c0ad61f5a2adb2bdfd8d478e1e5023) Deis does not rest. (@mboersma)
- [#85](https://github.com/deis/deis/pull/85) Merge pull request #85 from opdemand/66-dev-setup (@opdemand)
- [9898dd8](https://github.com/deis/deis/commit/9898dd853ad9536c52339da5ebb66efeec07a7a8) Fixed #38 -- enabled Django admin for Deis API models. (@mboersma)
- [#90](https://github.com/deis/deis/pull/90) Merge pull request #90 from opdemand/38-django-admin (@opdemand)
- [371638b](https://github.com/deis/deis/commit/371638b51e33c9d4112db030a27743356608d434) Fixed #92 -- correct some JavaScript in docs for "Releases" link. (@mboersma)
- [14481e3](https://github.com/deis/deis/commit/14481e3f4793103c89de288f99e9f91c871cbc49) Fixed #93 -- web UI loads the intended assets now. (@mboersma)
- [97c6030](https://github.com/deis/deis/commit/97c60305afe9800af2cb17e929523aa813ee0eb3) Fixed #94 -- reference squashing commits in docs, many thanks to Docker for the general wording. (@mboersma)
- [34cfcfd](https://github.com/deis/deis/commit/34cfcfdbd43e16d4cc6cd00ef17aee6b93f00460) Fixed 2 broken URL refs, re #94. (@mboersma)
- [e1ad061](https://github.com/deis/deis/commit/e1ad06143b991c563d323df6652deaafcd59d0f5) use deis::controller meta recipe in provision script re #95 (@gabrtv)
- [40c1676](https://github.com/deis/deis/commit/40c1676be588a9cbc965cf1af69aeb872e167d7b) Fixed #80 -- serializer SlugRelatedFields used too broad a query. (@mboersma)
- [#97](https://github.com/deis/deis/pull/97) Merge pull request #97 from opdemand/80-slug-related-field (@opdemand)
- [99729b1](https://github.com/deis/deis/commit/99729b1224c5b871876909d905921f42443478f3) add logs endpoint, views and tests along with `deis logs` cli command re #20 (@gabrtv)
- [#98](https://github.com/deis/deis/pull/98) Merge pull request #98 from opdemand/log-aggregation (@opdemand)
- [9b9ca9a](https://github.com/deis/deis/commit/9b9ca9a25eec9e4cb8e4429c27f74010bc85d0f2) Updated django-restframework to 2.3.7. (@mboersma)
- [aae91eb](https://github.com/deis/deis/commit/aae91ebb2ece10e4f4e292976e897bc769a5564c) Expanded vocabulary. (@mboersma)
- [ce8d1be](https://github.com/deis/deis/commit/ce8d1be44910fa03a1991202f360b9fab24cd159) Fixed #100 -- added rsyslog port 514 to EC2 provisioning script. (@mboersma)
- [06c4347](https://github.com/deis/deis/commit/06c4347775f93f5ea99d9a6c3393f100cf2158a8) Fixed #96 -- doc the 2 restframework methods. (@mboersma)
- [b6cf21f](https://github.com/deis/deis/commit/b6cf21f5d24df17021ff1eceed1a18f295e10e9a) Fixed #78 -- cookie cleanup before login. (@mboersma)
- [6fab360](https://github.com/deis/deis/commit/6fab3601f08d849b860d6615cccd73b639a5891c) Fixed #68 -- better CLI handling of EnvironmentErrors. (@mboersma)
- [#102](https://github.com/deis/deis/pull/102) Merge pull request #102 from opdemand/78-login-failed (@opdemand)
- [#103](https://github.com/deis/deis/pull/103) Merge pull request #103 from opdemand/68-cli-stacktrace (@opdemand)
- [1ec6ae4](https://github.com/deis/deis/commit/1ec6ae4df38b55aed17d8b3e80a096e17339526a) Added `deis logs` to REST API document, re #20. (@mboersma)
- [7132af7](https://github.com/deis/deis/commit/7132af76016391154aa8d6e7524d95b459dd76fc) switch from dash to bash, use /usr/bin/env for better compat fixes #104 (@gabrtv)
- [f392868](https://github.com/deis/deis/commit/f392868170d017df23a02b92c8f38fab0c64af68) switch berksfile to development version (@gabrtv)
- [3865c57](https://github.com/deis/deis/commit/3865c57ff4c759cd65d9446fcfad5ae97bb75742) dont converge on any job, just on new node creation fixes #99 (@gabrtv)
- [#105](https://github.com/deis/deis/pull/105) Merge pull request #105 from opdemand/99-autherror-on-scale (@opdemand)
- [69526b0](https://github.com/deis/deis/commit/69526b0f956a117cd8c87566719a93ca8fde33ef) add logs to common CLI commands (@gabrtv)
- [e71c803](https://github.com/deis/deis/commit/e71c803422cf77e3678ceae0b7d5b8d3ab8177dd) find a proxy and use the OS default handler to open the URL fixes #106 (@gabrtv)
- [#107](https://github.com/deis/deis/pull/107) Merge pull request #107 from opdemand/106-deis-open (@opdemand)
- [30a35e8](https://github.com/deis/deis/commit/30a35e8adb1adf071db8feef356d94aa09b4e762) log django.request and api errors to console, where gunicorn will dump a stacktrace fixes #79 (@gabrtv)
- [f26e859](https://github.com/deis/deis/commit/f26e85912a7b62a326d834a0bcf41cdc0f4a3154) return a proper 404 when no logs exist fixes #101 (@gabrtv)
- [#109](https://github.com/deis/deis/pull/109) Merge pull request #109 from opdemand/101-no-logs-message (@opdemand)
- [6081551](https://github.com/deis/deis/commit/608155165fefa13b2bf5e0c07efb5a35273a68aa) cleanup any old logfiles re #101 (@gabrtv)
- [ca3112c](https://github.com/deis/deis/commit/ca3112c0cb42991fb00d423cb9838a7486335593) add whitespace after : for the flake8 gods (@gabrtv)
- [#110](https://github.com/deis/deis/pull/110) Merge pull request #110 from opdemand/101-no-logs-message (@opdemand)
- [#108](https://github.com/deis/deis/pull/108) Merge pull request #108 from opdemand/79-log-500-errors (@opdemand)
- [30a939f](https://github.com/deis/deis/commit/30a939f8132ef5760378460ae8e7803aff0ee753) Added `deis logs` to docstrings. (@mboersma)
- [313200c](https://github.com/deis/deis/commit/313200c8abfd2f46a51ddf20f589dd2004925d52) remove dupe doc reference to logs (@gabrtv)
- [2d2c65d](https://github.com/deis/deis/commit/2d2c65d22d6a9903a84c823d9e32059dbbc61ec8) Fixed #84 -- no stacktrace when `deis providers` comes up empty. (@mboersma)
- [e26da5e](https://github.com/deis/deis/commit/e26da5e5b70244243adffd8c05a41ef5d2d963df) Fixed #24 -- added progress animation for long CLI commands. (@mboersma)
- [#112](https://github.com/deis/deis/pull/112) Merge pull request #112 from opdemand/24-cli-progress (@opdemand)
- [976ba88](https://github.com/deis/deis/commit/976ba8849331bafd6663e718d5529dfbca68b6d7) Aligned the Deis web UI with the deis.io/docus theme. (@mboersma)
- [#114](https://github.com/deis/deis/pull/114) Merge pull request #114 from opdemand/113-controller-web-ui (@opdemand)
- [bf61fbc](https://github.com/deis/deis/commit/bf61fbc03f2edf3ef9ef3eb595f04b05e0079c72) Fixed #111 -- move new_nodes out of conditional and delete nodes properly. (@mboersma)
- [b330e24](https://github.com/deis/deis/commit/b330e2422811c1d2f011742e41837357cb8fc032) Fix #70 -- first pass at `deis run <command>` including test coverage (@mboersma)
- [#116](https://github.com/deis/deis/pull/116) Merge pull request #116 from opdemand/111-scaling-error (@opdemand)
- [#115](https://github.com/deis/deis/pull/115) Merge pull request #115 from opdemand/70-run-bash (@opdemand)
- [4033d94](https://github.com/deis/deis/commit/4033d9406c85f749453a65e702222cefbab9315e) Fixed #118 -- fixed progress thread management in CLI. (@mboersma)
- [#119](https://github.com/deis/deis/pull/119) Merge pull request #119 from opdemand/118-progress-threads (@opdemand)
- [ce2563b](https://github.com/deis/deis/commit/ce2563b90d3b7d4becc0cd4750602b0d19386ecb) import profile.d/*.sh into shell environment on `deis run` (@gabrtv)
- [9d7de9b](https://github.com/deis/deis/commit/9d7de9b15f2b09668686556ae5542f487b7e772f) Prep for 0.0.6 release. (@mboersma)
- [a3ab116](https://github.com/deis/deis/commit/a3ab1163cf64e21c52c0630fabec5ce6ee8eb587) update berksfile.lock for 0.0.6 (@gabrtv)

### v0.0.5 (2013/08/06 15:59 +00:00)
- [e5b7c68](https://github.com/deis/deis/commit/e5b7c686cced8fd4011e3163d22b1327326d65cc) Fixed #5 -- created release process doc. (@mboersma)
- [0ac52a8](https://github.com/deis/deis/commit/0ac52a84a0a5d4c33fa9ba5628f5856ffd18787d) Add client module to Sphinx docs, re #49. (@mboersma)
- [b455a1d](https://github.com/deis/deis/commit/b455a1dbf1f04823228990b5870ecc5cbf7cacad) reset south migrations, and add uniqueness contraint on builds fixes #30 (@gabrtv)
- [ab88961](https://github.com/deis/deis/commit/ab8896176ddcc3c988594baed06dd04fff9c522e) paginate by 100 instead of 10 fixes #44 (@gabrtv)
- [f03d218](https://github.com/deis/deis/commit/f03d218ee5e3e34cedb4d4b512b169ce57f8831c) display assigned nodes on containers:list, to view balancing (@gabrtv)
- [849ebc5](https://github.com/deis/deis/commit/849ebc5fd93c6718a23e91f0aa0d93cb54ea8769) Added brief REST API docs, re #47. (@mboersma)
- [56effef](https://github.com/deis/deis/commit/56effefb8f763b090417cf82a5d73a67fd2eb698) Fixed URL ordering that broke several tests. (@mboersma)
- [df32c09](https://github.com/deis/deis/commit/df32c090c2fcbcb269514c118c38e0123f023169) Fixed #49 -- make module docstring into reST, everyone's happy. (@mboersma)
- [213237f](https://github.com/deis/deis/commit/213237fc4fe775e549bb78c64b0cfac5d351873b) Simplify requirements and fake SECRET_KEY for doc generation, re #57. (@mboersma)
- [b4dc254](https://github.com/deis/deis/commit/b4dc2549856f1bb97f31aeb4998f77e25593f026) Include LICENSE file in client pypi package. (@mboersma)
- [5faf53f](https://github.com/deis/deis/commit/5faf53f29c90e745aa4390c681db02eca4db2719) Updated sphinx theme to match deis.io site, re #29. (@mboersma)
- [51434ae](https://github.com/deis/deis/commit/51434ae1d1a7779545eb9297b3ac9b336da9c155) Added right navigation to docs. (@mboersma)
- [f5891f2](https://github.com/deis/deis/commit/f5891f2c387c70715736512c8dc4f5aa4ced3578) wait 10 seconds for ssh daemon to come up (@gabrtv)
- [9da39f7](https://github.com/deis/deis/commit/9da39f7ed60d5fee31a73fecd447d6dfde99ecdb) Added sphinx search in for styling, re #29. (@mboersma)
- [88c98c6](https://github.com/deis/deis/commit/88c98c61e53e8c9b8ba59087836535688e20a03e) Updated: CSS and Structure (@bengrunfeld)
- [335b0ad](https://github.com/deis/deis/commit/335b0ad0e74ba0024818aafb61919d4daa85237d) Deleted old CSS files. Updated Layout and CSS (@bengrunfeld)
- [468ca52](https://github.com/deis/deis/commit/468ca52f925920c63a99f341b04dc3780a18fb11) Remove permalinks from Sphinx doc generation. (@mboersma)
- [cc96896](https://github.com/deis/deis/commit/cc968961acbd2bd00a2c52d350861cc4fee8472a) Fixed broken JS by removing a macro. (@mboersma)
- [635988a](https://github.com/deis/deis/commit/635988af2cdeb51c4d6054798fec3f901bcfe32e) Updated: Margins and Padding inside of Sidebar (@bengrunfeld)
- [12d4e13](https://github.com/deis/deis/commit/12d4e13c831728a25f9006efc6ac3dd7ad444947) Merge remote-tracking branch 'origin/master' (@bengrunfeld)
- [f5be86c](https://github.com/deis/deis/commit/f5be86cf9345d703fdfde5ea2bd0715887414d4e) Restored search in docs, started Community docs, re #4. (@mboersma)
- [6f11be6](https://github.com/deis/deis/commit/6f11be60d583ebb254ccb45fd84356362d94265a) Added: Analytics code to layout.html (@bengrunfeld)
- [d518536](https://github.com/deis/deis/commit/d518536feb3730b48bf63874cd066694c1714627) Added a "make zipfile" target for pythonhosted.org doc hosting. (@mboersma)
- [44b3c7d](https://github.com/deis/deis/commit/44b3c7d88bf995d91862e33f2eef188092701fe4) Update releases doc to include "make zipfile" and pythonhosted.org. (@mboersma)
- [652af70](https://github.com/deis/deis/commit/652af70fdf9e7a164da9bba310b22d206c432f12) Updated: Removed search and restyled sidebar. Code blocks now in lightgray background (@bengrunfeld)
- [013ea3a](https://github.com/deis/deis/commit/013ea3a43f5a87d8b4efbe2677fc9efeae6718f4) Fixed: Javascript error. Changed docs styles (@bengrunfeld)
- [e0db967](https://github.com/deis/deis/commit/e0db967955a27aaaf9225f934ff448a32bf0d96b) Fixed #4 -- added community and conduct language to docs. (@mboersma)
- [639e80c](https://github.com/deis/deis/commit/639e80cf21a6771539e9d10e085e3d62a5143ed1) pushing new structure for sphinx nav (@gabrtv)
- [7fd6f14](https://github.com/deis/deis/commit/7fd6f141a5e2ae3989686a0b1508aac24cba9cc0) add comprehensive client reference, cleanup toctrees re #47 (@gabrtv)
- [cac60eb](https://github.com/deis/deis/commit/cac60eb4431e30a9745f4fbc4bcfdd2238cb6856) first pass at technical overview, include terms in toctree #62 (@gabrtv)
- [93d45fc](https://github.com/deis/deis/commit/93d45fcdd544fa68e03e4e3e53ed9779e6847205) Updated: the jQuery that sets the height of the 3 columns, and how the margin above teh social buttons is calculated (@bengrunfeld)
- [d47b85d](https://github.com/deis/deis/commit/d47b85de5b55f1d491022ecc8bdda3188b76179b) Added accordion functionality to docs sidebar. Updated style of search box. Updated jQuery page height calculation. (@bengrunfeld)
- [3f066ee](https://github.com/deis/deis/commit/3f066eef02668ff36b847a87e0cbdea62e42f1ed) fix seo on main documentation page (@gabrtv)
- [4caf32c](https://github.com/deis/deis/commit/4caf32cd10c26a09dcc1bcadee8b7e9a2f5ac079) rename technical overview to concepts (@gabrtv)
- [bec19a0](https://github.com/deis/deis/commit/bec19a0bc88b20acd4b18254c56204fa7b874ac3) Added the search results template to deis theme. (@mboersma)
- [65d8b99](https://github.com/deis/deis/commit/65d8b9922de74583fc5bfd5e126d86cce377a77a) Started dev setup and code standards docs, re #2. (@mboersma)
- [25e9cc2](https://github.com/deis/deis/commit/25e9cc25fbf10dbddb3e22738bbac75a893d752d) update concepts language, welcome page language (@gabrtv)
- [9eed2bf](https://github.com/deis/deis/commit/9eed2bf4a30baf81e80d142c05f9283b988f493c) Fixed #2 -- added "contributing" documentation. (@mboersma)
- [ae296bd](https://github.com/deis/deis/commit/ae296bd3a595e26a33a8b1732cf5f552077e13e0) standardize on uppercase for contributing docs (@gabrtv)
- [e0270a2](https://github.com/deis/deis/commit/e0270a2e2c03b9b01e4f8adf8de8db782d4ed9de) fix some typos and broken links on concepts page (@gabrtv)
- [6d8f971](https://github.com/deis/deis/commit/6d8f971a67a1f97cc8dfad6c38a964ec570e8816) add technical description to welcome page (@gabrtv)
- [117b6d2](https://github.com/deis/deis/commit/117b6d2d0d182eca5d8a6d7a0ee4d4822be8e765) update client readme.rst with updated language (@gabrtv)
- [8743735](https://github.com/deis/deis/commit/8743735aec9f955231c0e99153028cfb2af1247f) add getting started instructions, remove CRs fixes #45 (@gabrtv)
- [e7ab6d6](https://github.com/deis/deis/commit/e7ab6d6ba6cc231abef2423dc630541d862efcd4) Started dev setup documentation, re #1. (@mboersma)
- [7c43037](https://github.com/deis/deis/commit/7c43037c181882471db6e35ea3814df984523ef6) add better client description (@gabrtv)
- [a1cc87c](https://github.com/deis/deis/commit/a1cc87c6293741bfd77268467337d0f790092231) edits to readme (@gabrtv)
- [08bc8e1](https://github.com/deis/deis/commit/08bc8e17ab8135ee7fb6d0e8474030666d16ecb0) Updated README.md with some github-flavored markdown (@mboersma)
- [b778f81](https://github.com/deis/deis/commit/b778f81b4ad222667f3705f3e1510e64f2cab70d) Updated jQuery URL-matching functionality to sidebar (@bengrunfeld)
- [cbe5145](https://github.com/deis/deis/commit/cbe51452ecce807aa1fdb56707061d699a61ae29) Updated docs layout. Removed old code. (@bengrunfeld)
- [a4ffa1f](https://github.com/deis/deis/commit/a4ffa1f373bd78f8da0cfe234108bd4143ca1cda) Added the installation doc, from the project README. (@mboersma)
- [d29c97a](https://github.com/deis/deis/commit/d29c97a57fe3ca73ee08db8e4f614867f5106382) Add ref to Installation from Usage doc. (@mboersma)
- [e91f40d](https://github.com/deis/deis/commit/e91f40db9adee8dca5e0189d84c4c485537b3791) Created new favicon and applied it to docs and theme (@bengrunfeld)
- [5b4f5bc](https://github.com/deis/deis/commit/5b4f5bcf589601003b39cebc5e4855f7256e8a0d) Reference the Installation doc in Developer Setup. (@mboersma)
- [a6a4aa1](https://github.com/deis/deis/commit/a6a4aa11909b6370a9eecef30202c2fbf683321a) Fixed link to example app and fixed some inline <pre> markup. (@mboersma)
- [5df9616](https://github.com/deis/deis/commit/5df96161edd366589209cba4f23b8515c90e5b6c) add note about publishing amis (@gabrtv)
- [a39574f](https://github.com/deis/deis/commit/a39574f82a0c8eee044d54cc32a52d8e32c65549) first pass at terms documentation (@gabrtv)
- [5b72fe8](https://github.com/deis/deis/commit/5b72fe879c4e413fdf24b3b8b2edfba8bcb6afce) Added module docstrings for the proto-web app. (@mboersma)
- [29a751c](https://github.com/deis/deis/commit/29a751c3326ae310a15801c88aa6be8fd2c68950) Skip 0-length files and use Deis' CSS in coverage report. (@mboersma)
- [8d4fba5](https://github.com/deis/deis/commit/8d4fba567de967b31e2498146ae5eff3ca71d89b) Commented out empty web test. (@mboersma)
- [0d8474a](https://github.com/deis/deis/commit/0d8474a43ac6086795378081b402a3c3d9e1fb97) Updated boto, django-celery, and paramiko. (@mboersma)
- [42bf7ef](https://github.com/deis/deis/commit/42bf7ef6ff299f7a551bcb447166d4e4b368479f) remove dupe content from docs welcome page (@gabrtv)
- [f9107e3](https://github.com/deis/deis/commit/f9107e32a3eb316f9257c0b630f8f897abde38d4) add note about admins group requirement re #53 (@gabrtv)
- [bd67434](https://github.com/deis/deis/commit/bd6743448e0395b1f2ecc046f05abce02942ba5d) update installation docs w/ chef admin requirement re #53 (@gabrtv)
- [285588c](https://github.com/deis/deis/commit/285588ce626aaea57bf3572bc0ab3de5e075c298) Updated version to 0.0.5. (@mboersma)
- [266fa79](https://github.com/deis/deis/commit/266fa79dfb6726cd9c48aa89c0521167a456c2a4) Removed a swapfile dropping and updated docs Makefile. (@mboersma)
- [868d037](https://github.com/deis/deis/commit/868d0378c29a713e9a29f31275088b96ee6d5437) update Berksfile to use new v0.0.5 cookbook (@gabrtv)

### v0.0.4 (2013/07/30 15:32 +00:00)
- [0462cef](https://github.com/deis/deis/commit/0462cef5812ce31fe12f25596ff68dc614c708af) Initial commit (@mboersma)
- [40bf6f6](https://github.com/deis/deis/commit/40bf6f64ddb2d9dbe7acbd4fd528c8087d9bbca0) Merged three projects into one. (@mboersma)
- [918a18f](https://github.com/deis/deis/commit/918a18f1da8aa834ab0930cd46b572e11b25864a) Updated README.md for current deis product blurb. (@mboersma)
- [3ac0199](https://github.com/deis/deis/commit/3ac0199a689869cc34e63d5581ac40b4d5a03968) Add missing bin/ dirs and remove bin from .gitignore. (@mboersma)
- [9413a72](https://github.com/deis/deis/commit/9413a721d4ba583ef5fe2086a18d41d2567d32d6) Updated git checkout path for controller. (@mboersma)
- [1976aa6](https://github.com/deis/deis/commit/1976aa61c38c133ea4b74cc7c5fcd8616cf95ea1) More project structure maneuvering. (@mboersma)
- [d9285ce](https://github.com/deis/deis/commit/d9285ceb14b2cf1c6a76d4aacc1619c8a7de551b) change contrib script name (@gabrtv)
- [98b14f0](https://github.com/deis/deis/commit/98b14f0209431177e3505eb0c853e5e207d84c16) add Gemfile and Berksfile for Chef dependency management (@gabrtv)
- [2739380](https://github.com/deis/deis/commit/27393800efe41283cc7baa6a7c1d4a3a8aa6d4b8) add helper script for provisioning an ec2 controller (@gabrtv)
- [9b321f8](https://github.com/deis/deis/commit/9b321f8993e4318c780f7f0fb76acd7db93c3b03) ignore rbenv version (@gabrtv)
- [aa2b715](https://github.com/deis/deis/commit/aa2b715b6ef6ec9aef6afa2a021cf90ecf581ad4) remove pydevd from master (@gabrtv)
- [60814b9](https://github.com/deis/deis/commit/60814b90c68775d136ab82b56abc488791fa696b) Updated doc API layout. (@mboersma)
- [75f2aa2](https://github.com/deis/deis/commit/75f2aa20bb5e1bbf18876de3cf7a7a83964b6572) move auto-generated ssh keys to formation, add tests for ssh key override on formation create.  fixes #17 (@gabrtv)
- [7064132](https://github.com/deis/deis/commit/70641325c66dacc29cefdde0059b7a8da2561eea) Added config file for Travis CI. (@mboersma)
- [7392f83](https://github.com/deis/deis/commit/7392f83ef77c311841b1620c98d3750a2dffc763) hardcode chef version to 11.4.4 as the new 11.6.0 breaks everything (@gabrtv)
- [35c3046](https://github.com/deis/deis/commit/35c304673a91111d7aacad4ea3829bbf1d793491) update berksfile to use deis 0.0.4 (@gabrtv)
- [b58281b](https://github.com/deis/deis/commit/b58281bfd3882328a6c1c14386e97246f1016f70) More testing of Travis CI configuration. (@mboersma)
- [d7c60dc](https://github.com/deis/deis/commit/d7c60dcc9204301696448ed475f73ff6c27e3662) Added DB config to .travis.yml. (@mboersma)
- [d03aff3](https://github.com/deis/deis/commit/d03aff38ab358ea65dc2cc093d1df2886deda091) Fixed #9 -- Travis-CI.org integration working. (@mboersma)
- [9328e5a](https://github.com/deis/deis/commit/9328e5abf045950c76f6995d09fc92c2c697dd5e) Restore lost line in travis config. (@mboersma)
- [dc62bf3](https://github.com/deis/deis/commit/dc62bf3b1d916e2490d9d396f84b831d0758071e) Fixed #7 -- updated README and published to pypi. (@mboersma)
- [71bd371](https://github.com/deis/deis/commit/71bd371ed16437b2343cfbbe94902c995d8dd5e2) Updated pypi package status to beta. (@mboersma)
- [4ab89bb](https://github.com/deis/deis/commit/4ab89bbc69b97177542569f1db347245e8090cba) convert deis to symlink (@gabrtv)
- [cc9f277](https://github.com/deis/deis/commit/cc9f277e0a6c80e814fa09545c06c17c6559bada) refactor CLI http dispatch re #16 (@gabrtv)
- [485df36](https://github.com/deis/deis/commit/485df366f62979d24ae109f457fd23e2b2918158) seed default providers and flavors on user registration, re #23 (@gabrtv)
- [50df654](https://github.com/deis/deis/commit/50df65488d5df45bf70fd57edb8c03ee67e55380) add `deis providers:discover` with a more explicit discovery workflow that uses default providers, fixes #23 (@gabrtv)
- [1536176](https://github.com/deis/deis/commit/1536176f0a0aaec8aa8b38ce1cad675026652ed2) Began some PEP8 / pyflakes-inspired code cleanup. (@mboersma)
- [96fecae](https://github.com/deis/deis/commit/96fecae7962241904140fabfea1bf3136e459b3f) Continued PEP8 code cleanup. (@mboersma)
- [8b3c218](https://github.com/deis/deis/commit/8b3c218c66e512f85c27ef9fd7a3aa479a96fecd) Removed two requirements that weren't actually required. (@mboersma)
- [d97714b](https://github.com/deis/deis/commit/d97714be7632e5eaeaf51ae61ff7e842c037782e) Testing pre-commit flake8 hook. (@mboersma)
- [3b9d90a](https://github.com/deis/deis/commit/3b9d90ad024299fab31aafcd8a8c561b2bd0f2ef) Replaced pep8 and pyflakes targets with flake8. (@mboersma)
- [ba5119b](https://github.com/deis/deis/commit/ba5119be6962948d86d93a806f40cff7bf1923ec) Refs #6, flake8 code cleanup nearly done. (@mboersma)
- [0c89448](https://github.com/deis/deis/commit/0c894485bdfde4516e9950d17273c95d185b3d93) first pass at layer refactoring, with passing test suite (@gabrtv)
- [1206fe6](https://github.com/deis/deis/commit/1206fe67850c1ceaa196e2279d0721fa9f1581c5) remove south for now (@gabrtv)
- [14aa7e4](https://github.com/deis/deis/commit/14aa7e4debdc578c072279a01a6f2566e9e67942) use layer to define run_list and initial attributes (@gabrtv)
- [30e40b9](https://github.com/deis/deis/commit/30e40b9fdade14a1827c1aade514c57012f3c3a2) Refs #10 -- set up travis-ci.org and coveralls.io integration. (@mboersma)
- [c516468](https://github.com/deis/deis/commit/c516468704d381bd880d00ce809d62de80806577) move key functions, remove image from formation required args (@gabrtv)
- [e4da21b](https://github.com/deis/deis/commit/e4da21b26f814c0a5716103f9f1f381fe8ce716d) Revert azure to required, apparently travis CI thinks so. (@mboersma)
- [3e7ab6e](https://github.com/deis/deis/commit/3e7ab6efec8de8389f10f94b59b2c54656802f85) Fixed typo in travis after_success hook. (@mboersma)
- [5d78fb8](https://github.com/deis/deis/commit/5d78fb89838d019c1fa2629d6d328cd55f0c37ef) move default cloud init into FlavorManager (@gabrtv)
- [e421b30](https://github.com/deis/deis/commit/e421b300f1c0f75b0b6ebda7ad6fd487e47752bb) move initial_attributes into layer (@gabrtv)
- [d6ee9e9](https://github.com/deis/deis/commit/d6ee9e92ed7a19332f47fa8aae6a70da304f830e) number nodes by layer (@gabrtv)
- [bc03426](https://github.com/deis/deis/commit/bc0342674ed71b5c507728b41b7eeb080c7ac724) Filter out travis' virtualenv from coverage report. (@mboersma)
- [9bb3638](https://github.com/deis/deis/commit/9bb3638d949ce1623991c98687e119f48d8de397) add run_list and initial_attributes conditionally (@gabrtv)
- [f78a533](https://github.com/deis/deis/commit/f78a53335c394dbefc17454c0e433f637df35df3) replace formation scaling with layer & container scaling (@gabrtv)
- [b11c9f0](https://github.com/deis/deis/commit/b11c9f0fcb0a7c2f037d604afe0c2763e47acbf2) move cloud infrastructure fields from formation to layer (@gabrtv)
- [483b4d2](https://github.com/deis/deis/commit/483b4d250bb240bf2e5af7f087e4491594bc867f) include formation name in layer infrastructure (@gabrtv)
- [4a9ed1a](https://github.com/deis/deis/commit/4a9ed1af18fcd8be18d29e72a02c92dc1906741b) destroy layer infrastructure on DELETE (@gabrtv)
- [a09d60e](https://github.com/deis/deis/commit/a09d60e7d8682c4f0d3a35843d67daca3ae474dd) switch to get_object_or_404 on layer views (@gabrtv)
- [959c79c](https://github.com/deis/deis/commit/959c79c55ee27079407dd92341b40276441863d9) only apply jobs if defined (@gabrtv)
- [2cfa340](https://github.com/deis/deis/commit/2cfa3404e6005067c0f51e646618703498a4b41d) new batching logic for formation/layer destroy (@gabrtv)
- [5aed1ee](https://github.com/deis/deis/commit/5aed1ee57e3c020582c5f01b89fe76b36056a0d5) add layers:destroy, change layers:create args (@gabrtv)
- [c5638fd](https://github.com/deis/deis/commit/c5638fdb6865f8896a261c0f578a93a754d1da0b) change register url to match other auth urls (@gabrtv)
- [e115621](https://github.com/deis/deis/commit/e115621541e62433cba07a628f389553d93e71e6) remove commented line (@gabrtv)
- [3542969](https://github.com/deis/deis/commit/3542969f3fbd641349ffb2e50b153be94c1e0299) fix sg_name bug (@gabrtv)
- [fcbf263](https://github.com/deis/deis/commit/fcbf263ae0d3849e854ba57bc9a0ec4bf823c3e6) add node deletion (@gabrtv)
- [8908fd5](https://github.com/deis/deis/commit/8908fd5a72554a18172e6aba7386fba1b31bc6ad) Moved docopt to requirements.txt and updated client/Makefile. (@mboersma)
- [56f7ad1](https://github.com/deis/deis/commit/56f7ad1628c5ff788c7c67258b94bf29db69ab1d) create a list of csv run_list field (@gabrtv)
- [2a14dc7](https://github.com/deis/deis/commit/2a14dc7f80942226176a4b56b6fa1190f474b56d) Added requirements to setup.py for client. (@mboersma)
- [01df37f](https://github.com/deis/deis/commit/01df37fe52afd1d76e23c085a2384378190bd9d0) remove sleeps from node tests, test for databag on layer:scale operations (@gabrtv)
- [8f582f5](https://github.com/deis/deis/commit/8f582f5acf20a3af8233263f569d6f2659b0e74e) add chef version to layer (@gabrtv)
- [8ae3d22](https://github.com/deis/deis/commit/8ae3d22e6ba77ce71af3502f64518fefa8e57600) add Layer.level for future batching of node converges (@gabrtv)
- [5c285d0](https://github.com/deis/deis/commit/5c285d0e83a27cba267400978ccd6671471addf9) remove default build URL, allow null builds by default (@gabrtv)
- [f60c9e4](https://github.com/deis/deis/commit/f60c9e4af71eecb4930b90d9bfb54665a919dc2e) limit to just gitosis recipe on formation destroy (to assist with debugging) (@gabrtv)
- [bbfad86](https://github.com/deis/deis/commit/bbfad86fbbe9ca179b7b78dbe2bb167d180016a3) add formation info and node destroy (@gabrtv)
- [d83c2c0](https://github.com/deis/deis/commit/d83c2c040f67aac5fb663ada645f72a31426ed6f) change print on layer:create (@gabrtv)
- [663dc88](https://github.com/deis/deis/commit/663dc888cb627d824ab5dfa485045cc6f6623d96) fix bug with change flag in scale_containers (@gabrtv)
- [5b177f9](https://github.com/deis/deis/commit/5b177f900912c0375345de5f11419e9492dedc24) fix bug in layer scaling (@gabrtv)
- [c672ec4](https://github.com/deis/deis/commit/c672ec4d4984117729ee8eb827dd17e32e14f405) purge backends/proxies references from client (@gabrtv)
- [0187064](https://github.com/deis/deis/commit/01870643b780f0b2250f6149d08e918cfb0d9281) merging layout changes with current master re #34 (@gabrtv)
- [7b86a7c](https://github.com/deis/deis/commit/7b86a7cfe291006622ea33a90ed4466b0fb194eb) reset south migrations and fix some uniqueness contraints #34 (@gabrtv)
- [ea8e7ba](https://github.com/deis/deis/commit/ea8e7bac112d40f9b6ea1849125592a26dee8b47) fix client merge conflicts (@gabrtv)
- [10d1429](https://github.com/deis/deis/commit/10d1429605b8d9ea961e338dd01de645343ac58b) re-enable south, note this requires a db wipe (@gabrtv)
- [9e07a52](https://github.com/deis/deis/commit/9e07a52a5e25d059660976bc502dd0c86d848346) Build.push classmethod for handling git-push through gitosis #35 (@gabrtv)
- [519969b](https://github.com/deis/deis/commit/519969b81107e174805f561b6c89e4676cd4b2ab) rename to push-hook #35 (@gabrtv)
- [ce3430a](https://github.com/deis/deis/commit/ce3430a2a4943beeaa6a9b5d676e1937bd36df26) remove build version so push-hook doesn't have to increment it re #35 (@gabrtv)
- [4b75903](https://github.com/deis/deis/commit/4b75903384afe756072067f96d4470763166b627) catch layer does not exist error (@gabrtv)
- [b636f0d](https://github.com/deis/deis/commit/b636f0d9e0a5301f06d2434556fd24955c8c7ad1) make layer:destroy message consistent (@gabrtv)
- [e0b3724](https://github.com/deis/deis/commit/e0b3724d3ea0c9af45be4a1aed0a3c3bbac6bc07) deprecate Access and Event models, we'll reintroduce what we need later #37 (@gabrtv)
- [8efb373](https://github.com/deis/deis/commit/8efb3734606cf263fc5f125d13ad70b980055e04) purge cruft from django settings #37 (@gabrtv)
- [5b5bb71](https://github.com/deis/deis/commit/5b5bb71e1d257d70e702912ffee53999917472af) purge admin module, we'll re-enable it when we get to #38 (@gabrtv)
- [9890f0e](https://github.com/deis/deis/commit/9890f0eda97ef55719ea6e8e34895aa8a240a6f4) db migration for removing access and event models #37 (@gabrtv)
- [3370ecf](https://github.com/deis/deis/commit/3370ecf52746f693af429e6fceb925d6f4ea1f84) remove admin urls #37 (@gabrtv)
- [4f94e80](https://github.com/deis/deis/commit/4f94e80789766986e2152384ea45306976cbc86e) only save updates to formation.layers and formation.containers after successful scale operations #34 (@gabrtv)
- [0db163e](https://github.com/deis/deis/commit/0db163e6c39f0b6bcdfaac5fd0141263edbe0fc9) fix config api endpoints #16 (@gabrtv)
- [41718ff](https://github.com/deis/deis/commit/41718ffbea367b3735ef1048b5d248ece1545239) moar readme (@gabrtv)
- [8d9ec4e](https://github.com/deis/deis/commit/8d9ec4e7aed4b177ec0729b185046d5d0189b502) another round of readme updates (@gabrtv)
- [8db1ff1](https://github.com/deis/deis/commit/8db1ff1c66849bc7ab5cc77c61d2fadf674265d6) add deis-graphic (@gabrtv)
- [e6e7ff4](https://github.com/deis/deis/commit/e6e7ff4c8f496b252264647387968953cef75fb0) Updated sphinx docs layout. (@mboersma)
- [e938d57](https://github.com/deis/deis/commit/e938d57305a263a2a6c3dcad111ed89494bcf6b7) Moved "docs" target to default. (@mboersma)
- [e1c1d19](https://github.com/deis/deis/commit/e1c1d1922800a0cbe0e884d3b3b30db6d7ec1000) Added some "terms" pages to define basic Deis concepts. (@mboersma)
- [b4d32dc](https://github.com/deis/deis/commit/b4d32dc61023b34e93fb1aa6a474b83ed06bfb36) Added sphinx :ref: tags to docs. (@mboersma)
- [45d327a](https://github.com/deis/deis/commit/45d327a1a34a058908aa5bba475be9a9f047e83b) Added a sphinx theme. (@mboersma)
- [b5d515d](https://github.com/deis/deis/commit/b5d515d76431de906f86089956594a3e5a03abfc) add default run_lists to layers:create (@gabrtv)
- [4dabce9](https://github.com/deis/deis/commit/4dabce99e68116fee76e8515e47bfaa112267827) add data bag creation to provisioning (@gabrtv)
- [17409a3](https://github.com/deis/deis/commit/17409a3f958ab4821d538efae8ee4936478d735a) add provider discovery on registration #16 (@gabrtv)
- [a5d07cd](https://github.com/deis/deis/commit/a5d07cd92c400d7ac1375dec88ab70e6c0004749) create data bags and data bag items on provision (@gabrtv)
- [93c10b7](https://github.com/deis/deis/commit/93c10b75f21f1aeed2027cf2eb1754af338ec15b) update berksfile lock (@gabrtv)
- [c014426](https://github.com/deis/deis/commit/c014426bf5a2c77b4fef5a1eb3d7bb7826e03fe2) move docopt usage into docstrings and cleanup CLI dispatch re #11 #16 (@gabrtv)
- [2d5823e](https://github.com/deis/deis/commit/2d5823e25b701e001b653cf439ba1214231f542e) fix ugly git remote not found stacktrace, misc cleanup #16 (@gabrtv)
- [cb9906d](https://github.com/deis/deis/commit/cb9906da70e7ccc018e8f1a3adf713b3b52d56a3) cleanup create, scale, destroy workflow and output #16 (@gabrtv)
- [c57ae23](https://github.com/deis/deis/commit/c57ae236fa028b6fd1fd9f507010fbdd14b124d0) Refs #41 -- add client to INSTALLED_APPS, "make flake8" code cleanup. (@mboersma)
- [b04f295](https://github.com/deis/deis/commit/b04f2955b90c59fbce4d6aabccee829e34eefbb8) Added sphinx to travis ci configuration. (@mboersma)
- [02f6fad](https://github.com/deis/deis/commit/02f6fad9b2032c53311da7319e81b8fe920c5938) Fixed #41 -- repackaged client as a single-file install. (@mboersma)
- [b1f8911](https://github.com/deis/deis/commit/b1f8911fb1ea33c841ba89cb193ff920af204f5c) create one initial web container on Build.push, only if there exists a runtime layer and web containers are < 1 fixes #42 (@gabrtv)
- [914bb99](https://github.com/deis/deis/commit/914bb998f0dcc0444122d1ff0c9e079d990cf855) first pass at heroku-style container listing #16 (@gabrtv)
- [c5de935](https://github.com/deis/deis/commit/c5de935125e5dea195f6b3053dd3a6786659a2ae) resolve merge conflict on client (@gabrtv)
- [3f373db](https://github.com/deis/deis/commit/3f373db43ff4ca45a93f193c135e6a435f63a6ae) change default image to deis/buildstep #43 (@gabrtv)
- [0abdacf](https://github.com/deis/deis/commit/0abdacfb50bc67c2318971c03f99898a91c68321) order containers oldest first for CLI output #16 (@gabrtv)
- [f8a2ac1](https://github.com/deis/deis/commit/f8a2ac1fc59d03584ff1568c3bde5cffb65b9263) we need to check for > 0 runtime _nodes_, not just a runtime layer #42 (@gabrtv)
- [c7fdf8c](https://github.com/deis/deis/commit/c7fdf8c2d989ddde3dfd0df144a2df38b0a1d25d) add status fields on node/container with TODOs for adding celery beat health checks (@gabrtv)
- [de7f3fd](https://github.com/deis/deis/commit/de7f3fd66a3bd807ef172e9a7ab4040d42e89eaf) workaround for ec2 race condition (@gabrtv)
- [c3e907c](https://github.com/deis/deis/commit/c3e907cfcc6686a7713a98daba59d6d460f961a7) change managed to created, since we're not actively managing the sg and we don't want to scare admins away from locking it down (@gabrtv)
- [af4b082](https://github.com/deis/deis/commit/af4b082a58beeda8c9b13e69e9d9af814a4d5770) add subcommand help dispatch, with placeholder help for now #16 (@gabrtv)
- [eb9ad86](https://github.com/deis/deis/commit/eb9ad8658eab6ebb92497ad6cb180a5c0ba7755a) ignore node does not exist errors in the event of unclean destroy (@gabrtv)
- [45c7d00](https://github.com/deis/deis/commit/45c7d004e4744d6ea27480c9e577f735cabcd6b0) change default instance size to m1.medium (@gabrtv)
- [ed9e3a9](https://github.com/deis/deis/commit/ed9e3a9fbd5b75b4bcfaeb8ad4212674dc9c0b92) add script and instructions building Deis-optimized AMI from scratch #21 (@gabrtv)
- [ea234b5](https://github.com/deis/deis/commit/ea234b59b2de8a66093ca9cd8eb830208e6e6d29) add script to distribute AMIs across regions #21 (@gabrtv)
- [b5dda35](https://github.com/deis/deis/commit/b5dda35fdaff371f52642ce926a511419b05c642) deprecate old script (@gabrtv)
- [a61da77](https://github.com/deis/deis/commit/a61da77873dc4cce16598ca14a21513f75c2dd34) switch ec2 to new deis-optimized AMIs #21 (@gabrtv)
- [8990667](https://github.com/deis/deis/commit/8990667d55f696ee84b59181c73b6c7137954a6e) add deis-optimized amis to provision-ec2-controller script #21 (@gabrtv)
- [2079616](https://github.com/deis/deis/commit/2079616ae4bfe0bb9936155292748e56c5a17d34) minor cleanup on provision controller script (@gabrtv)
- [5d2f6a7](https://github.com/deis/deis/commit/5d2f6a7031a421ad6eff55cb1e8a97939db90d6c) check for git root before creating formation, provide better workflow guidance #16 (@gabrtv)
- [129445b](https://github.com/deis/deis/commit/129445b560e3cb099e312bcf45f573c480a4900c) cleanup formation/layer/node destroy batching (@gabrtv)
- [7d52dec](https://github.com/deis/deis/commit/7d52dec623504a382145d060c93621fcde168b69) check for no creds on layer:scale, with tests (@gabrtv)
- [08ae187](https://github.com/deis/deis/commit/08ae187fcffbcd96cc94a19c8962a3d273fb3911) only delete records from the view, fix chef_id issue (@gabrtv)
- [67c6cf3](https://github.com/deis/deis/commit/67c6cf3ce8fef854e5095eef43e21ec95eb8f4df) rework subtask batching again (@gabrtv)
- [ccd60e2](https://github.com/deis/deis/commit/ccd60e20780d32aeb5ee038598141e3adff5154c) remove unnecessary celery grouping (@gabrtv)
- [5ce8a38](https://github.com/deis/deis/commit/5ce8a38a6b2f52cc4fd719403f15c0b7c656c932) only terminate node if provider_id exists (@gabrtv)
- [6704c28](https://github.com/deis/deis/commit/6704c2805c3915b3134a369ca0ac79196b0dc944) add formation_id to args (@gabrtv)
- [31fe7f6](https://github.com/deis/deis/commit/31fe7f6ed044fc2cbce6f07739f520d85aa30449) change task invocation style (@gabrtv)
- [f79aac9](https://github.com/deis/deis/commit/f79aac9d5d4a2c5edc29ec018fa050570f0ddfda) Code cleanup via flake8. (@mboersma)
- [48fc8d1](https://github.com/deis/deis/commit/48fc8d17686f72a90746f92d4baf17c16b5a9c12) add docstrings, make `deis help <anything>` dispatch correctly #16 (@gabrtv)
- [73a1d37](https://github.com/deis/deis/commit/73a1d375191d33ae582b1b1a76f0bf6b4679462d) move parse_args() out of main, other flake8 fixes #16 (@gabrtv)
- [9a04b32](https://github.com/deis/deis/commit/9a04b32cc62b4591a0c24f5f963955d074cd0dab) resolve remaining flake8 issues (@gabrtv)
- [64deec5](https://github.com/deis/deis/commit/64deec5d3bead26d9f1fb3ec1281527717c7b14b) allow listing of builds/releases (@gabrtv)
- [6f01b25](https://github.com/deis/deis/commit/6f01b25d8061dc077ab306f41a4c797bad8a80b2) Enforce flake8 checking on travis CI. (@mboersma)
- [696b897](https://github.com/deis/deis/commit/696b8971f39b63b26d74e267ee22c30b2386032a) Updated API docs structure. (@mboersma)
- [33ddab6](https://github.com/deis/deis/commit/33ddab681c513c90aa0d3b3a25891ef878d50a2c) Remove unused "./manage.py client" command. (@mboersma)
- [ef89938](https://github.com/deis/deis/commit/ef8993858ff6923d3b31595bd79907bb4fdcc045) Added a few docstrings, refs #11. (@mboersma)
- [56d0d30](https://github.com/deis/deis/commit/56d0d30f8105d96d0331d21074d4feb65515d9e8) finish adding docstrings and inline help to cli, add support for enumerating releases/builds #16 (@gabrtv)
- [13f5128](https://github.com/deis/deis/commit/13f512881382bdfb623a5d186f237eced3c6cfae) more cli inline help edits (@gabrtv)
- [2fb15e6](https://github.com/deis/deis/commit/2fb15e6c1d332b7b75bff641bee2f25757f8b6dd) remove old readme (@gabrtv)
- [3797daf](https://github.com/deis/deis/commit/3797daf9a7778c795c9618fb62b457ed03151fa9) Refs #11 -- more docstring improvement. (@mboersma)
- [001e9d6](https://github.com/deis/deis/commit/001e9d6616cb5293c02d3c4487dd4a7197588da4) Re #11 -- more docstring progress (@mboersma)
- [578c032](https://github.com/deis/deis/commit/578c032d48b7260ddc9272e10a5620c32b3c73b6) Removed pydevd debug.py file from master branch. (@mboersma)
- [4ebd123](https://github.com/deis/deis/commit/4ebd123a1c37c539ea3e8a1909d4e5b422d8441c) standardize list and info cli output (@gabrtv)
- [abbc10a](https://github.com/deis/deis/commit/abbc10a2a0b6006353cc467cb87813293713c7df) fix flake8 line length (@gabrtv)
- [8834b94](https://github.com/deis/deis/commit/8834b946a99a40828a5e6ef01d06adab67e17e22) check for valid flavor on formations:create, add time-based done output #16 (@gabrtv)
- [72b8345](https://github.com/deis/deis/commit/72b8345ac6557a2c4707208a13a2c407478f740b) update in prep for 0.0.4 release (@gabrtv)
